/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.function.BiPredicate;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.Counter;

public class CounterConditionalClassVisitor
implements ClassVisitor {
    private final BiPredicate<Integer, Integer> predicate;
    private final Counter counter;
    private final ClassVisitor classVisitor1;
    private final ClassVisitor classVisitor2;

    public CounterConditionalClassVisitor(Counter counter, BiPredicate<Integer, Integer> predicate, ClassVisitor classVisitor1, ClassVisitor classVisitor2) {
        this.counter = counter;
        this.classVisitor1 = classVisitor1;
        this.classVisitor2 = classVisitor2;
        this.predicate = predicate;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        int count = this.counter.getCount();
        clazz.accept(this.classVisitor1);
        if (this.predicate.test(count, this.counter.getCount())) {
            clazz.accept(this.classVisitor2);
        }
    }

    public static boolean hasIncreased(int before, int after) {
        return before < after;
    }

    public static boolean isSame(int before, int after) {
        return before == after;
    }
}

