/////////////////////////////////////////////////////////////////////////////
// Name:        printoptions.cpp
// Purpose:     
// Author:      Brett Bode
// Modified by: 
// Created:     Tue 16 May 11:20:20 2006
// RCS-ID:      
// Copyright:   (c) 2006 Iowa State University
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), Tue 16 May 11:20:20 2006

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "printoptions.h"
#endif
#include "Globals.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "MolDisplayWin.h"
#include "Prefs.h"

#include "printoptions.h"

////@begin XPM images
////@end XPM images

/*!
 * PrintOptions type definition
 */

IMPLEMENT_DYNAMIC_CLASS( PrintOptions, wxDialog )

/*!
 * PrintOptions event table definition
 */

BEGIN_EVENT_TABLE( PrintOptions, wxDialog )

////@begin PrintOptions event table entries
    EVT_BUTTON( wxID_OK, PrintOptions::OnOkClick )

////@end PrintOptions event table entries

END_EVENT_TABLE()

/*!
 * PrintOptions constructors
 */

PrintOptions::PrintOptions( )
{
}

PrintOptions::PrintOptions( MolDisplayWin* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    Create(parent, id, caption, pos, size, style);
}

/*!
 * PrintOptions creator
 */

bool PrintOptions::Create( MolDisplayWin* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin PrintOptions member initialisation
    FrameCheck = NULL;
    CenterCheck = NULL;
    MaxCheck = NULL;
////@end PrintOptions member initialisation
	Parent = parent;

////@begin PrintOptions creation
    SetExtraStyle(GetExtraStyle()|wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    GetSizer()->Fit(this);
    GetSizer()->SetSizeHints(this);
    Centre();
////@end PrintOptions creation
    return true;
}

/*!
 * Control creation for PrintOptions
 */

void PrintOptions::CreateControls()
{    
////@begin PrintOptions content construction
    // Generated by DialogBlocks, Tue 16 May 11:25:57 2006 (unregistered)

    PrintOptions* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    FrameCheck = new wxCheckBox( itemDialog1, ID_CHECKBOX, _("Add a frame bordering the image"), wxDefaultPosition, wxDefaultSize, 0 );
    FrameCheck->SetValue(false);
    itemBoxSizer2->Add(FrameCheck, 0, wxALIGN_LEFT|wxALL, 5);

    CenterCheck = new wxCheckBox( itemDialog1, ID_CHECKBOX1, _("Center image on Page"), wxDefaultPosition, wxDefaultSize, 0 );
    CenterCheck->SetValue(false);
    itemBoxSizer2->Add(CenterCheck, 0, wxALIGN_LEFT|wxALL, 5);

    MaxCheck = new wxCheckBox( itemDialog1, ID_CHECKBOX2, _("Maximize image on page"), wxDefaultPosition, wxDefaultSize, 0 );
    MaxCheck->SetValue(false);
    itemBoxSizer2->Add(MaxCheck, 0, wxALIGN_LEFT|wxALL, 5);

    wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer6, 0, wxALIGN_RIGHT|wxALL, 5);

    wxButton* itemButton7 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer6->Add(itemButton7, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton8 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer6->Add(itemButton8, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end PrintOptions content construction
	WinPrefs * prefs = Parent->GetPrefs();
    FrameCheck->SetValue(prefs->GetFramePage());
    CenterCheck->SetValue(prefs->GetCenterOnPage());
    MaxCheck->SetValue(prefs->GetFitToPage());
}

/*!
 * Should we show tooltips?
 */

bool PrintOptions::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap PrintOptions::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin PrintOptions bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end PrintOptions bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon PrintOptions::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin PrintOptions icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end PrintOptions icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void PrintOptions::OnOkClick( wxCommandEvent& event )
{
	WinPrefs * prefs = Parent->GetPrefs();
	prefs->SetFramePage(FrameCheck->IsChecked());
	prefs->SetCenterOnPage(CenterCheck->IsChecked());
	prefs->SetFitToPage(MaxCheck->IsChecked());

    event.Skip();
}


