/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.util.LazyList;

public class HashSessionManager
extends AbstractSessionManager {
    private Timer _timer;
    private TimerTask _task;
    private int _scavengePeriodMs = 30000;
    protected Map _sessions;

    public void doStart() throws Exception {
        this._sessions = new HashMap();
        super.doStart();
        this._timer = new Timer();
        this.setScavengePeriod(this.getScavengePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        super.doStop();
        this._sessions.clear();
        this._sessions = null;
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._task != null) {
                this._task.cancel();
            }
            if (this._timer != null) {
                this._timer.cancel();
            }
            this._timer = null;
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public void setMaxInactiveInterval(int seconds) {
        super.setMaxInactiveInterval(seconds);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        this._scavengePeriodMs = period;
        if (this._timer != null && (period != old_period || this._task == null)) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    public void run() {
                        HashSessionManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengePeriodMs, (long)this._scavengePeriodMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            Object stale = null;
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    Session session = (Session)i.next();
                    long idleTime = session._maxIdleMs;
                    if (idleTime <= 0L || session._accessed + idleTime >= now) continue;
                    stale = LazyList.add(stale, session);
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                Session session = (Session)LazyList.get(stale, i);
                long idleTime = session._maxIdleMs;
                if (idleTime <= 0L || session._accessed + idleTime >= System.currentTimeMillis()) continue;
                session.timeout();
                int nbsess = this._sessions.size();
                if (nbsess >= this._minSessions) continue;
                this._minSessions = nbsess;
            }
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected void addSession(AbstractSessionManager.Session session) {
        this._sessions.put(session.getClusterId(), session);
    }

    public AbstractSessionManager.Session getSession(String idInCluster) {
        return (Session)this._sessions.get(idInCluster);
    }

    protected void invalidateSessions() {
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = sessions.iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        this._sessions.clear();
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new Session(request);
    }

    protected void removeSession(String clusterId) {
        this._sessions.remove(clusterId);
    }

    protected class Session
    extends AbstractSessionManager.Session {
        private static final long serialVersionUID = -2134521374206116367L;

        protected Session(HttpServletRequest request) {
            super(request);
        }

        public void setMaxInactiveInterval(int secs) {
            super.setMaxInactiveInterval(secs);
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)HashSessionManager.this._scavengePeriodMs) {
                HashSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        protected Map newAttributeMap() {
            return new HashMap(3);
        }
    }
}

