'use client';
import { jsxs, jsx } from 'react/jsx-runtime';
import { useRef } from 'react';
import { useMergedRef } from '@mantine/hooks';
import { createScopedKeydownHandler } from '../../../core/utils/create-scoped-keydown-handler/create-scoped-keydown-handler.mjs';
import { createEventHandler } from '../../../core/utils/create-event-handler/create-event-handler.mjs';
import 'clsx';
import { parseThemeColor } from '../../../core/MantineProvider/color-functions/parse-theme-color/parse-theme-color.mjs';
import '../../../core/MantineProvider/Mantine.context.mjs';
import '../../../core/MantineProvider/default-theme.mjs';
import '../../../core/MantineProvider/MantineProvider.mjs';
import { useMantineTheme } from '../../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.mjs';
import { useProps } from '../../../core/MantineProvider/use-props/use-props.mjs';
import '../../../core/MantineProvider/MantineCssVariables/MantineCssVariables.mjs';
import '../../../core/Box/Box.mjs';
import { polymorphicFactory } from '../../../core/factory/polymorphic-factory.mjs';
import { useDirection } from '../../../core/DirectionProvider/DirectionProvider.mjs';
import '../../Accordion/Accordion.mjs';
import { AccordionChevron } from '../../Accordion/AccordionChevron.mjs';
import '../../Accordion/AccordionItem/AccordionItem.mjs';
import '../../Accordion/AccordionPanel/AccordionPanel.mjs';
import '../../Accordion/AccordionControl/AccordionControl.mjs';
import { UnstyledButton } from '../../UnstyledButton/UnstyledButton.mjs';
import { useMenuContext } from '../Menu.context.mjs';
import { useSubMenuContext } from '../MenuSub/MenuSub.context.mjs';
import classes from '../Menu.module.css.mjs';

const defaultProps = {};
const MenuSubItem = polymorphicFactory((props, ref) => {
  const {
    classNames,
    className,
    style,
    styles,
    vars,
    color,
    leftSection,
    rightSection,
    children,
    disabled,
    "data-disabled": dataDisabled,
    closeMenuOnClick,
    ...others
  } = useProps("MenuSubItem", defaultProps, props);
  const ctx = useMenuContext();
  const subCtx = useSubMenuContext();
  const theme = useMantineTheme();
  const { dir } = useDirection();
  const itemRef = useRef(null);
  const _others = others;
  const colors = color ? theme.variantColorResolver({ color, theme, variant: "light" }) : void 0;
  const parsedThemeColor = color ? parseThemeColor({ color, theme }) : null;
  const handleKeydown = createEventHandler(_others.onKeyDown, (event) => {
    if (event.key === "ArrowRight") {
      subCtx?.open();
      subCtx?.focusFirstItem();
    }
    if (event.key === "ArrowLeft" && subCtx?.parentContext) {
      subCtx.parentContext.close();
      subCtx.parentContext.focusParentItem();
    }
  });
  const handleClick = createEventHandler(_others.onClick, () => {
    if (!dataDisabled && closeMenuOnClick) {
      ctx.closeDropdownImmediately();
    }
  });
  const handleMouseEnter = createEventHandler(_others.onMouseEnter, subCtx?.open);
  const handleMouseLeave = createEventHandler(_others.onMouseLeave, subCtx?.close);
  return /* @__PURE__ */ jsxs(
    UnstyledButton,
    {
      onMouseDown: (event) => event.preventDefault(),
      ...others,
      unstyled: ctx.unstyled,
      tabIndex: ctx.menuItemTabIndex,
      ...ctx.getStyles("item", { className, style, styles, classNames }),
      ref: useMergedRef(itemRef, ref),
      role: "menuitem",
      disabled,
      "data-menu-item": true,
      "data-sub-menu-item": true,
      "data-disabled": disabled || dataDisabled || void 0,
      "data-mantine-stop-propagation": true,
      onMouseEnter: handleMouseEnter,
      onMouseLeave: handleMouseLeave,
      onClick: handleClick,
      onKeyDown: createScopedKeydownHandler({
        siblingSelector: "[data-menu-item]:not([data-disabled])",
        parentSelector: "[data-menu-dropdown]",
        activateOnFocus: false,
        loop: ctx.loop,
        dir,
        orientation: "vertical",
        onKeyDown: handleKeydown
      }),
      __vars: {
        "--menu-item-color": parsedThemeColor?.isThemeColor && parsedThemeColor?.shade === void 0 ? `var(--mantine-color-${parsedThemeColor.color}-6)` : colors?.color,
        "--menu-item-hover": colors?.hover
      },
      children: [
        leftSection && /* @__PURE__ */ jsx("div", { ...ctx.getStyles("itemSection", { styles, classNames }), "data-position": "left", children: leftSection }),
        children && /* @__PURE__ */ jsx("div", { ...ctx.getStyles("itemLabel", { styles, classNames }), children }),
        /* @__PURE__ */ jsx("div", { ...ctx.getStyles("itemSection", { styles, classNames }), "data-position": "right", children: rightSection || /* @__PURE__ */ jsx(AccordionChevron, { ...ctx.getStyles("chevron"), size: 14 }) })
      ]
    }
  );
});
MenuSubItem.classes = classes;
MenuSubItem.displayName = "@mantine/core/MenuSubItem";

export { MenuSubItem };
//# sourceMappingURL=MenuSubItem.mjs.map
