"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.styled = void 0;
const error_1 = require("../utils/error");
/**
 * ## Styled component
 *
 * Create a component that styles a JSX element which comes with built-in behavior such as `ref` and `as` prop support.
 * For further details [read the documentation](https://compiledcssinjs.com/docs/api-styled).
 *
 * ### Style with objects
 *
 * @example
 * ```
 * styled.div({
 *   fontSize: 12,
 * });
 * ```
 *
 * ### Style with template literals
 *
 * @example
 * ```
 * styled.div`
 *   font-size: 12px
 * `;
 * ```
 *
 * ### Compose styles with arrays
 *
 * @example
 * ```
 * import { css } from '@compiled/react';
 *
 * styled.div([
 *   { fontSize: 12 },
 *   css`font-size: 12px;`
 * ]);
 *
 * styled.div(
 *   { fontSize: 12 },
 *   css`font-size: 12px`
 * );
 * ```
 */
exports.styled = new Proxy({}, {
    get() {
        return () => {
            // Blow up if the transformer isn't turned on.
            // This code won't ever be executed when setup correctly.
            throw (0, error_1.createSetupError)();
        };
    },
});
//# sourceMappingURL=index.js.map