/// <reference types="react" />
import type { CssFunction } from '../types';
type WithConditionalCSSProp<TProps> = 'className' extends keyof TProps ? string extends TProps['className' & keyof TProps] ? {
    /**
     * ## CSS prop
     *
     * Style a JSX element.
     * For further details [read the API documentation](https://compiledcssinjs.com/docs/api-css-prop).
     *
     * ### Style with objects
     *
     * @example
     * ```
     * import { css } from '@compiled/react';
     *
     * <div css={css({ fontSize: 12 })} />
     * ```
     *
     * ### Style with template literals
     *
     * @example
     * ```
     * import { css } from '@compiled/react';
     *
     * <div css={css`color: red;`} />
     * ```
     *
     * ### Compose styles with arrays
     *
     * @example
     * ```
     * import { css } from '@compiled/react';
     *
     * <div
     *  css={[
     *    css({ fontSize: 12 }),
     *    css`color: red;`,
     *  ]}
     * />
     * ```
     */
    css?: CssFunction<void> | CssFunction<void>[];
} : {} : {};
type ReactJSXElementType = string | React.JSXElementConstructor<any>;
type ReactJSXElement = JSX.Element;
type ReactJSXElementClass = JSX.ElementClass;
type ReactJSXElementAttributesProperty = JSX.ElementAttributesProperty;
type ReactJSXElementChildrenAttribute = JSX.ElementChildrenAttribute;
type ReactJSXLibraryManagedAttributes<C, P> = JSX.LibraryManagedAttributes<C, P>;
type ReactJSXIntrinsicAttributes = JSX.IntrinsicAttributes;
type ReactJSXIntrinsicClassAttributes<T> = JSX.IntrinsicClassAttributes<T>;
type ReactJSXIntrinsicElements = JSX.IntrinsicElements;
export declare namespace CompiledJSX {
    type ElementType = ReactJSXElementType;
    type Element = ReactJSXElement;
    type ElementClass = ReactJSXElementClass;
    type ElementAttributesProperty = ReactJSXElementAttributesProperty;
    type ElementChildrenAttribute = ReactJSXElementChildrenAttribute;
    type LibraryManagedAttributes<C, P> = WithConditionalCSSProp<P> & ReactJSXLibraryManagedAttributes<C, P>;
    type IntrinsicAttributes = ReactJSXIntrinsicAttributes;
    type IntrinsicClassAttributes<T> = ReactJSXIntrinsicClassAttributes<T>;
    type IntrinsicElements = {
        [K in keyof ReactJSXIntrinsicElements]: Omit<ReactJSXIntrinsicElements[K], 'className'> & {
            /**
             * The class name prop now can be given the output of xcss prop from `@compiled/react`.
             */
            className?: string | Record<string, any> | null | false;
            css?: CssFunction<void> | CssFunction<void>[];
        };
    };
}
export {};
