import type tokens from '../artifacts/token-names';
import { type CSSColor, type ThemeColorModes } from '../theme-config';
type Token = keyof typeof tokens;
type TokenMap = {
    [key in Token]?: number | string;
};
type Mode = 'light' | 'dark';
export declare const getClosestColorIndex: (themeRamp: CSSColor[], brandColor: CSSColor) => number;
export declare const generateColors: (brandColor: CSSColor) => {
    ramp: CSSColor[];
    replacedColor: CSSColor;
};
export declare const generateTokenMap: (brandColor: CSSColor, mode: ThemeColorModes, themeRamp?: CSSColor[]) => {
    light?: TokenMap | undefined;
    dark?: TokenMap | undefined;
};
export declare const generateTokenMapWithContrastCheck: (brandColor: CSSColor, mode: ThemeColorModes, themeRamp?: CSSColor[]) => {
    light?: TokenMap | undefined;
    dark?: TokenMap | undefined;
};
export {};
