type Callback = () => void;
type Scheduler = {
    /**
     * Queues the provided function to be called asynchronously.
     */
    schedule(callback: Callback): void;
    /**
     * Calls the queue of functions synchronously, and cancels the pending timeouts.
     */
    flush(): void;
};
/**
 * Used to schedule callbacks inside of a `setTimeout(fn, 0)`.
 *
 * This is used to match the behavior and timings of `react-beautiful-dnd`.
 */
export declare function useScheduler(): Scheduler;
export {};
