import { useEffect, useState } from 'react';
const noop = () => {};
function createCleanupManager() {
  let cleanupFn = noop;
  const setCleanupFn = newCleanupFn => {
    cleanupFn = newCleanupFn;
  };
  const runCleanupFn = () => {
    cleanupFn();
    cleanupFn = noop;
  };
  return {
    setCleanupFn,
    runCleanupFn
  };
}
export function useCleanupFn() {
  const [cleanupManager] = useState(createCleanupManager);

  /**
   * Run the cleanup function on unmount.
   */
  useEffect(() => {
    return cleanupManager.runCleanupFn;
  }, [cleanupManager.runCleanupFn]);
  return cleanupManager;
}