export const idleState = {
  draggingFromThisWith: null,
  draggingOverWith: null,
  isDraggingOver: false
};
export function reducer(state, action) {
  if (action.type === 'DRAG_START') {
    const {
      droppableId,
      start
    } = action.payload;
    const {
      draggableId,
      source
    } = start;
    const isDraggingOver = source.droppableId === droppableId;
    const draggingOverWith = isDraggingOver ? draggableId : null;
    const isDraggingFrom = source.droppableId === droppableId;
    const draggingFromThisWith = isDraggingFrom ? draggableId : null;
    return {
      ...state,
      isDraggingOver,
      draggingFromThisWith,
      draggingOverWith
    };
  }
  if (action.type === 'DRAG_UPDATE') {
    const {
      droppableId,
      update
    } = action.payload;
    const {
      destination = null,
      draggableId,
      source
    } = update;
    const isDraggingOver = (destination === null || destination === void 0 ? void 0 : destination.droppableId) === droppableId;
    const draggingOverWith = isDraggingOver ? draggableId : null;
    const isDraggingFrom = source.droppableId === droppableId;
    const draggingFromThisWith = isDraggingFrom ? draggableId : null;
    return {
      ...state,
      isDraggingOver,
      draggingFromThisWith,
      draggingOverWith
    };
  }
  if (action.type === 'DRAG_CLEAR') {
    return idleState;
  }
  return state;
}