"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.warning = exports.log = exports.error = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
// This file has been copied from `react-beautiful-dnd`
// <https://github.com/atlassian/react-beautiful-dnd/blob/v13.1.1/src/dev-warning.js>

function noop() {}
var log = exports.log =
// no warnings in production
process.env.NODE_ENV === 'production' ? noop :
/**
* An Immediately Invoked Function Expression (IIFE) is used to enable
* dead code elimination while also only having to evaluate these
* declarations once.
*/
function () {
  var isDisabledFlag = '__react-beautiful-dnd-disable-dev-warnings';

  // not replacing newlines (which \s does)
  var spacesAndTabs = /[ \t]{2,}/g;
  var lineStartWithSpaces = /^[ \t]*/gm;

  // using .trim() to clear the any newlines before the first text and after last text
  var clean = function clean(value) {
    return value.replace(spacesAndTabs, ' ').replace(lineStartWithSpaces, '').trim();
  };
  var getDevMessage = function getDevMessage(message) {
    return clean("\n          %creact-beautiful-dnd\n          \n          %c".concat(clean(message), "\n          \n          %c\uD83D\uDC77\u200D This is a development only message. It will be removed in production builds.\n        "));
  };
  var getFormattedMessage = function getFormattedMessage(message) {
    return [getDevMessage(message),
    // title (green400)
    'color: #00C584; font-size: 1.2em; font-weight: bold;',
    // message
    'line-height: 1.5',
    // footer (purple300)
    'color: #723874;'];
  };
  return function log(type, message) {
    var _console;
    // manual opt out of warnings
    // @ts-expect-error
    if (typeof window !== 'undefined' && window[isDisabledFlag]) {
      return;
    }

    // eslint-disable-next-line no-console
    (_console = console)[type].apply(_console, (0, _toConsumableArray2.default)(getFormattedMessage(message)));
  };
}();
var warning = exports.warning = log.bind(null, 'warn');
var error = exports.error = log.bind(null, 'error');