/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.utils.jars;

import io.bazel.kotlin.builder.utils.jars.JarHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017J\u0006\u0010\u0018\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator;", "Lio/bazel/kotlin/builder/utils/jars/JarHelper;", "path", "Ljava/nio/file/Path;", "verbose", "", "(Ljava/nio/file/Path;Z)V", "entries", "Ljava/util/TreeMap;", "", "Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry;", "filenameHelper", "Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$JarFilenameHelper;", "addEntry", "", "name", "bytes", "", "addJavaLikeSourceFile", "sourceFile", "addSourceJar", "addSources", "sources", "Ljava/util/stream/Stream;", "execute", "Companion", "Entry", "JarFilenameHelper", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
public final class SourceJarCreator
extends JarHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JarFilenameHelper filenameHelper;
    @NotNull
    private final TreeMap<String, Entry> entries;
    @NotNull
    private static final String BL = "\\p{Blank}*";
    @NotNull
    private static final String COM_BL = "\\p{Blank}*(?:/\\*[^\\n]*\\*/\\p{Blank}*)*";
    @NotNull
    private static final Pattern PKG_PATTERN;

    public SourceJarCreator(@NotNull Path path, boolean verbose) {
        Intrinsics.checkNotNullParameter(path, "path");
        super(path, true, verbose, false, 8, null);
        this.filenameHelper = new JarFilenameHelper();
        this.entries = new TreeMap();
    }

    public /* synthetic */ SourceJarCreator(Path path, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(path, bl);
    }

    public final void addSources(@NotNull Stream<Path> sources) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        sources.forEach(new Consumer(this){
            final /* synthetic */ SourceJarCreator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Path path) {
                String fileName = ((Object)path.getFileName()).toString();
                if (io.bazel.kotlin.builder.utils.jars.SourceJarCreator$Companion.access$isJavaSourceLike(SourceJarCreator.Companion, fileName)) {
                    Intrinsics.checkNotNullExpressionValue(path, "path");
                    SourceJarCreator.access$addJavaLikeSourceFile(this.this$0, path);
                } else if (StringsKt.endsWith$default(fileName, ".srcjar", false, 2, null)) {
                    Intrinsics.checkNotNullExpressionValue(path, "path");
                    SourceJarCreator.access$addSourceJar(this.this$0, path);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addSourceJar(Path path) {
        if (this.getVerbose()) {
            System.err.println("adding source jar: " + path);
        }
        Closeable closeable = new JarFile(path.toFile());
        Throwable throwable = null;
        try {
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = jar.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "jar.entries()");
            Iterator<JarEntry> iterator2 = CollectionsKt.iterator(enumeration);
            while (iterator2.hasNext()) {
                byte[] byArray;
                JarEntry entry2 = iterator2.next();
                if (entry2.isDirectory()) continue;
                String string = entry2.getName();
                Intrinsics.checkNotNullExpressionValue(string, "entry.name");
                if (!SourceJarCreator.Companion.isJavaSourceLike(string)) continue;
                InputStream inputStream = jar.getInputStream(entry2);
                Intrinsics.checkNotNullExpressionValue(inputStream, "jar.getInputStream(entry)");
                byte[] it = byArray = ByteStreamsKt.readBytes(inputStream);
                boolean bl2 = false;
                String string2 = entry2.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "entry.name");
                this.addEntry(string2, path, it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final void addJavaLikeSourceFile(Path sourceFile) {
        block0: {
            String string;
            byte[] bytes = Files.readAllBytes(sourceFile);
            Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
            String string2 = this.filenameHelper.getFilenameOrDefer(sourceFile, bytes);
            if (string2 == null) break block0;
            String it = string = string2;
            boolean bl = false;
            this.addEntry(it, sourceFile, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        if (this.getVerbose()) {
            System.err.println("creating source jar file: " + this.getJarPath());
        }
        this.filenameHelper.visitDeferredEntries((Function3<? super Path, ? super String, ? super byte[], Unit>)new Function3<Path, String, byte[], Unit>(this){
            final /* synthetic */ SourceJarCreator this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull Path path, @Nullable String jarFilename, @NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter(path, "path");
                Intrinsics.checkNotNullParameter(bytes, "bytes");
                if (jarFilename == null) {
                    if (this.this$0.getVerbose()) {
                        byte[] byArray = bytes;
                        Charset charset = Charset.defaultCharset();
                        Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
                        Charset charset2 = charset;
                        String body = new String(byArray, charset2);
                        System.err.println("could not determine jar entry name for " + path + ". Body:\\n" + body + '}');
                    } else {
                        SourceJarCreator.access$addEntry(this.this$0, ((Object)path.getFileName()).toString(), path, bytes);
                    }
                } else {
                    System.err.println("adding deferred source file " + path + " -> " + jarFilename);
                    SourceJarCreator.access$addEntry(this.this$0, jarFilename, path, bytes);
                }
            }
        });
        Closeable closeable = Files.newOutputStream(this.getJarPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new JarOutputStream(it);
            Throwable throwable2 = null;
            try {
                JarOutputStream out2 = (JarOutputStream)closeable2;
                boolean bl2 = false;
                for (Map.Entry entry2 : ((Map)this.entries).entrySet()) {
                    String key = (String)entry2.getKey();
                    Entry value = (Entry)entry2.getValue();
                    try {
                        Entry entry3 = value;
                        if (entry3 instanceof Entry.File) {
                            this.copyEntry(out2, key, ((Entry.File)value).getPath(), ((Entry.File)value).getContent());
                            continue;
                        }
                        if (!(entry3 instanceof Entry.Directory)) continue;
                        JarHelper.copyEntry$default(this, out2, key, null, null, 6, null);
                    }
                    catch (Throwable throwable3) {
                        throw new RuntimeException("could not copy JarEntry " + key + ' ' + value, throwable3);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final void addEntry(String name, Path path, byte[] bytes) {
        Entry result;
        Object object = new String[]{"/"};
        Object it = object = StringsKt.split$default((CharSequence)name, (String[])object, false, 0, 6, null);
        boolean bl = false;
        if (it.size() >= 2) {
            String dirName;
            for (int i = it.size() - 1; 0 < i && this.entries.putIfAbsent(dirName = CollectionsKt.joinToString$default(it.subList(0, i), "/", null, "/", 0, null, null, 58, null), Entry.Directory.INSTANCE) == null; --i) {
                if (!this.getVerbose()) continue;
                System.err.println("adding directory: " + dirName);
            }
        }
        if (!(((result = this.entries.putIfAbsent(name, new Entry.File(path, bytes))) instanceof Entry.Directory ? (Entry.Directory)result : null) != null || result == null)) {
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append("source entry jarName: ").append(name).append(" from: ").append(path).append(" collides with entry from: ");
            Intrinsics.checkNotNull(result, "null cannot be cast to non-null type io.bazel.kotlin.builder.utils.jars.SourceJarCreator.Entry.File");
            String string = stringBuilder.append(((Entry.File)result).getPath()).toString();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @JvmStatic
    @Nullable
    public static final String extractPackage(@NotNull String line) {
        return Companion.extractPackage(line);
    }

    public static final /* synthetic */ void access$addJavaLikeSourceFile(SourceJarCreator $this, Path sourceFile) {
        $this.addJavaLikeSourceFile(sourceFile);
    }

    public static final /* synthetic */ void access$addSourceJar(SourceJarCreator $this, Path path) {
        $this.addSourceJar(path);
    }

    public static final /* synthetic */ void access$addEntry(SourceJarCreator $this, String name, Path path, byte[] bytes) {
        $this.addEntry(name, path, bytes);
    }

    static {
        Pattern pattern = Pattern.compile("^\\p{Blank}*(?:/\\*[^\\n]*\\*/\\p{Blank}*)*package\\p{Blank}*(?:/\\*[^\\n]*\\*/\\p{Blank}*)*([a-zA-Z0-9._]+)\\p{Blank}*(?:/\\*[^\\n]*\\*/\\p{Blank}*)*(?:;?.*)$");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(\"\"\"^${COM_BL}pac\u2026._]+)$COM_BL(?:;?.*)$\"\"\")");
        PKG_PATTERN = pattern;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Companion;", "", "()V", "BL", "", "COM_BL", "PKG_PATTERN", "Ljava/util/regex/Pattern;", "extractPackage", "line", "isJavaSourceLike", "", "name", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String extractPackage(@NotNull String line) {
            Matcher matcher;
            Intrinsics.checkNotNullParameter(line, "line");
            Matcher it = matcher = PKG_PATTERN.matcher(line);
            boolean bl = false;
            Matcher matcher2 = it.matches() ? matcher : null;
            return matcher2 != null ? matcher2.group(1) : null;
        }

        private final boolean isJavaSourceLike(String name) {
            return StringsKt.endsWith$default(name, ".kt", false, 2, null) || StringsKt.endsWith$default(name, ".java", false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry;", "", "()V", "Directory", "File", "Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry$Directory;", "Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry$File;", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
    public static abstract class Entry {
        private Entry() {
        }

        public /* synthetic */ Entry(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry$Directory;", "Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry;", "()V", "toString", "", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
        public static final class Directory
        extends Entry {
            @NotNull
            public static final Directory INSTANCE = new Directory();

            private Directory() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Directory";
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry$File;", "Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$Entry;", "path", "Ljava/nio/file/Path;", "content", "", "(Ljava/nio/file/Path;[B)V", "getContent", "()[B", "getPath", "()Ljava/nio/file/Path;", "toString", "", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
        public static final class File
        extends Entry {
            @NotNull
            private final Path path;
            @NotNull
            private final byte[] content;

            public File(@NotNull Path path, @NotNull byte[] content) {
                Intrinsics.checkNotNullParameter(path, "path");
                Intrinsics.checkNotNullParameter(content, "content");
                super(null);
                this.path = path;
                this.content = content;
            }

            @NotNull
            public final Path getPath() {
                return this.path;
            }

            @NotNull
            public final byte[] getContent() {
                return this.content;
            }

            @NotNull
            public String toString() {
                return "File " + this.path;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006J\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\r\u001a\u00020\u000e2 \u0010\u000f\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/bazel/kotlin/builder/utils/jars/SourceJarCreator$JarFilenameHelper;", "", "()V", "deferredEntries", "", "Ljava/nio/file/Path;", "", "directoryToPackageMap", "", "getFilenameOrDefer", "sourceFile", "body", "locatePackagePathOrDefer", "visitDeferredEntries", "", "block", "Lkotlin/Function3;", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
    private static final class JarFilenameHelper {
        @NotNull
        private final Map<Path, String> directoryToPackageMap = new LinkedHashMap();
        @NotNull
        private final Map<Path, byte[]> deferredEntries = new LinkedHashMap();

        @Nullable
        public final String getFilenameOrDefer(@NotNull Path sourceFile, @NotNull byte[] body) {
            Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
            Intrinsics.checkNotNullParameter(body, "body");
            String string = this.directoryToPackageMap.get(sourceFile.getParent());
            if (string == null) {
                String string2 = this.locatePackagePathOrDefer(sourceFile, body);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    string = it + '/' + sourceFile.getFileName();
                } else {
                    string = null;
                }
            }
            return string;
        }

        public final void visitDeferredEntries(@NotNull Function3<? super Path, ? super String, ? super byte[], Unit> block) {
            Intrinsics.checkNotNullParameter(block, "block");
            this.deferredEntries.forEach(new BiConsumer(block, this){
                final /* synthetic */ Function3<Path, String, byte[], Unit> $block;
                final /* synthetic */ JarFilenameHelper this$0;
                {
                    this.$block = $block;
                    this.this$0 = $receiver;
                }

                public final void accept(@NotNull Path sourceFile, @NotNull byte[] bytes) {
                    Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
                    Intrinsics.checkNotNullParameter(bytes, "bytes");
                    this.$block.invoke(sourceFile, (String)JarFilenameHelper.access$getDirectoryToPackageMap$p(this.this$0).get(sourceFile.getParent()), bytes);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String locatePackagePathOrDefer(Path sourceFile, byte[] body) {
            String string;
            Object object = new ByteArrayInputStream(body);
            Charset charset = Charsets.UTF_8;
            Closeable closeable = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean $i$f$useLines = false;
            closeable = $this$useLines$iv;
            n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence<String> it = TextStreamsKt.lineSequence(it$iv);
                boolean bl2 = false;
                String string2 = (String)SequencesKt.firstOrNull(SequencesKt.mapNotNull(it, (Function1)new Function1<String, String>((Object)Companion){

                    @Nullable
                    public final String invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Companion)this.receiver).extractPackage(p0);
                    }
                }));
                string = string2 != null ? StringsKt.replace$default(string2, '.', '/', false, 4, null) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Object it = object = string;
            boolean bl = false;
            if (it == null) {
                this.deferredEntries.put(sourceFile, body);
            }
            return object;
        }

        public static final /* synthetic */ Map access$getDirectoryToPackageMap$p(JarFilenameHelper $this) {
            return $this.directoryToPackageMap;
        }
    }
}

