/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.dagger.internal;

import io.bazel.kotlin.builder.dagger.Lazy;
import io.bazel.kotlin.builder.dagger.internal.AbstractMapFactory;
import io.bazel.kotlin.builder.dagger.internal.DaggerCollections;
import io.bazel.kotlin.builder.dagger.internal.Provider;
import io.bazel.kotlin.builder.dagger.internal.Providers;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapProviderFactory<K, V>
extends AbstractMapFactory<K, V, Provider<V>>
implements Lazy<Map<K, Provider<V>>> {
    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    private MapProviderFactory(Map<K, Provider<V>> contributingMap) {
        super(contributingMap);
    }

    @Override
    public Map<K, Provider<V>> get() {
        return this.contributingMap();
    }

    public static final class Builder<K, V>
    extends AbstractMapFactory.Builder<K, V, Provider<V>> {
        private Builder(int size) {
            super(size);
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            super.put(key, providerOfValue);
            return this;
        }

        @Deprecated
        public Builder<K, V> put(K key, javax.inject.Provider<V> providerOfValue) {
            return this.put((Object)key, (Provider)Providers.asDaggerProvider(providerOfValue));
        }

        public Builder<K, V> putAll(Provider<Map<K, Provider<V>>> mapProviderFactory) {
            super.putAll(mapProviderFactory);
            return this;
        }

        @Deprecated
        public Builder<K, V> putAll(final javax.inject.Provider<Map<K, javax.inject.Provider<V>>> mapProviderFactory) {
            return this.putAll(new Provider<Map<K, Provider<V>>>(){

                @Override
                public Map<K, Provider<V>> get() {
                    Map javaxMap = (Map)mapProviderFactory.get();
                    if (javaxMap.isEmpty()) {
                        return Collections.emptyMap();
                    }
                    LinkedHashMap daggerMap = DaggerCollections.newLinkedHashMapWithExpectedSize(javaxMap.size());
                    for (Map.Entry e : javaxMap.entrySet()) {
                        daggerMap.put(e.getKey(), Providers.asDaggerProvider((javax.inject.Provider)e.getValue()));
                    }
                    return Collections.unmodifiableMap(daggerMap);
                }
            });
        }

        public MapProviderFactory<K, V> build() {
            return new MapProviderFactory(this.map);
        }
    }
}

