;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2023 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
; This test checks that i64 data write is translated to v2i32 in VectorProcess.
; Ref: IGC-7889

; Below .ll is generated by the ocloc options
;     -device mtl
;     -internal_options "-cl-intel-use-bindless-mode -cl-intel-use-bindless-advanced-mode"
; CL Source:
;     __kernel void QueryKernelTimestamps(__global ulong* dst) {
;       uint gid = get_global_id(0);
;       uint currentOffset = gid * 4;
;       dst[currentOffset] = 0;
;     }
;
; RUN: igc_opt --typed-pointers -enable-debugify --igc-vectorprocess -platformmtl -S < %s 2>&1 | FileCheck %s

; ------------------------------------------------
; VectorProcess
; ------------------------------------------------
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v24:32:32-v32:32:32-v48:64:64-v64:64:64-v96:128:128-v128:128:128-v192:256:256-v256:256:256-v512:512:512-v1024:1024:1024-n8:16:32"

; Debug-info related check
; CHECK-NOT: WARNING
; CHECK: CheckModuleDebugify: PASS

define spir_kernel void @QueryKernelTimestamps(i64 addrspace(1)* %dst, <8 x i32> %r0, <8 x i32> %payloadHeader, <3 x i32> %enqueuedLocalSize, i16 %localIdX, i16 %localIdY, i16 %localIdZ, i32 %bufferOffset) {
entry:
  %payloadHeader.scalar = extractelement <8 x i32> %payloadHeader, i32 0
  %enqueuedLocalSize.scalar = extractelement <3 x i32> %enqueuedLocalSize, i32 0
  %r0.scalar17 = extractelement <8 x i32> %r0, i32 1
  %mul.i.i.i = mul i32 %enqueuedLocalSize.scalar, %r0.scalar17
  %localIdX2 = zext i16 %localIdX to i32
  %add.i.i.i = add i32 %mul.i.i.i, %localIdX2
  %add4.i.i.i = add i32 %add.i.i.i, %payloadHeader.scalar
  %mul = shl i32 %add4.i.i.i, 5
  %0 = addrspacecast i64 addrspace(1)* %dst to i64 addrspace(2490368)*
; CHECK: call void @llvm.genx.GenISA.storerawvector
; CHECK-NOT: i64
; CHECK-SAME: v2i32.v2i32
  call void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)* %0, i32 %mul, i64 0, i32 8, i1 false)
  ret void
}

declare void @llvm.genx.GenISA.storeraw.indexed.p2490368i64.i64(i64 addrspace(2490368)*, i32, i64, i32, i1)
