// This file is auto-generated, don't edit it. Thanks.
package client

import (
	openapi "github.com/alibabacloud-go/darabonba-openapi/v2/client"
	endpointutil "github.com/alibabacloud-go/endpoint-util/service"
	openapiutil "github.com/alibabacloud-go/openapi-util/service"
	util "github.com/alibabacloud-go/tea-utils/v2/service"
	"github.com/alibabacloud-go/tea/tea"
)

type AddCustomLineRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The CIDR blocks.
	//
	// This parameter is required.
	IpSegment []*AddCustomLineRequestIpSegment `json:"IpSegment,omitempty" xml:"IpSegment,omitempty" type:"Repeated"`
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The name of the custom line.
	//
	// This parameter is required.
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s AddCustomLineRequest) String() string {
	return tea.Prettify(s)
}

func (s AddCustomLineRequest) GoString() string {
	return s.String()
}

func (s *AddCustomLineRequest) SetDomainName(v string) *AddCustomLineRequest {
	s.DomainName = &v
	return s
}

func (s *AddCustomLineRequest) SetIpSegment(v []*AddCustomLineRequestIpSegment) *AddCustomLineRequest {
	s.IpSegment = v
	return s
}

func (s *AddCustomLineRequest) SetLang(v string) *AddCustomLineRequest {
	s.Lang = &v
	return s
}

func (s *AddCustomLineRequest) SetLineName(v string) *AddCustomLineRequest {
	s.LineName = &v
	return s
}

type AddCustomLineRequestIpSegment struct {
	// The end IP address of the CIDR block.
	//
	// example:
	//
	// 192.0.2.254
	EndIp *string `json:"EndIp,omitempty" xml:"EndIp,omitempty"`
	// The start IP address of the CIDR block.
	//
	// example:
	//
	// 192.0.2.0
	StartIp *string `json:"StartIp,omitempty" xml:"StartIp,omitempty"`
}

func (s AddCustomLineRequestIpSegment) String() string {
	return tea.Prettify(s)
}

func (s AddCustomLineRequestIpSegment) GoString() string {
	return s.String()
}

func (s *AddCustomLineRequestIpSegment) SetEndIp(v string) *AddCustomLineRequestIpSegment {
	s.EndIp = &v
	return s
}

func (s *AddCustomLineRequestIpSegment) SetStartIp(v string) *AddCustomLineRequestIpSegment {
	s.StartIp = &v
	return s
}

type AddCustomLineResponseBody struct {
	// The code of the custom line.
	//
	// example:
	//
	// hra0yc-597
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The unique ID of the custom line.
	//
	// example:
	//
	// 597
	LineId *int64 `json:"LineId,omitempty" xml:"LineId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddCustomLineResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddCustomLineResponseBody) GoString() string {
	return s.String()
}

func (s *AddCustomLineResponseBody) SetLineCode(v string) *AddCustomLineResponseBody {
	s.LineCode = &v
	return s
}

func (s *AddCustomLineResponseBody) SetLineId(v int64) *AddCustomLineResponseBody {
	s.LineId = &v
	return s
}

func (s *AddCustomLineResponseBody) SetRequestId(v string) *AddCustomLineResponseBody {
	s.RequestId = &v
	return s
}

type AddCustomLineResponse struct {
	Headers    map[string]*string         `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                     `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddCustomLineResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddCustomLineResponse) String() string {
	return tea.Prettify(s)
}

func (s AddCustomLineResponse) GoString() string {
	return s.String()
}

func (s *AddCustomLineResponse) SetHeaders(v map[string]*string) *AddCustomLineResponse {
	s.Headers = v
	return s
}

func (s *AddCustomLineResponse) SetStatusCode(v int32) *AddCustomLineResponse {
	s.StatusCode = &v
	return s
}

func (s *AddCustomLineResponse) SetBody(v *AddCustomLineResponseBody) *AddCustomLineResponse {
	s.Body = v
	return s
}

type AddDnsCacheDomainRequest struct {
	// The maximum TTL period of the cached data retrieved from the origin DNS server. Unit: seconds. Valid values: 30 to 86400.
	//
	// This parameter is required.
	//
	// example:
	//
	// 86400
	CacheTtlMax *int32 `json:"CacheTtlMax,omitempty" xml:"CacheTtlMax,omitempty"`
	// The minimum time-to-live (TTL) period of the cached data retrieved from the origin Domain Name System (DNS) server. Unit: seconds. Valid values: 30 to 86400.
	//
	// This parameter is required.
	//
	// example:
	//
	// 30
	CacheTtlMin *int32 `json:"CacheTtlMin,omitempty" xml:"CacheTtlMin,omitempty"`
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// dns.example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The instance ID of the cache-accelerated domain name. You can call the [ListCloudGtmInstances](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-listcloudgtminstances?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the instance ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// dns-cn-j6666
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language of the content within the request and response. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English Default: **zh**
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The remarks.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The origin DNS servers. A maximum of 10 origin DNS servers are supported.
	//
	// This parameter is required.
	SourceDnsServer []*AddDnsCacheDomainRequestSourceDnsServer `json:"SourceDnsServer,omitempty" xml:"SourceDnsServer,omitempty" type:"Repeated"`
	// Specifies whether the origin DNS server supports Extension Mechanisms for DNS (EDNS). Valid values: NOT_SUPPORT and SUPPORT.
	//
	// This parameter is required.
	//
	// example:
	//
	// SUPPORT
	SourceEdns *string `json:"SourceEdns,omitempty" xml:"SourceEdns,omitempty"`
	// The origin protocol policy. Valid values: TCP and UDP. Default value: UDP.
	//
	// This parameter is required.
	//
	// example:
	//
	// UDP
	SourceProtocol *string `json:"SourceProtocol,omitempty" xml:"SourceProtocol,omitempty"`
}

func (s AddDnsCacheDomainRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDnsCacheDomainRequest) GoString() string {
	return s.String()
}

func (s *AddDnsCacheDomainRequest) SetCacheTtlMax(v int32) *AddDnsCacheDomainRequest {
	s.CacheTtlMax = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetCacheTtlMin(v int32) *AddDnsCacheDomainRequest {
	s.CacheTtlMin = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetDomainName(v string) *AddDnsCacheDomainRequest {
	s.DomainName = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetInstanceId(v string) *AddDnsCacheDomainRequest {
	s.InstanceId = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetLang(v string) *AddDnsCacheDomainRequest {
	s.Lang = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetRemark(v string) *AddDnsCacheDomainRequest {
	s.Remark = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetSourceDnsServer(v []*AddDnsCacheDomainRequestSourceDnsServer) *AddDnsCacheDomainRequest {
	s.SourceDnsServer = v
	return s
}

func (s *AddDnsCacheDomainRequest) SetSourceEdns(v string) *AddDnsCacheDomainRequest {
	s.SourceEdns = &v
	return s
}

func (s *AddDnsCacheDomainRequest) SetSourceProtocol(v string) *AddDnsCacheDomainRequest {
	s.SourceProtocol = &v
	return s
}

type AddDnsCacheDomainRequestSourceDnsServer struct {
	// The domain name or IP address of the origin DNS server.
	//
	// This parameter is required.
	//
	// example:
	//
	// 192.0.0.0
	Host *string `json:"Host,omitempty" xml:"Host,omitempty"`
	// The port of the origin DNS server.
	//
	// This parameter is required.
	//
	// example:
	//
	// 53
	Port *string `json:"Port,omitempty" xml:"Port,omitempty"`
}

func (s AddDnsCacheDomainRequestSourceDnsServer) String() string {
	return tea.Prettify(s)
}

func (s AddDnsCacheDomainRequestSourceDnsServer) GoString() string {
	return s.String()
}

func (s *AddDnsCacheDomainRequestSourceDnsServer) SetHost(v string) *AddDnsCacheDomainRequestSourceDnsServer {
	s.Host = &v
	return s
}

func (s *AddDnsCacheDomainRequestSourceDnsServer) SetPort(v string) *AddDnsCacheDomainRequestSourceDnsServer {
	s.Port = &v
	return s
}

type AddDnsCacheDomainResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-XXXXXXX
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDnsCacheDomainResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDnsCacheDomainResponseBody) GoString() string {
	return s.String()
}

func (s *AddDnsCacheDomainResponseBody) SetRequestId(v string) *AddDnsCacheDomainResponseBody {
	s.RequestId = &v
	return s
}

type AddDnsCacheDomainResponse struct {
	Headers    map[string]*string             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDnsCacheDomainResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDnsCacheDomainResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDnsCacheDomainResponse) GoString() string {
	return s.String()
}

func (s *AddDnsCacheDomainResponse) SetHeaders(v map[string]*string) *AddDnsCacheDomainResponse {
	s.Headers = v
	return s
}

func (s *AddDnsCacheDomainResponse) SetStatusCode(v int32) *AddDnsCacheDomainResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDnsCacheDomainResponse) SetBody(v *AddDnsCacheDomainResponseBody) *AddDnsCacheDomainResponse {
	s.Body = v
	return s
}

type AddDnsGtmAccessStrategyRequest struct {
	// The address pools in the primary address pool set.
	//
	// This parameter is required.
	DefaultAddrPool []*AddDnsGtmAccessStrategyRequestDefaultAddrPool `json:"DefaultAddrPool,omitempty" xml:"DefaultAddrPool,omitempty" type:"Repeated"`
	// The type of the primary address pool. Valid values:
	//
	// 	- IPV4
	//
	// 	- IPV6
	//
	// 	- DOMAIN
	//
	// This parameter is required.
	//
	// example:
	//
	// ipv4
	DefaultAddrPoolType *string `json:"DefaultAddrPoolType,omitempty" xml:"DefaultAddrPoolType,omitempty"`
	// Specifies whether to enable DNS resolution with optimal latency for the primary address pool set. Valid values:
	//
	// 	- OPEN
	//
	// 	- CLOSE
	//
	// example:
	//
	// open
	DefaultLatencyOptimization *string `json:"DefaultLatencyOptimization,omitempty" xml:"DefaultLatencyOptimization,omitempty"`
	// The load balancing policy of the primary address pool set. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	DefaultLbaStrategy *string `json:"DefaultLbaStrategy,omitempty" xml:"DefaultLbaStrategy,omitempty"`
	// The maximum number of addresses returned from the primary address pool set.
	//
	// example:
	//
	// 3
	DefaultMaxReturnAddrNum *int32 `json:"DefaultMaxReturnAddrNum,omitempty" xml:"DefaultMaxReturnAddrNum,omitempty"`
	// The minimum number of available addresses in the primary address pool set.
	//
	// This parameter is required.
	//
	// example:
	//
	// 1
	DefaultMinAvailableAddrNum *int32 `json:"DefaultMinAvailableAddrNum,omitempty" xml:"DefaultMinAvailableAddrNum,omitempty"`
	// The address pools in the secondary address pool set. If no address pool exists in the secondary address pool set, set this parameter to EMPTY.
	FailoverAddrPool []*AddDnsGtmAccessStrategyRequestFailoverAddrPool `json:"FailoverAddrPool,omitempty" xml:"FailoverAddrPool,omitempty" type:"Repeated"`
	// The type of the secondary address pool. Valid values:
	//
	// 	- IPV4
	//
	// 	- IPV6
	//
	// 	- DOMAIN
	//
	// example:
	//
	// ipv4
	FailoverAddrPoolType *string `json:"FailoverAddrPoolType,omitempty" xml:"FailoverAddrPoolType,omitempty"`
	// Specifies whether to enable DNS resolution with optimal latency for the secondary address pool set. Valid values:
	//
	// 	- OPEN
	//
	// 	- CLOSE
	//
	// example:
	//
	// open
	FailoverLatencyOptimization *string `json:"FailoverLatencyOptimization,omitempty" xml:"FailoverLatencyOptimization,omitempty"`
	// The load balancing policy of the secondary address pool set. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	FailoverLbaStrategy *string `json:"FailoverLbaStrategy,omitempty" xml:"FailoverLbaStrategy,omitempty"`
	// The maximum number of addresses returned from the secondary address pool set.
	//
	// example:
	//
	// 1
	FailoverMaxReturnAddrNum *int32 `json:"FailoverMaxReturnAddrNum,omitempty" xml:"FailoverMaxReturnAddrNum,omitempty"`
	// The minimum number of available addresses in the secondary address pool set.
	//
	// example:
	//
	// 1
	FailoverMinAvailableAddrNum *int32 `json:"FailoverMinAvailableAddrNum,omitempty" xml:"FailoverMinAvailableAddrNum,omitempty"`
	// The instance ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language of the values for specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The Domain Name System (DNS) request source. For example: `["default", "drpeng"]` indicates Global and Dr. Peng Group.
	//
	// example:
	//
	// ["default", "drpeng"]
	Lines *string `json:"Lines,omitempty" xml:"Lines,omitempty"`
	// The type of the access policy. Valid values:
	//
	// 	- GEO: geographical location-based access policy
	//
	// 	- LATENCY: latency-based access policy
	//
	// This parameter is required.
	//
	// example:
	//
	// geo
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
	// The name of the access policy.
	//
	// This parameter is required.
	//
	// example:
	//
	// testStrategyName
	StrategyName *string `json:"StrategyName,omitempty" xml:"StrategyName,omitempty"`
}

func (s AddDnsGtmAccessStrategyRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAccessStrategyRequest) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAccessStrategyRequest) SetDefaultAddrPool(v []*AddDnsGtmAccessStrategyRequestDefaultAddrPool) *AddDnsGtmAccessStrategyRequest {
	s.DefaultAddrPool = v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetDefaultAddrPoolType(v string) *AddDnsGtmAccessStrategyRequest {
	s.DefaultAddrPoolType = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetDefaultLatencyOptimization(v string) *AddDnsGtmAccessStrategyRequest {
	s.DefaultLatencyOptimization = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetDefaultLbaStrategy(v string) *AddDnsGtmAccessStrategyRequest {
	s.DefaultLbaStrategy = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetDefaultMaxReturnAddrNum(v int32) *AddDnsGtmAccessStrategyRequest {
	s.DefaultMaxReturnAddrNum = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetDefaultMinAvailableAddrNum(v int32) *AddDnsGtmAccessStrategyRequest {
	s.DefaultMinAvailableAddrNum = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetFailoverAddrPool(v []*AddDnsGtmAccessStrategyRequestFailoverAddrPool) *AddDnsGtmAccessStrategyRequest {
	s.FailoverAddrPool = v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetFailoverAddrPoolType(v string) *AddDnsGtmAccessStrategyRequest {
	s.FailoverAddrPoolType = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetFailoverLatencyOptimization(v string) *AddDnsGtmAccessStrategyRequest {
	s.FailoverLatencyOptimization = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetFailoverLbaStrategy(v string) *AddDnsGtmAccessStrategyRequest {
	s.FailoverLbaStrategy = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetFailoverMaxReturnAddrNum(v int32) *AddDnsGtmAccessStrategyRequest {
	s.FailoverMaxReturnAddrNum = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetFailoverMinAvailableAddrNum(v int32) *AddDnsGtmAccessStrategyRequest {
	s.FailoverMinAvailableAddrNum = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetInstanceId(v string) *AddDnsGtmAccessStrategyRequest {
	s.InstanceId = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetLang(v string) *AddDnsGtmAccessStrategyRequest {
	s.Lang = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetLines(v string) *AddDnsGtmAccessStrategyRequest {
	s.Lines = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetStrategyMode(v string) *AddDnsGtmAccessStrategyRequest {
	s.StrategyMode = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequest) SetStrategyName(v string) *AddDnsGtmAccessStrategyRequest {
	s.StrategyName = &v
	return s
}

type AddDnsGtmAccessStrategyRequestDefaultAddrPool struct {
	// The ID of the address pool in the primary address pool set.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The weight of the address pool in the primary address pool set.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
}

func (s AddDnsGtmAccessStrategyRequestDefaultAddrPool) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAccessStrategyRequestDefaultAddrPool) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAccessStrategyRequestDefaultAddrPool) SetId(v string) *AddDnsGtmAccessStrategyRequestDefaultAddrPool {
	s.Id = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequestDefaultAddrPool) SetLbaWeight(v int32) *AddDnsGtmAccessStrategyRequestDefaultAddrPool {
	s.LbaWeight = &v
	return s
}

type AddDnsGtmAccessStrategyRequestFailoverAddrPool struct {
	// The ID of the address pool in the secondary address pool set.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The weight of the address pool in the secondary address pool set.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
}

func (s AddDnsGtmAccessStrategyRequestFailoverAddrPool) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAccessStrategyRequestFailoverAddrPool) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAccessStrategyRequestFailoverAddrPool) SetId(v string) *AddDnsGtmAccessStrategyRequestFailoverAddrPool {
	s.Id = &v
	return s
}

func (s *AddDnsGtmAccessStrategyRequestFailoverAddrPool) SetLbaWeight(v int32) *AddDnsGtmAccessStrategyRequestFailoverAddrPool {
	s.LbaWeight = &v
	return s
}

type AddDnsGtmAccessStrategyResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// 29D0F8F8-5499-4F6C-9FDC-1EE13BF55925
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the access policy.
	//
	// example:
	//
	// testStrategyId1
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
}

func (s AddDnsGtmAccessStrategyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAccessStrategyResponseBody) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAccessStrategyResponseBody) SetRequestId(v string) *AddDnsGtmAccessStrategyResponseBody {
	s.RequestId = &v
	return s
}

func (s *AddDnsGtmAccessStrategyResponseBody) SetStrategyId(v string) *AddDnsGtmAccessStrategyResponseBody {
	s.StrategyId = &v
	return s
}

type AddDnsGtmAccessStrategyResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDnsGtmAccessStrategyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDnsGtmAccessStrategyResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAccessStrategyResponse) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAccessStrategyResponse) SetHeaders(v map[string]*string) *AddDnsGtmAccessStrategyResponse {
	s.Headers = v
	return s
}

func (s *AddDnsGtmAccessStrategyResponse) SetStatusCode(v int32) *AddDnsGtmAccessStrategyResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDnsGtmAccessStrategyResponse) SetBody(v *AddDnsGtmAccessStrategyResponseBody) *AddDnsGtmAccessStrategyResponse {
	s.Body = v
	return s
}

type AddDnsGtmAddressPoolRequest struct {
	// The address pools.
	//
	// This parameter is required.
	Addr []*AddDnsGtmAddressPoolRequestAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Repeated"`
	// The number of consecutive failures.
	//
	// example:
	//
	// 1
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The instance ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The health check interval. Unit: seconds.
	//
	// example:
	//
	// 1
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The nodes for monitoring.
	IspCityNode []*AddDnsGtmAddressPoolRequestIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
	// The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The load balancing policy of the address pool. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// This parameter is required.
	//
	// example:
	//
	// all_rr
	LbaStrategy *string `json:"LbaStrategy,omitempty" xml:"LbaStrategy,omitempty"`
	// The extended information. The required parameters vary based on the health check protocol.
	//
	// 	- HTTP or HTTPS:
	//
	//     	- port: the port that you want to check
	//
	//     	- host: the host settings
	//
	//     	- path: the URL
	//
	//     	- code: the return code. The health check result is deemed abnormal if the returned value is greater than the specified value. Valid values: 400 and 500.
	//
	//     	- failureRate: the failure rate
	//
	//     	- sni: specifies whether to enable Server Name Indication (SNI). This parameter is available only when ProtocolType is set to HTTPS. Valid values:
	//
	//         	- true: enables SNI.
	//
	//         	- other: disables SNI.
	//
	//     	- nodeType: the type of the node for monitoring when Type is set to DOMAIN. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// 	- ping:
	//
	//     	- failureRate: the failure rate
	//
	//     	- packetNum: the number of ping packets
	//
	//     	- packetLossRate: the loss rate of ping packets
	//
	//     	- nodeType: the type of the node for monitoring when Type is set to DOMAIN. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// 	- TCP:
	//
	//     	- port: the port that you want to check
	//
	//     	- failureRate: the failure rate
	//
	//     	- nodeType: the type of the node for monitoring when Type is set to DOMAIN. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	MonitorExtendInfo *string `json:"MonitorExtendInfo,omitempty" xml:"MonitorExtendInfo,omitempty"`
	// Specifies whether to enable the health check feature. If you set this parameter to OPEN, the system verifies the health check configurations. If you set this parameter to CLOSE, the system discards the health check configurations. Default value: CLOSE. Valid values:
	//
	// 	- OPEN: enables the health check feature.
	//
	// 	- CLOSE: disables the health check feature.
	//
	// example:
	//
	// open
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The name of the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// test
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The health check protocol. Valid values:
	//
	// 	- HTTP
	//
	// 	- HTTPS
	//
	// 	- PING
	//
	// 	- TCP
	//
	// example:
	//
	// http
	ProtocolType *string `json:"ProtocolType,omitempty" xml:"ProtocolType,omitempty"`
	// The timeout period. Unit: milliseconds.
	//
	// example:
	//
	// 1
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- IPV4: IPv4 address
	//
	// 	- IPV6: IPv6 address
	//
	// 	- DOMAIN: domain name
	//
	// This parameter is required.
	//
	// example:
	//
	// ipv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s AddDnsGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAddressPoolRequest) SetAddr(v []*AddDnsGtmAddressPoolRequestAddr) *AddDnsGtmAddressPoolRequest {
	s.Addr = v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetEvaluationCount(v int32) *AddDnsGtmAddressPoolRequest {
	s.EvaluationCount = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetInstanceId(v string) *AddDnsGtmAddressPoolRequest {
	s.InstanceId = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetInterval(v int32) *AddDnsGtmAddressPoolRequest {
	s.Interval = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetIspCityNode(v []*AddDnsGtmAddressPoolRequestIspCityNode) *AddDnsGtmAddressPoolRequest {
	s.IspCityNode = v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetLang(v string) *AddDnsGtmAddressPoolRequest {
	s.Lang = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetLbaStrategy(v string) *AddDnsGtmAddressPoolRequest {
	s.LbaStrategy = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetMonitorExtendInfo(v string) *AddDnsGtmAddressPoolRequest {
	s.MonitorExtendInfo = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetMonitorStatus(v string) *AddDnsGtmAddressPoolRequest {
	s.MonitorStatus = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetName(v string) *AddDnsGtmAddressPoolRequest {
	s.Name = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetProtocolType(v string) *AddDnsGtmAddressPoolRequest {
	s.ProtocolType = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetTimeout(v int32) *AddDnsGtmAddressPoolRequest {
	s.Timeout = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequest) SetType(v string) *AddDnsGtmAddressPoolRequest {
	s.Type = &v
	return s
}

type AddDnsGtmAddressPoolRequestAddr struct {
	// The address in the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// 1.1.1.1
	Addr *string `json:"Addr,omitempty" xml:"Addr,omitempty"`
	// The information about the source region of the address. The value of this parameter is a JSON string. Valid values:
	//
	// 	- lineCode: the line code of the source region for the address
	//
	// 	- lineCodeRectifyType: the rectification type of the line code. Default value: AUTO. Valid values:
	//
	//     	- NO_NEED: no need for rectification
	//
	//     	- RECTIFIED: rectified
	//
	//     	- AUTO: automatic rectification
	//
	// This parameter is required.
	//
	// example:
	//
	// default
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The weight of the address.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The return mode of the addresses: Valid values:
	//
	// 	- SMART: smart return
	//
	// 	- ONLINE: always online
	//
	// 	- OFFLINE: always offline
	//
	// This parameter is required.
	//
	// example:
	//
	// online
	Mode *string `json:"Mode,omitempty" xml:"Mode,omitempty"`
	// The description of the address pool.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
}

func (s AddDnsGtmAddressPoolRequestAddr) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAddressPoolRequestAddr) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAddressPoolRequestAddr) SetAddr(v string) *AddDnsGtmAddressPoolRequestAddr {
	s.Addr = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequestAddr) SetAttributeInfo(v string) *AddDnsGtmAddressPoolRequestAddr {
	s.AttributeInfo = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequestAddr) SetLbaWeight(v int32) *AddDnsGtmAddressPoolRequestAddr {
	s.LbaWeight = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequestAddr) SetMode(v string) *AddDnsGtmAddressPoolRequestAddr {
	s.Mode = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequestAddr) SetRemark(v string) *AddDnsGtmAddressPoolRequestAddr {
	s.Remark = &v
	return s
}

type AddDnsGtmAddressPoolRequestIspCityNode struct {
	// The city code.
	//
	// Specify the parameter according to the value of CityCode returned by the DescribeGtmMonitorAvailableConfig operation.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// 	- The Internet service provider (ISP) node. Specify the parameter according to the value of IspCode returned by the DescribeGtmMonitorAvailableConfig operation.
	//
	// 	- If the returned value of GroupType for the DescribeGtmMonitorAvailableConfig operation is BGP or Overseas, IspCode is not required and is set to 465 by default.
	//
	// 	- If the returned value of GroupType for the DescribeGtmMonitorAvailableConfig operation is not BGP or Overseas, IspCode is required. When IspCode is specified, CityCode is required.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
}

func (s AddDnsGtmAddressPoolRequestIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAddressPoolRequestIspCityNode) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAddressPoolRequestIspCityNode) SetCityCode(v string) *AddDnsGtmAddressPoolRequestIspCityNode {
	s.CityCode = &v
	return s
}

func (s *AddDnsGtmAddressPoolRequestIspCityNode) SetIspCode(v string) *AddDnsGtmAddressPoolRequestIspCityNode {
	s.IspCode = &v
	return s
}

type AddDnsGtmAddressPoolResponseBody struct {
	// The ID of the address pool.
	//
	// example:
	//
	// testpool1
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The ID of the health check configuration.
	//
	// example:
	//
	// test1
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDnsGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAddressPoolResponseBody) SetAddrPoolId(v string) *AddDnsGtmAddressPoolResponseBody {
	s.AddrPoolId = &v
	return s
}

func (s *AddDnsGtmAddressPoolResponseBody) SetMonitorConfigId(v string) *AddDnsGtmAddressPoolResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *AddDnsGtmAddressPoolResponseBody) SetRequestId(v string) *AddDnsGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

type AddDnsGtmAddressPoolResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDnsGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDnsGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *AddDnsGtmAddressPoolResponse) SetHeaders(v map[string]*string) *AddDnsGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *AddDnsGtmAddressPoolResponse) SetStatusCode(v int32) *AddDnsGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDnsGtmAddressPoolResponse) SetBody(v *AddDnsGtmAddressPoolResponseBody) *AddDnsGtmAddressPoolResponse {
	s.Body = v
	return s
}

type AddDnsGtmMonitorRequest struct {
	// The ID of the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// pool1
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
	//
	// This parameter is required.
	//
	// example:
	//
	// 1
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The health check interval. Unit: seconds.
	//
	// This parameter is required.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The monitored nodes.
	//
	// This parameter is required.
	IspCityNode []*AddDnsGtmMonitorRequestIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
	// The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The extended information. The required parameters vary based on the value of ProtocolType.
	//
	// 	- HTTP or HTTPS
	//
	//     	- port: the port that you want to check
	//
	//     	- host: the host settings
	//
	//     	- path: the URL path
	//
	//     	- code: the response code. The health check result is deemed abnormal if the returned value is greater than the specified value.
	//
	//     	- failureRate: the failure rate
	//
	//     	- sni: specifies whether to enable server name indication (SNI). This parameter is available only when ProtocolType is set to HTTPS. Valid values:
	//
	//         	- true: enables SNI.
	//
	//         	- false: disables SNI.
	//
	//     	- nodeType: the type of the node for monitoring when Type is set to DOMAIN. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// 	- PING
	//
	//     	- failureRate: the failure rate
	//
	//     	- packetNum: the number of ping packets
	//
	//     	- packetLossRate: the loss rate of ping packets
	//
	//     	- nodeType: the type of the node for monitoring when Type is set to DOMAIN. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// 	- TCP
	//
	//     	- port: the port that you want to check
	//
	//     	- failureRate: the failure rate
	//
	//     	- nodeType: the type of the node for monitoring when Type is set to DOMAIN. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// This parameter is required.
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	MonitorExtendInfo *string `json:"MonitorExtendInfo,omitempty" xml:"MonitorExtendInfo,omitempty"`
	// The health check protocol. Valid values:
	//
	// 	- HTTP
	//
	// 	- HTTPS
	//
	// 	- PING
	//
	// 	- TCP
	//
	// This parameter is required.
	//
	// example:
	//
	// http
	ProtocolType *string `json:"ProtocolType,omitempty" xml:"ProtocolType,omitempty"`
	// The timeout period. Unit: milliseconds.
	//
	// This parameter is required.
	//
	// example:
	//
	// 30000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
}

func (s AddDnsGtmMonitorRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmMonitorRequest) GoString() string {
	return s.String()
}

func (s *AddDnsGtmMonitorRequest) SetAddrPoolId(v string) *AddDnsGtmMonitorRequest {
	s.AddrPoolId = &v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetEvaluationCount(v int32) *AddDnsGtmMonitorRequest {
	s.EvaluationCount = &v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetInterval(v int32) *AddDnsGtmMonitorRequest {
	s.Interval = &v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetIspCityNode(v []*AddDnsGtmMonitorRequestIspCityNode) *AddDnsGtmMonitorRequest {
	s.IspCityNode = v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetLang(v string) *AddDnsGtmMonitorRequest {
	s.Lang = &v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetMonitorExtendInfo(v string) *AddDnsGtmMonitorRequest {
	s.MonitorExtendInfo = &v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetProtocolType(v string) *AddDnsGtmMonitorRequest {
	s.ProtocolType = &v
	return s
}

func (s *AddDnsGtmMonitorRequest) SetTimeout(v int32) *AddDnsGtmMonitorRequest {
	s.Timeout = &v
	return s
}

type AddDnsGtmMonitorRequestIspCityNode struct {
	// The code of the city where the monitored node is deployed.
	//
	// example:
	//
	// 123
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The code of the Internet service provider (ISP) to which the monitored node belongs.
	//
	// example:
	//
	// 123
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
}

func (s AddDnsGtmMonitorRequestIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmMonitorRequestIspCityNode) GoString() string {
	return s.String()
}

func (s *AddDnsGtmMonitorRequestIspCityNode) SetCityCode(v string) *AddDnsGtmMonitorRequestIspCityNode {
	s.CityCode = &v
	return s
}

func (s *AddDnsGtmMonitorRequestIspCityNode) SetIspCode(v string) *AddDnsGtmMonitorRequestIspCityNode {
	s.IspCode = &v
	return s
}

type AddDnsGtmMonitorResponseBody struct {
	// The ID of the health check configuration.
	//
	// example:
	//
	// MonitorConfigId1
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDnsGtmMonitorResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmMonitorResponseBody) GoString() string {
	return s.String()
}

func (s *AddDnsGtmMonitorResponseBody) SetMonitorConfigId(v string) *AddDnsGtmMonitorResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *AddDnsGtmMonitorResponseBody) SetRequestId(v string) *AddDnsGtmMonitorResponseBody {
	s.RequestId = &v
	return s
}

type AddDnsGtmMonitorResponse struct {
	Headers    map[string]*string            `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                        `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDnsGtmMonitorResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDnsGtmMonitorResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDnsGtmMonitorResponse) GoString() string {
	return s.String()
}

func (s *AddDnsGtmMonitorResponse) SetHeaders(v map[string]*string) *AddDnsGtmMonitorResponse {
	s.Headers = v
	return s
}

func (s *AddDnsGtmMonitorResponse) SetStatusCode(v int32) *AddDnsGtmMonitorResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDnsGtmMonitorResponse) SetBody(v *AddDnsGtmMonitorResponseBody) *AddDnsGtmMonitorResponse {
	s.Body = v
	return s
}

type AddDomainRequest struct {
	// The domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// dns-example.top
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the group to which the domain name will belong. The default value is the ID of the default group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the resource group.
	//
	// example:
	//
	// rg-resourcegroupid
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
}

func (s AddDomainRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDomainRequest) GoString() string {
	return s.String()
}

func (s *AddDomainRequest) SetDomainName(v string) *AddDomainRequest {
	s.DomainName = &v
	return s
}

func (s *AddDomainRequest) SetGroupId(v string) *AddDomainRequest {
	s.GroupId = &v
	return s
}

func (s *AddDomainRequest) SetLang(v string) *AddDomainRequest {
	s.Lang = &v
	return s
}

func (s *AddDomainRequest) SetResourceGroupId(v string) *AddDomainRequest {
	s.ResourceGroupId = &v
	return s
}

type AddDomainResponseBody struct {
	// The Domain Name System (DNS) servers configured for the domain name.
	DnsServers *AddDomainResponseBodyDnsServers `json:"DnsServers,omitempty" xml:"DnsServers,omitempty" type:"Struct"`
	// The ID of the domain name.
	//
	// example:
	//
	// 00efd71a-770e-4255-b54e-6fe5659baffe
	DomainId *string `json:"DomainId,omitempty" xml:"DomainId,omitempty"`
	// The domain name.
	//
	// example:
	//
	// dns-example.top
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the domain name group.
	//
	// example:
	//
	// MyGroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The Punycode for the domain name. This parameter is returned only for Chinese domain names.
	//
	// example:
	//
	// xn--fsq270a.com
	PunyCode *string `json:"PunyCode,omitempty" xml:"PunyCode,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDomainResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDomainResponseBody) GoString() string {
	return s.String()
}

func (s *AddDomainResponseBody) SetDnsServers(v *AddDomainResponseBodyDnsServers) *AddDomainResponseBody {
	s.DnsServers = v
	return s
}

func (s *AddDomainResponseBody) SetDomainId(v string) *AddDomainResponseBody {
	s.DomainId = &v
	return s
}

func (s *AddDomainResponseBody) SetDomainName(v string) *AddDomainResponseBody {
	s.DomainName = &v
	return s
}

func (s *AddDomainResponseBody) SetGroupId(v string) *AddDomainResponseBody {
	s.GroupId = &v
	return s
}

func (s *AddDomainResponseBody) SetGroupName(v string) *AddDomainResponseBody {
	s.GroupName = &v
	return s
}

func (s *AddDomainResponseBody) SetPunyCode(v string) *AddDomainResponseBody {
	s.PunyCode = &v
	return s
}

func (s *AddDomainResponseBody) SetRequestId(v string) *AddDomainResponseBody {
	s.RequestId = &v
	return s
}

type AddDomainResponseBodyDnsServers struct {
	DnsServer []*string `json:"DnsServer,omitempty" xml:"DnsServer,omitempty" type:"Repeated"`
}

func (s AddDomainResponseBodyDnsServers) String() string {
	return tea.Prettify(s)
}

func (s AddDomainResponseBodyDnsServers) GoString() string {
	return s.String()
}

func (s *AddDomainResponseBodyDnsServers) SetDnsServer(v []*string) *AddDomainResponseBodyDnsServers {
	s.DnsServer = v
	return s
}

type AddDomainResponse struct {
	Headers    map[string]*string     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDomainResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDomainResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDomainResponse) GoString() string {
	return s.String()
}

func (s *AddDomainResponse) SetHeaders(v map[string]*string) *AddDomainResponse {
	s.Headers = v
	return s
}

func (s *AddDomainResponse) SetStatusCode(v int32) *AddDomainResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDomainResponse) SetBody(v *AddDomainResponseBody) *AddDomainResponse {
	s.Body = v
	return s
}

type AddDomainBackupRequest struct {
	// The domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// test.aliyun.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The backup cycle. Valid values:
	//
	// 	- DAY: backs up data on a daily basis.
	//
	// 	- HOUR: backs up data on an hourly basis.
	//
	// This parameter is required.
	//
	// example:
	//
	// HOUR
	PeriodType *string `json:"PeriodType,omitempty" xml:"PeriodType,omitempty"`
}

func (s AddDomainBackupRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDomainBackupRequest) GoString() string {
	return s.String()
}

func (s *AddDomainBackupRequest) SetDomainName(v string) *AddDomainBackupRequest {
	s.DomainName = &v
	return s
}

func (s *AddDomainBackupRequest) SetLang(v string) *AddDomainBackupRequest {
	s.Lang = &v
	return s
}

func (s *AddDomainBackupRequest) SetPeriodType(v string) *AddDomainBackupRequest {
	s.PeriodType = &v
	return s
}

type AddDomainBackupResponseBody struct {
	// The domain name.
	//
	// example:
	//
	// test.aliyun.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The backup cycle.
	//
	// example:
	//
	// DAY
	PeriodType *string `json:"PeriodType,omitempty" xml:"PeriodType,omitempty"`
	// The request ID.
	//
	// example:
	//
	// FD552816-FCC8-4832-B4A2-2DA0C2BA1688
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDomainBackupResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDomainBackupResponseBody) GoString() string {
	return s.String()
}

func (s *AddDomainBackupResponseBody) SetDomainName(v string) *AddDomainBackupResponseBody {
	s.DomainName = &v
	return s
}

func (s *AddDomainBackupResponseBody) SetPeriodType(v string) *AddDomainBackupResponseBody {
	s.PeriodType = &v
	return s
}

func (s *AddDomainBackupResponseBody) SetRequestId(v string) *AddDomainBackupResponseBody {
	s.RequestId = &v
	return s
}

type AddDomainBackupResponse struct {
	Headers    map[string]*string           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDomainBackupResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDomainBackupResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDomainBackupResponse) GoString() string {
	return s.String()
}

func (s *AddDomainBackupResponse) SetHeaders(v map[string]*string) *AddDomainBackupResponse {
	s.Headers = v
	return s
}

func (s *AddDomainBackupResponse) SetStatusCode(v int32) *AddDomainBackupResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDomainBackupResponse) SetBody(v *AddDomainBackupResponseBody) *AddDomainBackupResponse {
	s.Body = v
	return s
}

type AddDomainGroupRequest struct {
	// The name of the domain name group.
	//
	// This parameter is required.
	//
	// example:
	//
	// MyGroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s AddDomainGroupRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDomainGroupRequest) GoString() string {
	return s.String()
}

func (s *AddDomainGroupRequest) SetGroupName(v string) *AddDomainGroupRequest {
	s.GroupName = &v
	return s
}

func (s *AddDomainGroupRequest) SetLang(v string) *AddDomainGroupRequest {
	s.Lang = &v
	return s
}

type AddDomainGroupResponseBody struct {
	// The ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the domain name group.
	//
	// example:
	//
	// NewName
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDomainGroupResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDomainGroupResponseBody) GoString() string {
	return s.String()
}

func (s *AddDomainGroupResponseBody) SetGroupId(v string) *AddDomainGroupResponseBody {
	s.GroupId = &v
	return s
}

func (s *AddDomainGroupResponseBody) SetGroupName(v string) *AddDomainGroupResponseBody {
	s.GroupName = &v
	return s
}

func (s *AddDomainGroupResponseBody) SetRequestId(v string) *AddDomainGroupResponseBody {
	s.RequestId = &v
	return s
}

type AddDomainGroupResponse struct {
	Headers    map[string]*string          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDomainGroupResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDomainGroupResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDomainGroupResponse) GoString() string {
	return s.String()
}

func (s *AddDomainGroupResponse) SetHeaders(v map[string]*string) *AddDomainGroupResponse {
	s.Headers = v
	return s
}

func (s *AddDomainGroupResponse) SetStatusCode(v int32) *AddDomainGroupResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDomainGroupResponse) SetBody(v *AddDomainGroupResponseBody) *AddDomainGroupResponse {
	s.Body = v
	return s
}

type AddDomainRecordRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the content within the request and response. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English Default: **zh**
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The resolution line. Default value: **default**. For more information, see
	//
	// [DNS resolution lines](https://www.alibabacloud.com/help/zh/doc-detail/29807.htm).
	//
	// example:
	//
	// default
	Line *string `json:"Line,omitempty" xml:"Line,omitempty"`
	// The priority of the mail exchanger (MX) record. Valid values: `1 to 50`.
	//
	// This parameter is required if the type of the DNS record is MX. A smaller value indicates a higher priority.
	//
	// example:
	//
	// 1
	Priority *int64 `json:"Priority,omitempty" xml:"Priority,omitempty"`
	// The hostname.
	//
	// For example, to resolve @.example.com, you must set this parameter to an at sign (@). You cannot leave this parameter empty.
	//
	// This parameter is required.
	//
	// example:
	//
	// www
	RR *string `json:"RR,omitempty" xml:"RR,omitempty"`
	// The time to live (TTL) period of the Alibaba Cloud DNS (DNS) record. Default value: 600. Unit: seconds. For more information, see
	//
	// [TTL definition](https://www.alibabacloud.com/help/zh/doc-detail/29806.htm).
	//
	// example:
	//
	// 600
	TTL *int64 `json:"TTL,omitempty" xml:"TTL,omitempty"`
	// The type of the DNS record. For more information, see
	//
	// [DNS record types](https://www.alibabacloud.com/help/zh/doc-detail/29805.htm).
	//
	// This parameter is required.
	//
	// example:
	//
	// A
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 192.0.2.0
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
	// The value of the DNS record.
	//
	// This parameter is required.
	//
	// example:
	//
	// 192.0.2.254
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s AddDomainRecordRequest) String() string {
	return tea.Prettify(s)
}

func (s AddDomainRecordRequest) GoString() string {
	return s.String()
}

func (s *AddDomainRecordRequest) SetDomainName(v string) *AddDomainRecordRequest {
	s.DomainName = &v
	return s
}

func (s *AddDomainRecordRequest) SetLang(v string) *AddDomainRecordRequest {
	s.Lang = &v
	return s
}

func (s *AddDomainRecordRequest) SetLine(v string) *AddDomainRecordRequest {
	s.Line = &v
	return s
}

func (s *AddDomainRecordRequest) SetPriority(v int64) *AddDomainRecordRequest {
	s.Priority = &v
	return s
}

func (s *AddDomainRecordRequest) SetRR(v string) *AddDomainRecordRequest {
	s.RR = &v
	return s
}

func (s *AddDomainRecordRequest) SetTTL(v int64) *AddDomainRecordRequest {
	s.TTL = &v
	return s
}

func (s *AddDomainRecordRequest) SetType(v string) *AddDomainRecordRequest {
	s.Type = &v
	return s
}

func (s *AddDomainRecordRequest) SetUserClientIp(v string) *AddDomainRecordRequest {
	s.UserClientIp = &v
	return s
}

func (s *AddDomainRecordRequest) SetValue(v string) *AddDomainRecordRequest {
	s.Value = &v
	return s
}

type AddDomainRecordResponseBody struct {
	// The ID of the DNS record.
	//
	// example:
	//
	// 9999985
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddDomainRecordResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddDomainRecordResponseBody) GoString() string {
	return s.String()
}

func (s *AddDomainRecordResponseBody) SetRecordId(v string) *AddDomainRecordResponseBody {
	s.RecordId = &v
	return s
}

func (s *AddDomainRecordResponseBody) SetRequestId(v string) *AddDomainRecordResponseBody {
	s.RequestId = &v
	return s
}

type AddDomainRecordResponse struct {
	Headers    map[string]*string           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddDomainRecordResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddDomainRecordResponse) String() string {
	return tea.Prettify(s)
}

func (s AddDomainRecordResponse) GoString() string {
	return s.String()
}

func (s *AddDomainRecordResponse) SetHeaders(v map[string]*string) *AddDomainRecordResponse {
	s.Headers = v
	return s
}

func (s *AddDomainRecordResponse) SetStatusCode(v int32) *AddDomainRecordResponse {
	s.StatusCode = &v
	return s
}

func (s *AddDomainRecordResponse) SetBody(v *AddDomainRecordResponseBody) *AddDomainRecordResponse {
	s.Body = v
	return s
}

type AddGtmAccessStrategyRequest struct {
	// The line codes of access regions.
	//
	// This parameter is required.
	//
	// example:
	//
	// ["default", "drpeng"]
	AccessLines *string `json:"AccessLines,omitempty" xml:"AccessLines,omitempty"`
	// The ID of the default address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// hrsix
	DefaultAddrPoolId *string `json:"DefaultAddrPoolId,omitempty" xml:"DefaultAddrPoolId,omitempty"`
	// The ID of the failover address pool.
	//
	// If the failover address pool is not set, pass the **Empty*	- value.
	//
	// This parameter is required.
	//
	// example:
	//
	// hrsyw
	FailoverAddrPoolId *string `json:"FailoverAddrPoolId,omitempty" xml:"FailoverAddrPoolId,omitempty"`
	// The ID of the GTM instance for which you want to create an access policy.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The name of the access policy.
	//
	// This parameter is required.
	StrategyName *string `json:"StrategyName,omitempty" xml:"StrategyName,omitempty"`
}

func (s AddGtmAccessStrategyRequest) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAccessStrategyRequest) GoString() string {
	return s.String()
}

func (s *AddGtmAccessStrategyRequest) SetAccessLines(v string) *AddGtmAccessStrategyRequest {
	s.AccessLines = &v
	return s
}

func (s *AddGtmAccessStrategyRequest) SetDefaultAddrPoolId(v string) *AddGtmAccessStrategyRequest {
	s.DefaultAddrPoolId = &v
	return s
}

func (s *AddGtmAccessStrategyRequest) SetFailoverAddrPoolId(v string) *AddGtmAccessStrategyRequest {
	s.FailoverAddrPoolId = &v
	return s
}

func (s *AddGtmAccessStrategyRequest) SetInstanceId(v string) *AddGtmAccessStrategyRequest {
	s.InstanceId = &v
	return s
}

func (s *AddGtmAccessStrategyRequest) SetLang(v string) *AddGtmAccessStrategyRequest {
	s.Lang = &v
	return s
}

func (s *AddGtmAccessStrategyRequest) SetStrategyName(v string) *AddGtmAccessStrategyRequest {
	s.StrategyName = &v
	return s
}

type AddGtmAccessStrategyResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 29D0F8F8-5499-4F6C-9FDC-1EE13BF55925
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the access policy created.
	//
	// example:
	//
	// strategyid
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
}

func (s AddGtmAccessStrategyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAccessStrategyResponseBody) GoString() string {
	return s.String()
}

func (s *AddGtmAccessStrategyResponseBody) SetRequestId(v string) *AddGtmAccessStrategyResponseBody {
	s.RequestId = &v
	return s
}

func (s *AddGtmAccessStrategyResponseBody) SetStrategyId(v string) *AddGtmAccessStrategyResponseBody {
	s.StrategyId = &v
	return s
}

type AddGtmAccessStrategyResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddGtmAccessStrategyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddGtmAccessStrategyResponse) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAccessStrategyResponse) GoString() string {
	return s.String()
}

func (s *AddGtmAccessStrategyResponse) SetHeaders(v map[string]*string) *AddGtmAccessStrategyResponse {
	s.Headers = v
	return s
}

func (s *AddGtmAccessStrategyResponse) SetStatusCode(v int32) *AddGtmAccessStrategyResponse {
	s.StatusCode = &v
	return s
}

func (s *AddGtmAccessStrategyResponse) SetBody(v *AddGtmAccessStrategyResponseBody) *AddGtmAccessStrategyResponse {
	s.Body = v
	return s
}

type AddGtmAddressPoolRequest struct {
	// The address pools.
	//
	// This parameter is required.
	Addr []*AddGtmAddressPoolRequestAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Repeated"`
	// The number of consecutive failures.
	//
	// example:
	//
	// 2
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The ID of the GTM instance for which you want to create an address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// gtm-cn-xxxxxxx
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The health check interval. Unit: seconds. Set the value to 60.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The monitored nodes.
	IspCityNode []*AddGtmAddressPoolRequestIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
	// The language of the values of specific response parameters.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The minimum number of available addresses in the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// 2
	MinAvailableAddrNum *int32 `json:"MinAvailableAddrNum,omitempty" xml:"MinAvailableAddrNum,omitempty"`
	// The extended information. The required parameters vary based on the value of ProtocolType.
	//
	// When ProtocolType is set to HTTP or HTTPS:
	//
	// 	- port: the port that you want to check
	//
	// 	- failureRate: the failure rate
	//
	// 	- code: the return code. The health check result is deemed abnormal if the returned value is greater than the specified value. Valid values: 400 and 500.
	//
	// 	- host: the host settings
	//
	// 	- path: the URL path
	//
	// When ProtocolType is set to PING:
	//
	// 	- packetNum: the number of ping packets
	//
	// 	- packetLossRate: the packet loss rate
	//
	// 	- failureRate: the failure rate
	//
	// When ProtocolType is set to TCP:
	//
	// 	- port: the port that you want to check
	//
	// 	- failureRate: the failure rate
	//
	// example:
	//
	// {"host":"aliyun.com","port":80}
	MonitorExtendInfo *string `json:"MonitorExtendInfo,omitempty" xml:"MonitorExtendInfo,omitempty"`
	// Specifies whether to enable the health check. Valid values:
	//
	// 	- **OPEN**: enables the health check.
	//
	// 	- **CLOSE**: disables the health check. This is the default value.
	//
	// example:
	//
	// OPEN
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The name of the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// Alibaba Cloud cluster
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The health check protocol. Valid values:
	//
	// 	- HTTP
	//
	// 	- HTTPS
	//
	// 	- Ping
	//
	// 	- TCP
	//
	// example:
	//
	// HTTPS
	ProtocolType *string `json:"ProtocolType,omitempty" xml:"ProtocolType,omitempty"`
	// The timeout period. Unit: milliseconds. Valid values: 2000, 3000, 5000, and 10000.
	//
	// example:
	//
	// 60
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- **IP**: IPv4 address
	//
	// 	- **DOMAIN**: domain name
	//
	// This parameter is required.
	//
	// example:
	//
	// IP
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s AddGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *AddGtmAddressPoolRequest) SetAddr(v []*AddGtmAddressPoolRequestAddr) *AddGtmAddressPoolRequest {
	s.Addr = v
	return s
}

func (s *AddGtmAddressPoolRequest) SetEvaluationCount(v int32) *AddGtmAddressPoolRequest {
	s.EvaluationCount = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetInstanceId(v string) *AddGtmAddressPoolRequest {
	s.InstanceId = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetInterval(v int32) *AddGtmAddressPoolRequest {
	s.Interval = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetIspCityNode(v []*AddGtmAddressPoolRequestIspCityNode) *AddGtmAddressPoolRequest {
	s.IspCityNode = v
	return s
}

func (s *AddGtmAddressPoolRequest) SetLang(v string) *AddGtmAddressPoolRequest {
	s.Lang = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetMinAvailableAddrNum(v int32) *AddGtmAddressPoolRequest {
	s.MinAvailableAddrNum = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetMonitorExtendInfo(v string) *AddGtmAddressPoolRequest {
	s.MonitorExtendInfo = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetMonitorStatus(v string) *AddGtmAddressPoolRequest {
	s.MonitorStatus = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetName(v string) *AddGtmAddressPoolRequest {
	s.Name = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetProtocolType(v string) *AddGtmAddressPoolRequest {
	s.ProtocolType = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetTimeout(v int32) *AddGtmAddressPoolRequest {
	s.Timeout = &v
	return s
}

func (s *AddGtmAddressPoolRequest) SetType(v string) *AddGtmAddressPoolRequest {
	s.Type = &v
	return s
}

type AddGtmAddressPoolRequestAddr struct {
	// The weight of the address pool.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The mode of the address pool. Valid values:
	//
	// 	- **SMART**: smart return
	//
	// 	- **ONLINE**: always online
	//
	// 	- **OFFLINE**: always offline
	//
	// example:
	//
	// SMART
	Mode *string `json:"Mode,omitempty" xml:"Mode,omitempty"`
	// The address in the address pool.
	//
	// example:
	//
	// 1.1.1.1
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s AddGtmAddressPoolRequestAddr) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAddressPoolRequestAddr) GoString() string {
	return s.String()
}

func (s *AddGtmAddressPoolRequestAddr) SetLbaWeight(v int32) *AddGtmAddressPoolRequestAddr {
	s.LbaWeight = &v
	return s
}

func (s *AddGtmAddressPoolRequestAddr) SetMode(v string) *AddGtmAddressPoolRequestAddr {
	s.Mode = &v
	return s
}

func (s *AddGtmAddressPoolRequestAddr) SetValue(v string) *AddGtmAddressPoolRequestAddr {
	s.Value = &v
	return s
}

type AddGtmAddressPoolRequestIspCityNode struct {
	// The code of the city where the monitored node is deployed. For more information about specific values, see the response parameters of DescribeGtmMonitorAvailableConfig.
	//
	// example:
	//
	// 546
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// 	- The code of the Internet service provider (ISP) to which the monitored node belongs. For more information about specific values, see the response parameters of DescribeGtmMonitorAvailableConfig.
	//
	// 	- If the value of the GroupType parameter is BGP or OVERSEAS, IspCode is optional. The default value is 465.
	//
	// 	- If the value of the GroupType parameter is not BGP or OVERSEAS, IspCode is required and is used together with CityCode.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
}

func (s AddGtmAddressPoolRequestIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAddressPoolRequestIspCityNode) GoString() string {
	return s.String()
}

func (s *AddGtmAddressPoolRequestIspCityNode) SetCityCode(v string) *AddGtmAddressPoolRequestIspCityNode {
	s.CityCode = &v
	return s
}

func (s *AddGtmAddressPoolRequestIspCityNode) SetIspCode(v string) *AddGtmAddressPoolRequestIspCityNode {
	s.IspCode = &v
	return s
}

type AddGtmAddressPoolResponseBody struct {
	// The ID of the address pool created.
	//
	// example:
	//
	// hraf3x
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The ID of the health check configuration.
	//
	// example:
	//
	// hraf14
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *AddGtmAddressPoolResponseBody) SetAddrPoolId(v string) *AddGtmAddressPoolResponseBody {
	s.AddrPoolId = &v
	return s
}

func (s *AddGtmAddressPoolResponseBody) SetMonitorConfigId(v string) *AddGtmAddressPoolResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *AddGtmAddressPoolResponseBody) SetRequestId(v string) *AddGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

type AddGtmAddressPoolResponse struct {
	Headers    map[string]*string             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s AddGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *AddGtmAddressPoolResponse) SetHeaders(v map[string]*string) *AddGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *AddGtmAddressPoolResponse) SetStatusCode(v int32) *AddGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *AddGtmAddressPoolResponse) SetBody(v *AddGtmAddressPoolResponseBody) *AddGtmAddressPoolResponse {
	s.Body = v
	return s
}

type AddGtmMonitorRequest struct {
	// The ID of the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// xxxx
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The number of consecutive failures.
	//
	// This parameter is required.
	//
	// example:
	//
	// 3
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The health check interval. Unit: seconds. Set the value to 60.
	//
	// This parameter is required.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The nodes for monitoring.
	//
	// This parameter is required.
	IspCityNode []*AddGtmMonitorRequestIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The extended information. The required parameters vary based on the health check protocol.
	//
	// HTTP or HTTPS
	//
	// 	- port: the port that you want to check
	//
	// 	- failureRate: the failure rate
	//
	// 	- code: the return code. The health check result is deemed abnormal if the returned value is greater than the specified value. Valid values: 400 and 500.
	//
	// 	- host: the host settings
	//
	// 	- path: the URL path
	//
	// PING
	//
	// 	- packetNum: the number of ping packets
	//
	// 	- packetLossRate: the packet loss rate
	//
	// 	- failureRate: the failure rate
	//
	// TCP
	//
	// 	- port: the port that you want to check
	//
	// 	- failureRate: the failure rate
	//
	// This parameter is required.
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"/index.htm\\",\\"host\\":\\"aliyun.com\\"}
	MonitorExtendInfo *string `json:"MonitorExtendInfo,omitempty" xml:"MonitorExtendInfo,omitempty"`
	// The protocol used for the health check. Valid values:
	//
	// 	- HTTP
	//
	// 	- HTTPS
	//
	// 	- PING
	//
	// 	- TCP
	//
	// This parameter is required.
	//
	// example:
	//
	// HTTP
	ProtocolType *string `json:"ProtocolType,omitempty" xml:"ProtocolType,omitempty"`
	// The health check timeout period. Unit: milliseconds. Valid values: 2000, 3000, 5000, and 10000.
	//
	// This parameter is required.
	//
	// example:
	//
	// 3000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
}

func (s AddGtmMonitorRequest) String() string {
	return tea.Prettify(s)
}

func (s AddGtmMonitorRequest) GoString() string {
	return s.String()
}

func (s *AddGtmMonitorRequest) SetAddrPoolId(v string) *AddGtmMonitorRequest {
	s.AddrPoolId = &v
	return s
}

func (s *AddGtmMonitorRequest) SetEvaluationCount(v int32) *AddGtmMonitorRequest {
	s.EvaluationCount = &v
	return s
}

func (s *AddGtmMonitorRequest) SetInterval(v int32) *AddGtmMonitorRequest {
	s.Interval = &v
	return s
}

func (s *AddGtmMonitorRequest) SetIspCityNode(v []*AddGtmMonitorRequestIspCityNode) *AddGtmMonitorRequest {
	s.IspCityNode = v
	return s
}

func (s *AddGtmMonitorRequest) SetLang(v string) *AddGtmMonitorRequest {
	s.Lang = &v
	return s
}

func (s *AddGtmMonitorRequest) SetMonitorExtendInfo(v string) *AddGtmMonitorRequest {
	s.MonitorExtendInfo = &v
	return s
}

func (s *AddGtmMonitorRequest) SetProtocolType(v string) *AddGtmMonitorRequest {
	s.ProtocolType = &v
	return s
}

func (s *AddGtmMonitorRequest) SetTimeout(v int32) *AddGtmMonitorRequest {
	s.Timeout = &v
	return s
}

type AddGtmMonitorRequestIspCityNode struct {
	// The city code.
	//
	// Specify the parameter according to the value of CityCode returned by the DescribeGtmMonitorAvailableConfig operation.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The Internet service provider (ISP) node. Specify the parameter according to the value of IspCode returned by the DescribeGtmMonitorAvailableConfig operation.
	//
	// 	- If the return value of GroupType for the DescribeGtmMonitorAvailableConfig operation is BGP or Overseas, IspCode is not required and is set to 465 by default.
	//
	// 	- If the return value of GroupType for the DescribeGtmMonitorAvailableConfig operation is not BGP or Overseas, IspCode is required. When IspCode is specified, CityCode is required.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
}

func (s AddGtmMonitorRequestIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s AddGtmMonitorRequestIspCityNode) GoString() string {
	return s.String()
}

func (s *AddGtmMonitorRequestIspCityNode) SetCityCode(v string) *AddGtmMonitorRequestIspCityNode {
	s.CityCode = &v
	return s
}

func (s *AddGtmMonitorRequestIspCityNode) SetIspCode(v string) *AddGtmMonitorRequestIspCityNode {
	s.IspCode = &v
	return s
}

type AddGtmMonitorResponseBody struct {
	// The ID of the health check configuration.
	//
	// example:
	//
	// 1234abc
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddGtmMonitorResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddGtmMonitorResponseBody) GoString() string {
	return s.String()
}

func (s *AddGtmMonitorResponseBody) SetMonitorConfigId(v string) *AddGtmMonitorResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *AddGtmMonitorResponseBody) SetRequestId(v string) *AddGtmMonitorResponseBody {
	s.RequestId = &v
	return s
}

type AddGtmMonitorResponse struct {
	Headers    map[string]*string         `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                     `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddGtmMonitorResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddGtmMonitorResponse) String() string {
	return tea.Prettify(s)
}

func (s AddGtmMonitorResponse) GoString() string {
	return s.String()
}

func (s *AddGtmMonitorResponse) SetHeaders(v map[string]*string) *AddGtmMonitorResponse {
	s.Headers = v
	return s
}

func (s *AddGtmMonitorResponse) SetStatusCode(v int32) *AddGtmMonitorResponse {
	s.StatusCode = &v
	return s
}

func (s *AddGtmMonitorResponse) SetBody(v *AddGtmMonitorResponseBody) *AddGtmMonitorResponse {
	s.Body = v
	return s
}

type AddGtmRecoveryPlanRequest struct {
	// The IDs of faulty address pools.
	//
	// This parameter is required.
	//
	// example:
	//
	// ["hra0or"]
	FaultAddrPool *string `json:"FaultAddrPool,omitempty" xml:"FaultAddrPool,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The name of the disaster recovery plan.
	//
	// This parameter is required.
	//
	// example:
	//
	// name-example
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The description of the disaster recovery plan.
	//
	// example:
	//
	// remark
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
}

func (s AddGtmRecoveryPlanRequest) String() string {
	return tea.Prettify(s)
}

func (s AddGtmRecoveryPlanRequest) GoString() string {
	return s.String()
}

func (s *AddGtmRecoveryPlanRequest) SetFaultAddrPool(v string) *AddGtmRecoveryPlanRequest {
	s.FaultAddrPool = &v
	return s
}

func (s *AddGtmRecoveryPlanRequest) SetLang(v string) *AddGtmRecoveryPlanRequest {
	s.Lang = &v
	return s
}

func (s *AddGtmRecoveryPlanRequest) SetName(v string) *AddGtmRecoveryPlanRequest {
	s.Name = &v
	return s
}

func (s *AddGtmRecoveryPlanRequest) SetRemark(v string) *AddGtmRecoveryPlanRequest {
	s.Remark = &v
	return s
}

type AddGtmRecoveryPlanResponseBody struct {
	// The ID of the disaster recovery plan.
	//
	// example:
	//
	// 100
	RecoveryPlanId *string `json:"RecoveryPlanId,omitempty" xml:"RecoveryPlanId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s AddGtmRecoveryPlanResponseBody) String() string {
	return tea.Prettify(s)
}

func (s AddGtmRecoveryPlanResponseBody) GoString() string {
	return s.String()
}

func (s *AddGtmRecoveryPlanResponseBody) SetRecoveryPlanId(v string) *AddGtmRecoveryPlanResponseBody {
	s.RecoveryPlanId = &v
	return s
}

func (s *AddGtmRecoveryPlanResponseBody) SetRequestId(v string) *AddGtmRecoveryPlanResponseBody {
	s.RequestId = &v
	return s
}

type AddGtmRecoveryPlanResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *AddGtmRecoveryPlanResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s AddGtmRecoveryPlanResponse) String() string {
	return tea.Prettify(s)
}

func (s AddGtmRecoveryPlanResponse) GoString() string {
	return s.String()
}

func (s *AddGtmRecoveryPlanResponse) SetHeaders(v map[string]*string) *AddGtmRecoveryPlanResponse {
	s.Headers = v
	return s
}

func (s *AddGtmRecoveryPlanResponse) SetStatusCode(v int32) *AddGtmRecoveryPlanResponse {
	s.StatusCode = &v
	return s
}

func (s *AddGtmRecoveryPlanResponse) SetBody(v *AddGtmRecoveryPlanResponseBody) *AddGtmRecoveryPlanResponse {
	s.Body = v
	return s
}

type BindInstanceDomainsRequest struct {
	// The domain names.
	//
	// >  Separate multiple domain names with commas (,). Up to 100 domain names can be entered.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com,example.net
	DomainNames *string `json:"DomainNames,omitempty" xml:"DomainNames,omitempty"`
	// The instance ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// sdfasdf
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s BindInstanceDomainsRequest) String() string {
	return tea.Prettify(s)
}

func (s BindInstanceDomainsRequest) GoString() string {
	return s.String()
}

func (s *BindInstanceDomainsRequest) SetDomainNames(v string) *BindInstanceDomainsRequest {
	s.DomainNames = &v
	return s
}

func (s *BindInstanceDomainsRequest) SetInstanceId(v string) *BindInstanceDomainsRequest {
	s.InstanceId = &v
	return s
}

func (s *BindInstanceDomainsRequest) SetLang(v string) *BindInstanceDomainsRequest {
	s.Lang = &v
	return s
}

type BindInstanceDomainsResponseBody struct {
	// The number of domain names that failed to be bound to the instance.
	//
	// example:
	//
	// 0
	FailedCount *int32 `json:"FailedCount,omitempty" xml:"FailedCount,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The number of domain names that are bound to the instance.
	//
	// example:
	//
	// 2
	SuccessCount *int32 `json:"SuccessCount,omitempty" xml:"SuccessCount,omitempty"`
}

func (s BindInstanceDomainsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s BindInstanceDomainsResponseBody) GoString() string {
	return s.String()
}

func (s *BindInstanceDomainsResponseBody) SetFailedCount(v int32) *BindInstanceDomainsResponseBody {
	s.FailedCount = &v
	return s
}

func (s *BindInstanceDomainsResponseBody) SetRequestId(v string) *BindInstanceDomainsResponseBody {
	s.RequestId = &v
	return s
}

func (s *BindInstanceDomainsResponseBody) SetSuccessCount(v int32) *BindInstanceDomainsResponseBody {
	s.SuccessCount = &v
	return s
}

type BindInstanceDomainsResponse struct {
	Headers    map[string]*string               `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                           `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *BindInstanceDomainsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s BindInstanceDomainsResponse) String() string {
	return tea.Prettify(s)
}

func (s BindInstanceDomainsResponse) GoString() string {
	return s.String()
}

func (s *BindInstanceDomainsResponse) SetHeaders(v map[string]*string) *BindInstanceDomainsResponse {
	s.Headers = v
	return s
}

func (s *BindInstanceDomainsResponse) SetStatusCode(v int32) *BindInstanceDomainsResponse {
	s.StatusCode = &v
	return s
}

func (s *BindInstanceDomainsResponse) SetBody(v *BindInstanceDomainsResponseBody) *BindInstanceDomainsResponse {
	s.Body = v
	return s
}

type ChangeDomainGroupRequest struct {
	// The domain name. You can call the [DescribeDomains ](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0)operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the target domain name group.
	//
	// 	- If you do not specify GroupId, the domain name belongs to the default group.
	//
	// 	- If you specify an empty string "" for GroupId, the domain name belongs to the default group.
	//
	// 	- If you set GroupId to defaultGroup, the domain name belongs to the default group.
	//
	// 	- If you specify GroupId to another value and the value is verified existent, the value of GroupId for the target domain name is updated. If the value is verified inexistent, the value of GroupId for the target domain name is not updated.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s ChangeDomainGroupRequest) String() string {
	return tea.Prettify(s)
}

func (s ChangeDomainGroupRequest) GoString() string {
	return s.String()
}

func (s *ChangeDomainGroupRequest) SetDomainName(v string) *ChangeDomainGroupRequest {
	s.DomainName = &v
	return s
}

func (s *ChangeDomainGroupRequest) SetGroupId(v string) *ChangeDomainGroupRequest {
	s.GroupId = &v
	return s
}

func (s *ChangeDomainGroupRequest) SetLang(v string) *ChangeDomainGroupRequest {
	s.Lang = &v
	return s
}

type ChangeDomainGroupResponseBody struct {
	// The ID of the target domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the destination domain name group.
	//
	// example:
	//
	// MyGroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s ChangeDomainGroupResponseBody) String() string {
	return tea.Prettify(s)
}

func (s ChangeDomainGroupResponseBody) GoString() string {
	return s.String()
}

func (s *ChangeDomainGroupResponseBody) SetGroupId(v string) *ChangeDomainGroupResponseBody {
	s.GroupId = &v
	return s
}

func (s *ChangeDomainGroupResponseBody) SetGroupName(v string) *ChangeDomainGroupResponseBody {
	s.GroupName = &v
	return s
}

func (s *ChangeDomainGroupResponseBody) SetRequestId(v string) *ChangeDomainGroupResponseBody {
	s.RequestId = &v
	return s
}

type ChangeDomainGroupResponse struct {
	Headers    map[string]*string             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *ChangeDomainGroupResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s ChangeDomainGroupResponse) String() string {
	return tea.Prettify(s)
}

func (s ChangeDomainGroupResponse) GoString() string {
	return s.String()
}

func (s *ChangeDomainGroupResponse) SetHeaders(v map[string]*string) *ChangeDomainGroupResponse {
	s.Headers = v
	return s
}

func (s *ChangeDomainGroupResponse) SetStatusCode(v int32) *ChangeDomainGroupResponse {
	s.StatusCode = &v
	return s
}

func (s *ChangeDomainGroupResponse) SetBody(v *ChangeDomainGroupResponseBody) *ChangeDomainGroupResponse {
	s.Body = v
	return s
}

type ChangeDomainOfDnsProductRequest struct {
	// Specifies whether to forcibly bind a domain name to the instance. Valid values:
	//
	// 	- **false****: no**
	//
	// 	- **true**: **yes**
	//
	// Default value: **false**.
	//
	// example:
	//
	// false
	Force *bool `json:"Force,omitempty" xml:"Force,omitempty"`
	// The ID of the Alibaba Cloud Domain Name System (DNS) instance.
	//
	// You can call the [ListCloudGtmInstances ](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-listcloudgtminstances?spm=a2c63.p38356.help-menu-search-29697.d_0)operation to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// i-7sb
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language of the content within the request and response. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// Default value: **zh**.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The domain name that you want to bind to the instance. If you leave this parameter empty, the domain name that is bound to the instance is unbound from the instance.
	//
	// example:
	//
	// newdomain.com
	NewDomain *string `json:"NewDomain,omitempty" xml:"NewDomain,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 1.1.1.1
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
}

func (s ChangeDomainOfDnsProductRequest) String() string {
	return tea.Prettify(s)
}

func (s ChangeDomainOfDnsProductRequest) GoString() string {
	return s.String()
}

func (s *ChangeDomainOfDnsProductRequest) SetForce(v bool) *ChangeDomainOfDnsProductRequest {
	s.Force = &v
	return s
}

func (s *ChangeDomainOfDnsProductRequest) SetInstanceId(v string) *ChangeDomainOfDnsProductRequest {
	s.InstanceId = &v
	return s
}

func (s *ChangeDomainOfDnsProductRequest) SetLang(v string) *ChangeDomainOfDnsProductRequest {
	s.Lang = &v
	return s
}

func (s *ChangeDomainOfDnsProductRequest) SetNewDomain(v string) *ChangeDomainOfDnsProductRequest {
	s.NewDomain = &v
	return s
}

func (s *ChangeDomainOfDnsProductRequest) SetUserClientIp(v string) *ChangeDomainOfDnsProductRequest {
	s.UserClientIp = &v
	return s
}

type ChangeDomainOfDnsProductResponseBody struct {
	// The domain name that is originally bound to the instance. If no value is returned for this parameter, the instance is bound to a domain name for the first time.
	//
	// example:
	//
	// originaldomain.com
	OriginalDomain *string `json:"OriginalDomain,omitempty" xml:"OriginalDomain,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s ChangeDomainOfDnsProductResponseBody) String() string {
	return tea.Prettify(s)
}

func (s ChangeDomainOfDnsProductResponseBody) GoString() string {
	return s.String()
}

func (s *ChangeDomainOfDnsProductResponseBody) SetOriginalDomain(v string) *ChangeDomainOfDnsProductResponseBody {
	s.OriginalDomain = &v
	return s
}

func (s *ChangeDomainOfDnsProductResponseBody) SetRequestId(v string) *ChangeDomainOfDnsProductResponseBody {
	s.RequestId = &v
	return s
}

type ChangeDomainOfDnsProductResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *ChangeDomainOfDnsProductResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s ChangeDomainOfDnsProductResponse) String() string {
	return tea.Prettify(s)
}

func (s ChangeDomainOfDnsProductResponse) GoString() string {
	return s.String()
}

func (s *ChangeDomainOfDnsProductResponse) SetHeaders(v map[string]*string) *ChangeDomainOfDnsProductResponse {
	s.Headers = v
	return s
}

func (s *ChangeDomainOfDnsProductResponse) SetStatusCode(v int32) *ChangeDomainOfDnsProductResponse {
	s.StatusCode = &v
	return s
}

func (s *ChangeDomainOfDnsProductResponse) SetBody(v *ChangeDomainOfDnsProductResponseBody) *ChangeDomainOfDnsProductResponse {
	s.Body = v
	return s
}

type CopyGtmConfigRequest struct {
	// The type of the object that is copied. Only the INSTANCE type is supported.
	//
	// This parameter is required.
	//
	// example:
	//
	// INSTANCE
	CopyType *string `json:"CopyType,omitempty" xml:"CopyType,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the source object. Only instance IDs are supported.
	//
	// This parameter is required.
	//
	// example:
	//
	// gtm-cn-0pp1j84v60d
	SourceId *string `json:"SourceId,omitempty" xml:"SourceId,omitempty"`
	// The ID of the target object. Only instance IDs are supported.
	//
	// This parameter is required.
	//
	// example:
	//
	// gtm-cn-v0h1gaujg06
	TargetId *string `json:"TargetId,omitempty" xml:"TargetId,omitempty"`
}

func (s CopyGtmConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s CopyGtmConfigRequest) GoString() string {
	return s.String()
}

func (s *CopyGtmConfigRequest) SetCopyType(v string) *CopyGtmConfigRequest {
	s.CopyType = &v
	return s
}

func (s *CopyGtmConfigRequest) SetLang(v string) *CopyGtmConfigRequest {
	s.Lang = &v
	return s
}

func (s *CopyGtmConfigRequest) SetSourceId(v string) *CopyGtmConfigRequest {
	s.SourceId = &v
	return s
}

func (s *CopyGtmConfigRequest) SetTargetId(v string) *CopyGtmConfigRequest {
	s.TargetId = &v
	return s
}

type CopyGtmConfigResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// 389DFFA3-77A5-4A9E-BF3D-147C6F98A5BA
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s CopyGtmConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CopyGtmConfigResponseBody) GoString() string {
	return s.String()
}

func (s *CopyGtmConfigResponseBody) SetRequestId(v string) *CopyGtmConfigResponseBody {
	s.RequestId = &v
	return s
}

type CopyGtmConfigResponse struct {
	Headers    map[string]*string         `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                     `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CopyGtmConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CopyGtmConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s CopyGtmConfigResponse) GoString() string {
	return s.String()
}

func (s *CopyGtmConfigResponse) SetHeaders(v map[string]*string) *CopyGtmConfigResponse {
	s.Headers = v
	return s
}

func (s *CopyGtmConfigResponse) SetStatusCode(v int32) *CopyGtmConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *CopyGtmConfigResponse) SetBody(v *CopyGtmConfigResponseBody) *CopyGtmConfigResponse {
	s.Body = v
	return s
}

type CreateCloudGtmAddressRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// zh-CN
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// IP address or domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// 223.5.XX.XX
	Address *string `json:"Address,omitempty" xml:"Address,omitempty"`
	// Address ownership information.
	//
	// example:
	//
	// 当前版本不支持传入此参数，请不要传入参数。
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The failover mode that is used when address exceptions are identified. Valid values:
	//
	// 	- auto: the automatic mode. The system determines whether to return an address based on the health check results. If the address fails health checks, the system does not return the address. If the address passes health checks, the system returns the address.
	//
	// 	- manual: the manual mode. If an address is in the unavailable state, the address is not returned for DNS requests even if the address passes health checks. If an address is in the available state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// This parameter is required.
	//
	// example:
	//
	// auto
	AvailableMode *string `json:"AvailableMode,omitempty" xml:"AvailableMode,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// Indicates the current enabled status of the address:
	//
	// - enable: Enabled status
	//
	// - disable: Disabled status
	//
	// This parameter is required.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address. This parameter is required when HealthTasks is specified. Valid values:
	//
	// 	- any_ok: The health check results of at least one health check template are normal.
	//
	// 	- p30_ok: The health check results of at least 30% of health check templates are normal.
	//
	// 	- p50_ok: The health check results of at least 50% of health check templates are normal.
	//
	// 	- p70_ok: The health check results of at least 70% of health check templates are normal.
	//
	// 	- all_ok: The health check results of all health check templates are normal.
	//
	// This parameter is required.
	//
	// example:
	//
	// p50_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health check tasks associated with the address.
	HealthTasks []*CreateCloudGtmAddressRequestHealthTasks `json:"HealthTasks,omitempty" xml:"HealthTasks,omitempty" type:"Repeated"`
	// The availability state of the address. This parameter is required when AvailableMode is set to **manual**. Valid values:
	//
	// 	- available: The address is normal. In this state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// 	- unavailable: The address is abnormal. In this state, the address is not returned for DNS requests even if the address passes health checks.
	//
	// example:
	//
	// available
	ManualAvailableStatus *string `json:"ManualAvailableStatus,omitempty" xml:"ManualAvailableStatus,omitempty"`
	// Address name.
	//
	// This parameter is required.
	//
	// example:
	//
	// Address-1
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// Remarks.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Address type:
	//
	// - IPv4
	//
	// - IPv6
	//
	// - domain
	//
	// This parameter is required.
	//
	// example:
	//
	// IPv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s CreateCloudGtmAddressRequest) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressRequest) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressRequest) SetAcceptLanguage(v string) *CreateCloudGtmAddressRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetAddress(v string) *CreateCloudGtmAddressRequest {
	s.Address = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetAttributeInfo(v string) *CreateCloudGtmAddressRequest {
	s.AttributeInfo = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetAvailableMode(v string) *CreateCloudGtmAddressRequest {
	s.AvailableMode = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetClientToken(v string) *CreateCloudGtmAddressRequest {
	s.ClientToken = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetEnableStatus(v string) *CreateCloudGtmAddressRequest {
	s.EnableStatus = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetHealthJudgement(v string) *CreateCloudGtmAddressRequest {
	s.HealthJudgement = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetHealthTasks(v []*CreateCloudGtmAddressRequestHealthTasks) *CreateCloudGtmAddressRequest {
	s.HealthTasks = v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetManualAvailableStatus(v string) *CreateCloudGtmAddressRequest {
	s.ManualAvailableStatus = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetName(v string) *CreateCloudGtmAddressRequest {
	s.Name = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetRemark(v string) *CreateCloudGtmAddressRequest {
	s.Remark = &v
	return s
}

func (s *CreateCloudGtmAddressRequest) SetType(v string) *CreateCloudGtmAddressRequest {
	s.Type = &v
	return s
}

type CreateCloudGtmAddressRequestHealthTasks struct {
	// The service port of the address on which health check tasks are performed. If the ping protocol is used for health checks, the configuration of the service port is not supported.
	//
	// example:
	//
	// 80
	Port *int32 `json:"Port,omitempty" xml:"Port,omitempty"`
	// The ID of the health check template associated with the address.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
}

func (s CreateCloudGtmAddressRequestHealthTasks) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressRequestHealthTasks) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressRequestHealthTasks) SetPort(v int32) *CreateCloudGtmAddressRequestHealthTasks {
	s.Port = &v
	return s
}

func (s *CreateCloudGtmAddressRequestHealthTasks) SetTemplateId(v string) *CreateCloudGtmAddressRequestHealthTasks {
	s.TemplateId = &v
	return s
}

type CreateCloudGtmAddressShrinkRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// zh-CN
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// IP address or domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// 223.5.XX.XX
	Address *string `json:"Address,omitempty" xml:"Address,omitempty"`
	// Address ownership information.
	//
	// example:
	//
	// 当前版本不支持传入此参数，请不要传入参数。
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The failover mode that is used when address exceptions are identified. Valid values:
	//
	// 	- auto: the automatic mode. The system determines whether to return an address based on the health check results. If the address fails health checks, the system does not return the address. If the address passes health checks, the system returns the address.
	//
	// 	- manual: the manual mode. If an address is in the unavailable state, the address is not returned for DNS requests even if the address passes health checks. If an address is in the available state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// This parameter is required.
	//
	// example:
	//
	// auto
	AvailableMode *string `json:"AvailableMode,omitempty" xml:"AvailableMode,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// Indicates the current enabled status of the address:
	//
	// - enable: Enabled status
	//
	// - disable: Disabled status
	//
	// This parameter is required.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address. This parameter is required when HealthTasks is specified. Valid values:
	//
	// 	- any_ok: The health check results of at least one health check template are normal.
	//
	// 	- p30_ok: The health check results of at least 30% of health check templates are normal.
	//
	// 	- p50_ok: The health check results of at least 50% of health check templates are normal.
	//
	// 	- p70_ok: The health check results of at least 70% of health check templates are normal.
	//
	// 	- all_ok: The health check results of all health check templates are normal.
	//
	// This parameter is required.
	//
	// example:
	//
	// p50_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health check tasks associated with the address.
	HealthTasksShrink *string `json:"HealthTasks,omitempty" xml:"HealthTasks,omitempty"`
	// The availability state of the address. This parameter is required when AvailableMode is set to **manual**. Valid values:
	//
	// 	- available: The address is normal. In this state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// 	- unavailable: The address is abnormal. In this state, the address is not returned for DNS requests even if the address passes health checks.
	//
	// example:
	//
	// available
	ManualAvailableStatus *string `json:"ManualAvailableStatus,omitempty" xml:"ManualAvailableStatus,omitempty"`
	// Address name.
	//
	// This parameter is required.
	//
	// example:
	//
	// Address-1
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// Remarks.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Address type:
	//
	// - IPv4
	//
	// - IPv6
	//
	// - domain
	//
	// This parameter is required.
	//
	// example:
	//
	// IPv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s CreateCloudGtmAddressShrinkRequest) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressShrinkRequest) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressShrinkRequest) SetAcceptLanguage(v string) *CreateCloudGtmAddressShrinkRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetAddress(v string) *CreateCloudGtmAddressShrinkRequest {
	s.Address = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetAttributeInfo(v string) *CreateCloudGtmAddressShrinkRequest {
	s.AttributeInfo = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetAvailableMode(v string) *CreateCloudGtmAddressShrinkRequest {
	s.AvailableMode = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetClientToken(v string) *CreateCloudGtmAddressShrinkRequest {
	s.ClientToken = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetEnableStatus(v string) *CreateCloudGtmAddressShrinkRequest {
	s.EnableStatus = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetHealthJudgement(v string) *CreateCloudGtmAddressShrinkRequest {
	s.HealthJudgement = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetHealthTasksShrink(v string) *CreateCloudGtmAddressShrinkRequest {
	s.HealthTasksShrink = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetManualAvailableStatus(v string) *CreateCloudGtmAddressShrinkRequest {
	s.ManualAvailableStatus = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetName(v string) *CreateCloudGtmAddressShrinkRequest {
	s.Name = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetRemark(v string) *CreateCloudGtmAddressShrinkRequest {
	s.Remark = &v
	return s
}

func (s *CreateCloudGtmAddressShrinkRequest) SetType(v string) *CreateCloudGtmAddressShrinkRequest {
	s.Type = &v
	return s
}

type CreateCloudGtmAddressResponseBody struct {
	// The address ID. This ID uniquely identifies the address.
	//
	// example:
	//
	// addr-8951821811436**192
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// 46973D4C-E3E4-4ABA-9190-9A9DE406C7E
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the address creation operation is successful:
	//
	// - true: Operation was successful
	//
	// - false: Operation was failed
	//
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s CreateCloudGtmAddressResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressResponseBody) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressResponseBody) SetAddressId(v string) *CreateCloudGtmAddressResponseBody {
	s.AddressId = &v
	return s
}

func (s *CreateCloudGtmAddressResponseBody) SetRequestId(v string) *CreateCloudGtmAddressResponseBody {
	s.RequestId = &v
	return s
}

func (s *CreateCloudGtmAddressResponseBody) SetSuccess(v bool) *CreateCloudGtmAddressResponseBody {
	s.Success = &v
	return s
}

type CreateCloudGtmAddressResponse struct {
	Headers    map[string]*string                 `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                             `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CreateCloudGtmAddressResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CreateCloudGtmAddressResponse) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressResponse) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressResponse) SetHeaders(v map[string]*string) *CreateCloudGtmAddressResponse {
	s.Headers = v
	return s
}

func (s *CreateCloudGtmAddressResponse) SetStatusCode(v int32) *CreateCloudGtmAddressResponse {
	s.StatusCode = &v
	return s
}

func (s *CreateCloudGtmAddressResponse) SetBody(v *CreateCloudGtmAddressResponseBody) *CreateCloudGtmAddressResponse {
	s.Body = v
	return s
}

type CreateCloudGtmAddressPoolRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// Address pool name, helping users distinguish the purpose of address pools.
	//
	// example:
	//
	// Address pool-1
	AddressPoolName *string `json:"AddressPoolName,omitempty" xml:"AddressPoolName,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- IPv4: IPv4 addresses are returned for Domain Name System (DNS) resolution.
	//
	// 	- IPv6: IPv6 addresses are returned for DNS resolution.
	//
	// 	- domain: Domain names are returned for DNS resolution.
	//
	// example:
	//
	// IPv4
	AddressPoolType *string `json:"AddressPoolType,omitempty" xml:"AddressPoolType,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// The enabling state of the address pool. Valid values:
	//
	// 	- enable: The address pool is enabled, and the addresses in the address pool are returned for DNS resolution when the health check results are normal.
	//
	// 	- disable: The address pool is disabled, and the addresses in the address pool are not returned for DNS resolution regardless of whether the health check results are normal or not.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address pool. Valid values:
	//
	// 	- any_ok: At least one address in the address pool is available.
	//
	// 	- p30_ok: At least 30% of the addresses in the address pool are available.
	//
	// 	- p50_ok: At least 50% of the addresses in the address pool are available.
	//
	// 	- p70_ok: At least 70% of the addresses in the address pool are available.
	//
	// 	- all_ok: All addresses in the address pool are available.
	//
	// example:
	//
	// any_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// Remarks for the address pool, helping users distinguish the usage scenarios of different address pools.
	//
	// example:
	//
	// app
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
}

func (s CreateCloudGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressPoolRequest) SetAcceptLanguage(v string) *CreateCloudGtmAddressPoolRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *CreateCloudGtmAddressPoolRequest) SetAddressPoolName(v string) *CreateCloudGtmAddressPoolRequest {
	s.AddressPoolName = &v
	return s
}

func (s *CreateCloudGtmAddressPoolRequest) SetAddressPoolType(v string) *CreateCloudGtmAddressPoolRequest {
	s.AddressPoolType = &v
	return s
}

func (s *CreateCloudGtmAddressPoolRequest) SetClientToken(v string) *CreateCloudGtmAddressPoolRequest {
	s.ClientToken = &v
	return s
}

func (s *CreateCloudGtmAddressPoolRequest) SetEnableStatus(v string) *CreateCloudGtmAddressPoolRequest {
	s.EnableStatus = &v
	return s
}

func (s *CreateCloudGtmAddressPoolRequest) SetHealthJudgement(v string) *CreateCloudGtmAddressPoolRequest {
	s.HealthJudgement = &v
	return s
}

func (s *CreateCloudGtmAddressPoolRequest) SetRemark(v string) *CreateCloudGtmAddressPoolRequest {
	s.Remark = &v
	return s
}

type CreateCloudGtmAddressPoolResponseBody struct {
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89528023225442**16
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// 46973D4C-E3E4-4ABA-9190-9A9DE406C7E
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the address pool creation operation was successful:
	//
	// - true: Operation was successful
	//
	// - false: Operation was failed
	//
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s CreateCloudGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressPoolResponseBody) SetAddressPoolId(v string) *CreateCloudGtmAddressPoolResponseBody {
	s.AddressPoolId = &v
	return s
}

func (s *CreateCloudGtmAddressPoolResponseBody) SetRequestId(v string) *CreateCloudGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

func (s *CreateCloudGtmAddressPoolResponseBody) SetSuccess(v bool) *CreateCloudGtmAddressPoolResponseBody {
	s.Success = &v
	return s
}

type CreateCloudGtmAddressPoolResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CreateCloudGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CreateCloudGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmAddressPoolResponse) SetHeaders(v map[string]*string) *CreateCloudGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *CreateCloudGtmAddressPoolResponse) SetStatusCode(v int32) *CreateCloudGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *CreateCloudGtmAddressPoolResponse) SetBody(v *CreateCloudGtmAddressPoolResponseBody) *CreateCloudGtmAddressPoolResponse {
	s.Body = v
	return s
}

type CreateCloudGtmInstanceConfigRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US: English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can specify a custom value for this parameter, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// The enabling state of the access domain name. Valid values:
	//
	// 	- enable: The access domain name is enabled and the intelligent scheduling policy of the corresponding GTM instance takes effect.
	//
	// 	- disable: The access domain name is disabled and the intelligent scheduling policy of the corresponding GTM instance is unavailable.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The ID of the Global Traffic Manager (GTM) 3.0 instance. This ID uniquely identifies a GTM 3.0 instance.
	//
	// example:
	//
	// gtm-cn-jmp3qnw**03
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The description of the access domain name.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The hostname of the access domain name.
	//
	// example:
	//
	// www
	ScheduleHostname *string `json:"ScheduleHostname,omitempty" xml:"ScheduleHostname,omitempty"`
	// The type of the Domain Name System (DNS) record configured for the access domain name. Valid values:
	//
	// 	- A: IPv4 address
	//
	// 	- AAAA: IPv6 address
	//
	// 	- CNAME: domain name
	//
	// example:
	//
	// A
	ScheduleRrType *string `json:"ScheduleRrType,omitempty" xml:"ScheduleRrType,omitempty"`
	// The configuration mode of the access domain name. Valid values:
	//
	// 	- sys_assign: system allocation. This mode is not supported.
	//
	// 	- custom: custom allocation. You must select a zone within the account to which the instance belongs and enter a hostname to generate an access domain name.
	//
	// example:
	//
	// custom
	ScheduleZoneMode *string `json:"ScheduleZoneMode,omitempty" xml:"ScheduleZoneMode,omitempty"`
	// The name of the parent zone for the access domain name configured in GTM. In most cases, the value of this parameter is the name of a zone hosted by Alibaba Cloud DNS. This zone belongs to the account to which the GTM instance belongs. You can specify the name of a zone or subzone.
	//
	// example:
	//
	// example.com
	ScheduleZoneName *string `json:"ScheduleZoneName,omitempty" xml:"ScheduleZoneName,omitempty"`
	// The global time to live (TTL) period. Unit: seconds. The global TTL period affects how long the DNS records that map the access domain name to the addresses in the address pools are cached in the local DNS servers of Internet service providers (ISPs). You can specify a custom value.
	//
	// example:
	//
	// 30
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
}

func (s CreateCloudGtmInstanceConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmInstanceConfigRequest) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmInstanceConfigRequest) SetAcceptLanguage(v string) *CreateCloudGtmInstanceConfigRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetClientToken(v string) *CreateCloudGtmInstanceConfigRequest {
	s.ClientToken = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetEnableStatus(v string) *CreateCloudGtmInstanceConfigRequest {
	s.EnableStatus = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetInstanceId(v string) *CreateCloudGtmInstanceConfigRequest {
	s.InstanceId = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetRemark(v string) *CreateCloudGtmInstanceConfigRequest {
	s.Remark = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetScheduleHostname(v string) *CreateCloudGtmInstanceConfigRequest {
	s.ScheduleHostname = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetScheduleRrType(v string) *CreateCloudGtmInstanceConfigRequest {
	s.ScheduleRrType = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetScheduleZoneMode(v string) *CreateCloudGtmInstanceConfigRequest {
	s.ScheduleZoneMode = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetScheduleZoneName(v string) *CreateCloudGtmInstanceConfigRequest {
	s.ScheduleZoneName = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigRequest) SetTtl(v int32) *CreateCloudGtmInstanceConfigRequest {
	s.Ttl = &v
	return s
}

type CreateCloudGtmInstanceConfigResponseBody struct {
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// example:
	//
	// config-000**1
	ConfigId *bool `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the request was successful. Valid values:
	//
	// 	- true
	//
	// 	- false
	//
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s CreateCloudGtmInstanceConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmInstanceConfigResponseBody) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmInstanceConfigResponseBody) SetConfigId(v bool) *CreateCloudGtmInstanceConfigResponseBody {
	s.ConfigId = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigResponseBody) SetRequestId(v string) *CreateCloudGtmInstanceConfigResponseBody {
	s.RequestId = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigResponseBody) SetSuccess(v bool) *CreateCloudGtmInstanceConfigResponseBody {
	s.Success = &v
	return s
}

type CreateCloudGtmInstanceConfigResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CreateCloudGtmInstanceConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CreateCloudGtmInstanceConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmInstanceConfigResponse) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmInstanceConfigResponse) SetHeaders(v map[string]*string) *CreateCloudGtmInstanceConfigResponse {
	s.Headers = v
	return s
}

func (s *CreateCloudGtmInstanceConfigResponse) SetStatusCode(v int32) *CreateCloudGtmInstanceConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *CreateCloudGtmInstanceConfigResponse) SetBody(v *CreateCloudGtmInstanceConfigResponseBody) *CreateCloudGtmInstanceConfigResponse {
	s.Body = v
	return s
}

type CreateCloudGtmMonitorTemplateRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can specify a custom value for this parameter, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 2
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The extended information. The value of this parameter is a JSON string. The required parameters vary based on the health check protocol.
	//
	// 	- HTTP or HTTPS:
	//
	//     **host**: the Host field of an HTTP or HTTPS request header during an HTTP or HTTPS health check. The parameter value indicates the HTTP website that you want to visit. By default, the value is the primary domain name. You can change the value based on your business requirements.
	//
	//     **path**: the URL for HTTP or HTTPS health checks. Default value: /.
	//
	//     **code**: the alert threshold. During an HTTP or HTTPS health check, the system checks whether a web server functions as expected based on the status code that is returned from the web server. If the returned status code is greater than the specified threshold, the corresponding application service address is deemed abnormal. Valid values:
	//
	//     	- 400: specifies an invalid request. If an HTTP or HTTPS request contains invalid request parameters, a web server returns a status code that is greater than 400. You must set path to an exact URL if you set code to 400.
	//
	//     	- 500: specifies a server error. If some exceptions occur on a web server, the web server returns a status code that is greater than 500. This value is used by default.
	//
	//     **sni**: specifies whether to enable Server Name Indication (SNI). This parameter is used only when the health check protocol is HTTPS. SNI is an extension to the Transport Layer Security (TLS) protocol, which allows a client to specify the host to be connected when the client sends a TLS handshake request. TLS handshakes occur before any data of HTTP requests is sent. Therefore, SNI enables servers to identify the services that clients are attempting to access before certificates are sent. This allows the servers to present correct certificates to the clients. Valid values:
	//
	//     	- true: enables SNI.
	//
	//     	- false: disables SNI.
	//
	//     **followRedirect**: specifies whether to follow 3XX redirects. Valid values:
	//
	//     	- true: follows 3XX redirects. You are redirected to the destination address if a 3XX status code such as 301, 302, 303, 307, or 308 is returned.
	//
	//     	- false: does not follow 3XX redirects.
	//
	// 	- ping:
	//
	//     **packetNum**: the total number of Internet Control Message Protocol (ICMP) packets that are sent to the address for each ping-based health check. Valid values: 20, 50, and 100.
	//
	//     **packetLossRate**: the ICMP packet loss rate for each ping-based health check. The packet loss rate in a health check can be calculated by using the following formula: Packet loss rate in a health check = (Number of lost packets/Total number of sent ICMP packets) × 100%. If the packet loss rate reaches the threshold, an alert is triggered. Valid values: 10, 30, 40, 80, 90, and 100.
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	ExtendInfo *string `json:"ExtendInfo,omitempty" xml:"ExtendInfo,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 50
	FailureRate *int32 `json:"FailureRate,omitempty" xml:"FailureRate,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The IP address type of health check nodes. Valid values:
	//
	// 	- IPv4: You can set IpVersion to IPv4 to perform health checks on IPv4 addresses.
	//
	// 	- IPv6: You can set IpVersion to IPv6 to perform health checks on IPv6 addresses.
	//
	// This parameter is required.
	//
	// example:
	//
	// IPv4
	IpVersion *string `json:"IpVersion,omitempty" xml:"IpVersion,omitempty"`
	// The health check nodes. You can call the [ListCloudGtmMonitorNodes](~~ListCloudGtmMonitorNodes~~) operation to obtain the health check nodes.
	//
	// This parameter is required.
	IspCityNodes []*CreateCloudGtmMonitorTemplateRequestIspCityNodes `json:"IspCityNodes,omitempty" xml:"IspCityNodes,omitempty" type:"Repeated"`
	// The name of the health check template. We recommend that you use a name that distinguishes the type of health check protocol used.
	//
	// This parameter is required.
	//
	// example:
	//
	// Ping-IPv4
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// ping
	Protocol *string `json:"Protocol,omitempty" xml:"Protocol,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 5000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
}

func (s CreateCloudGtmMonitorTemplateRequest) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmMonitorTemplateRequest) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetAcceptLanguage(v string) *CreateCloudGtmMonitorTemplateRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetClientToken(v string) *CreateCloudGtmMonitorTemplateRequest {
	s.ClientToken = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetEvaluationCount(v int32) *CreateCloudGtmMonitorTemplateRequest {
	s.EvaluationCount = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetExtendInfo(v string) *CreateCloudGtmMonitorTemplateRequest {
	s.ExtendInfo = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetFailureRate(v int32) *CreateCloudGtmMonitorTemplateRequest {
	s.FailureRate = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetInterval(v int32) *CreateCloudGtmMonitorTemplateRequest {
	s.Interval = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetIpVersion(v string) *CreateCloudGtmMonitorTemplateRequest {
	s.IpVersion = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetIspCityNodes(v []*CreateCloudGtmMonitorTemplateRequestIspCityNodes) *CreateCloudGtmMonitorTemplateRequest {
	s.IspCityNodes = v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetName(v string) *CreateCloudGtmMonitorTemplateRequest {
	s.Name = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetProtocol(v string) *CreateCloudGtmMonitorTemplateRequest {
	s.Protocol = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequest) SetTimeout(v int32) *CreateCloudGtmMonitorTemplateRequest {
	s.Timeout = &v
	return s
}

type CreateCloudGtmMonitorTemplateRequestIspCityNodes struct {
	// The city code of the health check node.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The Internet service provider (ISP) code of the health check node.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
}

func (s CreateCloudGtmMonitorTemplateRequestIspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmMonitorTemplateRequestIspCityNodes) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmMonitorTemplateRequestIspCityNodes) SetCityCode(v string) *CreateCloudGtmMonitorTemplateRequestIspCityNodes {
	s.CityCode = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateRequestIspCityNodes) SetIspCode(v string) *CreateCloudGtmMonitorTemplateRequestIspCityNodes {
	s.IspCode = &v
	return s
}

type CreateCloudGtmMonitorTemplateShrinkRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can specify a custom value for this parameter, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 2
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The extended information. The value of this parameter is a JSON string. The required parameters vary based on the health check protocol.
	//
	// 	- HTTP or HTTPS:
	//
	//     **host**: the Host field of an HTTP or HTTPS request header during an HTTP or HTTPS health check. The parameter value indicates the HTTP website that you want to visit. By default, the value is the primary domain name. You can change the value based on your business requirements.
	//
	//     **path**: the URL for HTTP or HTTPS health checks. Default value: /.
	//
	//     **code**: the alert threshold. During an HTTP or HTTPS health check, the system checks whether a web server functions as expected based on the status code that is returned from the web server. If the returned status code is greater than the specified threshold, the corresponding application service address is deemed abnormal. Valid values:
	//
	//     	- 400: specifies an invalid request. If an HTTP or HTTPS request contains invalid request parameters, a web server returns a status code that is greater than 400. You must set path to an exact URL if you set code to 400.
	//
	//     	- 500: specifies a server error. If some exceptions occur on a web server, the web server returns a status code that is greater than 500. This value is used by default.
	//
	//     **sni**: specifies whether to enable Server Name Indication (SNI). This parameter is used only when the health check protocol is HTTPS. SNI is an extension to the Transport Layer Security (TLS) protocol, which allows a client to specify the host to be connected when the client sends a TLS handshake request. TLS handshakes occur before any data of HTTP requests is sent. Therefore, SNI enables servers to identify the services that clients are attempting to access before certificates are sent. This allows the servers to present correct certificates to the clients. Valid values:
	//
	//     	- true: enables SNI.
	//
	//     	- false: disables SNI.
	//
	//     **followRedirect**: specifies whether to follow 3XX redirects. Valid values:
	//
	//     	- true: follows 3XX redirects. You are redirected to the destination address if a 3XX status code such as 301, 302, 303, 307, or 308 is returned.
	//
	//     	- false: does not follow 3XX redirects.
	//
	// 	- ping:
	//
	//     **packetNum**: the total number of Internet Control Message Protocol (ICMP) packets that are sent to the address for each ping-based health check. Valid values: 20, 50, and 100.
	//
	//     **packetLossRate**: the ICMP packet loss rate for each ping-based health check. The packet loss rate in a health check can be calculated by using the following formula: Packet loss rate in a health check = (Number of lost packets/Total number of sent ICMP packets) × 100%. If the packet loss rate reaches the threshold, an alert is triggered. Valid values: 10, 30, 40, 80, 90, and 100.
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	ExtendInfo *string `json:"ExtendInfo,omitempty" xml:"ExtendInfo,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 50
	FailureRate *int32 `json:"FailureRate,omitempty" xml:"FailureRate,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The IP address type of health check nodes. Valid values:
	//
	// 	- IPv4: You can set IpVersion to IPv4 to perform health checks on IPv4 addresses.
	//
	// 	- IPv6: You can set IpVersion to IPv6 to perform health checks on IPv6 addresses.
	//
	// This parameter is required.
	//
	// example:
	//
	// IPv4
	IpVersion *string `json:"IpVersion,omitempty" xml:"IpVersion,omitempty"`
	// The health check nodes. You can call the [ListCloudGtmMonitorNodes](~~ListCloudGtmMonitorNodes~~) operation to obtain the health check nodes.
	//
	// This parameter is required.
	IspCityNodesShrink *string `json:"IspCityNodes,omitempty" xml:"IspCityNodes,omitempty"`
	// The name of the health check template. We recommend that you use a name that distinguishes the type of health check protocol used.
	//
	// This parameter is required.
	//
	// example:
	//
	// Ping-IPv4
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// ping
	Protocol *string `json:"Protocol,omitempty" xml:"Protocol,omitempty"`
	// This parameter is required.
	//
	// example:
	//
	// 5000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
}

func (s CreateCloudGtmMonitorTemplateShrinkRequest) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmMonitorTemplateShrinkRequest) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetAcceptLanguage(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetClientToken(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.ClientToken = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetEvaluationCount(v int32) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.EvaluationCount = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetExtendInfo(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.ExtendInfo = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetFailureRate(v int32) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.FailureRate = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetInterval(v int32) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.Interval = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetIpVersion(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.IpVersion = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetIspCityNodesShrink(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.IspCityNodesShrink = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetName(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.Name = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetProtocol(v string) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.Protocol = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateShrinkRequest) SetTimeout(v int32) *CreateCloudGtmMonitorTemplateShrinkRequest {
	s.Timeout = &v
	return s
}

type CreateCloudGtmMonitorTemplateResponseBody struct {
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
	// The ID of the health check template. This ID uniquely identifies the health check template.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
}

func (s CreateCloudGtmMonitorTemplateResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmMonitorTemplateResponseBody) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmMonitorTemplateResponseBody) SetRequestId(v string) *CreateCloudGtmMonitorTemplateResponseBody {
	s.RequestId = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateResponseBody) SetSuccess(v bool) *CreateCloudGtmMonitorTemplateResponseBody {
	s.Success = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateResponseBody) SetTemplateId(v string) *CreateCloudGtmMonitorTemplateResponseBody {
	s.TemplateId = &v
	return s
}

type CreateCloudGtmMonitorTemplateResponse struct {
	Headers    map[string]*string                         `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                     `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CreateCloudGtmMonitorTemplateResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CreateCloudGtmMonitorTemplateResponse) String() string {
	return tea.Prettify(s)
}

func (s CreateCloudGtmMonitorTemplateResponse) GoString() string {
	return s.String()
}

func (s *CreateCloudGtmMonitorTemplateResponse) SetHeaders(v map[string]*string) *CreateCloudGtmMonitorTemplateResponse {
	s.Headers = v
	return s
}

func (s *CreateCloudGtmMonitorTemplateResponse) SetStatusCode(v int32) *CreateCloudGtmMonitorTemplateResponse {
	s.StatusCode = &v
	return s
}

func (s *CreateCloudGtmMonitorTemplateResponse) SetBody(v *CreateCloudGtmMonitorTemplateResponseBody) *CreateCloudGtmMonitorTemplateResponse {
	s.Body = v
	return s
}

type CreatePdnsAppKeyRequest struct {
	Lang   *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
}

func (s CreatePdnsAppKeyRequest) String() string {
	return tea.Prettify(s)
}

func (s CreatePdnsAppKeyRequest) GoString() string {
	return s.String()
}

func (s *CreatePdnsAppKeyRequest) SetLang(v string) *CreatePdnsAppKeyRequest {
	s.Lang = &v
	return s
}

func (s *CreatePdnsAppKeyRequest) SetRemark(v string) *CreatePdnsAppKeyRequest {
	s.Remark = &v
	return s
}

type CreatePdnsAppKeyResponseBody struct {
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s CreatePdnsAppKeyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CreatePdnsAppKeyResponseBody) GoString() string {
	return s.String()
}

func (s *CreatePdnsAppKeyResponseBody) SetRequestId(v string) *CreatePdnsAppKeyResponseBody {
	s.RequestId = &v
	return s
}

type CreatePdnsAppKeyResponse struct {
	Headers    map[string]*string            `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                        `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CreatePdnsAppKeyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CreatePdnsAppKeyResponse) String() string {
	return tea.Prettify(s)
}

func (s CreatePdnsAppKeyResponse) GoString() string {
	return s.String()
}

func (s *CreatePdnsAppKeyResponse) SetHeaders(v map[string]*string) *CreatePdnsAppKeyResponse {
	s.Headers = v
	return s
}

func (s *CreatePdnsAppKeyResponse) SetStatusCode(v int32) *CreatePdnsAppKeyResponse {
	s.StatusCode = &v
	return s
}

func (s *CreatePdnsAppKeyResponse) SetBody(v *CreatePdnsAppKeyResponseBody) *CreatePdnsAppKeyResponse {
	s.Body = v
	return s
}

type CreatePdnsUdpIpSegmentRequest struct {
	Ip      *string `json:"Ip,omitempty" xml:"Ip,omitempty"`
	IpToken *string `json:"IpToken,omitempty" xml:"IpToken,omitempty"`
	Lang    *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	Name    *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s CreatePdnsUdpIpSegmentRequest) String() string {
	return tea.Prettify(s)
}

func (s CreatePdnsUdpIpSegmentRequest) GoString() string {
	return s.String()
}

func (s *CreatePdnsUdpIpSegmentRequest) SetIp(v string) *CreatePdnsUdpIpSegmentRequest {
	s.Ip = &v
	return s
}

func (s *CreatePdnsUdpIpSegmentRequest) SetIpToken(v string) *CreatePdnsUdpIpSegmentRequest {
	s.IpToken = &v
	return s
}

func (s *CreatePdnsUdpIpSegmentRequest) SetLang(v string) *CreatePdnsUdpIpSegmentRequest {
	s.Lang = &v
	return s
}

func (s *CreatePdnsUdpIpSegmentRequest) SetName(v string) *CreatePdnsUdpIpSegmentRequest {
	s.Name = &v
	return s
}

type CreatePdnsUdpIpSegmentResponseBody struct {
	RequestId    *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	ValidMessage *string `json:"ValidMessage,omitempty" xml:"ValidMessage,omitempty"`
}

func (s CreatePdnsUdpIpSegmentResponseBody) String() string {
	return tea.Prettify(s)
}

func (s CreatePdnsUdpIpSegmentResponseBody) GoString() string {
	return s.String()
}

func (s *CreatePdnsUdpIpSegmentResponseBody) SetRequestId(v string) *CreatePdnsUdpIpSegmentResponseBody {
	s.RequestId = &v
	return s
}

func (s *CreatePdnsUdpIpSegmentResponseBody) SetValidMessage(v string) *CreatePdnsUdpIpSegmentResponseBody {
	s.ValidMessage = &v
	return s
}

type CreatePdnsUdpIpSegmentResponse struct {
	Headers    map[string]*string                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *CreatePdnsUdpIpSegmentResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s CreatePdnsUdpIpSegmentResponse) String() string {
	return tea.Prettify(s)
}

func (s CreatePdnsUdpIpSegmentResponse) GoString() string {
	return s.String()
}

func (s *CreatePdnsUdpIpSegmentResponse) SetHeaders(v map[string]*string) *CreatePdnsUdpIpSegmentResponse {
	s.Headers = v
	return s
}

func (s *CreatePdnsUdpIpSegmentResponse) SetStatusCode(v int32) *CreatePdnsUdpIpSegmentResponse {
	s.StatusCode = &v
	return s
}

func (s *CreatePdnsUdpIpSegmentResponse) SetBody(v *CreatePdnsUdpIpSegmentResponseBody) *CreatePdnsUdpIpSegmentResponse {
	s.Body = v
	return s
}

type DeleteCloudGtmAddressRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// This parameter is required.
	//
	// example:
	//
	// addr-895182181143688192
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can specify a custom value for this parameter, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DeleteCloudGtmAddressRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmAddressRequest) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmAddressRequest) SetAcceptLanguage(v string) *DeleteCloudGtmAddressRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DeleteCloudGtmAddressRequest) SetAddressId(v string) *DeleteCloudGtmAddressRequest {
	s.AddressId = &v
	return s
}

func (s *DeleteCloudGtmAddressRequest) SetClientToken(v string) *DeleteCloudGtmAddressRequest {
	s.ClientToken = &v
	return s
}

type DeleteCloudGtmAddressResponseBody struct {
	// Unique request identification code.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the address deletion operation was successful:
	//
	// - true: Operation successful
	//
	// - false: Operation failed
	//
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s DeleteCloudGtmAddressResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmAddressResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmAddressResponseBody) SetRequestId(v string) *DeleteCloudGtmAddressResponseBody {
	s.RequestId = &v
	return s
}

func (s *DeleteCloudGtmAddressResponseBody) SetSuccess(v bool) *DeleteCloudGtmAddressResponseBody {
	s.Success = &v
	return s
}

type DeleteCloudGtmAddressResponse struct {
	Headers    map[string]*string                 `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                             `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteCloudGtmAddressResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteCloudGtmAddressResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmAddressResponse) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmAddressResponse) SetHeaders(v map[string]*string) *DeleteCloudGtmAddressResponse {
	s.Headers = v
	return s
}

func (s *DeleteCloudGtmAddressResponse) SetStatusCode(v int32) *DeleteCloudGtmAddressResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteCloudGtmAddressResponse) SetBody(v *DeleteCloudGtmAddressResponseBody) *DeleteCloudGtmAddressResponse {
	s.Body = v
	return s
}

type DeleteCloudGtmAddressPoolRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89528023225442**16
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DeleteCloudGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmAddressPoolRequest) SetAcceptLanguage(v string) *DeleteCloudGtmAddressPoolRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DeleteCloudGtmAddressPoolRequest) SetAddressPoolId(v string) *DeleteCloudGtmAddressPoolRequest {
	s.AddressPoolId = &v
	return s
}

func (s *DeleteCloudGtmAddressPoolRequest) SetClientToken(v string) *DeleteCloudGtmAddressPoolRequest {
	s.ClientToken = &v
	return s
}

type DeleteCloudGtmAddressPoolResponseBody struct {
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89528023225442**16
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s DeleteCloudGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmAddressPoolResponseBody) SetAddressPoolId(v string) *DeleteCloudGtmAddressPoolResponseBody {
	s.AddressPoolId = &v
	return s
}

func (s *DeleteCloudGtmAddressPoolResponseBody) SetRequestId(v string) *DeleteCloudGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

func (s *DeleteCloudGtmAddressPoolResponseBody) SetSuccess(v bool) *DeleteCloudGtmAddressPoolResponseBody {
	s.Success = &v
	return s
}

type DeleteCloudGtmAddressPoolResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteCloudGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteCloudGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmAddressPoolResponse) SetHeaders(v map[string]*string) *DeleteCloudGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *DeleteCloudGtmAddressPoolResponse) SetStatusCode(v int32) *DeleteCloudGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteCloudGtmAddressPoolResponse) SetBody(v *DeleteCloudGtmAddressPoolResponseBody) *DeleteCloudGtmAddressPoolResponse {
	s.Body = v
	return s
}

type DeleteCloudGtmInstanceConfigRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration. You can call the [ListCloudGtmInstanceConfigs](~~ListCloudGtmInstanceConfigs~~) operation to query the configuration ID of the access domain name.
	//
	// example:
	//
	// config-000**1
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The access domain name that is configured for the desired GTM 3.0 instance. You can delete only one access domain name.
	//
	// example:
	//
	// gtm-cn-jmp3qnw**03
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
}

func (s DeleteCloudGtmInstanceConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmInstanceConfigRequest) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmInstanceConfigRequest) SetAcceptLanguage(v string) *DeleteCloudGtmInstanceConfigRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DeleteCloudGtmInstanceConfigRequest) SetClientToken(v string) *DeleteCloudGtmInstanceConfigRequest {
	s.ClientToken = &v
	return s
}

func (s *DeleteCloudGtmInstanceConfigRequest) SetConfigId(v string) *DeleteCloudGtmInstanceConfigRequest {
	s.ConfigId = &v
	return s
}

func (s *DeleteCloudGtmInstanceConfigRequest) SetInstanceId(v string) *DeleteCloudGtmInstanceConfigRequest {
	s.InstanceId = &v
	return s
}

type DeleteCloudGtmInstanceConfigResponseBody struct {
	// Unique request identification code.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the operation to delete domain instance configurations was successful:
	//
	// - true: Operation successful - false: Operation failed
	//
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s DeleteCloudGtmInstanceConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmInstanceConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmInstanceConfigResponseBody) SetRequestId(v string) *DeleteCloudGtmInstanceConfigResponseBody {
	s.RequestId = &v
	return s
}

func (s *DeleteCloudGtmInstanceConfigResponseBody) SetSuccess(v bool) *DeleteCloudGtmInstanceConfigResponseBody {
	s.Success = &v
	return s
}

type DeleteCloudGtmInstanceConfigResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteCloudGtmInstanceConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteCloudGtmInstanceConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmInstanceConfigResponse) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmInstanceConfigResponse) SetHeaders(v map[string]*string) *DeleteCloudGtmInstanceConfigResponse {
	s.Headers = v
	return s
}

func (s *DeleteCloudGtmInstanceConfigResponse) SetStatusCode(v int32) *DeleteCloudGtmInstanceConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteCloudGtmInstanceConfigResponse) SetBody(v *DeleteCloudGtmInstanceConfigResponseBody) *DeleteCloudGtmInstanceConfigResponse {
	s.Body = v
	return s
}

type DeleteCloudGtmMonitorTemplateRequest struct {
	// The language in which the returned results are displayed. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// The ID of the health check template. This ID uniquely identifies a health check template.
	//
	// This parameter is required.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
}

func (s DeleteCloudGtmMonitorTemplateRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmMonitorTemplateRequest) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmMonitorTemplateRequest) SetAcceptLanguage(v string) *DeleteCloudGtmMonitorTemplateRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DeleteCloudGtmMonitorTemplateRequest) SetClientToken(v string) *DeleteCloudGtmMonitorTemplateRequest {
	s.ClientToken = &v
	return s
}

func (s *DeleteCloudGtmMonitorTemplateRequest) SetTemplateId(v string) *DeleteCloudGtmMonitorTemplateRequest {
	s.TemplateId = &v
	return s
}

type DeleteCloudGtmMonitorTemplateResponseBody struct {
	// Unique request identification code.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the operation to delete the health check template was successful:
	//
	// - true: Operation successful
	//
	// - false: Operation failed
	//
	// example:
	//
	// true
	Success *bool `json:"Success,omitempty" xml:"Success,omitempty"`
}

func (s DeleteCloudGtmMonitorTemplateResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmMonitorTemplateResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmMonitorTemplateResponseBody) SetRequestId(v string) *DeleteCloudGtmMonitorTemplateResponseBody {
	s.RequestId = &v
	return s
}

func (s *DeleteCloudGtmMonitorTemplateResponseBody) SetSuccess(v bool) *DeleteCloudGtmMonitorTemplateResponseBody {
	s.Success = &v
	return s
}

type DeleteCloudGtmMonitorTemplateResponse struct {
	Headers    map[string]*string                         `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                     `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteCloudGtmMonitorTemplateResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteCloudGtmMonitorTemplateResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteCloudGtmMonitorTemplateResponse) GoString() string {
	return s.String()
}

func (s *DeleteCloudGtmMonitorTemplateResponse) SetHeaders(v map[string]*string) *DeleteCloudGtmMonitorTemplateResponse {
	s.Headers = v
	return s
}

func (s *DeleteCloudGtmMonitorTemplateResponse) SetStatusCode(v int32) *DeleteCloudGtmMonitorTemplateResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteCloudGtmMonitorTemplateResponse) SetBody(v *DeleteCloudGtmMonitorTemplateResponseBody) *DeleteCloudGtmMonitorTemplateResponse {
	s.Body = v
	return s
}

type DeleteCustomLinesRequest struct {
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The unique IDs of the custom lines that you want to delete. Separate the unique IDs with commas (,). You can call the [DescribeCustomLines](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describecustomlines?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// 1234,1235
	LineIds *string `json:"LineIds,omitempty" xml:"LineIds,omitempty"`
}

func (s DeleteCustomLinesRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteCustomLinesRequest) GoString() string {
	return s.String()
}

func (s *DeleteCustomLinesRequest) SetLang(v string) *DeleteCustomLinesRequest {
	s.Lang = &v
	return s
}

func (s *DeleteCustomLinesRequest) SetLineIds(v string) *DeleteCustomLinesRequest {
	s.LineIds = &v
	return s
}

type DeleteCustomLinesResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteCustomLinesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteCustomLinesResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteCustomLinesResponseBody) SetRequestId(v string) *DeleteCustomLinesResponseBody {
	s.RequestId = &v
	return s
}

type DeleteCustomLinesResponse struct {
	Headers    map[string]*string             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteCustomLinesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteCustomLinesResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteCustomLinesResponse) GoString() string {
	return s.String()
}

func (s *DeleteCustomLinesResponse) SetHeaders(v map[string]*string) *DeleteCustomLinesResponse {
	s.Headers = v
	return s
}

func (s *DeleteCustomLinesResponse) SetStatusCode(v int32) *DeleteCustomLinesResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteCustomLinesResponse) SetBody(v *DeleteCustomLinesResponseBody) *DeleteCustomLinesResponse {
	s.Body = v
	return s
}

type DeleteDnsCacheDomainRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the name.
	//
	// This parameter is required.
	//
	// example:
	//
	// dns-example.top
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the content within the request and response. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English Default: **zh**
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DeleteDnsCacheDomainRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsCacheDomainRequest) GoString() string {
	return s.String()
}

func (s *DeleteDnsCacheDomainRequest) SetDomainName(v string) *DeleteDnsCacheDomainRequest {
	s.DomainName = &v
	return s
}

func (s *DeleteDnsCacheDomainRequest) SetLang(v string) *DeleteDnsCacheDomainRequest {
	s.Lang = &v
	return s
}

type DeleteDnsCacheDomainResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteDnsCacheDomainResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsCacheDomainResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteDnsCacheDomainResponseBody) SetRequestId(v string) *DeleteDnsCacheDomainResponseBody {
	s.RequestId = &v
	return s
}

type DeleteDnsCacheDomainResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteDnsCacheDomainResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteDnsCacheDomainResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsCacheDomainResponse) GoString() string {
	return s.String()
}

func (s *DeleteDnsCacheDomainResponse) SetHeaders(v map[string]*string) *DeleteDnsCacheDomainResponse {
	s.Headers = v
	return s
}

func (s *DeleteDnsCacheDomainResponse) SetStatusCode(v int32) *DeleteDnsCacheDomainResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteDnsCacheDomainResponse) SetBody(v *DeleteDnsCacheDomainResponseBody) *DeleteDnsCacheDomainResponse {
	s.Body = v
	return s
}

type DeleteDnsGtmAccessStrategyRequest struct {
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the access policy.
	//
	// This parameter is required.
	//
	// example:
	//
	// testStrategyId1
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
}

func (s DeleteDnsGtmAccessStrategyRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsGtmAccessStrategyRequest) GoString() string {
	return s.String()
}

func (s *DeleteDnsGtmAccessStrategyRequest) SetLang(v string) *DeleteDnsGtmAccessStrategyRequest {
	s.Lang = &v
	return s
}

func (s *DeleteDnsGtmAccessStrategyRequest) SetStrategyId(v string) *DeleteDnsGtmAccessStrategyRequest {
	s.StrategyId = &v
	return s
}

type DeleteDnsGtmAccessStrategyResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 29D0F8F8-5499-4F6C-9FDC-1EE13BF55925
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteDnsGtmAccessStrategyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsGtmAccessStrategyResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteDnsGtmAccessStrategyResponseBody) SetRequestId(v string) *DeleteDnsGtmAccessStrategyResponseBody {
	s.RequestId = &v
	return s
}

type DeleteDnsGtmAccessStrategyResponse struct {
	Headers    map[string]*string                      `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                  `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteDnsGtmAccessStrategyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteDnsGtmAccessStrategyResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsGtmAccessStrategyResponse) GoString() string {
	return s.String()
}

func (s *DeleteDnsGtmAccessStrategyResponse) SetHeaders(v map[string]*string) *DeleteDnsGtmAccessStrategyResponse {
	s.Headers = v
	return s
}

func (s *DeleteDnsGtmAccessStrategyResponse) SetStatusCode(v int32) *DeleteDnsGtmAccessStrategyResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteDnsGtmAccessStrategyResponse) SetBody(v *DeleteDnsGtmAccessStrategyResponseBody) *DeleteDnsGtmAccessStrategyResponse {
	s.Body = v
	return s
}

type DeleteDnsGtmAddressPoolRequest struct {
	// The ID of the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// testpool1
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DeleteDnsGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *DeleteDnsGtmAddressPoolRequest) SetAddrPoolId(v string) *DeleteDnsGtmAddressPoolRequest {
	s.AddrPoolId = &v
	return s
}

func (s *DeleteDnsGtmAddressPoolRequest) SetLang(v string) *DeleteDnsGtmAddressPoolRequest {
	s.Lang = &v
	return s
}

type DeleteDnsGtmAddressPoolResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteDnsGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteDnsGtmAddressPoolResponseBody) SetRequestId(v string) *DeleteDnsGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

type DeleteDnsGtmAddressPoolResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteDnsGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteDnsGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteDnsGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *DeleteDnsGtmAddressPoolResponse) SetHeaders(v map[string]*string) *DeleteDnsGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *DeleteDnsGtmAddressPoolResponse) SetStatusCode(v int32) *DeleteDnsGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteDnsGtmAddressPoolResponse) SetBody(v *DeleteDnsGtmAddressPoolResponseBody) *DeleteDnsGtmAddressPoolResponse {
	s.Body = v
	return s
}

type DeleteDomainRequest struct {
	// The domain name that already exists in Alibaba Cloud DNS. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DeleteDomainRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainRequest) GoString() string {
	return s.String()
}

func (s *DeleteDomainRequest) SetDomainName(v string) *DeleteDomainRequest {
	s.DomainName = &v
	return s
}

func (s *DeleteDomainRequest) SetLang(v string) *DeleteDomainRequest {
	s.Lang = &v
	return s
}

type DeleteDomainResponseBody struct {
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteDomainResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteDomainResponseBody) SetDomainName(v string) *DeleteDomainResponseBody {
	s.DomainName = &v
	return s
}

func (s *DeleteDomainResponseBody) SetRequestId(v string) *DeleteDomainResponseBody {
	s.RequestId = &v
	return s
}

type DeleteDomainResponse struct {
	Headers    map[string]*string        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteDomainResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteDomainResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainResponse) GoString() string {
	return s.String()
}

func (s *DeleteDomainResponse) SetHeaders(v map[string]*string) *DeleteDomainResponse {
	s.Headers = v
	return s
}

func (s *DeleteDomainResponse) SetStatusCode(v int32) *DeleteDomainResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteDomainResponse) SetBody(v *DeleteDomainResponseBody) *DeleteDomainResponse {
	s.Body = v
	return s
}

type DeleteDomainGroupRequest struct {
	// The ID of the domain name group. You can call the [DescribeDomainGroups](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomaingroups?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DeleteDomainGroupRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainGroupRequest) GoString() string {
	return s.String()
}

func (s *DeleteDomainGroupRequest) SetGroupId(v string) *DeleteDomainGroupRequest {
	s.GroupId = &v
	return s
}

func (s *DeleteDomainGroupRequest) SetLang(v string) *DeleteDomainGroupRequest {
	s.Lang = &v
	return s
}

type DeleteDomainGroupResponseBody struct {
	// The name of the domain name group.
	//
	// example:
	//
	// MyGroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteDomainGroupResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainGroupResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteDomainGroupResponseBody) SetGroupName(v string) *DeleteDomainGroupResponseBody {
	s.GroupName = &v
	return s
}

func (s *DeleteDomainGroupResponseBody) SetRequestId(v string) *DeleteDomainGroupResponseBody {
	s.RequestId = &v
	return s
}

type DeleteDomainGroupResponse struct {
	Headers    map[string]*string             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteDomainGroupResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteDomainGroupResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainGroupResponse) GoString() string {
	return s.String()
}

func (s *DeleteDomainGroupResponse) SetHeaders(v map[string]*string) *DeleteDomainGroupResponse {
	s.Headers = v
	return s
}

func (s *DeleteDomainGroupResponse) SetStatusCode(v int32) *DeleteDomainGroupResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteDomainGroupResponse) SetBody(v *DeleteDomainGroupResponseBody) *DeleteDomainGroupResponse {
	s.Body = v
	return s
}

type DeleteDomainRecordRequest struct {
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the DNS record. You can call the [DescribeDomainRecords](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomainrecords?spm=a2c63.p38356.help-menu-search-29697.d_0) to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// 9999985
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 192.0.2.0
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
}

func (s DeleteDomainRecordRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainRecordRequest) GoString() string {
	return s.String()
}

func (s *DeleteDomainRecordRequest) SetLang(v string) *DeleteDomainRecordRequest {
	s.Lang = &v
	return s
}

func (s *DeleteDomainRecordRequest) SetRecordId(v string) *DeleteDomainRecordRequest {
	s.RecordId = &v
	return s
}

func (s *DeleteDomainRecordRequest) SetUserClientIp(v string) *DeleteDomainRecordRequest {
	s.UserClientIp = &v
	return s
}

type DeleteDomainRecordResponseBody struct {
	// The ID of the DNS record.
	//
	// example:
	//
	// 9999985
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteDomainRecordResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainRecordResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteDomainRecordResponseBody) SetRecordId(v string) *DeleteDomainRecordResponseBody {
	s.RecordId = &v
	return s
}

func (s *DeleteDomainRecordResponseBody) SetRequestId(v string) *DeleteDomainRecordResponseBody {
	s.RequestId = &v
	return s
}

type DeleteDomainRecordResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteDomainRecordResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteDomainRecordResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteDomainRecordResponse) GoString() string {
	return s.String()
}

func (s *DeleteDomainRecordResponse) SetHeaders(v map[string]*string) *DeleteDomainRecordResponse {
	s.Headers = v
	return s
}

func (s *DeleteDomainRecordResponse) SetStatusCode(v int32) *DeleteDomainRecordResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteDomainRecordResponse) SetBody(v *DeleteDomainRecordResponseBody) *DeleteDomainRecordResponse {
	s.Body = v
	return s
}

type DeleteGtmAccessStrategyRequest struct {
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the access policy that you want to delete.
	//
	// example:
	//
	// hrskc
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
}

func (s DeleteGtmAccessStrategyRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmAccessStrategyRequest) GoString() string {
	return s.String()
}

func (s *DeleteGtmAccessStrategyRequest) SetLang(v string) *DeleteGtmAccessStrategyRequest {
	s.Lang = &v
	return s
}

func (s *DeleteGtmAccessStrategyRequest) SetStrategyId(v string) *DeleteGtmAccessStrategyRequest {
	s.StrategyId = &v
	return s
}

type DeleteGtmAccessStrategyResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 29D0F8F8-5499-4F6C-9FDC-1EE13BF55925
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteGtmAccessStrategyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmAccessStrategyResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteGtmAccessStrategyResponseBody) SetRequestId(v string) *DeleteGtmAccessStrategyResponseBody {
	s.RequestId = &v
	return s
}

type DeleteGtmAccessStrategyResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteGtmAccessStrategyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteGtmAccessStrategyResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmAccessStrategyResponse) GoString() string {
	return s.String()
}

func (s *DeleteGtmAccessStrategyResponse) SetHeaders(v map[string]*string) *DeleteGtmAccessStrategyResponse {
	s.Headers = v
	return s
}

func (s *DeleteGtmAccessStrategyResponse) SetStatusCode(v int32) *DeleteGtmAccessStrategyResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteGtmAccessStrategyResponse) SetBody(v *DeleteGtmAccessStrategyResponseBody) *DeleteGtmAccessStrategyResponse {
	s.Body = v
	return s
}

type DeleteGtmAddressPoolRequest struct {
	// The ID of the address pool that you want to delete.
	//
	// This parameter is required.
	//
	// example:
	//
	// 1234
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DeleteGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *DeleteGtmAddressPoolRequest) SetAddrPoolId(v string) *DeleteGtmAddressPoolRequest {
	s.AddrPoolId = &v
	return s
}

func (s *DeleteGtmAddressPoolRequest) SetLang(v string) *DeleteGtmAddressPoolRequest {
	s.Lang = &v
	return s
}

type DeleteGtmAddressPoolResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteGtmAddressPoolResponseBody) SetRequestId(v string) *DeleteGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

type DeleteGtmAddressPoolResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *DeleteGtmAddressPoolResponse) SetHeaders(v map[string]*string) *DeleteGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *DeleteGtmAddressPoolResponse) SetStatusCode(v int32) *DeleteGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteGtmAddressPoolResponse) SetBody(v *DeleteGtmAddressPoolResponseBody) *DeleteGtmAddressPoolResponse {
	s.Body = v
	return s
}

type DeleteGtmRecoveryPlanRequest struct {
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the disaster recovery plan that you want to delete.
	//
	// This parameter is required.
	//
	// example:
	//
	// 100
	RecoveryPlanId *int64 `json:"RecoveryPlanId,omitempty" xml:"RecoveryPlanId,omitempty"`
}

func (s DeleteGtmRecoveryPlanRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmRecoveryPlanRequest) GoString() string {
	return s.String()
}

func (s *DeleteGtmRecoveryPlanRequest) SetLang(v string) *DeleteGtmRecoveryPlanRequest {
	s.Lang = &v
	return s
}

func (s *DeleteGtmRecoveryPlanRequest) SetRecoveryPlanId(v int64) *DeleteGtmRecoveryPlanRequest {
	s.RecoveryPlanId = &v
	return s
}

type DeleteGtmRecoveryPlanResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DeleteGtmRecoveryPlanResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmRecoveryPlanResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteGtmRecoveryPlanResponseBody) SetRequestId(v string) *DeleteGtmRecoveryPlanResponseBody {
	s.RequestId = &v
	return s
}

type DeleteGtmRecoveryPlanResponse struct {
	Headers    map[string]*string                 `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                             `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteGtmRecoveryPlanResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteGtmRecoveryPlanResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteGtmRecoveryPlanResponse) GoString() string {
	return s.String()
}

func (s *DeleteGtmRecoveryPlanResponse) SetHeaders(v map[string]*string) *DeleteGtmRecoveryPlanResponse {
	s.Headers = v
	return s
}

func (s *DeleteGtmRecoveryPlanResponse) SetStatusCode(v int32) *DeleteGtmRecoveryPlanResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteGtmRecoveryPlanResponse) SetBody(v *DeleteGtmRecoveryPlanResponseBody) *DeleteGtmRecoveryPlanResponse {
	s.Body = v
	return s
}

type DeleteSubDomainRecordsRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The hostname field in the DNS record.
	//
	// For example, if you want to resolve @.example.com, you must set this parameter to an at sign (@) instead of leaving it empty.
	//
	// This parameter is required.
	//
	// example:
	//
	// www
	RR *string `json:"RR,omitempty" xml:"RR,omitempty"`
	// The type of DNS records. If you do not specify this parameter, all types of DNS records corresponding to the subdomain are returned.
	//
	// Valid values: **A, MX, CNAME, TXT, REDIRECT_URL, FORWORD_URL, NS, AAAA, and SRV**. The value is not case-sensitive.
	//
	// example:
	//
	// A
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 192.0.2.0
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
}

func (s DeleteSubDomainRecordsRequest) String() string {
	return tea.Prettify(s)
}

func (s DeleteSubDomainRecordsRequest) GoString() string {
	return s.String()
}

func (s *DeleteSubDomainRecordsRequest) SetDomainName(v string) *DeleteSubDomainRecordsRequest {
	s.DomainName = &v
	return s
}

func (s *DeleteSubDomainRecordsRequest) SetLang(v string) *DeleteSubDomainRecordsRequest {
	s.Lang = &v
	return s
}

func (s *DeleteSubDomainRecordsRequest) SetRR(v string) *DeleteSubDomainRecordsRequest {
	s.RR = &v
	return s
}

func (s *DeleteSubDomainRecordsRequest) SetType(v string) *DeleteSubDomainRecordsRequest {
	s.Type = &v
	return s
}

func (s *DeleteSubDomainRecordsRequest) SetUserClientIp(v string) *DeleteSubDomainRecordsRequest {
	s.UserClientIp = &v
	return s
}

type DeleteSubDomainRecordsResponseBody struct {
	// The hostname.
	//
	// example:
	//
	// www
	RR *string `json:"RR,omitempty" xml:"RR,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of the DNS records to be deleted.
	//
	// example:
	//
	// 1
	TotalCount *string `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DeleteSubDomainRecordsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DeleteSubDomainRecordsResponseBody) GoString() string {
	return s.String()
}

func (s *DeleteSubDomainRecordsResponseBody) SetRR(v string) *DeleteSubDomainRecordsResponseBody {
	s.RR = &v
	return s
}

func (s *DeleteSubDomainRecordsResponseBody) SetRequestId(v string) *DeleteSubDomainRecordsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DeleteSubDomainRecordsResponseBody) SetTotalCount(v string) *DeleteSubDomainRecordsResponseBody {
	s.TotalCount = &v
	return s
}

type DeleteSubDomainRecordsResponse struct {
	Headers    map[string]*string                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DeleteSubDomainRecordsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DeleteSubDomainRecordsResponse) String() string {
	return tea.Prettify(s)
}

func (s DeleteSubDomainRecordsResponse) GoString() string {
	return s.String()
}

func (s *DeleteSubDomainRecordsResponse) SetHeaders(v map[string]*string) *DeleteSubDomainRecordsResponse {
	s.Headers = v
	return s
}

func (s *DeleteSubDomainRecordsResponse) SetStatusCode(v int32) *DeleteSubDomainRecordsResponse {
	s.StatusCode = &v
	return s
}

func (s *DeleteSubDomainRecordsResponse) SetBody(v *DeleteSubDomainRecordsResponseBody) *DeleteSubDomainRecordsResponse {
	s.Body = v
	return s
}

type DescribeBatchResultCountRequest struct {
	// The type of the batch operation. Valid values:
	//
	// 	- **DOMAIN_ADD**: adds domain names in batches.
	//
	// 	- **DOMAIN_DEL**: deletes domain names in batches.
	//
	// 	- **RR_ADD**: adds Domain Name System (DNS) records in batches.
	//
	// 	- **RR_DEL**: deletes DNS records in batches.
	//
	// >  If you do not specify this parameter, filtering is not required.
	//
	// example:
	//
	// DOMAIN_ADD
	BatchType *string `json:"BatchType,omitempty" xml:"BatchType,omitempty"`
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The task ID.
	//
	// >  If you specify TaskId, the execution result of the specified task is returned. If you do not specify TaskId, the execution result of the last task is returned.
	//
	// example:
	//
	// 123456
	TaskId *int64 `json:"TaskId,omitempty" xml:"TaskId,omitempty"`
}

func (s DescribeBatchResultCountRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultCountRequest) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultCountRequest) SetBatchType(v string) *DescribeBatchResultCountRequest {
	s.BatchType = &v
	return s
}

func (s *DescribeBatchResultCountRequest) SetLang(v string) *DescribeBatchResultCountRequest {
	s.Lang = &v
	return s
}

func (s *DescribeBatchResultCountRequest) SetTaskId(v int64) *DescribeBatchResultCountRequest {
	s.TaskId = &v
	return s
}

type DescribeBatchResultCountResponseBody struct {
	// The type of the batch operation.
	//
	// example:
	//
	// DOMAIN_ADD
	BatchType *string `json:"BatchType,omitempty" xml:"BatchType,omitempty"`
	// The total number of domain names or DNS records that failed to be processed.
	//
	// example:
	//
	// 2
	FailedCount *int32 `json:"FailedCount,omitempty" xml:"FailedCount,omitempty"`
	// The cause of the execution failure.
	//
	// example:
	//
	// failed_reason
	Reason *string `json:"Reason,omitempty" xml:"Reason,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 75446CC1-FC9A-4595-8D96-089D73D7A63D
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The state of the task. Valid values:
	//
	// 	- **-1**: No task for importing domain names or DNS records is submitted.
	//
	// 	- **0**: The task is being processed.
	//
	// 	- **1**: The task is complete.
	//
	// 	- **2**: The task failed.
	//
	// example:
	//
	// 0
	Status *int32 `json:"Status,omitempty" xml:"Status,omitempty"`
	// The total number of domain names or DNS records that were processed.
	//
	// example:
	//
	// 2
	SuccessCount *int32 `json:"SuccessCount,omitempty" xml:"SuccessCount,omitempty"`
	// The ID of the last task.
	//
	// example:
	//
	// 123456
	TaskId *int64 `json:"TaskId,omitempty" xml:"TaskId,omitempty"`
	// The total number of DNS records that were processed in batches.
	//
	// example:
	//
	// 4
	TotalCount *int32 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeBatchResultCountResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultCountResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultCountResponseBody) SetBatchType(v string) *DescribeBatchResultCountResponseBody {
	s.BatchType = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetFailedCount(v int32) *DescribeBatchResultCountResponseBody {
	s.FailedCount = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetReason(v string) *DescribeBatchResultCountResponseBody {
	s.Reason = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetRequestId(v string) *DescribeBatchResultCountResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetStatus(v int32) *DescribeBatchResultCountResponseBody {
	s.Status = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetSuccessCount(v int32) *DescribeBatchResultCountResponseBody {
	s.SuccessCount = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetTaskId(v int64) *DescribeBatchResultCountResponseBody {
	s.TaskId = &v
	return s
}

func (s *DescribeBatchResultCountResponseBody) SetTotalCount(v int32) *DescribeBatchResultCountResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeBatchResultCountResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeBatchResultCountResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeBatchResultCountResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultCountResponse) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultCountResponse) SetHeaders(v map[string]*string) *DescribeBatchResultCountResponse {
	s.Headers = v
	return s
}

func (s *DescribeBatchResultCountResponse) SetStatusCode(v int32) *DescribeBatchResultCountResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeBatchResultCountResponse) SetBody(v *DescribeBatchResultCountResponseBody) *DescribeBatchResultCountResponse {
	s.Body = v
	return s
}

type DescribeBatchResultDetailRequest struct {
	// The type of the batch operation. Valid values:
	//
	// 	- **DOMAIN_ADD**: adds domain names in batches.
	//
	// 	- **DOMAIN_DEL**: deletes domain names in batches.
	//
	// 	- **RR_ADD**: adds Domain Name System (DNS) records in batches.
	//
	// 	- **RR_DEL**: deletes DNS records in batches.
	//
	// >  Do not perform filtering when this field is empty.
	//
	// example:
	//
	// DOMAIN_ADD
	BatchType *string `json:"BatchType,omitempty" xml:"BatchType,omitempty"`
	// The language of the content within the request and response. Default: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The execution result. If you do not specify this parameter, all results are returned.
	//
	// example:
	//
	// SUCCESS
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The task ID.
	//
	// example:
	//
	// 83618818
	TaskId *int64 `json:"TaskId,omitempty" xml:"TaskId,omitempty"`
}

func (s DescribeBatchResultDetailRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultDetailRequest) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultDetailRequest) SetBatchType(v string) *DescribeBatchResultDetailRequest {
	s.BatchType = &v
	return s
}

func (s *DescribeBatchResultDetailRequest) SetLang(v string) *DescribeBatchResultDetailRequest {
	s.Lang = &v
	return s
}

func (s *DescribeBatchResultDetailRequest) SetPageNumber(v int32) *DescribeBatchResultDetailRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeBatchResultDetailRequest) SetPageSize(v int32) *DescribeBatchResultDetailRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeBatchResultDetailRequest) SetStatus(v string) *DescribeBatchResultDetailRequest {
	s.Status = &v
	return s
}

func (s *DescribeBatchResultDetailRequest) SetTaskId(v int64) *DescribeBatchResultDetailRequest {
	s.TaskId = &v
	return s
}

type DescribeBatchResultDetailResponseBody struct {
	// The detailed results of the batch operation.
	BatchResultDetails *DescribeBatchResultDetailResponseBodyBatchResultDetails `json:"BatchResultDetails,omitempty" xml:"BatchResultDetails,omitempty" type:"Struct"`
	// The page number.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 10
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 75446CC1-FC9A-4595-8D96-089D73D7A63D
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 1
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeBatchResultDetailResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultDetailResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultDetailResponseBody) SetBatchResultDetails(v *DescribeBatchResultDetailResponseBodyBatchResultDetails) *DescribeBatchResultDetailResponseBody {
	s.BatchResultDetails = v
	return s
}

func (s *DescribeBatchResultDetailResponseBody) SetPageNumber(v int64) *DescribeBatchResultDetailResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBody) SetPageSize(v int64) *DescribeBatchResultDetailResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBody) SetRequestId(v string) *DescribeBatchResultDetailResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBody) SetTotalCount(v int64) *DescribeBatchResultDetailResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeBatchResultDetailResponseBodyBatchResultDetails struct {
	BatchResultDetail []*DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail `json:"BatchResultDetail,omitempty" xml:"BatchResultDetail,omitempty" type:"Repeated"`
}

func (s DescribeBatchResultDetailResponseBodyBatchResultDetails) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultDetailResponseBodyBatchResultDetails) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetails) SetBatchResultDetail(v []*DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) *DescribeBatchResultDetailResponseBodyBatchResultDetails {
	s.BatchResultDetail = v
	return s
}

type DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail struct {
	// The type of the batch operation.
	//
	// example:
	//
	// DOMAIN_ADD
	BatchType *string `json:"BatchType,omitempty" xml:"BatchType,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	Domain *string `json:"Domain,omitempty" xml:"Domain,omitempty"`
	// The line code.
	//
	// example:
	//
	// default
	Line *string `json:"Line,omitempty" xml:"Line,omitempty"`
	// The new hostname.
	//
	// example:
	//
	// demo-batch-7
	NewRr *string `json:"NewRr,omitempty" xml:"NewRr,omitempty"`
	// The new record value.
	//
	// example:
	//
	// 192.0.2.254
	NewValue *string `json:"NewValue,omitempty" xml:"NewValue,omitempty"`
	// The time when the operation was performed. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2019-08-22 18:02:58
	OperateDateStr *string `json:"OperateDateStr,omitempty" xml:"OperateDateStr,omitempty"`
	// The priority of the mail exchanger (MX) record.
	//
	// example:
	//
	// 10
	Priority *string `json:"Priority,omitempty" xml:"Priority,omitempty"`
	// The cause of the execution failure.
	//
	// example:
	//
	// Task lock fail
	Reason *string `json:"Reason,omitempty" xml:"Reason,omitempty"`
	// The ID of the DNS record.
	//
	// example:
	//
	// 123456789
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The description of the DNS record.
	//
	// example:
	//
	// remark
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The hostname.
	//
	// example:
	//
	// www
	Rr *string `json:"Rr,omitempty" xml:"Rr,omitempty"`
	// The status of the DNS record.
	//
	// example:
	//
	// stop
	RrStatus *string `json:"RrStatus,omitempty" xml:"RrStatus,omitempty"`
	// The execution result of the batch operation. Valid values: **true**: The operation succeeded. **false**: The operation failed.
	//
	// example:
	//
	// true
	Status *bool `json:"Status,omitempty" xml:"Status,omitempty"`
	// The time-to-live (TTL) of the DNS record.
	//
	// example:
	//
	// 600
	Ttl *string `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	// The type of the DNS record.
	//
	// example:
	//
	// A
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The value of the DNS record.
	//
	// example:
	//
	// 192.0.2.0
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetBatchType(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.BatchType = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetDomain(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Domain = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetLine(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Line = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetNewRr(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.NewRr = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetNewValue(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.NewValue = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetOperateDateStr(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.OperateDateStr = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetPriority(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Priority = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetReason(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Reason = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetRecordId(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.RecordId = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetRemark(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Remark = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetRr(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Rr = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetRrStatus(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.RrStatus = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetStatus(v bool) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Status = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetTtl(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Ttl = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetType(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Type = &v
	return s
}

func (s *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail) SetValue(v string) *DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail {
	s.Value = &v
	return s
}

type DescribeBatchResultDetailResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeBatchResultDetailResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeBatchResultDetailResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeBatchResultDetailResponse) GoString() string {
	return s.String()
}

func (s *DescribeBatchResultDetailResponse) SetHeaders(v map[string]*string) *DescribeBatchResultDetailResponse {
	s.Headers = v
	return s
}

func (s *DescribeBatchResultDetailResponse) SetStatusCode(v int32) *DescribeBatchResultDetailResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeBatchResultDetailResponse) SetBody(v *DescribeBatchResultDetailResponseBody) *DescribeBatchResultDetailResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmAddressRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// This parameter is required.
	//
	// example:
	//
	// addr-89518218114368**92
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DescribeCloudGtmAddressRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressRequest) SetAcceptLanguage(v string) *DescribeCloudGtmAddressRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmAddressRequest) SetAddressId(v string) *DescribeCloudGtmAddressRequest {
	s.AddressId = &v
	return s
}

func (s *DescribeCloudGtmAddressRequest) SetClientToken(v string) *DescribeCloudGtmAddressRequest {
	s.ClientToken = &v
	return s
}

type DescribeCloudGtmAddressResponseBody struct {
	// IP address or domain name.
	//
	// example:
	//
	// 223.5.XX.XX
	Address *string `json:"Address,omitempty" xml:"Address,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// example:
	//
	// addr-89518218114368**92
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// Address ownership information.
	//
	// example:
	//
	// The current version does not support passing this parameter, please do not input the parameter.
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The failover method that is used if the address fails health checks. Valid values:
	//
	// 	- auto: the automatic mode. The system determines whether to return an address based on the health check results. If the address fails health checks, the system does not return the address. If the address passes health checks, the system returns the address.
	//
	// 	- manual: the manual mode. If an address is in the unavailable state, the address is not returned for Domain Name System (DNS) requests even if the address passes health checks. If an address is in the available state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// example:
	//
	// auto
	AvailableMode *string `json:"AvailableMode,omitempty" xml:"AvailableMode,omitempty"`
	// Address availability status:
	//
	// - available: Available
	//
	// - unavailable: Unavailable
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// Address creation time.
	//
	// example:
	//
	// 2024-03-23T13:09Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// Indicates the current enabled status of the address:
	//
	// enabled: enabled state
	//
	// disabled: disabled state
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address. Valid values:
	//
	// 	- any_ok: The health check results of at least one health check template are normal.
	//
	// 	- p30_ok: The health check results of at least 30% of health check templates are normal.
	//
	// 	- p50_ok: The health check results of at least 50% of health check templates are normal.
	//
	// 	- p70_ok: The health check results of at least 70% of health check templates are normal.
	//
	// 	- all_ok: The health check results of all health check templates are normal.
	//
	// example:
	//
	// p50_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health check state of the address. Valid values:
	//
	// 	- ok: The address passes all health checks of the referenced health check templates.
	//
	// 	- ok_alert: The address fails some health checks of the referenced health check templates but the address is deemed normal.
	//
	// 	- ok_no_monitor: The address does not reference a health check template.
	//
	// 	- exceptional: The address fails some or all health checks of the referenced health check templates and the address is deemed abnormal.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// The health check tasks referenced by the address.
	HealthTasks *DescribeCloudGtmAddressResponseBodyHealthTasks `json:"HealthTasks,omitempty" xml:"HealthTasks,omitempty" type:"Struct"`
	// The availability state of the address when AvailableMode is set to manual. Valid values:
	//
	// 	- available: The address is normal. In this state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// 	- unavailable: The address is abnormal. In this state, the address is not returned for DNS requests even if the address passes health checks.
	//
	// example:
	//
	// available
	ManualAvailableStatus *string `json:"ManualAvailableStatus,omitempty" xml:"ManualAvailableStatus,omitempty"`
	// Address name.
	//
	// example:
	//
	// test
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// Remarks.
	//
	// example:
	//
	// test1
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Address type:
	//
	// - IPv4
	//
	// - IPv6
	//
	// - domain
	//
	// example:
	//
	// IPv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The last modification time of the address configuration.
	//
	// example:
	//
	// 2024-03-29T13:20Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// Modified time (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeCloudGtmAddressResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressResponseBody) SetAddress(v string) *DescribeCloudGtmAddressResponseBody {
	s.Address = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetAddressId(v string) *DescribeCloudGtmAddressResponseBody {
	s.AddressId = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetAttributeInfo(v string) *DescribeCloudGtmAddressResponseBody {
	s.AttributeInfo = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetAvailableMode(v string) *DescribeCloudGtmAddressResponseBody {
	s.AvailableMode = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetAvailableStatus(v string) *DescribeCloudGtmAddressResponseBody {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetCreateTime(v string) *DescribeCloudGtmAddressResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetCreateTimestamp(v int64) *DescribeCloudGtmAddressResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetEnableStatus(v string) *DescribeCloudGtmAddressResponseBody {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetHealthJudgement(v string) *DescribeCloudGtmAddressResponseBody {
	s.HealthJudgement = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetHealthStatus(v string) *DescribeCloudGtmAddressResponseBody {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetHealthTasks(v *DescribeCloudGtmAddressResponseBodyHealthTasks) *DescribeCloudGtmAddressResponseBody {
	s.HealthTasks = v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetManualAvailableStatus(v string) *DescribeCloudGtmAddressResponseBody {
	s.ManualAvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetName(v string) *DescribeCloudGtmAddressResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetRemark(v string) *DescribeCloudGtmAddressResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetRequestId(v string) *DescribeCloudGtmAddressResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetType(v string) *DescribeCloudGtmAddressResponseBody {
	s.Type = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetUpdateTime(v string) *DescribeCloudGtmAddressResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBody) SetUpdateTimestamp(v int64) *DescribeCloudGtmAddressResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeCloudGtmAddressResponseBodyHealthTasks struct {
	HealthTask []*DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask `json:"HealthTask,omitempty" xml:"HealthTask,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressResponseBodyHealthTasks) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressResponseBodyHealthTasks) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressResponseBodyHealthTasks) SetHealthTask(v []*DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) *DescribeCloudGtmAddressResponseBodyHealthTasks {
	s.HealthTask = v
	return s
}

type DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask struct {
	// The state of the health check task. Valid values:
	//
	// 	- ok: The task is normal.
	//
	// 	- alert: An alert is triggered.
	//
	// 	- no_data: No data is available. In most cases, the health check task is newly created and no data is collected.
	//
	// example:
	//
	// ok
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The target service port for health checks. When the Ping protocol is selected for health checks, configuration of the service port is not supported.
	//
	// example:
	//
	// 80
	Port *int32 `json:"Port,omitempty" xml:"Port,omitempty"`
	// The ID of the health check template associated with the address.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
	// The name of the health check template.
	//
	// example:
	//
	// Ping-IPv4
	TemplateName *string `json:"TemplateName,omitempty" xml:"TemplateName,omitempty"`
}

func (s DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) SetMonitorStatus(v string) *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask {
	s.MonitorStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) SetPort(v int32) *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask {
	s.Port = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) SetTemplateId(v string) *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask {
	s.TemplateId = &v
	return s
}

func (s *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask) SetTemplateName(v string) *DescribeCloudGtmAddressResponseBodyHealthTasksHealthTask {
	s.TemplateName = &v
	return s
}

type DescribeCloudGtmAddressResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmAddressResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmAddressResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmAddressResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmAddressResponse) SetStatusCode(v int32) *DescribeCloudGtmAddressResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmAddressResponse) SetBody(v *DescribeCloudGtmAddressResponseBody) *DescribeCloudGtmAddressResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmAddressPoolRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89564674533755**96
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DescribeCloudGtmAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolRequest) SetAcceptLanguage(v string) *DescribeCloudGtmAddressPoolRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolRequest) SetAddressPoolId(v string) *DescribeCloudGtmAddressPoolRequest {
	s.AddressPoolId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolRequest) SetClientToken(v string) *DescribeCloudGtmAddressPoolRequest {
	s.ClientToken = &v
	return s
}

type DescribeCloudGtmAddressPoolResponseBody struct {
	// Load balancing policy among addresses in the address pool:
	//
	// - round_robin: Round-robin, where for any source of DNS resolution requests, all addresses are returned, with a rotation of the order for every request.
	//
	// - sequence: Sequential, where for any source of DNS resolution requests, the address with the lower sequence number (indicating a higher priority, the smaller the number, the higher the priority) is returned. If the address with the lower sequence number is unavailable, the next address with a lower sequence number is returned.
	//
	// - weight: Weighted, supporting the setting of different weight values for each address to realize returning addresses according to the weight ratio of query resolutions.
	//
	// - source_nearest: Source-nearest, also known as intelligent resolution, where GTM can return different addresses based on the source of different DNS resolution requests, achieving the effect of users accessing nearby servers.
	//
	// example:
	//
	// round_robin
	AddressLbStrategy *string `json:"AddressLbStrategy,omitempty" xml:"AddressLbStrategy,omitempty"`
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89564674533755**96
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// Address pool name.
	//
	// example:
	//
	// AddressPool-1
	AddressPoolName *string `json:"AddressPoolName,omitempty" xml:"AddressPoolName,omitempty"`
	// Address pool type:
	//
	// - IPv4
	//
	// - IPv6
	//
	// - domain
	//
	// example:
	//
	// IPv4
	AddressPoolType *string `json:"AddressPoolType,omitempty" xml:"AddressPoolType,omitempty"`
	// The addresses.
	Addresses *DescribeCloudGtmAddressPoolResponseBodyAddresses `json:"Addresses,omitempty" xml:"Addresses,omitempty" type:"Struct"`
	// Address pool availability status:
	//
	// - available: Available
	//
	// - unavailable: Unavailable
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// Address pool creation time.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Address pool creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// Address pool status:
	//
	// - enable: Enabled status
	//
	// - disable: Disabled status
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address pool. Valid values:
	//
	// 	- any_ok: At least one address in the address pool is available.
	//
	// 	- p30_ok: At least 30% of the addresses in the address pool are available.
	//
	// 	- p50_ok: At least 50% of the addresses in the address pool are available.
	//
	// 	- p70_ok: At least 70% of the addresses in the address pool are available.
	//
	// 	- all_ok: All addresses in the address pool are available.
	//
	// example:
	//
	// any_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health state of the address pool. Valid values:
	//
	// 	- ok: The health state of the address pool is normal and all addresses that are referenced by the address pool are available.
	//
	// 	- ok_alert: The health state of the address pool is warning and some of the addresses that are referenced by the address pool are unavailable. However, the address pool is deemed normal. In this case, only the available addresses are returned for Domain Name System (DNS) requests.
	//
	// 	- exceptional: The health state of the address pool is abnormal and some or all of the addresses that are referenced by the address pool are unavailable. In this case, the address pool is deemed abnormal.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// Remarks for the address.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The mode used if the address with the smallest sequence number is recovered. This parameter is returned only when the policy for load balancing between addresses is sequence. Valid values:
	//
	// 	- preemptive: The address with the smallest sequence number is preferentially used if this address is recovered.
	//
	// 	- non_preemptive: The current address is still used even if the address with the smallest sequence number is recovered.
	//
	// example:
	//
	// preemptive
	SequenceLbStrategyMode *string `json:"SequenceLbStrategyMode,omitempty" xml:"SequenceLbStrategyMode,omitempty"`
	// The last modification time of the address pool.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// Last modification time of the address pool (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeCloudGtmAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetAddressLbStrategy(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.AddressLbStrategy = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetAddressPoolId(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.AddressPoolId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetAddressPoolName(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.AddressPoolName = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetAddressPoolType(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.AddressPoolType = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetAddresses(v *DescribeCloudGtmAddressPoolResponseBodyAddresses) *DescribeCloudGtmAddressPoolResponseBody {
	s.Addresses = v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetAvailableStatus(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetCreateTime(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetCreateTimestamp(v int64) *DescribeCloudGtmAddressPoolResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetEnableStatus(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetHealthJudgement(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.HealthJudgement = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetHealthStatus(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetRemark(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetRequestId(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetSequenceLbStrategyMode(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.SequenceLbStrategyMode = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetUpdateTime(v string) *DescribeCloudGtmAddressPoolResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBody) SetUpdateTimestamp(v int64) *DescribeCloudGtmAddressPoolResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeCloudGtmAddressPoolResponseBodyAddresses struct {
	Address []*DescribeCloudGtmAddressPoolResponseBodyAddressesAddress `json:"Address,omitempty" xml:"Address,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddresses) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddresses) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddresses) SetAddress(v []*DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) *DescribeCloudGtmAddressPoolResponseBodyAddresses {
	s.Address = v
	return s
}

type DescribeCloudGtmAddressPoolResponseBodyAddressesAddress struct {
	// IP address or domain name.
	//
	// example:
	//
	// 223.5.XX.XX
	Address *string `json:"Address,omitempty" xml:"Address,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// example:
	//
	// addr-89518218114368**92
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// Address ownership information, not supported in the current version.
	//
	// example:
	//
	// Not supported in the current version.
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The failover method that is used if the address fails health checks. Valid values:
	//
	// 	- auto: the automatic mode. The system determines whether to return an address based on the health check results. If the address fails health checks, the system does not return the address. If the address passes health checks, the system returns the address.
	//
	// 	- manual: the manual mode. If an address is in the unavailable state, the address is not returned for DNS requests even if the address passes health checks. If an address is in the available state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// example:
	//
	// auto
	AvailableMode *string `json:"AvailableMode,omitempty" xml:"AvailableMode,omitempty"`
	// Address availability status:
	//
	// - available: Address available
	//
	// - unavailable: Address unavailable
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// Address creation time.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Address creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// Address enable status, indicating whether the address is currently available:
	//
	// - enable: Enabled status
	//
	// - disable: Disabled status
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address. Valid values:
	//
	// 	- any_ok: The health check results of at least one health check template are normal.
	//
	// 	- p30_ok: The health check results of at least 30% of health check templates are normal.
	//
	// 	- p50_ok: The health check results of at least 50% of health check templates are normal.
	//
	// 	- p70_ok: The health check results of at least 70% of health check templates are normal.
	//
	// 	- all_ok: The health check results of all health check templates are normal.
	//
	// example:
	//
	// any_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health check state of the address. Valid values:
	//
	// 	- ok: The address passes all health checks of the referenced health check templates.
	//
	// 	- ok_alert: The address fails some health checks of the referenced health check templates but the address is deemed normal.
	//
	// 	- ok_no_monitor: The address does not reference a health check template and is normal.
	//
	// 	- exceptional: The address fails some or all health checks of the referenced health check templates and the address is deemed abnormal.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// Health check task list.
	HealthTasks *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks `json:"HealthTasks,omitempty" xml:"HealthTasks,omitempty" type:"Struct"`
	// The availability state of the address when AvailableMode is set to manual. Valid values:
	//
	// 	- available: The address is normal. In this state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// 	- unavailable: The address is abnormal. In this state, the address is not returned for DNS requests even if the address passes health checks.
	//
	// example:
	//
	// available
	ManualAvailableStatus *string `json:"ManualAvailableStatus,omitempty" xml:"ManualAvailableStatus,omitempty"`
	// Address name.
	//
	// example:
	//
	// Address-1
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// Remarks for the address.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The request source list.
	RequestSource *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource `json:"RequestSource,omitempty" xml:"RequestSource,omitempty" type:"Struct"`
	// Indicates whether it is a sequential (non-preemptive) scheduling object for hybrid cloud management scenarios: - true: yes - false: no
	//
	// example:
	//
	// false
	SeqNonPreemptiveSchedule *bool `json:"SeqNonPreemptiveSchedule,omitempty" xml:"SeqNonPreemptiveSchedule,omitempty"`
	// Sequence number, indicating the priority of address return, where smaller numbers have higher priority.
	//
	// example:
	//
	// 1
	SerialNumber *int32 `json:"SerialNumber,omitempty" xml:"SerialNumber,omitempty"`
	// The address type. Valid values:
	//
	// 	- IPv4: IPv4 address
	//
	// 	- IPv6: IPv6 address
	//
	// 	- domain: domain name
	//
	// example:
	//
	// IPv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The last time the address was modified.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The last modification time of the address (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// Weight value (an integer between 1 and 100, inclusive), allowing different weight values to be set for each address, enabling resolution queries to return addresses according to the weighted ratio.
	//
	// example:
	//
	// 1
	WeightValue *int32 `json:"WeightValue,omitempty" xml:"WeightValue,omitempty"`
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetAddress(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.Address = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetAddressId(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.AddressId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetAttributeInfo(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.AttributeInfo = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetAvailableMode(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.AvailableMode = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetAvailableStatus(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetCreateTime(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetCreateTimestamp(v int64) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetEnableStatus(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetHealthJudgement(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.HealthJudgement = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetHealthStatus(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetHealthTasks(v *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.HealthTasks = v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetManualAvailableStatus(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.ManualAvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetName(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.Name = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetRemark(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetRequestSource(v *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.RequestSource = v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetSeqNonPreemptiveSchedule(v bool) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.SeqNonPreemptiveSchedule = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetSerialNumber(v int32) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.SerialNumber = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetType(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.Type = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetUpdateTime(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetUpdateTimestamp(v int64) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress) SetWeightValue(v int32) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddress {
	s.WeightValue = &v
	return s
}

type DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks struct {
	HealthTask []*DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask `json:"HealthTask,omitempty" xml:"HealthTask,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks) SetHealthTask(v []*DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasks {
	s.HealthTask = v
	return s
}

type DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask struct {
	// The target service port for health check probes. When the health check protocol is set to Ping, configuration of the service port is not supported.
	//
	// example:
	//
	// 80
	Port *int32 `json:"Port,omitempty" xml:"Port,omitempty"`
	// ID of the health check template associated with the address.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
	// Health check template name.
	//
	// example:
	//
	// IPv4-Ping
	TemplateName *string `json:"TemplateName,omitempty" xml:"TemplateName,omitempty"`
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask) SetPort(v int32) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask {
	s.Port = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask) SetTemplateId(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask {
	s.TemplateId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask) SetTemplateName(v string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressHealthTasksHealthTask {
	s.TemplateName = &v
	return s
}

type DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource struct {
	RequestSource []*string `json:"RequestSource,omitempty" xml:"RequestSource,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource) SetRequestSource(v []*string) *DescribeCloudGtmAddressPoolResponseBodyAddressesAddressRequestSource {
	s.RequestSource = v
	return s
}

type DescribeCloudGtmAddressPoolResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponse) SetStatusCode(v int32) *DescribeCloudGtmAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolResponse) SetBody(v *DescribeCloudGtmAddressPoolResponseBody) *DescribeCloudGtmAddressPoolResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmAddressPoolReferenceRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89528023225442**16
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DescribeCloudGtmAddressPoolReferenceRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolReferenceRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolReferenceRequest) SetAcceptLanguage(v string) *DescribeCloudGtmAddressPoolReferenceRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceRequest) SetAddressPoolId(v string) *DescribeCloudGtmAddressPoolReferenceRequest {
	s.AddressPoolId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceRequest) SetClientToken(v string) *DescribeCloudGtmAddressPoolReferenceRequest {
	s.ClientToken = &v
	return s
}

type DescribeCloudGtmAddressPoolReferenceResponseBody struct {
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89528023225442**16
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// Address pool name.
	//
	// example:
	//
	// app
	AddressPoolName *string `json:"AddressPoolName,omitempty" xml:"AddressPoolName,omitempty"`
	// The access domain names that reference the address pool.
	InstanceConfigs *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs `json:"InstanceConfigs,omitempty" xml:"InstanceConfigs,omitempty" type:"Struct"`
	// Unique request identification code.
	//
	// example:
	//
	// 853805EA-3D47-47D5-9A1A-A45C24313ABD
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeCloudGtmAddressPoolReferenceResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolReferenceResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBody) SetAddressPoolId(v string) *DescribeCloudGtmAddressPoolReferenceResponseBody {
	s.AddressPoolId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBody) SetAddressPoolName(v string) *DescribeCloudGtmAddressPoolReferenceResponseBody {
	s.AddressPoolName = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBody) SetInstanceConfigs(v *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs) *DescribeCloudGtmAddressPoolReferenceResponseBody {
	s.InstanceConfigs = v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBody) SetRequestId(v string) *DescribeCloudGtmAddressPoolReferenceResponseBody {
	s.RequestId = &v
	return s
}

type DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs struct {
	InstanceConfig []*DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig `json:"InstanceConfig,omitempty" xml:"InstanceConfig,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs) SetInstanceConfig(v []*DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigs {
	s.InstanceConfig = v
	return s
}

type DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig struct {
	// The policy for load balancing between address pools. Valid values:
	//
	// 	- round_robin: All address pools are returned for Domain Name System (DNS) requests from any source. All address pools are sorted in round-robin mode each time they are returned.
	//
	// 	- sequence: The address pool with the smallest sequence number is preferentially returned for DNS requests from any source. The sequence number indicates the priority for returning the address pool. A smaller sequence number indicates a higher priority. If the address pool with the smallest sequence number is unavailable, the address pool with the second smallest sequence number is returned.
	//
	// 	- weight: You can set a different weight value for each address pool. This way, address pools are returned based on the weight values.
	//
	// 	- source_nearest: Different address pools are returned based on the sources of DNS requests. This way, users can access nearby address pools.
	//
	// example:
	//
	// round_robin
	AddressPoolLbStrategy *string `json:"AddressPoolLbStrategy,omitempty" xml:"AddressPoolLbStrategy,omitempty"`
	// The availability state of the access domain name. Valid values:
	//
	// 	- available: If the access domain name is **enabled*	- and the health state is **normal**, the access domain name is deemed **available**.
	//
	// 	- unavailable: If the access domain name is **disabled*	- or the health state is **abnormal**, the access domain name is deemed **unavailable**.
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// example:
	//
	// config-000**1
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The enabling state of the access domain name. Valid values:
	//
	// 	- enable: The access domain name is enabled and the intelligent scheduling policy of the corresponding GTM instance takes effect.
	//
	// 	- disable: The access domain name is disabled and the intelligent scheduling policy of the corresponding GTM instance does not take effect.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The health state of the access domain name. Valid values:
	//
	// 	- ok: The health state of the access domain name is normal and all address pools that are referenced by the access domain name are available.
	//
	// 	- ok_alert: The health state of the access domain name is warning and some of the address pools that are referenced by the access domain name are unavailable. In this case, only the available address pools are returned for DNS requests.
	//
	// 	- exceptional: The health state of the access domain name is abnormal and all address pools that are referenced by the access domain name are unavailable. In this case, addresses in the non-empty address pool with the smallest sequence number are preferentially used for fallback resolution. This returns DNS results for clients as much as possible.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// The ID of the Global Traffic Manager (GTM) 3.0 instance.
	//
	// example:
	//
	// gtm-cn-jmp3qnw**03
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// Instance name.
	//
	// example:
	//
	// test
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// Remarks.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The access domain name. The value of this parameter is composed of the value of ScheduleHostname and the value of ScheduleZoneName.
	//
	// example:
	//
	// www.example.com
	ScheduleDomainName *string `json:"ScheduleDomainName,omitempty" xml:"ScheduleDomainName,omitempty"`
	// Host record of the domain accessed by GTM.
	//
	// example:
	//
	// www
	ScheduleHostname *string `json:"ScheduleHostname,omitempty" xml:"ScheduleHostname,omitempty"`
	// DNS record types for scheduling domains:
	//
	// - A: IPv4 address
	//
	// - AAAA: IPv6 address
	//
	// - CNAME: Domain name
	//
	// example:
	//
	// A
	ScheduleRrType *string `json:"ScheduleRrType,omitempty" xml:"ScheduleRrType,omitempty"`
	// The zone such as example.com or subzone such as a.example.com of the access domain name. In most cases, the zone or subzone is hosted by the Public Authoritative DNS module of Alibaba Cloud DNS. This zone belongs to the account to which the GTM instance belongs.
	//
	// example:
	//
	// example.com
	ScheduleZoneName *string `json:"ScheduleZoneName,omitempty" xml:"ScheduleZoneName,omitempty"`
	// The mode used if the address pool with the smallest sequence number is recovered. This parameter is returned when AddressPoolLbStrategy is set to sequence. Valid values:
	//
	// 	- preemptive: The address pool with the smallest sequence number is preferentially used if this address pool is recovered.
	//
	// 	- non_preemptive: The current address pool is still used even if the address pool with the smallest sequence number is recovered.
	//
	// example:
	//
	// preemptive
	SequenceLbStrategyMode *string `json:"SequenceLbStrategyMode,omitempty" xml:"SequenceLbStrategyMode,omitempty"`
	// Global TTL, the TTL value for resolving the accessed domain name to addresses in the address pool, which affects the caching time of DNS records in the operator\\"s LocalDNS. Supports custom TTL values.
	//
	// example:
	//
	// 30
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	// Global Traffic Management version 3.0 instance types:
	//
	// - standard: Standard Edition
	//
	// - ultimate: Ultimate Edition
	//
	// example:
	//
	// ultimate
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetAddressPoolLbStrategy(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.AddressPoolLbStrategy = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetAvailableStatus(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetConfigId(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.ConfigId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetEnableStatus(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetHealthStatus(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetInstanceId(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.InstanceId = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetInstanceName(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.InstanceName = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetRemark(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetScheduleDomainName(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.ScheduleDomainName = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetScheduleHostname(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.ScheduleHostname = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetScheduleRrType(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.ScheduleRrType = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetScheduleZoneName(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.ScheduleZoneName = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetSequenceLbStrategyMode(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.SequenceLbStrategyMode = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetTtl(v int32) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.Ttl = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig) SetVersionCode(v string) *DescribeCloudGtmAddressPoolReferenceResponseBodyInstanceConfigsInstanceConfig {
	s.VersionCode = &v
	return s
}

type DescribeCloudGtmAddressPoolReferenceResponse struct {
	Headers    map[string]*string                                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmAddressPoolReferenceResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmAddressPoolReferenceResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressPoolReferenceResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressPoolReferenceResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmAddressPoolReferenceResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponse) SetStatusCode(v int32) *DescribeCloudGtmAddressPoolReferenceResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmAddressPoolReferenceResponse) SetBody(v *DescribeCloudGtmAddressPoolReferenceResponseBody) *DescribeCloudGtmAddressPoolReferenceResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmAddressReferenceRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// example:
	//
	// addr-89518218114368**92
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DescribeCloudGtmAddressReferenceRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceRequest) SetAcceptLanguage(v string) *DescribeCloudGtmAddressReferenceRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceRequest) SetAddressId(v string) *DescribeCloudGtmAddressReferenceRequest {
	s.AddressId = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceRequest) SetClientToken(v string) *DescribeCloudGtmAddressReferenceRequest {
	s.ClientToken = &v
	return s
}

type DescribeCloudGtmAddressReferenceResponseBody struct {
	// IP address or domain name.
	//
	// example:
	//
	// 223.5.XX.XX
	Address *string `json:"Address,omitempty" xml:"Address,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// example:
	//
	// addr-89564584963974**40
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// The address pools.
	AddressPools *DescribeCloudGtmAddressReferenceResponseBodyAddressPools `json:"AddressPools,omitempty" xml:"AddressPools,omitempty" type:"Struct"`
	// Address name.
	//
	// example:
	//
	// Address-1
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeCloudGtmAddressReferenceResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceResponseBody) SetAddress(v string) *DescribeCloudGtmAddressReferenceResponseBody {
	s.Address = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBody) SetAddressId(v string) *DescribeCloudGtmAddressReferenceResponseBody {
	s.AddressId = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBody) SetAddressPools(v *DescribeCloudGtmAddressReferenceResponseBodyAddressPools) *DescribeCloudGtmAddressReferenceResponseBody {
	s.AddressPools = v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBody) SetName(v string) *DescribeCloudGtmAddressReferenceResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBody) SetRequestId(v string) *DescribeCloudGtmAddressReferenceResponseBody {
	s.RequestId = &v
	return s
}

type DescribeCloudGtmAddressReferenceResponseBodyAddressPools struct {
	AddressPool []*DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool `json:"AddressPool,omitempty" xml:"AddressPool,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPools) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPools) SetAddressPool(v []*DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) *DescribeCloudGtmAddressReferenceResponseBodyAddressPools {
	s.AddressPool = v
	return s
}

type DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool struct {
	// Load balancing policy among addresses in the address pool:
	//
	// - round_robin: Round-robin, for any source of DNS resolution requests, all addresses are returned, with a rotation sort applied to all addresses each time.
	//
	// - sequence: Sequential, for any source of DNS resolution requests, returns the address with the smaller sequence number (the sequence number indicates the priority of address return, with smaller numbers having higher priority). If the address with the smaller sequence number is unavailable, the next address with a smaller sequence number is returned.
	//
	// - weight: Weighted, supports setting different weight values for each address, realizing the return of addresses according to the ratio of weight for DNS query resolutions.
	//
	// - source_nearest: Source-nearest, i.e., intelligent resolution function, where GTM can return different addresses based on the source of different DNS resolution requests, achieving the effect of users accessing nearby.
	//
	// example:
	//
	// round_robin
	AddressLbStrategy *string `json:"AddressLbStrategy,omitempty" xml:"AddressLbStrategy,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool-895280232254422016
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// Address pool name.
	//
	// example:
	//
	// AddressPool-1
	AddressPoolName *string `json:"AddressPoolName,omitempty" xml:"AddressPoolName,omitempty"`
	// Address pool type:
	//
	// - IPv4
	//
	// - IPv6
	//
	// - domain
	//
	// example:
	//
	// IPv4
	AddressPoolType *string `json:"AddressPoolType,omitempty" xml:"AddressPoolType,omitempty"`
	// Address pool availability status:
	//
	// - available
	//
	// - unavailable
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// Address pool status:
	//
	// - enable: Enabled status
	//
	// - disable: Disabled status
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health status of the address pool. Valid values:
	//
	// 	- any_ok: At least one address in the address pool is available.
	//
	// 	- p30_ok: At least 30% of the addresses in the address pool are available.
	//
	// 	- p50_ok: At least 50% of the addresses in the address pool are available.
	//
	// 	- p70_ok: At least 70% of the addresses in the address pool are available.
	//
	// 	- all_ok: All addresses in the address pool are available.
	//
	// example:
	//
	// any_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health state of the address pool. Valid values:
	//
	// 	- ok: The health state of the address pool is normal and all addresses that are referenced by the address pool are available.
	//
	// 	- ok_alert: The health state of the address pool is warning and some of the addresses that are referenced by the address pool are unavailable. However, the address pool is deemed normal. In this case, only the available addresses are returned for DNS requests.
	//
	// 	- exceptional: The health state of the address pool is abnormal and some or all of the addresses that are referenced by the address pool are unavailable. In this case, the address pool is deemed abnormal.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// The instances that reference the address pool.
	InstanceConfigs *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs `json:"InstanceConfigs,omitempty" xml:"InstanceConfigs,omitempty" type:"Struct"`
	// Remarks for the address pool.
	//
	// example:
	//
	// pool-1
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Load balancing policy between addresses in sequential mode during the recovery of preceding resources service mode:
	//
	// - preemptive: Preemption mode, where upon recovery of preceding resources, priority is given to using addresses with smaller sequence numbers;
	//
	// - non_preemptive: Non-preemption mode, where upon recovery of preceding resources, the current address continues to be used;
	//
	// example:
	//
	// preemptive
	SequenceLbStrategyMode *string `json:"SequenceLbStrategyMode,omitempty" xml:"SequenceLbStrategyMode,omitempty"`
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetAddressLbStrategy(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.AddressLbStrategy = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetAddressPoolId(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.AddressPoolId = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetAddressPoolName(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.AddressPoolName = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetAddressPoolType(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.AddressPoolType = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetAvailableStatus(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetEnableStatus(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetHealthJudgement(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.HealthJudgement = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetHealthStatus(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetInstanceConfigs(v *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.InstanceConfigs = v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetRemark(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool) SetSequenceLbStrategyMode(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPool {
	s.SequenceLbStrategyMode = &v
	return s
}

type DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs struct {
	InstanceConfig []*DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig `json:"InstanceConfig,omitempty" xml:"InstanceConfig,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs) SetInstanceConfig(v []*DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigs {
	s.InstanceConfig = v
	return s
}

type DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig struct {
	// The policy for load balancing between address pools. Valid values:
	//
	// 	- round_robin: All address pools are returned for Domain Name System (DNS) requests from any source. All address pools are sorted in round-robin mode each time they are returned.
	//
	// 	- sequence: The address pool with the smallest sequence number is preferentially returned for DNS requests from any source. The sequence number indicates the priority for returning the address pool. A smaller sequence number indicates a higher priority. If the address pool with the smallest sequence number is unavailable, the address pool with the second smallest sequence number is returned.
	//
	// 	- weight: You can set a different weight value for each address pool. This way, address pools are returned based on the weight values.
	//
	// 	- source_nearest: Different address pools are returned based on the sources of DNS requests. This way, users can access nearby address pools.
	//
	// example:
	//
	// round_robin
	AddressPoolLbStrategy *string `json:"AddressPoolLbStrategy,omitempty" xml:"AddressPoolLbStrategy,omitempty"`
	// The availability state of the access domain name. Valid values:
	//
	// 	- available: If the access domain name is **enabled*	- and the health state is normal, the access domain name is deemed **available**.
	//
	// 	- unavailable: If the access domain name is **disabled*	- or the health state is **abnormal**, the access domain name is deemed **unavailable**.
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// example:
	//
	// config-00**01
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The enabling state of the access domain name. Valid values:
	//
	// 	- enable: The access domain name is enabled and the intelligent scheduling policy of the corresponding GTM instance takes effect.
	//
	// 	- disable: The access domain name is disabled and the intelligent scheduling policy of the corresponding GTM instance does not take effect.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The health state of the access domain name. Valid values:
	//
	// 	- ok: The health state of the access domain name is normal and all address pools that are referenced by the access domain name are available.
	//
	// 	- ok_alert: The health state of the access domain name is warning and some of the address pools that are referenced by the access domain name are unavailable. In this case, only the available address pools are returned for DNS requests.
	//
	// 	- exceptional: The health state of the access domain name is abnormal and all address pools that are referenced by the access domain name are unavailable. In this case, addresses in the non-empty address pool with the smallest sequence number are preferentially used for fallback resolution. This returns DNS results for clients as much as possible.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// The ID of the GTM 3.0 instance.
	//
	// example:
	//
	// gtm-cn-zz11t58**0k
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// Instance name.
	//
	// example:
	//
	// test
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// Remarks.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The access domain name. The value of this parameter is composed of the value of ScheduleHostname and the value of ScheduleZoneName.
	//
	// example:
	//
	// www.example.com
	ScheduleDomainName *string `json:"ScheduleDomainName,omitempty" xml:"ScheduleDomainName,omitempty"`
	// Host record of the domain accessed by GTM.
	//
	// example:
	//
	// www
	ScheduleHostname *string `json:"ScheduleHostname,omitempty" xml:"ScheduleHostname,omitempty"`
	// DNS record types for the scheduling domain:
	//
	// - A: IPv4 address
	//
	// - AAAA: IPv6 address
	//
	// - CNAME: Domain name
	//
	// example:
	//
	// A
	ScheduleRrType *string `json:"ScheduleRrType,omitempty" xml:"ScheduleRrType,omitempty"`
	// The zone such as example.com or subzone such as a.example.com of the access domain name. In most cases, the zone or subzone is hosted by the Public Authoritative DNS module of Alibaba Cloud DNS. This zone belongs to the account to which the GTM instance belongs.
	//
	// example:
	//
	// example.com
	ScheduleZoneName *string `json:"ScheduleZoneName,omitempty" xml:"ScheduleZoneName,omitempty"`
	// The mode used if the address pool with the smallest sequence number is recovered. This parameter is returned when AddressPoolLbStrategy is set to sequence. Valid values:
	//
	// 	- preemptive: The address pool with the smallest sequence number is preferentially used if this address pool is recovered.
	//
	// 	- non_preemptive: The current address pool is still used even if the address pool with the smallest sequence number is recovered.
	//
	// example:
	//
	// preemptive
	SequenceLbStrategyMode *string `json:"SequenceLbStrategyMode,omitempty" xml:"SequenceLbStrategyMode,omitempty"`
	// Global TTL (in seconds), the TTL value for domain name resolution to addresses in the address pool, which affects the caching time of DNS records in the ISP\\"s LocalDNS. Custom TTL values are supported.
	//
	// example:
	//
	// 30
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	// Global Traffic Management version 3.0 instance types:
	//
	// - standard: Standard Edition
	//
	// - ultimate: Ultimate Edition
	//
	// example:
	//
	// ultimate
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetAddressPoolLbStrategy(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.AddressPoolLbStrategy = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetAvailableStatus(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetConfigId(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.ConfigId = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetEnableStatus(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetHealthStatus(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetInstanceId(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.InstanceId = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetInstanceName(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.InstanceName = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetRemark(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetScheduleDomainName(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.ScheduleDomainName = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetScheduleHostname(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.ScheduleHostname = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetScheduleRrType(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.ScheduleRrType = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetScheduleZoneName(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.ScheduleZoneName = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetSequenceLbStrategyMode(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.SequenceLbStrategyMode = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetTtl(v int32) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.Ttl = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig) SetVersionCode(v string) *DescribeCloudGtmAddressReferenceResponseBodyAddressPoolsAddressPoolInstanceConfigsInstanceConfig {
	s.VersionCode = &v
	return s
}

type DescribeCloudGtmAddressReferenceResponse struct {
	Headers    map[string]*string                            `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                        `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmAddressReferenceResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmAddressReferenceResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmAddressReferenceResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmAddressReferenceResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmAddressReferenceResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponse) SetStatusCode(v int32) *DescribeCloudGtmAddressReferenceResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmAddressReferenceResponse) SetBody(v *DescribeCloudGtmAddressReferenceResponseBody) *DescribeCloudGtmAddressReferenceResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmGlobalAlertRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US: English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
}

func (s DescribeCloudGtmGlobalAlertRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmGlobalAlertRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmGlobalAlertRequest) SetAcceptLanguage(v string) *DescribeCloudGtmGlobalAlertRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmGlobalAlertRequest) SetClientToken(v string) *DescribeCloudGtmGlobalAlertRequest {
	s.ClientToken = &v
	return s
}

type DescribeCloudGtmGlobalAlertResponseBody struct {
	// The alert configurations.
	AlertConfig *DescribeCloudGtmGlobalAlertResponseBodyAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Struct"`
	// The alert contact groups.
	AlertGroup *DescribeCloudGtmGlobalAlertResponseBodyAlertGroup `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty" type:"Struct"`
	// The request ID.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeCloudGtmGlobalAlertResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmGlobalAlertResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmGlobalAlertResponseBody) SetAlertConfig(v *DescribeCloudGtmGlobalAlertResponseBodyAlertConfig) *DescribeCloudGtmGlobalAlertResponseBody {
	s.AlertConfig = v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponseBody) SetAlertGroup(v *DescribeCloudGtmGlobalAlertResponseBodyAlertGroup) *DescribeCloudGtmGlobalAlertResponseBody {
	s.AlertGroup = v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponseBody) SetRequestId(v string) *DescribeCloudGtmGlobalAlertResponseBody {
	s.RequestId = &v
	return s
}

type DescribeCloudGtmGlobalAlertResponseBodyAlertConfig struct {
	AlertConfig []*DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmGlobalAlertResponseBodyAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmGlobalAlertResponseBodyAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmGlobalAlertResponseBodyAlertConfig) SetAlertConfig(v []*DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) *DescribeCloudGtmGlobalAlertResponseBodyAlertConfig {
	s.AlertConfig = v
	return s
}

type DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig struct {
	// Indicates whether DingTalk notifications are configured. Valid values:
	//
	// 	- true: DingTalk notifications are configured. DingTalk notifications are sent when alerts are triggered.
	//
	// 	- false: DingTalk notifications are not configured.
	//
	// example:
	//
	// false
	DingtalkNotice *bool `json:"DingtalkNotice,omitempty" xml:"DingtalkNotice,omitempty"`
	// Indicates whether email notifications are configured. Valid values:
	//
	// 	- true: Email notifications are configured. Emails are sent when alerts are triggered.
	//
	// 	- false: Email notifications are not configured.
	//
	// example:
	//
	// true
	EmailNotice *bool `json:"EmailNotice,omitempty" xml:"EmailNotice,omitempty"`
	// The type of the alert event. Valid values:
	//
	// 	- addr_alert: The address is unavailable.
	//
	// 	- addr_resume: The address becomes available.
	//
	// 	- addr_pool_unavailable: The address pool is unavailable.
	//
	// 	- addr_pool_available: The address pool becomes available.
	//
	// example:
	//
	// addr_alert
	NoticeType *string `json:"NoticeType,omitempty" xml:"NoticeType,omitempty"`
	// Indicates whether text message notifications are configured. Valid values:
	//
	// 	- true: Text message notifications are configured. Text messages are sent when alerts are triggered.
	//
	// 	- false: Text message notifications are not configured.
	//
	// Only the China site (aliyun.com) supports text message notifications.
	//
	// example:
	//
	// true
	SmsNotice *bool `json:"SmsNotice,omitempty" xml:"SmsNotice,omitempty"`
}

func (s DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) SetDingtalkNotice(v bool) *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig {
	s.DingtalkNotice = &v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) SetEmailNotice(v bool) *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig {
	s.EmailNotice = &v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) SetNoticeType(v string) *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig {
	s.NoticeType = &v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig) SetSmsNotice(v bool) *DescribeCloudGtmGlobalAlertResponseBodyAlertConfigAlertConfig {
	s.SmsNotice = &v
	return s
}

type DescribeCloudGtmGlobalAlertResponseBodyAlertGroup struct {
	AlertGroup []*string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmGlobalAlertResponseBodyAlertGroup) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmGlobalAlertResponseBodyAlertGroup) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmGlobalAlertResponseBodyAlertGroup) SetAlertGroup(v []*string) *DescribeCloudGtmGlobalAlertResponseBodyAlertGroup {
	s.AlertGroup = v
	return s
}

type DescribeCloudGtmGlobalAlertResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmGlobalAlertResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmGlobalAlertResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmGlobalAlertResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmGlobalAlertResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmGlobalAlertResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponse) SetStatusCode(v int32) *DescribeCloudGtmGlobalAlertResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmGlobalAlertResponse) SetBody(v *DescribeCloudGtmGlobalAlertResponseBody) *DescribeCloudGtmGlobalAlertResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmInstanceConfigAlertRequest struct {
	// The language of the response. Valid values:
	//
	// 	- **zh-CN**: Chinese
	//
	// 	- **en-US**: English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// example:
	//
	// Config-000**11
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The ID of the Global Traffic Manager (GTM) 3.0 instance.
	//
	// example:
	//
	// gtm-cn-wwo3a3hbz**
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigAlertRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigAlertRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigAlertRequest) SetAcceptLanguage(v string) *DescribeCloudGtmInstanceConfigAlertRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertRequest) SetClientToken(v string) *DescribeCloudGtmInstanceConfigAlertRequest {
	s.ClientToken = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertRequest) SetConfigId(v string) *DescribeCloudGtmInstanceConfigAlertRequest {
	s.ConfigId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertRequest) SetInstanceId(v string) *DescribeCloudGtmInstanceConfigAlertRequest {
	s.InstanceId = &v
	return s
}

type DescribeCloudGtmInstanceConfigAlertResponseBody struct {
	// The alert configurations.
	AlertConfig *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Struct"`
	// The alert contact groups.
	AlertGroup *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty" type:"Struct"`
	// The alert configuration mode of the instance. Valid values:
	//
	// 	- global: global alert configuration
	//
	// 	- instance_config: custom alert configuration
	//
	// example:
	//
	// global
	AlertMode *string `json:"AlertMode,omitempty" xml:"AlertMode,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// example:
	//
	// Config-000**11
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The ID of the GTM 3.0 instance.
	//
	// example:
	//
	// gtm-cn-wwo3a3hbz**
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBody) SetAlertConfig(v *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig) *DescribeCloudGtmInstanceConfigAlertResponseBody {
	s.AlertConfig = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBody) SetAlertGroup(v *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup) *DescribeCloudGtmInstanceConfigAlertResponseBody {
	s.AlertGroup = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBody) SetAlertMode(v string) *DescribeCloudGtmInstanceConfigAlertResponseBody {
	s.AlertMode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBody) SetConfigId(v string) *DescribeCloudGtmInstanceConfigAlertResponseBody {
	s.ConfigId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBody) SetInstanceId(v string) *DescribeCloudGtmInstanceConfigAlertResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBody) SetRequestId(v string) *DescribeCloudGtmInstanceConfigAlertResponseBody {
	s.RequestId = &v
	return s
}

type DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig struct {
	AlertConfig []*DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig) SetAlertConfig(v []*DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfig {
	s.AlertConfig = v
	return s
}

type DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig struct {
	// Indicates whether DingTalk notifications are configured. Valid values:
	//
	// 	- true: DingTalk notifications are configured. DingTalk notifications are sent after alerts are triggered.
	//
	// 	- false: DingTalk notifications are not configured.
	//
	// example:
	//
	// true
	DingtalkNotice *bool `json:"DingtalkNotice,omitempty" xml:"DingtalkNotice,omitempty"`
	// Indicates whether email notifications are configured. Valid values:
	//
	// 	- true: Email notifications are configured. Emails are sent after alerts are triggered.
	//
	// 	- false: Email notifications are not configured.
	//
	// example:
	//
	// true
	EmailNotice *bool `json:"EmailNotice,omitempty" xml:"EmailNotice,omitempty"`
	// The type of the alert event. Valid values:
	//
	// 	- addr_alert: The address is unavailable.
	//
	// 	- addr_resume: The address becomes available.
	//
	// 	- addr_pool_unavailable: The address pool is unavailable.
	//
	// 	- addr_pool_available: The address pool becomes available.
	//
	// example:
	//
	// addr_alert
	NoticeType *string `json:"NoticeType,omitempty" xml:"NoticeType,omitempty"`
	// Indicates whether text message notifications are configured. Valid values:
	//
	// 	- true: Text message notifications are configured. Text messages are sent after alerts are triggered.
	//
	// 	- false: Text message notifications are not configured.
	//
	// Only the China site (aliyun.com) supports text message notifications.
	//
	// example:
	//
	// true
	SmsNotice *bool `json:"SmsNotice,omitempty" xml:"SmsNotice,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) SetDingtalkNotice(v bool) *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig {
	s.DingtalkNotice = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) SetEmailNotice(v bool) *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig {
	s.EmailNotice = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) SetNoticeType(v string) *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig {
	s.NoticeType = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig) SetSmsNotice(v bool) *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertConfigAlertConfig {
	s.SmsNotice = &v
	return s
}

type DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup struct {
	AlertGroup []*string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup) SetAlertGroup(v []*string) *DescribeCloudGtmInstanceConfigAlertResponseBodyAlertGroup {
	s.AlertGroup = v
	return s
}

type DescribeCloudGtmInstanceConfigAlertResponse struct {
	Headers    map[string]*string                               `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                           `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmInstanceConfigAlertResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigAlertResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigAlertResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigAlertResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmInstanceConfigAlertResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponse) SetStatusCode(v int32) *DescribeCloudGtmInstanceConfigAlertResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigAlertResponse) SetBody(v *DescribeCloudGtmInstanceConfigAlertResponseBody) *DescribeCloudGtmInstanceConfigAlertResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
	//
	// example:
	//
	// 1ae05db4-10e7-11ef-b126-00163e24**22
	ClientToken *string `json:"ClientToken,omitempty" xml:"ClientToken,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// You can call the [ListCloudGtmInstanceConfigs](~~ListCloudGtmInstanceConfigs~~) operation to query the value of ConfigId for the access domain name.
	//
	// example:
	//
	// Config-000**11
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// The ID of the GTM 3.0 instance.
	//
	// example:
	//
	// gtm-cn-wwo3a3hbz**
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoRequest) SetAcceptLanguage(v string) *DescribeCloudGtmInstanceConfigFullInfoRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoRequest) SetClientToken(v string) *DescribeCloudGtmInstanceConfigFullInfoRequest {
	s.ClientToken = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoRequest) SetConfigId(v string) *DescribeCloudGtmInstanceConfigFullInfoRequest {
	s.ConfigId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoRequest) SetInstanceId(v string) *DescribeCloudGtmInstanceConfigFullInfoRequest {
	s.InstanceId = &v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBody struct {
	// The policy for load balancing between address pools. Valid values:
	//
	// 	- round_robin: All address pools are returned for DNS requests from any source. All address pools are sorted in round-robin mode each time they are returned.
	//
	// 	- sequence: The address pool with the smallest sequence number is preferentially returned for DNS requests from any source. The sequence number indicates the priority for returning the address pool. A smaller sequence number indicates a higher priority. If the address pool with the smallest sequence number is unavailable, the address pool with the second smallest sequence number is returned.
	//
	// 	- weight: You can set a different weight value for each address pool. This way, address pools are returned based on the weight values.
	//
	// 	- source_nearest: GTM returns different addresses based on the sources of DNS requests. This way, users can access nearby addresses.
	//
	// example:
	//
	// round_robin
	AddressPoolLbStrategy *string `json:"AddressPoolLbStrategy,omitempty" xml:"AddressPoolLbStrategy,omitempty"`
	// The address pools.
	AddressPools *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools `json:"AddressPools,omitempty" xml:"AddressPools,omitempty" type:"Struct"`
	// Alert notification configuration.
	//
	// example:
	//
	// [{\\"NoticeType\\":\\"addr_alert\\",\\"SmsNotice\\":true,\\"EmailNotice\\":true,\\"DingtalkNotice\\":true},{\\"NoticeType\\":\\"addr_resume\\",\\"SmsNotice\\":true,\\"EmailNotice\\":true,\\"DingtalkNotice\\":true},{\\"NoticeType\\":\\"addr_pool_unavailable\\",\\"SmsNotice\\":true,\\"EmailNotice\\":true,\\"DingtalkNotice\\":true},{\\"NoticeType\\":\\"addr_pool_available\\",\\"SmsNotice\\":true,\\"EmailNotice\\":true,\\"DingtalkNotice\\":true}]"
	AlertConfig *string `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty"`
	// Alert notification group.
	//
	// example:
	//
	// [\\"Default Contact Group\\"]
	AlertGroup *string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty"`
	// The availability state of the access domain name. Valid values:
	//
	// 	- available: If the access domain name is **enabled*	- and the health state of the access domain name is **Normal**, the access domain name is deemed **available**.
	//
	// 	- unavailable: If the access domain name is **disabled*	- or the health state of the access domain name is **Abnormal**, the access domain name is deemed **unavailable**.
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// The commodity code. Valid values:
	//
	// 	- dns_gtm_public_cn: the commodity code on the China site (aliyun.com)
	//
	// 	- dns_gtm_public_intl: the commodity code on the international site (alibabacloud.com)
	//
	// example:
	//
	// dns_gtm_public_cn
	CommodityCode *string `json:"CommodityCode,omitempty" xml:"CommodityCode,omitempty"`
	// The configuration ID of the access domain name. Two configuration IDs exist when the access domain name is bound to the same GTM instance but an A record and an AAAA record are configured for the access domain name. The configuration ID uniquely identifies a configuration.
	//
	// example:
	//
	// Config-000**11
	ConfigId *string `json:"ConfigId,omitempty" xml:"ConfigId,omitempty"`
	// Instance creation time.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Instance creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The enabling state of the access domain name. Valid values:
	//
	// 	- enable: The access domain name is enabled and the intelligent scheduling policy of the corresponding GTM instance takes effect.
	//
	// 	- disable: The access domain name is disabled and the intelligent scheduling policy of the corresponding GTM instance does not take effect.
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The health state of the access domain name. Valid values:
	//
	// 	- ok: The health state of the access domain name is Normal and all address pools that are referenced by the access domain name are available.
	//
	// 	- ok_alert: The health state of the access domain name is Warning and some of the address pools that are referenced by the access domain name are unavailable. In this case, the available address pools are normally used for DNS resolution, but the unavailable address pools cannot be used for DNS resolution.
	//
	// 	- exceptional: The health state of the access domain name is Abnormal and all address pools that are referenced by the access domain name are unavailable. In this case, addresses in the non-empty address pool with the smallest sequence number are preferentially used for fallback resolution. This returns DNS results for clients as much as possible.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// The ID of the GTM 3.0 instance.
	//
	// example:
	//
	// gtm-cn-wwo3a3hbz**
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// Schedule instance name.
	//
	// example:
	//
	// test
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// Remarks of the configuration of domain instance.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// 29D0F8F8-5499-4F6C-9FDC-1EE13BF55925
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The GTM access domain name. The value of this parameter is composed of the value of ScheduleHostname and the value of ScheduleZoneName.
	//
	// example:
	//
	// www.example.com
	ScheduleDomainName *string `json:"ScheduleDomainName,omitempty" xml:"ScheduleDomainName,omitempty"`
	// Host name of the domain accessed by GTM.
	//
	// example:
	//
	// www
	ScheduleHostname *string `json:"ScheduleHostname,omitempty" xml:"ScheduleHostname,omitempty"`
	// DNS record types for the ScheduleDomainName:
	//
	// - A: IPv4 address
	//
	// - AAAA: IPv6 address
	//
	// - CNAME: Domain name
	//
	// example:
	//
	// A
	ScheduleRrType *string `json:"ScheduleRrType,omitempty" xml:"ScheduleRrType,omitempty"`
	// The allocation mode of the access domain name. Valid values:
	//
	// 	- custom: custom allocation. You must specify a custom hostname and associate the hostname with a zone or subzone within the account to which the GTM instance belongs to generate an access domain name.
	//
	// 	- sys_assign: The system assigns an access domain name by default. This mode is no longer supported. Do not choose this mode.
	//
	// example:
	//
	// custom
	ScheduleZoneMode *string `json:"ScheduleZoneMode,omitempty" xml:"ScheduleZoneMode,omitempty"`
	// The zone (such as example.com) or subzone (such as a.example.com) associated with the GTM access domain name. In most cases, the zone or subzone is hosted in Authoritative DNS Resolution of the Alibaba Cloud DNS console within the account to which the GTM instance belongs.
	//
	// example:
	//
	// example.com
	ScheduleZoneName *string `json:"ScheduleZoneName,omitempty" xml:"ScheduleZoneName,omitempty"`
	// The mode used if the address pool with the smallest sequence number is recovered. This parameter is required when AddressPoolLbStrategy is set to sequence. Valid values:
	//
	// 	- preemptive: The address pool with the smallest sequence number is preferentially used if this address pool is recovered.
	//
	// 	- non_preemptive: The current address pool is still used even if the address pool with the smallest sequence number is recovered.
	//
	// example:
	//
	// preemptive
	SequenceLbStrategyMode *string `json:"SequenceLbStrategyMode,omitempty" xml:"SequenceLbStrategyMode,omitempty"`
	// Global TTL (in seconds), the TTL value for resolving the access domain to addresses in the address pool, which affects the caching time of DNS records in the ISP\\"s LocalDNS. Custom TTL values are supported.
	//
	// example:
	//
	// 60
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	// Last modified time.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// Last modified time (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// Global Traffic Management version 3.0 instances:
	//
	// - standard: Standard Edition
	//
	// - ultimate: Ultimate Edition
	//
	// example:
	//
	// ultimate
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetAddressPoolLbStrategy(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.AddressPoolLbStrategy = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetAddressPools(v *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.AddressPools = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetAlertConfig(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.AlertConfig = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetAlertGroup(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.AlertGroup = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetAvailableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetCommodityCode(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.CommodityCode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetConfigId(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.ConfigId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetCreateTime(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetCreateTimestamp(v int64) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetEnableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetHealthStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetInstanceId(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetInstanceName(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.InstanceName = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetRemark(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetRequestId(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetScheduleDomainName(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.ScheduleDomainName = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetScheduleHostname(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.ScheduleHostname = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetScheduleRrType(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.ScheduleRrType = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetScheduleZoneMode(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.ScheduleZoneMode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetScheduleZoneName(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.ScheduleZoneName = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetSequenceLbStrategyMode(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.SequenceLbStrategyMode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetTtl(v int32) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.Ttl = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetUpdateTime(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetUpdateTimestamp(v int64) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBody) SetVersionCode(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBody {
	s.VersionCode = &v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools struct {
	AddressPool []*DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool `json:"AddressPool,omitempty" xml:"AddressPool,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools) SetAddressPool(v []*DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPools {
	s.AddressPool = v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool struct {
	// Load balancing policy among addresses in the address pool:
	//
	// - round_robin: Round-robin, for any source of DNS resolution requests, returns all addresses and rotates their order for each request.
	//
	// - sequence: Sequential, for any source of DNS resolution requests, returns the address with the smaller sequence number (the sequence number indicates the priority of the address return, with smaller numbers having higher priority). If the address with the smaller sequence number is unavailable, the next address with a smaller sequence number is returned.
	//
	// - weight: Weighted, supports setting different weight values for each address to realize returning addresses according to the weight ratio for resolution queries.
	//
	// - source_nearest: Source-nearest, i.e., intelligent resolution function, where GTM can return different addresses based on the source of different DNS resolution requests, achieving the effect of users accessing nearby.
	//
	// example:
	//
	// round_robin
	AddressLbStrategy *string `json:"AddressLbStrategy,omitempty" xml:"AddressLbStrategy,omitempty"`
	// The ID of the address pool. This ID uniquely identifies the address pool.
	//
	// example:
	//
	// pool-89528023225442**16
	AddressPoolId *string `json:"AddressPoolId,omitempty" xml:"AddressPoolId,omitempty"`
	// Address pool name.
	//
	// example:
	//
	// AddressPool-1
	AddressPoolName *string `json:"AddressPoolName,omitempty" xml:"AddressPoolName,omitempty"`
	// Address pool type:
	//
	// - IPv4
	//
	// - IPv6
	//
	// - domain
	//
	// example:
	//
	// IPv4
	AddressPoolType *string `json:"AddressPoolType,omitempty" xml:"AddressPoolType,omitempty"`
	// The addresses.
	Addresses *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses `json:"Addresses,omitempty" xml:"Addresses,omitempty" type:"Struct"`
	// The availability state of the address pool. Valid values:
	//
	// 	- Available
	//
	// 	- unavailable
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// Address pool creation time.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Address pool creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The enabling state of the address pool. Valid values:
	//
	// 	- enable
	//
	// 	- disable
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health state of the address pool. Valid values:
	//
	// 	- any_ok: At least one address in the address pool is available.
	//
	// 	- p30_ok: At least 30% of the addresses in the address pool are available.
	//
	// 	- p50_ok: At least 50% of the addresses in the address pool are available.
	//
	// 	- p70_ok: At least 70% of the addresses in the address pool are available.
	//
	// 	- all_ok: All addresses in the address pool are available.
	//
	// example:
	//
	// any_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// Address pool health status:
	//
	// - ok: Normal, all addresses referenced by the address pool are available.
	//
	// - ok_alert: Warning, some addresses referenced by the address pool are unavailable, but the address pool status is deemed normal. In the warning state, available address pools are resolved normally, while unavailable ones stop resolving.
	//
	// - exceptional: Abnormal, some or all of the addresses referenced by the address pool are unavailable, and the address pool status is determined to be abnormal.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// Parse the list of request sources.
	RequestSource *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource `json:"RequestSource,omitempty" xml:"RequestSource,omitempty" type:"Struct"`
	// Indicates whether it is a sequential (non-preemptive) scheduling object for hybrid cloud management scenarios:
	//
	// - true: yes
	//
	// - false: no
	//
	// example:
	//
	// false
	SeqNonPreemptiveSchedule *bool `json:"SeqNonPreemptiveSchedule,omitempty" xml:"SeqNonPreemptiveSchedule,omitempty"`
	// The mode used if the address with the smallest sequence number is recovered. This parameter is required only when AddressLbStrategy is set to sequence. Valid values:
	//
	// 	- preemptive: The address with the smallest sequence number is preferentially used if this address is recovered.
	//
	// 	- non_preemptive: The current address is still used even if the address with the smallest sequence number is recovered.
	//
	// example:
	//
	// preemptive
	SequenceLbStrategyMode *string `json:"SequenceLbStrategyMode,omitempty" xml:"SequenceLbStrategyMode,omitempty"`
	// Sequence number. For any parsing request from any source, the address pool with the smaller sequence number is returned (the sequence number indicates the priority of the address pool returned, with smaller numbers having higher priority).
	//
	// example:
	//
	// 1
	SerialNumber *int32 `json:"SerialNumber,omitempty" xml:"SerialNumber,omitempty"`
	// Last modification time of the address pool.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// Last modification time of the address pool (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// Weight value (an integer between 1 and 100, inclusive), allowing different weight values to be set for each address pool, enabling resolution queries to return address pools according to the weighted ratio.
	//
	// example:
	//
	// 1
	WeightValue *int32 `json:"WeightValue,omitempty" xml:"WeightValue,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetAddressLbStrategy(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.AddressLbStrategy = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetAddressPoolId(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.AddressPoolId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetAddressPoolName(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.AddressPoolName = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetAddressPoolType(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.AddressPoolType = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetAddresses(v *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.Addresses = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetAvailableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetCreateTime(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetCreateTimestamp(v int64) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetEnableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetHealthJudgement(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.HealthJudgement = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetHealthStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetRequestSource(v *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.RequestSource = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetSeqNonPreemptiveSchedule(v bool) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.SeqNonPreemptiveSchedule = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetSequenceLbStrategyMode(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.SequenceLbStrategyMode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetSerialNumber(v int32) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.SerialNumber = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetUpdateTime(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetUpdateTimestamp(v int64) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool) SetWeightValue(v int32) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPool {
	s.WeightValue = &v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses struct {
	Address []*DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress `json:"Address,omitempty" xml:"Address,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses) SetAddress(v []*DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddresses {
	s.Address = v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress struct {
	// IP address or domain name.
	//
	// example:
	//
	// 223.5.XX.XX
	Address *string `json:"Address,omitempty" xml:"Address,omitempty"`
	// The address ID. This ID uniquely identifies the address.
	//
	// example:
	//
	// addr-89564712295703**96
	AddressId *string `json:"AddressId,omitempty" xml:"AddressId,omitempty"`
	// Address ownership information, not supported in the current version.
	//
	// example:
	//
	// The current version does not support returning this parameter.
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The failover mode that is used when address exceptions are identified. Valid values:
	//
	// 	- auto: the automatic mode. The system determines whether to return an address based on the health check results. If the address fails health checks, the system does not return the address. If the address passes health checks, the system returns the address.
	//
	// 	- manual: the manual mode. If an address is in the unavailable state, the address is not returned for DNS requests even if the address passes health checks. If an address is in the available state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// example:
	//
	// auto
	AvailableMode *string `json:"AvailableMode,omitempty" xml:"AvailableMode,omitempty"`
	// The availability state of the address. Valid values:
	//
	// 	- available
	//
	// 	- unavailable
	//
	// example:
	//
	// available
	AvailableStatus *string `json:"AvailableStatus,omitempty" xml:"AvailableStatus,omitempty"`
	// Address creation time.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Address creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The enabling state of the address. Valid values:
	//
	// 	- enable
	//
	// 	- disable
	//
	// example:
	//
	// enable
	EnableStatus *string `json:"EnableStatus,omitempty" xml:"EnableStatus,omitempty"`
	// The condition for determining the health state of the address. Valid values:
	//
	// 	- any_ok: The health check results of at least one health check template are normal.
	//
	// 	- p30_ok: The health check results of at least 30% of health check templates are normal.
	//
	// 	- p50_ok: The health check results of at least 50% of health check templates are normal.
	//
	// 	- p70_ok: The health check results of at least 70% of health check templates are normal.
	//
	// 	- all_ok: The health check results of all health check templates are normal.
	//
	// example:
	//
	// any_ok
	HealthJudgement *string `json:"HealthJudgement,omitempty" xml:"HealthJudgement,omitempty"`
	// The health check state of the address. Valid values:
	//
	// 	- ok: The address passes all health checks of the referenced health check templates.
	//
	// 	- ok_alert: The address fails some health checks of the referenced health check templates but the address is deemed normal.
	//
	// 	- ok_no_monitor: The address does not reference any health check template and is normal.
	//
	// 	- exceptional: The address fails some or all health checks of the referenced health check templates and the address is deemed abnormal.
	//
	// example:
	//
	// ok
	HealthStatus *string `json:"HealthStatus,omitempty" xml:"HealthStatus,omitempty"`
	// The availability state of the address when AvailableMode is set to manual. Valid values:
	//
	// 	- available: The address is normal. In this state, the address is returned for DNS requests even if an alert is triggered when the address fails health checks.
	//
	// 	- unavailable: The address is abnormal. In this state, the address is not returned for DNS requests even if the address passes health checks.
	//
	// example:
	//
	// available
	ManualAvailableStatus *string `json:"ManualAvailableStatus,omitempty" xml:"ManualAvailableStatus,omitempty"`
	// Address name.
	//
	// example:
	//
	// Address-1
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The remark of the address.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Request source list.
	RequestSource *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource `json:"RequestSource,omitempty" xml:"RequestSource,omitempty" type:"Struct"`
	// Indicates whether it is a sequential (non-preemptive) mode scheduling object, applicable to hybrid cloud management scenarios:
	//
	// - true: yes
	//
	// - false: no
	//
	// example:
	//
	// false
	SeqNonPreemptiveSchedule *bool `json:"SeqNonPreemptiveSchedule,omitempty" xml:"SeqNonPreemptiveSchedule,omitempty"`
	// Sequence number, indicating the priority of address return, where smaller numbers have higher priority.
	//
	// example:
	//
	// 1
	SerialNumber *int32 `json:"SerialNumber,omitempty" xml:"SerialNumber,omitempty"`
	// The type of the address. Valid values:
	//
	// 	- IPV4: the IPv4 address
	//
	// 	- IPv6: the IPv6 address
	//
	// 	- domain: the domain name
	//
	// example:
	//
	// IPv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// Last modified time of the address.
	//
	// example:
	//
	// 2024-03-15T01:46Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The last modification time of the address (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// Weight value (an integer between 1 and 100, inclusive), allowing different weight values to be set for each address, enabling resolution queries to return addresses in proportion to their weights.
	//
	// example:
	//
	// 1
	WeightValue *int32 `json:"WeightValue,omitempty" xml:"WeightValue,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetAddress(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.Address = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetAddressId(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.AddressId = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetAttributeInfo(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.AttributeInfo = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetAvailableMode(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.AvailableMode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetAvailableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.AvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetCreateTime(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetCreateTimestamp(v int64) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetEnableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.EnableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetHealthJudgement(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.HealthJudgement = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetHealthStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.HealthStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetManualAvailableStatus(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.ManualAvailableStatus = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetName(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.Name = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetRemark(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetRequestSource(v *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.RequestSource = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetSeqNonPreemptiveSchedule(v bool) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.SeqNonPreemptiveSchedule = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetSerialNumber(v int32) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.SerialNumber = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetType(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.Type = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetUpdateTime(v string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetUpdateTimestamp(v int64) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress) SetWeightValue(v int32) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddress {
	s.WeightValue = &v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource struct {
	RequestSource []*string `json:"RequestSource,omitempty" xml:"RequestSource,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource) SetRequestSource(v []*string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolAddressesAddressRequestSource {
	s.RequestSource = v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource struct {
	RequestSource []*string `json:"RequestSource,omitempty" xml:"RequestSource,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource) SetRequestSource(v []*string) *DescribeCloudGtmInstanceConfigFullInfoResponseBodyAddressPoolsAddressPoolRequestSource {
	s.RequestSource = v
	return s
}

type DescribeCloudGtmInstanceConfigFullInfoResponse struct {
	Headers    map[string]*string                                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmInstanceConfigFullInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmInstanceConfigFullInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmInstanceConfigFullInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponse) SetStatusCode(v int32) *DescribeCloudGtmInstanceConfigFullInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmInstanceConfigFullInfoResponse) SetBody(v *DescribeCloudGtmInstanceConfigFullInfoResponseBody) *DescribeCloudGtmInstanceConfigFullInfoResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmMonitorTemplateRequest struct {
	// The language of the response. Valid values:
	//
	// 	- **zh-CN**: Chinese
	//
	// 	- **en-US*	- (default): English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
	// The ID of the health check template that you want to query. This ID uniquely identifies the health check template.
	//
	// This parameter is required.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
}

func (s DescribeCloudGtmMonitorTemplateRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmMonitorTemplateRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmMonitorTemplateRequest) SetAcceptLanguage(v string) *DescribeCloudGtmMonitorTemplateRequest {
	s.AcceptLanguage = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateRequest) SetTemplateId(v string) *DescribeCloudGtmMonitorTemplateRequest {
	s.TemplateId = &v
	return s
}

type DescribeCloudGtmMonitorTemplateResponseBody struct {
	// Health check template creation time.
	//
	// example:
	//
	// 2024-03-23T13:09Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// Health check template creation time (timestamp).
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// Retries count. The system will only judge the application service as abnormal after consecutive monitoring failures to prevent inaccurate monitoring results due to momentary network fluctuations or other reasons. Available retry counts are:
	//
	// - 1
	//
	// - 2
	//
	// - 3
	//
	// example:
	//
	// 2
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The extended information. The value of this parameter is a JSON string. The required parameters vary based on the health check protocol.
	//
	// 	- HTTP or HTTPS:
	//
	//     **host**: the Host field of an HTTP or HTTPS request header during an HTTP or HTTPS health check. The parameter value indicates the HTTP website that you want to visit. By default, the value is the primary domain name. You can change the value based on your business requirements.
	//
	//     **path**: the URL for HTTP or HTTPS health checks. Default value: /.
	//
	//     **code**: the alert threshold. During an HTTP or HTTPS health check, the system checks whether a web server functions as expected based on the status code that is returned from the web server. If the returned status code is greater than the specified threshold, the corresponding application service address is deemed abnormal. Valid values:
	//
	//     	- 400: indicates an invalid request. If an HTTP or HTTPS request contains invalid request parameters, a web server returns a status code that is greater than 400. You must specify an exact URL for path if you set code to 400.
	//
	//     	- 500: indicates a server error. If some exceptions occur on a web server, the web server returns a status code that is greater than 500. This value is used by default.
	//
	//     **sni**: indicates whether Server Name Indication (SNI) is enabled. This parameter is used only when the health check protocol is HTTPS. SNI is an extension to the Transport Layer Security (TLS) protocol, which allows a client to specify the host to be connected when the client sends a TLS handshake request. TLS handshakes occur before any data of HTTP requests is sent. Therefore, SNI enables servers to identify the services that clients are attempting to access before certificates are sent. This allows the servers to present correct certificates to the clients. Valid values:
	//
	//     	- true: SNI is enabled.
	//
	//     	- false: SNI is disabled.
	//
	//     **followRedirect**: indicates whether 3XX redirects are followed. Valid values:
	//
	//     	- true: 3XX redirects are followed. You are redirected to the destination address if a 3XX status code such as 301, 302, 303, 307, or 308 is returned.
	//
	//     	- false: 3XX redirects are not followed.
	//
	// 	- ping:
	//
	//     **packetNum**: the total number of Internet Control Message Protocol (ICMP) packets that are sent to the address for each ping-based health check. Valid values: 20, 50, and 100.
	//
	//     **packetLossRate**: the ICMP packet loss rate for each ping-based health check. The packet loss rate in a health check can be calculated by using the following formula: Packet loss rate in a health check = (Number of lost packets/Total number of sent ICMP packets) × 100%. If the packet loss rate reaches the threshold, an alert is triggered. Valid values: 10, 30, 40, 80, 90, and 100.
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	ExtendInfo *string `json:"ExtendInfo,omitempty" xml:"ExtendInfo,omitempty"`
	// Percentage of selected node probe failures (%), that is, the percentage of abnormal detection points among the total detection points. When the failure ratio exceeds the set threshold, the service address is judged as abnormal. The available failure ratio thresholds are:
	//
	// - 20
	//
	// - 50
	//
	// - 80
	//
	// - 100
	//
	// example:
	//
	// 50
	FailureRate *int32 `json:"FailureRate,omitempty" xml:"FailureRate,omitempty"`
	// The time interval (in seconds) between each check, with a default interval of 1 minute. The minimum supported health check interval is 15 seconds, available for flagship edition instances.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// Detect the type of the node IP address:
	//
	// - IPv4: Applicable when the target address type is IPv4;
	//
	// - IPv6: Applicable when the target address type is IPv6.
	//
	// example:
	//
	// IPv4
	IpVersion *string `json:"IpVersion,omitempty" xml:"IpVersion,omitempty"`
	// Probe node list, detailed information can be obtained by calling ListCloudGtmMonitorNodes.
	IspCityNodes *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes `json:"IspCityNodes,omitempty" xml:"IspCityNodes,omitempty" type:"Struct"`
	// The name of the health check probe template, which is recommended to be distinguishable for configuration personnel to differentiate and remember, ideally indicating the health check protocol.
	//
	// example:
	//
	// Ping-IPv4
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// Protocol types to initiate probes to the target IP address:
	//
	// - ping
	//
	// - tcp
	//
	// - http
	//
	// - https
	//
	// example:
	//
	// ping
	Protocol *string `json:"Protocol,omitempty" xml:"Protocol,omitempty"`
	// Remarks for the health check template.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// Unique request identification code.
	//
	// example:
	//
	// 6AEC7A64-3CB1-4C49-8B35-0B901F1E26BF
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the health check template. This ID uniquely identifies the health check template.
	//
	// example:
	//
	// mtp-89518052425100**80
	TemplateId *string `json:"TemplateId,omitempty" xml:"TemplateId,omitempty"`
	// Probe timeout (in milliseconds), data packets not returned within the timeout period are deemed as health check timeouts:
	//
	// - 2000
	//
	// - 3000
	//
	// - 5000
	//
	// - 10000
	//
	// example:
	//
	// 5000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
	// Health check template configuration modification time.
	//
	// example:
	//
	// 2024-03-29T13:20Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// Health check template configuration modification time (timestamp).
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeCloudGtmMonitorTemplateResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmMonitorTemplateResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetCreateTime(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetCreateTimestamp(v int64) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetEvaluationCount(v int32) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.EvaluationCount = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetExtendInfo(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.ExtendInfo = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetFailureRate(v int32) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.FailureRate = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetInterval(v int32) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.Interval = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetIpVersion(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.IpVersion = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetIspCityNodes(v *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.IspCityNodes = v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetName(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetProtocol(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.Protocol = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetRemark(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetRequestId(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetTemplateId(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.TemplateId = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetTimeout(v int32) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.Timeout = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetUpdateTime(v string) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBody) SetUpdateTimestamp(v int64) *DescribeCloudGtmMonitorTemplateResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes struct {
	IspCityNode []*DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes) SetIspCityNode(v []*DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodes {
	s.IspCityNode = v
	return s
}

type DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode struct {
	// City code
	//
	// example:
	//
	// 357
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// City name
	//
	// example:
	//
	// Shanghai
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// Country Code
	//
	// example:
	//
	// 629
	CountryCode *string `json:"CountryCode,omitempty" xml:"CountryCode,omitempty"`
	// Country Name
	//
	// example:
	//
	// China
	CountryName *string `json:"CountryName,omitempty" xml:"CountryName,omitempty"`
	// Probe node group type name
	//
	// example:
	//
	// BGP Nodes
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// Probe node group types:
	//
	// - BGP: BGP nodes
	//
	// - OVERSEAS: International nodes
	//
	// - ISP: Carrier nodes
	//
	// example:
	//
	// BGP
	GroupType *string `json:"GroupType,omitempty" xml:"GroupType,omitempty"`
	// Operator Code
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// Operator Name
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetCityCode(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetCityName(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetCountryCode(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.CountryCode = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetCountryName(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.CountryName = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetGroupName(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.GroupName = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetGroupType(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.GroupType = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetIspCode(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode) SetIspName(v string) *DescribeCloudGtmMonitorTemplateResponseBodyIspCityNodesIspCityNode {
	s.IspName = &v
	return s
}

type DescribeCloudGtmMonitorTemplateResponse struct {
	Headers    map[string]*string                           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmMonitorTemplateResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmMonitorTemplateResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmMonitorTemplateResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmMonitorTemplateResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmMonitorTemplateResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponse) SetStatusCode(v int32) *DescribeCloudGtmMonitorTemplateResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmMonitorTemplateResponse) SetBody(v *DescribeCloudGtmMonitorTemplateResponseBody) *DescribeCloudGtmMonitorTemplateResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmSummaryRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh-CN: Chinese
	//
	// 	- en-US: English
	//
	// example:
	//
	// en-US
	AcceptLanguage *string `json:"AcceptLanguage,omitempty" xml:"AcceptLanguage,omitempty"`
}

func (s DescribeCloudGtmSummaryRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSummaryRequest) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSummaryRequest) SetAcceptLanguage(v string) *DescribeCloudGtmSummaryRequest {
	s.AcceptLanguage = &v
	return s
}

type DescribeCloudGtmSummaryResponseBody struct {
	// The total number of instances within the current account.
	//
	// example:
	//
	// 10
	InstanceTotalCount *int32 `json:"InstanceTotalCount,omitempty" xml:"InstanceTotalCount,omitempty"`
	// The total number of configured health check tasks.
	//
	// example:
	//
	// 20
	MonitorTaskTotalCount *int32 `json:"MonitorTaskTotalCount,omitempty" xml:"MonitorTaskTotalCount,omitempty"`
	// The quota on the number of health check tasks.
	//
	// example:
	//
	// 101
	MonitorTaskTotalQuota *int32 `json:"MonitorTaskTotalQuota,omitempty" xml:"MonitorTaskTotalQuota,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 199C3699-9A7B-41A1-BB5A-F1E862D3CB38
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeCloudGtmSummaryResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSummaryResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSummaryResponseBody) SetInstanceTotalCount(v int32) *DescribeCloudGtmSummaryResponseBody {
	s.InstanceTotalCount = &v
	return s
}

func (s *DescribeCloudGtmSummaryResponseBody) SetMonitorTaskTotalCount(v int32) *DescribeCloudGtmSummaryResponseBody {
	s.MonitorTaskTotalCount = &v
	return s
}

func (s *DescribeCloudGtmSummaryResponseBody) SetMonitorTaskTotalQuota(v int32) *DescribeCloudGtmSummaryResponseBody {
	s.MonitorTaskTotalQuota = &v
	return s
}

func (s *DescribeCloudGtmSummaryResponseBody) SetRequestId(v string) *DescribeCloudGtmSummaryResponseBody {
	s.RequestId = &v
	return s
}

type DescribeCloudGtmSummaryResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmSummaryResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmSummaryResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSummaryResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSummaryResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmSummaryResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmSummaryResponse) SetStatusCode(v int32) *DescribeCloudGtmSummaryResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmSummaryResponse) SetBody(v *DescribeCloudGtmSummaryResponseBody) *DescribeCloudGtmSummaryResponse {
	s.Body = v
	return s
}

type DescribeCloudGtmSystemLinesResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// 389DFFA3-77A5-4A9E-BF3D-147C6F98A5BA
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The system lines.
	SystemLines *DescribeCloudGtmSystemLinesResponseBodySystemLines `json:"SystemLines,omitempty" xml:"SystemLines,omitempty" type:"Struct"`
	// The system lines, which are in a tree structure. Only a system line is listed in this example.
	//
	// example:
	//
	// [{\\"displayName\\":\\"Default\\",\\"id\\":\\"default\\",\\"isAvailable\\":true,\\"name\\":\\"Default\\",\\"parentId\\":\\"\\"}]
	SystemLinesTree *string `json:"SystemLinesTree,omitempty" xml:"SystemLinesTree,omitempty"`
}

func (s DescribeCloudGtmSystemLinesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSystemLinesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSystemLinesResponseBody) SetRequestId(v string) *DescribeCloudGtmSystemLinesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponseBody) SetSystemLines(v *DescribeCloudGtmSystemLinesResponseBodySystemLines) *DescribeCloudGtmSystemLinesResponseBody {
	s.SystemLines = v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponseBody) SetSystemLinesTree(v string) *DescribeCloudGtmSystemLinesResponseBody {
	s.SystemLinesTree = &v
	return s
}

type DescribeCloudGtmSystemLinesResponseBodySystemLines struct {
	SystemLine []*DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine `json:"SystemLine,omitempty" xml:"SystemLine,omitempty" type:"Repeated"`
}

func (s DescribeCloudGtmSystemLinesResponseBodySystemLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSystemLinesResponseBodySystemLines) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSystemLinesResponseBodySystemLines) SetSystemLine(v []*DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) *DescribeCloudGtmSystemLinesResponseBodySystemLines {
	s.SystemLine = v
	return s
}

type DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine struct {
	// The line code.
	//
	// example:
	//
	// aliyun_r_ap-south-1
	Code *string `json:"Code,omitempty" xml:"Code,omitempty"`
	// The display name of the line.
	//
	// example:
	//
	// Default
	DisplayName *string `json:"DisplayName,omitempty" xml:"DisplayName,omitempty"`
	// Indicates whether the line can be selected as the source of a Domain Name System (DNS) request. Valid values:
	//
	// 	- true
	//
	// 	- false
	//
	// example:
	//
	// true
	IsAvailable *bool `json:"IsAvailable,omitempty" xml:"IsAvailable,omitempty"`
	// The name of the line.
	//
	// example:
	//
	// Default
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The code of the parent line.
	//
	// example:
	//
	// String	aliyun
	ParentCode *string `json:"ParentCode,omitempty" xml:"ParentCode,omitempty"`
}

func (s DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) SetCode(v string) *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine {
	s.Code = &v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) SetDisplayName(v string) *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine {
	s.DisplayName = &v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) SetIsAvailable(v bool) *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine {
	s.IsAvailable = &v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) SetName(v string) *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine {
	s.Name = &v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine) SetParentCode(v string) *DescribeCloudGtmSystemLinesResponseBodySystemLinesSystemLine {
	s.ParentCode = &v
	return s
}

type DescribeCloudGtmSystemLinesResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCloudGtmSystemLinesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCloudGtmSystemLinesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCloudGtmSystemLinesResponse) GoString() string {
	return s.String()
}

func (s *DescribeCloudGtmSystemLinesResponse) SetHeaders(v map[string]*string) *DescribeCloudGtmSystemLinesResponse {
	s.Headers = v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponse) SetStatusCode(v int32) *DescribeCloudGtmSystemLinesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCloudGtmSystemLinesResponse) SetBody(v *DescribeCloudGtmSystemLinesResponseBody) *DescribeCloudGtmSystemLinesResponse {
	s.Body = v
	return s
}

type DescribeCustomLineRequest struct {
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The unique ID of the custom line. You can call [DescribeCustomLines](https://www.alibabacloud.com/help/en/dns/api-alidns-2015-01-09-describecustomlines?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the ID
	//
	// example:
	//
	// 597
	LineId *int64 `json:"LineId,omitempty" xml:"LineId,omitempty"`
}

func (s DescribeCustomLineRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLineRequest) GoString() string {
	return s.String()
}

func (s *DescribeCustomLineRequest) SetLang(v string) *DescribeCustomLineRequest {
	s.Lang = &v
	return s
}

func (s *DescribeCustomLineRequest) SetLineId(v int64) *DescribeCustomLineRequest {
	s.LineId = &v
	return s
}

type DescribeCustomLineResponseBody struct {
	// The code of the custom line.
	//
	// example:
	//
	// hra0yc-597
	Code *string `json:"Code,omitempty" xml:"Code,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID/Name of the custom line.
	//
	// example:
	//
	// 597
	Id *int64 `json:"Id,omitempty" xml:"Id,omitempty"`
	// The CIDR blocks. Separate IP addresses with a hyphen (-). Enter a CIDR block in each row. You can enter 1 to 50 CIDR blocks at a time. If a CIDR block contains only one IP address, enter the IP address in the format of IP1-IP1. Different CIDR blocks cannot be overlapped.
	IpSegmentList []*DescribeCustomLineResponseBodyIpSegmentList `json:"IpSegmentList,omitempty" xml:"IpSegmentList,omitempty" type:"Repeated"`
	// The name of the custom line.
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The request ID.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeCustomLineResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLineResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCustomLineResponseBody) SetCode(v string) *DescribeCustomLineResponseBody {
	s.Code = &v
	return s
}

func (s *DescribeCustomLineResponseBody) SetDomainName(v string) *DescribeCustomLineResponseBody {
	s.DomainName = &v
	return s
}

func (s *DescribeCustomLineResponseBody) SetId(v int64) *DescribeCustomLineResponseBody {
	s.Id = &v
	return s
}

func (s *DescribeCustomLineResponseBody) SetIpSegmentList(v []*DescribeCustomLineResponseBodyIpSegmentList) *DescribeCustomLineResponseBody {
	s.IpSegmentList = v
	return s
}

func (s *DescribeCustomLineResponseBody) SetName(v string) *DescribeCustomLineResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeCustomLineResponseBody) SetRequestId(v string) *DescribeCustomLineResponseBody {
	s.RequestId = &v
	return s
}

type DescribeCustomLineResponseBodyIpSegmentList struct {
	// The end IP address of the CIDR block.
	//
	// example:
	//
	// 11.1.1.3
	EndIp *string `json:"EndIp,omitempty" xml:"EndIp,omitempty"`
	// The start IP address of the CIDR block.
	//
	// example:
	//
	// 11.1.1.2
	StartIp *string `json:"StartIp,omitempty" xml:"StartIp,omitempty"`
}

func (s DescribeCustomLineResponseBodyIpSegmentList) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLineResponseBodyIpSegmentList) GoString() string {
	return s.String()
}

func (s *DescribeCustomLineResponseBodyIpSegmentList) SetEndIp(v string) *DescribeCustomLineResponseBodyIpSegmentList {
	s.EndIp = &v
	return s
}

func (s *DescribeCustomLineResponseBodyIpSegmentList) SetStartIp(v string) *DescribeCustomLineResponseBodyIpSegmentList {
	s.StartIp = &v
	return s
}

type DescribeCustomLineResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCustomLineResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCustomLineResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLineResponse) GoString() string {
	return s.String()
}

func (s *DescribeCustomLineResponse) SetHeaders(v map[string]*string) *DescribeCustomLineResponse {
	s.Headers = v
	return s
}

func (s *DescribeCustomLineResponse) SetStatusCode(v int32) *DescribeCustomLineResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCustomLineResponse) SetBody(v *DescribeCustomLineResponseBody) *DescribeCustomLineResponse {
	s.Body = v
	return s
}

type DescribeCustomLinesRequest struct {
	// The domain name that already exists in Alibaba Cloud Domain Name System (DNS). You can call the [DescribeDomains ](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0)operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 10
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeCustomLinesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLinesRequest) GoString() string {
	return s.String()
}

func (s *DescribeCustomLinesRequest) SetDomainName(v string) *DescribeCustomLinesRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeCustomLinesRequest) SetLang(v string) *DescribeCustomLinesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeCustomLinesRequest) SetPageNumber(v int64) *DescribeCustomLinesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeCustomLinesRequest) SetPageSize(v int64) *DescribeCustomLinesRequest {
	s.PageSize = &v
	return s
}

type DescribeCustomLinesResponseBody struct {
	// The custom lines.
	CustomLines []*DescribeCustomLinesResponseBodyCustomLines `json:"CustomLines,omitempty" xml:"CustomLines,omitempty" type:"Repeated"`
	// The page number.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 10
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// B57C121B-A45F-44D8-A9B2-13E5A5044195
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of custom lines.
	//
	// example:
	//
	// 1
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeCustomLinesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLinesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeCustomLinesResponseBody) SetCustomLines(v []*DescribeCustomLinesResponseBodyCustomLines) *DescribeCustomLinesResponseBody {
	s.CustomLines = v
	return s
}

func (s *DescribeCustomLinesResponseBody) SetPageNumber(v int32) *DescribeCustomLinesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeCustomLinesResponseBody) SetPageSize(v int32) *DescribeCustomLinesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeCustomLinesResponseBody) SetRequestId(v string) *DescribeCustomLinesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeCustomLinesResponseBody) SetTotalItems(v int32) *DescribeCustomLinesResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeCustomLinesResponseBody) SetTotalPages(v int32) *DescribeCustomLinesResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeCustomLinesResponseBodyCustomLines struct {
	// The code of the custom line.
	//
	// example:
	//
	// hra0yc-597
	Code *string `json:"Code,omitempty" xml:"Code,omitempty"`
	// The unique ID of the custom line.
	//
	// example:
	//
	// 597
	Id            *int64                                                     `json:"Id,omitempty" xml:"Id,omitempty"`
	IpSegmentList []*DescribeCustomLinesResponseBodyCustomLinesIpSegmentList `json:"IpSegmentList,omitempty" xml:"IpSegmentList,omitempty" type:"Repeated"`
	// The name of the custom line.
	//
	// example:
	//
	// hra0yd-597
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeCustomLinesResponseBodyCustomLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLinesResponseBodyCustomLines) GoString() string {
	return s.String()
}

func (s *DescribeCustomLinesResponseBodyCustomLines) SetCode(v string) *DescribeCustomLinesResponseBodyCustomLines {
	s.Code = &v
	return s
}

func (s *DescribeCustomLinesResponseBodyCustomLines) SetId(v int64) *DescribeCustomLinesResponseBodyCustomLines {
	s.Id = &v
	return s
}

func (s *DescribeCustomLinesResponseBodyCustomLines) SetIpSegmentList(v []*DescribeCustomLinesResponseBodyCustomLinesIpSegmentList) *DescribeCustomLinesResponseBodyCustomLines {
	s.IpSegmentList = v
	return s
}

func (s *DescribeCustomLinesResponseBodyCustomLines) SetName(v string) *DescribeCustomLinesResponseBodyCustomLines {
	s.Name = &v
	return s
}

type DescribeCustomLinesResponseBodyCustomLinesIpSegmentList struct {
	EndIp   *string `json:"EndIp,omitempty" xml:"EndIp,omitempty"`
	StartIp *string `json:"StartIp,omitempty" xml:"StartIp,omitempty"`
}

func (s DescribeCustomLinesResponseBodyCustomLinesIpSegmentList) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLinesResponseBodyCustomLinesIpSegmentList) GoString() string {
	return s.String()
}

func (s *DescribeCustomLinesResponseBodyCustomLinesIpSegmentList) SetEndIp(v string) *DescribeCustomLinesResponseBodyCustomLinesIpSegmentList {
	s.EndIp = &v
	return s
}

func (s *DescribeCustomLinesResponseBodyCustomLinesIpSegmentList) SetStartIp(v string) *DescribeCustomLinesResponseBodyCustomLinesIpSegmentList {
	s.StartIp = &v
	return s
}

type DescribeCustomLinesResponse struct {
	Headers    map[string]*string               `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                           `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeCustomLinesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeCustomLinesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeCustomLinesResponse) GoString() string {
	return s.String()
}

func (s *DescribeCustomLinesResponse) SetHeaders(v map[string]*string) *DescribeCustomLinesResponse {
	s.Headers = v
	return s
}

func (s *DescribeCustomLinesResponse) SetStatusCode(v int32) *DescribeCustomLinesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeCustomLinesResponse) SetBody(v *DescribeCustomLinesResponseBody) *DescribeCustomLinesResponse {
	s.Body = v
	return s
}

type DescribeDNSSLBSubDomainsRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- **zh*	- (default): Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The hostname.
	//
	// example:
	//
	// test
	Rr *string `json:"Rr,omitempty" xml:"Rr,omitempty"`
	// The IP address of the user account.
	//
	// example:
	//
	// 1.1.1.1
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
}

func (s DescribeDNSSLBSubDomainsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsRequest) SetDomainName(v string) *DescribeDNSSLBSubDomainsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsRequest) SetLang(v string) *DescribeDNSSLBSubDomainsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsRequest) SetPageNumber(v int64) *DescribeDNSSLBSubDomainsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsRequest) SetPageSize(v int64) *DescribeDNSSLBSubDomainsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsRequest) SetRr(v string) *DescribeDNSSLBSubDomainsRequest {
	s.Rr = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsRequest) SetUserClientIp(v string) *DescribeDNSSLBSubDomainsRequest {
	s.UserClientIp = &v
	return s
}

type DescribeDNSSLBSubDomainsResponseBody struct {
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 1
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The subdomains for which weighted round-robin is enabled.
	SlbSubDomains *DescribeDNSSLBSubDomainsResponseBodySlbSubDomains `json:"SlbSubDomains,omitempty" xml:"SlbSubDomains,omitempty" type:"Struct"`
	// The total number of entries returned.
	//
	// example:
	//
	// 1
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDNSSLBSubDomainsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsResponseBody) SetPageNumber(v int64) *DescribeDNSSLBSubDomainsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBody) SetPageSize(v int64) *DescribeDNSSLBSubDomainsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBody) SetRequestId(v string) *DescribeDNSSLBSubDomainsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBody) SetSlbSubDomains(v *DescribeDNSSLBSubDomainsResponseBodySlbSubDomains) *DescribeDNSSLBSubDomainsResponseBody {
	s.SlbSubDomains = v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBody) SetTotalCount(v int64) *DescribeDNSSLBSubDomainsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDNSSLBSubDomainsResponseBodySlbSubDomains struct {
	SlbSubDomain []*DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain `json:"SlbSubDomain,omitempty" xml:"SlbSubDomain,omitempty" type:"Repeated"`
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomains) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomains) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomains) SetSlbSubDomain(v []*DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomains {
	s.SlbSubDomain = v
	return s
}

type DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain struct {
	// The lines for which weighted round-robin is enabled.
	LineAlgorithms *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms `json:"LineAlgorithms,omitempty" xml:"LineAlgorithms,omitempty" type:"Struct"`
	// Indicates whether weighted round-robin is enabled for the subdomain.
	//
	// example:
	//
	// true
	Open *bool `json:"Open,omitempty" xml:"Open,omitempty"`
	// The number of DNS records added for the subdomain.
	//
	// example:
	//
	// 3
	RecordCount *int64 `json:"RecordCount,omitempty" xml:"RecordCount,omitempty"`
	// The name of the subdomain.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	// The type of the Domain Name System (DNS) record that supports weighted round-robin. Valid values: A, AAAA, and CNAME.
	//
	// example:
	//
	// A
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) SetLineAlgorithms(v *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain {
	s.LineAlgorithms = v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) SetOpen(v bool) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain {
	s.Open = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) SetRecordCount(v int64) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain {
	s.RecordCount = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) SetSubDomain(v string) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain {
	s.SubDomain = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain) SetType(v string) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain {
	s.Type = &v
	return s
}

type DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms struct {
	LineAlgorithm []*DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm `json:"LineAlgorithm,omitempty" xml:"LineAlgorithm,omitempty" type:"Repeated"`
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms) SetLineAlgorithm(v []*DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms {
	s.LineAlgorithm = v
	return s
}

type DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm struct {
	// The DNS resolution line. The line can be China Telecom, China Mobile, and China Unicom.
	//
	// example:
	//
	// default
	Line *string `json:"Line,omitempty" xml:"Line,omitempty"`
	// Indicates whether weighted round-robin is enabled for the line. Valid values:
	//
	// 	- **true*	- (default): Weighted round-robin is enabled.
	//
	// 	- **false**: Weighted round-robin is disabled.
	//
	// example:
	//
	// true
	Open *bool `json:"Open,omitempty" xml:"Open,omitempty"`
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm) SetLine(v string) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm {
	s.Line = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm) SetOpen(v bool) *DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm {
	s.Open = &v
	return s
}

type DescribeDNSSLBSubDomainsResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDNSSLBSubDomainsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDNSSLBSubDomainsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDNSSLBSubDomainsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDNSSLBSubDomainsResponse) SetHeaders(v map[string]*string) *DescribeDNSSLBSubDomainsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponse) SetStatusCode(v int32) *DescribeDNSSLBSubDomainsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDNSSLBSubDomainsResponse) SetBody(v *DescribeDNSSLBSubDomainsResponseBody) *DescribeDNSSLBSubDomainsResponse {
	s.Body = v
	return s
}

type DescribeDnsCacheDomainsRequest struct {
	// The keyword for searches in "%KeyWord%" mode. The value is not case-sensitive.
	//
	// example:
	//
	// a\\"\\"
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language.
	//
	// example:
	//
	// zh
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeDnsCacheDomainsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsCacheDomainsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsCacheDomainsRequest) SetKeyword(v string) *DescribeDnsCacheDomainsRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeDnsCacheDomainsRequest) SetLang(v string) *DescribeDnsCacheDomainsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsCacheDomainsRequest) SetPageNumber(v int64) *DescribeDnsCacheDomainsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsCacheDomainsRequest) SetPageSize(v int64) *DescribeDnsCacheDomainsRequest {
	s.PageSize = &v
	return s
}

type DescribeDnsCacheDomainsResponseBody struct {
	// The domain names.
	Domains []*DescribeDnsCacheDomainsResponseBodyDomains `json:"Domains,omitempty" xml:"Domains,omitempty" type:"Repeated"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: 1 to 100. Default value: 20.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 57121A9C-CDCF-541F-AD39-275D89099420
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 3
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDnsCacheDomainsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsCacheDomainsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsCacheDomainsResponseBody) SetDomains(v []*DescribeDnsCacheDomainsResponseBodyDomains) *DescribeDnsCacheDomainsResponseBody {
	s.Domains = v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBody) SetPageNumber(v int64) *DescribeDnsCacheDomainsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBody) SetPageSize(v int64) *DescribeDnsCacheDomainsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBody) SetRequestId(v string) *DescribeDnsCacheDomainsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBody) SetTotalCount(v int64) *DescribeDnsCacheDomainsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDnsCacheDomainsResponseBodyDomains struct {
	// The maximum time-to-live (TTL) period of the cached data retrieved from the origin DNS server. Unit: seconds. Valid values: 30 to 86400.
	//
	// example:
	//
	// 86400
	CacheTtlMax *int32 `json:"CacheTtlMax,omitempty" xml:"CacheTtlMax,omitempty"`
	// The minimum TTL period of the cached data retrieved from the origin DNS server. Unit: seconds. Valid values: 30 to 86400.
	//
	// example:
	//
	// 30
	CacheTtlMin *int32 `json:"CacheTtlMin,omitempty" xml:"CacheTtlMin,omitempty"`
	// The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2022-10-17T06:13Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The time when the domain name was added. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1660546144000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The ID of the cache-accelerated domain name.
	//
	// example:
	//
	// 00efd71a-770e-4255-b54e-6fe5659baffe
	DomainId *string `json:"DomainId,omitempty" xml:"DomainId,omitempty"`
	// The cache-accelerated domain name.
	//
	// example:
	//
	// dns-example.top
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The time when the instance expires. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2022-12-02T16:00Z
	ExpireTime *string `json:"ExpireTime,omitempty" xml:"ExpireTime,omitempty"`
	// The time when the instance expires. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1692374400000
	ExpireTimestamp *int64 `json:"ExpireTimestamp,omitempty" xml:"ExpireTimestamp,omitempty"`
	// The instance ID of the cache-accelerated domain name.
	//
	// example:
	//
	// i-7bg
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The description of the domain name.
	//
	// example:
	//
	// remark
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The origin DNS servers.
	SourceDnsServers []*DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers `json:"SourceDnsServers,omitempty" xml:"SourceDnsServers,omitempty" type:"Repeated"`
	// Specifies whether the origin Domain Name System (DNS) server supports Extension Mechanisms for DNS (EDNS). Valid values: NOT_SUPPORT and SUPPORT.
	//
	// example:
	//
	// SUPPORT
	SourceEdns *string `json:"SourceEdns,omitempty" xml:"SourceEdns,omitempty"`
	// The origin protocol policy. Valid values: TCP and UDP. Default value: UDP.
	//
	// example:
	//
	// UDP
	SourceProtocol *string `json:"SourceProtocol,omitempty" xml:"SourceProtocol,omitempty"`
	// The time when the configurations of the domain name were updated. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2023-05-22T03:40Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The time when the configurations of the domain name were updated. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1671690491000
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// The edition code of Alibaba Cloud DNS.
	//
	// example:
	//
	// ultimate
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeDnsCacheDomainsResponseBodyDomains) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsCacheDomainsResponseBodyDomains) GoString() string {
	return s.String()
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetCacheTtlMax(v int32) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.CacheTtlMax = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetCacheTtlMin(v int32) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.CacheTtlMin = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetCreateTime(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetCreateTimestamp(v int64) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetDomainId(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.DomainId = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetDomainName(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.DomainName = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetExpireTime(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.ExpireTime = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetExpireTimestamp(v int64) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.ExpireTimestamp = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetInstanceId(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetRemark(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.Remark = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetSourceDnsServers(v []*DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.SourceDnsServers = v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetSourceEdns(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.SourceEdns = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetSourceProtocol(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.SourceProtocol = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetUpdateTime(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.UpdateTime = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetUpdateTimestamp(v int64) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomains) SetVersionCode(v string) *DescribeDnsCacheDomainsResponseBodyDomains {
	s.VersionCode = &v
	return s
}

type DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers struct {
	// The domain name or IP address of the origin DNS server.
	//
	// example:
	//
	// ns8.alidns.com
	Host *string `json:"Host,omitempty" xml:"Host,omitempty"`
	// The port of the origin DNS server.
	//
	// example:
	//
	// 53
	Port *string `json:"Port,omitempty" xml:"Port,omitempty"`
}

func (s DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers) GoString() string {
	return s.String()
}

func (s *DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers) SetHost(v string) *DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers {
	s.Host = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers) SetPort(v string) *DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers {
	s.Port = &v
	return s
}

type DescribeDnsCacheDomainsResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsCacheDomainsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsCacheDomainsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsCacheDomainsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsCacheDomainsResponse) SetHeaders(v map[string]*string) *DescribeDnsCacheDomainsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsCacheDomainsResponse) SetStatusCode(v int32) *DescribeDnsCacheDomainsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsCacheDomainsResponse) SetBody(v *DescribeDnsCacheDomainsResponseBody) *DescribeDnsCacheDomainsResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmAccessStrategiesRequest struct {
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The type of the access policy. Valid values:
	//
	// 	- GEO: geographical location-based
	//
	// 	- LATENCY: latency-based
	//
	// This parameter is required.
	//
	// example:
	//
	// geo
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
}

func (s DescribeDnsGtmAccessStrategiesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesRequest) SetInstanceId(v string) *DescribeDnsGtmAccessStrategiesRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesRequest) SetLang(v string) *DescribeDnsGtmAccessStrategiesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesRequest) SetPageNumber(v int32) *DescribeDnsGtmAccessStrategiesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesRequest) SetPageSize(v int32) *DescribeDnsGtmAccessStrategiesRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesRequest) SetStrategyMode(v string) *DescribeDnsGtmAccessStrategiesRequest {
	s.StrategyMode = &v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBody struct {
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 0CCC9971-CEC9-4132-824B-4AE611C07623
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The access policies.
	Strategies *DescribeDnsGtmAccessStrategiesResponseBodyStrategies `json:"Strategies,omitempty" xml:"Strategies,omitempty" type:"Struct"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 11
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 11
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBody) SetPageNumber(v int32) *DescribeDnsGtmAccessStrategiesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBody) SetPageSize(v int32) *DescribeDnsGtmAccessStrategiesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBody) SetRequestId(v string) *DescribeDnsGtmAccessStrategiesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBody) SetStrategies(v *DescribeDnsGtmAccessStrategiesResponseBodyStrategies) *DescribeDnsGtmAccessStrategiesResponseBody {
	s.Strategies = v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBody) SetTotalItems(v int32) *DescribeDnsGtmAccessStrategiesResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBody) SetTotalPages(v int32) *DescribeDnsGtmAccessStrategiesResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBodyStrategies struct {
	Strategy []*DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy `json:"Strategy,omitempty" xml:"Strategy,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategies) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategies) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategies) SetStrategy(v []*DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) *DescribeDnsGtmAccessStrategiesResponseBodyStrategies {
	s.Strategy = v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy struct {
	// The time when the access policy was created.
	//
	// example:
	//
	// 2018-08-09T00:10Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates when the access policy was created.
	//
	// example:
	//
	// 1533773400000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The type of the active address pool group. Valid values:
	//
	// 	- DEFAULT: the primary address pool group
	//
	// 	- FAILOVER: the secondary address pool group
	//
	// example:
	//
	// default
	EffectiveAddrPoolGroupType *string `json:"EffectiveAddrPoolGroupType,omitempty" xml:"EffectiveAddrPoolGroupType,omitempty"`
	// The type of the active address pools. Valid values:
	//
	// 	- IPV4
	//
	// 	- IPV6
	//
	// 	- DOMAIN
	//
	// example:
	//
	// ipv4
	EffectiveAddrPoolType *string `json:"EffectiveAddrPoolType,omitempty" xml:"EffectiveAddrPoolType,omitempty"`
	// The active address pool groups.
	EffectiveAddrPools *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools `json:"EffectiveAddrPools,omitempty" xml:"EffectiveAddrPools,omitempty" type:"Struct"`
	// The load balancing policy of the active address pool group. Data is returned when StrategyMode is set to GEO. Valid values:
	//
	// - ALL_RR: returns all addresses.
	//
	// - RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	EffectiveLbaStrategy *string `json:"EffectiveLbaStrategy,omitempty" xml:"EffectiveLbaStrategy,omitempty"`
	// The source regions. Data is returned when StrategyMode is set to GEO. Valid values:
	Lines *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines `json:"Lines,omitempty" xml:"Lines,omitempty" type:"Struct"`
	// The ID of the access policy.
	//
	// example:
	//
	// strategyid1
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
	// The name of the access policy.
	//
	// example:
	//
	// strategname1
	StrategyName *string `json:"StrategyName,omitempty" xml:"StrategyName,omitempty"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetCreateTime(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetCreateTimestamp(v int64) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetEffectiveAddrPoolGroupType(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.EffectiveAddrPoolGroupType = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetEffectiveAddrPoolType(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.EffectiveAddrPoolType = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetEffectiveAddrPools(v *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.EffectiveAddrPools = v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetEffectiveLbaStrategy(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.EffectiveLbaStrategy = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetLines(v *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.Lines = v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetStrategyId(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.StrategyId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy) SetStrategyName(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.StrategyName = &v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools struct {
	EffectiveAddrPool []*DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool `json:"EffectiveAddrPool,omitempty" xml:"EffectiveAddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools) SetEffectiveAddrPool(v []*DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools {
	s.EffectiveAddrPool = v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 3
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The weight of the address pool.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// test
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) SetAddrCount(v int32) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) SetId(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) SetLbaWeight(v int32) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool {
	s.LbaWeight = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool) SetName(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool {
	s.Name = &v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines struct {
	Line []*DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine `json:"Line,omitempty" xml:"Line,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines) SetLine(v []*DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines {
	s.Line = v
	return s
}

type DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine struct {
	// The code of the source region group.
	//
	// example:
	//
	// default
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the source region group.
	//
	// example:
	//
	// global
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The line code of the source region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The line name of the source region.
	//
	// example:
	//
	// global
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetGroupCode(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.GroupCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetGroupName(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetLineCode(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.LineCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetLineName(v string) *DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.LineName = &v
	return s
}

type DescribeDnsGtmAccessStrategiesResponse struct {
	Headers    map[string]*string                          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmAccessStrategiesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmAccessStrategiesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategiesResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategiesResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmAccessStrategiesResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponse) SetStatusCode(v int32) *DescribeDnsGtmAccessStrategiesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategiesResponse) SetBody(v *DescribeDnsGtmAccessStrategiesResponseBody) *DescribeDnsGtmAccessStrategiesResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmAccessStrategyRequest struct {
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the access policy.
	//
	// This parameter is required.
	//
	// example:
	//
	// strategyId1
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyRequest) SetLang(v string) *DescribeDnsGtmAccessStrategyRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyRequest) SetStrategyId(v string) *DescribeDnsGtmAccessStrategyRequest {
	s.StrategyId = &v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBody struct {
	// The primary/secondary switchover policy for address pool groups. Valid values:
	//
	// 	- AUTO: performs automatic switchover between the primary and secondary address pool groups upon failures.
	//
	// 	- DEFAULT: uses the primary address pool group.
	//
	// 	- FAILOVER: uses the secondary address pool group.
	//
	// example:
	//
	// auto
	AccessMode *string `json:"AccessMode,omitempty" xml:"AccessMode,omitempty"`
	// The time when the access policy was created.
	//
	// example:
	//
	// 2018-08-09T00:10Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates when the access policy was created.
	//
	// example:
	//
	// 1533773400000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The status of the primary address pool group. Valid values:
	//
	// 	- AVAILABLE: available
	//
	// 	- NOT_AVAILABLE: unavailable
	//
	// example:
	//
	// AVAILABLE
	DefaultAddrPoolGroupStatus *string `json:"DefaultAddrPoolGroupStatus,omitempty" xml:"DefaultAddrPoolGroupStatus,omitempty"`
	// The type of the primary address pool. Valid values:
	//
	// 	- IPV4
	//
	// 	- IPV6
	//
	// 	- DOMAIN
	//
	// example:
	//
	// ipv4
	DefaultAddrPoolType *string `json:"DefaultAddrPoolType,omitempty" xml:"DefaultAddrPoolType,omitempty"`
	// The address pools in the primary address pool group.
	DefaultAddrPools *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools `json:"DefaultAddrPools,omitempty" xml:"DefaultAddrPools,omitempty" type:"Struct"`
	// The number of available addresses in the primary address pool.
	//
	// example:
	//
	// 1
	DefaultAvailableAddrNum *int32 `json:"DefaultAvailableAddrNum,omitempty" xml:"DefaultAvailableAddrNum,omitempty"`
	// Indicates whether scheduling optimization for latency resolution was enabled for the primary address pool group. Valid values:
	//
	// 	- OPEN: enabled
	//
	// 	- CLOSE: disabled
	//
	// example:
	//
	// open
	DefaultLatencyOptimization *string `json:"DefaultLatencyOptimization,omitempty" xml:"DefaultLatencyOptimization,omitempty"`
	// The load balancing policy of the primary address pool group. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	DefaultLbaStrategy *string `json:"DefaultLbaStrategy,omitempty" xml:"DefaultLbaStrategy,omitempty"`
	// The maximum number of addresses returned from the primary address pool group.
	//
	// example:
	//
	// 1
	DefaultMaxReturnAddrNum *int32 `json:"DefaultMaxReturnAddrNum,omitempty" xml:"DefaultMaxReturnAddrNum,omitempty"`
	// The minimum number of available addresses in the primary address pool group.
	//
	// example:
	//
	// 1
	DefaultMinAvailableAddrNum *int32 `json:"DefaultMinAvailableAddrNum,omitempty" xml:"DefaultMinAvailableAddrNum,omitempty"`
	// The type of the active address pool group. Valid values:
	//
	// 	- DEFAULT: the primary address pool group
	//
	// 	- FAILOVER: the secondary address pool group
	//
	// example:
	//
	// DEFAULT
	EffectiveAddrPoolGroupType *string `json:"EffectiveAddrPoolGroupType,omitempty" xml:"EffectiveAddrPoolGroupType,omitempty"`
	// The status of the secondary address pool group. Valid values:
	//
	// 	- AVAILABLE: available
	//
	// 	- NOT_AVAILABLE: unavailable
	//
	// example:
	//
	// AVAILABLE
	FailoverAddrPoolGroupStatus *string `json:"FailoverAddrPoolGroupStatus,omitempty" xml:"FailoverAddrPoolGroupStatus,omitempty"`
	// The type of the secondary address pool. Valid values:
	//
	// 	- IPV4
	//
	// 	- IPV6
	//
	// 	- DOMAIN
	//
	// example:
	//
	// ipv4
	FailoverAddrPoolType *string `json:"FailoverAddrPoolType,omitempty" xml:"FailoverAddrPoolType,omitempty"`
	// The address pools in the secondary address pool group.
	FailoverAddrPools *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools `json:"FailoverAddrPools,omitempty" xml:"FailoverAddrPools,omitempty" type:"Struct"`
	// The number of available addresses in the secondary address pool.
	//
	// example:
	//
	// 1
	FailoverAvailableAddrNum *int32 `json:"FailoverAvailableAddrNum,omitempty" xml:"FailoverAvailableAddrNum,omitempty"`
	// Indicates whether scheduling optimization for latency resolution was enabled for the secondary address pool group. Valid values:
	//
	// 	- OPEN: enabled
	//
	// 	- CLOSE: disabled
	//
	// example:
	//
	// open
	FailoverLatencyOptimization *string `json:"FailoverLatencyOptimization,omitempty" xml:"FailoverLatencyOptimization,omitempty"`
	// The load balancing policy of the secondary address pool group. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	FailoverLbaStrategy *string `json:"FailoverLbaStrategy,omitempty" xml:"FailoverLbaStrategy,omitempty"`
	// The maximum number of addresses returned from the secondary address pool group.
	//
	// example:
	//
	// 1
	FailoverMaxReturnAddrNum *int32 `json:"FailoverMaxReturnAddrNum,omitempty" xml:"FailoverMaxReturnAddrNum,omitempty"`
	// The minimum number of available addresses in the secondary address pool group.
	//
	// example:
	//
	// 1
	FailoverMinAvailableAddrNum *int32 `json:"FailoverMinAvailableAddrNum,omitempty" xml:"FailoverMinAvailableAddrNum,omitempty"`
	// The ID of the associated instance.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The source regions.
	Lines *DescribeDnsGtmAccessStrategyResponseBodyLines `json:"Lines,omitempty" xml:"Lines,omitempty" type:"Struct"`
	// The ID of the request.
	//
	// example:
	//
	// BA1608CA-834C-4E63-8682-8AF0B11ED72D
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the access policy.
	//
	// example:
	//
	// strategyId1
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
	// The type of the access policy. Valid values:
	//
	// 	- GEO: geographical location-based
	//
	// 	- LATENCY: latency-based
	//
	// example:
	//
	// geo
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
	// The name of the access policy.
	//
	// example:
	//
	// strategyName1
	StrategyName *string `json:"StrategyName,omitempty" xml:"StrategyName,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetAccessMode(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.AccessMode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetCreateTime(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetCreateTimestamp(v int64) *DescribeDnsGtmAccessStrategyResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultAddrPoolGroupStatus(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultAddrPoolGroupStatus = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultAddrPoolType(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultAddrPoolType = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultAddrPools(v *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultAddrPools = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultAvailableAddrNum(v int32) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultAvailableAddrNum = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultLatencyOptimization(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultLatencyOptimization = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultLbaStrategy(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultLbaStrategy = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultMaxReturnAddrNum(v int32) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultMaxReturnAddrNum = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetDefaultMinAvailableAddrNum(v int32) *DescribeDnsGtmAccessStrategyResponseBody {
	s.DefaultMinAvailableAddrNum = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetEffectiveAddrPoolGroupType(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.EffectiveAddrPoolGroupType = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverAddrPoolGroupStatus(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverAddrPoolGroupStatus = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverAddrPoolType(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverAddrPoolType = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverAddrPools(v *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverAddrPools = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverAvailableAddrNum(v int32) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverAvailableAddrNum = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverLatencyOptimization(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverLatencyOptimization = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverLbaStrategy(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverLbaStrategy = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverMaxReturnAddrNum(v int32) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverMaxReturnAddrNum = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetFailoverMinAvailableAddrNum(v int32) *DescribeDnsGtmAccessStrategyResponseBody {
	s.FailoverMinAvailableAddrNum = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetInstanceId(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetLines(v *DescribeDnsGtmAccessStrategyResponseBodyLines) *DescribeDnsGtmAccessStrategyResponseBody {
	s.Lines = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetRequestId(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetStrategyId(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.StrategyId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetStrategyMode(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.StrategyMode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBody) SetStrategyName(v string) *DescribeDnsGtmAccessStrategyResponseBody {
	s.StrategyName = &v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools struct {
	DefaultAddrPool []*DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool `json:"DefaultAddrPool,omitempty" xml:"DefaultAddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools) SetDefaultAddrPool(v []*DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools {
	s.DefaultAddrPool = v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The weight of the address pool.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// test
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) SetAddrCount(v int32) *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) SetId(v string) *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) SetLbaWeight(v int32) *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool {
	s.LbaWeight = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool) SetName(v string) *DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool {
	s.Name = &v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools struct {
	FailoverAddrPool []*DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool `json:"FailoverAddrPool,omitempty" xml:"FailoverAddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools) SetFailoverAddrPool(v []*DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools {
	s.FailoverAddrPool = v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The weight of the address pool.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// test
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) SetAddrCount(v int32) *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) SetId(v string) *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) SetLbaWeight(v int32) *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool {
	s.LbaWeight = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool) SetName(v string) *DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool {
	s.Name = &v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBodyLines struct {
	Line []*DescribeDnsGtmAccessStrategyResponseBodyLinesLine `json:"Line,omitempty" xml:"Line,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyResponseBodyLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBodyLines) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyLines) SetLine(v []*DescribeDnsGtmAccessStrategyResponseBodyLinesLine) *DescribeDnsGtmAccessStrategyResponseBodyLines {
	s.Line = v
	return s
}

type DescribeDnsGtmAccessStrategyResponseBodyLinesLine struct {
	// The code of the source region group.
	//
	// example:
	//
	// default
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the source region group.
	//
	// example:
	//
	// global
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The line code of the source region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The line name of the source region.
	//
	// example:
	//
	// global
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyResponseBodyLinesLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponseBodyLinesLine) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyLinesLine) SetGroupCode(v string) *DescribeDnsGtmAccessStrategyResponseBodyLinesLine {
	s.GroupCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyLinesLine) SetGroupName(v string) *DescribeDnsGtmAccessStrategyResponseBodyLinesLine {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyLinesLine) SetLineCode(v string) *DescribeDnsGtmAccessStrategyResponseBodyLinesLine {
	s.LineCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponseBodyLinesLine) SetLineName(v string) *DescribeDnsGtmAccessStrategyResponseBodyLinesLine {
	s.LineName = &v
	return s
}

type DescribeDnsGtmAccessStrategyResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmAccessStrategyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmAccessStrategyResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponse) SetStatusCode(v int32) *DescribeDnsGtmAccessStrategyResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyResponse) SetBody(v *DescribeDnsGtmAccessStrategyResponseBody) *DescribeDnsGtmAccessStrategyResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigRequest struct {
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The type of the access policy. Valid values:
	//
	// 	- GEO: geographical location-based
	//
	// 	- LATENCY: latency-based
	//
	// This parameter is required.
	//
	// example:
	//
	// geo
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigRequest) SetInstanceId(v string) *DescribeDnsGtmAccessStrategyAvailableConfigRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigRequest) SetLang(v string) *DescribeDnsGtmAccessStrategyAvailableConfigRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigRequest) SetStrategyMode(v string) *DescribeDnsGtmAccessStrategyAvailableConfigRequest {
	s.StrategyMode = &v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBody struct {
	// The available address pools of the domain name type.
	DomainAddrPools *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools `json:"DomainAddrPools,omitempty" xml:"DomainAddrPools,omitempty" type:"Struct"`
	// The available address pools of the IPv4 type.
	Ipv4AddrPools *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools `json:"Ipv4AddrPools,omitempty" xml:"Ipv4AddrPools,omitempty" type:"Struct"`
	// The available address pools of the IPv6 type.
	Ipv6AddrPools *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools `json:"Ipv6AddrPools,omitempty" xml:"Ipv6AddrPools,omitempty" type:"Struct"`
	// The source regions.
	Lines *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines `json:"Lines,omitempty" xml:"Lines,omitempty" type:"Struct"`
	// The ID of the request.
	//
	// example:
	//
	// C2851BA9-CE56-49AF-8D12-4FC6A49EE688
	RequestId           *string                                                                     `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	SelectedDomainLines *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines `json:"SelectedDomainLines,omitempty" xml:"SelectedDomainLines,omitempty" type:"Struct"`
	SelectedIpv4Lines   *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines   `json:"SelectedIpv4Lines,omitempty" xml:"SelectedIpv4Lines,omitempty" type:"Struct"`
	SelectedIpv6Lines   *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines   `json:"SelectedIpv6Lines,omitempty" xml:"SelectedIpv6Lines,omitempty" type:"Struct"`
	// Indicates whether we recommend that you set the source region to global.
	//
	// example:
	//
	// true
	SuggestSetDefaultLine *bool `json:"SuggestSetDefaultLine,omitempty" xml:"SuggestSetDefaultLine,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetDomainAddrPools(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.DomainAddrPools = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetIpv4AddrPools(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.Ipv4AddrPools = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetIpv6AddrPools(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.Ipv6AddrPools = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetLines(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.Lines = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetRequestId(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetSelectedDomainLines(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.SelectedDomainLines = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetSelectedIpv4Lines(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.SelectedIpv4Lines = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetSelectedIpv6Lines(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.SelectedIpv6Lines = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) SetSuggestSetDefaultLine(v bool) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody {
	s.SuggestSetDefaultLine = &v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools struct {
	DomainAddrPool []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool `json:"DomainAddrPool,omitempty" xml:"DomainAddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools) SetDomainAddrPool(v []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools {
	s.DomainAddrPool = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// testpool
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool) SetAddrCount(v int32) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool) SetId(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool) SetName(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool {
	s.Name = &v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools struct {
	Ipv4AddrPool []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool `json:"Ipv4AddrPool,omitempty" xml:"Ipv4AddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools) SetIpv4AddrPool(v []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools {
	s.Ipv4AddrPool = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// testpool
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool) SetAddrCount(v int32) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool) SetId(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool) SetName(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool {
	s.Name = &v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools struct {
	Ipv6AddrPool []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool `json:"Ipv6AddrPool,omitempty" xml:"Ipv6AddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools) SetIpv6AddrPool(v []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools {
	s.Ipv6AddrPool = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool1
	Id *string `json:"Id,omitempty" xml:"Id,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// testpool
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool) SetAddrCount(v int32) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool) SetId(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool) SetName(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool {
	s.Name = &v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines struct {
	Line []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine `json:"Line,omitempty" xml:"Line,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines) SetLine(v []*DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines {
	s.Line = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine struct {
	// The parent line code of the source region. Leave it blank if no parent line exists.
	//
	// example:
	//
	// telecom
	FatherCode *string `json:"FatherCode,omitempty" xml:"FatherCode,omitempty"`
	// The line name of the source region.
	//
	// example:
	//
	// default
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the source region group.
	//
	// example:
	//
	// global
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The line code of the source region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The code of the source region group.
	//
	// example:
	//
	// global
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetFatherCode(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.FatherCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetGroupCode(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.GroupCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetGroupName(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetLineCode(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.LineCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetLineName(v string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.LineName = &v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines struct {
	SelectedDomainLine []*string `json:"SelectedDomainLine,omitempty" xml:"SelectedDomainLine,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines) SetSelectedDomainLine(v []*string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines {
	s.SelectedDomainLine = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines struct {
	SelectedIpv4Line []*string `json:"SelectedIpv4Line,omitempty" xml:"SelectedIpv4Line,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines) SetSelectedIpv4Line(v []*string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines {
	s.SelectedIpv4Line = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines struct {
	SelectedIpv6Line []*string `json:"SelectedIpv6Line,omitempty" xml:"SelectedIpv6Line,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines) SetSelectedIpv6Line(v []*string) *DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines {
	s.SelectedIpv6Line = v
	return s
}

type DescribeDnsGtmAccessStrategyAvailableConfigResponse struct {
	Headers    map[string]*string                                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAccessStrategyAvailableConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmAccessStrategyAvailableConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponse) SetStatusCode(v int32) *DescribeDnsGtmAccessStrategyAvailableConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmAccessStrategyAvailableConfigResponse) SetBody(v *DescribeDnsGtmAccessStrategyAvailableConfigResponseBody) *DescribeDnsGtmAccessStrategyAvailableConfigResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmAddrAttributeInfoRequest struct {
	// The addresses.
	//
	// This parameter is required.
	//
	// example:
	//
	// ["1.1.1.1"]
	Addrs *string `json:"Addrs,omitempty" xml:"Addrs,omitempty"`
	// The language of the values for specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The type of addresses. Valid values:
	//
	// 	- IPV4: IPv4 address
	//
	// 	- IPv6: IPv6 address
	//
	// 	- DOMAIN: domain name
	//
	// This parameter is required.
	//
	// example:
	//
	// ipv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribeDnsGtmAddrAttributeInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddrAttributeInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddrAttributeInfoRequest) SetAddrs(v string) *DescribeDnsGtmAddrAttributeInfoRequest {
	s.Addrs = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoRequest) SetLang(v string) *DescribeDnsGtmAddrAttributeInfoRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoRequest) SetType(v string) *DescribeDnsGtmAddrAttributeInfoRequest {
	s.Type = &v
	return s
}

type DescribeDnsGtmAddrAttributeInfoResponseBody struct {
	// The address in the address pool.
	Addr *DescribeDnsGtmAddrAttributeInfoResponseBodyAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Struct"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBody) SetAddr(v *DescribeDnsGtmAddrAttributeInfoResponseBodyAddr) *DescribeDnsGtmAddrAttributeInfoResponseBody {
	s.Addr = v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBody) SetRequestId(v string) *DescribeDnsGtmAddrAttributeInfoResponseBody {
	s.RequestId = &v
	return s
}

type DescribeDnsGtmAddrAttributeInfoResponseBodyAddr struct {
	Addr []*DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBodyAddr) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBodyAddr) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddr) SetAddr(v []*DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddr {
	s.Addr = v
	return s
}

type DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr struct {
	// The address in the address pool.
	//
	// example:
	//
	// 1.1.1.1
	Addr *string `json:"Addr,omitempty" xml:"Addr,omitempty"`
	// The information about the source region of the address.
	AttributeInfo *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty" type:"Struct"`
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr) SetAddr(v string) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr {
	s.Addr = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr) SetAttributeInfo(v *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr {
	s.AttributeInfo = v
	return s
}

type DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo struct {
	// The parent line code of the source region.
	//
	// example:
	//
	// telecom
	FatherCode *string `json:"FatherCode,omitempty" xml:"FatherCode,omitempty"`
	// The code of the source region group.
	//
	// example:
	//
	// DEFAULT
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the source region group.
	//
	// example:
	//
	// Global
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The line code of the source region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The line name of the source region.
	//
	// example:
	//
	// Global
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) SetFatherCode(v string) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo {
	s.FatherCode = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) SetGroupCode(v string) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo {
	s.GroupCode = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) SetGroupName(v string) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) SetLineCode(v string) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo {
	s.LineCode = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo) SetLineName(v string) *DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo {
	s.LineName = &v
	return s
}

type DescribeDnsGtmAddrAttributeInfoResponse struct {
	Headers    map[string]*string                           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmAddrAttributeInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmAddrAttributeInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddrAttributeInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddrAttributeInfoResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmAddrAttributeInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponse) SetStatusCode(v int32) *DescribeDnsGtmAddrAttributeInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmAddrAttributeInfoResponse) SetBody(v *DescribeDnsGtmAddrAttributeInfoResponseBody) *DescribeDnsGtmAddrAttributeInfoResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmAddressPoolAvailableConfigRequest struct {
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmAddressPoolAvailableConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddressPoolAvailableConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigRequest) SetInstanceId(v string) *DescribeDnsGtmAddressPoolAvailableConfigRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigRequest) SetLang(v string) *DescribeDnsGtmAddressPoolAvailableConfigRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmAddressPoolAvailableConfigResponseBody struct {
	// The supported source regions.
	AttributeInfos *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos `json:"AttributeInfos,omitempty" xml:"AttributeInfos,omitempty" type:"Struct"`
	// The ID of the request.
	//
	// example:
	//
	// 199C3699-9A7B-41A1-BB5A-F1E862D3CB38
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBody) SetAttributeInfos(v *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos) *DescribeDnsGtmAddressPoolAvailableConfigResponseBody {
	s.AttributeInfos = v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBody) SetRequestId(v string) *DescribeDnsGtmAddressPoolAvailableConfigResponseBody {
	s.RequestId = &v
	return s
}

type DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos struct {
	AttributeInfo []*DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos) SetAttributeInfo(v []*DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos {
	s.AttributeInfo = v
	return s
}

type DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo struct {
	// The parent line code of the source region.
	//
	// example:
	//
	// telecom
	FatherCode *string `json:"FatherCode,omitempty" xml:"FatherCode,omitempty"`
	// The code of the source region group.
	//
	// example:
	//
	// default
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the request source group.
	//
	// example:
	//
	// global
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The line code of the source region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The line name of the source region.
	//
	// example:
	//
	// global
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) SetFatherCode(v string) *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo {
	s.FatherCode = &v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) SetGroupCode(v string) *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo {
	s.GroupCode = &v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) SetGroupName(v string) *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) SetLineCode(v string) *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo {
	s.LineCode = &v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo) SetLineName(v string) *DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo {
	s.LineName = &v
	return s
}

type DescribeDnsGtmAddressPoolAvailableConfigResponse struct {
	Headers    map[string]*string                                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmAddressPoolAvailableConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAddressPoolAvailableConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmAddressPoolAvailableConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponse) SetStatusCode(v int32) *DescribeDnsGtmAddressPoolAvailableConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmAddressPoolAvailableConfigResponse) SetBody(v *DescribeDnsGtmAddressPoolAvailableConfigResponseBody) *DescribeDnsGtmAddressPoolAvailableConfigResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmAvailableAlertGroupRequest struct {
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmAvailableAlertGroupRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAvailableAlertGroupRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAvailableAlertGroupRequest) SetLang(v string) *DescribeDnsGtmAvailableAlertGroupRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmAvailableAlertGroupResponseBody struct {
	// The returned available alert groups.
	AvailableAlertGroup *string `json:"AvailableAlertGroup,omitempty" xml:"AvailableAlertGroup,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeDnsGtmAvailableAlertGroupResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAvailableAlertGroupResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAvailableAlertGroupResponseBody) SetAvailableAlertGroup(v string) *DescribeDnsGtmAvailableAlertGroupResponseBody {
	s.AvailableAlertGroup = &v
	return s
}

func (s *DescribeDnsGtmAvailableAlertGroupResponseBody) SetRequestId(v string) *DescribeDnsGtmAvailableAlertGroupResponseBody {
	s.RequestId = &v
	return s
}

type DescribeDnsGtmAvailableAlertGroupResponse struct {
	Headers    map[string]*string                             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmAvailableAlertGroupResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmAvailableAlertGroupResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmAvailableAlertGroupResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmAvailableAlertGroupResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmAvailableAlertGroupResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmAvailableAlertGroupResponse) SetStatusCode(v int32) *DescribeDnsGtmAvailableAlertGroupResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmAvailableAlertGroupResponse) SetBody(v *DescribeDnsGtmAvailableAlertGroupResponseBody) *DescribeDnsGtmAvailableAlertGroupResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmInstanceRequest struct {
	// The ID of the instance about which you want to query the information.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmInstanceRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceRequest) SetInstanceId(v string) *DescribeDnsGtmInstanceRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmInstanceRequest) SetLang(v string) *DescribeDnsGtmInstanceRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmInstanceResponseBody struct {
	// The configurations of the instance.
	Config *DescribeDnsGtmInstanceResponseBodyConfig `json:"Config,omitempty" xml:"Config,omitempty" type:"Struct"`
	// The time when the instance was created.
	//
	// example:
	//
	// 2020-10-14T06:58Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The UNIX timestamp that indicates when the instance was created.
	//
	// example:
	//
	// 1602656937000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The time when the instance expires.
	//
	// example:
	//
	// 2020-10-14T06:58Z
	ExpireTime *string `json:"ExpireTime,omitempty" xml:"ExpireTime,omitempty"`
	// The UNIX timestamp that indicates when the instance expires.
	//
	// example:
	//
	// 1602656937000
	ExpireTimestamp *int64 `json:"ExpireTimestamp,omitempty" xml:"ExpireTimestamp,omitempty"`
	// The ID of the instance.
	//
	// example:
	//
	// instanceid1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The billing method. Valid value:
	//
	// 	- Subscription: You can pay in advance for the use of resources.
	//
	// example:
	//
	// Subscription
	PaymentType *string `json:"PaymentType,omitempty" xml:"PaymentType,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 84314904-D047-4176-A0EC-256D7F68C7F5
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the resource group to which the instance belongs.
	//
	// example:
	//
	// resourcegroupid1
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	// The total number of SMS notifications.
	//
	// example:
	//
	// 100
	SmsQuota *int32 `json:"SmsQuota,omitempty" xml:"SmsQuota,omitempty"`
	// The total number of detection tasks.
	//
	// example:
	//
	// 100
	TaskQuota *int32 `json:"TaskQuota,omitempty" xml:"TaskQuota,omitempty"`
	// The used quota.
	UsedQuota *DescribeDnsGtmInstanceResponseBodyUsedQuota `json:"UsedQuota,omitempty" xml:"UsedQuota,omitempty" type:"Struct"`
	// The version of the instance.
	//
	// example:
	//
	// versioncode1
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeDnsGtmInstanceResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceResponseBody) SetConfig(v *DescribeDnsGtmInstanceResponseBodyConfig) *DescribeDnsGtmInstanceResponseBody {
	s.Config = v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetCreateTime(v string) *DescribeDnsGtmInstanceResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetCreateTimestamp(v int64) *DescribeDnsGtmInstanceResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetExpireTime(v string) *DescribeDnsGtmInstanceResponseBody {
	s.ExpireTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetExpireTimestamp(v int64) *DescribeDnsGtmInstanceResponseBody {
	s.ExpireTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetInstanceId(v string) *DescribeDnsGtmInstanceResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetPaymentType(v string) *DescribeDnsGtmInstanceResponseBody {
	s.PaymentType = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetRequestId(v string) *DescribeDnsGtmInstanceResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetResourceGroupId(v string) *DescribeDnsGtmInstanceResponseBody {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetSmsQuota(v int32) *DescribeDnsGtmInstanceResponseBody {
	s.SmsQuota = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetTaskQuota(v int32) *DescribeDnsGtmInstanceResponseBody {
	s.TaskQuota = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetUsedQuota(v *DescribeDnsGtmInstanceResponseBodyUsedQuota) *DescribeDnsGtmInstanceResponseBody {
	s.UsedQuota = v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBody) SetVersionCode(v string) *DescribeDnsGtmInstanceResponseBody {
	s.VersionCode = &v
	return s
}

type DescribeDnsGtmInstanceResponseBodyConfig struct {
	// The alert notification method.
	AlertConfig *DescribeDnsGtmInstanceResponseBodyConfigAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Struct"`
	// The name of the alert group.
	//
	// example:
	//
	// alertgroup1
	AlertGroup *string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty"`
	// The type of the CNAME domain name that is used to access the instance. Valid value:
	//
	// 	- PUBLIC: The CNAME domain name is used to access the instance over the Internet.
	//
	// example:
	//
	// public
	CnameType *string `json:"CnameType,omitempty" xml:"CnameType,omitempty"`
	// The name of the instance.
	//
	// example:
	//
	// instancetest1
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// The domain name that is used to access the instance over the Internet.
	//
	// example:
	//
	// test.rr.gtm-003.com
	PubicZoneName *string `json:"PubicZoneName,omitempty" xml:"PubicZoneName,omitempty"`
	// Indicates whether a custom CNAME domain name or a CNAME domain name assigned by the system is used to access the instance over the Internet. Valid values:
	//
	// 	- CUSTOM: A custom CNAME domain name is used.
	//
	// 	- SYSTEM_ASSIGN: A CNAME domain name assigned by the system is used.
	//
	// example:
	//
	// custom
	PublicCnameMode *string `json:"PublicCnameMode,omitempty" xml:"PublicCnameMode,omitempty"`
	// The hostname corresponding to the CNAME domain name that is used to access the instance over the Internet.
	//
	// example:
	//
	// test.rr
	PublicRr *string `json:"PublicRr,omitempty" xml:"PublicRr,omitempty"`
	// The service domain name that is used over the Internet.
	//
	// example:
	//
	// example.com
	PublicUserDomainName *string `json:"PublicUserDomainName,omitempty" xml:"PublicUserDomainName,omitempty"`
	// The type of the access policy. Valid values:
	//
	// 	- LATENCY: Latency-based
	//
	// 	- GEO: Geographical location-based
	//
	// example:
	//
	// GEO
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
	// The global time to live (TTL).
	//
	// example:
	//
	// 1
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
}

func (s DescribeDnsGtmInstanceResponseBodyConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceResponseBodyConfig) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetAlertConfig(v *DescribeDnsGtmInstanceResponseBodyConfigAlertConfig) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.AlertConfig = v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetAlertGroup(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.AlertGroup = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetCnameType(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.CnameType = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetInstanceName(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.InstanceName = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetPubicZoneName(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.PubicZoneName = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetPublicCnameMode(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.PublicCnameMode = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetPublicRr(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.PublicRr = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetPublicUserDomainName(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.PublicUserDomainName = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetStrategyMode(v string) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.StrategyMode = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfig) SetTtl(v int32) *DescribeDnsGtmInstanceResponseBodyConfig {
	s.Ttl = &v
	return s
}

type DescribeDnsGtmInstanceResponseBodyConfigAlertConfig struct {
	AlertConfig []*DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmInstanceResponseBodyConfigAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceResponseBodyConfigAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceResponseBodyConfigAlertConfig) SetAlertConfig(v []*DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) *DescribeDnsGtmInstanceResponseBodyConfigAlertConfig {
	s.AlertConfig = v
	return s
}

type DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig struct {
	DingtalkNotice *bool `json:"DingtalkNotice,omitempty" xml:"DingtalkNotice,omitempty"`
	// Indicates whether email notification is configured. Valid values:
	//
	// 	- true: Email notification is configured.
	//
	// 	- false: Email notification is not configured. null: Email notification is not configured.
	//
	// example:
	//
	// true
	EmailNotice *bool `json:"EmailNotice,omitempty" xml:"EmailNotice,omitempty"`
	// The type of the alert event. Valid values:
	//
	// 	- ADDR_ALERT: The address is unavailable.
	//
	// 	- ADDR_RESUME: The address is restored and becomes available.
	//
	// 	- ADDR_POOL_GROUP_UNAVAILABLE: The address pool group is unavailable.
	//
	// 	- ADDR_POOL_GROUP_AVAILABLE: The address pool group is restored and becomes available.
	//
	// 	- ACCESS_STRATEGY_POOL_GROUP_SWITCH: Switchover is triggered between the primary and secondary address pools.
	//
	// 	- MONITOR_NODE_IP_CHANGE: The IP address of the monitoring node has changed.
	//
	// example:
	//
	// ADDR_ALERT
	NoticeType *string `json:"NoticeType,omitempty" xml:"NoticeType,omitempty"`
	// Indicates whether SMS notification is configured. Valid values:
	//
	// 	- true: SMS notification is configured.
	//
	// 	- false: SMS notification is not configured. null: SMS notification is not configured.
	//
	// example:
	//
	// true
	SmsNotice *bool `json:"SmsNotice,omitempty" xml:"SmsNotice,omitempty"`
}

func (s DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) SetDingtalkNotice(v bool) *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig {
	s.DingtalkNotice = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) SetEmailNotice(v bool) *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig {
	s.EmailNotice = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) SetNoticeType(v string) *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig {
	s.NoticeType = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig) SetSmsNotice(v bool) *DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig {
	s.SmsNotice = &v
	return s
}

type DescribeDnsGtmInstanceResponseBodyUsedQuota struct {
	DingtalkUsedCount *int32 `json:"DingtalkUsedCount,omitempty" xml:"DingtalkUsedCount,omitempty"`
	// The total number of emails that were sent.
	//
	// example:
	//
	// 123
	EmailUsedCount *int32 `json:"EmailUsedCount,omitempty" xml:"EmailUsedCount,omitempty"`
	// The total number of short messages that were sent.
	//
	// example:
	//
	// 123
	SmsUsedCount *int32 `json:"SmsUsedCount,omitempty" xml:"SmsUsedCount,omitempty"`
	// The number of detection tasks that were created.
	//
	// example:
	//
	// 123
	TaskUsedCount *int32 `json:"TaskUsedCount,omitempty" xml:"TaskUsedCount,omitempty"`
}

func (s DescribeDnsGtmInstanceResponseBodyUsedQuota) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceResponseBodyUsedQuota) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceResponseBodyUsedQuota) SetDingtalkUsedCount(v int32) *DescribeDnsGtmInstanceResponseBodyUsedQuota {
	s.DingtalkUsedCount = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyUsedQuota) SetEmailUsedCount(v int32) *DescribeDnsGtmInstanceResponseBodyUsedQuota {
	s.EmailUsedCount = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyUsedQuota) SetSmsUsedCount(v int32) *DescribeDnsGtmInstanceResponseBodyUsedQuota {
	s.SmsUsedCount = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponseBodyUsedQuota) SetTaskUsedCount(v int32) *DescribeDnsGtmInstanceResponseBodyUsedQuota {
	s.TaskUsedCount = &v
	return s
}

type DescribeDnsGtmInstanceResponse struct {
	Headers    map[string]*string                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmInstanceResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmInstanceResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmInstanceResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmInstanceResponse) SetStatusCode(v int32) *DescribeDnsGtmInstanceResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmInstanceResponse) SetBody(v *DescribeDnsGtmInstanceResponseBody) *DescribeDnsGtmInstanceResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmInstanceAddressPoolRequest struct {
	// The ID of the address pool.
	//
	// This parameter is required.
	//
	// example:
	//
	// testpool1
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolRequest) SetAddrPoolId(v string) *DescribeDnsGtmInstanceAddressPoolRequest {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolRequest) SetLang(v string) *DescribeDnsGtmInstanceAddressPoolRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmInstanceAddressPoolResponseBody struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// testpool1
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The addresses in the address pool.
	Addrs *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs `json:"Addrs,omitempty" xml:"Addrs,omitempty" type:"Struct"`
	// The time when the address pool was created.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates the time when the address pool was created.
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The load balancing policy for the address pool. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	LbaStrategy *string `json:"LbaStrategy,omitempty" xml:"LbaStrategy,omitempty"`
	// The ID of the health check configuration.
	//
	// example:
	//
	// test1
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// Indicates the status of the health check. Valid values:
	//
	// 	- OPEN: The health check is enabled.
	//
	// 	- CLOSE: The health check is disabled.
	//
	// 	- UNCONFIGURED: The health check is not configured.
	//
	// example:
	//
	// open
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// test
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- IPV4: IPv4 address
	//
	// 	- IPV6: IPv6 address
	//
	// 	- DOMAIN: domain name
	//
	// example:
	//
	// ipv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The time when the address pool was last updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The timestamp that indicates the time when the address pool was last updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetAddrCount(v int32) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetAddrPoolId(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetAddrs(v *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.Addrs = v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetCreateTime(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetCreateTimestamp(v int64) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetLbaStrategy(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.LbaStrategy = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetMonitorConfigId(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetMonitorStatus(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.MonitorStatus = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetName(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetRequestId(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetType(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.Type = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetUpdateTime(v string) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBody) SetUpdateTimestamp(v int64) *DescribeDnsGtmInstanceAddressPoolResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs struct {
	Addr []*DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs) SetAddr(v []*DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs {
	s.Addr = v
	return s
}

type DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr struct {
	// The address.
	//
	// example:
	//
	// 1.1.1.1
	Addr *string `json:"Addr,omitempty" xml:"Addr,omitempty"`
	// The status of the last health check on the address. Valid values:
	//
	// 	- OK: No active alerts are triggered.
	//
	// 	- ALERT: Alerts are triggered based on the alert rules.
	//
	// example:
	//
	// ok
	AlertStatus *string `json:"AlertStatus,omitempty" xml:"AlertStatus,omitempty"`
	// The source region of the address.
	//
	// 	- lineCode: the line code of the source region of the address. This parameter is deprecated, and lineCodes prevails.
	//
	// 	- lineName: the line name of the source region of the address. This parameter is deprecated.
	//
	// 	- lineCodes: the line codes of the source regions of the address.
	//
	// example:
	//
	// "lineCode":"aliyun_r_cn-zhangjiakou", "lineName": "Alibaba Cloud_China (Zhangjiakou)", "lineCodes": ["aliyun_r_cn-zhangjiakou"]
	AttributeInfo *string `json:"AttributeInfo,omitempty" xml:"AttributeInfo,omitempty"`
	// The time when the address was added into the address pool.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates the time when the address was added into the address pool.
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The weight of the address.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The mode of the address. Valid values:
	//
	// 	- SMART: smart return
	//
	// 	- ONLINE: always online
	//
	// 	- OFFLINE: always offline
	//
	// example:
	//
	// online
	Mode *string `json:"Mode,omitempty" xml:"Mode,omitempty"`
	// The description of the address.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The time when the address was last updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The timestamp that indicates the time when the address was last updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetAddr(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.Addr = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetAlertStatus(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.AlertStatus = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetAttributeInfo(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.AttributeInfo = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetCreateTime(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetCreateTimestamp(v int64) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetLbaWeight(v int32) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.LbaWeight = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetMode(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.Mode = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetRemark(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.Remark = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetUpdateTime(v string) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.UpdateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr) SetUpdateTimestamp(v int64) *DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.UpdateTimestamp = &v
	return s
}

type DescribeDnsGtmInstanceAddressPoolResponse struct {
	Headers    map[string]*string                             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmInstanceAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmInstanceAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponse) SetStatusCode(v int32) *DescribeDnsGtmInstanceAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolResponse) SetBody(v *DescribeDnsGtmInstanceAddressPoolResponseBody) *DescribeDnsGtmInstanceAddressPoolResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmInstanceAddressPoolsRequest struct {
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: 100. Default value: 20.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolsRequest) SetInstanceId(v string) *DescribeDnsGtmInstanceAddressPoolsRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsRequest) SetLang(v string) *DescribeDnsGtmInstanceAddressPoolsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsRequest) SetPageNumber(v int32) *DescribeDnsGtmInstanceAddressPoolsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsRequest) SetPageSize(v int32) *DescribeDnsGtmInstanceAddressPoolsRequest {
	s.PageSize = &v
	return s
}

type DescribeDnsGtmInstanceAddressPoolsResponseBody struct {
	// The returned address pools.
	AddrPools *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools `json:"AddrPools,omitempty" xml:"AddrPools,omitempty" type:"Struct"`
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 1
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBody) SetAddrPools(v *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools) *DescribeDnsGtmInstanceAddressPoolsResponseBody {
	s.AddrPools = v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBody) SetPageNumber(v int32) *DescribeDnsGtmInstanceAddressPoolsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBody) SetPageSize(v int32) *DescribeDnsGtmInstanceAddressPoolsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBody) SetRequestId(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBody) SetTotalItems(v int32) *DescribeDnsGtmInstanceAddressPoolsResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBody) SetTotalPages(v int32) *DescribeDnsGtmInstanceAddressPoolsResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools struct {
	AddrPool []*DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool `json:"AddrPool,omitempty" xml:"AddrPool,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools) SetAddrPool(v []*DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools {
	s.AddrPool = v
	return s
}

type DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 1
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// pool-1
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The time when the address pool was created.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates when the address pool was created.
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The load balancing policy of the address pool. Valid values:
	//
	// 	- ALL_RR: returns all addresses.
	//
	// 	- RATIO: returns addresses by weight.
	//
	// example:
	//
	// all_rr
	LbaStrategy *string `json:"LbaStrategy,omitempty" xml:"LbaStrategy,omitempty"`
	// The ID of the health check task.
	//
	// example:
	//
	// abc123
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// Indicates whether health checks are configured. Valid values:
	//
	// 	- OPEN: enabled
	//
	// 	- CLOSE: disabled
	//
	// 	- UNCONFIGURED: not configured
	//
	// example:
	//
	// open
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// testpool
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- IPV4: IPv4 address
	//
	// 	- IPV6: IPv6 address
	//
	// 	- DOMAIN: domain name
	//
	// example:
	//
	// ipv4
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The time when the address pool was updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The timestamp that indicates when the address pool was updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetAddrCount(v int32) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetAddrPoolId(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetCreateTime(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetCreateTimestamp(v int64) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetLbaStrategy(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.LbaStrategy = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetMonitorConfigId(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.MonitorConfigId = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetMonitorStatus(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.MonitorStatus = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetName(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.Name = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetType(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.Type = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetUpdateTime(v string) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.UpdateTime = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetUpdateTimestamp(v int64) *DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.UpdateTimestamp = &v
	return s
}

type DescribeDnsGtmInstanceAddressPoolsResponse struct {
	Headers    map[string]*string                              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmInstanceAddressPoolsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmInstanceAddressPoolsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceAddressPoolsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmInstanceAddressPoolsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponse) SetStatusCode(v int32) *DescribeDnsGtmInstanceAddressPoolsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmInstanceAddressPoolsResponse) SetBody(v *DescribeDnsGtmInstanceAddressPoolsResponseBody) *DescribeDnsGtmInstanceAddressPoolsResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmInstanceStatusRequest struct {
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmInstanceStatusRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceStatusRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceStatusRequest) SetInstanceId(v string) *DescribeDnsGtmInstanceStatusRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusRequest) SetLang(v string) *DescribeDnsGtmInstanceStatusRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmInstanceStatusResponseBody struct {
	// The number of available addresses.
	//
	// example:
	//
	// 1
	AddrAvailableNum *int32 `json:"AddrAvailableNum,omitempty" xml:"AddrAvailableNum,omitempty"`
	// The number of unavailable addresses.
	//
	// example:
	//
	// 1
	AddrNotAvailableNum *int32 `json:"AddrNotAvailableNum,omitempty" xml:"AddrNotAvailableNum,omitempty"`
	// The number of unavailable address pool groups.
	//
	// example:
	//
	// 1
	AddrPoolGroupNotAvailableNum *int32 `json:"AddrPoolGroupNotAvailableNum,omitempty" xml:"AddrPoolGroupNotAvailableNum,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 389DFFA3-77A5-4A9E-BF3D-147C6F98A5BA
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The number of access policies that are unavailable in the current active address pool group.
	//
	// example:
	//
	// 1
	StrategyNotAvailableNum *int32 `json:"StrategyNotAvailableNum,omitempty" xml:"StrategyNotAvailableNum,omitempty"`
	// The number of access policies switched to the secondary address pool group.
	//
	// example:
	//
	// 1
	SwitchToFailoverStrategyNum *int32 `json:"SwitchToFailoverStrategyNum,omitempty" xml:"SwitchToFailoverStrategyNum,omitempty"`
}

func (s DescribeDnsGtmInstanceStatusResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceStatusResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceStatusResponseBody) SetAddrAvailableNum(v int32) *DescribeDnsGtmInstanceStatusResponseBody {
	s.AddrAvailableNum = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponseBody) SetAddrNotAvailableNum(v int32) *DescribeDnsGtmInstanceStatusResponseBody {
	s.AddrNotAvailableNum = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponseBody) SetAddrPoolGroupNotAvailableNum(v int32) *DescribeDnsGtmInstanceStatusResponseBody {
	s.AddrPoolGroupNotAvailableNum = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponseBody) SetRequestId(v string) *DescribeDnsGtmInstanceStatusResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponseBody) SetStrategyNotAvailableNum(v int32) *DescribeDnsGtmInstanceStatusResponseBody {
	s.StrategyNotAvailableNum = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponseBody) SetSwitchToFailoverStrategyNum(v int32) *DescribeDnsGtmInstanceStatusResponseBody {
	s.SwitchToFailoverStrategyNum = &v
	return s
}

type DescribeDnsGtmInstanceStatusResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmInstanceStatusResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmInstanceStatusResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceStatusResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceStatusResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmInstanceStatusResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponse) SetStatusCode(v int32) *DescribeDnsGtmInstanceStatusResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmInstanceStatusResponse) SetBody(v *DescribeDnsGtmInstanceStatusResponseBody) *DescribeDnsGtmInstanceStatusResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmInstanceSystemCnameRequest struct {
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmInstanceSystemCnameRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceSystemCnameRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceSystemCnameRequest) SetInstanceId(v string) *DescribeDnsGtmInstanceSystemCnameRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmInstanceSystemCnameRequest) SetLang(v string) *DescribeDnsGtmInstanceSystemCnameRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmInstanceSystemCnameResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The CNAME domain name assigned by the system.
	//
	// example:
	//
	// gtminstance.com
	SystemCname *string `json:"SystemCname,omitempty" xml:"SystemCname,omitempty"`
}

func (s DescribeDnsGtmInstanceSystemCnameResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceSystemCnameResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceSystemCnameResponseBody) SetRequestId(v string) *DescribeDnsGtmInstanceSystemCnameResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmInstanceSystemCnameResponseBody) SetSystemCname(v string) *DescribeDnsGtmInstanceSystemCnameResponseBody {
	s.SystemCname = &v
	return s
}

type DescribeDnsGtmInstanceSystemCnameResponse struct {
	Headers    map[string]*string                             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmInstanceSystemCnameResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmInstanceSystemCnameResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstanceSystemCnameResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstanceSystemCnameResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmInstanceSystemCnameResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmInstanceSystemCnameResponse) SetStatusCode(v int32) *DescribeDnsGtmInstanceSystemCnameResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmInstanceSystemCnameResponse) SetBody(v *DescribeDnsGtmInstanceSystemCnameResponseBody) *DescribeDnsGtmInstanceSystemCnameResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmInstancesRequest struct {
	// The keyword that you use for the query. Fuzzy search by instance ID or instance name is supported.
	//
	// example:
	//
	// instance1
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language of the values for specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The resource group ID.
	//
	// example:
	//
	// rg-testgroupid
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
}

func (s DescribeDnsGtmInstancesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesRequest) SetKeyword(v string) *DescribeDnsGtmInstancesRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeDnsGtmInstancesRequest) SetLang(v string) *DescribeDnsGtmInstancesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmInstancesRequest) SetPageNumber(v int32) *DescribeDnsGtmInstancesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmInstancesRequest) SetPageSize(v int32) *DescribeDnsGtmInstancesRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmInstancesRequest) SetResourceGroupId(v string) *DescribeDnsGtmInstancesRequest {
	s.ResourceGroupId = &v
	return s
}

type DescribeDnsGtmInstancesResponseBody struct {
	// The Global Traffic Manager (GTM) instances.
	GtmInstances []*DescribeDnsGtmInstancesResponseBodyGtmInstances `json:"GtmInstances,omitempty" xml:"GtmInstances,omitempty" type:"Repeated"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Maximum value: 100. Default value: 20.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 84314904-D047-4176-A0EC-256D7F68C7F5
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 100
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 123
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDnsGtmInstancesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesResponseBody) SetGtmInstances(v []*DescribeDnsGtmInstancesResponseBodyGtmInstances) *DescribeDnsGtmInstancesResponseBody {
	s.GtmInstances = v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBody) SetPageNumber(v int32) *DescribeDnsGtmInstancesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBody) SetPageSize(v int32) *DescribeDnsGtmInstancesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBody) SetRequestId(v string) *DescribeDnsGtmInstancesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBody) SetTotalItems(v int32) *DescribeDnsGtmInstancesResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBody) SetTotalPages(v int32) *DescribeDnsGtmInstancesResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDnsGtmInstancesResponseBodyGtmInstances struct {
	// The configurations of the instance.
	Config *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig `json:"Config,omitempty" xml:"Config,omitempty" type:"Struct"`
	// The time when the instance was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2020-10-14T06:58Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The time when the instance was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1602658709000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The time when the instance expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2020-10-14T06:58Z
	ExpireTime *string `json:"ExpireTime,omitempty" xml:"ExpireTime,omitempty"`
	// The time when the instance expires. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1602658709000
	ExpireTimestamp *int64 `json:"ExpireTimestamp,omitempty" xml:"ExpireTimestamp,omitempty"`
	// The instance ID.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The billing method of the GTM instance. Valid value:
	//
	// 	- Subscription.
	//
	// example:
	//
	// Subscription
	PaymentType *string `json:"PaymentType,omitempty" xml:"PaymentType,omitempty"`
	// The ID of the resource group.
	//
	// example:
	//
	// resourceGroupid123
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	// The total number of Short Message Service (SMS) notifications.
	//
	// example:
	//
	// 1
	SmsQuota *int32 `json:"SmsQuota,omitempty" xml:"SmsQuota,omitempty"`
	// The total number of detection tasks.
	//
	// example:
	//
	// 1
	TaskQuota *int32 `json:"TaskQuota,omitempty" xml:"TaskQuota,omitempty"`
	// The used quota.
	UsedQuota *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota `json:"UsedQuota,omitempty" xml:"UsedQuota,omitempty" type:"Struct"`
	// The version of the instance.
	//
	// example:
	//
	// testVersion1
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstances) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstances) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetConfig(v *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.Config = v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetCreateTime(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetCreateTimestamp(v int64) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetExpireTime(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.ExpireTime = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetExpireTimestamp(v int64) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.ExpireTimestamp = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetInstanceId(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetPaymentType(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.PaymentType = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetResourceGroupId(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetSmsQuota(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.SmsQuota = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetTaskQuota(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.TaskQuota = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetUsedQuota(v *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.UsedQuota = v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstances) SetVersionCode(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstances {
	s.VersionCode = &v
	return s
}

type DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig struct {
	// The alert notification method.
	AlertConfig []*DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig `json:"AlertConfig,omitempty" xml:"AlertConfig,omitempty" type:"Repeated"`
	// The alert contact groups. The value is in the JSON format.
	//
	// example:
	//
	// testgroup
	AlertGroup *string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty"`
	// The type of the CNAME. Valid value:
	//
	// 	- PUBLIC
	//
	// example:
	//
	// public
	CnameType *string `json:"CnameType,omitempty" xml:"CnameType,omitempty"`
	// The name of the instance.
	//
	// example:
	//
	// instanceTest
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// Specifies whether to use a custom CNAME or a system-assigned CNAME to access GTM over the Internet. Valid values:
	//
	// 	- CUSTOM: a custom CNAME
	//
	// 	- SYSTEM_ASSIGN: a system-assigned CNAME. You cannot set PublicCnameMode to this value.
	//
	// example:
	//
	// custom
	PublicCnameMode *string `json:"PublicCnameMode,omitempty" xml:"PublicCnameMode,omitempty"`
	// The hostname of the domain name that is used to access GTM over the Internet.
	//
	// example:
	//
	// test.rr
	PublicRr *string `json:"PublicRr,omitempty" xml:"PublicRr,omitempty"`
	// The domain name that is used to access GTM over the Internet.
	//
	// example:
	//
	// example.com
	PublicUserDomainName *string `json:"PublicUserDomainName,omitempty" xml:"PublicUserDomainName,omitempty"`
	// The canonical name (CNAME) that is used to access GTM over the Internet.
	//
	// example:
	//
	// test.rr.gtm-003.com
	PublicZoneName *string `json:"PublicZoneName,omitempty" xml:"PublicZoneName,omitempty"`
	// The type of the access policy. Valid values:
	//
	// 	- LATENCY: latency-based access policy
	//
	// 	- GEO: geographical location-based access policy
	//
	// example:
	//
	// geo
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
	// The global time to live (TTL).
	//
	// example:
	//
	// 1
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetAlertConfig(v []*DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.AlertConfig = v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetAlertGroup(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.AlertGroup = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetCnameType(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.CnameType = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetInstanceName(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.InstanceName = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetPublicCnameMode(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.PublicCnameMode = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetPublicRr(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.PublicRr = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetPublicUserDomainName(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.PublicUserDomainName = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetPublicZoneName(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.PublicZoneName = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetStrategyMode(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.StrategyMode = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig) SetTtl(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig {
	s.Ttl = &v
	return s
}

type DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig struct {
	// Indicates whether DingTalk alert notifications are configured. Valid values:
	//
	// 	- true
	//
	// 	- false | null
	//
	// example:
	//
	// true
	DingtalkNotice *string `json:"DingtalkNotice,omitempty" xml:"DingtalkNotice,omitempty"`
	// Indicates whether email notifications are configured. Valid values:
	//
	// 	- true
	//
	// 	- false | null
	//
	// example:
	//
	// true
	EmailNotice *string `json:"EmailNotice,omitempty" xml:"EmailNotice,omitempty"`
	// The type of the alert event. Valid values:
	//
	// 	- ADDR_ALERT: The address is unavailable.
	//
	// 	- ADDR_RESUME: The address becomes available.
	//
	// 	- ADDR_POOL_GROUP_UNAVAILABLE: The address pool set is unavailable.
	//
	// 	- ADDR_POOL_GROUP_AVAILABLE: The address pool set becomes available.
	//
	// 	- ACCESS_STRATEGY_POOL_GROUP_SWITCH: Switchover is triggered between the primary and secondary address pools.
	//
	// example:
	//
	// ADDR_ALERT
	NoticeType *string `json:"NoticeType,omitempty" xml:"NoticeType,omitempty"`
	// Indicates whether SMS notifications are configured. Valid values:
	//
	// 	- true
	//
	// 	- false | null
	//
	// example:
	//
	// true
	SmsNotice *string `json:"SmsNotice,omitempty" xml:"SmsNotice,omitempty"`
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) SetDingtalkNotice(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig {
	s.DingtalkNotice = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) SetEmailNotice(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig {
	s.EmailNotice = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) SetNoticeType(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig {
	s.NoticeType = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig) SetSmsNotice(v string) *DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig {
	s.SmsNotice = &v
	return s
}

type DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota struct {
	// The total number of sent DingTalk notifications.
	//
	// example:
	//
	// 100
	DingtalkUsedCount *int32 `json:"DingtalkUsedCount,omitempty" xml:"DingtalkUsedCount,omitempty"`
	// The total number of sent email notifications.
	//
	// example:
	//
	// 100
	EmailUsedCount *int32 `json:"EmailUsedCount,omitempty" xml:"EmailUsedCount,omitempty"`
	// The total number of sent SMS notifications.
	//
	// example:
	//
	// 100
	SmsUsedCount *int32 `json:"SmsUsedCount,omitempty" xml:"SmsUsedCount,omitempty"`
	// The number of created detection tasks.
	//
	// example:
	//
	// 100
	TaskUsedCount *int32 `json:"TaskUsedCount,omitempty" xml:"TaskUsedCount,omitempty"`
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) SetDingtalkUsedCount(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota {
	s.DingtalkUsedCount = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) SetEmailUsedCount(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota {
	s.EmailUsedCount = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) SetSmsUsedCount(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota {
	s.SmsUsedCount = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota) SetTaskUsedCount(v int32) *DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota {
	s.TaskUsedCount = &v
	return s
}

type DescribeDnsGtmInstancesResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmInstancesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmInstancesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmInstancesResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmInstancesResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmInstancesResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmInstancesResponse) SetStatusCode(v int32) *DescribeDnsGtmInstancesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmInstancesResponse) SetBody(v *DescribeDnsGtmInstancesResponseBody) *DescribeDnsGtmInstancesResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmLogsRequest struct {
	// The timestamp that specifies the end of the time range to query.
	//
	// example:
	//
	// 1516779348000
	EndTimestamp *int64 `json:"EndTimestamp,omitempty" xml:"EndTimestamp,omitempty"`
	// The ID of the instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The keyword for searches in "%KeyWord%" mode. The value is not case-sensitive.
	//
	// example:
	//
	// demo
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: 100. Default value: 20.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The timestamp that specifies the beginning of the time range to query.
	//
	// example:
	//
	// 1516779348000
	StartTimestamp *int64 `json:"StartTimestamp,omitempty" xml:"StartTimestamp,omitempty"`
}

func (s DescribeDnsGtmLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmLogsRequest) SetEndTimestamp(v int64) *DescribeDnsGtmLogsRequest {
	s.EndTimestamp = &v
	return s
}

func (s *DescribeDnsGtmLogsRequest) SetInstanceId(v string) *DescribeDnsGtmLogsRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsGtmLogsRequest) SetKeyword(v string) *DescribeDnsGtmLogsRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeDnsGtmLogsRequest) SetLang(v string) *DescribeDnsGtmLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmLogsRequest) SetPageNumber(v int32) *DescribeDnsGtmLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmLogsRequest) SetPageSize(v int32) *DescribeDnsGtmLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmLogsRequest) SetStartTimestamp(v int64) *DescribeDnsGtmLogsRequest {
	s.StartTimestamp = &v
	return s
}

type DescribeDnsGtmLogsResponseBody struct {
	// The returned logs.
	Logs *DescribeDnsGtmLogsResponseBodyLogs `json:"Logs,omitempty" xml:"Logs,omitempty" type:"Struct"`
	// The number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 1
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 50C60A29-2E93-425A-ABA8-068686E28873
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 1
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDnsGtmLogsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmLogsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmLogsResponseBody) SetLogs(v *DescribeDnsGtmLogsResponseBodyLogs) *DescribeDnsGtmLogsResponseBody {
	s.Logs = v
	return s
}

func (s *DescribeDnsGtmLogsResponseBody) SetPageNumber(v int32) *DescribeDnsGtmLogsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBody) SetPageSize(v int32) *DescribeDnsGtmLogsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBody) SetRequestId(v string) *DescribeDnsGtmLogsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBody) SetTotalItems(v int32) *DescribeDnsGtmLogsResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBody) SetTotalPages(v int32) *DescribeDnsGtmLogsResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDnsGtmLogsResponseBodyLogs struct {
	Log []*DescribeDnsGtmLogsResponseBodyLogsLog `json:"Log,omitempty" xml:"Log,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmLogsResponseBodyLogs) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmLogsResponseBodyLogs) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmLogsResponseBodyLogs) SetLog(v []*DescribeDnsGtmLogsResponseBodyLogsLog) *DescribeDnsGtmLogsResponseBodyLogs {
	s.Log = v
	return s
}

type DescribeDnsGtmLogsResponseBodyLogsLog struct {
	// The formatted message content.
	//
	// example:
	//
	// addtest-pool-1
	Content *string `json:"Content,omitempty" xml:"Content,omitempty"`
	// The ID of the object on which the operation was performed.
	//
	// example:
	//
	// 121212
	EntityId *string `json:"EntityId,omitempty" xml:"EntityId,omitempty"`
	// The name of the object on which the operation was performed.
	//
	// example:
	//
	// test-pool-1
	EntityName *string `json:"EntityName,omitempty" xml:"EntityName,omitempty"`
	// The type of the object on which the operation was performed.
	EntityType *string `json:"EntityType,omitempty" xml:"EntityType,omitempty"`
	// The ID of the record.
	//
	// example:
	//
	// 6726
	Id *int64 `json:"Id,omitempty" xml:"Id,omitempty"`
	// The operation performed.
	OperAction *string `json:"OperAction,omitempty" xml:"OperAction,omitempty"`
	// The time when the operation was performed.
	//
	// example:
	//
	// 2018-01-24T07:35Z
	OperTime *string `json:"OperTime,omitempty" xml:"OperTime,omitempty"`
	// The timestamp of the operation.
	//
	// example:
	//
	// 1516779348000
	OperTimestamp *int64 `json:"OperTimestamp,omitempty" xml:"OperTimestamp,omitempty"`
}

func (s DescribeDnsGtmLogsResponseBodyLogsLog) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmLogsResponseBodyLogsLog) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetContent(v string) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.Content = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetEntityId(v string) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.EntityId = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetEntityName(v string) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.EntityName = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetEntityType(v string) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.EntityType = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetId(v int64) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.Id = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetOperAction(v string) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.OperAction = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetOperTime(v string) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.OperTime = &v
	return s
}

func (s *DescribeDnsGtmLogsResponseBodyLogsLog) SetOperTimestamp(v int64) *DescribeDnsGtmLogsResponseBodyLogsLog {
	s.OperTimestamp = &v
	return s
}

type DescribeDnsGtmLogsResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmLogsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmLogsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmLogsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmLogsResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmLogsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmLogsResponse) SetStatusCode(v int32) *DescribeDnsGtmLogsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmLogsResponse) SetBody(v *DescribeDnsGtmLogsResponseBody) *DescribeDnsGtmLogsResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigRequest struct {
	// The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigRequest) SetLang(v string) *DescribeDnsGtmMonitorAvailableConfigRequest {
	s.Lang = &v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBody struct {
	// The nodes that perform health checks on domain names that use public IPv4 addresses.
	DomainIpv4IspCityNodes *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes `json:"DomainIpv4IspCityNodes,omitempty" xml:"DomainIpv4IspCityNodes,omitempty" type:"Struct"`
	// The nodes that perform health checks on domain names that use public IPv6 addresses.
	DomainIpv6IspCityNodes *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes `json:"DomainIpv6IspCityNodes,omitempty" xml:"DomainIpv6IspCityNodes,omitempty" type:"Struct"`
	// The nodes that perform health checks on public IPv4 addresses.
	Ipv4IspCityNodes *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes `json:"Ipv4IspCityNodes,omitempty" xml:"Ipv4IspCityNodes,omitempty" type:"Struct"`
	// The nodes that perform health checks on public IPv6 addresses.
	Ipv6IspCityNodes *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes `json:"Ipv6IspCityNodes,omitempty" xml:"Ipv6IspCityNodes,omitempty" type:"Struct"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBody) SetDomainIpv4IspCityNodes(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes) *DescribeDnsGtmMonitorAvailableConfigResponseBody {
	s.DomainIpv4IspCityNodes = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBody) SetDomainIpv6IspCityNodes(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes) *DescribeDnsGtmMonitorAvailableConfigResponseBody {
	s.DomainIpv6IspCityNodes = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBody) SetIpv4IspCityNodes(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes) *DescribeDnsGtmMonitorAvailableConfigResponseBody {
	s.Ipv4IspCityNodes = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBody) SetIpv6IspCityNodes(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes) *DescribeDnsGtmMonitorAvailableConfigResponseBody {
	s.Ipv6IspCityNodes = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBody) SetRequestId(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBody {
	s.RequestId = &v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes struct {
	DomainIpv4IspCityNode []*DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode `json:"DomainIpv4IspCityNode,omitempty" xml:"DomainIpv4IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes) SetDomainIpv4IspCityNode(v []*DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes {
	s.DomainIpv4IspCityNode = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode struct {
	// The city code.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city.
	//
	// example:
	//
	// Zhangjiakou
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// Indicates whether the health check node is selected by default.
	//
	// example:
	//
	// true
	DefaultSelected *bool `json:"DefaultSelected,omitempty" xml:"DefaultSelected,omitempty"`
	// The name of the node group.
	//
	// example:
	//
	// BGP Nodes
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The type of the node group. Valid values:
	//
	// 	- BGP: BGP node
	//
	// 	- OVERSEAS: node outside the Chinese mainland
	//
	// 	- ISP: ISP node
	//
	// example:
	//
	// BGP
	GroupType *string `json:"GroupType,omitempty" xml:"GroupType,omitempty"`
	// The IP addresses of the health check nodes.
	Ips *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps `json:"Ips,omitempty" xml:"Ips,omitempty" type:"Struct"`
	// The ISP code.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetCityCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetCityName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetDefaultSelected(v bool) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.DefaultSelected = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetGroupName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetGroupType(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.GroupType = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetIps(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.Ips = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetIspCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode) SetIspName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode {
	s.IspName = &v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps struct {
	Ip []*string `json:"Ip,omitempty" xml:"Ip,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps) SetIp(v []*string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps {
	s.Ip = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes struct {
	DomainIpv6IspCityNode []*DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode `json:"DomainIpv6IspCityNode,omitempty" xml:"DomainIpv6IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes) SetDomainIpv6IspCityNode(v []*DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes {
	s.DomainIpv6IspCityNode = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode struct {
	// The city code.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city.
	//
	// example:
	//
	// Zhangjiakou
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// Indicates whether the health check node is selected by default.
	//
	// example:
	//
	// false
	DefaultSelected *bool `json:"DefaultSelected,omitempty" xml:"DefaultSelected,omitempty"`
	// The name of the node group.
	//
	// example:
	//
	// BGP Nodes
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The type of the node group. Valid values:
	//
	// 	- BGP: BGP node
	//
	// 	- OVERSEAS: node outside the Chinese mainland
	//
	// 	- ISP: ISP node
	//
	// example:
	//
	// BGP
	GroupType *string `json:"GroupType,omitempty" xml:"GroupType,omitempty"`
	// This parameter is not returned.
	Ips *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps `json:"Ips,omitempty" xml:"Ips,omitempty" type:"Struct"`
	// The ISP code.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetCityCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetCityName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetDefaultSelected(v bool) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.DefaultSelected = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetGroupName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetGroupType(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.GroupType = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetIps(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.Ips = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetIspCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode) SetIspName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode {
	s.IspName = &v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps struct {
	Ip []*string `json:"ip,omitempty" xml:"ip,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps) SetIp(v []*string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps {
	s.Ip = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes struct {
	Ipv4IspCityNode []*DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode `json:"Ipv4IspCityNode,omitempty" xml:"Ipv4IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes) SetIpv4IspCityNode(v []*DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes {
	s.Ipv4IspCityNode = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode struct {
	// The city code.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city.
	//
	// example:
	//
	// Zhangjiakou
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// Indicates whether the health check node is selected by default.
	//
	// example:
	//
	// true
	DefaultSelected *bool `json:"DefaultSelected,omitempty" xml:"DefaultSelected,omitempty"`
	// The name of the node group.
	//
	// example:
	//
	// BGP Nodes
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The type of the node group. Valid values:
	//
	// 	- BGP: Border Gateway Protocol (BGP) node
	//
	// 	- OVERSEAS: node outside the Chinese mainland
	//
	// 	- ISP: ISP node
	//
	// example:
	//
	// BGP
	GroupType *string `json:"GroupType,omitempty" xml:"GroupType,omitempty"`
	// The IP addresses of the health check nodes.
	Ips *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps `json:"Ips,omitempty" xml:"Ips,omitempty" type:"Struct"`
	// The Internet service provider (ISP) code.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetCityCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetCityName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetDefaultSelected(v bool) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.DefaultSelected = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetGroupName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetGroupType(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.GroupType = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetIps(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.Ips = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetIspCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode) SetIspName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode {
	s.IspName = &v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps struct {
	Ip []*string `json:"Ip,omitempty" xml:"Ip,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps) SetIp(v []*string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps {
	s.Ip = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes struct {
	Ipv6IspCityNode []*DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode `json:"Ipv6IspCityNode,omitempty" xml:"Ipv6IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes) SetIpv6IspCityNode(v []*DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes {
	s.Ipv6IspCityNode = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode struct {
	// The city code.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city.
	//
	// example:
	//
	// Zhangjiakou
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// Indicates whether the health check node is selected by default.
	//
	// example:
	//
	// true
	DefaultSelected *bool `json:"DefaultSelected,omitempty" xml:"DefaultSelected,omitempty"`
	// The name of the node group.
	//
	// example:
	//
	// BGP Nodes
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The type of the node group. Valid values:
	//
	// 	- BGP: BGP node
	//
	// 	- OVERSEAS: node outside the Chinese mainland
	//
	// 	- ISP: ISP node
	//
	// example:
	//
	// BGP
	GroupType *string `json:"GroupType,omitempty" xml:"GroupType,omitempty"`
	// This parameter is not returned.
	Ips *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps `json:"Ips,omitempty" xml:"Ips,omitempty" type:"Struct"`
	// The ISP code.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetCityCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetCityName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetDefaultSelected(v bool) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.DefaultSelected = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetGroupName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.GroupName = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetGroupType(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.GroupType = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetIps(v *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.Ips = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetIspCode(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode) SetIspName(v string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode {
	s.IspName = &v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps struct {
	Ip []*string `json:"Ip,omitempty" xml:"Ip,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps) SetIp(v []*string) *DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps {
	s.Ip = v
	return s
}

type DescribeDnsGtmMonitorAvailableConfigResponse struct {
	Headers    map[string]*string                                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmMonitorAvailableConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmMonitorAvailableConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorAvailableConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmMonitorAvailableConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponse) SetStatusCode(v int32) *DescribeDnsGtmMonitorAvailableConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorAvailableConfigResponse) SetBody(v *DescribeDnsGtmMonitorAvailableConfigResponseBody) *DescribeDnsGtmMonitorAvailableConfigResponse {
	s.Body = v
	return s
}

type DescribeDnsGtmMonitorConfigRequest struct {
	// The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the health check task.
	//
	// This parameter is required.
	//
	// example:
	//
	// MonitorConfigId1
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
}

func (s DescribeDnsGtmMonitorConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorConfigRequest) SetLang(v string) *DescribeDnsGtmMonitorConfigRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigRequest) SetMonitorConfigId(v string) *DescribeDnsGtmMonitorConfigRequest {
	s.MonitorConfigId = &v
	return s
}

type DescribeDnsGtmMonitorConfigResponseBody struct {
	// The time when the health check configuration was created. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The time when the health check configuration was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The number of consecutive failures.
	//
	// example:
	//
	// 1
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The health check interval. Unit: seconds.
	//
	// example:
	//
	// 1
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The health check nodes.
	IspCityNodes *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes `json:"IspCityNodes,omitempty" xml:"IspCityNodes,omitempty" type:"Struct"`
	// The ID of the health check configuration.
	//
	// example:
	//
	// MonitorConfigId1
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// The extended information. The required parameters vary based on the value of ProtocolType.
	//
	// 	- HTTP or HTTPS
	//
	//     	- port: the port that you want to check
	//
	//     	- host: the host settings
	//
	//     	- path: the URL path
	//
	//     	- code: the response code. The health check result is deemed abnormal if the returned value is greater than the specified value.
	//
	//     	- failureRate: the failure rate
	//
	//     	- sni: specifies whether to enable server name indication (SNI). This parameter is available only when ProtocolType is set to HTTPS. Valid values:
	//
	//         	- true: enables SNI.
	//
	//         	- false: disables SNI.
	//
	//     	- nodeType: the type of the node for monitoring when the address pool type is domain name. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// 	- PING:
	//
	//     	- failureRate: the failure rate
	//
	//     	- packetNum: the number of ping packets
	//
	//     	- packetLossRate: the loss rate of ping packets
	//
	//     	- nodeType: the type of the node for monitoring when the address pool type is domain name. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// 	- TCP
	//
	//     	- port: the port that you want to check
	//
	//     	- failureRate: the failure rate
	//
	//     	- nodeType: the type of the node for monitoring when the address pool type is domain name. Valid values:
	//
	//         	- IPV4
	//
	//         	- IPV6
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	MonitorExtendInfo *string `json:"MonitorExtendInfo,omitempty" xml:"MonitorExtendInfo,omitempty"`
	// The health check protocol. Valid values:
	//
	// 	- HTTP
	//
	// 	- HTTPS
	//
	// 	- PING
	//
	// 	- TCP
	//
	// example:
	//
	// http
	ProtocolType *string `json:"ProtocolType,omitempty" xml:"ProtocolType,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The timeout period. Unit: milliseconds.
	//
	// example:
	//
	// 3000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
	// The time when the health check configuration was updated. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2018-01-03T08:57Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The time when the health check configuration was updated. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeDnsGtmMonitorConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetCreateTime(v string) *DescribeDnsGtmMonitorConfigResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetCreateTimestamp(v int64) *DescribeDnsGtmMonitorConfigResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetEvaluationCount(v int32) *DescribeDnsGtmMonitorConfigResponseBody {
	s.EvaluationCount = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetInterval(v int32) *DescribeDnsGtmMonitorConfigResponseBody {
	s.Interval = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetIspCityNodes(v *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes) *DescribeDnsGtmMonitorConfigResponseBody {
	s.IspCityNodes = v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetMonitorConfigId(v string) *DescribeDnsGtmMonitorConfigResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetMonitorExtendInfo(v string) *DescribeDnsGtmMonitorConfigResponseBody {
	s.MonitorExtendInfo = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetProtocolType(v string) *DescribeDnsGtmMonitorConfigResponseBody {
	s.ProtocolType = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetRequestId(v string) *DescribeDnsGtmMonitorConfigResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetTimeout(v int32) *DescribeDnsGtmMonitorConfigResponseBody {
	s.Timeout = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetUpdateTime(v string) *DescribeDnsGtmMonitorConfigResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBody) SetUpdateTimestamp(v int64) *DescribeDnsGtmMonitorConfigResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes struct {
	IspCityNode []*DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes) SetIspCityNode(v []*DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes {
	s.IspCityNode = v
	return s
}

type DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode struct {
	// The city code.
	//
	// example:
	//
	// 572
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city.
	//
	// example:
	//
	// Qingdao
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// The code of the country or region.
	//
	// example:
	//
	// 001
	CountryCode *string `json:"CountryCode,omitempty" xml:"CountryCode,omitempty"`
	// The display name of the country or region.
	//
	// example:
	//
	// China
	CountryName *string `json:"CountryName,omitempty" xml:"CountryName,omitempty"`
	// The Internet service provider (ISP) code.
	//
	// example:
	//
	// 123
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCityCode(v string) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCityName(v string) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCountryCode(v string) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CountryCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCountryName(v string) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CountryName = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetIspCode(v string) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetIspName(v string) *DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.IspName = &v
	return s
}

type DescribeDnsGtmMonitorConfigResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsGtmMonitorConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsGtmMonitorConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsGtmMonitorConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsGtmMonitorConfigResponse) SetHeaders(v map[string]*string) *DescribeDnsGtmMonitorConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponse) SetStatusCode(v int32) *DescribeDnsGtmMonitorConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsGtmMonitorConfigResponse) SetBody(v *DescribeDnsGtmMonitorConfigResponseBody) *DescribeDnsGtmMonitorConfigResponse {
	s.Body = v
	return s
}

type DescribeDnsProductInstanceRequest struct {
	// The ID of the DNS instance. . You can call the [DescribeDomainInfo](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomaininfo?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// i-8fxxxx
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 192.0.2.0
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
}

func (s DescribeDnsProductInstanceRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstanceRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstanceRequest) SetInstanceId(v string) *DescribeDnsProductInstanceRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsProductInstanceRequest) SetLang(v string) *DescribeDnsProductInstanceRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsProductInstanceRequest) SetUserClientIp(v string) *DescribeDnsProductInstanceRequest {
	s.UserClientIp = &v
	return s
}

type DescribeDnsProductInstanceResponseBody struct {
	// Indicates whether auto-renewal was enabled. Valid values:
	//
	// 	- true: Auto-renewal was enabled.
	//
	// 	- false: Auto-renewal was not enabled.
	//
	// example:
	//
	// true
	AutoRenewal *bool `json:"AutoRenewal,omitempty" xml:"AutoRenewal,omitempty"`
	// The number of times that you can change the domain names that are bound to the paid Alibaba Cloud DNS instance. This parameter applies to Alibaba Cloud DNS instances of the custom edition.
	//
	// example:
	//
	// 3
	BindCount *int64 `json:"BindCount,omitempty" xml:"BindCount,omitempty"`
	// The number of domain names that can be bound to the paid Alibaba Cloud DNS instance. This parameter applies to Alibaba Cloud DNS instances of Personal Edition, Enterprise Standard Edition, and Enterprise Ultimate Edition.
	//
	// example:
	//
	// 5
	BindDomainCount *int64 `json:"BindDomainCount,omitempty" xml:"BindDomainCount,omitempty"`
	// The number of domain names that are bound to the paid Alibaba Cloud DNS instance. This parameter applies to Alibaba Cloud DNS instances of Personal Edition, Enterprise Standard Edition, and Enterprise Ultimate Edition.
	//
	// example:
	//
	// 3
	BindDomainUsedCount *int64 `json:"BindDomainUsedCount,omitempty" xml:"BindDomainUsedCount,omitempty"`
	// The number of times that you have changed the domain names that are bound to the paid Alibaba Cloud DNS instance. This parameter applies to Alibaba Cloud DNS instances of the custom edition.
	//
	// example:
	//
	// 1
	BindUsedCount *int64 `json:"BindUsedCount,omitempty" xml:"BindUsedCount,omitempty"`
	// The DDoS protection traffic. Unit: GB.
	//
	// example:
	//
	// 50
	DDosDefendFlow *int64 `json:"DDosDefendFlow,omitempty" xml:"DDosDefendFlow,omitempty"`
	// The DDoS protection frequency. Unit: 10,000 QPS. This parameter applies to Alibaba Cloud DNS instances of the custom edition.
	//
	// example:
	//
	// 50
	DDosDefendQuery *int64 `json:"DDosDefendQuery,omitempty" xml:"DDosDefendQuery,omitempty"`
	// The maximum number of IP addresses that are used for load balancing in a single line of a domain name.
	//
	// example:
	//
	// 15
	DnsSLBCount *int64 `json:"DnsSLBCount,omitempty" xml:"DnsSLBCount,omitempty"`
	// The level of DNS protection. Valid values:
	//
	// 	- no: No DNS protection is provided.
	//
	// 	- basic: Basic DNS protection is provided.
	//
	// 	- advanced: Advanced DNS protection is provided.
	//
	// example:
	//
	// advanced
	DnsSecurity *string `json:"DnsSecurity,omitempty" xml:"DnsSecurity,omitempty"`
	// The DNS servers configured for the domain names.
	DnsServers *DescribeDnsProductInstanceResponseBodyDnsServers `json:"DnsServers,omitempty" xml:"DnsServers,omitempty" type:"Struct"`
	// The domain name that is bound to the paid instance.
	//
	// If no value is returned for this parameter, no domain name is bound to the paid instance.
	//
	// example:
	//
	// example.com
	Domain *string `json:"Domain,omitempty" xml:"Domain,omitempty"`
	// The type of the instance. Valid values:
	//
	// 	- PUBLIC: authoritative domain name
	//
	// 	- CACHE: cache-accelerated domain name
	//
	// example:
	//
	// PUBLIC
	DomainType *string `json:"DomainType,omitempty" xml:"DomainType,omitempty"`
	// The time when the instance expired. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2015-12-12T09:23Z
	EndTime *string `json:"EndTime,omitempty" xml:"EndTime,omitempty"`
	// The time when the instance expired. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1474335170000
	EndTimestamp *int64 `json:"EndTimestamp,omitempty" xml:"EndTimestamp,omitempty"`
	// Indicates whether global server load balancing (GSLB) is supported. Valid values:
	//
	// 	- true: GSLB is supported.
	//
	// 	- false: GSLB is not supported.
	//
	// example:
	//
	// true
	Gslb *bool `json:"Gslb,omitempty" xml:"Gslb,omitempty"`
	// The ISP resolution lines. Valid values:
	//
	// 	- China Telecom
	//
	// 	- China Mobile
	//
	// 	- China Unicom
	//
	// 	- China Education and Research Network (CERNET)
	//
	// 	- China Broadcasting Network (CBN)
	//
	// 	- Dr Peng Telecom & Media Group
	ISPLines *string `json:"ISPLines,omitempty" xml:"ISPLines,omitempty"`
	// The regional ISP resolution lines. Valid values:
	//
	// 	- China Telecom (province)
	//
	// 	- China Mobile (province)
	//
	// 	- China Unicom (province)
	//
	// 	- CERNET (province)
	ISPRegionLines *string `json:"ISPRegionLines,omitempty" xml:"ISPRegionLines,omitempty"`
	// Indicates whether the Domain Name System (DNS) servers stopped responding to all DNS requests. Valid values:
	//
	// 	- true: The DNS servers stopped responding to all DNS requests.
	//
	// 	- false: The DNS servers did not stop responding to all DNS requests.
	//
	// example:
	//
	// false
	InBlackHole *bool `json:"InBlackHole,omitempty" xml:"InBlackHole,omitempty"`
	// Indicates whether the DNS servers stopped responding to abnormal requests sent to the domain names.
	//
	// 	- true: The DNS servers stopped responding to abnormal requests sent to the domain names.
	//
	// 	- false: The DNS servers did not stop responding to abnormal requests sent to the domain names.
	//
	// example:
	//
	// false
	InClean *bool `json:"InClean,omitempty" xml:"InClean,omitempty"`
	// The ID of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// i-8fxxx
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The interval at which the instance is monitored. Unit: minutes.
	//
	// example:
	//
	// 50
	MonitorFrequency *int64 `json:"MonitorFrequency,omitempty" xml:"MonitorFrequency,omitempty"`
	// The number of monitoring nodes.
	//
	// example:
	//
	// 5
	MonitorNodeCount *int64 `json:"MonitorNodeCount,omitempty" xml:"MonitorNodeCount,omitempty"`
	// The number of monitoring tasks.
	//
	// example:
	//
	// 2
	MonitorTaskCount *int64 `json:"MonitorTaskCount,omitempty" xml:"MonitorTaskCount,omitempty"`
	// The DDoS protection traffic outside the Chinese mainland. Unit: GB.
	//
	// example:
	//
	// 1
	OverseaDDosDefendFlow *int64 `json:"OverseaDDosDefendFlow,omitempty" xml:"OverseaDDosDefendFlow,omitempty"`
	// The line outside the Chinese mainland.
	OverseaLine *string `json:"OverseaLine,omitempty" xml:"OverseaLine,omitempty"`
	// The billing method.
	//
	// example:
	//
	// Subscription
	PaymentType *string `json:"PaymentType,omitempty" xml:"PaymentType,omitempty"`
	// Indicates whether the DNS request lines are regional lines. Valid values:
	//
	// 	- true: The DNS request lines are regional lines.
	//
	// 	- false: The DNS request lines are not regional lines.
	//
	// example:
	//
	// true
	RegionLines *bool `json:"RegionLines,omitempty" xml:"RegionLines,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The search engine resolution lines. Valid values:
	//
	// 	- Google
	//
	// 	- Baidu
	//
	// 	- Bing
	//
	// 	- Youdao
	SearchEngineLines *string `json:"SearchEngineLines,omitempty" xml:"SearchEngineLines,omitempty"`
	// The time when the instance was purchased. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2015-12-12T09:23Z
	StartTime *string `json:"StartTime,omitempty" xml:"StartTime,omitempty"`
	// The time when the instance was purchased. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1474335170000
	StartTimestamp *int64 `json:"StartTimestamp,omitempty" xml:"StartTimestamp,omitempty"`
	// The number of subdomain name levels.
	//
	// example:
	//
	// 6
	SubDomainLevel *int64 `json:"SubDomainLevel,omitempty" xml:"SubDomainLevel,omitempty"`
	// The minimum time-to-live (TTL) period. Unit: seconds.
	//
	// example:
	//
	// 10
	TTLMinValue *int64 `json:"TTLMinValue,omitempty" xml:"TTLMinValue,omitempty"`
	// The number of the forwarded URLs.
	//
	// example:
	//
	// 20
	URLForwardCount *int64 `json:"URLForwardCount,omitempty" xml:"URLForwardCount,omitempty"`
	// The version code of Alibaba Cloud DNS.
	//
	// example:
	//
	// version1
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
	// The edition of Alibaba Cloud DNS.
	VersionName *string `json:"VersionName,omitempty" xml:"VersionName,omitempty"`
}

func (s DescribeDnsProductInstanceResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstanceResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstanceResponseBody) SetAutoRenewal(v bool) *DescribeDnsProductInstanceResponseBody {
	s.AutoRenewal = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetBindCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.BindCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetBindDomainCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.BindDomainCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetBindDomainUsedCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.BindDomainUsedCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetBindUsedCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.BindUsedCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDDosDefendFlow(v int64) *DescribeDnsProductInstanceResponseBody {
	s.DDosDefendFlow = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDDosDefendQuery(v int64) *DescribeDnsProductInstanceResponseBody {
	s.DDosDefendQuery = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDnsSLBCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.DnsSLBCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDnsSecurity(v string) *DescribeDnsProductInstanceResponseBody {
	s.DnsSecurity = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDnsServers(v *DescribeDnsProductInstanceResponseBodyDnsServers) *DescribeDnsProductInstanceResponseBody {
	s.DnsServers = v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDomain(v string) *DescribeDnsProductInstanceResponseBody {
	s.Domain = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetDomainType(v string) *DescribeDnsProductInstanceResponseBody {
	s.DomainType = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetEndTime(v string) *DescribeDnsProductInstanceResponseBody {
	s.EndTime = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetEndTimestamp(v int64) *DescribeDnsProductInstanceResponseBody {
	s.EndTimestamp = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetGslb(v bool) *DescribeDnsProductInstanceResponseBody {
	s.Gslb = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetISPLines(v string) *DescribeDnsProductInstanceResponseBody {
	s.ISPLines = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetISPRegionLines(v string) *DescribeDnsProductInstanceResponseBody {
	s.ISPRegionLines = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetInBlackHole(v bool) *DescribeDnsProductInstanceResponseBody {
	s.InBlackHole = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetInClean(v bool) *DescribeDnsProductInstanceResponseBody {
	s.InClean = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetInstanceId(v string) *DescribeDnsProductInstanceResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetMonitorFrequency(v int64) *DescribeDnsProductInstanceResponseBody {
	s.MonitorFrequency = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetMonitorNodeCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.MonitorNodeCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetMonitorTaskCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.MonitorTaskCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetOverseaDDosDefendFlow(v int64) *DescribeDnsProductInstanceResponseBody {
	s.OverseaDDosDefendFlow = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetOverseaLine(v string) *DescribeDnsProductInstanceResponseBody {
	s.OverseaLine = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetPaymentType(v string) *DescribeDnsProductInstanceResponseBody {
	s.PaymentType = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetRegionLines(v bool) *DescribeDnsProductInstanceResponseBody {
	s.RegionLines = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetRequestId(v string) *DescribeDnsProductInstanceResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetSearchEngineLines(v string) *DescribeDnsProductInstanceResponseBody {
	s.SearchEngineLines = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetStartTime(v string) *DescribeDnsProductInstanceResponseBody {
	s.StartTime = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetStartTimestamp(v int64) *DescribeDnsProductInstanceResponseBody {
	s.StartTimestamp = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetSubDomainLevel(v int64) *DescribeDnsProductInstanceResponseBody {
	s.SubDomainLevel = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetTTLMinValue(v int64) *DescribeDnsProductInstanceResponseBody {
	s.TTLMinValue = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetURLForwardCount(v int64) *DescribeDnsProductInstanceResponseBody {
	s.URLForwardCount = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetVersionCode(v string) *DescribeDnsProductInstanceResponseBody {
	s.VersionCode = &v
	return s
}

func (s *DescribeDnsProductInstanceResponseBody) SetVersionName(v string) *DescribeDnsProductInstanceResponseBody {
	s.VersionName = &v
	return s
}

type DescribeDnsProductInstanceResponseBodyDnsServers struct {
	DnsServer []*string `json:"DnsServer,omitempty" xml:"DnsServer,omitempty" type:"Repeated"`
}

func (s DescribeDnsProductInstanceResponseBodyDnsServers) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstanceResponseBodyDnsServers) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstanceResponseBodyDnsServers) SetDnsServer(v []*string) *DescribeDnsProductInstanceResponseBodyDnsServers {
	s.DnsServer = v
	return s
}

type DescribeDnsProductInstanceResponse struct {
	Headers    map[string]*string                      `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                  `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsProductInstanceResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsProductInstanceResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstanceResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstanceResponse) SetHeaders(v map[string]*string) *DescribeDnsProductInstanceResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsProductInstanceResponse) SetStatusCode(v int32) *DescribeDnsProductInstanceResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsProductInstanceResponse) SetBody(v *DescribeDnsProductInstanceResponseBody) *DescribeDnsProductInstanceResponse {
	s.Body = v
	return s
}

type DescribeDnsProductInstancesRequest struct {
	// The order in which you want to sort returned entries. Valid values:
	//
	// 	- DESC: Returned entries are sorted in descending order. If this parameter is left empty, returned entries are sorted in descending order by default.
	//
	// 	- ASC: Returned entries are sorted in ascending order.
	//
	// example:
	//
	// DESC
	Direction *string `json:"Direction,omitempty" xml:"Direction,omitempty"`
	// The type of the domain name. Valid values:
	//
	// 	- PUBLIC (default): hosted public domain name
	//
	// 	- CACHE: cached public domain name
	//
	// example:
	//
	// PUBLIC
	DomainType *string `json:"DomainType,omitempty" xml:"DomainType,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The method that is used to sort returned entries. Valid values:
	//
	// 	- createDate: sorts returned entries by creation time. If this parameter is left empty, returned entries are sorted by creation time by default.
	//
	// 	- expireDate: sorts returned entries by expiration time.
	//
	// example:
	//
	// createDate
	OrderBy *string `json:"OrderBy,omitempty" xml:"OrderBy,omitempty"`
	// The number of the page to return. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 192.0.2.0
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
	// The version code of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// version1
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeDnsProductInstancesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstancesRequest) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstancesRequest) SetDirection(v string) *DescribeDnsProductInstancesRequest {
	s.Direction = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetDomainType(v string) *DescribeDnsProductInstancesRequest {
	s.DomainType = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetLang(v string) *DescribeDnsProductInstancesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetOrderBy(v string) *DescribeDnsProductInstancesRequest {
	s.OrderBy = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetPageNumber(v int64) *DescribeDnsProductInstancesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetPageSize(v int64) *DescribeDnsProductInstancesRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetUserClientIp(v string) *DescribeDnsProductInstancesRequest {
	s.UserClientIp = &v
	return s
}

func (s *DescribeDnsProductInstancesRequest) SetVersionCode(v string) *DescribeDnsProductInstancesRequest {
	s.VersionCode = &v
	return s
}

type DescribeDnsProductInstancesResponseBody struct {
	// The paid Alibaba Cloud DNS instances.
	DnsProducts *DescribeDnsProductInstancesResponseBodyDnsProducts `json:"DnsProducts,omitempty" xml:"DnsProducts,omitempty" type:"Struct"`
	// The type of the domain name. Valid values:
	//
	// 	- PUBLIC (default): hosted public domain name
	//
	// 	- CACHE: cached public domain name
	//
	// example:
	//
	// PUBLIC
	DomainType *string `json:"DomainType,omitempty" xml:"DomainType,omitempty"`
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 2
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of domain names.
	//
	// example:
	//
	// 2
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDnsProductInstancesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstancesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstancesResponseBody) SetDnsProducts(v *DescribeDnsProductInstancesResponseBodyDnsProducts) *DescribeDnsProductInstancesResponseBody {
	s.DnsProducts = v
	return s
}

func (s *DescribeDnsProductInstancesResponseBody) SetDomainType(v string) *DescribeDnsProductInstancesResponseBody {
	s.DomainType = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBody) SetPageNumber(v int64) *DescribeDnsProductInstancesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBody) SetPageSize(v int64) *DescribeDnsProductInstancesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBody) SetRequestId(v string) *DescribeDnsProductInstancesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBody) SetTotalCount(v int64) *DescribeDnsProductInstancesResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDnsProductInstancesResponseBodyDnsProducts struct {
	DnsProduct []*DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct `json:"DnsProduct,omitempty" xml:"DnsProduct,omitempty" type:"Repeated"`
}

func (s DescribeDnsProductInstancesResponseBodyDnsProducts) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstancesResponseBodyDnsProducts) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProducts) SetDnsProduct(v []*DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) *DescribeDnsProductInstancesResponseBodyDnsProducts {
	s.DnsProduct = v
	return s
}

type DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct struct {
	// Indicates whether auto-renewal was enabled. Valid values:
	//
	// 	- true: Auto-renewal was enabled.
	//
	// 	- false: Auto-renewal was not enabled.
	//
	// example:
	//
	// true
	AutoRenewal *bool `json:"AutoRenewal,omitempty" xml:"AutoRenewal,omitempty"`
	// The number of times you can change domain names that are bound to the DNS instance. It can be specified by the user who uses Alibaba Cloud DNS of the custom version.
	//
	// example:
	//
	// 3
	BindCount *int64 `json:"BindCount,omitempty" xml:"BindCount,omitempty"`
	// The number of domain names that can be bound to the DNS instance.
	//
	// example:
	//
	// 5
	BindDomainCount *int64 `json:"BindDomainCount,omitempty" xml:"BindDomainCount,omitempty"`
	// The number of domain names that have been bound to the DNS instance.
	//
	// example:
	//
	// 3
	BindDomainUsedCount *int64 `json:"BindDomainUsedCount,omitempty" xml:"BindDomainUsedCount,omitempty"`
	// The number of times you have changed domain names that are bound to the DNS instance. It can be specified by the user who uses Alibaba Cloud DNS of the custom version.
	//
	// example:
	//
	// 1
	BindUsedCount *int64 `json:"BindUsedCount,omitempty" xml:"BindUsedCount,omitempty"`
	// The DDoS protection traffic. Unit: GB.
	//
	// example:
	//
	// 50
	DDosDefendFlow *int64 `json:"DDosDefendFlow,omitempty" xml:"DDosDefendFlow,omitempty"`
	// The DDoS protection frequency. Unit: 10,000 QPS.
	//
	// example:
	//
	// 50
	DDosDefendQuery *int64 `json:"DDosDefendQuery,omitempty" xml:"DDosDefendQuery,omitempty"`
	// The number of IP addresses supported by a domain name or line.
	//
	// example:
	//
	// 15
	DnsSLBCount *int64 `json:"DnsSLBCount,omitempty" xml:"DnsSLBCount,omitempty"`
	// The level of DNS protection. Valid values:
	//
	// 	- no: No DNS protection is provided.
	//
	// 	- basic: Basic DNS protection is provided.
	//
	// 	- advanced: Advanced DNS protection is provided.
	//
	// example:
	//
	// no
	DnsSecurity *string `json:"DnsSecurity,omitempty" xml:"DnsSecurity,omitempty"`
	// The bound domain name.
	//
	// example:
	//
	// example.com
	Domain *string `json:"Domain,omitempty" xml:"Domain,omitempty"`
	// The time at which the instance expired.
	//
	// example:
	//
	// 2015-12-12T00:00Z
	EndTime *string `json:"EndTime,omitempty" xml:"EndTime,omitempty"`
	// The UNIX timestamp representing the expiration time of the instance.
	//
	// example:
	//
	// 1474335170000
	EndTimestamp *int64 `json:"EndTimestamp,omitempty" xml:"EndTimestamp,omitempty"`
	// Indicates whether global server load balancing (GSLB) is supported.
	//
	// 	- true: GSLB is supported.
	//
	// 	- false: GSLB is not supported.
	//
	// example:
	//
	// true
	Gslb *bool `json:"Gslb,omitempty" xml:"Gslb,omitempty"`
	// The ISP resolution lines.
	//
	// 	- China Telecom
	//
	// 	- China Mobile
	//
	// 	- China Unicom
	//
	// 	- CERNET
	//
	// 	- China Broadcasting Network (CBN)
	//
	// 	- Dr Peng Telecom & Media Group
	//
	// example:
	//
	// China Mobile,China Unicom,China Telecom,China Edu
	ISPLines *string `json:"ISPLines,omitempty" xml:"ISPLines,omitempty"`
	// The regional ISP resolution lines. Valid values:
	//
	// 	- China Telecom (province)
	//
	// 	- China Mobile (province)
	//
	// 	- China Unicom (province)
	//
	// 	- China Education and Research Network (CERNET) (province)
	//
	// example:
	//
	// Telecom (Province), Mobile (Province), Unicom (Province), Education Network (Province)
	ISPRegionLines *string `json:"ISPRegionLines,omitempty" xml:"ISPRegionLines,omitempty"`
	// Indicates whether the Domain Name System (DNS) servers stopped responding to all requests. Valid values:
	//
	// 	- true: The DNS servers stopped responding to all requests.
	//
	// 	- false: The DNS servers did not stop responding to all requests.
	//
	// example:
	//
	// false
	InBlackHole *bool `json:"InBlackHole,omitempty" xml:"InBlackHole,omitempty"`
	// Indicates whether the request for domain name resolution was being cleared.
	//
	// example:
	//
	// false
	InClean *bool `json:"InClean,omitempty" xml:"InClean,omitempty"`
	// The ID of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// i-8fj
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The monitoring frequency. Unit: minutes.
	//
	// example:
	//
	// 50
	MonitorFrequency *int64 `json:"MonitorFrequency,omitempty" xml:"MonitorFrequency,omitempty"`
	// The number of monitored nodes.
	//
	// example:
	//
	// 5
	MonitorNodeCount *int64 `json:"MonitorNodeCount,omitempty" xml:"MonitorNodeCount,omitempty"`
	// The number of monitoring tasks.
	//
	// example:
	//
	// 2
	MonitorTaskCount *int64 `json:"MonitorTaskCount,omitempty" xml:"MonitorTaskCount,omitempty"`
	// DDoS protection traffic outside China. Unit: GB.
	//
	// example:
	//
	// 1
	OverseaDDosDefendFlow *int64 `json:"OverseaDDosDefendFlow,omitempty" xml:"OverseaDDosDefendFlow,omitempty"`
	// The type of the overseas line.
	//
	// example:
	//
	// Countries
	OverseaLine *string `json:"OverseaLine,omitempty" xml:"OverseaLine,omitempty"`
	// The billing method.
	//
	// example:
	//
	// Subscription
	PaymentType *string `json:"PaymentType,omitempty" xml:"PaymentType,omitempty"`
	// Indicates whether the DNS request lines are regional lines.
	//
	// 	- true: The DNS request lines are regional lines.
	//
	// 	- false: The DNS request lines are not regional lines.
	//
	// example:
	//
	// true
	RegionLines *bool `json:"RegionLines,omitempty" xml:"RegionLines,omitempty"`
	// The search engine resolution lines. Valid values:
	//
	// 	- Google
	//
	// 	- Baidu
	//
	// 	- Bing
	//
	// 	- Youdao
	//
	// example:
	//
	// Search Engine Robots,Google Robots,Baidu Robots,Bing Robots
	SearchEngineLines *string `json:"SearchEngineLines,omitempty" xml:"SearchEngineLines,omitempty"`
	// The time when the DNS instance was purchased.
	//
	// example:
	//
	// 2015-11-12T09:23Z
	StartTime *string `json:"StartTime,omitempty" xml:"StartTime,omitempty"`
	// The UNIX timestamp representing when the DNS instance was purchased.
	//
	// example:
	//
	// 1474335170000
	StartTimestamp *int64 `json:"StartTimestamp,omitempty" xml:"StartTimestamp,omitempty"`
	// The number of subdomain name levels.
	//
	// example:
	//
	// 6
	SubDomainLevel *int64 `json:"SubDomainLevel,omitempty" xml:"SubDomainLevel,omitempty"`
	// The minimum TTL. Unit: seconds.
	//
	// example:
	//
	// 10
	TTLMinValue *int64 `json:"TTLMinValue,omitempty" xml:"TTLMinValue,omitempty"`
	// The URL forwarding quantity.
	//
	// example:
	//
	// 20
	URLForwardCount *int64 `json:"URLForwardCount,omitempty" xml:"URLForwardCount,omitempty"`
	// The version code of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// version1
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
	// The version name of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// Alibaba Cloud DNS
	VersionName *string `json:"VersionName,omitempty" xml:"VersionName,omitempty"`
}

func (s DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetAutoRenewal(v bool) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.AutoRenewal = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetBindCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.BindCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetBindDomainCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.BindDomainCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetBindDomainUsedCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.BindDomainUsedCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetBindUsedCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.BindUsedCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetDDosDefendFlow(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.DDosDefendFlow = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetDDosDefendQuery(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.DDosDefendQuery = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetDnsSLBCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.DnsSLBCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetDnsSecurity(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.DnsSecurity = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetDomain(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.Domain = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetEndTime(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.EndTime = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetEndTimestamp(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.EndTimestamp = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetGslb(v bool) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.Gslb = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetISPLines(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.ISPLines = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetISPRegionLines(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.ISPRegionLines = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetInBlackHole(v bool) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.InBlackHole = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetInClean(v bool) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.InClean = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetInstanceId(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.InstanceId = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetMonitorFrequency(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.MonitorFrequency = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetMonitorNodeCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.MonitorNodeCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetMonitorTaskCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.MonitorTaskCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetOverseaDDosDefendFlow(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.OverseaDDosDefendFlow = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetOverseaLine(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.OverseaLine = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetPaymentType(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.PaymentType = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetRegionLines(v bool) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.RegionLines = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetSearchEngineLines(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.SearchEngineLines = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetStartTime(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.StartTime = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetStartTimestamp(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.StartTimestamp = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetSubDomainLevel(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.SubDomainLevel = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetTTLMinValue(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.TTLMinValue = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetURLForwardCount(v int64) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.URLForwardCount = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetVersionCode(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.VersionCode = &v
	return s
}

func (s *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct) SetVersionName(v string) *DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct {
	s.VersionName = &v
	return s
}

type DescribeDnsProductInstancesResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDnsProductInstancesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDnsProductInstancesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDnsProductInstancesResponse) GoString() string {
	return s.String()
}

func (s *DescribeDnsProductInstancesResponse) SetHeaders(v map[string]*string) *DescribeDnsProductInstancesResponse {
	s.Headers = v
	return s
}

func (s *DescribeDnsProductInstancesResponse) SetStatusCode(v int32) *DescribeDnsProductInstancesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDnsProductInstancesResponse) SetBody(v *DescribeDnsProductInstancesResponseBody) *DescribeDnsProductInstancesResponse {
	s.Body = v
	return s
}

type DescribeDohAccountStatisticsRequest struct {
	// The end of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// The default value is the day when you perform the operation.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// You can query only the DNS records of the latest 90 days.`The value of StartDate must be greater than or equal to the difference between the current date and 90`.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribeDohAccountStatisticsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohAccountStatisticsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDohAccountStatisticsRequest) SetEndDate(v string) *DescribeDohAccountStatisticsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDohAccountStatisticsRequest) SetLang(v string) *DescribeDohAccountStatisticsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDohAccountStatisticsRequest) SetStartDate(v string) *DescribeDohAccountStatisticsRequest {
	s.StartDate = &v
	return s
}

type DescribeDohAccountStatisticsResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics list.
	Statistics []*DescribeDohAccountStatisticsResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Repeated"`
}

func (s DescribeDohAccountStatisticsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohAccountStatisticsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDohAccountStatisticsResponseBody) SetRequestId(v string) *DescribeDohAccountStatisticsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponseBody) SetStatistics(v []*DescribeDohAccountStatisticsResponseBodyStatistics) *DescribeDohAccountStatisticsResponseBody {
	s.Statistics = v
	return s
}

type DescribeDohAccountStatisticsResponseBodyStatistics struct {
	// The timestamp.
	//
	// example:
	//
	// 1544976000000
	Timestamp *int64 `json:"Timestamp,omitempty" xml:"Timestamp,omitempty"`
	// The total number of requests.
	//
	// example:
	//
	// 3141592653
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribeDohAccountStatisticsResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohAccountStatisticsResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDohAccountStatisticsResponseBodyStatistics) SetTimestamp(v int64) *DescribeDohAccountStatisticsResponseBodyStatistics {
	s.Timestamp = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponseBodyStatistics) SetTotalCount(v int64) *DescribeDohAccountStatisticsResponseBodyStatistics {
	s.TotalCount = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponseBodyStatistics) SetV4HttpCount(v int64) *DescribeDohAccountStatisticsResponseBodyStatistics {
	s.V4HttpCount = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponseBodyStatistics) SetV4HttpsCount(v int64) *DescribeDohAccountStatisticsResponseBodyStatistics {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponseBodyStatistics) SetV6HttpCount(v int64) *DescribeDohAccountStatisticsResponseBodyStatistics {
	s.V6HttpCount = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponseBodyStatistics) SetV6HttpsCount(v int64) *DescribeDohAccountStatisticsResponseBodyStatistics {
	s.V6HttpsCount = &v
	return s
}

type DescribeDohAccountStatisticsResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDohAccountStatisticsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDohAccountStatisticsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohAccountStatisticsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDohAccountStatisticsResponse) SetHeaders(v map[string]*string) *DescribeDohAccountStatisticsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDohAccountStatisticsResponse) SetStatusCode(v int32) *DescribeDohAccountStatisticsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDohAccountStatisticsResponse) SetBody(v *DescribeDohAccountStatisticsResponseBody) *DescribeDohAccountStatisticsResponse {
	s.Body = v
	return s
}

type DescribeDohDomainStatisticsRequest struct {
	// The domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The end of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// The default value is the day when you perform the operation.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// You can query only the DNS records of the latest 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribeDohDomainStatisticsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsRequest) SetDomainName(v string) *DescribeDohDomainStatisticsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDohDomainStatisticsRequest) SetEndDate(v string) *DescribeDohDomainStatisticsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDohDomainStatisticsRequest) SetLang(v string) *DescribeDohDomainStatisticsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDohDomainStatisticsRequest) SetStartDate(v string) *DescribeDohDomainStatisticsRequest {
	s.StartDate = &v
	return s
}

type DescribeDohDomainStatisticsResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics list.
	Statistics []*DescribeDohDomainStatisticsResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Repeated"`
}

func (s DescribeDohDomainStatisticsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsResponseBody) SetRequestId(v string) *DescribeDohDomainStatisticsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponseBody) SetStatistics(v []*DescribeDohDomainStatisticsResponseBodyStatistics) *DescribeDohDomainStatisticsResponseBody {
	s.Statistics = v
	return s
}

type DescribeDohDomainStatisticsResponseBodyStatistics struct {
	// The timestamp.
	//
	// example:
	//
	// 1544976000000
	Timestamp *int64 `json:"Timestamp,omitempty" xml:"Timestamp,omitempty"`
	// The total number of requests.
	//
	// example:
	//
	// 3141592653
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribeDohDomainStatisticsResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsResponseBodyStatistics) SetTimestamp(v int64) *DescribeDohDomainStatisticsResponseBodyStatistics {
	s.Timestamp = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponseBodyStatistics) SetTotalCount(v int64) *DescribeDohDomainStatisticsResponseBodyStatistics {
	s.TotalCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponseBodyStatistics) SetV4HttpCount(v int64) *DescribeDohDomainStatisticsResponseBodyStatistics {
	s.V4HttpCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponseBodyStatistics) SetV4HttpsCount(v int64) *DescribeDohDomainStatisticsResponseBodyStatistics {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponseBodyStatistics) SetV6HttpCount(v int64) *DescribeDohDomainStatisticsResponseBodyStatistics {
	s.V6HttpCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponseBodyStatistics) SetV6HttpsCount(v int64) *DescribeDohDomainStatisticsResponseBodyStatistics {
	s.V6HttpsCount = &v
	return s
}

type DescribeDohDomainStatisticsResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDohDomainStatisticsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDohDomainStatisticsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsResponse) SetHeaders(v map[string]*string) *DescribeDohDomainStatisticsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDohDomainStatisticsResponse) SetStatusCode(v int32) *DescribeDohDomainStatisticsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDohDomainStatisticsResponse) SetBody(v *DescribeDohDomainStatisticsResponseBody) *DescribeDohDomainStatisticsResponse {
	s.Body = v
	return s
}

type DescribeDohDomainStatisticsSummaryRequest struct {
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The end of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// The default value is the day when you perform the operation.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: 100. Default value: 20.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// You can query only the DNS records of the last 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribeDohDomainStatisticsSummaryRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsSummaryRequest) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsSummaryRequest) SetDomainName(v string) *DescribeDohDomainStatisticsSummaryRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryRequest) SetEndDate(v string) *DescribeDohDomainStatisticsSummaryRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryRequest) SetLang(v string) *DescribeDohDomainStatisticsSummaryRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryRequest) SetPageNumber(v int32) *DescribeDohDomainStatisticsSummaryRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryRequest) SetPageSize(v int32) *DescribeDohDomainStatisticsSummaryRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryRequest) SetStartDate(v string) *DescribeDohDomainStatisticsSummaryRequest {
	s.StartDate = &v
	return s
}

type DescribeDohDomainStatisticsSummaryResponseBody struct {
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics list.
	Statistics []*DescribeDohDomainStatisticsSummaryResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Repeated"`
	// The total number of entries returned.
	//
	// example:
	//
	// 300
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 50
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDohDomainStatisticsSummaryResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsSummaryResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsSummaryResponseBody) SetPageNumber(v int32) *DescribeDohDomainStatisticsSummaryResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBody) SetPageSize(v int32) *DescribeDohDomainStatisticsSummaryResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBody) SetRequestId(v string) *DescribeDohDomainStatisticsSummaryResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBody) SetStatistics(v []*DescribeDohDomainStatisticsSummaryResponseBodyStatistics) *DescribeDohDomainStatisticsSummaryResponseBody {
	s.Statistics = v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBody) SetTotalItems(v int32) *DescribeDohDomainStatisticsSummaryResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBody) SetTotalPages(v int32) *DescribeDohDomainStatisticsSummaryResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDohDomainStatisticsSummaryResponseBodyStatistics struct {
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The number of HTTP requests.
	//
	// example:
	//
	// 3141592653
	HttpCount *int64 `json:"HttpCount,omitempty" xml:"HttpCount,omitempty"`
	// The number of HTTPS requests.
	//
	// example:
	//
	// 3141592653
	HttpsCount *int64 `json:"HttpsCount,omitempty" xml:"HttpsCount,omitempty"`
	// The number of IP addresses.
	//
	// example:
	//
	// 20
	IpCount *int64 `json:"IpCount,omitempty" xml:"IpCount,omitempty"`
	// The total number of requests.
	//
	// example:
	//
	// 14141592653
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribeDohDomainStatisticsSummaryResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsSummaryResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetDomainName(v string) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.DomainName = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetHttpCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.HttpCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetHttpsCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.HttpsCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetIpCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.IpCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetTotalCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.TotalCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetV4HttpCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.V4HttpCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetV4HttpsCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetV6HttpCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.V6HttpCount = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponseBodyStatistics) SetV6HttpsCount(v int64) *DescribeDohDomainStatisticsSummaryResponseBodyStatistics {
	s.V6HttpsCount = &v
	return s
}

type DescribeDohDomainStatisticsSummaryResponse struct {
	Headers    map[string]*string                              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDohDomainStatisticsSummaryResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDohDomainStatisticsSummaryResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohDomainStatisticsSummaryResponse) GoString() string {
	return s.String()
}

func (s *DescribeDohDomainStatisticsSummaryResponse) SetHeaders(v map[string]*string) *DescribeDohDomainStatisticsSummaryResponse {
	s.Headers = v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponse) SetStatusCode(v int32) *DescribeDohDomainStatisticsSummaryResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDohDomainStatisticsSummaryResponse) SetBody(v *DescribeDohDomainStatisticsSummaryResponseBody) *DescribeDohDomainStatisticsSummaryResponse {
	s.Body = v
	return s
}

type DescribeDohSubDomainStatisticsRequest struct {
	// The end of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// The default value is the day when you perform the operation.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// You can query only the DNS records of the latest 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The subdomain whose statistics you want to query.
	//
	// This parameter is required.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
}

func (s DescribeDohSubDomainStatisticsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsRequest) SetEndDate(v string) *DescribeDohSubDomainStatisticsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsRequest) SetLang(v string) *DescribeDohSubDomainStatisticsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsRequest) SetStartDate(v string) *DescribeDohSubDomainStatisticsRequest {
	s.StartDate = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsRequest) SetSubDomain(v string) *DescribeDohSubDomainStatisticsRequest {
	s.SubDomain = &v
	return s
}

type DescribeDohSubDomainStatisticsResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics list.
	Statistics []*DescribeDohSubDomainStatisticsResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Repeated"`
}

func (s DescribeDohSubDomainStatisticsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsResponseBody) SetRequestId(v string) *DescribeDohSubDomainStatisticsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponseBody) SetStatistics(v []*DescribeDohSubDomainStatisticsResponseBodyStatistics) *DescribeDohSubDomainStatisticsResponseBody {
	s.Statistics = v
	return s
}

type DescribeDohSubDomainStatisticsResponseBodyStatistics struct {
	// The timestamp.
	//
	// example:
	//
	// 1544976000000
	Timestamp *int64 `json:"Timestamp,omitempty" xml:"Timestamp,omitempty"`
	// The total number of requests.
	//
	// example:
	//
	// 3141592653
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribeDohSubDomainStatisticsResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsResponseBodyStatistics) SetTimestamp(v int64) *DescribeDohSubDomainStatisticsResponseBodyStatistics {
	s.Timestamp = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponseBodyStatistics) SetTotalCount(v int64) *DescribeDohSubDomainStatisticsResponseBodyStatistics {
	s.TotalCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponseBodyStatistics) SetV4HttpCount(v int64) *DescribeDohSubDomainStatisticsResponseBodyStatistics {
	s.V4HttpCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponseBodyStatistics) SetV4HttpsCount(v int64) *DescribeDohSubDomainStatisticsResponseBodyStatistics {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponseBodyStatistics) SetV6HttpCount(v int64) *DescribeDohSubDomainStatisticsResponseBodyStatistics {
	s.V6HttpCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponseBodyStatistics) SetV6HttpsCount(v int64) *DescribeDohSubDomainStatisticsResponseBodyStatistics {
	s.V6HttpsCount = &v
	return s
}

type DescribeDohSubDomainStatisticsResponse struct {
	Headers    map[string]*string                          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDohSubDomainStatisticsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDohSubDomainStatisticsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsResponse) SetHeaders(v map[string]*string) *DescribeDohSubDomainStatisticsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponse) SetStatusCode(v int32) *DescribeDohSubDomainStatisticsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsResponse) SetBody(v *DescribeDohSubDomainStatisticsResponseBody) *DescribeDohSubDomainStatisticsResponse {
	s.Body = v
	return s
}

type DescribeDohSubDomainStatisticsSummaryRequest struct {
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The end of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// The default value is the day when you query the required data.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: 100. Default value: 20.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// You can query only the DNS records of the last 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The subdomain.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
}

func (s DescribeDohSubDomainStatisticsSummaryRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsSummaryRequest) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetDomainName(v string) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetEndDate(v string) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetLang(v string) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetPageNumber(v int32) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetPageSize(v int32) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetStartDate(v string) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.StartDate = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryRequest) SetSubDomain(v string) *DescribeDohSubDomainStatisticsSummaryRequest {
	s.SubDomain = &v
	return s
}

type DescribeDohSubDomainStatisticsSummaryResponseBody struct {
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 10
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics list.
	Statistics []*DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Repeated"`
	// Total number of entries returned.
	//
	// example:
	//
	// 100
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// Total number of pages returned.
	//
	// example:
	//
	// 50
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDohSubDomainStatisticsSummaryResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsSummaryResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBody) SetPageNumber(v int32) *DescribeDohSubDomainStatisticsSummaryResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBody) SetPageSize(v int32) *DescribeDohSubDomainStatisticsSummaryResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBody) SetRequestId(v string) *DescribeDohSubDomainStatisticsSummaryResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBody) SetStatistics(v []*DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) *DescribeDohSubDomainStatisticsSummaryResponseBody {
	s.Statistics = v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBody) SetTotalItems(v int32) *DescribeDohSubDomainStatisticsSummaryResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBody) SetTotalPages(v int32) *DescribeDohSubDomainStatisticsSummaryResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics struct {
	// The number of HTTP requests.
	//
	// example:
	//
	// 3141592653
	HttpCount *int64 `json:"HttpCount,omitempty" xml:"HttpCount,omitempty"`
	// The number of HTTPS requests.
	//
	// example:
	//
	// 3141592653
	HttpsCount *int64 `json:"HttpsCount,omitempty" xml:"HttpsCount,omitempty"`
	// The number of IP addresses.
	//
	// example:
	//
	// 20
	IpCount *int64 `json:"IpCount,omitempty" xml:"IpCount,omitempty"`
	// The subdomain.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	// Total number of requests.
	//
	// example:
	//
	// 14141592653
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 3141592653
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 3141592653
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetHttpCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.HttpCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetHttpsCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.HttpsCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetIpCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.IpCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetSubDomain(v string) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.SubDomain = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetTotalCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.TotalCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetV4HttpCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.V4HttpCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetV4HttpsCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetV6HttpCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.V6HttpCount = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics) SetV6HttpsCount(v int64) *DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics {
	s.V6HttpsCount = &v
	return s
}

type DescribeDohSubDomainStatisticsSummaryResponse struct {
	Headers    map[string]*string                                 `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                             `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDohSubDomainStatisticsSummaryResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDohSubDomainStatisticsSummaryResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohSubDomainStatisticsSummaryResponse) GoString() string {
	return s.String()
}

func (s *DescribeDohSubDomainStatisticsSummaryResponse) SetHeaders(v map[string]*string) *DescribeDohSubDomainStatisticsSummaryResponse {
	s.Headers = v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponse) SetStatusCode(v int32) *DescribeDohSubDomainStatisticsSummaryResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDohSubDomainStatisticsSummaryResponse) SetBody(v *DescribeDohSubDomainStatisticsSummaryResponseBody) *DescribeDohSubDomainStatisticsSummaryResponse {
	s.Body = v
	return s
}

type DescribeDohUserInfoRequest struct {
	// The end time for the query. Format: YYYY-MM-DD
	//
	// If you do not specify this parameter, the default value is the time when you perform the query.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The start time for the query. Format: YYYY-MM-DD
	//
	// You can query the user information of the last 90 days only. `Set the parameter to a value no earlier than 90 days from the current time`.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribeDohUserInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohUserInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribeDohUserInfoRequest) SetEndDate(v string) *DescribeDohUserInfoRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDohUserInfoRequest) SetLang(v string) *DescribeDohUserInfoRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDohUserInfoRequest) SetStartDate(v string) *DescribeDohUserInfoRequest {
	s.StartDate = &v
	return s
}

type DescribeDohUserInfoResponseBody struct {
	// The number of accessed domains.
	//
	// example:
	//
	// 123
	DomainCount *int32 `json:"DomainCount,omitempty" xml:"DomainCount,omitempty"`
	// The ID of the Alibaba Cloud public DNS user.
	//
	// example:
	//
	// 12345678
	PdnsId *int64 `json:"PdnsId,omitempty" xml:"PdnsId,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 0F32959D-417B-4D66-8463-68606605E3E2
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The number of accessed subdomains.
	//
	// example:
	//
	// 123
	SubDomainCount *int32 `json:"SubDomainCount,omitempty" xml:"SubDomainCount,omitempty"`
}

func (s DescribeDohUserInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohUserInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDohUserInfoResponseBody) SetDomainCount(v int32) *DescribeDohUserInfoResponseBody {
	s.DomainCount = &v
	return s
}

func (s *DescribeDohUserInfoResponseBody) SetPdnsId(v int64) *DescribeDohUserInfoResponseBody {
	s.PdnsId = &v
	return s
}

func (s *DescribeDohUserInfoResponseBody) SetRequestId(v string) *DescribeDohUserInfoResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDohUserInfoResponseBody) SetSubDomainCount(v int32) *DescribeDohUserInfoResponseBody {
	s.SubDomainCount = &v
	return s
}

type DescribeDohUserInfoResponse struct {
	Headers    map[string]*string               `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                           `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDohUserInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDohUserInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDohUserInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribeDohUserInfoResponse) SetHeaders(v map[string]*string) *DescribeDohUserInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribeDohUserInfoResponse) SetStatusCode(v int32) *DescribeDohUserInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDohUserInfoResponse) SetBody(v *DescribeDohUserInfoResponseBody) *DescribeDohUserInfoResponse {
	s.Body = v
	return s
}

type DescribeDomainDnssecInfoRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the content within the request and response. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// Default value: **zh**
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDomainDnssecInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainDnssecInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainDnssecInfoRequest) SetDomainName(v string) *DescribeDomainDnssecInfoRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainDnssecInfoRequest) SetLang(v string) *DescribeDomainDnssecInfoRequest {
	s.Lang = &v
	return s
}

type DescribeDomainDnssecInfoResponseBody struct {
	// The algorithm type. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// 13
	Algorithm *string `json:"Algorithm,omitempty" xml:"Algorithm,omitempty"`
	// The digest. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// C1A0424B97A049F1F9B2EA139CC298533219668164E343BD21203ABC4608C02A
	Digest *string `json:"Digest,omitempty" xml:"Digest,omitempty"`
	// The digest type. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// SHA256
	DigestType *string `json:"DigestType,omitempty" xml:"DigestType,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The delegation signer (DS) record. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// example.com. 3600 IN DS 2371 13 2 C1A0424B97A049F1F9B2EA139CC298533219668164E343BD21203ABC4608C02A
	DsRecord *string `json:"DsRecord,omitempty" xml:"DsRecord,omitempty"`
	// The flag. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// 257 (KSK)
	Flags *string `json:"Flags,omitempty" xml:"Flags,omitempty"`
	// The key tag. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// 54931
	KeyTag *string `json:"KeyTag,omitempty" xml:"KeyTag,omitempty"`
	// The public key. This parameter is returned if DNSSEC is enabled.
	//
	// example:
	//
	// mdsswUyr3DPW132mOi8V9xESWE8jTo0dxCjjnopKl+GqJxpVXckHAeF+KkxLbxILfDLUT0rAK9iUzy1L53eKGQ==
	PublicKey *string `json:"PublicKey,omitempty" xml:"PublicKey,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The state of the DNSSEC. Valid values:
	//
	// 	- ON
	//
	// 	- OFF
	//
	// example:
	//
	// ON
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
}

func (s DescribeDomainDnssecInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainDnssecInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainDnssecInfoResponseBody) SetAlgorithm(v string) *DescribeDomainDnssecInfoResponseBody {
	s.Algorithm = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetDigest(v string) *DescribeDomainDnssecInfoResponseBody {
	s.Digest = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetDigestType(v string) *DescribeDomainDnssecInfoResponseBody {
	s.DigestType = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetDomainName(v string) *DescribeDomainDnssecInfoResponseBody {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetDsRecord(v string) *DescribeDomainDnssecInfoResponseBody {
	s.DsRecord = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetFlags(v string) *DescribeDomainDnssecInfoResponseBody {
	s.Flags = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetKeyTag(v string) *DescribeDomainDnssecInfoResponseBody {
	s.KeyTag = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetPublicKey(v string) *DescribeDomainDnssecInfoResponseBody {
	s.PublicKey = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetRequestId(v string) *DescribeDomainDnssecInfoResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponseBody) SetStatus(v string) *DescribeDomainDnssecInfoResponseBody {
	s.Status = &v
	return s
}

type DescribeDomainDnssecInfoResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainDnssecInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainDnssecInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainDnssecInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainDnssecInfoResponse) SetHeaders(v map[string]*string) *DescribeDomainDnssecInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainDnssecInfoResponse) SetStatusCode(v int32) *DescribeDomainDnssecInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainDnssecInfoResponse) SetBody(v *DescribeDomainDnssecInfoResponseBody) *DescribeDomainDnssecInfoResponse {
	s.Body = v
	return s
}

type DescribeDomainGroupsRequest struct {
	// The keyword of the domain name group for searches in %KeyWord% mode. The value is not case-sensitive.
	//
	// example:
	//
	// Group
	KeyWord *string `json:"KeyWord,omitempty" xml:"KeyWord,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeDomainGroupsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainGroupsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainGroupsRequest) SetKeyWord(v string) *DescribeDomainGroupsRequest {
	s.KeyWord = &v
	return s
}

func (s *DescribeDomainGroupsRequest) SetLang(v string) *DescribeDomainGroupsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainGroupsRequest) SetPageNumber(v int64) *DescribeDomainGroupsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainGroupsRequest) SetPageSize(v int64) *DescribeDomainGroupsRequest {
	s.PageSize = &v
	return s
}

type DescribeDomainGroupsResponseBody struct {
	// The domain name groups.
	DomainGroups *DescribeDomainGroupsResponseBodyDomainGroups `json:"DomainGroups,omitempty" xml:"DomainGroups,omitempty" type:"Struct"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 1
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDomainGroupsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainGroupsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainGroupsResponseBody) SetDomainGroups(v *DescribeDomainGroupsResponseBodyDomainGroups) *DescribeDomainGroupsResponseBody {
	s.DomainGroups = v
	return s
}

func (s *DescribeDomainGroupsResponseBody) SetPageNumber(v int64) *DescribeDomainGroupsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainGroupsResponseBody) SetPageSize(v int64) *DescribeDomainGroupsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainGroupsResponseBody) SetRequestId(v string) *DescribeDomainGroupsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainGroupsResponseBody) SetTotalCount(v int64) *DescribeDomainGroupsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDomainGroupsResponseBodyDomainGroups struct {
	DomainGroup []*DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup `json:"DomainGroup,omitempty" xml:"DomainGroup,omitempty" type:"Repeated"`
}

func (s DescribeDomainGroupsResponseBodyDomainGroups) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainGroupsResponseBodyDomainGroups) GoString() string {
	return s.String()
}

func (s *DescribeDomainGroupsResponseBodyDomainGroups) SetDomainGroup(v []*DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup) *DescribeDomainGroupsResponseBodyDomainGroups {
	s.DomainGroup = v
	return s
}

type DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup struct {
	// The number of domain name groups.
	//
	// example:
	//
	// 2
	DomainCount *int64 `json:"DomainCount,omitempty" xml:"DomainCount,omitempty"`
	// The ID of the domain name group. Valid values:
	//
	// 	- defaultGroup: the default group
	//
	// 	- If an empty string is returned, it indicates the group that contains all domain names.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the domain name group.
	//
	// example:
	//
	// MyGroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
}

func (s DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup) GoString() string {
	return s.String()
}

func (s *DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup) SetDomainCount(v int64) *DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup {
	s.DomainCount = &v
	return s
}

func (s *DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup) SetGroupId(v string) *DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup) SetGroupName(v string) *DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup {
	s.GroupName = &v
	return s
}

type DescribeDomainGroupsResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainGroupsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainGroupsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainGroupsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainGroupsResponse) SetHeaders(v map[string]*string) *DescribeDomainGroupsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainGroupsResponse) SetStatusCode(v int32) *DescribeDomainGroupsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainGroupsResponse) SetBody(v *DescribeDomainGroupsResponseBody) *DescribeDomainGroupsResponse {
	s.Body = v
	return s
}

type DescribeDomainInfoRequest struct {
	// The domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// dns-example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// Specifies whether detailed attributes are required. Default value: **false**, which indicates that detailed attributes are not returned.
	//
	// If you set this parameter to **true**, the values of the following parameters are returned: LineType, MinTtl, RecordLineTreeJson, RecordLines, LineCode, LineDisplayName, LineName, RegionLines, and SlaveDns.
	//
	// example:
	//
	// true
	NeedDetailAttributes *bool `json:"NeedDetailAttributes,omitempty" xml:"NeedDetailAttributes,omitempty"`
}

func (s DescribeDomainInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoRequest) SetDomainName(v string) *DescribeDomainInfoRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainInfoRequest) SetLang(v string) *DescribeDomainInfoRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainInfoRequest) SetNeedDetailAttributes(v bool) *DescribeDomainInfoRequest {
	s.NeedDetailAttributes = &v
	return s
}

type DescribeDomainInfoResponseBody struct {
	// Indicates whether the domain name was registered in Alibaba Cloud.
	//
	// example:
	//
	// true
	AliDomain *bool `json:"AliDomain,omitempty" xml:"AliDomain,omitempty"`
	// The available time to live (TTL) values that can be configured for the domain name. Available TTL values are not returned by default. If you want to query such information, set NeedDetailAttributes to true.
	AvailableTtls *DescribeDomainInfoResponseBodyAvailableTtls `json:"AvailableTtls,omitempty" xml:"AvailableTtls,omitempty" type:"Struct"`
	// The time when the domain name was created.
	//
	// example:
	//
	// 2015-12-12T09:23Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The DNS servers that are used to resolve the domain name.
	DnsServers *DescribeDomainInfoResponseBodyDnsServers `json:"DnsServers,omitempty" xml:"DnsServers,omitempty" type:"Struct"`
	// The ID of the domain name.
	//
	// example:
	//
	// 00efd71a-770e-4255-b54e-6fe5659baffe
	DomainId *string `json:"DomainId,omitempty" xml:"DomainId,omitempty"`
	// Indicates whether the DNS traffic analysis feature is enabled. Valid values:
	DomainLoggingSwitchStatus *string `json:"DomainLoggingSwitchStatus,omitempty" xml:"DomainLoggingSwitchStatus,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the domain name group.
	//
	// example:
	//
	// mygroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// Indicates whether blackhole filtering was triggered.
	//
	// example:
	//
	// false
	InBlackHole *bool `json:"InBlackHole,omitempty" xml:"InBlackHole,omitempty"`
	// Indicates whether traffic scrubbing was in progress.
	//
	// example:
	//
	// false
	InClean *bool `json:"InClean,omitempty" xml:"InClean,omitempty"`
	// The ID of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// i-7bg
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The type of the DNS request line.
	//
	// example:
	//
	// region_province
	LineType *string `json:"LineType,omitempty" xml:"LineType,omitempty"`
	// The minimum TTL value.
	//
	// example:
	//
	// 1
	MinTtl *int64 `json:"MinTtl,omitempty" xml:"MinTtl,omitempty"`
	// The Punycode for the domain name. This parameter is returned only for Chinese domain names.
	//
	// example:
	//
	// example.com
	PunyCode *string `json:"PunyCode,omitempty" xml:"PunyCode,omitempty"`
	// The tree-structure DNS request lines.
	//
	// example:
	//
	// {"default":{},"unicom":{},"telecom":{},"mobile":{},"edu":{},"oversea":{},"baidu":{},"biying":{},"google":{}}
	RecordLineTreeJson *string `json:"RecordLineTreeJson,omitempty" xml:"RecordLineTreeJson,omitempty"`
	// The DNS request lines.
	RecordLines *DescribeDomainInfoResponseBodyRecordLines `json:"RecordLines,omitempty" xml:"RecordLines,omitempty" type:"Struct"`
	// Indicates whether the DNS request lines are regional lines.
	//
	// example:
	//
	// false
	RegionLines *bool `json:"RegionLines,omitempty" xml:"RegionLines,omitempty"`
	// The description.
	//
	// example:
	//
	// remark
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the resource group.
	//
	// example:
	//
	// rg-aek3dj3wvclgcxo
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	// Indicates whether secondary DNS is supported.
	//
	// example:
	//
	// true
	SlaveDns *bool `json:"SlaveDns,omitempty" xml:"SlaveDns,omitempty"`
	// Indicates whether the queried domain name is a hosted subdomain name. Valid values:
	//
	// 	- true
	//
	// 	- false
	//
	// example:
	//
	// false
	SubDomain *bool `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	// The version ID of Alibaba Cloud DNS.
	//
	// example:
	//
	// version1
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
	// The edition of Alibaba Cloud DNS.
	VersionName *string `json:"VersionName,omitempty" xml:"VersionName,omitempty"`
}

func (s DescribeDomainInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoResponseBody) SetAliDomain(v bool) *DescribeDomainInfoResponseBody {
	s.AliDomain = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetAvailableTtls(v *DescribeDomainInfoResponseBodyAvailableTtls) *DescribeDomainInfoResponseBody {
	s.AvailableTtls = v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetCreateTime(v string) *DescribeDomainInfoResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetDnsServers(v *DescribeDomainInfoResponseBodyDnsServers) *DescribeDomainInfoResponseBody {
	s.DnsServers = v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetDomainId(v string) *DescribeDomainInfoResponseBody {
	s.DomainId = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetDomainLoggingSwitchStatus(v string) *DescribeDomainInfoResponseBody {
	s.DomainLoggingSwitchStatus = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetDomainName(v string) *DescribeDomainInfoResponseBody {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetGroupId(v string) *DescribeDomainInfoResponseBody {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetGroupName(v string) *DescribeDomainInfoResponseBody {
	s.GroupName = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetInBlackHole(v bool) *DescribeDomainInfoResponseBody {
	s.InBlackHole = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetInClean(v bool) *DescribeDomainInfoResponseBody {
	s.InClean = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetInstanceId(v string) *DescribeDomainInfoResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetLineType(v string) *DescribeDomainInfoResponseBody {
	s.LineType = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetMinTtl(v int64) *DescribeDomainInfoResponseBody {
	s.MinTtl = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetPunyCode(v string) *DescribeDomainInfoResponseBody {
	s.PunyCode = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetRecordLineTreeJson(v string) *DescribeDomainInfoResponseBody {
	s.RecordLineTreeJson = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetRecordLines(v *DescribeDomainInfoResponseBodyRecordLines) *DescribeDomainInfoResponseBody {
	s.RecordLines = v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetRegionLines(v bool) *DescribeDomainInfoResponseBody {
	s.RegionLines = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetRemark(v string) *DescribeDomainInfoResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetRequestId(v string) *DescribeDomainInfoResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetResourceGroupId(v string) *DescribeDomainInfoResponseBody {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetSlaveDns(v bool) *DescribeDomainInfoResponseBody {
	s.SlaveDns = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetSubDomain(v bool) *DescribeDomainInfoResponseBody {
	s.SubDomain = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetVersionCode(v string) *DescribeDomainInfoResponseBody {
	s.VersionCode = &v
	return s
}

func (s *DescribeDomainInfoResponseBody) SetVersionName(v string) *DescribeDomainInfoResponseBody {
	s.VersionName = &v
	return s
}

type DescribeDomainInfoResponseBodyAvailableTtls struct {
	AvailableTtl []*string `json:"AvailableTtl,omitempty" xml:"AvailableTtl,omitempty" type:"Repeated"`
}

func (s DescribeDomainInfoResponseBodyAvailableTtls) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoResponseBodyAvailableTtls) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoResponseBodyAvailableTtls) SetAvailableTtl(v []*string) *DescribeDomainInfoResponseBodyAvailableTtls {
	s.AvailableTtl = v
	return s
}

type DescribeDomainInfoResponseBodyDnsServers struct {
	DnsServer []*string `json:"DnsServer,omitempty" xml:"DnsServer,omitempty" type:"Repeated"`
}

func (s DescribeDomainInfoResponseBodyDnsServers) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoResponseBodyDnsServers) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoResponseBodyDnsServers) SetDnsServer(v []*string) *DescribeDomainInfoResponseBodyDnsServers {
	s.DnsServer = v
	return s
}

type DescribeDomainInfoResponseBodyRecordLines struct {
	RecordLine []*DescribeDomainInfoResponseBodyRecordLinesRecordLine `json:"RecordLine,omitempty" xml:"RecordLine,omitempty" type:"Repeated"`
}

func (s DescribeDomainInfoResponseBodyRecordLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoResponseBodyRecordLines) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoResponseBodyRecordLines) SetRecordLine(v []*DescribeDomainInfoResponseBodyRecordLinesRecordLine) *DescribeDomainInfoResponseBodyRecordLines {
	s.RecordLine = v
	return s
}

type DescribeDomainInfoResponseBodyRecordLinesRecordLine struct {
	// The code of the parent line. This parameter is not returned if the line has no parent line.
	//
	// example:
	//
	// internal
	FatherCode *string `json:"FatherCode,omitempty" xml:"FatherCode,omitempty"`
	// The code of the line.
	//
	// example:
	//
	// cn_region_xibei
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The name of the parent line.
	LineDisplayName *string `json:"LineDisplayName,omitempty" xml:"LineDisplayName,omitempty"`
	// The name of the line.
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeDomainInfoResponseBodyRecordLinesRecordLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoResponseBodyRecordLinesRecordLine) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoResponseBodyRecordLinesRecordLine) SetFatherCode(v string) *DescribeDomainInfoResponseBodyRecordLinesRecordLine {
	s.FatherCode = &v
	return s
}

func (s *DescribeDomainInfoResponseBodyRecordLinesRecordLine) SetLineCode(v string) *DescribeDomainInfoResponseBodyRecordLinesRecordLine {
	s.LineCode = &v
	return s
}

func (s *DescribeDomainInfoResponseBodyRecordLinesRecordLine) SetLineDisplayName(v string) *DescribeDomainInfoResponseBodyRecordLinesRecordLine {
	s.LineDisplayName = &v
	return s
}

func (s *DescribeDomainInfoResponseBodyRecordLinesRecordLine) SetLineName(v string) *DescribeDomainInfoResponseBodyRecordLinesRecordLine {
	s.LineName = &v
	return s
}

type DescribeDomainInfoResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainInfoResponse) SetHeaders(v map[string]*string) *DescribeDomainInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainInfoResponse) SetStatusCode(v int32) *DescribeDomainInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainInfoResponse) SetBody(v *DescribeDomainInfoResponseBody) *DescribeDomainInfoResponse {
	s.Body = v
	return s
}

type DescribeDomainLogsRequest struct {
	// The ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The keyword for the query in "%KeyWord%" mode. The keyword is not case-sensitive.
	//
	// example:
	//
	// test
	KeyWord *string `json:"KeyWord,omitempty" xml:"KeyWord,omitempty"`
	// The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number to return. The page number starts from **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return per page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The start time for the query. Format: **YYYY-MM-DD**
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The type of object of which you want to query operation logs. Valid values:
	//
	// 	- domain: domain name
	//
	// 	- slavedns: secondary Domain Name System (DNS)
	//
	// example:
	//
	// domain
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The end time for the query. Format: **YYYY-MM-DD**
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"endDate,omitempty" xml:"endDate,omitempty"`
}

func (s DescribeDomainLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainLogsRequest) SetGroupId(v string) *DescribeDomainLogsRequest {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetKeyWord(v string) *DescribeDomainLogsRequest {
	s.KeyWord = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetLang(v string) *DescribeDomainLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetPageNumber(v int64) *DescribeDomainLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetPageSize(v int64) *DescribeDomainLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetStartDate(v string) *DescribeDomainLogsRequest {
	s.StartDate = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetType(v string) *DescribeDomainLogsRequest {
	s.Type = &v
	return s
}

func (s *DescribeDomainLogsRequest) SetEndDate(v string) *DescribeDomainLogsRequest {
	s.EndDate = &v
	return s
}

type DescribeDomainLogsResponseBody struct {
	// The operation logs.
	DomainLogs *DescribeDomainLogsResponseBodyDomainLogs `json:"DomainLogs,omitempty" xml:"DomainLogs,omitempty" type:"Struct"`
	// The page number.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 2
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 2
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDomainLogsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainLogsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainLogsResponseBody) SetDomainLogs(v *DescribeDomainLogsResponseBodyDomainLogs) *DescribeDomainLogsResponseBody {
	s.DomainLogs = v
	return s
}

func (s *DescribeDomainLogsResponseBody) SetPageNumber(v int64) *DescribeDomainLogsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainLogsResponseBody) SetPageSize(v int64) *DescribeDomainLogsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainLogsResponseBody) SetRequestId(v string) *DescribeDomainLogsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainLogsResponseBody) SetTotalCount(v int64) *DescribeDomainLogsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDomainLogsResponseBodyDomainLogs struct {
	DomainLog []*DescribeDomainLogsResponseBodyDomainLogsDomainLog `json:"DomainLog,omitempty" xml:"DomainLog,omitempty" type:"Repeated"`
}

func (s DescribeDomainLogsResponseBodyDomainLogs) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainLogsResponseBodyDomainLogs) GoString() string {
	return s.String()
}

func (s *DescribeDomainLogsResponseBodyDomainLogs) SetDomainLog(v []*DescribeDomainLogsResponseBodyDomainLogsDomainLog) *DescribeDomainLogsResponseBodyDomainLogs {
	s.DomainLog = v
	return s
}

type DescribeDomainLogsResponseBodyDomainLogsDomainLog struct {
	// The operation.
	//
	// example:
	//
	// Add
	Action *string `json:"Action,omitempty" xml:"Action,omitempty"`
	// The time when the operation is performed. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2015-12-12T09:23Z
	ActionTime *string `json:"ActionTime,omitempty" xml:"ActionTime,omitempty"`
	// The time when the operation was performed. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 143562300000
	ActionTimestamp *int64 `json:"ActionTimestamp,omitempty" xml:"ActionTimestamp,omitempty"`
	// The IP address of the operator.
	//
	// example:
	//
	// 182.92.253.20
	ClientIp *string `json:"ClientIp,omitempty" xml:"ClientIp,omitempty"`
	// The domain name.
	//
	// example:
	//
	// abc.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The message for the operation.
	//
	// example:
	//
	// To the DNS record list
	Message *string `json:"Message,omitempty" xml:"Message,omitempty"`
	// The ID of the private zone.
	//
	// example:
	//
	// cxfd345sd234
	ZoneId *string `json:"ZoneId,omitempty" xml:"ZoneId,omitempty"`
}

func (s DescribeDomainLogsResponseBodyDomainLogsDomainLog) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainLogsResponseBodyDomainLogsDomainLog) GoString() string {
	return s.String()
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetAction(v string) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.Action = &v
	return s
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetActionTime(v string) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.ActionTime = &v
	return s
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetActionTimestamp(v int64) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.ActionTimestamp = &v
	return s
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetClientIp(v string) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.ClientIp = &v
	return s
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetDomainName(v string) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetMessage(v string) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.Message = &v
	return s
}

func (s *DescribeDomainLogsResponseBodyDomainLogsDomainLog) SetZoneId(v string) *DescribeDomainLogsResponseBodyDomainLogsDomainLog {
	s.ZoneId = &v
	return s
}

type DescribeDomainLogsResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainLogsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainLogsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainLogsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainLogsResponse) SetHeaders(v map[string]*string) *DescribeDomainLogsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainLogsResponse) SetStatusCode(v int32) *DescribeDomainLogsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainLogsResponse) SetBody(v *DescribeDomainLogsResponseBody) *DescribeDomainLogsResponse {
	s.Body = v
	return s
}

type DescribeDomainNsRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The language of the content in the request and response.
	//
	// Valid values:
	//
	// zh: Chinese\\
	//
	// en: English
	//
	// Default value: **zh**
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeDomainNsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainNsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainNsRequest) SetDomainName(v string) *DescribeDomainNsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainNsRequest) SetLang(v string) *DescribeDomainNsRequest {
	s.Lang = &v
	return s
}

type DescribeDomainNsResponseBody struct {
	// Indicates whether all the name servers are Alibaba Cloud DNS servers.
	//
	// example:
	//
	// true
	AllAliDns *bool `json:"AllAliDns,omitempty" xml:"AllAliDns,omitempty"`
	// The cause code of the detection failure.
	//
	// example:
	//
	// DnsCheck.Failed
	DetectFailedReasonCode *string `json:"DetectFailedReasonCode,omitempty" xml:"DetectFailedReasonCode,omitempty"`
	// The DNS server names configured for the domain name.
	DnsServers *DescribeDomainNsResponseBodyDnsServers `json:"DnsServers,omitempty" xml:"DnsServers,omitempty" type:"Struct"`
	// The Domain Name System (DNS) server names assigned by Alibaba Cloud DNS.
	ExpectDnsServers *DescribeDomainNsResponseBodyExpectDnsServers `json:"ExpectDnsServers,omitempty" xml:"ExpectDnsServers,omitempty" type:"Struct"`
	// Indicates whether the name servers include Alibaba Cloud DNS servers.
	//
	// example:
	//
	// true
	IncludeAliDns *bool `json:"IncludeAliDns,omitempty" xml:"IncludeAliDns,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 16C7DC7A-2FA7-4D14-8B12-88A2BB6373DB
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeDomainNsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainNsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainNsResponseBody) SetAllAliDns(v bool) *DescribeDomainNsResponseBody {
	s.AllAliDns = &v
	return s
}

func (s *DescribeDomainNsResponseBody) SetDetectFailedReasonCode(v string) *DescribeDomainNsResponseBody {
	s.DetectFailedReasonCode = &v
	return s
}

func (s *DescribeDomainNsResponseBody) SetDnsServers(v *DescribeDomainNsResponseBodyDnsServers) *DescribeDomainNsResponseBody {
	s.DnsServers = v
	return s
}

func (s *DescribeDomainNsResponseBody) SetExpectDnsServers(v *DescribeDomainNsResponseBodyExpectDnsServers) *DescribeDomainNsResponseBody {
	s.ExpectDnsServers = v
	return s
}

func (s *DescribeDomainNsResponseBody) SetIncludeAliDns(v bool) *DescribeDomainNsResponseBody {
	s.IncludeAliDns = &v
	return s
}

func (s *DescribeDomainNsResponseBody) SetRequestId(v string) *DescribeDomainNsResponseBody {
	s.RequestId = &v
	return s
}

type DescribeDomainNsResponseBodyDnsServers struct {
	DnsServer []*string `json:"DnsServer,omitempty" xml:"DnsServer,omitempty" type:"Repeated"`
}

func (s DescribeDomainNsResponseBodyDnsServers) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainNsResponseBodyDnsServers) GoString() string {
	return s.String()
}

func (s *DescribeDomainNsResponseBodyDnsServers) SetDnsServer(v []*string) *DescribeDomainNsResponseBodyDnsServers {
	s.DnsServer = v
	return s
}

type DescribeDomainNsResponseBodyExpectDnsServers struct {
	ExpectDnsServer []*string `json:"ExpectDnsServer,omitempty" xml:"ExpectDnsServer,omitempty" type:"Repeated"`
}

func (s DescribeDomainNsResponseBodyExpectDnsServers) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainNsResponseBodyExpectDnsServers) GoString() string {
	return s.String()
}

func (s *DescribeDomainNsResponseBodyExpectDnsServers) SetExpectDnsServer(v []*string) *DescribeDomainNsResponseBodyExpectDnsServers {
	s.ExpectDnsServer = v
	return s
}

type DescribeDomainNsResponse struct {
	Headers    map[string]*string            `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                        `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainNsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainNsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainNsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainNsResponse) SetHeaders(v map[string]*string) *DescribeDomainNsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainNsResponse) SetStatusCode(v int32) *DescribeDomainNsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainNsResponse) SetBody(v *DescribeDomainNsResponseBody) *DescribeDomainNsResponse {
	s.Body = v
	return s
}

type DescribeDomainRecordInfoRequest struct {
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the DNS record. You can call the [DescribeDomainRecords](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomainrecords?spm=a2c63.p38356.help-menu-search-29697.d_0) to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// 9999985
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 192.0.2.0
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
}

func (s DescribeDomainRecordInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordInfoRequest) SetLang(v string) *DescribeDomainRecordInfoRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainRecordInfoRequest) SetRecordId(v string) *DescribeDomainRecordInfoRequest {
	s.RecordId = &v
	return s
}

func (s *DescribeDomainRecordInfoRequest) SetUserClientIp(v string) *DescribeDomainRecordInfoRequest {
	s.UserClientIp = &v
	return s
}

type DescribeDomainRecordInfoResponseBody struct {
	// The ID of the domain name.
	//
	// example:
	//
	// 00efd71a-770e-4255-b54e-6fe5659baffe
	DomainId *string `json:"DomainId,omitempty" xml:"DomainId,omitempty"`
	// The domain name.
	//
	// example:
	//
	// dns-example.top
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the domain name group.
	//
	// example:
	//
	// MyGroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The DNS resolution line.
	//
	// example:
	//
	// default
	Line *string `json:"Line,omitempty" xml:"Line,omitempty"`
	// The lock state of the DNS record. Valid values: **true and false**.
	//
	// example:
	//
	// true
	Locked *bool `json:"Locked,omitempty" xml:"Locked,omitempty"`
	// The priority of the mail exchanger (MX) record.
	//
	// example:
	//
	// 5
	Priority *int64 `json:"Priority,omitempty" xml:"Priority,omitempty"`
	// The Punycode for the domain name. This parameter is returned only for Chinese domain names.
	//
	// example:
	//
	// xn--fsq270a.com
	PunyCode *string `json:"PunyCode,omitempty" xml:"PunyCode,omitempty"`
	// The hostname.
	//
	// example:
	//
	// @
	RR *string `json:"RR,omitempty" xml:"RR,omitempty"`
	// The ID of the DNS record.
	//
	// example:
	//
	// 9999985
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The description of your DNS record.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The status of the DNS record. Valid values:
	//
	// Enable: enabled
	//
	// Disable: disabled
	//
	// example:
	//
	// Enable
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The time for which the DNS record is cached in a local DNS system.
	//
	// example:
	//
	// 600
	TTL *int64 `json:"TTL,omitempty" xml:"TTL,omitempty"`
	// The type of the DNS record.
	//
	// example:
	//
	// MX
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The record value.
	//
	// example:
	//
	// 1.1.XX.XX
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s DescribeDomainRecordInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordInfoResponseBody) SetDomainId(v string) *DescribeDomainRecordInfoResponseBody {
	s.DomainId = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetDomainName(v string) *DescribeDomainRecordInfoResponseBody {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetGroupId(v string) *DescribeDomainRecordInfoResponseBody {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetGroupName(v string) *DescribeDomainRecordInfoResponseBody {
	s.GroupName = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetLine(v string) *DescribeDomainRecordInfoResponseBody {
	s.Line = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetLocked(v bool) *DescribeDomainRecordInfoResponseBody {
	s.Locked = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetPriority(v int64) *DescribeDomainRecordInfoResponseBody {
	s.Priority = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetPunyCode(v string) *DescribeDomainRecordInfoResponseBody {
	s.PunyCode = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetRR(v string) *DescribeDomainRecordInfoResponseBody {
	s.RR = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetRecordId(v string) *DescribeDomainRecordInfoResponseBody {
	s.RecordId = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetRemark(v string) *DescribeDomainRecordInfoResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetRequestId(v string) *DescribeDomainRecordInfoResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetStatus(v string) *DescribeDomainRecordInfoResponseBody {
	s.Status = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetTTL(v int64) *DescribeDomainRecordInfoResponseBody {
	s.TTL = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetType(v string) *DescribeDomainRecordInfoResponseBody {
	s.Type = &v
	return s
}

func (s *DescribeDomainRecordInfoResponseBody) SetValue(v string) *DescribeDomainRecordInfoResponseBody {
	s.Value = &v
	return s
}

type DescribeDomainRecordInfoResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainRecordInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainRecordInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordInfoResponse) SetHeaders(v map[string]*string) *DescribeDomainRecordInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainRecordInfoResponse) SetStatusCode(v int32) *DescribeDomainRecordInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainRecordInfoResponse) SetBody(v *DescribeDomainRecordInfoResponseBody) *DescribeDomainRecordInfoResponse {
	s.Body = v
	return s
}

type DescribeDomainRecordsRequest struct {
	// The order in which you want to sort the returned DNS records. Valid values: DESC and ASC. Default value: DESC.
	//
	// example:
	//
	// DESC
	Direction *string `json:"Direction,omitempty" xml:"Direction,omitempty"`
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the domain name group.
	//
	// 	- If you do not specify GroupId, all domain names are queried.
	//
	// 	- If you set GroupId to 0, no value is returned.
	//
	// 	- If you set GroupId to 1, the domain names in the default group are queried.
	//
	// 	- If you set GroupId to -2, all domain names are queried.
	//
	// 	- You can also specify GroupId based on the actual group ID.
	//
	// You can call the [DescribeDomainGroups ](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomaingroups?spm=a2c63.p38356.help-menu-search-29697.d_0)operation to obtain the ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *int64 `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The keyword.
	//
	// example:
	//
	// test
	KeyWord *string `json:"KeyWord,omitempty" xml:"KeyWord,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The resolution line. Default value: **default**.
	//
	// For more information, see
	//
	// [DNS lines](https://www.alibabacloud.com/help/zh/doc-detail/29807.htm).
	//
	// example:
	//
	// cn_mobile_anhui
	Line *string `json:"Line,omitempty" xml:"Line,omitempty"`
	// The method that is used to sort the returned DNS records. By default, the DNS records are sorted in reverse chronological order based on the time when they were added.
	//
	// example:
	//
	// default
	OrderBy *string `json:"OrderBy,omitempty" xml:"OrderBy,omitempty"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 500**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The hostname keyword based on which the system queries DNS records. The system queries DNS records based on the value of this parameter in fuzzy match mode. The value is not case-sensitive.
	//
	// example:
	//
	// www
	RRKeyWord *string `json:"RRKeyWord,omitempty" xml:"RRKeyWord,omitempty"`
	// The search mode. Valid values: **LIKE, EXACT, and ADVANCED**.
	//
	// 	- If you set SearchMode to LIKE or EXACT, specify KeyWord. In this case, RRKeyWord, TypeKeyWord, ValueKeyWord, Type, Line, and Status are invalid.
	//
	// 	- If you set SearchMode to ADVANCED, specify RRKeyWord, TypeKeyWord, ValueKeyWord, Type, Line, and Status.
	//
	// 	- If you do not specify SearchMode, the system determines the search mode based on the following rules:
	//
	//     	- If KeyWord is specified, the system uses the LIKE mode.
	//
	//     	- If KeyWord is not specified, the system queries DNS records based on values of RRKeyWord and ValueKeyWord in fuzzy match mode, and based on the values of TypeKeyWord, Type, Line, and Status in exact match mode.
	//
	// example:
	//
	// LIKE
	SearchMode *string `json:"SearchMode,omitempty" xml:"SearchMode,omitempty"`
	// The status of the DNS records to query. Valid values: **Enable and Disable**.
	//
	// example:
	//
	// Enable
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The type of the DNS records to query. For more information, see
	//
	// [DNS record types](https://www.alibabacloud.com/help/zh/doc-detail/29805.htm).
	//
	// example:
	//
	// A
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The type keyword based on which the system queries DNS records. The system queries DNS records based on the value of this parameter in exact match mode. The value is not case-sensitive.
	//
	// example:
	//
	// MX
	TypeKeyWord *string `json:"TypeKeyWord,omitempty" xml:"TypeKeyWord,omitempty"`
	// The record value keyword based on which the system queries DNS records. The system queries DNS records based on the value of this parameter in fuzzy match mode. The value is not case-sensitive.
	//
	// example:
	//
	// com
	ValueKeyWord *string `json:"ValueKeyWord,omitempty" xml:"ValueKeyWord,omitempty"`
}

func (s DescribeDomainRecordsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordsRequest) SetDirection(v string) *DescribeDomainRecordsRequest {
	s.Direction = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetDomainName(v string) *DescribeDomainRecordsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetGroupId(v int64) *DescribeDomainRecordsRequest {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetKeyWord(v string) *DescribeDomainRecordsRequest {
	s.KeyWord = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetLang(v string) *DescribeDomainRecordsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetLine(v string) *DescribeDomainRecordsRequest {
	s.Line = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetOrderBy(v string) *DescribeDomainRecordsRequest {
	s.OrderBy = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetPageNumber(v int64) *DescribeDomainRecordsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetPageSize(v int64) *DescribeDomainRecordsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetRRKeyWord(v string) *DescribeDomainRecordsRequest {
	s.RRKeyWord = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetSearchMode(v string) *DescribeDomainRecordsRequest {
	s.SearchMode = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetStatus(v string) *DescribeDomainRecordsRequest {
	s.Status = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetType(v string) *DescribeDomainRecordsRequest {
	s.Type = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetTypeKeyWord(v string) *DescribeDomainRecordsRequest {
	s.TypeKeyWord = &v
	return s
}

func (s *DescribeDomainRecordsRequest) SetValueKeyWord(v string) *DescribeDomainRecordsRequest {
	s.ValueKeyWord = &v
	return s
}

type DescribeDomainRecordsResponseBody struct {
	// The returned Domain Name System (DNS) records.
	DomainRecords *DescribeDomainRecordsResponseBodyDomainRecords `json:"DomainRecords,omitempty" xml:"DomainRecords,omitempty" type:"Struct"`
	// The page number.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 2
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDomainRecordsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordsResponseBody) SetDomainRecords(v *DescribeDomainRecordsResponseBodyDomainRecords) *DescribeDomainRecordsResponseBody {
	s.DomainRecords = v
	return s
}

func (s *DescribeDomainRecordsResponseBody) SetPageNumber(v int64) *DescribeDomainRecordsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainRecordsResponseBody) SetPageSize(v int64) *DescribeDomainRecordsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainRecordsResponseBody) SetRequestId(v string) *DescribeDomainRecordsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainRecordsResponseBody) SetTotalCount(v int64) *DescribeDomainRecordsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDomainRecordsResponseBodyDomainRecords struct {
	Record []*DescribeDomainRecordsResponseBodyDomainRecordsRecord `json:"Record,omitempty" xml:"Record,omitempty" type:"Repeated"`
}

func (s DescribeDomainRecordsResponseBodyDomainRecords) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordsResponseBodyDomainRecords) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordsResponseBodyDomainRecords) SetRecord(v []*DescribeDomainRecordsResponseBodyDomainRecordsRecord) *DescribeDomainRecordsResponseBodyDomainRecords {
	s.Record = v
	return s
}

type DescribeDomainRecordsResponseBodyDomainRecordsRecord struct {
	// The time when the DNS record was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since 00:00:00 UTC on January 1, 1970.
	//
	// example:
	//
	// 1666501957000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The resolution line.
	//
	// example:
	//
	// default
	Line *string `json:"Line,omitempty" xml:"Line,omitempty"`
	// Indicates whether the DNS record is locked.
	//
	// example:
	//
	// false
	Locked *bool `json:"Locked,omitempty" xml:"Locked,omitempty"`
	// The priority of the mail exchanger (MX) record.
	//
	// example:
	//
	// 5
	Priority *int64 `json:"Priority,omitempty" xml:"Priority,omitempty"`
	// The hostname.
	//
	// example:
	//
	// www
	RR *string `json:"RR,omitempty" xml:"RR,omitempty"`
	// The ID of the DNS record.
	//
	// example:
	//
	// 9999985
	RecordId *string `json:"RecordId,omitempty" xml:"RecordId,omitempty"`
	// The description of the DNS record.
	//
	// example:
	//
	// test
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The status of the DNS record.
	//
	// example:
	//
	// Enable
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The time-to-live (TTL) of the cached DNS record. Unit: seconds.
	//
	// example:
	//
	// 600
	TTL *int64 `json:"TTL,omitempty" xml:"TTL,omitempty"`
	// The type of the DNS record.
	//
	// example:
	//
	// MX
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The time when the DNS record was updated. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since 00:00:00 UTC on January 1, 1970.
	//
	// example:
	//
	// 1676872961000
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// The record value.
	//
	// example:
	//
	// mail1.hichina.com
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
	// The weight of the DNS record.
	//
	// example:
	//
	// 2
	Weight *int32 `json:"Weight,omitempty" xml:"Weight,omitempty"`
}

func (s DescribeDomainRecordsResponseBodyDomainRecordsRecord) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordsResponseBodyDomainRecordsRecord) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetCreateTimestamp(v int64) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetDomainName(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetLine(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Line = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetLocked(v bool) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Locked = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetPriority(v int64) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Priority = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetRR(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.RR = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetRecordId(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.RecordId = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetRemark(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Remark = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetStatus(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Status = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetTTL(v int64) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.TTL = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetType(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Type = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetUpdateTimestamp(v int64) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetValue(v string) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Value = &v
	return s
}

func (s *DescribeDomainRecordsResponseBodyDomainRecordsRecord) SetWeight(v int32) *DescribeDomainRecordsResponseBodyDomainRecordsRecord {
	s.Weight = &v
	return s
}

type DescribeDomainRecordsResponse struct {
	Headers    map[string]*string                 `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                             `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainRecordsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainRecordsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainRecordsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainRecordsResponse) SetHeaders(v map[string]*string) *DescribeDomainRecordsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainRecordsResponse) SetStatusCode(v int32) *DescribeDomainRecordsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainRecordsResponse) SetBody(v *DescribeDomainRecordsResponseBody) *DescribeDomainRecordsResponse {
	s.Body = v
	return s
}

type DescribeDomainResolveStatisticsSummaryRequest struct {
	// The order in which you want to sort the returned entries. Valid values:
	//
	// 	- DESC: the descending order
	//
	// 	- ASC: the ascending order
	//
	// example:
	//
	// DESC
	Direction *string `json:"Direction,omitempty" xml:"Direction,omitempty"`
	// The end time in the yyyy-MM-dd format, for example, 2023-03-13.
	//
	// example:
	//
	// 2023-03-01
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The keyword. The Keyword parameter is used together with the SearchMode parameter.
	//
	// example:
	//
	// test
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language. Valid values: zh, en, and ja.
	//
	// example:
	//
	// zh
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Valid values: 1 to 1000.
	//
	// example:
	//
	// 10
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The search mode of the keyword. Valid values:
	//
	// 	- LIKE (default): fuzzy search
	//
	// 	- EXACT: exact search
	//
	// example:
	//
	// EXACT
	SearchMode *string `json:"SearchMode,omitempty" xml:"SearchMode,omitempty"`
	// The start time in the yyyy-MM-dd format, for example, 2023-03-01.
	//
	// This parameter is required.
	//
	// example:
	//
	// 2023-03-01
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The threshold for the number of Domain Name System (DNS) requests. You can query the domain names at the specified quantity level of DNS requests and query the number of DNS requests for each domain name.
	//
	// If you do not specify this parameter, the data about the domain names that have DNS requests is obtained.
	//
	// If you set this parameter to a value less than 0, the data about all domain names is obtained.
	//
	// If you set this parameter to 0, the data about the domain names that do not have DNS requests is obtained.
	//
	// If you set this parameter to a value greater than 0, the data about the domain names whose number of DNS requests is less than or equal to the value of this parameter is obtained.
	//
	// example:
	//
	// -1
	Threshold *int64 `json:"Threshold,omitempty" xml:"Threshold,omitempty"`
}

func (s DescribeDomainResolveStatisticsSummaryRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainResolveStatisticsSummaryRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetDirection(v string) *DescribeDomainResolveStatisticsSummaryRequest {
	s.Direction = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetEndDate(v string) *DescribeDomainResolveStatisticsSummaryRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetKeyword(v string) *DescribeDomainResolveStatisticsSummaryRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetLang(v string) *DescribeDomainResolveStatisticsSummaryRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetPageNumber(v int32) *DescribeDomainResolveStatisticsSummaryRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetPageSize(v int32) *DescribeDomainResolveStatisticsSummaryRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetSearchMode(v string) *DescribeDomainResolveStatisticsSummaryRequest {
	s.SearchMode = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetStartDate(v string) *DescribeDomainResolveStatisticsSummaryRequest {
	s.StartDate = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryRequest) SetThreshold(v int64) *DescribeDomainResolveStatisticsSummaryRequest {
	s.Threshold = &v
	return s
}

type DescribeDomainResolveStatisticsSummaryResponseBody struct {
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 10
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics.
	Statistics []*DescribeDomainResolveStatisticsSummaryResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Repeated"`
	// The total number of entries returned.
	//
	// example:
	//
	// 1
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDomainResolveStatisticsSummaryResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainResolveStatisticsSummaryResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBody) SetPageNumber(v int32) *DescribeDomainResolveStatisticsSummaryResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBody) SetPageSize(v int32) *DescribeDomainResolveStatisticsSummaryResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBody) SetRequestId(v string) *DescribeDomainResolveStatisticsSummaryResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBody) SetStatistics(v []*DescribeDomainResolveStatisticsSummaryResponseBodyStatistics) *DescribeDomainResolveStatisticsSummaryResponseBody {
	s.Statistics = v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBody) SetTotalItems(v int32) *DescribeDomainResolveStatisticsSummaryResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBody) SetTotalPages(v int32) *DescribeDomainResolveStatisticsSummaryResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDomainResolveStatisticsSummaryResponseBodyStatistics struct {
	// The number of DNS requests.
	//
	// example:
	//
	// 35509014
	Count *string `json:"Count,omitempty" xml:"Count,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The type of the domain name. Valid values:
	//
	// 	- PUBLIC: hosted public domain name
	//
	// 	- CACHE: cache-accelerated domain name
	//
	// example:
	//
	// CACHE
	DomainType *string `json:"DomainType,omitempty" xml:"DomainType,omitempty"`
}

func (s DescribeDomainResolveStatisticsSummaryResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainResolveStatisticsSummaryResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBodyStatistics) SetCount(v string) *DescribeDomainResolveStatisticsSummaryResponseBodyStatistics {
	s.Count = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBodyStatistics) SetDomainName(v string) *DescribeDomainResolveStatisticsSummaryResponseBodyStatistics {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponseBodyStatistics) SetDomainType(v string) *DescribeDomainResolveStatisticsSummaryResponseBodyStatistics {
	s.DomainType = &v
	return s
}

type DescribeDomainResolveStatisticsSummaryResponse struct {
	Headers    map[string]*string                                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainResolveStatisticsSummaryResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainResolveStatisticsSummaryResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainResolveStatisticsSummaryResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainResolveStatisticsSummaryResponse) SetHeaders(v map[string]*string) *DescribeDomainResolveStatisticsSummaryResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponse) SetStatusCode(v int32) *DescribeDomainResolveStatisticsSummaryResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainResolveStatisticsSummaryResponse) SetBody(v *DescribeDomainResolveStatisticsSummaryResponseBody) *DescribeDomainResolveStatisticsSummaryResponse {
	s.Body = v
	return s
}

type DescribeDomainStatisticsRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The type of the domain name. Valid values:
	//
	// 	- PUBLIC (default): hosted public domain name
	//
	// 	- CACHE: cached public domain name
	//
	// example:
	//
	// PUBLIC CACHE
	DomainType *string `json:"DomainType,omitempty" xml:"DomainType,omitempty"`
	// The end date of the query. Specify the end date in the **YYYY-MM-DD*	- format.
	//
	// The default value is the day when you query the data.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language of the content within the request and response.
	//
	// 	- **zh**: Chinese (default)
	//
	// 	- **en**: English
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The start date of the query. Specify the start date in the **YYYY-MM-DD*	- format.
	//
	// You can only query the DNS records within the last 90 days.``
	//
	// This parameter is required.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribeDomainStatisticsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsRequest) SetDomainName(v string) *DescribeDomainStatisticsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainStatisticsRequest) SetDomainType(v string) *DescribeDomainStatisticsRequest {
	s.DomainType = &v
	return s
}

func (s *DescribeDomainStatisticsRequest) SetEndDate(v string) *DescribeDomainStatisticsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDomainStatisticsRequest) SetLang(v string) *DescribeDomainStatisticsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainStatisticsRequest) SetStartDate(v string) *DescribeDomainStatisticsRequest {
	s.StartDate = &v
	return s
}

type DescribeDomainStatisticsResponseBody struct {
	// The request ID.
	//
	// example:
	//
	// 6AEC7A64-3CB1-4C49-8B35-0B901F1E26BF
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics on the Domain Name System (DNS) requests.
	Statistics *DescribeDomainStatisticsResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Struct"`
}

func (s DescribeDomainStatisticsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsResponseBody) SetRequestId(v string) *DescribeDomainStatisticsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainStatisticsResponseBody) SetStatistics(v *DescribeDomainStatisticsResponseBodyStatistics) *DescribeDomainStatisticsResponseBody {
	s.Statistics = v
	return s
}

type DescribeDomainStatisticsResponseBodyStatistics struct {
	Statistic []*DescribeDomainStatisticsResponseBodyStatisticsStatistic `json:"Statistic,omitempty" xml:"Statistic,omitempty" type:"Repeated"`
}

func (s DescribeDomainStatisticsResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsResponseBodyStatistics) SetStatistic(v []*DescribeDomainStatisticsResponseBodyStatisticsStatistic) *DescribeDomainStatisticsResponseBodyStatistics {
	s.Statistic = v
	return s
}

type DescribeDomainStatisticsResponseBodyStatisticsStatistic struct {
	// The number of DNS requests.
	//
	// example:
	//
	// 15292887
	Count *int64 `json:"Count,omitempty" xml:"Count,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The statistical timestamp. Unit: milliseconds. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1556640000000
	Timestamp *int64 `json:"Timestamp,omitempty" xml:"Timestamp,omitempty"`
}

func (s DescribeDomainStatisticsResponseBodyStatisticsStatistic) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsResponseBodyStatisticsStatistic) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsResponseBodyStatisticsStatistic) SetCount(v int64) *DescribeDomainStatisticsResponseBodyStatisticsStatistic {
	s.Count = &v
	return s
}

func (s *DescribeDomainStatisticsResponseBodyStatisticsStatistic) SetDomainName(v string) *DescribeDomainStatisticsResponseBodyStatisticsStatistic {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainStatisticsResponseBodyStatisticsStatistic) SetTimestamp(v int64) *DescribeDomainStatisticsResponseBodyStatisticsStatistic {
	s.Timestamp = &v
	return s
}

type DescribeDomainStatisticsResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainStatisticsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainStatisticsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsResponse) SetHeaders(v map[string]*string) *DescribeDomainStatisticsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainStatisticsResponse) SetStatusCode(v int32) *DescribeDomainStatisticsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainStatisticsResponse) SetBody(v *DescribeDomainStatisticsResponseBody) *DescribeDomainStatisticsResponse {
	s.Body = v
	return s
}

type DescribeDomainStatisticsSummaryRequest struct {
	// The end of the time range to query. Specify the time in the **YYYY-MM-DD*	- format.
	//
	// The default value is the day when you perform the operation.
	//
	// example:
	//
	// 2019-07-04
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The keyword for searches in %KeyWord% mode. The value is not case-sensitive.
	//
	// example:
	//
	// test
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The search mode of the keyword. Valid values:
	//
	// 	- **LIKE**: fuzzy match (default).
	//
	// 	- **EXACT**: exact match.
	//
	// example:
	//
	// LIKE
	SearchMode *string `json:"SearchMode,omitempty" xml:"SearchMode,omitempty"`
	// The beginning of the time range to query. Specify the time in the **YYYY-MM-DD*	- format.
	//
	// You can only query DNS records of the last 90 days.
	//
	// This parameter is required.
	//
	// example:
	//
	// 2019-07-04
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The threshold of query volume that can be obtained. You can also obtain data about a domain name with the query volume less than or equal to the threshold. For example, if you set this parameter to 100, you can query domain names with less than 100 queries.
	//
	// example:
	//
	// 12
	Threshold *int64 `json:"Threshold,omitempty" xml:"Threshold,omitempty"`
}

func (s DescribeDomainStatisticsSummaryRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsSummaryRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsSummaryRequest) SetEndDate(v string) *DescribeDomainStatisticsSummaryRequest {
	s.EndDate = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetKeyword(v string) *DescribeDomainStatisticsSummaryRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetLang(v string) *DescribeDomainStatisticsSummaryRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetPageNumber(v int64) *DescribeDomainStatisticsSummaryRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetPageSize(v int64) *DescribeDomainStatisticsSummaryRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetSearchMode(v string) *DescribeDomainStatisticsSummaryRequest {
	s.SearchMode = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetStartDate(v string) *DescribeDomainStatisticsSummaryRequest {
	s.StartDate = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryRequest) SetThreshold(v int64) *DescribeDomainStatisticsSummaryRequest {
	s.Threshold = &v
	return s
}

type DescribeDomainStatisticsSummaryResponseBody struct {
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 5
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// CC625C21-8832-4683-BF10-C3CFB1A4FA13
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The statistics on the Domain Name System (DNS) requests.
	Statistics *DescribeDomainStatisticsSummaryResponseBodyStatistics `json:"Statistics,omitempty" xml:"Statistics,omitempty" type:"Struct"`
	// The total number of data records.
	//
	// example:
	//
	// 68
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of returned pages.
	//
	// example:
	//
	// 14
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeDomainStatisticsSummaryResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsSummaryResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsSummaryResponseBody) SetPageNumber(v int32) *DescribeDomainStatisticsSummaryResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBody) SetPageSize(v int32) *DescribeDomainStatisticsSummaryResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBody) SetRequestId(v string) *DescribeDomainStatisticsSummaryResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBody) SetStatistics(v *DescribeDomainStatisticsSummaryResponseBodyStatistics) *DescribeDomainStatisticsSummaryResponseBody {
	s.Statistics = v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBody) SetTotalItems(v int32) *DescribeDomainStatisticsSummaryResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBody) SetTotalPages(v int32) *DescribeDomainStatisticsSummaryResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeDomainStatisticsSummaryResponseBodyStatistics struct {
	Statistic []*DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic `json:"Statistic,omitempty" xml:"Statistic,omitempty" type:"Repeated"`
}

func (s DescribeDomainStatisticsSummaryResponseBodyStatistics) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsSummaryResponseBodyStatistics) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsSummaryResponseBodyStatistics) SetStatistic(v []*DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) *DescribeDomainStatisticsSummaryResponseBodyStatistics {
	s.Statistic = v
	return s
}

type DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic struct {
	// The number of DNS requests.
	//
	// example:
	//
	// 35509014
	Count *int64 `json:"Count,omitempty" xml:"Count,omitempty"`
	// The domain name.
	//
	// example:
	//
	// ali-gslb.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The type of the domain name. The parameter value is not case-sensitive. Valid values:
	//
	// PUBLIC (default): hosted public domain name
	//
	// CACHE: cache-accelerated domain name
	//
	// example:
	//
	// PUBLIC
	DomainType *string `json:"DomainType,omitempty" xml:"DomainType,omitempty"`
	// Indicates whether the DNS traffic analysis feature is enabled for the domain name. Valid values:
	//
	// 	- OPEN
	//
	// 	- CLOSE
	//
	// example:
	//
	// OPEN
	ResolveAnalysisStatus *string `json:"resolveAnalysisStatus,omitempty" xml:"resolveAnalysisStatus,omitempty"`
}

func (s DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) SetCount(v int64) *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic {
	s.Count = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) SetDomainName(v string) *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) SetDomainType(v string) *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic {
	s.DomainType = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic) SetResolveAnalysisStatus(v string) *DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic {
	s.ResolveAnalysisStatus = &v
	return s
}

type DescribeDomainStatisticsSummaryResponse struct {
	Headers    map[string]*string                           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainStatisticsSummaryResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainStatisticsSummaryResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainStatisticsSummaryResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainStatisticsSummaryResponse) SetHeaders(v map[string]*string) *DescribeDomainStatisticsSummaryResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponse) SetStatusCode(v int32) *DescribeDomainStatisticsSummaryResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainStatisticsSummaryResponse) SetBody(v *DescribeDomainStatisticsSummaryResponseBody) *DescribeDomainStatisticsSummaryResponse {
	s.Body = v
	return s
}

type DescribeDomainsRequest struct {
	// The ID of the domain name group. If you do not specify this parameter, all domain names are queried by default.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The keyword for searches in "%KeyWord%" mode. The value is not case-sensitive.
	//
	// example:
	//
	// com
	KeyWord *string `json:"KeyWord,omitempty" xml:"KeyWord,omitempty"`
	// The language type.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the resource group.
	//
	// example:
	//
	// rg-resourcegroupid01
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	// The search mode. Valid values:
	//
	// 	- **LIKE**: fuzzy match.
	//
	// 	- **EXACT**: exact match.
	//
	// example:
	//
	// LIKE
	SearchMode *string `json:"SearchMode,omitempty" xml:"SearchMode,omitempty"`
	// Specifies whether to query the starmark of the domain name.
	//
	// example:
	//
	// true
	Starmark *bool `json:"Starmark,omitempty" xml:"Starmark,omitempty"`
}

func (s DescribeDomainsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsRequest) GoString() string {
	return s.String()
}

func (s *DescribeDomainsRequest) SetGroupId(v string) *DescribeDomainsRequest {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainsRequest) SetKeyWord(v string) *DescribeDomainsRequest {
	s.KeyWord = &v
	return s
}

func (s *DescribeDomainsRequest) SetLang(v string) *DescribeDomainsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeDomainsRequest) SetPageNumber(v int64) *DescribeDomainsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainsRequest) SetPageSize(v int64) *DescribeDomainsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainsRequest) SetResourceGroupId(v string) *DescribeDomainsRequest {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeDomainsRequest) SetSearchMode(v string) *DescribeDomainsRequest {
	s.SearchMode = &v
	return s
}

func (s *DescribeDomainsRequest) SetStarmark(v bool) *DescribeDomainsRequest {
	s.Starmark = &v
	return s
}

type DescribeDomainsResponseBody struct {
	// The domain names.
	Domains *DescribeDomainsResponseBodyDomains `json:"Domains,omitempty" xml:"Domains,omitempty" type:"Struct"`
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 2
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 68386699-8B9E-4D5B-BC4C-75A28F6C2A00
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of domain names.
	//
	// example:
	//
	// 2
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribeDomainsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponseBody) SetDomains(v *DescribeDomainsResponseBodyDomains) *DescribeDomainsResponseBody {
	s.Domains = v
	return s
}

func (s *DescribeDomainsResponseBody) SetPageNumber(v int64) *DescribeDomainsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeDomainsResponseBody) SetPageSize(v int64) *DescribeDomainsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeDomainsResponseBody) SetRequestId(v string) *DescribeDomainsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeDomainsResponseBody) SetTotalCount(v int64) *DescribeDomainsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribeDomainsResponseBodyDomains struct {
	Domain []*DescribeDomainsResponseBodyDomainsDomain `json:"Domain,omitempty" xml:"Domain,omitempty" type:"Repeated"`
}

func (s DescribeDomainsResponseBodyDomains) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponseBodyDomains) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponseBodyDomains) SetDomain(v []*DescribeDomainsResponseBodyDomainsDomain) *DescribeDomainsResponseBodyDomains {
	s.Domain = v
	return s
}

type DescribeDomainsResponseBodyDomainsDomain struct {
	// Indicates whether the domain name was registered with Alibaba Cloud.
	//
	// example:
	//
	// true
	AliDomain *bool `json:"AliDomain,omitempty" xml:"AliDomain,omitempty"`
	// The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2019-01-30T05:25Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The time when the domain name was added. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1660546144000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The names of the DNS servers configured for the domain name assigned by Alibaba Cloud DNS.
	DnsServers *DescribeDomainsResponseBodyDomainsDomainDnsServers `json:"DnsServers,omitempty" xml:"DnsServers,omitempty" type:"Struct"`
	// The ID of the domain name.
	//
	// example:
	//
	// 00efd71a-770e-4255-b54e-6fe5659baffe
	DomainId *string `json:"DomainId,omitempty" xml:"DomainId,omitempty"`
	// Indicates whether the DNS traffic analysis feature is enabled for the domain name. Valid values:
	//
	// 	- OPEN
	//
	// 	- CLOSE
	//
	// example:
	//
	// OPEN
	DomainLoggingSwitchStatus *string `json:"DomainLoggingSwitchStatus,omitempty" xml:"DomainLoggingSwitchStatus,omitempty"`
	// The domain name.
	//
	// example:
	//
	// abc.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The ID of the domain name group.
	//
	// example:
	//
	// 2223
	GroupId *string `json:"GroupId,omitempty" xml:"GroupId,omitempty"`
	// The name of the domain name group.
	//
	// example:
	//
	// mygroup
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The time when the Alibaba Cloud DNS instance expires. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2020-03-14T16:00Z
	InstanceEndTime *string `json:"InstanceEndTime,omitempty" xml:"InstanceEndTime,omitempty"`
	// Indicates whether the Alibaba Cloud DNS instance expires.
	//
	// example:
	//
	// false
	InstanceExpired *bool `json:"InstanceExpired,omitempty" xml:"InstanceExpired,omitempty"`
	// The ID of the Alibaba Cloud DNS instance.
	//
	// example:
	//
	// i-7bg
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The Punycode for the domain name. This parameter is returned only for Chinese domain names.
	//
	// example:
	//
	// abc.com
	PunyCode *string `json:"PunyCode,omitempty" xml:"PunyCode,omitempty"`
	// The number of Domain Name System (DNS) records added for the domain name.
	//
	// example:
	//
	// 100
	RecordCount *int64 `json:"RecordCount,omitempty" xml:"RecordCount,omitempty"`
	// The email address of the registrant.
	//
	// example:
	//
	// test@example.com
	RegistrantEmail *string `json:"RegistrantEmail,omitempty" xml:"RegistrantEmail,omitempty"`
	// The description of the domain name.
	//
	// example:
	//
	// remark
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The ID of the resource group to which the domain name belongs.
	//
	// example:
	//
	// rg-acf
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	SlaveDnsStatus  *string `json:"SlaveDnsStatus,omitempty" xml:"SlaveDnsStatus,omitempty"`
	// Indicates whether the domain name was added to favorites.
	//
	// example:
	//
	// true
	Starmark *bool `json:"Starmark,omitempty" xml:"Starmark,omitempty"`
	// The tags added to the resource.
	Tags *DescribeDomainsResponseBodyDomainsDomainTags `json:"Tags,omitempty" xml:"Tags,omitempty" type:"Struct"`
	// The edition code of Alibaba Cloud DNS.
	//
	// example:
	//
	// version_enterprise_basic
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
	// The edition of Alibaba Cloud DNS.
	VersionName *string `json:"VersionName,omitempty" xml:"VersionName,omitempty"`
}

func (s DescribeDomainsResponseBodyDomainsDomain) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponseBodyDomainsDomain) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetAliDomain(v bool) *DescribeDomainsResponseBodyDomainsDomain {
	s.AliDomain = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetCreateTime(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.CreateTime = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetCreateTimestamp(v int64) *DescribeDomainsResponseBodyDomainsDomain {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetDnsServers(v *DescribeDomainsResponseBodyDomainsDomainDnsServers) *DescribeDomainsResponseBodyDomainsDomain {
	s.DnsServers = v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetDomainId(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.DomainId = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetDomainLoggingSwitchStatus(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.DomainLoggingSwitchStatus = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetDomainName(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.DomainName = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetGroupId(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.GroupId = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetGroupName(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.GroupName = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetInstanceEndTime(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.InstanceEndTime = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetInstanceExpired(v bool) *DescribeDomainsResponseBodyDomainsDomain {
	s.InstanceExpired = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetInstanceId(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.InstanceId = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetPunyCode(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.PunyCode = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetRecordCount(v int64) *DescribeDomainsResponseBodyDomainsDomain {
	s.RecordCount = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetRegistrantEmail(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.RegistrantEmail = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetRemark(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.Remark = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetResourceGroupId(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetSlaveDnsStatus(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.SlaveDnsStatus = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetStarmark(v bool) *DescribeDomainsResponseBodyDomainsDomain {
	s.Starmark = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetTags(v *DescribeDomainsResponseBodyDomainsDomainTags) *DescribeDomainsResponseBodyDomainsDomain {
	s.Tags = v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetVersionCode(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.VersionCode = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomain) SetVersionName(v string) *DescribeDomainsResponseBodyDomainsDomain {
	s.VersionName = &v
	return s
}

type DescribeDomainsResponseBodyDomainsDomainDnsServers struct {
	DnsServer []*string `json:"DnsServer,omitempty" xml:"DnsServer,omitempty" type:"Repeated"`
}

func (s DescribeDomainsResponseBodyDomainsDomainDnsServers) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponseBodyDomainsDomainDnsServers) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponseBodyDomainsDomainDnsServers) SetDnsServer(v []*string) *DescribeDomainsResponseBodyDomainsDomainDnsServers {
	s.DnsServer = v
	return s
}

type DescribeDomainsResponseBodyDomainsDomainTags struct {
	Tag []*DescribeDomainsResponseBodyDomainsDomainTagsTag `json:"Tag,omitempty" xml:"Tag,omitempty" type:"Repeated"`
}

func (s DescribeDomainsResponseBodyDomainsDomainTags) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponseBodyDomainsDomainTags) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponseBodyDomainsDomainTags) SetTag(v []*DescribeDomainsResponseBodyDomainsDomainTagsTag) *DescribeDomainsResponseBodyDomainsDomainTags {
	s.Tag = v
	return s
}

type DescribeDomainsResponseBodyDomainsDomainTagsTag struct {
	// The key of tag N added to the resource.
	Key *string `json:"Key,omitempty" xml:"Key,omitempty"`
	// The value of tag N added to the resource.
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s DescribeDomainsResponseBodyDomainsDomainTagsTag) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponseBodyDomainsDomainTagsTag) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponseBodyDomainsDomainTagsTag) SetKey(v string) *DescribeDomainsResponseBodyDomainsDomainTagsTag {
	s.Key = &v
	return s
}

func (s *DescribeDomainsResponseBodyDomainsDomainTagsTag) SetValue(v string) *DescribeDomainsResponseBodyDomainsDomainTagsTag {
	s.Value = &v
	return s
}

type DescribeDomainsResponse struct {
	Headers    map[string]*string           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeDomainsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeDomainsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeDomainsResponse) GoString() string {
	return s.String()
}

func (s *DescribeDomainsResponse) SetHeaders(v map[string]*string) *DescribeDomainsResponse {
	s.Headers = v
	return s
}

func (s *DescribeDomainsResponse) SetStatusCode(v int32) *DescribeDomainsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeDomainsResponse) SetBody(v *DescribeDomainsResponseBody) *DescribeDomainsResponse {
	s.Body = v
	return s
}

type DescribeGtmAccessStrategiesRequest struct {
	// The ID of the GTM instance whose access policies you want to query.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeGtmAccessStrategiesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesRequest) SetInstanceId(v string) *DescribeGtmAccessStrategiesRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmAccessStrategiesRequest) SetLang(v string) *DescribeGtmAccessStrategiesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmAccessStrategiesRequest) SetPageNumber(v int32) *DescribeGtmAccessStrategiesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmAccessStrategiesRequest) SetPageSize(v int32) *DescribeGtmAccessStrategiesRequest {
	s.PageSize = &v
	return s
}

type DescribeGtmAccessStrategiesResponseBody struct {
	// The number of the page returned.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 0CCC9971-CEC9-4132-824B-4AE611C07623
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The returned list of access policies of the GTM instance.
	Strategies *DescribeGtmAccessStrategiesResponseBodyStrategies `json:"Strategies,omitempty" xml:"Strategies,omitempty" type:"Struct"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 1
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeGtmAccessStrategiesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesResponseBody) SetPageNumber(v int32) *DescribeGtmAccessStrategiesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBody) SetPageSize(v int32) *DescribeGtmAccessStrategiesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBody) SetRequestId(v string) *DescribeGtmAccessStrategiesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBody) SetStrategies(v *DescribeGtmAccessStrategiesResponseBodyStrategies) *DescribeGtmAccessStrategiesResponseBody {
	s.Strategies = v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBody) SetTotalItems(v int32) *DescribeGtmAccessStrategiesResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBody) SetTotalPages(v int32) *DescribeGtmAccessStrategiesResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeGtmAccessStrategiesResponseBodyStrategies struct {
	Strategy []*DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy `json:"Strategy,omitempty" xml:"Strategy,omitempty" type:"Repeated"`
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategies) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategies) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategies) SetStrategy(v []*DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) *DescribeGtmAccessStrategiesResponseBodyStrategies {
	s.Strategy = v
	return s
}

type DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy struct {
	// The access policy. Valid values:
	//
	// 	- **AUTO**: Automatic switch
	//
	// 	- **DEFAULT**: Default address pool
	//
	// 	- **FAILOVER**: Failover address pool
	//
	// example:
	//
	// DEFAULT
	AccessMode *string `json:"AccessMode,omitempty" xml:"AccessMode,omitempty"`
	// The access status. Valid values:
	//
	// 	- **DEFAULT**: The default address pool is currently accessed.
	//
	// 	- **FAILOVER**: The failover address pool is currently accessed.
	//
	// example:
	//
	// DEFAULT
	AccessStatus *string `json:"AccessStatus,omitempty" xml:"AccessStatus,omitempty"`
	// The time when the access policy was created.
	//
	// example:
	//
	// 2018-08-09T00:10Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// example:
	//
	// 1533773400000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The ID of the default address pool.
	//
	// example:
	//
	// hra0i1
	DefaultAddrPoolId *string `json:"DefaultAddrPoolId,omitempty" xml:"DefaultAddrPoolId,omitempty"`
	// Indicates whether health check was enabled for the default address pool. Valid values:
	//
	// 	- **OPEN**: Enabled
	//
	// 	- **CLOSE**: Disabled
	//
	// 	- **UNCONFIGURED**: Not configured
	//
	// example:
	//
	// OPEN
	DefaultAddrPoolMonitorStatus *string `json:"DefaultAddrPoolMonitorStatus,omitempty" xml:"DefaultAddrPoolMonitorStatus,omitempty"`
	// The name of the default address pool.
	DefaultAddrPoolName *string `json:"DefaultAddrPoolName,omitempty" xml:"DefaultAddrPoolName,omitempty"`
	// The availability status of the default address pool. Valid values:
	//
	// 	- **AVAILABLE**: Available
	//
	// 	- **NOT_AVAILABLE**: Unavailable
	//
	// example:
	//
	// AVAILABLE
	DefaultAddrPoolStatus *string `json:"DefaultAddrPoolStatus,omitempty" xml:"DefaultAddrPoolStatus,omitempty"`
	// The ID of the failover address pool.
	//
	// example:
	//
	// hra0i2
	FailoverAddrPoolId *string `json:"FailoverAddrPoolId,omitempty" xml:"FailoverAddrPoolId,omitempty"`
	// Indicates whether health check was enabled for the failover address pool.
	//
	// example:
	//
	// OPEN
	FailoverAddrPoolMonitorStatus *string `json:"FailoverAddrPoolMonitorStatus,omitempty" xml:"FailoverAddrPoolMonitorStatus,omitempty"`
	// The name of the failover address pool.
	FailoverAddrPoolName *string `json:"FailoverAddrPoolName,omitempty" xml:"FailoverAddrPoolName,omitempty"`
	// The availability status of the failover address pool.
	//
	// example:
	//
	// AVAILABLE
	FailoverAddrPoolStatus *string `json:"FailoverAddrPoolStatus,omitempty" xml:"FailoverAddrPoolStatus,omitempty"`
	// The ID of the GTM instance whose access policies you want to query.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The returned lines of access regions.
	Lines *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines `json:"Lines,omitempty" xml:"Lines,omitempty" type:"Struct"`
	// The ID of the access policy.
	//
	// example:
	//
	// hra0hs
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
	// The mode of the access policy. **SELF_DEFINED*	- indicates that the access policy is user-defined.
	//
	// example:
	//
	// SELF_DEFINED
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
	// The name of the access policy.
	StrategyName *string `json:"StrategyName,omitempty" xml:"StrategyName,omitempty"`
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetAccessMode(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.AccessMode = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetAccessStatus(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.AccessStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetCreateTime(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetCreateTimestamp(v int64) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetDefaultAddrPoolId(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.DefaultAddrPoolId = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetDefaultAddrPoolMonitorStatus(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.DefaultAddrPoolMonitorStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetDefaultAddrPoolName(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.DefaultAddrPoolName = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetDefaultAddrPoolStatus(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.DefaultAddrPoolStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetFailoverAddrPoolId(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.FailoverAddrPoolId = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetFailoverAddrPoolMonitorStatus(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.FailoverAddrPoolMonitorStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetFailoverAddrPoolName(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.FailoverAddrPoolName = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetFailoverAddrPoolStatus(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.FailoverAddrPoolStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetInstanceId(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetLines(v *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.Lines = v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetStrategyId(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.StrategyId = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetStrategyMode(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.StrategyMode = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy) SetStrategyName(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy {
	s.StrategyName = &v
	return s
}

type DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines struct {
	Line []*DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine `json:"Line,omitempty" xml:"Line,omitempty" type:"Repeated"`
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines) SetLine(v []*DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines {
	s.Line = v
	return s
}

type DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine struct {
	// The code of the access region group.
	//
	// example:
	//
	// DEFAULT
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the access region group.
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The code for the line of the access region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The name for the line of the access region.
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetGroupCode(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.GroupCode = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetGroupName(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.GroupName = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetLineCode(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.LineCode = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine) SetLineName(v string) *DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine {
	s.LineName = &v
	return s
}

type DescribeGtmAccessStrategiesResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmAccessStrategiesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmAccessStrategiesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategiesResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategiesResponse) SetHeaders(v map[string]*string) *DescribeGtmAccessStrategiesResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmAccessStrategiesResponse) SetStatusCode(v int32) *DescribeGtmAccessStrategiesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmAccessStrategiesResponse) SetBody(v *DescribeGtmAccessStrategiesResponseBody) *DescribeGtmAccessStrategiesResponse {
	s.Body = v
	return s
}

type DescribeGtmAccessStrategyRequest struct {
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the access policy that you want to query.
	//
	// This parameter is required.
	//
	// example:
	//
	// hra0hs
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
}

func (s DescribeGtmAccessStrategyRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyRequest) SetLang(v string) *DescribeGtmAccessStrategyRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmAccessStrategyRequest) SetStrategyId(v string) *DescribeGtmAccessStrategyRequest {
	s.StrategyId = &v
	return s
}

type DescribeGtmAccessStrategyResponseBody struct {
	// The access policy.
	//
	// example:
	//
	// AUTO
	AccessMode *string `json:"AccessMode,omitempty" xml:"AccessMode,omitempty"`
	// The access status. Valid values:
	//
	// 	- **DEFAULT**: Indicates normal when the default address pool is accessed.
	//
	// 	- **FAILOVER**: Indicates an exception when a failover address pool is accessed.
	//
	// example:
	//
	// DEFAULT
	AccessStatus *string `json:"AccessStatus,omitempty" xml:"AccessStatus,omitempty"`
	// Indicates whether health check is enabled for the default address pool.
	//
	// example:
	//
	// OPEN
	DefaultAddrPoolMonitorStatus *string `json:"DefaultAddrPoolMonitorStatus,omitempty" xml:"DefaultAddrPoolMonitorStatus,omitempty"`
	// The name of the default address pool.
	DefaultAddrPoolName *string `json:"DefaultAddrPoolName,omitempty" xml:"DefaultAddrPoolName,omitempty"`
	// The availability status of the default address pool.
	//
	// example:
	//
	// AVAILABLE
	DefaultAddrPoolStatus *string `json:"DefaultAddrPoolStatus,omitempty" xml:"DefaultAddrPoolStatus,omitempty"`
	// The ID of the default address pool.
	//
	// example:
	//
	// hra0i1
	DefultAddrPoolId *string `json:"DefultAddrPoolId,omitempty" xml:"DefultAddrPoolId,omitempty"`
	// The ID of the failover address pool.
	//
	// example:
	//
	// hra0i2
	FailoverAddrPoolId *string `json:"FailoverAddrPoolId,omitempty" xml:"FailoverAddrPoolId,omitempty"`
	// Indicates whether health check is enabled for the failover address pool.
	//
	// example:
	//
	// OPEN
	FailoverAddrPoolMonitorStatus *string `json:"FailoverAddrPoolMonitorStatus,omitempty" xml:"FailoverAddrPoolMonitorStatus,omitempty"`
	// The name of the failover address pool.
	FailoverAddrPoolName *string `json:"FailoverAddrPoolName,omitempty" xml:"FailoverAddrPoolName,omitempty"`
	// The availability status of the failover address pool.
	//
	// example:
	//
	// AVAILABLE
	FailoverAddrPoolStatus *string `json:"FailoverAddrPoolStatus,omitempty" xml:"FailoverAddrPoolStatus,omitempty"`
	// The ID of the GTM instance whose access policy details you want to query.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The returned lines of access regions.
	Lines *DescribeGtmAccessStrategyResponseBodyLines `json:"Lines,omitempty" xml:"Lines,omitempty" type:"Struct"`
	// The ID of the request.
	//
	// example:
	//
	// BA1608CA-834C-4E63-8682-8AF0B11ED72D
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the access policy queried.
	//
	// example:
	//
	// hra0hs
	StrategyId *string `json:"StrategyId,omitempty" xml:"StrategyId,omitempty"`
	// The mode of traffic scheduling.
	//
	// example:
	//
	// SELF_DEFINED
	StrategyMode *string `json:"StrategyMode,omitempty" xml:"StrategyMode,omitempty"`
	// The name of the access policy queried.
	StrategyName *string `json:"StrategyName,omitempty" xml:"StrategyName,omitempty"`
}

func (s DescribeGtmAccessStrategyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyResponseBody) SetAccessMode(v string) *DescribeGtmAccessStrategyResponseBody {
	s.AccessMode = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetAccessStatus(v string) *DescribeGtmAccessStrategyResponseBody {
	s.AccessStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetDefaultAddrPoolMonitorStatus(v string) *DescribeGtmAccessStrategyResponseBody {
	s.DefaultAddrPoolMonitorStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetDefaultAddrPoolName(v string) *DescribeGtmAccessStrategyResponseBody {
	s.DefaultAddrPoolName = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetDefaultAddrPoolStatus(v string) *DescribeGtmAccessStrategyResponseBody {
	s.DefaultAddrPoolStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetDefultAddrPoolId(v string) *DescribeGtmAccessStrategyResponseBody {
	s.DefultAddrPoolId = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetFailoverAddrPoolId(v string) *DescribeGtmAccessStrategyResponseBody {
	s.FailoverAddrPoolId = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetFailoverAddrPoolMonitorStatus(v string) *DescribeGtmAccessStrategyResponseBody {
	s.FailoverAddrPoolMonitorStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetFailoverAddrPoolName(v string) *DescribeGtmAccessStrategyResponseBody {
	s.FailoverAddrPoolName = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetFailoverAddrPoolStatus(v string) *DescribeGtmAccessStrategyResponseBody {
	s.FailoverAddrPoolStatus = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetInstanceId(v string) *DescribeGtmAccessStrategyResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetLines(v *DescribeGtmAccessStrategyResponseBodyLines) *DescribeGtmAccessStrategyResponseBody {
	s.Lines = v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetRequestId(v string) *DescribeGtmAccessStrategyResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetStrategyId(v string) *DescribeGtmAccessStrategyResponseBody {
	s.StrategyId = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetStrategyMode(v string) *DescribeGtmAccessStrategyResponseBody {
	s.StrategyMode = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBody) SetStrategyName(v string) *DescribeGtmAccessStrategyResponseBody {
	s.StrategyName = &v
	return s
}

type DescribeGtmAccessStrategyResponseBodyLines struct {
	Line []*DescribeGtmAccessStrategyResponseBodyLinesLine `json:"Line,omitempty" xml:"Line,omitempty" type:"Repeated"`
}

func (s DescribeGtmAccessStrategyResponseBodyLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyResponseBodyLines) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyResponseBodyLines) SetLine(v []*DescribeGtmAccessStrategyResponseBodyLinesLine) *DescribeGtmAccessStrategyResponseBodyLines {
	s.Line = v
	return s
}

type DescribeGtmAccessStrategyResponseBodyLinesLine struct {
	// The code of the access region group.
	//
	// example:
	//
	// DEFAULT
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The name of the access region group.
	//
	// example:
	//
	// Global
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The code for the line of the access region.
	//
	// example:
	//
	// default
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The name for the line of the access region.
	//
	// example:
	//
	// Global
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
}

func (s DescribeGtmAccessStrategyResponseBodyLinesLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyResponseBodyLinesLine) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyResponseBodyLinesLine) SetGroupCode(v string) *DescribeGtmAccessStrategyResponseBodyLinesLine {
	s.GroupCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBodyLinesLine) SetGroupName(v string) *DescribeGtmAccessStrategyResponseBodyLinesLine {
	s.GroupName = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBodyLinesLine) SetLineCode(v string) *DescribeGtmAccessStrategyResponseBodyLinesLine {
	s.LineCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponseBodyLinesLine) SetLineName(v string) *DescribeGtmAccessStrategyResponseBodyLinesLine {
	s.LineName = &v
	return s
}

type DescribeGtmAccessStrategyResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmAccessStrategyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmAccessStrategyResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyResponse) SetHeaders(v map[string]*string) *DescribeGtmAccessStrategyResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmAccessStrategyResponse) SetStatusCode(v int32) *DescribeGtmAccessStrategyResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyResponse) SetBody(v *DescribeGtmAccessStrategyResponseBody) *DescribeGtmAccessStrategyResponse {
	s.Body = v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigRequest struct {
	// The ID of the Global Traffic Manager (GTM) instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// gtm-cn-xxxx
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmAccessStrategyAvailableConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigRequest) SetInstanceId(v string) *DescribeGtmAccessStrategyAvailableConfigRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigRequest) SetLang(v string) *DescribeGtmAccessStrategyAvailableConfigRequest {
	s.Lang = &v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigResponseBody struct {
	// The address pools.
	AddrPools *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools `json:"AddrPools,omitempty" xml:"AddrPools,omitempty" type:"Struct"`
	// The Domain Name System (DNS) request sources.
	Lines *DescribeGtmAccessStrategyAvailableConfigResponseBodyLines `json:"Lines,omitempty" xml:"Lines,omitempty" type:"Struct"`
	// The request ID.
	//
	// example:
	//
	// C2851BA9-CE56-49AF-8D12-4FC6A49EE688
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Indicates whether the global line is recommended.
	//
	// example:
	//
	// True
	SuggestSetDefaultLine *bool `json:"SuggestSetDefaultLine,omitempty" xml:"SuggestSetDefaultLine,omitempty"`
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBody) SetAddrPools(v *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools) *DescribeGtmAccessStrategyAvailableConfigResponseBody {
	s.AddrPools = v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBody) SetLines(v *DescribeGtmAccessStrategyAvailableConfigResponseBodyLines) *DescribeGtmAccessStrategyAvailableConfigResponseBody {
	s.Lines = v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBody) SetRequestId(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBody) SetSuggestSetDefaultLine(v bool) *DescribeGtmAccessStrategyAvailableConfigResponseBody {
	s.SuggestSetDefaultLine = &v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools struct {
	AddrPool []*DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool `json:"AddrPool,omitempty" xml:"AddrPool,omitempty" type:"Repeated"`
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools) SetAddrPool(v []*DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool) *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools {
	s.AddrPool = v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool struct {
	// The ID of the address pool.
	//
	// example:
	//
	// hra0ix
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// test
	AddrPoolName *string `json:"AddrPoolName,omitempty" xml:"AddrPoolName,omitempty"`
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool) SetAddrPoolId(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool) SetAddrPoolName(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool {
	s.AddrPoolName = &v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigResponseBodyLines struct {
	Line []*DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine `json:"Line,omitempty" xml:"Line,omitempty" type:"Repeated"`
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyLines) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyLines) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLines) SetLine(v []*DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLines {
	s.Line = v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine struct {
	// The code of the parent line. No value is returned if no parent line exists.
	//
	// example:
	//
	// telecom
	FatherCode *string `json:"FatherCode,omitempty" xml:"FatherCode,omitempty"`
	// The group number of the DNS request source.
	//
	// example:
	//
	// ISP
	GroupCode *string `json:"GroupCode,omitempty" xml:"GroupCode,omitempty"`
	// The group name of the DNS request source.
	//
	// example:
	//
	// Mainland China
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The code of the DNS request source.
	//
	// example:
	//
	// cn_telecom_hubei
	LineCode *string `json:"LineCode,omitempty" xml:"LineCode,omitempty"`
	// The name of the DNS request source.
	//
	// example:
	//
	// South China
	LineName *string `json:"LineName,omitempty" xml:"LineName,omitempty"`
	// The state of the line. Valid values:
	//
	// 	- **FORBIDDEN**: The line is unavailable.
	//
	// 	- **OPTIONAL**: The line is available.
	//
	// example:
	//
	// FORBIDDEN
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetFatherCode(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.FatherCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetGroupCode(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.GroupCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetGroupName(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.GroupName = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetLineCode(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.LineCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetLineName(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.LineName = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine) SetStatus(v string) *DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine {
	s.Status = &v
	return s
}

type DescribeGtmAccessStrategyAvailableConfigResponse struct {
	Headers    map[string]*string                                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmAccessStrategyAvailableConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmAccessStrategyAvailableConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAccessStrategyAvailableConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponse) SetHeaders(v map[string]*string) *DescribeGtmAccessStrategyAvailableConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponse) SetStatusCode(v int32) *DescribeGtmAccessStrategyAvailableConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmAccessStrategyAvailableConfigResponse) SetBody(v *DescribeGtmAccessStrategyAvailableConfigResponseBody) *DescribeGtmAccessStrategyAvailableConfigResponse {
	s.Body = v
	return s
}

type DescribeGtmAvailableAlertGroupRequest struct {
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmAvailableAlertGroupRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAvailableAlertGroupRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmAvailableAlertGroupRequest) SetLang(v string) *DescribeGtmAvailableAlertGroupRequest {
	s.Lang = &v
	return s
}

type DescribeGtmAvailableAlertGroupResponseBody struct {
	// The available alert groups of the GTM instance.
	AvailableAlertGroup *string `json:"AvailableAlertGroup,omitempty" xml:"AvailableAlertGroup,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 29D0F8F8-5499-4F6C-9FDC-1EE13BF55925
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeGtmAvailableAlertGroupResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAvailableAlertGroupResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmAvailableAlertGroupResponseBody) SetAvailableAlertGroup(v string) *DescribeGtmAvailableAlertGroupResponseBody {
	s.AvailableAlertGroup = &v
	return s
}

func (s *DescribeGtmAvailableAlertGroupResponseBody) SetRequestId(v string) *DescribeGtmAvailableAlertGroupResponseBody {
	s.RequestId = &v
	return s
}

type DescribeGtmAvailableAlertGroupResponse struct {
	Headers    map[string]*string                          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmAvailableAlertGroupResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmAvailableAlertGroupResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmAvailableAlertGroupResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmAvailableAlertGroupResponse) SetHeaders(v map[string]*string) *DescribeGtmAvailableAlertGroupResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmAvailableAlertGroupResponse) SetStatusCode(v int32) *DescribeGtmAvailableAlertGroupResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmAvailableAlertGroupResponse) SetBody(v *DescribeGtmAvailableAlertGroupResponseBody) *DescribeGtmAvailableAlertGroupResponse {
	s.Body = v
	return s
}

type DescribeGtmInstanceRequest struct {
	// The ID of the GTM instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language of the values of specific response parameters.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// Specifies whether additional information is required. Default value: **false**. If the value is **true**, the AccessStrategyNum and AddressPoolNum parameters are returned.
	//
	// example:
	//
	// false
	NeedDetailAttributes *bool `json:"NeedDetailAttributes,omitempty" xml:"NeedDetailAttributes,omitempty"`
}

func (s DescribeGtmInstanceRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceRequest) SetInstanceId(v string) *DescribeGtmInstanceRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmInstanceRequest) SetLang(v string) *DescribeGtmInstanceRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmInstanceRequest) SetNeedDetailAttributes(v bool) *DescribeGtmInstanceRequest {
	s.NeedDetailAttributes = &v
	return s
}

type DescribeGtmInstanceResponseBody struct {
	// The number of access policies of the GTM instance.
	//
	// example:
	//
	// 5
	AccessStrategyNum *int32 `json:"AccessStrategyNum,omitempty" xml:"AccessStrategyNum,omitempty"`
	// The number of address pools of the GTM instance.
	//
	// example:
	//
	// 5
	AddressPoolNum *int32 `json:"AddressPoolNum,omitempty" xml:"AddressPoolNum,omitempty"`
	// The alert group of the GTM instance.
	//
	// example:
	//
	// [\\\\"Daily test - R\\&D group\\\\"]
	AlertGroup *string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty"`
	// The domain name of the GTM instance to which the service domain name is mapped by using a CNAME record.
	//
	// example:
	//
	// instance1.14.com
	Cname *string `json:"Cname,omitempty" xml:"Cname,omitempty"`
	// Indicates whether the CNAME is a custom domain name or is assigned by the system. Valid values:
	//
	// 	- **SYSTEM_ASSIGN**
	//
	// 	- **CUSTOM**
	//
	// example:
	//
	// SYSTEM_ASSIGN
	CnameMode *string `json:"CnameMode,omitempty" xml:"CnameMode,omitempty"`
	// The time when the GTM instance was created.
	//
	// example:
	//
	// 2018-06-06T11:34Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates the time when the GTM instance was created.
	//
	// example:
	//
	// 1528284856000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The time when the GTM instance expires.
	//
	// example:
	//
	// 2018-06-06T11:34Z
	ExpireTime *string `json:"ExpireTime,omitempty" xml:"ExpireTime,omitempty"`
	// The timestamp that indicates the time when the GTM instance expires.
	//
	// example:
	//
	// 1528284856000
	ExpireTimestamp *int64 `json:"ExpireTimestamp,omitempty" xml:"ExpireTimestamp,omitempty"`
	// The ID of the GTM instance.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The name of the GTM instance.
	//
	// example:
	//
	// test
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// The load balancing policy. Valid values:
	//
	// 	- **ALL_RR**: round robin
	//
	// 	- **RATIO**: weighted round-robin
	//
	// example:
	//
	// RATIO
	LbaStrategy *string `json:"LbaStrategy,omitempty" xml:"LbaStrategy,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// E41AA251-F9BA-48C6-99B2-2B82B26A573A
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The ID of the resource group.
	//
	// example:
	//
	// rg-testgroupid
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	// The global time to live (TTL).
	//
	// example:
	//
	// 60
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	// The domain name of the application.
	//
	// example:
	//
	// www.example.com
	UserDomainName *string `json:"UserDomainName,omitempty" xml:"UserDomainName,omitempty"`
	// The version code.
	//
	// example:
	//
	// biaozhun
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeGtmInstanceResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceResponseBody) SetAccessStrategyNum(v int32) *DescribeGtmInstanceResponseBody {
	s.AccessStrategyNum = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetAddressPoolNum(v int32) *DescribeGtmInstanceResponseBody {
	s.AddressPoolNum = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetAlertGroup(v string) *DescribeGtmInstanceResponseBody {
	s.AlertGroup = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetCname(v string) *DescribeGtmInstanceResponseBody {
	s.Cname = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetCnameMode(v string) *DescribeGtmInstanceResponseBody {
	s.CnameMode = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetCreateTime(v string) *DescribeGtmInstanceResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetCreateTimestamp(v int64) *DescribeGtmInstanceResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetExpireTime(v string) *DescribeGtmInstanceResponseBody {
	s.ExpireTime = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetExpireTimestamp(v int64) *DescribeGtmInstanceResponseBody {
	s.ExpireTimestamp = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetInstanceId(v string) *DescribeGtmInstanceResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetInstanceName(v string) *DescribeGtmInstanceResponseBody {
	s.InstanceName = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetLbaStrategy(v string) *DescribeGtmInstanceResponseBody {
	s.LbaStrategy = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetRequestId(v string) *DescribeGtmInstanceResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetResourceGroupId(v string) *DescribeGtmInstanceResponseBody {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetTtl(v int32) *DescribeGtmInstanceResponseBody {
	s.Ttl = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetUserDomainName(v string) *DescribeGtmInstanceResponseBody {
	s.UserDomainName = &v
	return s
}

func (s *DescribeGtmInstanceResponseBody) SetVersionCode(v string) *DescribeGtmInstanceResponseBody {
	s.VersionCode = &v
	return s
}

type DescribeGtmInstanceResponse struct {
	Headers    map[string]*string               `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                           `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmInstanceResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmInstanceResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceResponse) SetHeaders(v map[string]*string) *DescribeGtmInstanceResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmInstanceResponse) SetStatusCode(v int32) *DescribeGtmInstanceResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmInstanceResponse) SetBody(v *DescribeGtmInstanceResponseBody) *DescribeGtmInstanceResponse {
	s.Body = v
	return s
}

type DescribeGtmInstanceAddressPoolRequest struct {
	// The ID of the address pool that you want to query.
	//
	// This parameter is required.
	//
	// example:
	//
	// 1234
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolRequest) SetAddrPoolId(v string) *DescribeGtmInstanceAddressPoolRequest {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolRequest) SetLang(v string) *DescribeGtmInstanceAddressPoolRequest {
	s.Lang = &v
	return s
}

type DescribeGtmInstanceAddressPoolResponseBody struct {
	// The number of addresses in the address pool queried.
	//
	// example:
	//
	// 2
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// 1234abc
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The addresses in the address pool.
	Addrs *DescribeGtmInstanceAddressPoolResponseBodyAddrs `json:"Addrs,omitempty" xml:"Addrs,omitempty" type:"Struct"`
	// The time when the address pool was created.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The minimum number of available addresses in the address pool.
	//
	// example:
	//
	// 2
	MinAvailableAddrNum *int32 `json:"MinAvailableAddrNum,omitempty" xml:"MinAvailableAddrNum,omitempty"`
	// The health check ID of the address pool.
	//
	// example:
	//
	// 100abc
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// Indicates whether health check was enabled for the address pool. Valid values:
	//
	// 	- **OPEN**: Enabled
	//
	// 	- **CLOSE**: Disabled
	//
	// 	- **UNCONFIGURED**: Not configured
	//
	// example:
	//
	// OPEN
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The name of the address pool.
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The availability status of the address pool. Valid values:
	//
	// 	- **AVAILABLE**: Available
	//
	// 	- **NOT_AVAILABLE**: Unavailable
	//
	// example:
	//
	// AVAILABLE
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- **IP**: IP address
	//
	// 	- **DOMAIN**: Domain name
	//
	// example:
	//
	// IP
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The last time when the address pool was updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// A timestamp that indicates the last time the address pool was updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetAddrCount(v int32) *DescribeGtmInstanceAddressPoolResponseBody {
	s.AddrCount = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetAddrPoolId(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetAddrs(v *DescribeGtmInstanceAddressPoolResponseBodyAddrs) *DescribeGtmInstanceAddressPoolResponseBody {
	s.Addrs = v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetCreateTime(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetCreateTimestamp(v int64) *DescribeGtmInstanceAddressPoolResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetMinAvailableAddrNum(v int32) *DescribeGtmInstanceAddressPoolResponseBody {
	s.MinAvailableAddrNum = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetMonitorConfigId(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetMonitorStatus(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.MonitorStatus = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetName(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetRequestId(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetStatus(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.Status = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetType(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.Type = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetUpdateTime(v string) *DescribeGtmInstanceAddressPoolResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBody) SetUpdateTimestamp(v int64) *DescribeGtmInstanceAddressPoolResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeGtmInstanceAddressPoolResponseBodyAddrs struct {
	Addr []*DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Repeated"`
}

func (s DescribeGtmInstanceAddressPoolResponseBodyAddrs) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolResponseBodyAddrs) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrs) SetAddr(v []*DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) *DescribeGtmInstanceAddressPoolResponseBodyAddrs {
	s.Addr = v
	return s
}

type DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr struct {
	// The ID of the address.
	//
	// example:
	//
	// 123
	AddrId *int64 `json:"AddrId,omitempty" xml:"AddrId,omitempty"`
	// Indicates whether health check was enabled for the address. Valid values:
	//
	// 	- **OK**: Normal
	//
	// 	- **ALERT**: Alert
	//
	// example:
	//
	// OK
	AlertStatus *string `json:"AlertStatus,omitempty" xml:"AlertStatus,omitempty"`
	// The time when the address pool was created.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The weight of the address.
	//
	// example:
	//
	// 1
	LbaWeight *int32 `json:"LbaWeight,omitempty" xml:"LbaWeight,omitempty"`
	// The mode of the address. Valid values:
	//
	// 	- **SMART**: Intelligent return
	//
	// 	- **ONLINE**: Always online
	//
	// 	- **OFFLINE**: Always offline
	//
	// example:
	//
	// SMART
	Mode *string `json:"Mode,omitempty" xml:"Mode,omitempty"`
	// The last time when the address was updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// A timestamp that indicates the last time when the address was updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
	// The address.
	//
	// example:
	//
	// 1.1.1.1
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetAddrId(v int64) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.AddrId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetAlertStatus(v string) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.AlertStatus = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetCreateTime(v string) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetCreateTimestamp(v int64) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetLbaWeight(v int32) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.LbaWeight = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetMode(v string) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.Mode = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetUpdateTime(v string) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.UpdateTime = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetUpdateTimestamp(v int64) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.UpdateTimestamp = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr) SetValue(v string) *DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr {
	s.Value = &v
	return s
}

type DescribeGtmInstanceAddressPoolResponse struct {
	Headers    map[string]*string                          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmInstanceAddressPoolResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolResponse) SetHeaders(v map[string]*string) *DescribeGtmInstanceAddressPoolResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponse) SetStatusCode(v int32) *DescribeGtmInstanceAddressPoolResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolResponse) SetBody(v *DescribeGtmInstanceAddressPoolResponseBody) *DescribeGtmInstanceAddressPoolResponse {
	s.Body = v
	return s
}

type DescribeGtmInstanceAddressPoolsRequest struct {
	// The ID of the GTM instance that you want to query.
	//
	// This parameter is required.
	//
	// example:
	//
	// gtmtest
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return per page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolsRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolsRequest) SetInstanceId(v string) *DescribeGtmInstanceAddressPoolsRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsRequest) SetLang(v string) *DescribeGtmInstanceAddressPoolsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsRequest) SetPageNumber(v int32) *DescribeGtmInstanceAddressPoolsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsRequest) SetPageSize(v int32) *DescribeGtmInstanceAddressPoolsRequest {
	s.PageSize = &v
	return s
}

type DescribeGtmInstanceAddressPoolsResponseBody struct {
	// The returned list of address pools of the GTM instance.
	AddrPools *DescribeGtmInstanceAddressPoolsResponseBodyAddrPools `json:"AddrPools,omitempty" xml:"AddrPools,omitempty" type:"Struct"`
	// The number of the page returned.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 2
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolsResponseBody) SetAddrPools(v *DescribeGtmInstanceAddressPoolsResponseBodyAddrPools) *DescribeGtmInstanceAddressPoolsResponseBody {
	s.AddrPools = v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBody) SetPageNumber(v int32) *DescribeGtmInstanceAddressPoolsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBody) SetPageSize(v int32) *DescribeGtmInstanceAddressPoolsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBody) SetRequestId(v string) *DescribeGtmInstanceAddressPoolsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBody) SetTotalItems(v int32) *DescribeGtmInstanceAddressPoolsResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBody) SetTotalPages(v int32) *DescribeGtmInstanceAddressPoolsResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeGtmInstanceAddressPoolsResponseBodyAddrPools struct {
	AddrPool []*DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool `json:"AddrPool,omitempty" xml:"AddrPool,omitempty" type:"Repeated"`
}

func (s DescribeGtmInstanceAddressPoolsResponseBodyAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolsResponseBodyAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPools) SetAddrPool(v []*DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPools {
	s.AddrPool = v
	return s
}

type DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool struct {
	// The number of addresses in the address pool.
	//
	// example:
	//
	// 2
	AddrCount *int32 `json:"AddrCount,omitempty" xml:"AddrCount,omitempty"`
	// The ID of the address pool.
	//
	// example:
	//
	// 1234abc
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The time when this address pool was created.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The minimum number of available addresses in the address pool.
	//
	// example:
	//
	// 2
	MinAvailableAddrNum *int32 `json:"MinAvailableAddrNum,omitempty" xml:"MinAvailableAddrNum,omitempty"`
	// The health check ID of the address pool.
	//
	// example:
	//
	// 100abc
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// Indicates whether health check was enabled for the address pool. Valid values:
	//
	// 	- **OPEN**: Enabled
	//
	// 	- **CLOSE**: Disabled
	//
	// 	- **UNCONFIGURED**: Not configured
	//
	// example:
	//
	// OPEN
	MonitorStatus *string `json:"MonitorStatus,omitempty" xml:"MonitorStatus,omitempty"`
	// The name of the address pool.
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The availability status of the address pool. Valid values:
	//
	// 	- **AVAILABLE**: Available
	//
	// 	- **NOT_AVAILABLE**: Unavailable
	//
	// example:
	//
	// AVAILABLE
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The type of the address pool. Valid values:
	//
	// 	- **IP**: IP address
	//
	// 	- **DOMAIN**: Domain name
	//
	// example:
	//
	// IP
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
	// The last time when the address pool was updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// A timestamp that indicates the last time the address pool was updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetAddrCount(v int32) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.AddrCount = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetAddrPoolId(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetCreateTime(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetCreateTimestamp(v int64) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetMinAvailableAddrNum(v int32) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.MinAvailableAddrNum = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetMonitorConfigId(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.MonitorConfigId = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetMonitorStatus(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.MonitorStatus = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetName(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.Name = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetStatus(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.Status = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetType(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.Type = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetUpdateTime(v string) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.UpdateTime = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool) SetUpdateTimestamp(v int64) *DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool {
	s.UpdateTimestamp = &v
	return s
}

type DescribeGtmInstanceAddressPoolsResponse struct {
	Headers    map[string]*string                           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmInstanceAddressPoolsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmInstanceAddressPoolsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceAddressPoolsResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceAddressPoolsResponse) SetHeaders(v map[string]*string) *DescribeGtmInstanceAddressPoolsResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponse) SetStatusCode(v int32) *DescribeGtmInstanceAddressPoolsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmInstanceAddressPoolsResponse) SetBody(v *DescribeGtmInstanceAddressPoolsResponseBody) *DescribeGtmInstanceAddressPoolsResponse {
	s.Body = v
	return s
}

type DescribeGtmInstanceStatusRequest struct {
	// The instance ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmInstanceStatusRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceStatusRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceStatusRequest) SetInstanceId(v string) *DescribeGtmInstanceStatusRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmInstanceStatusRequest) SetLang(v string) *DescribeGtmInstanceStatusRequest {
	s.Lang = &v
	return s
}

type DescribeGtmInstanceStatusResponseBody struct {
	// The number of unavailable addresses.
	//
	// example:
	//
	// 10
	AddrNotAvailableNum *int32 `json:"AddrNotAvailableNum,omitempty" xml:"AddrNotAvailableNum,omitempty"`
	// The number of unavailable address pools.
	//
	// example:
	//
	// 10
	AddrPoolNotAvailableNum *int32 `json:"AddrPoolNotAvailableNum,omitempty" xml:"AddrPoolNotAvailableNum,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 389DFFA3-77A5-4A9E-BF3D-147C6F98A5BA
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The state of the instance. Valid values:
	//
	// 	- ALLOW: The operation on the instance is allowed.
	//
	// 	- DENY: The operation on the instance is not allowed.
	//
	// example:
	//
	// ALLOW
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The reasons why the instance is in the current state. Valid values:
	//
	// 	- INSTANCE_OPERATE_BLACK_LIST: The operation on the instance is not allowed.
	//
	// 	- BETA_INSTANCE: The instance is in public preview.
	//
	// example:
	//
	// ["BETA_INSTANCE"]
	StatusReason *string `json:"StatusReason,omitempty" xml:"StatusReason,omitempty"`
	// The number of unavailable access policies.
	//
	// example:
	//
	// 10
	StrategyNotAvailableNum *int32 `json:"StrategyNotAvailableNum,omitempty" xml:"StrategyNotAvailableNum,omitempty"`
	// The number of access policies switched to the secondary address pool.
	//
	// example:
	//
	// 10
	SwitchToFailoverStrategyNum *int32 `json:"SwitchToFailoverStrategyNum,omitempty" xml:"SwitchToFailoverStrategyNum,omitempty"`
}

func (s DescribeGtmInstanceStatusResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceStatusResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceStatusResponseBody) SetAddrNotAvailableNum(v int32) *DescribeGtmInstanceStatusResponseBody {
	s.AddrNotAvailableNum = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponseBody) SetAddrPoolNotAvailableNum(v int32) *DescribeGtmInstanceStatusResponseBody {
	s.AddrPoolNotAvailableNum = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponseBody) SetRequestId(v string) *DescribeGtmInstanceStatusResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponseBody) SetStatus(v string) *DescribeGtmInstanceStatusResponseBody {
	s.Status = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponseBody) SetStatusReason(v string) *DescribeGtmInstanceStatusResponseBody {
	s.StatusReason = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponseBody) SetStrategyNotAvailableNum(v int32) *DescribeGtmInstanceStatusResponseBody {
	s.StrategyNotAvailableNum = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponseBody) SetSwitchToFailoverStrategyNum(v int32) *DescribeGtmInstanceStatusResponseBody {
	s.SwitchToFailoverStrategyNum = &v
	return s
}

type DescribeGtmInstanceStatusResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmInstanceStatusResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmInstanceStatusResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceStatusResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceStatusResponse) SetHeaders(v map[string]*string) *DescribeGtmInstanceStatusResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmInstanceStatusResponse) SetStatusCode(v int32) *DescribeGtmInstanceStatusResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmInstanceStatusResponse) SetBody(v *DescribeGtmInstanceStatusResponseBody) *DescribeGtmInstanceStatusResponse {
	s.Body = v
	return s
}

type DescribeGtmInstanceSystemCnameRequest struct {
	// The ID of the Global Traffic Manager (GTM) instance.
	//
	// This parameter is required.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmInstanceSystemCnameRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceSystemCnameRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceSystemCnameRequest) SetInstanceId(v string) *DescribeGtmInstanceSystemCnameRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmInstanceSystemCnameRequest) SetLang(v string) *DescribeGtmInstanceSystemCnameRequest {
	s.Lang = &v
	return s
}

type DescribeGtmInstanceSystemCnameResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The CNAME record assigned by the system.
	//
	// example:
	//
	// gtm-cn-mp91004xxxx.gtm-a2b4.com
	SystemCname *string `json:"SystemCname,omitempty" xml:"SystemCname,omitempty"`
}

func (s DescribeGtmInstanceSystemCnameResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceSystemCnameResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceSystemCnameResponseBody) SetRequestId(v string) *DescribeGtmInstanceSystemCnameResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmInstanceSystemCnameResponseBody) SetSystemCname(v string) *DescribeGtmInstanceSystemCnameResponseBody {
	s.SystemCname = &v
	return s
}

type DescribeGtmInstanceSystemCnameResponse struct {
	Headers    map[string]*string                          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmInstanceSystemCnameResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmInstanceSystemCnameResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstanceSystemCnameResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstanceSystemCnameResponse) SetHeaders(v map[string]*string) *DescribeGtmInstanceSystemCnameResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmInstanceSystemCnameResponse) SetStatusCode(v int32) *DescribeGtmInstanceSystemCnameResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmInstanceSystemCnameResponse) SetBody(v *DescribeGtmInstanceSystemCnameResponseBody) *DescribeGtmInstanceSystemCnameResponse {
	s.Body = v
	return s
}

type DescribeGtmInstancesRequest struct {
	// The keyword that you use for query. Exact match is supported by instance ID or instance name.
	//
	// example:
	//
	// test
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// Specifies whether additional information is required. Default value: **false**.
	//
	// example:
	//
	// false
	NeedDetailAttributes *bool `json:"NeedDetailAttributes,omitempty" xml:"NeedDetailAttributes,omitempty"`
	// The page number to return.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the resource group.
	//
	// example:
	//
	// rg-xxxxx
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
}

func (s DescribeGtmInstancesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstancesRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstancesRequest) SetKeyword(v string) *DescribeGtmInstancesRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeGtmInstancesRequest) SetLang(v string) *DescribeGtmInstancesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmInstancesRequest) SetNeedDetailAttributes(v bool) *DescribeGtmInstancesRequest {
	s.NeedDetailAttributes = &v
	return s
}

func (s *DescribeGtmInstancesRequest) SetPageNumber(v int32) *DescribeGtmInstancesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmInstancesRequest) SetPageSize(v int32) *DescribeGtmInstancesRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmInstancesRequest) SetResourceGroupId(v string) *DescribeGtmInstancesRequest {
	s.ResourceGroupId = &v
	return s
}

type DescribeGtmInstancesResponseBody struct {
	// The list of queried instances.
	GtmInstances *DescribeGtmInstancesResponseBodyGtmInstances `json:"GtmInstances,omitempty" xml:"GtmInstances,omitempty" type:"Struct"`
	// The returned page number.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 193B0163-7F93-42DF-AB05-ACEEB7D22707
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 1
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeGtmInstancesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstancesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstancesResponseBody) SetGtmInstances(v *DescribeGtmInstancesResponseBodyGtmInstances) *DescribeGtmInstancesResponseBody {
	s.GtmInstances = v
	return s
}

func (s *DescribeGtmInstancesResponseBody) SetPageNumber(v int32) *DescribeGtmInstancesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmInstancesResponseBody) SetPageSize(v int32) *DescribeGtmInstancesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmInstancesResponseBody) SetRequestId(v string) *DescribeGtmInstancesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmInstancesResponseBody) SetTotalItems(v int32) *DescribeGtmInstancesResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeGtmInstancesResponseBody) SetTotalPages(v int32) *DescribeGtmInstancesResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeGtmInstancesResponseBodyGtmInstances struct {
	GtmInstance []*DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance `json:"GtmInstance,omitempty" xml:"GtmInstance,omitempty" type:"Repeated"`
}

func (s DescribeGtmInstancesResponseBodyGtmInstances) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstancesResponseBodyGtmInstances) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstancesResponseBodyGtmInstances) SetGtmInstance(v []*DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) *DescribeGtmInstancesResponseBodyGtmInstances {
	s.GtmInstance = v
	return s
}

type DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance struct {
	// The number of access policies.
	//
	// example:
	//
	// 5
	AccessStrategyNum *int32 `json:"AccessStrategyNum,omitempty" xml:"AccessStrategyNum,omitempty"`
	// The number of address pools.
	//
	// example:
	//
	// 5
	AddressPoolNum *int32 `json:"AddressPoolNum,omitempty" xml:"AddressPoolNum,omitempty"`
	// The name of the alert group.
	//
	// example:
	//
	// [\\\\"R\\&D group\\\\"]
	AlertGroup *string `json:"AlertGroup,omitempty" xml:"AlertGroup,omitempty"`
	// The CNAME domain name that is used to access the instance.
	//
	// example:
	//
	// instance1.14.com
	Cname *string `json:"Cname,omitempty" xml:"Cname,omitempty"`
	// The CNAME domain name used to access the instance. Valid values:
	//
	// 	- **SYSTEM_ASSIGN**: A CNAME domain name assigned by the system is used.
	//
	// 	- **CUSTOM**: A custom CNAME domain name is used.
	//
	// example:
	//
	// SYSTEM_ASSIGN
	CnameMode *string `json:"CnameMode,omitempty" xml:"CnameMode,omitempty"`
	// The time when the instance was created.
	//
	// example:
	//
	// 2018-06-06T11:34Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The UNIX timestamp that indicates when the instance was created.
	//
	// example:
	//
	// 1528284856000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The time when the instance expires.
	//
	// example:
	//
	// 2018-06-06T11:34Z
	ExpireTime *string `json:"ExpireTime,omitempty" xml:"ExpireTime,omitempty"`
	// The UNIX timestamp that indicates when the instance expires.
	//
	// example:
	//
	// 1528284856000
	ExpireTimestamp *int64 `json:"ExpireTimestamp,omitempty" xml:"ExpireTimestamp,omitempty"`
	// The ID of the instance.
	//
	// example:
	//
	// instance1
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The name of the instance.
	//
	// example:
	//
	// test
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	// The load balancing policy that is used. Valid values:
	//
	// 	- **ALL_RR**: Load balancing
	//
	// 	- **RATIO**: Weighted round-robin
	//
	// example:
	//
	// RATIO
	LbaStrategy *string `json:"LbaStrategy,omitempty" xml:"LbaStrategy,omitempty"`
	// The ID of the resource group to which the instance belongs.
	//
	// example:
	//
	// rg-acfm2q2jqpjh***
	ResourceGroupId *string `json:"ResourceGroupId,omitempty" xml:"ResourceGroupId,omitempty"`
	// The global time to live (TTL).
	//
	// example:
	//
	// 60
	Ttl *int32 `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	// The domain name of the user.
	//
	// example:
	//
	// www.example.com
	UserDomainName *string `json:"UserDomainName,omitempty" xml:"UserDomainName,omitempty"`
	// The version code of the instance.
	//
	// example:
	//
	// biaozhun
	VersionCode *string `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetAccessStrategyNum(v int32) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.AccessStrategyNum = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetAddressPoolNum(v int32) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.AddressPoolNum = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetAlertGroup(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.AlertGroup = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetCname(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.Cname = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetCnameMode(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.CnameMode = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetCreateTime(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetCreateTimestamp(v int64) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetExpireTime(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.ExpireTime = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetExpireTimestamp(v int64) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.ExpireTimestamp = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetInstanceId(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetInstanceName(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.InstanceName = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetLbaStrategy(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.LbaStrategy = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetResourceGroupId(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.ResourceGroupId = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetTtl(v int32) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.Ttl = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetUserDomainName(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.UserDomainName = &v
	return s
}

func (s *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance) SetVersionCode(v string) *DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance {
	s.VersionCode = &v
	return s
}

type DescribeGtmInstancesResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmInstancesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmInstancesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmInstancesResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmInstancesResponse) SetHeaders(v map[string]*string) *DescribeGtmInstancesResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmInstancesResponse) SetStatusCode(v int32) *DescribeGtmInstancesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmInstancesResponse) SetBody(v *DescribeGtmInstancesResponseBody) *DescribeGtmInstancesResponse {
	s.Body = v
	return s
}

type DescribeGtmLogsRequest struct {
	// The timestamp that specifies the end of the time range to query.
	//
	// example:
	//
	// 1363453350000
	EndTimestamp *int64 `json:"EndTimestamp,omitempty" xml:"EndTimestamp,omitempty"`
	// The ID of the GTM instance whose logs you want to query.
	//
	// example:
	//
	// gtm-cn-xxxxx
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The keyword for searching logs, in case-insensitive "%Keyword%" format.
	//
	// example:
	//
	// test
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language used by the user.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The beginning of the time range to query.
	//
	// example:
	//
	// 1363453340000
	StartTimestamp *int64 `json:"StartTimestamp,omitempty" xml:"StartTimestamp,omitempty"`
}

func (s DescribeGtmLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmLogsRequest) SetEndTimestamp(v int64) *DescribeGtmLogsRequest {
	s.EndTimestamp = &v
	return s
}

func (s *DescribeGtmLogsRequest) SetInstanceId(v string) *DescribeGtmLogsRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmLogsRequest) SetKeyword(v string) *DescribeGtmLogsRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeGtmLogsRequest) SetLang(v string) *DescribeGtmLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmLogsRequest) SetPageNumber(v int32) *DescribeGtmLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmLogsRequest) SetPageSize(v int32) *DescribeGtmLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmLogsRequest) SetStartTimestamp(v int64) *DescribeGtmLogsRequest {
	s.StartTimestamp = &v
	return s
}

type DescribeGtmLogsResponseBody struct {
	// The list of logs returned.
	Logs *DescribeGtmLogsResponseBodyLogs `json:"Logs,omitempty" xml:"Logs,omitempty" type:"Struct"`
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 50C60A29-2E93-425A-ABA8-068686E28873
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 224
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 224
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeGtmLogsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmLogsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmLogsResponseBody) SetLogs(v *DescribeGtmLogsResponseBodyLogs) *DescribeGtmLogsResponseBody {
	s.Logs = v
	return s
}

func (s *DescribeGtmLogsResponseBody) SetPageNumber(v int32) *DescribeGtmLogsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmLogsResponseBody) SetPageSize(v int32) *DescribeGtmLogsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmLogsResponseBody) SetRequestId(v string) *DescribeGtmLogsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmLogsResponseBody) SetTotalItems(v int32) *DescribeGtmLogsResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeGtmLogsResponseBody) SetTotalPages(v int32) *DescribeGtmLogsResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeGtmLogsResponseBodyLogs struct {
	Log []*DescribeGtmLogsResponseBodyLogsLog `json:"Log,omitempty" xml:"Log,omitempty" type:"Repeated"`
}

func (s DescribeGtmLogsResponseBodyLogs) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmLogsResponseBodyLogs) GoString() string {
	return s.String()
}

func (s *DescribeGtmLogsResponseBodyLogs) SetLog(v []*DescribeGtmLogsResponseBodyLogsLog) *DescribeGtmLogsResponseBodyLogs {
	s.Log = v
	return s
}

type DescribeGtmLogsResponseBodyLogsLog struct {
	// The formatted message content.
	//
	// example:
	//
	// addtest-pool-1
	Content *string `json:"Content,omitempty" xml:"Content,omitempty"`
	// The ID of the object that was operated on.
	//
	// example:
	//
	// 121212
	EntityId *string `json:"EntityId,omitempty" xml:"EntityId,omitempty"`
	// The name of the object that was operated on.
	//
	// example:
	//
	// test-pool-1
	EntityName *string `json:"EntityName,omitempty" xml:"EntityName,omitempty"`
	// The type of the object that was operated on.
	//
	// example:
	//
	// POOL
	EntityType *string `json:"EntityType,omitempty" xml:"EntityType,omitempty"`
	// The ID of the log record.
	//
	// example:
	//
	// 6726
	Id *int64 `json:"Id,omitempty" xml:"Id,omitempty"`
	// The operation performed.
	//
	// example:
	//
	// add
	OperAction *string `json:"OperAction,omitempty" xml:"OperAction,omitempty"`
	// The IP address subject to the operation.
	//
	// example:
	//
	// 106.11.34.X
	OperIp *string `json:"OperIp,omitempty" xml:"OperIp,omitempty"`
	// The time when the operation was performed.
	//
	// example:
	//
	// 2018-01-24T07:35Z
	OperTime *string `json:"OperTime,omitempty" xml:"OperTime,omitempty"`
	// A timestamp that indicates the time when the operation was performed.
	//
	// example:
	//
	// 1516779348000
	OperTimestamp *int64 `json:"OperTimestamp,omitempty" xml:"OperTimestamp,omitempty"`
}

func (s DescribeGtmLogsResponseBodyLogsLog) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmLogsResponseBodyLogsLog) GoString() string {
	return s.String()
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetContent(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.Content = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetEntityId(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.EntityId = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetEntityName(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.EntityName = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetEntityType(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.EntityType = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetId(v int64) *DescribeGtmLogsResponseBodyLogsLog {
	s.Id = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetOperAction(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.OperAction = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetOperIp(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.OperIp = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetOperTime(v string) *DescribeGtmLogsResponseBodyLogsLog {
	s.OperTime = &v
	return s
}

func (s *DescribeGtmLogsResponseBodyLogsLog) SetOperTimestamp(v int64) *DescribeGtmLogsResponseBodyLogsLog {
	s.OperTimestamp = &v
	return s
}

type DescribeGtmLogsResponse struct {
	Headers    map[string]*string           `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                       `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmLogsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmLogsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmLogsResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmLogsResponse) SetHeaders(v map[string]*string) *DescribeGtmLogsResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmLogsResponse) SetStatusCode(v int32) *DescribeGtmLogsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmLogsResponse) SetBody(v *DescribeGtmLogsResponseBody) *DescribeGtmLogsResponse {
	s.Body = v
	return s
}

type DescribeGtmMonitorAvailableConfigRequest struct {
	// The language of the values of specific response parameters.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmMonitorAvailableConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorAvailableConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorAvailableConfigRequest) SetLang(v string) *DescribeGtmMonitorAvailableConfigRequest {
	s.Lang = &v
	return s
}

type DescribeGtmMonitorAvailableConfigResponseBody struct {
	// The monitored nodes.
	IspCityNodes *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes `json:"IspCityNodes,omitempty" xml:"IspCityNodes,omitempty" type:"Struct"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeGtmMonitorAvailableConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorAvailableConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorAvailableConfigResponseBody) SetIspCityNodes(v *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes) *DescribeGtmMonitorAvailableConfigResponseBody {
	s.IspCityNodes = v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBody) SetRequestId(v string) *DescribeGtmMonitorAvailableConfigResponseBody {
	s.RequestId = &v
	return s
}

type DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes struct {
	IspCityNode []*DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes) SetIspCityNode(v []*DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes {
	s.IspCityNode = v
	return s
}

type DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode struct {
	// The code of the city where the monitored node is deployed.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city where the monitored node is deployed.
	//
	// example:
	//
	// Zhangjiakou
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// Indicates whether the monitored node is selected for the health check by default.
	//
	// example:
	//
	// true
	DefaultSelected *bool `json:"DefaultSelected,omitempty" xml:"DefaultSelected,omitempty"`
	// The name of the group to which the monitored node belongs.
	//
	// Valid values: Overseas Nodes, BGP Nodes, and ISP Nodes.
	//
	// example:
	//
	// Overseas Nodes
	GroupName *string `json:"GroupName,omitempty" xml:"GroupName,omitempty"`
	// The type of the group to which the monitored node belongs.
	//
	// Valid values: BGP, OVERSEAS, and ISP.
	//
	// example:
	//
	// OVERSEAS
	GroupType *string `json:"GroupType,omitempty" xml:"GroupType,omitempty"`
	// The code of the Internet service provider (ISP) to which the monitored node belongs.
	//
	// 	- If the value of the GroupType parameter is BGP or OVERSEAS, the value of IspCode is 465 by default.
	//
	// 	- If the value of the GroupType parameter is not BGP or OVERSEAS, valid values of IspCode are 232, 132, and 5. and is used together with CityCode.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP to which the monitored node belongs.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
	// Indicates whether the monitored node is deployed in the Chinese mainland.
	//
	// example:
	//
	// true
	Mainland *bool `json:"Mainland,omitempty" xml:"Mainland,omitempty"`
}

func (s DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetCityCode(v string) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetCityName(v string) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetDefaultSelected(v bool) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.DefaultSelected = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetGroupName(v string) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.GroupName = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetGroupType(v string) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.GroupType = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetIspCode(v string) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetIspName(v string) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.IspName = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode) SetMainland(v bool) *DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode {
	s.Mainland = &v
	return s
}

type DescribeGtmMonitorAvailableConfigResponse struct {
	Headers    map[string]*string                             `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                         `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmMonitorAvailableConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmMonitorAvailableConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorAvailableConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorAvailableConfigResponse) SetHeaders(v map[string]*string) *DescribeGtmMonitorAvailableConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponse) SetStatusCode(v int32) *DescribeGtmMonitorAvailableConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmMonitorAvailableConfigResponse) SetBody(v *DescribeGtmMonitorAvailableConfigResponseBody) *DescribeGtmMonitorAvailableConfigResponse {
	s.Body = v
	return s
}

type DescribeGtmMonitorConfigRequest struct {
	// The language of the values of specific response parameters.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the health check configuration.
	//
	// This parameter is required.
	//
	// example:
	//
	// 100
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
}

func (s DescribeGtmMonitorConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorConfigRequest) SetLang(v string) *DescribeGtmMonitorConfigRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmMonitorConfigRequest) SetMonitorConfigId(v string) *DescribeGtmMonitorConfigRequest {
	s.MonitorConfigId = &v
	return s
}

type DescribeGtmMonitorConfigResponseBody struct {
	// The time when the health check configuration was created.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The timestamp that indicates the time when the health check configuration was created.
	//
	// example:
	//
	// 1527690629357
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
	//
	// example:
	//
	// 3
	EvaluationCount *int32 `json:"EvaluationCount,omitempty" xml:"EvaluationCount,omitempty"`
	// The health check interval. Unit: seconds. The value is 60.
	//
	// example:
	//
	// 60
	Interval *int32 `json:"Interval,omitempty" xml:"Interval,omitempty"`
	// The monitored nodes.
	IspCityNodes *DescribeGtmMonitorConfigResponseBodyIspCityNodes `json:"IspCityNodes,omitempty" xml:"IspCityNodes,omitempty" type:"Struct"`
	// The ID of the health check configuration.
	//
	// example:
	//
	// 1234abc
	MonitorConfigId *string `json:"MonitorConfigId,omitempty" xml:"MonitorConfigId,omitempty"`
	// The extended information, that is, the parameters required for the protocol. Different protocols require different parameters:
	//
	// HTTP or HTTPS:
	//
	// 	- port: the port to check.
	//
	// 	- failureRate: the failure rate.
	//
	// 	- code: the status code threshold. If the returned status code is greater than the specified threshold, the application service is deemed abnormal. Valid values: 400 and 500.
	//
	// 	- host: the host configuration.
	//
	// 	- path: the health check URL.
	//
	// PING:
	//
	// 	- packetNum: the number of ping packets.
	//
	// 	- packetLossRate: the loss rate of ping packets.
	//
	// 	- failureRate: the failure rate.
	//
	// TCP:
	//
	// 	- port: the port to check.
	//
	// 	- failureRate: the failure rate.
	//
	// example:
	//
	// {\\"code\\":200,\\"path\\":\\"\\\\index.htm\\",\\"host\\":\\"aliyun.com\\"}
	MonitorExtendInfo *string `json:"MonitorExtendInfo,omitempty" xml:"MonitorExtendInfo,omitempty"`
	// The protocol used for the health check.
	//
	// example:
	//
	// HTTP
	ProtocolType *string `json:"ProtocolType,omitempty" xml:"ProtocolType,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 6856BCF6-11D6-4D7E-AC53-FD579933522B
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The health check timeout period. Unit: milliseconds. Valid values: 2000, 3000, 5000, and 10000.
	//
	// example:
	//
	// 3000
	Timeout *int32 `json:"Timeout,omitempty" xml:"Timeout,omitempty"`
	// The time when the health check configuration was last updated.
	//
	// example:
	//
	// 2017-12-28T13:08Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The timestamp that indicates the time when the health check configuration was last updated.
	//
	// example:
	//
	// 1527690629357
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeGtmMonitorConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorConfigResponseBody) SetCreateTime(v string) *DescribeGtmMonitorConfigResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetCreateTimestamp(v int64) *DescribeGtmMonitorConfigResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetEvaluationCount(v int32) *DescribeGtmMonitorConfigResponseBody {
	s.EvaluationCount = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetInterval(v int32) *DescribeGtmMonitorConfigResponseBody {
	s.Interval = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetIspCityNodes(v *DescribeGtmMonitorConfigResponseBodyIspCityNodes) *DescribeGtmMonitorConfigResponseBody {
	s.IspCityNodes = v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetMonitorConfigId(v string) *DescribeGtmMonitorConfigResponseBody {
	s.MonitorConfigId = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetMonitorExtendInfo(v string) *DescribeGtmMonitorConfigResponseBody {
	s.MonitorExtendInfo = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetProtocolType(v string) *DescribeGtmMonitorConfigResponseBody {
	s.ProtocolType = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetRequestId(v string) *DescribeGtmMonitorConfigResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetTimeout(v int32) *DescribeGtmMonitorConfigResponseBody {
	s.Timeout = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetUpdateTime(v string) *DescribeGtmMonitorConfigResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBody) SetUpdateTimestamp(v int64) *DescribeGtmMonitorConfigResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeGtmMonitorConfigResponseBodyIspCityNodes struct {
	IspCityNode []*DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode `json:"IspCityNode,omitempty" xml:"IspCityNode,omitempty" type:"Repeated"`
}

func (s DescribeGtmMonitorConfigResponseBodyIspCityNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorConfigResponseBodyIspCityNodes) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodes) SetIspCityNode(v []*DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) *DescribeGtmMonitorConfigResponseBodyIspCityNodes {
	s.IspCityNode = v
	return s
}

type DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode struct {
	// The code of the city where the monitored node is deployed.
	//
	// example:
	//
	// 503
	CityCode *string `json:"CityCode,omitempty" xml:"CityCode,omitempty"`
	// The display name of the city where the monitored node is deployed.
	//
	// example:
	//
	// Zhangjiakou
	CityName *string `json:"CityName,omitempty" xml:"CityName,omitempty"`
	// The code of the country where the monitored node is deployed.
	//
	// example:
	//
	// 001
	CountryCode *string `json:"CountryCode,omitempty" xml:"CountryCode,omitempty"`
	// The display name of the country where the monitored node is deployed.
	//
	// example:
	//
	// China
	CountryName *string `json:"CountryName,omitempty" xml:"CountryName,omitempty"`
	// The code of the Internet service provider (ISP) to which the monitored node belongs.
	//
	// example:
	//
	// 465
	IspCode *string `json:"IspCode,omitempty" xml:"IspCode,omitempty"`
	// The display name of the ISP to which the monitored node belongs.
	//
	// example:
	//
	// Alibaba
	IspName *string `json:"IspName,omitempty" xml:"IspName,omitempty"`
}

func (s DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCityCode(v string) *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CityCode = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCityName(v string) *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CityName = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCountryCode(v string) *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CountryCode = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetCountryName(v string) *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.CountryName = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetIspCode(v string) *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.IspCode = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode) SetIspName(v string) *DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode {
	s.IspName = &v
	return s
}

type DescribeGtmMonitorConfigResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmMonitorConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmMonitorConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmMonitorConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmMonitorConfigResponse) SetHeaders(v map[string]*string) *DescribeGtmMonitorConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmMonitorConfigResponse) SetStatusCode(v int32) *DescribeGtmMonitorConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmMonitorConfigResponse) SetBody(v *DescribeGtmMonitorConfigResponseBody) *DescribeGtmMonitorConfigResponse {
	s.Body = v
	return s
}

type DescribeGtmRecoveryPlanRequest struct {
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The ID of the disaster recovery plan.
	//
	// This parameter is required.
	//
	// example:
	//
	// 100
	RecoveryPlanId *int64 `json:"RecoveryPlanId,omitempty" xml:"RecoveryPlanId,omitempty"`
}

func (s DescribeGtmRecoveryPlanRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanRequest) SetLang(v string) *DescribeGtmRecoveryPlanRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmRecoveryPlanRequest) SetRecoveryPlanId(v int64) *DescribeGtmRecoveryPlanRequest {
	s.RecoveryPlanId = &v
	return s
}

type DescribeGtmRecoveryPlanResponseBody struct {
	// The time when the disaster recovery plan was created. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2019-08-11T05:04Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The time when the disaster recovery plan was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1565499867000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The number of faulty address pools.
	//
	// example:
	//
	// 2
	FaultAddrPoolNum *int32 `json:"FaultAddrPoolNum,omitempty" xml:"FaultAddrPoolNum,omitempty"`
	// The faulty address pools.
	FaultAddrPools *DescribeGtmRecoveryPlanResponseBodyFaultAddrPools `json:"FaultAddrPools,omitempty" xml:"FaultAddrPools,omitempty" type:"Struct"`
	// The time when the disaster recovery plan was last executed. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2019-08-11T05:04Z
	LastExecuteTime *string `json:"LastExecuteTime,omitempty" xml:"LastExecuteTime,omitempty"`
	// The time when the disaster recovery plan was last executed. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1565505898000
	LastExecuteTimestamp *int64 `json:"LastExecuteTimestamp,omitempty" xml:"LastExecuteTimestamp,omitempty"`
	// The time when the disaster recovery plan was last rolled back. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 2019-08-11T06:45Z
	LastRollbackTime *string `json:"LastRollbackTime,omitempty" xml:"LastRollbackTime,omitempty"`
	// The time when the disaster recovery plan was last rolled back. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1565505919000
	LastRollbackTimestamp *int64 `json:"LastRollbackTimestamp,omitempty" xml:"LastRollbackTimestamp,omitempty"`
	// The name of the disaster recovery plan.
	//
	// example:
	//
	// name-example
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The ID of the disaster recovery plan.
	//
	// example:
	//
	// 55
	RecoveryPlanId *int64 `json:"RecoveryPlanId,omitempty" xml:"RecoveryPlanId,omitempty"`
	// The description of the disaster recovery plan.
	//
	// example:
	//
	// remark-example
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 0A5F4315-D6E8-435E-82DF-24F4C97D6999
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The status of the disaster recovery plan.
	//
	// example:
	//
	// UNEXECUTED
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The time when the disaster recovery plan was last modified. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
	//
	// example:
	//
	// 2019-08-11T06:45Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The time when the disaster recovery plan was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1565499867000
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeGtmRecoveryPlanResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetCreateTime(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetCreateTimestamp(v int64) *DescribeGtmRecoveryPlanResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetFaultAddrPoolNum(v int32) *DescribeGtmRecoveryPlanResponseBody {
	s.FaultAddrPoolNum = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetFaultAddrPools(v *DescribeGtmRecoveryPlanResponseBodyFaultAddrPools) *DescribeGtmRecoveryPlanResponseBody {
	s.FaultAddrPools = v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetLastExecuteTime(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.LastExecuteTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetLastExecuteTimestamp(v int64) *DescribeGtmRecoveryPlanResponseBody {
	s.LastExecuteTimestamp = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetLastRollbackTime(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.LastRollbackTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetLastRollbackTimestamp(v int64) *DescribeGtmRecoveryPlanResponseBody {
	s.LastRollbackTimestamp = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetName(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.Name = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetRecoveryPlanId(v int64) *DescribeGtmRecoveryPlanResponseBody {
	s.RecoveryPlanId = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetRemark(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.Remark = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetRequestId(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetStatus(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.Status = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetUpdateTime(v string) *DescribeGtmRecoveryPlanResponseBody {
	s.UpdateTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBody) SetUpdateTimestamp(v int64) *DescribeGtmRecoveryPlanResponseBody {
	s.UpdateTimestamp = &v
	return s
}

type DescribeGtmRecoveryPlanResponseBodyFaultAddrPools struct {
	FaultAddrPool []*DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool `json:"FaultAddrPool,omitempty" xml:"FaultAddrPool,omitempty" type:"Repeated"`
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPools) SetFaultAddrPool(v []*DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPools {
	s.FaultAddrPool = v
	return s
}

type DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool struct {
	// The address pool ID.
	//
	// example:
	//
	// hra0oq
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The address pool name.
	AddrPoolName *string                                                              `json:"AddrPoolName,omitempty" xml:"AddrPoolName,omitempty"`
	Addrs        *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs `json:"Addrs,omitempty" xml:"Addrs,omitempty" type:"Struct"`
	// The instance ID.
	//
	// example:
	//
	// instance-zwy-38
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) SetAddrPoolId(v string) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) SetAddrPoolName(v string) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool {
	s.AddrPoolName = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) SetAddrs(v *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool {
	s.Addrs = v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool) SetInstanceId(v string) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool {
	s.InstanceId = &v
	return s
}

type DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs struct {
	Addr []*DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr `json:"Addr,omitempty" xml:"Addr,omitempty" type:"Repeated"`
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs) SetAddr(v []*DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs {
	s.Addr = v
	return s
}

type DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr struct {
	// The address ID.
	//
	// example:
	//
	// 739
	Id *int64 `json:"Id,omitempty" xml:"Id,omitempty"`
	// The address mode.
	//
	// example:
	//
	// OFFLINE
	Mode *string `json:"Mode,omitempty" xml:"Mode,omitempty"`
	// The address.
	//
	// example:
	//
	// 1.1.1.1
	Value *string `json:"Value,omitempty" xml:"Value,omitempty"`
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr) SetId(v int64) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr {
	s.Id = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr) SetMode(v string) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr {
	s.Mode = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr) SetValue(v string) *DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr {
	s.Value = &v
	return s
}

type DescribeGtmRecoveryPlanResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmRecoveryPlanResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmRecoveryPlanResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanResponse) SetHeaders(v map[string]*string) *DescribeGtmRecoveryPlanResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmRecoveryPlanResponse) SetStatusCode(v int32) *DescribeGtmRecoveryPlanResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmRecoveryPlanResponse) SetBody(v *DescribeGtmRecoveryPlanResponseBody) *DescribeGtmRecoveryPlanResponse {
	s.Body = v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigRequest struct {
	// The language in which the returned results are displayed. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: en.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigRequest) SetLang(v string) *DescribeGtmRecoveryPlanAvailableConfigRequest {
	s.Lang = &v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigResponseBody struct {
	// The instances.
	Instances *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances `json:"Instances,omitempty" xml:"Instances,omitempty" type:"Struct"`
	// The request ID.
	//
	// example:
	//
	// F8F8EF50-8B7F-4702-B294-97170A423403
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBody) SetInstances(v *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances) *DescribeGtmRecoveryPlanAvailableConfigResponseBody {
	s.Instances = v
	return s
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBody) SetRequestId(v string) *DescribeGtmRecoveryPlanAvailableConfigResponseBody {
	s.RequestId = &v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances struct {
	Instance []*DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance `json:"Instance,omitempty" xml:"Instance,omitempty" type:"Repeated"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances) SetInstance(v []*DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances {
	s.Instance = v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance struct {
	// The address pools.
	AddrPools *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools `json:"AddrPools,omitempty" xml:"AddrPools,omitempty" type:"Struct"`
	// The instance ID.
	//
	// example:
	//
	// instance-example
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The instance name.
	//
	// example:
	//
	// instance-name-example
	InstanceName *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance) SetAddrPools(v *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance {
	s.AddrPools = v
	return s
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance) SetInstanceId(v string) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance {
	s.InstanceId = &v
	return s
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance) SetInstanceName(v string) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance {
	s.InstanceName = &v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools struct {
	AddrPool []*DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool `json:"AddrPool,omitempty" xml:"AddrPool,omitempty" type:"Repeated"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools) SetAddrPool(v []*DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools {
	s.AddrPool = v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool struct {
	// The address pool ID.
	AddrPoolId *string `json:"AddrPoolId,omitempty" xml:"AddrPoolId,omitempty"`
	// The name of the address pool.
	//
	// example:
	//
	// hra0i9
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool) SetAddrPoolId(v string) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool {
	s.AddrPoolId = &v
	return s
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool) SetName(v string) *DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool {
	s.Name = &v
	return s
}

type DescribeGtmRecoveryPlanAvailableConfigResponse struct {
	Headers    map[string]*string                                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmRecoveryPlanAvailableConfigResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlanAvailableConfigResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponse) SetHeaders(v map[string]*string) *DescribeGtmRecoveryPlanAvailableConfigResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponse) SetStatusCode(v int32) *DescribeGtmRecoveryPlanAvailableConfigResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmRecoveryPlanAvailableConfigResponse) SetBody(v *DescribeGtmRecoveryPlanAvailableConfigResponseBody) *DescribeGtmRecoveryPlanAvailableConfigResponse {
	s.Body = v
	return s
}

type DescribeGtmRecoveryPlansRequest struct {
	// The keyword for the query. Fuzzy match is supported by disaster recovery plan name.
	//
	// example:
	//
	// test
	Keyword *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	// The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number to return. The page number starts from **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries to return per page. Maximum value: **100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeGtmRecoveryPlansRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlansRequest) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlansRequest) SetKeyword(v string) *DescribeGtmRecoveryPlansRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeGtmRecoveryPlansRequest) SetLang(v string) *DescribeGtmRecoveryPlansRequest {
	s.Lang = &v
	return s
}

func (s *DescribeGtmRecoveryPlansRequest) SetPageNumber(v int32) *DescribeGtmRecoveryPlansRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmRecoveryPlansRequest) SetPageSize(v int32) *DescribeGtmRecoveryPlansRequest {
	s.PageSize = &v
	return s
}

type DescribeGtmRecoveryPlansResponseBody struct {
	// The page number of the returned page.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries returned per page.
	//
	// example:
	//
	// 20
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The details about the queried disaster recovery plans.
	RecoveryPlans *DescribeGtmRecoveryPlansResponseBodyRecoveryPlans `json:"RecoveryPlans,omitempty" xml:"RecoveryPlans,omitempty" type:"Struct"`
	// The ID of the request.
	//
	// example:
	//
	// 2BA072CF-CA21-4A34-B6C2-227BE2C58079
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 10
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 1
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeGtmRecoveryPlansResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlansResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlansResponseBody) SetPageNumber(v int32) *DescribeGtmRecoveryPlansResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBody) SetPageSize(v int32) *DescribeGtmRecoveryPlansResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBody) SetRecoveryPlans(v *DescribeGtmRecoveryPlansResponseBodyRecoveryPlans) *DescribeGtmRecoveryPlansResponseBody {
	s.RecoveryPlans = v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBody) SetRequestId(v string) *DescribeGtmRecoveryPlansResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBody) SetTotalItems(v int32) *DescribeGtmRecoveryPlansResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBody) SetTotalPages(v int32) *DescribeGtmRecoveryPlansResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeGtmRecoveryPlansResponseBodyRecoveryPlans struct {
	RecoveryPlan []*DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan `json:"RecoveryPlan,omitempty" xml:"RecoveryPlan,omitempty" type:"Repeated"`
}

func (s DescribeGtmRecoveryPlansResponseBodyRecoveryPlans) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlansResponseBodyRecoveryPlans) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlans) SetRecoveryPlan(v []*DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlans {
	s.RecoveryPlan = v
	return s
}

type DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan struct {
	// The time when the disaster recovery plan was created.
	//
	// example:
	//
	// 2019-08-11T06:45Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The UNIX timestamp that indicates when the disaster recovery plan was created.
	//
	// example:
	//
	// 1565499867000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The number of faulty address pools.
	//
	// example:
	//
	// 0
	FaultAddrPoolNum *int32 `json:"FaultAddrPoolNum,omitempty" xml:"FaultAddrPoolNum,omitempty"`
	// The last time when the disaster recovery plan was executed.
	//
	// example:
	//
	// 2019-08-11T06:44Z
	LastExecuteTime *string `json:"LastExecuteTime,omitempty" xml:"LastExecuteTime,omitempty"`
	// The UNIX timestamp that indicates the last time when the disaster recovery plan was executed.
	//
	// example:
	//
	// 1565505898000
	LastExecuteTimestamp *int64 `json:"LastExecuteTimestamp,omitempty" xml:"LastExecuteTimestamp,omitempty"`
	// The last time when the disaster recovery plan was rolled back.
	//
	// example:
	//
	// 2019-08-11T06:45Z
	LastRollbackTime *string `json:"LastRollbackTime,omitempty" xml:"LastRollbackTime,omitempty"`
	// The UNIX timestamp that indicates the last time when the disaster recovery plan was rolled back.
	//
	// example:
	//
	// 1565505919000
	LastRollbackTimestamp *int64 `json:"LastRollbackTimestamp,omitempty" xml:"LastRollbackTimestamp,omitempty"`
	// The name of the disaster recovery plan.
	//
	// example:
	//
	// name-example
	Name *string `json:"Name,omitempty" xml:"Name,omitempty"`
	// The ID of the disaster recovery plan.
	//
	// example:
	//
	// 55
	RecoveryPlanId *int64 `json:"RecoveryPlanId,omitempty" xml:"RecoveryPlanId,omitempty"`
	// The remarks about the disaster recovery plan.
	//
	// example:
	//
	// remark-example
	Remark *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	// The status of the disaster recovery plan. Valid values:
	//
	// 	- **UNEXECUTED**: The plan is not executed.
	//
	// 	- **EXECUTED**: The plan is executed.
	//
	// 	- **ROLLED_BACK**: The plan is rolled back.
	//
	// example:
	//
	// UNEXECUTED
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The last time when the disaster recovery plan was updated.
	//
	// example:
	//
	// 2019-08-11T06:45Z
	UpdateTime *string `json:"UpdateTime,omitempty" xml:"UpdateTime,omitempty"`
	// The UNIX timestamp that indicates the last time when the disaster recovery plan was updated.
	//
	// example:
	//
	// 1565505919000
	UpdateTimestamp *int64 `json:"UpdateTimestamp,omitempty" xml:"UpdateTimestamp,omitempty"`
}

func (s DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetCreateTime(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.CreateTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetCreateTimestamp(v int64) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetFaultAddrPoolNum(v int32) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.FaultAddrPoolNum = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetLastExecuteTime(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.LastExecuteTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetLastExecuteTimestamp(v int64) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.LastExecuteTimestamp = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetLastRollbackTime(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.LastRollbackTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetLastRollbackTimestamp(v int64) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.LastRollbackTimestamp = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetName(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.Name = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetRecoveryPlanId(v int64) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.RecoveryPlanId = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetRemark(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.Remark = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetStatus(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.Status = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetUpdateTime(v string) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.UpdateTime = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan) SetUpdateTimestamp(v int64) *DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan {
	s.UpdateTimestamp = &v
	return s
}

type DescribeGtmRecoveryPlansResponse struct {
	Headers    map[string]*string                    `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeGtmRecoveryPlansResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeGtmRecoveryPlansResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeGtmRecoveryPlansResponse) GoString() string {
	return s.String()
}

func (s *DescribeGtmRecoveryPlansResponse) SetHeaders(v map[string]*string) *DescribeGtmRecoveryPlansResponse {
	s.Headers = v
	return s
}

func (s *DescribeGtmRecoveryPlansResponse) SetStatusCode(v int32) *DescribeGtmRecoveryPlansResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeGtmRecoveryPlansResponse) SetBody(v *DescribeGtmRecoveryPlansResponseBody) *DescribeGtmRecoveryPlansResponse {
	s.Body = v
	return s
}

type DescribeInstanceDomainsRequest struct {
	// The ID of the Alibaba Cloud Domain Name System (DNS) instance. You can call the [DescribeDomainInfo](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomaininfo?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the ID.
	//
	// This parameter is required.
	//
	// example:
	//
	// weriwieru
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	// The language of the response. Valid values:
	//
	// 	- zh: Chinese
	//
	// 	- en: English
	//
	// Default value: English.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The number of the page to return. Pages start from page 1. Default value: 1.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: 1 to 100. Default value: 20.
	//
	// example:
	//
	// 2
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeInstanceDomainsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeInstanceDomainsRequest) GoString() string {
	return s.String()
}

func (s *DescribeInstanceDomainsRequest) SetInstanceId(v string) *DescribeInstanceDomainsRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeInstanceDomainsRequest) SetLang(v string) *DescribeInstanceDomainsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeInstanceDomainsRequest) SetPageNumber(v int64) *DescribeInstanceDomainsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeInstanceDomainsRequest) SetPageSize(v int64) *DescribeInstanceDomainsRequest {
	s.PageSize = &v
	return s
}

type DescribeInstanceDomainsResponseBody struct {
	// The domain names that are bound to the DNS instance.
	InstanceDomains []*DescribeInstanceDomainsResponseBodyInstanceDomains `json:"InstanceDomains,omitempty" xml:"InstanceDomains,omitempty" type:"Repeated"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 2
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The ID of the request.
	//
	// example:
	//
	// 68386699-8B9E-4D5B-BC4C-75A28F6C2A00
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned on all pages.
	//
	// example:
	//
	// 2
	TotalItems *int32 `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	// The total number of pages returned.
	//
	// example:
	//
	// 2
	TotalPages *int32 `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeInstanceDomainsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeInstanceDomainsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeInstanceDomainsResponseBody) SetInstanceDomains(v []*DescribeInstanceDomainsResponseBodyInstanceDomains) *DescribeInstanceDomainsResponseBody {
	s.InstanceDomains = v
	return s
}

func (s *DescribeInstanceDomainsResponseBody) SetPageNumber(v int32) *DescribeInstanceDomainsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeInstanceDomainsResponseBody) SetPageSize(v int32) *DescribeInstanceDomainsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeInstanceDomainsResponseBody) SetRequestId(v string) *DescribeInstanceDomainsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeInstanceDomainsResponseBody) SetTotalItems(v int32) *DescribeInstanceDomainsResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeInstanceDomainsResponseBody) SetTotalPages(v int32) *DescribeInstanceDomainsResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeInstanceDomainsResponseBodyInstanceDomains struct {
	// The time when the instance was created. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
	//
	// example:
	//
	// 2020-03-09T02:15Z
	CreateTime *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	// The time when the instance was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1583720154000
	CreateTimestamp *int64 `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
}

func (s DescribeInstanceDomainsResponseBodyInstanceDomains) String() string {
	return tea.Prettify(s)
}

func (s DescribeInstanceDomainsResponseBodyInstanceDomains) GoString() string {
	return s.String()
}

func (s *DescribeInstanceDomainsResponseBodyInstanceDomains) SetCreateTime(v string) *DescribeInstanceDomainsResponseBodyInstanceDomains {
	s.CreateTime = &v
	return s
}

func (s *DescribeInstanceDomainsResponseBodyInstanceDomains) SetCreateTimestamp(v int64) *DescribeInstanceDomainsResponseBodyInstanceDomains {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeInstanceDomainsResponseBodyInstanceDomains) SetDomainName(v string) *DescribeInstanceDomainsResponseBodyInstanceDomains {
	s.DomainName = &v
	return s
}

type DescribeInstanceDomainsResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeInstanceDomainsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeInstanceDomainsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeInstanceDomainsResponse) GoString() string {
	return s.String()
}

func (s *DescribeInstanceDomainsResponse) SetHeaders(v map[string]*string) *DescribeInstanceDomainsResponse {
	s.Headers = v
	return s
}

func (s *DescribeInstanceDomainsResponse) SetStatusCode(v int32) *DescribeInstanceDomainsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeInstanceDomainsResponse) SetBody(v *DescribeInstanceDomainsResponseBody) *DescribeInstanceDomainsResponse {
	s.Body = v
	return s
}

type DescribeInternetDnsLogsRequest struct {
	// The account ID displayed on the Recursive Resolution (Public DNS) page after you activate Alibaba Cloud Public DNS.
	//
	// example:
	//
	// 51**4
	AccountId *int64 `json:"AccountId,omitempty" xml:"AccountId,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The end time of the query (timestamp, unit: milliseconds). 	Warning: If the query time span is too large and the amount of resolution logs for the queried domain is excessive, it may lead to a query timeout or inaccurate query results.
	//
	// example:
	//
	// 1709196299999
	EndTimestamp *int64 `json:"EndTimestamp,omitempty" xml:"EndTimestamp,omitempty"`
	// Return value language, options:
	//
	// - zh: Chinese
	//
	// - en: English
	//
	// Default: en
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// Module type
	//
	// - AUTHORITY (default): Public Authoritative DNS
	//
	// - RECURSION: Public Recursive DNS
	//
	// example:
	//
	// AUTHORITY
	Module *string `json:"Module,omitempty" xml:"Module,omitempty"`
	// Page number, default value is 1.
	//
	// example:
	//
	// 1
	PageNumber *int32 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// Page size for query.
	//
	// example:
	//
	// 10
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// Query parameters
	//
	// - sourceIp: Source IP address
	//
	// - queryNameFuzzy: Domain name (fuzzy value)
	//
	// - queryType: Record type
	//
	// - value: Resolution result
	//
	// - status: Status
	//
	// - serverIp: Resolution server IP
	//
	// example:
	//
	// {"sourceIp":"59.82.XX.XX","queryType":"A"}
	QueryCondition        *string `json:"QueryCondition,omitempty" xml:"QueryCondition,omitempty"`
	RecursionProtocolType *string `json:"RecursionProtocolType,omitempty" xml:"RecursionProtocolType,omitempty"`
	// The start time of the query (timestamp, unit: milliseconds).
	//
	// example:
	//
	// 1709192640000
	StartTimestamp *int64 `json:"StartTimestamp,omitempty" xml:"StartTimestamp,omitempty"`
}

func (s DescribeInternetDnsLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeInternetDnsLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribeInternetDnsLogsRequest) SetAccountId(v int64) *DescribeInternetDnsLogsRequest {
	s.AccountId = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetDomainName(v string) *DescribeInternetDnsLogsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetEndTimestamp(v int64) *DescribeInternetDnsLogsRequest {
	s.EndTimestamp = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetLang(v string) *DescribeInternetDnsLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetModule(v string) *DescribeInternetDnsLogsRequest {
	s.Module = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetPageNumber(v int32) *DescribeInternetDnsLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetPageSize(v int32) *DescribeInternetDnsLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetQueryCondition(v string) *DescribeInternetDnsLogsRequest {
	s.QueryCondition = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetRecursionProtocolType(v string) *DescribeInternetDnsLogsRequest {
	s.RecursionProtocolType = &v
	return s
}

func (s *DescribeInternetDnsLogsRequest) SetStartTimestamp(v int64) *DescribeInternetDnsLogsRequest {
	s.StartTimestamp = &v
	return s
}

type DescribeInternetDnsLogsResponseBody struct {
	// Indicates whether the log query is precise.
	//
	// example:
	//
	// true
	Complete *bool `json:"Complete,omitempty" xml:"Complete,omitempty"`
	// Current page number.
	//
	// example:
	//
	// 1
	CurPage *int32 `json:"CurPage,omitempty" xml:"CurPage,omitempty"`
	// The queried logs.
	Logs *DescribeInternetDnsLogsResponseBodyLogs `json:"Logs,omitempty" xml:"Logs,omitempty" type:"Struct"`
	// Page size for query.
	//
	// example:
	//
	// 10
	PageSize *int32 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// Unique request identifier.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// Total number of pages.
	//
	// example:
	//
	// 5
	TotalPage *int32 `json:"TotalPage,omitempty" xml:"TotalPage,omitempty"`
	// Total quantity.
	//
	// example:
	//
	// 48
	TotalSize *int32 `json:"TotalSize,omitempty" xml:"TotalSize,omitempty"`
}

func (s DescribeInternetDnsLogsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeInternetDnsLogsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeInternetDnsLogsResponseBody) SetComplete(v bool) *DescribeInternetDnsLogsResponseBody {
	s.Complete = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBody) SetCurPage(v int32) *DescribeInternetDnsLogsResponseBody {
	s.CurPage = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBody) SetLogs(v *DescribeInternetDnsLogsResponseBodyLogs) *DescribeInternetDnsLogsResponseBody {
	s.Logs = v
	return s
}

func (s *DescribeInternetDnsLogsResponseBody) SetPageSize(v int32) *DescribeInternetDnsLogsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBody) SetRequestId(v string) *DescribeInternetDnsLogsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBody) SetTotalPage(v int32) *DescribeInternetDnsLogsResponseBody {
	s.TotalPage = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBody) SetTotalSize(v int32) *DescribeInternetDnsLogsResponseBody {
	s.TotalSize = &v
	return s
}

type DescribeInternetDnsLogsResponseBodyLogs struct {
	Log []*DescribeInternetDnsLogsResponseBodyLogsLog `json:"Log,omitempty" xml:"Log,omitempty" type:"Repeated"`
}

func (s DescribeInternetDnsLogsResponseBodyLogs) String() string {
	return tea.Prettify(s)
}

func (s DescribeInternetDnsLogsResponseBodyLogs) GoString() string {
	return s.String()
}

func (s *DescribeInternetDnsLogsResponseBodyLogs) SetLog(v []*DescribeInternetDnsLogsResponseBodyLogsLog) *DescribeInternetDnsLogsResponseBodyLogs {
	s.Log = v
	return s
}

type DescribeInternetDnsLogsResponseBodyLogsLog struct {
	// Parse log ID (can be duplicated).
	//
	// example:
	//
	// 3583
	DnsMsgId *string `json:"DnsMsgId,omitempty" xml:"DnsMsgId,omitempty"`
	// Parse timestamp.
	//
	// example:
	//
	// 1709196249000
	LogTime *int64 `json:"LogTime,omitempty" xml:"LogTime,omitempty"`
	// The protocol type of the domain name resolution query request:
	//
	// - UDP
	//
	// - TCP
	//
	// - HTTP
	//
	// - HTTPS
	//
	// - DOH
	//
	// example:
	//
	// UDP
	Protocol *string `json:"Protocol,omitempty" xml:"Protocol,omitempty"`
	// The domain name for which you want to query Domain Name System (DNS) records.
	//
	// example:
	//
	// example.com
	QueryName *string `json:"QueryName,omitempty" xml:"QueryName,omitempty"`
	// Record type.
	//
	// example:
	//
	// A
	QueryType *string `json:"QueryType,omitempty" xml:"QueryType,omitempty"`
	// Parse response time.
	//
	// example:
	//
	// 0
	Rt *int32 `json:"Rt,omitempty" xml:"Rt,omitempty"`
	// Parse server IP.
	//
	// example:
	//
	// 140.205.XX.XX
	ServerIp *string `json:"ServerIp,omitempty" xml:"ServerIp,omitempty"`
	// Source IP address.
	//
	// example:
	//
	// 59.82.XX.XX
	SourceIp *string `json:"SourceIp,omitempty" xml:"SourceIp,omitempty"`
	// Response status.
	//
	// example:
	//
	// NOERROR
	Status *string `json:"Status,omitempty" xml:"Status,omitempty"`
	// The value set for the edns-client-subnet option.
	//
	// example:
	//
	// 170.33.XX.XX
	SubnetIp *string `json:"SubnetIp,omitempty" xml:"SubnetIp,omitempty"`
	// Array of parsing results.
	Value *DescribeInternetDnsLogsResponseBodyLogsLogValue `json:"Value,omitempty" xml:"Value,omitempty" type:"Struct"`
	// The zone name.
	//
	// example:
	//
	// example.com
	ZoneName *string `json:"ZoneName,omitempty" xml:"ZoneName,omitempty"`
}

func (s DescribeInternetDnsLogsResponseBodyLogsLog) String() string {
	return tea.Prettify(s)
}

func (s DescribeInternetDnsLogsResponseBodyLogsLog) GoString() string {
	return s.String()
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetDnsMsgId(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.DnsMsgId = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetLogTime(v int64) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.LogTime = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetProtocol(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.Protocol = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetQueryName(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.QueryName = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetQueryType(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.QueryType = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetRt(v int32) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.Rt = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetServerIp(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.ServerIp = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetSourceIp(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.SourceIp = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetStatus(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.Status = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetSubnetIp(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.SubnetIp = &v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetValue(v *DescribeInternetDnsLogsResponseBodyLogsLogValue) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.Value = v
	return s
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLog) SetZoneName(v string) *DescribeInternetDnsLogsResponseBodyLogsLog {
	s.ZoneName = &v
	return s
}

type DescribeInternetDnsLogsResponseBodyLogsLogValue struct {
	Value []*string `json:"Value,omitempty" xml:"Value,omitempty" type:"Repeated"`
}

func (s DescribeInternetDnsLogsResponseBodyLogsLogValue) String() string {
	return tea.Prettify(s)
}

func (s DescribeInternetDnsLogsResponseBodyLogsLogValue) GoString() string {
	return s.String()
}

func (s *DescribeInternetDnsLogsResponseBodyLogsLogValue) SetValue(v []*string) *DescribeInternetDnsLogsResponseBodyLogsLogValue {
	s.Value = v
	return s
}

type DescribeInternetDnsLogsResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeInternetDnsLogsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeInternetDnsLogsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeInternetDnsLogsResponse) GoString() string {
	return s.String()
}

func (s *DescribeInternetDnsLogsResponse) SetHeaders(v map[string]*string) *DescribeInternetDnsLogsResponse {
	s.Headers = v
	return s
}

func (s *DescribeInternetDnsLogsResponse) SetStatusCode(v int32) *DescribeInternetDnsLogsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeInternetDnsLogsResponse) SetBody(v *DescribeInternetDnsLogsResponseBody) *DescribeInternetDnsLogsResponse {
	s.Body = v
	return s
}

type DescribeIspFlushCacheInstancesRequest struct {
	Direction  *string `json:"Direction,omitempty" xml:"Direction,omitempty"`
	Isp        *string `json:"Isp,omitempty" xml:"Isp,omitempty"`
	Keyword    *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	Lang       *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	OrderBy    *string `json:"OrderBy,omitempty" xml:"OrderBy,omitempty"`
	PageNumber *int32  `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int32  `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	Type       *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribeIspFlushCacheInstancesRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheInstancesRequest) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheInstancesRequest) SetDirection(v string) *DescribeIspFlushCacheInstancesRequest {
	s.Direction = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetIsp(v string) *DescribeIspFlushCacheInstancesRequest {
	s.Isp = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetKeyword(v string) *DescribeIspFlushCacheInstancesRequest {
	s.Keyword = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetLang(v string) *DescribeIspFlushCacheInstancesRequest {
	s.Lang = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetOrderBy(v string) *DescribeIspFlushCacheInstancesRequest {
	s.OrderBy = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetPageNumber(v int32) *DescribeIspFlushCacheInstancesRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetPageSize(v int32) *DescribeIspFlushCacheInstancesRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesRequest) SetType(v string) *DescribeIspFlushCacheInstancesRequest {
	s.Type = &v
	return s
}

type DescribeIspFlushCacheInstancesResponseBody struct {
	IspFlushCacheInstances []*DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances `json:"IspFlushCacheInstances,omitempty" xml:"IspFlushCacheInstances,omitempty" type:"Repeated"`
	PageNumber             *int32                                                              `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize               *int32                                                              `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	RequestId              *string                                                             `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TotalItems             *int32                                                              `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	TotalPages             *int32                                                              `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeIspFlushCacheInstancesResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheInstancesResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheInstancesResponseBody) SetIspFlushCacheInstances(v []*DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) *DescribeIspFlushCacheInstancesResponseBody {
	s.IspFlushCacheInstances = v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBody) SetPageNumber(v int32) *DescribeIspFlushCacheInstancesResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBody) SetPageSize(v int32) *DescribeIspFlushCacheInstancesResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBody) SetRequestId(v string) *DescribeIspFlushCacheInstancesResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBody) SetTotalItems(v int32) *DescribeIspFlushCacheInstancesResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBody) SetTotalPages(v int32) *DescribeIspFlushCacheInstancesResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances struct {
	ExpireTime      *string                                                                    `json:"ExpireTime,omitempty" xml:"ExpireTime,omitempty"`
	ExpireTimestamp *int64                                                                     `json:"ExpireTimestamp,omitempty" xml:"ExpireTimestamp,omitempty"`
	InstanceId      *string                                                                    `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	InstanceName    *string                                                                    `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	Isp             *string                                                                    `json:"Isp,omitempty" xml:"Isp,omitempty"`
	QuotaInfo       *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo `json:"QuotaInfo,omitempty" xml:"QuotaInfo,omitempty" type:"Struct"`
	Status          *string                                                                    `json:"Status,omitempty" xml:"Status,omitempty"`
	VersionCode     *string                                                                    `json:"VersionCode,omitempty" xml:"VersionCode,omitempty"`
}

func (s DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetExpireTime(v string) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.ExpireTime = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetExpireTimestamp(v int64) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.ExpireTimestamp = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetInstanceId(v string) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.InstanceId = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetInstanceName(v string) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.InstanceName = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetIsp(v string) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.Isp = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetQuotaInfo(v *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.QuotaInfo = v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetStatus(v string) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.Status = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances) SetVersionCode(v string) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances {
	s.VersionCode = &v
	return s
}

type DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo struct {
	InstanceQuota     *int32 `json:"InstanceQuota,omitempty" xml:"InstanceQuota,omitempty"`
	InstanceQuotaUsed *int32 `json:"InstanceQuotaUsed,omitempty" xml:"InstanceQuotaUsed,omitempty"`
}

func (s DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo) SetInstanceQuota(v int32) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo {
	s.InstanceQuota = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo) SetInstanceQuotaUsed(v int32) *DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo {
	s.InstanceQuotaUsed = &v
	return s
}

type DescribeIspFlushCacheInstancesResponse struct {
	Headers    map[string]*string                          `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                      `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeIspFlushCacheInstancesResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeIspFlushCacheInstancesResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheInstancesResponse) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheInstancesResponse) SetHeaders(v map[string]*string) *DescribeIspFlushCacheInstancesResponse {
	s.Headers = v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponse) SetStatusCode(v int32) *DescribeIspFlushCacheInstancesResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeIspFlushCacheInstancesResponse) SetBody(v *DescribeIspFlushCacheInstancesResponseBody) *DescribeIspFlushCacheInstancesResponse {
	s.Body = v
	return s
}

type DescribeIspFlushCacheRemainQuotaRequest struct {
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribeIspFlushCacheRemainQuotaRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheRemainQuotaRequest) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheRemainQuotaRequest) SetLang(v string) *DescribeIspFlushCacheRemainQuotaRequest {
	s.Lang = &v
	return s
}

type DescribeIspFlushCacheRemainQuotaResponseBody struct {
	RequestId          *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TelecomRemainQuota *int32  `json:"TelecomRemainQuota,omitempty" xml:"TelecomRemainQuota,omitempty"`
}

func (s DescribeIspFlushCacheRemainQuotaResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheRemainQuotaResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheRemainQuotaResponseBody) SetRequestId(v string) *DescribeIspFlushCacheRemainQuotaResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeIspFlushCacheRemainQuotaResponseBody) SetTelecomRemainQuota(v int32) *DescribeIspFlushCacheRemainQuotaResponseBody {
	s.TelecomRemainQuota = &v
	return s
}

type DescribeIspFlushCacheRemainQuotaResponse struct {
	Headers    map[string]*string                            `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                        `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeIspFlushCacheRemainQuotaResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeIspFlushCacheRemainQuotaResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheRemainQuotaResponse) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheRemainQuotaResponse) SetHeaders(v map[string]*string) *DescribeIspFlushCacheRemainQuotaResponse {
	s.Headers = v
	return s
}

func (s *DescribeIspFlushCacheRemainQuotaResponse) SetStatusCode(v int32) *DescribeIspFlushCacheRemainQuotaResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeIspFlushCacheRemainQuotaResponse) SetBody(v *DescribeIspFlushCacheRemainQuotaResponseBody) *DescribeIspFlushCacheRemainQuotaResponse {
	s.Body = v
	return s
}

type DescribeIspFlushCacheTaskRequest struct {
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// This parameter is required.
	TaskId *string `json:"TaskId,omitempty" xml:"TaskId,omitempty"`
}

func (s DescribeIspFlushCacheTaskRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTaskRequest) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTaskRequest) SetLang(v string) *DescribeIspFlushCacheTaskRequest {
	s.Lang = &v
	return s
}

func (s *DescribeIspFlushCacheTaskRequest) SetTaskId(v string) *DescribeIspFlushCacheTaskRequest {
	s.TaskId = &v
	return s
}

type DescribeIspFlushCacheTaskResponseBody struct {
	CreateTime        *string                                                   `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	CreateTimestamp   *int64                                                    `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	DomainName        *string                                                   `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	FlushCacheResults []*DescribeIspFlushCacheTaskResponseBodyFlushCacheResults `json:"FlushCacheResults,omitempty" xml:"FlushCacheResults,omitempty" type:"Repeated"`
	InstanceId        *string                                                   `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	InstanceName      *string                                                   `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	Isp               *string                                                   `json:"Isp,omitempty" xml:"Isp,omitempty"`
	RequestId         *string                                                   `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TaskId            *string                                                   `json:"TaskId,omitempty" xml:"TaskId,omitempty"`
	TaskStatus        *string                                                   `json:"TaskStatus,omitempty" xml:"TaskStatus,omitempty"`
}

func (s DescribeIspFlushCacheTaskResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTaskResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetCreateTime(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.CreateTime = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetCreateTimestamp(v int64) *DescribeIspFlushCacheTaskResponseBody {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetDomainName(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.DomainName = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetFlushCacheResults(v []*DescribeIspFlushCacheTaskResponseBodyFlushCacheResults) *DescribeIspFlushCacheTaskResponseBody {
	s.FlushCacheResults = v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetInstanceId(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.InstanceId = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetInstanceName(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.InstanceName = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetIsp(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.Isp = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetRequestId(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetTaskId(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.TaskId = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBody) SetTaskStatus(v string) *DescribeIspFlushCacheTaskResponseBody {
	s.TaskStatus = &v
	return s
}

type DescribeIspFlushCacheTaskResponseBodyFlushCacheResults struct {
	DnsNodes []*DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes `json:"DnsNodes,omitempty" xml:"DnsNodes,omitempty" type:"Repeated"`
	Province *string                                                           `json:"Province,omitempty" xml:"Province,omitempty"`
}

func (s DescribeIspFlushCacheTaskResponseBodyFlushCacheResults) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTaskResponseBodyFlushCacheResults) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResults) SetDnsNodes(v []*DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResults {
	s.DnsNodes = v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResults) SetProvince(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResults {
	s.Province = &v
	return s
}

type DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes struct {
	Answers []*DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers `json:"Answers,omitempty" xml:"Answers,omitempty" type:"Repeated"`
	NodeIp  *string                                                                  `json:"NodeIp,omitempty" xml:"NodeIp,omitempty"`
	SpName  *string                                                                  `json:"SpName,omitempty" xml:"SpName,omitempty"`
	Status  *string                                                                  `json:"Status,omitempty" xml:"Status,omitempty"`
}

func (s DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) SetAnswers(v []*DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes {
	s.Answers = v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) SetNodeIp(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes {
	s.NodeIp = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) SetSpName(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes {
	s.SpName = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes) SetStatus(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes {
	s.Status = &v
	return s
}

type DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers struct {
	Name   *string `json:"Name,omitempty" xml:"Name,omitempty"`
	Record *string `json:"Record,omitempty" xml:"Record,omitempty"`
	Ttl    *int64  `json:"Ttl,omitempty" xml:"Ttl,omitempty"`
	Type   *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) SetName(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers {
	s.Name = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) SetRecord(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers {
	s.Record = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) SetTtl(v int64) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers {
	s.Ttl = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers) SetType(v string) *DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers {
	s.Type = &v
	return s
}

type DescribeIspFlushCacheTaskResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeIspFlushCacheTaskResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeIspFlushCacheTaskResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTaskResponse) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTaskResponse) SetHeaders(v map[string]*string) *DescribeIspFlushCacheTaskResponse {
	s.Headers = v
	return s
}

func (s *DescribeIspFlushCacheTaskResponse) SetStatusCode(v int32) *DescribeIspFlushCacheTaskResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeIspFlushCacheTaskResponse) SetBody(v *DescribeIspFlushCacheTaskResponseBody) *DescribeIspFlushCacheTaskResponse {
	s.Body = v
	return s
}

type DescribeIspFlushCacheTasksRequest struct {
	Direction  *string `json:"Direction,omitempty" xml:"Direction,omitempty"`
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	InstanceId *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	Isp        *string `json:"Isp,omitempty" xml:"Isp,omitempty"`
	Lang       *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	OrderBy    *string `json:"OrderBy,omitempty" xml:"OrderBy,omitempty"`
	PageNumber *int32  `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int32  `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribeIspFlushCacheTasksRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTasksRequest) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTasksRequest) SetDirection(v string) *DescribeIspFlushCacheTasksRequest {
	s.Direction = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetDomainName(v string) *DescribeIspFlushCacheTasksRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetInstanceId(v string) *DescribeIspFlushCacheTasksRequest {
	s.InstanceId = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetIsp(v string) *DescribeIspFlushCacheTasksRequest {
	s.Isp = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetLang(v string) *DescribeIspFlushCacheTasksRequest {
	s.Lang = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetOrderBy(v string) *DescribeIspFlushCacheTasksRequest {
	s.OrderBy = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetPageNumber(v int32) *DescribeIspFlushCacheTasksRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeIspFlushCacheTasksRequest) SetPageSize(v int32) *DescribeIspFlushCacheTasksRequest {
	s.PageSize = &v
	return s
}

type DescribeIspFlushCacheTasksResponseBody struct {
	IspFlushCacheTasks []*DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks `json:"IspFlushCacheTasks,omitempty" xml:"IspFlushCacheTasks,omitempty" type:"Repeated"`
	PageNumber         *int32                                                      `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize           *int32                                                      `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	RequestId          *string                                                     `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TotalItems         *int32                                                      `json:"TotalItems,omitempty" xml:"TotalItems,omitempty"`
	TotalPages         *int32                                                      `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribeIspFlushCacheTasksResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTasksResponseBody) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTasksResponseBody) SetIspFlushCacheTasks(v []*DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) *DescribeIspFlushCacheTasksResponseBody {
	s.IspFlushCacheTasks = v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBody) SetPageNumber(v int32) *DescribeIspFlushCacheTasksResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBody) SetPageSize(v int32) *DescribeIspFlushCacheTasksResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBody) SetRequestId(v string) *DescribeIspFlushCacheTasksResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBody) SetTotalItems(v int32) *DescribeIspFlushCacheTasksResponseBody {
	s.TotalItems = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBody) SetTotalPages(v int32) *DescribeIspFlushCacheTasksResponseBody {
	s.TotalPages = &v
	return s
}

type DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks struct {
	CreateTime      *string `json:"CreateTime,omitempty" xml:"CreateTime,omitempty"`
	CreateTimestamp *int64  `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	DomainName      *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	InstanceId      *string `json:"InstanceId,omitempty" xml:"InstanceId,omitempty"`
	InstanceName    *string `json:"InstanceName,omitempty" xml:"InstanceName,omitempty"`
	Isp             *string `json:"Isp,omitempty" xml:"Isp,omitempty"`
	TaskId          *string `json:"TaskId,omitempty" xml:"TaskId,omitempty"`
	TaskStatus      *string `json:"TaskStatus,omitempty" xml:"TaskStatus,omitempty"`
}

func (s DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetCreateTime(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.CreateTime = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetCreateTimestamp(v int64) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetDomainName(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.DomainName = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetInstanceId(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.InstanceId = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetInstanceName(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.InstanceName = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetIsp(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.Isp = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetTaskId(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.TaskId = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks) SetTaskStatus(v string) *DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks {
	s.TaskStatus = &v
	return s
}

type DescribeIspFlushCacheTasksResponse struct {
	Headers    map[string]*string                      `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                  `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribeIspFlushCacheTasksResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribeIspFlushCacheTasksResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribeIspFlushCacheTasksResponse) GoString() string {
	return s.String()
}

func (s *DescribeIspFlushCacheTasksResponse) SetHeaders(v map[string]*string) *DescribeIspFlushCacheTasksResponse {
	s.Headers = v
	return s
}

func (s *DescribeIspFlushCacheTasksResponse) SetStatusCode(v int32) *DescribeIspFlushCacheTasksResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribeIspFlushCacheTasksResponse) SetBody(v *DescribeIspFlushCacheTasksResponseBody) *DescribeIspFlushCacheTasksResponse {
	s.Body = v
	return s
}

type DescribePdnsAccountSummaryRequest struct {
	EndDate   *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	Lang      *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribePdnsAccountSummaryRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAccountSummaryRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsAccountSummaryRequest) SetEndDate(v string) *DescribePdnsAccountSummaryRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsAccountSummaryRequest) SetLang(v string) *DescribePdnsAccountSummaryRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsAccountSummaryRequest) SetStartDate(v string) *DescribePdnsAccountSummaryRequest {
	s.StartDate = &v
	return s
}

type DescribePdnsAccountSummaryResponseBody struct {
	Data      *DescribePdnsAccountSummaryResponseBodyData `json:"Data,omitempty" xml:"Data,omitempty" type:"Struct"`
	RequestId *string                                     `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribePdnsAccountSummaryResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAccountSummaryResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsAccountSummaryResponseBody) SetData(v *DescribePdnsAccountSummaryResponseBodyData) *DescribePdnsAccountSummaryResponseBody {
	s.Data = v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBody) SetRequestId(v string) *DescribePdnsAccountSummaryResponseBody {
	s.RequestId = &v
	return s
}

type DescribePdnsAccountSummaryResponseBodyData struct {
	DomainCount    *int64 `json:"DomainCount,omitempty" xml:"DomainCount,omitempty"`
	HttpCount      *int64 `json:"HttpCount,omitempty" xml:"HttpCount,omitempty"`
	HttpsCount     *int64 `json:"HttpsCount,omitempty" xml:"HttpsCount,omitempty"`
	SubDomainCount *int64 `json:"SubDomainCount,omitempty" xml:"SubDomainCount,omitempty"`
	ThreatCount    *int64 `json:"ThreatCount,omitempty" xml:"ThreatCount,omitempty"`
	TotalCount     *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	UserId         *int64 `json:"UserId,omitempty" xml:"UserId,omitempty"`
}

func (s DescribePdnsAccountSummaryResponseBodyData) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAccountSummaryResponseBodyData) GoString() string {
	return s.String()
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetDomainCount(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.DomainCount = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetHttpCount(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.HttpCount = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetHttpsCount(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.HttpsCount = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetSubDomainCount(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.SubDomainCount = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetThreatCount(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.ThreatCount = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetTotalCount(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.TotalCount = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponseBodyData) SetUserId(v int64) *DescribePdnsAccountSummaryResponseBodyData {
	s.UserId = &v
	return s
}

type DescribePdnsAccountSummaryResponse struct {
	Headers    map[string]*string                      `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                  `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsAccountSummaryResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsAccountSummaryResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAccountSummaryResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsAccountSummaryResponse) SetHeaders(v map[string]*string) *DescribePdnsAccountSummaryResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsAccountSummaryResponse) SetStatusCode(v int32) *DescribePdnsAccountSummaryResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsAccountSummaryResponse) SetBody(v *DescribePdnsAccountSummaryResponseBody) *DescribePdnsAccountSummaryResponse {
	s.Body = v
	return s
}

type DescribePdnsAppKeyRequest struct {
	AppKeyId *string `json:"AppKeyId,omitempty" xml:"AppKeyId,omitempty"`
	AuthCode *string `json:"AuthCode,omitempty" xml:"AuthCode,omitempty"`
	Lang     *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribePdnsAppKeyRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeyRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeyRequest) SetAppKeyId(v string) *DescribePdnsAppKeyRequest {
	s.AppKeyId = &v
	return s
}

func (s *DescribePdnsAppKeyRequest) SetAuthCode(v string) *DescribePdnsAppKeyRequest {
	s.AuthCode = &v
	return s
}

func (s *DescribePdnsAppKeyRequest) SetLang(v string) *DescribePdnsAppKeyRequest {
	s.Lang = &v
	return s
}

type DescribePdnsAppKeyResponseBody struct {
	AppKey    *DescribePdnsAppKeyResponseBodyAppKey `json:"AppKey,omitempty" xml:"AppKey,omitempty" type:"Struct"`
	RequestId *string                               `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribePdnsAppKeyResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeyResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeyResponseBody) SetAppKey(v *DescribePdnsAppKeyResponseBodyAppKey) *DescribePdnsAppKeyResponseBody {
	s.AppKey = v
	return s
}

func (s *DescribePdnsAppKeyResponseBody) SetRequestId(v string) *DescribePdnsAppKeyResponseBody {
	s.RequestId = &v
	return s
}

type DescribePdnsAppKeyResponseBodyAppKey struct {
	AppKeyId        *string `json:"AppKeyId,omitempty" xml:"AppKeyId,omitempty"`
	AppKeySecret    *string `json:"AppKeySecret,omitempty" xml:"AppKeySecret,omitempty"`
	CreateDate      *string `json:"CreateDate,omitempty" xml:"CreateDate,omitempty"`
	CreateTimestamp *int64  `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	Remark          *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	State           *string `json:"State,omitempty" xml:"State,omitempty"`
}

func (s DescribePdnsAppKeyResponseBodyAppKey) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeyResponseBodyAppKey) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeyResponseBodyAppKey) SetAppKeyId(v string) *DescribePdnsAppKeyResponseBodyAppKey {
	s.AppKeyId = &v
	return s
}

func (s *DescribePdnsAppKeyResponseBodyAppKey) SetAppKeySecret(v string) *DescribePdnsAppKeyResponseBodyAppKey {
	s.AppKeySecret = &v
	return s
}

func (s *DescribePdnsAppKeyResponseBodyAppKey) SetCreateDate(v string) *DescribePdnsAppKeyResponseBodyAppKey {
	s.CreateDate = &v
	return s
}

func (s *DescribePdnsAppKeyResponseBodyAppKey) SetCreateTimestamp(v int64) *DescribePdnsAppKeyResponseBodyAppKey {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribePdnsAppKeyResponseBodyAppKey) SetRemark(v string) *DescribePdnsAppKeyResponseBodyAppKey {
	s.Remark = &v
	return s
}

func (s *DescribePdnsAppKeyResponseBodyAppKey) SetState(v string) *DescribePdnsAppKeyResponseBodyAppKey {
	s.State = &v
	return s
}

type DescribePdnsAppKeyResponse struct {
	Headers    map[string]*string              `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                          `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsAppKeyResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsAppKeyResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeyResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeyResponse) SetHeaders(v map[string]*string) *DescribePdnsAppKeyResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsAppKeyResponse) SetStatusCode(v int32) *DescribePdnsAppKeyResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsAppKeyResponse) SetBody(v *DescribePdnsAppKeyResponseBody) *DescribePdnsAppKeyResponse {
	s.Body = v
	return s
}

type DescribePdnsAppKeysRequest struct {
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribePdnsAppKeysRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeysRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeysRequest) SetLang(v string) *DescribePdnsAppKeysRequest {
	s.Lang = &v
	return s
}

type DescribePdnsAppKeysResponseBody struct {
	AppKeys   []*DescribePdnsAppKeysResponseBodyAppKeys `json:"AppKeys,omitempty" xml:"AppKeys,omitempty" type:"Repeated"`
	RequestId *string                                   `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribePdnsAppKeysResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeysResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeysResponseBody) SetAppKeys(v []*DescribePdnsAppKeysResponseBodyAppKeys) *DescribePdnsAppKeysResponseBody {
	s.AppKeys = v
	return s
}

func (s *DescribePdnsAppKeysResponseBody) SetRequestId(v string) *DescribePdnsAppKeysResponseBody {
	s.RequestId = &v
	return s
}

type DescribePdnsAppKeysResponseBodyAppKeys struct {
	AppKeyId        *string `json:"AppKeyId,omitempty" xml:"AppKeyId,omitempty"`
	CreateDate      *string `json:"CreateDate,omitempty" xml:"CreateDate,omitempty"`
	CreateTimestamp *int64  `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	Remark          *string `json:"Remark,omitempty" xml:"Remark,omitempty"`
	State           *string `json:"State,omitempty" xml:"State,omitempty"`
}

func (s DescribePdnsAppKeysResponseBodyAppKeys) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeysResponseBodyAppKeys) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeysResponseBodyAppKeys) SetAppKeyId(v string) *DescribePdnsAppKeysResponseBodyAppKeys {
	s.AppKeyId = &v
	return s
}

func (s *DescribePdnsAppKeysResponseBodyAppKeys) SetCreateDate(v string) *DescribePdnsAppKeysResponseBodyAppKeys {
	s.CreateDate = &v
	return s
}

func (s *DescribePdnsAppKeysResponseBodyAppKeys) SetCreateTimestamp(v int64) *DescribePdnsAppKeysResponseBodyAppKeys {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribePdnsAppKeysResponseBodyAppKeys) SetRemark(v string) *DescribePdnsAppKeysResponseBodyAppKeys {
	s.Remark = &v
	return s
}

func (s *DescribePdnsAppKeysResponseBodyAppKeys) SetState(v string) *DescribePdnsAppKeysResponseBodyAppKeys {
	s.State = &v
	return s
}

type DescribePdnsAppKeysResponse struct {
	Headers    map[string]*string               `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                           `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsAppKeysResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsAppKeysResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsAppKeysResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsAppKeysResponse) SetHeaders(v map[string]*string) *DescribePdnsAppKeysResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsAppKeysResponse) SetStatusCode(v int32) *DescribePdnsAppKeysResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsAppKeysResponse) SetBody(v *DescribePdnsAppKeysResponseBody) *DescribePdnsAppKeysResponse {
	s.Body = v
	return s
}

type DescribePdnsOperateLogsRequest struct {
	ActionType   *string `json:"ActionType,omitempty" xml:"ActionType,omitempty"`
	EndDate      *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	Keyword      *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	Lang         *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	PageNumber   *int64  `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize     *int64  `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	ResourceType *string `json:"ResourceType,omitempty" xml:"ResourceType,omitempty"`
	StartDate    *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
}

func (s DescribePdnsOperateLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsOperateLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsOperateLogsRequest) SetActionType(v string) *DescribePdnsOperateLogsRequest {
	s.ActionType = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetEndDate(v string) *DescribePdnsOperateLogsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetKeyword(v string) *DescribePdnsOperateLogsRequest {
	s.Keyword = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetLang(v string) *DescribePdnsOperateLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetPageNumber(v int64) *DescribePdnsOperateLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetPageSize(v int64) *DescribePdnsOperateLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetResourceType(v string) *DescribePdnsOperateLogsRequest {
	s.ResourceType = &v
	return s
}

func (s *DescribePdnsOperateLogsRequest) SetStartDate(v string) *DescribePdnsOperateLogsRequest {
	s.StartDate = &v
	return s
}

type DescribePdnsOperateLogsResponseBody struct {
	Logs       []*DescribePdnsOperateLogsResponseBodyLogs `json:"Logs,omitempty" xml:"Logs,omitempty" type:"Repeated"`
	PageNumber *int64                                     `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int64                                     `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	RequestId  *string                                    `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TotalCount *int64                                     `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribePdnsOperateLogsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsOperateLogsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsOperateLogsResponseBody) SetLogs(v []*DescribePdnsOperateLogsResponseBodyLogs) *DescribePdnsOperateLogsResponseBody {
	s.Logs = v
	return s
}

func (s *DescribePdnsOperateLogsResponseBody) SetPageNumber(v int64) *DescribePdnsOperateLogsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsOperateLogsResponseBody) SetPageSize(v int64) *DescribePdnsOperateLogsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsOperateLogsResponseBody) SetRequestId(v string) *DescribePdnsOperateLogsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribePdnsOperateLogsResponseBody) SetTotalCount(v int64) *DescribePdnsOperateLogsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribePdnsOperateLogsResponseBodyLogs struct {
	Action      *string `json:"Action,omitempty" xml:"Action,omitempty"`
	OperateTime *string `json:"OperateTime,omitempty" xml:"OperateTime,omitempty"`
	Type        *string `json:"Type,omitempty" xml:"Type,omitempty"`
	Content     *string `json:"content,omitempty" xml:"content,omitempty"`
}

func (s DescribePdnsOperateLogsResponseBodyLogs) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsOperateLogsResponseBodyLogs) GoString() string {
	return s.String()
}

func (s *DescribePdnsOperateLogsResponseBodyLogs) SetAction(v string) *DescribePdnsOperateLogsResponseBodyLogs {
	s.Action = &v
	return s
}

func (s *DescribePdnsOperateLogsResponseBodyLogs) SetOperateTime(v string) *DescribePdnsOperateLogsResponseBodyLogs {
	s.OperateTime = &v
	return s
}

func (s *DescribePdnsOperateLogsResponseBodyLogs) SetType(v string) *DescribePdnsOperateLogsResponseBodyLogs {
	s.Type = &v
	return s
}

func (s *DescribePdnsOperateLogsResponseBodyLogs) SetContent(v string) *DescribePdnsOperateLogsResponseBodyLogs {
	s.Content = &v
	return s
}

type DescribePdnsOperateLogsResponse struct {
	Headers    map[string]*string                   `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                               `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsOperateLogsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsOperateLogsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsOperateLogsResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsOperateLogsResponse) SetHeaders(v map[string]*string) *DescribePdnsOperateLogsResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsOperateLogsResponse) SetStatusCode(v int32) *DescribePdnsOperateLogsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsOperateLogsResponse) SetBody(v *DescribePdnsOperateLogsResponseBody) *DescribePdnsOperateLogsResponse {
	s.Body = v
	return s
}

type DescribePdnsRequestStatisticRequest struct {
	// The primary domain name whose statistics you want to query.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The end of the time range to query. Specify the time in the **YYYY-MM-DD*	- format.
	//
	// The default value is the day when you query the data.
	//
	// example:
	//
	// 2024-7-1 00:00:00
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// zh
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The beginning of the time range to query. Specify the time in the **YYYY-MM-DD*	- format.
	//
	// You can query only records of the last 90 days.
	//
	// example:
	//
	// 2024-06-14 00:00:00
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The subdomain name whose statistics you want to query.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	// The type of the request statistics that you want to query. Valid values:
	//
	// 	- **ACCOUNT**: queries the request statistics by account.
	//
	// 	- **DOMAIN**: queries the request statistics by domain name.
	//
	// 	- **SUB_DOMAIN**: queries the request statistics by subdomain name.
	//
	// example:
	//
	// ACCOUNT
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribePdnsRequestStatisticRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticRequest) SetDomainName(v string) *DescribePdnsRequestStatisticRequest {
	s.DomainName = &v
	return s
}

func (s *DescribePdnsRequestStatisticRequest) SetEndDate(v string) *DescribePdnsRequestStatisticRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsRequestStatisticRequest) SetLang(v string) *DescribePdnsRequestStatisticRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsRequestStatisticRequest) SetStartDate(v string) *DescribePdnsRequestStatisticRequest {
	s.StartDate = &v
	return s
}

func (s *DescribePdnsRequestStatisticRequest) SetSubDomain(v string) *DescribePdnsRequestStatisticRequest {
	s.SubDomain = &v
	return s
}

func (s *DescribePdnsRequestStatisticRequest) SetType(v string) *DescribePdnsRequestStatisticRequest {
	s.Type = &v
	return s
}

type DescribePdnsRequestStatisticResponseBody struct {
	// The statistics on the DNS requests.
	Data []*DescribePdnsRequestStatisticResponseBodyData `json:"Data,omitempty" xml:"Data,omitempty" type:"Repeated"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribePdnsRequestStatisticResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticResponseBody) SetData(v []*DescribePdnsRequestStatisticResponseBodyData) *DescribePdnsRequestStatisticResponseBody {
	s.Data = v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBody) SetRequestId(v string) *DescribePdnsRequestStatisticResponseBody {
	s.RequestId = &v
	return s
}

type DescribePdnsRequestStatisticResponseBodyData struct {
	// The total number of DoH requests, including HTTP and HTTPS requests.
	//
	// example:
	//
	// 0
	DohTotalCount *int64 `json:"DohTotalCount,omitempty" xml:"DohTotalCount,omitempty"`
	// The number of HTTP requests.
	//
	// example:
	//
	// 0
	HttpCount *int64 `json:"HttpCount,omitempty" xml:"HttpCount,omitempty"`
	// The number of HTTPS requests. On the Traffic Analysis tab of the Public DNS console, the value of this parameter includes the number of DNS over HTTPs (DoH) requests. Therefore, the number of DoH requests is not separately displayed in the console.
	//
	// example:
	//
	// 0
	HttpsCount *int64 `json:"HttpsCount,omitempty" xml:"HttpsCount,omitempty"`
	// The number of source IP addresses.
	//
	// example:
	//
	// 10
	IpCount *int64 `json:"IpCount,omitempty" xml:"IpCount,omitempty"`
	// The statistical timestamp. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
	//
	// example:
	//
	// 1706716800000
	Timestamp *int64 `json:"Timestamp,omitempty" xml:"Timestamp,omitempty"`
	// The total number of requests.
	//
	// example:
	//
	// 0
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The total number of UDP requests.
	//
	// example:
	//
	// 5000
	UdpTotalCount *int64 `json:"UdpTotalCount,omitempty" xml:"UdpTotalCount,omitempty"`
	// The number of IPv4-based requests.
	//
	// example:
	//
	// 0
	V4Count *int64 `json:"V4Count,omitempty" xml:"V4Count,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 0
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 0
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based requests.
	//
	// example:
	//
	// 0
	V6Count *int64 `json:"V6Count,omitempty" xml:"V6Count,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 0
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 0
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribePdnsRequestStatisticResponseBodyData) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticResponseBodyData) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetDohTotalCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.DohTotalCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetHttpCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.HttpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetHttpsCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.HttpsCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetIpCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.IpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetTimestamp(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.Timestamp = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetTotalCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.TotalCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetUdpTotalCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.UdpTotalCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetV4Count(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.V4Count = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetV4HttpCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.V4HttpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetV4HttpsCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetV6Count(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.V6Count = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetV6HttpCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.V6HttpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponseBodyData) SetV6HttpsCount(v int64) *DescribePdnsRequestStatisticResponseBodyData {
	s.V6HttpsCount = &v
	return s
}

type DescribePdnsRequestStatisticResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsRequestStatisticResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsRequestStatisticResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticResponse) SetHeaders(v map[string]*string) *DescribePdnsRequestStatisticResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsRequestStatisticResponse) SetStatusCode(v int32) *DescribePdnsRequestStatisticResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsRequestStatisticResponse) SetBody(v *DescribePdnsRequestStatisticResponseBody) *DescribePdnsRequestStatisticResponse {
	s.Body = v
	return s
}

type DescribePdnsRequestStatisticsRequest struct {
	// The primary domain name whose statistics you want to query.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The end of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// The default value is the day when you query the data.
	//
	// example:
	//
	// 2024-07-14 00:00:00
	EndDate *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	// The language of the content within the request and response. Default value: **zh**. Valid values:
	//
	// 	- **zh**: Chinese
	//
	// 	- **en**: English
	//
	// example:
	//
	// zh
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Default value: 20. Valid values: 1 to 100.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
	//
	// You can query only records of the last 90 days.
	//
	// example:
	//
	// 2024-06-14 00:00:00
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The subdomain name whose statistics you want to query.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	// The type of the request statistics that you want to query. Valid values:
	//
	// 	- DOMAIN: queries the request statistics by domain name.
	//
	// 	- SUB_DOMAIN: queries the request statistics by subdomain name.
	//
	// example:
	//
	// DOMAIN
	Type *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribePdnsRequestStatisticsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticsRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticsRequest) SetDomainName(v string) *DescribePdnsRequestStatisticsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetEndDate(v string) *DescribePdnsRequestStatisticsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetLang(v string) *DescribePdnsRequestStatisticsRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetPageNumber(v int64) *DescribePdnsRequestStatisticsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetPageSize(v int64) *DescribePdnsRequestStatisticsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetStartDate(v string) *DescribePdnsRequestStatisticsRequest {
	s.StartDate = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetSubDomain(v string) *DescribePdnsRequestStatisticsRequest {
	s.SubDomain = &v
	return s
}

func (s *DescribePdnsRequestStatisticsRequest) SetType(v string) *DescribePdnsRequestStatisticsRequest {
	s.Type = &v
	return s
}

type DescribePdnsRequestStatisticsResponseBody struct {
	// The statistics on the DNS requests.
	Data []*DescribePdnsRequestStatisticsResponseBodyData `json:"Data,omitempty" xml:"Data,omitempty" type:"Repeated"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Default value: **20**. Valid values: **1 to 100**.
	//
	// example:
	//
	// 10
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 49
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribePdnsRequestStatisticsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticsResponseBody) SetData(v []*DescribePdnsRequestStatisticsResponseBodyData) *DescribePdnsRequestStatisticsResponseBody {
	s.Data = v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBody) SetPageNumber(v int64) *DescribePdnsRequestStatisticsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBody) SetPageSize(v int64) *DescribePdnsRequestStatisticsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBody) SetRequestId(v string) *DescribePdnsRequestStatisticsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBody) SetTotalCount(v int64) *DescribePdnsRequestStatisticsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribePdnsRequestStatisticsResponseBodyData struct {
	// The total number of DoH requests, including the HTTP and HTTPS requests.
	//
	// example:
	//
	// 0
	DohTotalCount *int64 `json:"DohTotalCount,omitempty" xml:"DohTotalCount,omitempty"`
	// The domain name.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The number of HTTP requests.
	//
	// example:
	//
	// 0
	HttpCount *int64 `json:"HttpCount,omitempty" xml:"HttpCount,omitempty"`
	// The number of HTTPS requests. On the Traffic Analysis tab of the public DNS console, the value of this parameter includes the number of DNS over HTTPs (DoH) requests. Therefore, the number of DoH requests is not separately displayed in the console.
	//
	// example:
	//
	// 0
	HttpsCount *int64 `json:"HttpsCount,omitempty" xml:"HttpsCount,omitempty"`
	// The number of source IP addresses.
	//
	// example:
	//
	// 10
	IpCount *int64 `json:"IpCount,omitempty" xml:"IpCount,omitempty"`
	// The current version does not support this parameter.
	//
	// example:
	//
	// -
	MaxThreatLevel *string `json:"MaxThreatLevel,omitempty" xml:"MaxThreatLevel,omitempty"`
	// The subdomain name.
	//
	// example:
	//
	// www.example.com
	SubDomain *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	// The current version does not support this parameter.
	//
	// example:
	//
	// -
	ThreatCount *int64 `json:"ThreatCount,omitempty" xml:"ThreatCount,omitempty"`
	// The current version does not support this parameter.
	ThreatInfo []*DescribePdnsRequestStatisticsResponseBodyDataThreatInfo `json:"ThreatInfo,omitempty" xml:"ThreatInfo,omitempty" type:"Repeated"`
	// The total number of requests.
	//
	// example:
	//
	// 500
	TotalCount *int64 `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	// The total number of UDP requests.
	//
	// example:
	//
	// 500
	UdpTotalCount *int64 `json:"UdpTotalCount,omitempty" xml:"UdpTotalCount,omitempty"`
	// The number of IPv4-based requests.
	//
	// example:
	//
	// 0
	V4Count *int64 `json:"V4Count,omitempty" xml:"V4Count,omitempty"`
	// The number of IPv4-based HTTP requests.
	//
	// example:
	//
	// 0
	V4HttpCount *int64 `json:"V4HttpCount,omitempty" xml:"V4HttpCount,omitempty"`
	// The number of IPv4-based HTTPS requests.
	//
	// example:
	//
	// 0
	V4HttpsCount *int64 `json:"V4HttpsCount,omitempty" xml:"V4HttpsCount,omitempty"`
	// The number of IPv6-based requests.
	//
	// example:
	//
	// 0
	V6Count *int64 `json:"V6Count,omitempty" xml:"V6Count,omitempty"`
	// The number of IPv6-based HTTP requests.
	//
	// example:
	//
	// 0
	V6HttpCount *int64 `json:"V6HttpCount,omitempty" xml:"V6HttpCount,omitempty"`
	// The number of IPv6-based HTTPS requests.
	//
	// example:
	//
	// 0
	V6HttpsCount *int64 `json:"V6HttpsCount,omitempty" xml:"V6HttpsCount,omitempty"`
}

func (s DescribePdnsRequestStatisticsResponseBodyData) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticsResponseBodyData) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetDohTotalCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.DohTotalCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetDomainName(v string) *DescribePdnsRequestStatisticsResponseBodyData {
	s.DomainName = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetHttpCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.HttpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetHttpsCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.HttpsCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetIpCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.IpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetMaxThreatLevel(v string) *DescribePdnsRequestStatisticsResponseBodyData {
	s.MaxThreatLevel = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetSubDomain(v string) *DescribePdnsRequestStatisticsResponseBodyData {
	s.SubDomain = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetThreatCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.ThreatCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetThreatInfo(v []*DescribePdnsRequestStatisticsResponseBodyDataThreatInfo) *DescribePdnsRequestStatisticsResponseBodyData {
	s.ThreatInfo = v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetTotalCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.TotalCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetUdpTotalCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.UdpTotalCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetV4Count(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.V4Count = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetV4HttpCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.V4HttpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetV4HttpsCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.V4HttpsCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetV6Count(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.V6Count = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetV6HttpCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.V6HttpCount = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyData) SetV6HttpsCount(v int64) *DescribePdnsRequestStatisticsResponseBodyData {
	s.V6HttpsCount = &v
	return s
}

type DescribePdnsRequestStatisticsResponseBodyDataThreatInfo struct {
	// The current version does not support this parameter.
	//
	// example:
	//
	// -
	ThreatLevel *string `json:"ThreatLevel,omitempty" xml:"ThreatLevel,omitempty"`
	// The current version does not support this parameter.
	//
	// example:
	//
	// -
	ThreatType *string `json:"ThreatType,omitempty" xml:"ThreatType,omitempty"`
}

func (s DescribePdnsRequestStatisticsResponseBodyDataThreatInfo) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticsResponseBodyDataThreatInfo) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticsResponseBodyDataThreatInfo) SetThreatLevel(v string) *DescribePdnsRequestStatisticsResponseBodyDataThreatInfo {
	s.ThreatLevel = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponseBodyDataThreatInfo) SetThreatType(v string) *DescribePdnsRequestStatisticsResponseBodyDataThreatInfo {
	s.ThreatType = &v
	return s
}

type DescribePdnsRequestStatisticsResponse struct {
	Headers    map[string]*string                         `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                     `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsRequestStatisticsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsRequestStatisticsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsRequestStatisticsResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsRequestStatisticsResponse) SetHeaders(v map[string]*string) *DescribePdnsRequestStatisticsResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsRequestStatisticsResponse) SetStatusCode(v int32) *DescribePdnsRequestStatisticsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsRequestStatisticsResponse) SetBody(v *DescribePdnsRequestStatisticsResponseBody) *DescribePdnsRequestStatisticsResponse {
	s.Body = v
	return s
}

type DescribePdnsThreatLogsRequest struct {
	EndDate        *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	Keyword        *string `json:"Keyword,omitempty" xml:"Keyword,omitempty"`
	Lang           *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	PageNumber     *int64  `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize       *int64  `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	StartDate      *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	ThreatLevel    *string `json:"ThreatLevel,omitempty" xml:"ThreatLevel,omitempty"`
	ThreatSourceIp *string `json:"ThreatSourceIp,omitempty" xml:"ThreatSourceIp,omitempty"`
	ThreatType     *string `json:"ThreatType,omitempty" xml:"ThreatType,omitempty"`
}

func (s DescribePdnsThreatLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatLogsRequest) SetEndDate(v string) *DescribePdnsThreatLogsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetKeyword(v string) *DescribePdnsThreatLogsRequest {
	s.Keyword = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetLang(v string) *DescribePdnsThreatLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetPageNumber(v int64) *DescribePdnsThreatLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetPageSize(v int64) *DescribePdnsThreatLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetStartDate(v string) *DescribePdnsThreatLogsRequest {
	s.StartDate = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetThreatLevel(v string) *DescribePdnsThreatLogsRequest {
	s.ThreatLevel = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetThreatSourceIp(v string) *DescribePdnsThreatLogsRequest {
	s.ThreatSourceIp = &v
	return s
}

func (s *DescribePdnsThreatLogsRequest) SetThreatType(v string) *DescribePdnsThreatLogsRequest {
	s.ThreatType = &v
	return s
}

type DescribePdnsThreatLogsResponseBody struct {
	Logs       []*DescribePdnsThreatLogsResponseBodyLogs `json:"Logs,omitempty" xml:"Logs,omitempty" type:"Repeated"`
	PageNumber *int64                                    `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int64                                    `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	RequestId  *string                                   `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TotalCount *int64                                    `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribePdnsThreatLogsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatLogsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatLogsResponseBody) SetLogs(v []*DescribePdnsThreatLogsResponseBodyLogs) *DescribePdnsThreatLogsResponseBody {
	s.Logs = v
	return s
}

func (s *DescribePdnsThreatLogsResponseBody) SetPageNumber(v int64) *DescribePdnsThreatLogsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBody) SetPageSize(v int64) *DescribePdnsThreatLogsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBody) SetRequestId(v string) *DescribePdnsThreatLogsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBody) SetTotalCount(v int64) *DescribePdnsThreatLogsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribePdnsThreatLogsResponseBodyLogs struct {
	SourceIp    *string `json:"SourceIp,omitempty" xml:"SourceIp,omitempty"`
	SubDomain   *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	ThreatLevel *string `json:"ThreatLevel,omitempty" xml:"ThreatLevel,omitempty"`
	ThreatTime  *string `json:"ThreatTime,omitempty" xml:"ThreatTime,omitempty"`
	ThreatType  *string `json:"ThreatType,omitempty" xml:"ThreatType,omitempty"`
}

func (s DescribePdnsThreatLogsResponseBodyLogs) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatLogsResponseBodyLogs) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatLogsResponseBodyLogs) SetSourceIp(v string) *DescribePdnsThreatLogsResponseBodyLogs {
	s.SourceIp = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBodyLogs) SetSubDomain(v string) *DescribePdnsThreatLogsResponseBodyLogs {
	s.SubDomain = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBodyLogs) SetThreatLevel(v string) *DescribePdnsThreatLogsResponseBodyLogs {
	s.ThreatLevel = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBodyLogs) SetThreatTime(v string) *DescribePdnsThreatLogsResponseBodyLogs {
	s.ThreatTime = &v
	return s
}

func (s *DescribePdnsThreatLogsResponseBodyLogs) SetThreatType(v string) *DescribePdnsThreatLogsResponseBodyLogs {
	s.ThreatType = &v
	return s
}

type DescribePdnsThreatLogsResponse struct {
	Headers    map[string]*string                  `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                              `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsThreatLogsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsThreatLogsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatLogsResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatLogsResponse) SetHeaders(v map[string]*string) *DescribePdnsThreatLogsResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsThreatLogsResponse) SetStatusCode(v int32) *DescribePdnsThreatLogsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsThreatLogsResponse) SetBody(v *DescribePdnsThreatLogsResponseBody) *DescribePdnsThreatLogsResponse {
	s.Body = v
	return s
}

type DescribePdnsThreatStatisticRequest struct {
	EndDate        *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	Lang           *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	StartDate      *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	ThreatSourceIp *string `json:"ThreatSourceIp,omitempty" xml:"ThreatSourceIp,omitempty"`
}

func (s DescribePdnsThreatStatisticRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticRequest) SetEndDate(v string) *DescribePdnsThreatStatisticRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsThreatStatisticRequest) SetLang(v string) *DescribePdnsThreatStatisticRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsThreatStatisticRequest) SetStartDate(v string) *DescribePdnsThreatStatisticRequest {
	s.StartDate = &v
	return s
}

func (s *DescribePdnsThreatStatisticRequest) SetThreatSourceIp(v string) *DescribePdnsThreatStatisticRequest {
	s.ThreatSourceIp = &v
	return s
}

type DescribePdnsThreatStatisticResponseBody struct {
	Data      []*DescribePdnsThreatStatisticResponseBodyData `json:"Data,omitempty" xml:"Data,omitempty" type:"Repeated"`
	RequestId *string                                        `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
}

func (s DescribePdnsThreatStatisticResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticResponseBody) SetData(v []*DescribePdnsThreatStatisticResponseBodyData) *DescribePdnsThreatStatisticResponseBody {
	s.Data = v
	return s
}

func (s *DescribePdnsThreatStatisticResponseBody) SetRequestId(v string) *DescribePdnsThreatStatisticResponseBody {
	s.RequestId = &v
	return s
}

type DescribePdnsThreatStatisticResponseBodyData struct {
	DohTotalCount *int64  `json:"DohTotalCount,omitempty" xml:"DohTotalCount,omitempty"`
	ThreatLevel   *string `json:"ThreatLevel,omitempty" xml:"ThreatLevel,omitempty"`
	ThreatType    *string `json:"ThreatType,omitempty" xml:"ThreatType,omitempty"`
	Timestamp     *int64  `json:"Timestamp,omitempty" xml:"Timestamp,omitempty"`
	TotalCount    *int64  `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	UdpTotalCount *int64  `json:"UdpTotalCount,omitempty" xml:"UdpTotalCount,omitempty"`
}

func (s DescribePdnsThreatStatisticResponseBodyData) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticResponseBodyData) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticResponseBodyData) SetDohTotalCount(v int64) *DescribePdnsThreatStatisticResponseBodyData {
	s.DohTotalCount = &v
	return s
}

func (s *DescribePdnsThreatStatisticResponseBodyData) SetThreatLevel(v string) *DescribePdnsThreatStatisticResponseBodyData {
	s.ThreatLevel = &v
	return s
}

func (s *DescribePdnsThreatStatisticResponseBodyData) SetThreatType(v string) *DescribePdnsThreatStatisticResponseBodyData {
	s.ThreatType = &v
	return s
}

func (s *DescribePdnsThreatStatisticResponseBodyData) SetTimestamp(v int64) *DescribePdnsThreatStatisticResponseBodyData {
	s.Timestamp = &v
	return s
}

func (s *DescribePdnsThreatStatisticResponseBodyData) SetTotalCount(v int64) *DescribePdnsThreatStatisticResponseBodyData {
	s.TotalCount = &v
	return s
}

func (s *DescribePdnsThreatStatisticResponseBodyData) SetUdpTotalCount(v int64) *DescribePdnsThreatStatisticResponseBodyData {
	s.UdpTotalCount = &v
	return s
}

type DescribePdnsThreatStatisticResponse struct {
	Headers    map[string]*string                       `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                   `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsThreatStatisticResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsThreatStatisticResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticResponse) SetHeaders(v map[string]*string) *DescribePdnsThreatStatisticResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsThreatStatisticResponse) SetStatusCode(v int32) *DescribePdnsThreatStatisticResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsThreatStatisticResponse) SetBody(v *DescribePdnsThreatStatisticResponseBody) *DescribePdnsThreatStatisticResponse {
	s.Body = v
	return s
}

type DescribePdnsThreatStatisticsRequest struct {
	Direction      *string `json:"Direction,omitempty" xml:"Direction,omitempty"`
	DomainName     *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	EndDate        *string `json:"EndDate,omitempty" xml:"EndDate,omitempty"`
	Lang           *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	OrderBy        *string `json:"OrderBy,omitempty" xml:"OrderBy,omitempty"`
	PageNumber     *int64  `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize       *int64  `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	StartDate      *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	SubDomain      *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	ThreatLevel    *string `json:"ThreatLevel,omitempty" xml:"ThreatLevel,omitempty"`
	ThreatSourceIp *string `json:"ThreatSourceIp,omitempty" xml:"ThreatSourceIp,omitempty"`
	ThreatType     *string `json:"ThreatType,omitempty" xml:"ThreatType,omitempty"`
	Type           *string `json:"Type,omitempty" xml:"Type,omitempty"`
}

func (s DescribePdnsThreatStatisticsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticsRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticsRequest) SetDirection(v string) *DescribePdnsThreatStatisticsRequest {
	s.Direction = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetDomainName(v string) *DescribePdnsThreatStatisticsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetEndDate(v string) *DescribePdnsThreatStatisticsRequest {
	s.EndDate = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetLang(v string) *DescribePdnsThreatStatisticsRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetOrderBy(v string) *DescribePdnsThreatStatisticsRequest {
	s.OrderBy = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetPageNumber(v int64) *DescribePdnsThreatStatisticsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetPageSize(v int64) *DescribePdnsThreatStatisticsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetStartDate(v string) *DescribePdnsThreatStatisticsRequest {
	s.StartDate = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetSubDomain(v string) *DescribePdnsThreatStatisticsRequest {
	s.SubDomain = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetThreatLevel(v string) *DescribePdnsThreatStatisticsRequest {
	s.ThreatLevel = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetThreatSourceIp(v string) *DescribePdnsThreatStatisticsRequest {
	s.ThreatSourceIp = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetThreatType(v string) *DescribePdnsThreatStatisticsRequest {
	s.ThreatType = &v
	return s
}

func (s *DescribePdnsThreatStatisticsRequest) SetType(v string) *DescribePdnsThreatStatisticsRequest {
	s.Type = &v
	return s
}

type DescribePdnsThreatStatisticsResponseBody struct {
	Data       []*DescribePdnsThreatStatisticsResponseBodyData `json:"Data,omitempty" xml:"Data,omitempty" type:"Repeated"`
	PageNumber *int64                                          `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int64                                          `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	RequestId  *string                                         `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TotalCount *int64                                          `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
}

func (s DescribePdnsThreatStatisticsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticsResponseBody) SetData(v []*DescribePdnsThreatStatisticsResponseBodyData) *DescribePdnsThreatStatisticsResponseBody {
	s.Data = v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBody) SetPageNumber(v int64) *DescribePdnsThreatStatisticsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBody) SetPageSize(v int64) *DescribePdnsThreatStatisticsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBody) SetRequestId(v string) *DescribePdnsThreatStatisticsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBody) SetTotalCount(v int64) *DescribePdnsThreatStatisticsResponseBody {
	s.TotalCount = &v
	return s
}

type DescribePdnsThreatStatisticsResponseBodyData struct {
	DohTotalCount    *int64  `json:"DohTotalCount,omitempty" xml:"DohTotalCount,omitempty"`
	DomainCount      *int64  `json:"DomainCount,omitempty" xml:"DomainCount,omitempty"`
	DomainName       *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	LatestThreatTime *int64  `json:"LatestThreatTime,omitempty" xml:"LatestThreatTime,omitempty"`
	MaxThreatLevel   *string `json:"MaxThreatLevel,omitempty" xml:"MaxThreatLevel,omitempty"`
	SourceIp         *string `json:"SourceIp,omitempty" xml:"SourceIp,omitempty"`
	SubDomain        *string `json:"SubDomain,omitempty" xml:"SubDomain,omitempty"`
	ThreatLevel      *string `json:"ThreatLevel,omitempty" xml:"ThreatLevel,omitempty"`
	ThreatType       *string `json:"ThreatType,omitempty" xml:"ThreatType,omitempty"`
	TotalCount       *int64  `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	UdpTotalCount    *int64  `json:"UdpTotalCount,omitempty" xml:"UdpTotalCount,omitempty"`
}

func (s DescribePdnsThreatStatisticsResponseBodyData) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticsResponseBodyData) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetDohTotalCount(v int64) *DescribePdnsThreatStatisticsResponseBodyData {
	s.DohTotalCount = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetDomainCount(v int64) *DescribePdnsThreatStatisticsResponseBodyData {
	s.DomainCount = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetDomainName(v string) *DescribePdnsThreatStatisticsResponseBodyData {
	s.DomainName = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetLatestThreatTime(v int64) *DescribePdnsThreatStatisticsResponseBodyData {
	s.LatestThreatTime = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetMaxThreatLevel(v string) *DescribePdnsThreatStatisticsResponseBodyData {
	s.MaxThreatLevel = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetSourceIp(v string) *DescribePdnsThreatStatisticsResponseBodyData {
	s.SourceIp = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetSubDomain(v string) *DescribePdnsThreatStatisticsResponseBodyData {
	s.SubDomain = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetThreatLevel(v string) *DescribePdnsThreatStatisticsResponseBodyData {
	s.ThreatLevel = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetThreatType(v string) *DescribePdnsThreatStatisticsResponseBodyData {
	s.ThreatType = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetTotalCount(v int64) *DescribePdnsThreatStatisticsResponseBodyData {
	s.TotalCount = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponseBodyData) SetUdpTotalCount(v int64) *DescribePdnsThreatStatisticsResponseBodyData {
	s.UdpTotalCount = &v
	return s
}

type DescribePdnsThreatStatisticsResponse struct {
	Headers    map[string]*string                        `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                    `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsThreatStatisticsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsThreatStatisticsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsThreatStatisticsResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsThreatStatisticsResponse) SetHeaders(v map[string]*string) *DescribePdnsThreatStatisticsResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsThreatStatisticsResponse) SetStatusCode(v int32) *DescribePdnsThreatStatisticsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsThreatStatisticsResponse) SetBody(v *DescribePdnsThreatStatisticsResponseBody) *DescribePdnsThreatStatisticsResponse {
	s.Body = v
	return s
}

type DescribePdnsUdpIpSegmentsRequest struct {
	Lang       *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	PageNumber *int64  `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int64  `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
}

func (s DescribePdnsUdpIpSegmentsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUdpIpSegmentsRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsUdpIpSegmentsRequest) SetLang(v string) *DescribePdnsUdpIpSegmentsRequest {
	s.Lang = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsRequest) SetPageNumber(v int64) *DescribePdnsUdpIpSegmentsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsRequest) SetPageSize(v int64) *DescribePdnsUdpIpSegmentsRequest {
	s.PageSize = &v
	return s
}

type DescribePdnsUdpIpSegmentsResponseBody struct {
	IpSegments []*DescribePdnsUdpIpSegmentsResponseBodyIpSegments `json:"IpSegments,omitempty" xml:"IpSegments,omitempty" type:"Repeated"`
	PageNumber *int64                                             `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	PageSize   *int64                                             `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	RequestId  *string                                            `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	TotalCount *int64                                             `json:"TotalCount,omitempty" xml:"TotalCount,omitempty"`
	TotalPages *string                                            `json:"TotalPages,omitempty" xml:"TotalPages,omitempty"`
}

func (s DescribePdnsUdpIpSegmentsResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUdpIpSegmentsResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsUdpIpSegmentsResponseBody) SetIpSegments(v []*DescribePdnsUdpIpSegmentsResponseBodyIpSegments) *DescribePdnsUdpIpSegmentsResponseBody {
	s.IpSegments = v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBody) SetPageNumber(v int64) *DescribePdnsUdpIpSegmentsResponseBody {
	s.PageNumber = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBody) SetPageSize(v int64) *DescribePdnsUdpIpSegmentsResponseBody {
	s.PageSize = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBody) SetRequestId(v string) *DescribePdnsUdpIpSegmentsResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBody) SetTotalCount(v int64) *DescribePdnsUdpIpSegmentsResponseBody {
	s.TotalCount = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBody) SetTotalPages(v string) *DescribePdnsUdpIpSegmentsResponseBody {
	s.TotalPages = &v
	return s
}

type DescribePdnsUdpIpSegmentsResponseBodyIpSegments struct {
	CreateDate      *string `json:"CreateDate,omitempty" xml:"CreateDate,omitempty"`
	CreateTimestamp *int64  `json:"CreateTimestamp,omitempty" xml:"CreateTimestamp,omitempty"`
	Id              *string `json:"Id,omitempty" xml:"Id,omitempty"`
	Ip              *string `json:"Ip,omitempty" xml:"Ip,omitempty"`
	Mask            *int64  `json:"Mask,omitempty" xml:"Mask,omitempty"`
	Name            *string `json:"Name,omitempty" xml:"Name,omitempty"`
	SecretKey       *string `json:"SecretKey,omitempty" xml:"SecretKey,omitempty"`
	State           *string `json:"State,omitempty" xml:"State,omitempty"`
	UpdateDate      *string `json:"UpdateDate,omitempty" xml:"UpdateDate,omitempty"`
}

func (s DescribePdnsUdpIpSegmentsResponseBodyIpSegments) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUdpIpSegmentsResponseBodyIpSegments) GoString() string {
	return s.String()
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetCreateDate(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.CreateDate = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetCreateTimestamp(v int64) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.CreateTimestamp = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetId(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.Id = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetIp(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.Ip = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetMask(v int64) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.Mask = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetName(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.Name = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetSecretKey(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.SecretKey = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetState(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.State = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponseBodyIpSegments) SetUpdateDate(v string) *DescribePdnsUdpIpSegmentsResponseBodyIpSegments {
	s.UpdateDate = &v
	return s
}

type DescribePdnsUdpIpSegmentsResponse struct {
	Headers    map[string]*string                     `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                                 `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsUdpIpSegmentsResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsUdpIpSegmentsResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUdpIpSegmentsResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsUdpIpSegmentsResponse) SetHeaders(v map[string]*string) *DescribePdnsUdpIpSegmentsResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponse) SetStatusCode(v int32) *DescribePdnsUdpIpSegmentsResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsUdpIpSegmentsResponse) SetBody(v *DescribePdnsUdpIpSegmentsResponseBody) *DescribePdnsUdpIpSegmentsResponse {
	s.Body = v
	return s
}

type DescribePdnsUserInfoRequest struct {
	// The language of the content within the request and response. Default value: **zh**. Valid value:
	//
	// 	- **zh**: Chinese.
	//
	// 	- **en**: English.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
}

func (s DescribePdnsUserInfoRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUserInfoRequest) GoString() string {
	return s.String()
}

func (s *DescribePdnsUserInfoRequest) SetLang(v string) *DescribePdnsUserInfoRequest {
	s.Lang = &v
	return s
}

type DescribePdnsUserInfoResponseBody struct {
	// The ID of the request.
	//
	// example:
	//
	// FD552816-FCC8-4832-B4A2-2DA0C2BA1688
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The information about the user.
	UserInfo *DescribePdnsUserInfoResponseBodyUserInfo `json:"UserInfo,omitempty" xml:"UserInfo,omitempty" type:"Struct"`
}

func (s DescribePdnsUserInfoResponseBody) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUserInfoResponseBody) GoString() string {
	return s.String()
}

func (s *DescribePdnsUserInfoResponseBody) SetRequestId(v string) *DescribePdnsUserInfoResponseBody {
	s.RequestId = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBody) SetUserInfo(v *DescribePdnsUserInfoResponseBodyUserInfo) *DescribePdnsUserInfoResponseBody {
	s.UserInfo = v
	return s
}

type DescribePdnsUserInfoResponseBodyUserInfo struct {
	// The enabled access security types.
	//
	// example:
	//
	// SECURE
	AvailableAccessSecurityType *string `json:"AvailableAccessSecurityType,omitempty" xml:"AvailableAccessSecurityType,omitempty"`
	// The enabled public recursive DNS service.
	//
	// example:
	//
	// HTTP,HTTPS
	AvailableService *string `json:"AvailableService,omitempty" xml:"AvailableService,omitempty"`
	// The configuration ID of the users in public recursive DNS.
	//
	// example:
	//
	// 10001
	PdnsId *int64 `json:"PdnsId,omitempty" xml:"PdnsId,omitempty"`
	// The SecretKey configured for a UDP-based CIDR block.
	//
	// example:
	//
	// 1c092d715b7a48de
	SecretKey *string `json:"SecretKey,omitempty" xml:"SecretKey,omitempty"`
	// The type of the public recursive DNS service.
	//
	// example:
	//
	// normal
	ServiceType *string `json:"ServiceType,omitempty" xml:"ServiceType,omitempty"`
	// The status of the public recursive DNS service.
	//
	// example:
	//
	// AVAILABLE
	State *string `json:"State,omitempty" xml:"State,omitempty"`
	// The status of the traffic analysis switch for the user in public recursive DNS service.
	//
	// example:
	//
	// CLOSED
	StatisticSwitchStatus *string `json:"StatisticSwitchStatus,omitempty" xml:"StatisticSwitchStatus,omitempty"`
	// The disabled public recursive DNS service.
	StoppedService *string `json:"StoppedService,omitempty" xml:"StoppedService,omitempty"`
}

func (s DescribePdnsUserInfoResponseBodyUserInfo) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUserInfoResponseBodyUserInfo) GoString() string {
	return s.String()
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetAvailableAccessSecurityType(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.AvailableAccessSecurityType = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetAvailableService(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.AvailableService = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetPdnsId(v int64) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.PdnsId = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetSecretKey(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.SecretKey = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetServiceType(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.ServiceType = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetState(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.State = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetStatisticSwitchStatus(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.StatisticSwitchStatus = &v
	return s
}

func (s *DescribePdnsUserInfoResponseBodyUserInfo) SetStoppedService(v string) *DescribePdnsUserInfoResponseBodyUserInfo {
	s.StoppedService = &v
	return s
}

type DescribePdnsUserInfoResponse struct {
	Headers    map[string]*string                `json:"headers,omitempty" xml:"headers,omitempty"`
	StatusCode *int32                            `json:"statusCode,omitempty" xml:"statusCode,omitempty"`
	Body       *DescribePdnsUserInfoResponseBody `json:"body,omitempty" xml:"body,omitempty"`
}

func (s DescribePdnsUserInfoResponse) String() string {
	return tea.Prettify(s)
}

func (s DescribePdnsUserInfoResponse) GoString() string {
	return s.String()
}

func (s *DescribePdnsUserInfoResponse) SetHeaders(v map[string]*string) *DescribePdnsUserInfoResponse {
	s.Headers = v
	return s
}

func (s *DescribePdnsUserInfoResponse) SetStatusCode(v int32) *DescribePdnsUserInfoResponse {
	s.StatusCode = &v
	return s
}

func (s *DescribePdnsUserInfoResponse) SetBody(v *DescribePdnsUserInfoResponseBody) *DescribePdnsUserInfoResponse {
	s.Body = v
	return s
}

type DescribeRecordLogsRequest struct {
	// The domain name. You can call the [DescribeDomains](https://www.alibabacloud.com/help/zh/dns/api-alidns-2015-01-09-describedomains?spm=a2c63.p38356.help-menu-search-29697.d_0) operation to obtain the domain name.
	//
	// This parameter is required.
	//
	// example:
	//
	// example.com
	DomainName *string `json:"DomainName,omitempty" xml:"DomainName,omitempty"`
	// The keyword for searches in "%KeyWord%" mode. The value is not case-sensitive.
	//
	// example:
	//
	// test
	KeyWord *string `json:"KeyWord,omitempty" xml:"KeyWord,omitempty"`
	// The language.
	//
	// example:
	//
	// en
	Lang *string `json:"Lang,omitempty" xml:"Lang,omitempty"`
	// The page number. Pages start from page **1**. Default value: **1**.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page. Valid values: **1 to 100**. Default value: **20**.
	//
	// example:
	//
	// 20
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The start date of the query. Specify the start date in the **YYYY-MM-DD*	- format.
	//
	// example:
	//
	// 2015-12-12
	StartDate *string `json:"StartDate,omitempty" xml:"StartDate,omitempty"`
	// The IP address of the client.
	//
	// example:
	//
	// 1.1.1.1
	UserClientIp *string `json:"UserClientIp,omitempty" xml:"UserClientIp,omitempty"`
	// The end date of the query. Specify the end date in the **YYYY-MM-DD*	- format.
	//
	// example:
	//
	// 2015-12-12
	EndDate *string `json:"endDate,omitempty" xml:"endDate,omitempty"`
}

func (s DescribeRecordLogsRequest) String() string {
	return tea.Prettify(s)
}

func (s DescribeRecordLogsRequest) GoString() string {
	return s.String()
}

func (s *DescribeRecordLogsRequest) SetDomainName(v string) *DescribeRecordLogsRequest {
	s.DomainName = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetKeyWord(v string) *DescribeRecordLogsRequest {
	s.KeyWord = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetLang(v string) *DescribeRecordLogsRequest {
	s.Lang = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetPageNumber(v int64) *DescribeRecordLogsRequest {
	s.PageNumber = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetPageSize(v int64) *DescribeRecordLogsRequest {
	s.PageSize = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetStartDate(v string) *DescribeRecordLogsRequest {
	s.StartDate = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetUserClientIp(v string) *DescribeRecordLogsRequest {
	s.UserClientIp = &v
	return s
}

func (s *DescribeRecordLogsRequest) SetEndDate(v string) *DescribeRecordLogsRequest {
	s.EndDate = &v
	return s
}

type DescribeRecordLogsResponseBody struct {
	// The page number.
	//
	// example:
	//
	// 1
	PageNumber *int64 `json:"PageNumber,omitempty" xml:"PageNumber,omitempty"`
	// The number of entries per page.
	//
	// example:
	//
	// 2
	PageSize *int64 `json:"PageSize,omitempty" xml:"PageSize,omitempty"`
	// The operation logs.
	RecordLogs *DescribeRecordLogsResponseBodyRecordLogs `json:"RecordLogs,omitempty" xml:"RecordLogs,omitempty" type:"Struct"`
	// The request ID.
	//
	// example:
	//
	// 536E9CAD-DB30-4647-AC87-AA5CC38C5382
	RequestId *string `json:"RequestId,omitempty" xml:"RequestId,omitempty"`
	// The total number of entries returned.
	//
	// example:
	//
	// 2
	TotalCount *int64 `json:"T