// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new database in Amazon Lightsail.
//
// The create relational database operation supports tag-based access control via
// request tags. For more information, see the [Amazon Lightsail Developer Guide].
//
// [Amazon Lightsail Developer Guide]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-controlling-access-using-tags
func (c *Client) CreateRelationalDatabase(ctx context.Context, params *CreateRelationalDatabaseInput, optFns ...func(*Options)) (*CreateRelationalDatabaseOutput, error) {
	if params == nil {
		params = &CreateRelationalDatabaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRelationalDatabase", params, optFns, c.addOperationCreateRelationalDatabaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRelationalDatabaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRelationalDatabaseInput struct {

	// The meaning of this parameter differs according to the database engine you use.
	//
	// MySQL
	//
	// The name of the database to create when the Lightsail database resource is
	// created. If this parameter isn't specified, no database is created in the
	// database resource.
	//
	// Constraints:
	//
	//   - Must contain 1 to 64 letters or numbers.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0- 9).
	//
	//   - Can't be a word reserved by the specified database engine.
	//
	// For more information about reserved words in MySQL, see the Keywords and
	//   Reserved Words articles for [MySQL 5.6], [MySQL 5.7], and [MySQL 8.0].
	//
	// PostgreSQL
	//
	// The name of the database to create when the Lightsail database resource is
	// created. If this parameter isn't specified, a database named postgres is
	// created in the database resource.
	//
	// Constraints:
	//
	//   - Must contain 1 to 63 letters or numbers.
	//
	//   - Must begin with a letter. Subsequent characters can be letters,
	//   underscores, or digits (0- 9).
	//
	//   - Can't be a word reserved by the specified database engine.
	//
	// For more information about reserved words in PostgreSQL, see the SQL Key Words
	//   articles for [PostgreSQL 9.6], [PostgreSQL 10], [PostgreSQL 11], and [PostgreSQL 12].
	//
	// [MySQL 5.6]: https://dev.mysql.com/doc/refman/5.6/en/keywords.html
	// [PostgreSQL 9.6]: https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html
	// [PostgreSQL 10]: https://www.postgresql.org/docs/10/sql-keywords-appendix.html
	// [MySQL 8.0]: https://dev.mysql.com/doc/refman/8.0/en/keywords.html
	// [PostgreSQL 12]: https://www.postgresql.org/docs/12/sql-keywords-appendix.html
	// [PostgreSQL 11]: https://www.postgresql.org/docs/11/sql-keywords-appendix.html
	// [MySQL 5.7]: https://dev.mysql.com/doc/refman/5.7/en/keywords.html
	//
	// This member is required.
	MasterDatabaseName *string

	// The name for the master user.
	//
	// MySQL
	//
	// Constraints:
	//
	//   - Required for MySQL.
	//
	//   - Must be 1 to 16 letters or numbers. Can contain underscores.
	//
	//   - First character must be a letter.
	//
	//   - Can't be a reserved word for the chosen database engine.
	//
	// For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords
	//   and Reserved Words articles for [MySQL 5.6], [MySQL 5.7], or [MySQL 8.0].
	//
	// PostgreSQL
	//
	// Constraints:
	//
	//   - Required for PostgreSQL.
	//
	//   - Must be 1 to 63 letters or numbers. Can contain underscores.
	//
	//   - First character must be a letter.
	//
	//   - Can't be a reserved word for the chosen database engine.
	//
	// For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords
	//   and Reserved Words articles for [PostgreSQL 9.6], [PostgreSQL 10], [PostgreSQL 11], and [PostgreSQL 12].
	//
	// [MySQL 5.6]: https://dev.mysql.com/doc/refman/5.6/en/keywords.html
	// [PostgreSQL 9.6]: https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html
	// [PostgreSQL 10]: https://www.postgresql.org/docs/10/sql-keywords-appendix.html
	// [MySQL 8.0]: https://dev.mysql.com/doc/refman/8.0/en/keywords.html
	// [PostgreSQL 12]: https://www.postgresql.org/docs/12/sql-keywords-appendix.html
	// [PostgreSQL 11]: https://www.postgresql.org/docs/11/sql-keywords-appendix.html
	// [MySQL 5.7]: https://dev.mysql.com/doc/refman/5.7/en/keywords.html
	//
	// This member is required.
	MasterUsername *string

	// The blueprint ID for your new database. A blueprint describes the major engine
	// version of a database.
	//
	// You can get a list of database blueprints IDs by using the get relational
	// database blueprints operation.
	//
	// This member is required.
	RelationalDatabaseBlueprintId *string

	// The bundle ID for your new database. A bundle describes the performance
	// specifications for your database.
	//
	// You can get a list of database bundle IDs by using the get relational database
	// bundles operation.
	//
	// This member is required.
	RelationalDatabaseBundleId *string

	// The name to use for your new Lightsail database resource.
	//
	// Constraints:
	//
	//   - Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//   - The first and last character must be a letter or number.
	//
	// This member is required.
	RelationalDatabaseName *string

	// The Availability Zone in which to create your new database. Use the us-east-2a
	// case-sensitive format.
	//
	// You can get a list of Availability Zones by using the get regions operation. Be
	// sure to add the include relational database Availability Zones parameter to
	// your request.
	AvailabilityZone *string

	// The password for the master user. The password can include any printable ASCII
	// character except "/", """, or "@". It cannot contain spaces.
	//
	// MySQL
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// PostgreSQL
	//
	// Constraints: Must contain from 8 to 128 characters.
	MasterUserPassword *string

	// The daily time range during which automated backups are created for your new
	// database if automated backups are enabled.
	//
	// The default is a 30-minute window selected at random from an 8-hour block of
	// time for each AWS Region. For more information about the preferred backup window
	// time blocks for each region, see the [Working With Backups]guide in the Amazon Relational Database
	// Service documentation.
	//
	// Constraints:
	//
	//   - Must be in the hh24:mi-hh24:mi format.
	//
	// Example: 16:00-16:30
	//
	//   - Specified in Coordinated Universal Time (UTC).
	//
	//   - Must not conflict with the preferred maintenance window.
	//
	//   - Must be at least 30 minutes.
	//
	// [Working With Backups]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
	PreferredBackupWindow *string

	// The weekly time range during which system maintenance can occur on your new
	// database.
	//
	// The default is a 30-minute window selected at random from an 8-hour block of
	// time for each AWS Region, occurring on a random day of the week.
	//
	// Constraints:
	//
	//   - Must be in the ddd:hh24:mi-ddd:hh24:mi format.
	//
	//   - Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	//   - Must be at least 30 minutes.
	//
	//   - Specified in Coordinated Universal Time (UTC).
	//
	//   - Example: Tue:17:00-Tue:17:30
	PreferredMaintenanceWindow *string

	// Specifies the accessibility options for your new database. A value of true
	// specifies a database that is available to resources outside of your Lightsail
	// account. A value of false specifies a database that is available only to your
	// Lightsail resources in the same region as your database.
	PubliclyAccessible *bool

	// The tag keys and optional values to add to the resource during create.
	//
	// Use the TagResource action to tag a resource after it's created.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateRelationalDatabaseOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operations []types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRelationalDatabaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateRelationalDatabase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateRelationalDatabase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRelationalDatabase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRelationalDatabaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRelationalDatabase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRelationalDatabase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRelationalDatabase",
	}
}
