/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.util.function.Supplier;
import org.asamk.signal.manager.helper.AccountFileUpdater;
import org.asamk.signal.manager.helper.AccountHelper;
import org.asamk.signal.manager.helper.AttachmentHelper;
import org.asamk.signal.manager.helper.ContactHelper;
import org.asamk.signal.manager.helper.GroupHelper;
import org.asamk.signal.manager.helper.GroupV2Helper;
import org.asamk.signal.manager.helper.IdentityHelper;
import org.asamk.signal.manager.helper.IncomingMessageHandler;
import org.asamk.signal.manager.helper.PinHelper;
import org.asamk.signal.manager.helper.PreKeyHelper;
import org.asamk.signal.manager.helper.ProfileHelper;
import org.asamk.signal.manager.helper.ReceiveHelper;
import org.asamk.signal.manager.helper.RecipientHelper;
import org.asamk.signal.manager.helper.SendHelper;
import org.asamk.signal.manager.helper.StickerHelper;
import org.asamk.signal.manager.helper.StorageHelper;
import org.asamk.signal.manager.helper.SyncHelper;
import org.asamk.signal.manager.helper.UnidentifiedAccessHelper;
import org.asamk.signal.manager.internal.JobExecutor;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.AttachmentStore;
import org.asamk.signal.manager.storage.AvatarStore;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.stickerPacks.StickerPackStore;

public class Context
implements AutoCloseable {
    private final Object LOCK = new Object();
    private final SignalAccount account;
    private final AccountFileUpdater accountFileUpdater;
    private final SignalDependencies dependencies;
    private final AvatarStore avatarStore;
    private final StickerPackStore stickerPackStore;
    private final AttachmentStore attachmentStore;
    private final JobExecutor jobExecutor;
    private AccountHelper accountHelper;
    private AttachmentHelper attachmentHelper;
    private ContactHelper contactHelper;
    private GroupHelper groupHelper;
    private GroupV2Helper groupV2Helper;
    private IdentityHelper identityHelper;
    private IncomingMessageHandler incomingMessageHandler;
    private PinHelper pinHelper;
    private PreKeyHelper preKeyHelper;
    private ProfileHelper profileHelper;
    private ReceiveHelper receiveHelper;
    private RecipientHelper recipientHelper;
    private SendHelper sendHelper;
    private StickerHelper stickerHelper;
    private StorageHelper storageHelper;
    private SyncHelper syncHelper;
    private UnidentifiedAccessHelper unidentifiedAccessHelper;

    public Context(SignalAccount account, AccountFileUpdater accountFileUpdater, SignalDependencies dependencies, AvatarStore avatarStore, AttachmentStore attachmentStore, StickerPackStore stickerPackStore) {
        this.account = account;
        this.accountFileUpdater = accountFileUpdater;
        this.dependencies = dependencies;
        this.avatarStore = avatarStore;
        this.stickerPackStore = stickerPackStore;
        this.attachmentStore = attachmentStore;
        this.jobExecutor = new JobExecutor(this);
    }

    public SignalAccount getAccount() {
        return this.account;
    }

    public AccountFileUpdater getAccountFileUpdater() {
        return this.accountFileUpdater;
    }

    public SignalDependencies getDependencies() {
        return this.dependencies;
    }

    public AvatarStore getAvatarStore() {
        return this.avatarStore;
    }

    public StickerPackStore getStickerPackStore() {
        return this.stickerPackStore;
    }

    AttachmentStore getAttachmentStore() {
        return this.attachmentStore;
    }

    public JobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    public AccountHelper getAccountHelper() {
        return this.getOrCreate(() -> this.accountHelper, () -> {
            this.accountHelper = new AccountHelper(this);
        });
    }

    public AttachmentHelper getAttachmentHelper() {
        return this.getOrCreate(() -> this.attachmentHelper, () -> {
            this.attachmentHelper = new AttachmentHelper(this);
        });
    }

    public ContactHelper getContactHelper() {
        return this.getOrCreate(() -> this.contactHelper, () -> {
            this.contactHelper = new ContactHelper(this.account);
        });
    }

    GroupV2Helper getGroupV2Helper() {
        return this.getOrCreate(() -> this.groupV2Helper, () -> {
            this.groupV2Helper = new GroupV2Helper(this);
        });
    }

    public GroupHelper getGroupHelper() {
        return this.getOrCreate(() -> this.groupHelper, () -> {
            this.groupHelper = new GroupHelper(this);
        });
    }

    public IdentityHelper getIdentityHelper() {
        return this.getOrCreate(() -> this.identityHelper, () -> {
            this.identityHelper = new IdentityHelper(this);
        });
    }

    public IncomingMessageHandler getIncomingMessageHandler() {
        return this.getOrCreate(() -> this.incomingMessageHandler, () -> {
            this.incomingMessageHandler = new IncomingMessageHandler(this);
        });
    }

    PinHelper getPinHelper() {
        return this.getOrCreate(() -> this.pinHelper, () -> {
            this.pinHelper = new PinHelper(this.dependencies.getSecureValueRecovery());
        });
    }

    public PreKeyHelper getPreKeyHelper() {
        return this.getOrCreate(() -> this.preKeyHelper, () -> {
            this.preKeyHelper = new PreKeyHelper(this.account, this.dependencies);
        });
    }

    public ProfileHelper getProfileHelper() {
        return this.getOrCreate(() -> this.profileHelper, () -> {
            this.profileHelper = new ProfileHelper(this);
        });
    }

    public ReceiveHelper getReceiveHelper() {
        return this.getOrCreate(() -> this.receiveHelper, () -> {
            this.receiveHelper = new ReceiveHelper(this);
        });
    }

    public RecipientHelper getRecipientHelper() {
        return this.getOrCreate(() -> this.recipientHelper, () -> {
            this.recipientHelper = new RecipientHelper(this);
        });
    }

    public SendHelper getSendHelper() {
        return this.getOrCreate(() -> this.sendHelper, () -> {
            this.sendHelper = new SendHelper(this);
        });
    }

    public StickerHelper getStickerHelper() {
        return this.getOrCreate(() -> this.stickerHelper, () -> {
            this.stickerHelper = new StickerHelper(this);
        });
    }

    public StorageHelper getStorageHelper() {
        return this.getOrCreate(() -> this.storageHelper, () -> {
            this.storageHelper = new StorageHelper(this);
        });
    }

    public SyncHelper getSyncHelper() {
        return this.getOrCreate(() -> this.syncHelper, () -> {
            this.syncHelper = new SyncHelper(this);
        });
    }

    UnidentifiedAccessHelper getUnidentifiedAccessHelper() {
        return this.getOrCreate(() -> this.unidentifiedAccessHelper, () -> {
            this.unidentifiedAccessHelper = new UnidentifiedAccessHelper(this);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreate(Supplier<T> supplier, Callable creator) {
        T value = supplier.get();
        if (value != null) {
            return value;
        }
        Object object = this.LOCK;
        synchronized (object) {
            value = supplier.get();
            if (value != null) {
                return value;
            }
            creator.call();
            return supplier.get();
        }
    }

    @Override
    public void close() {
        this.jobExecutor.close();
    }

    private static interface Callable {
        public void call();
    }
}

