## Rails 7.2.3 (October 28, 2025) ##

*   Fix `has_secure_password` to perform confirmation validation of the password even when blank.

    The validation was incorrectly skipped when the password only contained whitespace characters.

    *Fabio Sangiovanni*

*   Handle missing attributes for `ActiveModel::Translation#human_attribute_name`.

    *zzak*

*   Fix `ActiveModel::AttributeAssignment#assign_attributes` to accept objects without `each`.

    *Kouhei Yanagita*


## Rails 7.2.2.2 (August 13, 2025) ##

*   No changes.


## Rails 7.2.2.1 (December 10, 2024) ##

*   No changes.


## Rails 7.2.2 (October 30, 2024) ##

*   Fix regression in `alias_attribute` to work with user defined methods.

    `alias_attribute` would wrongly assume the attribute accessor was generated by Active Model.

    ```ruby
    class Person
      include ActiveModel::AttributeMethods

      define_attribute_methods :name
      attr_accessor :name

      alias_attribute :full_name, :name
    end

    person.full_name # => NoMethodError: undefined method `attribute' for an instance of Person
    ```

    *Jean Boussier*


## Rails 7.2.1.2 (October 23, 2024) ##

*   No changes.


## Rails 7.2.1.1 (October 15, 2024) ##

*   No changes.


## Rails 7.2.1 (August 22, 2024) ##

*   No changes.


## Rails 7.2.0 (August 09, 2024) ##

*   Fix a bug where type casting of string to `Time` and `DateTime` doesn't
    calculate minus minute value in TZ offset correctly.

    *Akira Matsuda*

*   Port the `type_for_attribute` method to Active Model. Classes that include
    `ActiveModel::Attributes` will now provide this method. This method behaves
    the same for Active Model as it does for Active Record.

      ```ruby
      class MyModel
        include ActiveModel::Attributes

        attribute :my_attribute, :integer
      end

      MyModel.type_for_attribute(:my_attribute) # => #<ActiveModel::Type::Integer ...>
      ```

    *Jonathan Hefner*

Please check [7-1-stable](https://github.com/rails/rails/blob/7-1-stable/activemodel/CHANGELOG.md) for previous changes.
