/******************************************************************************************************
 * (C) 2019 markummitchell@github.com. This file is part of Engauge Digitizer, which is released      *
 * under GNU General Public License version 2 (GPLv2) or (at your option) any later version. See file *
 * LICENSE or go to gnu.org/licenses for details. Distribution requires prior written permission.     *
 ******************************************************************************************************/

#include "EngaugeAssert.h"
#include "GuidelineAbstract.h"
#include "GuidelineState.h"
#include "GuidelineStateContext.h"
#include "GuidelineStateDeployedConstantXUnselectEdit.h"
#include "Logger.h"
#include "Transformation.h"

GuidelineStateDeployedConstantXUnselectEdit::GuidelineStateDeployedConstantXUnselectEdit (GuidelineStateContext &context) :
  GuidelineStateDeployedConstantXAbstract (context)
{
}

GuidelineStateDeployedConstantXUnselectEdit::~GuidelineStateDeployedConstantXUnselectEdit ()
{
}

void GuidelineStateDeployedConstantXUnselectEdit::begin ()
{
  LOG4CPP_INFO_S ((*mainCat)) << "GuidelineStateDeployedConstantXUnselectEdit::begin"
                              << " identifier=" << context().guideline().identifier().toLatin1().data();

  beginCommon (false,
               true);

  context().guideline().setGraphicsItemVisible (true); // Stop hover and painting (doPoint only stops painting)
}

bool GuidelineStateDeployedConstantXUnselectEdit::doPaint () const
{
  return false;
}

void GuidelineStateDeployedConstantXUnselectEdit::end ()
{
  LOG4CPP_INFO_S ((*mainCat)) << "GuidelineStateDeployedConstantXUnselectEdit::end";
}

void GuidelineStateDeployedConstantXUnselectEdit::handleActiveChange (bool /* active */)
{
}

void GuidelineStateDeployedConstantXUnselectEdit::handleGuidelineMode (bool visible,
                                                                       bool locked)
{
  if (visible || locked) {
    context().requestStateTransition(GUIDELINE_STATE_DEPLOYED_CONSTANT_X_UNSELECT_LOCK);
  }
}

void GuidelineStateDeployedConstantXUnselectEdit::handleHoverEnterEvent ()
{
}

void GuidelineStateDeployedConstantXUnselectEdit::handleHoverLeaveEvent ()
{
}

void GuidelineStateDeployedConstantXUnselectEdit::handleMousePress (const QPointF & /* posScene */)
{
}

QString GuidelineStateDeployedConstantXUnselectEdit::stateName () const
{
  return guidelineStateAsString (GUIDELINE_STATE_DEPLOYED_CONSTANT_X_UNSELECT_EDIT);
}
