// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A block of content for a message that you pass to, or receive from, a model with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API operations.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub enum ContentBlock {
    /// <p>CachePoint to include in the message.</p>
    CachePoint(crate::types::CachePointBlock),
    /// <p>A document to include in the message.</p>
    Document(crate::types::DocumentBlock),
    /// <p>Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a call to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.</p>
    /// <p>For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.</p>
    GuardContent(crate::types::GuardrailConverseContentBlock),
    /// <p>Image to include in the message.</p><note>
    /// <p>This field is only supported by Anthropic Claude 3 models.</p>
    /// </note>
    Image(crate::types::ImageBlock),
    /// <p>Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final response.</p>
    ReasoningContent(crate::types::ReasoningContentBlock),
    /// <p>Text to include in the message.</p>
    Text(::std::string::String),
    /// <p>The result for a tool request that a model makes.</p>
    ToolResult(crate::types::ToolResultBlock),
    /// <p>Information about a tool use request from a model.</p>
    ToolUse(crate::types::ToolUseBlock),
    /// <p>Video to include in the message.</p>
    Video(crate::types::VideoBlock),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ContentBlock {
    /// Tries to convert the enum instance into [`CachePoint`](crate::types::ContentBlock::CachePoint), extracting the inner [`CachePointBlock`](crate::types::CachePointBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_cache_point(&self) -> ::std::result::Result<&crate::types::CachePointBlock, &Self> {
        if let ContentBlock::CachePoint(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`CachePoint`](crate::types::ContentBlock::CachePoint).
    pub fn is_cache_point(&self) -> bool {
        self.as_cache_point().is_ok()
    }
    /// Tries to convert the enum instance into [`Document`](crate::types::ContentBlock::Document), extracting the inner [`DocumentBlock`](crate::types::DocumentBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_document(&self) -> ::std::result::Result<&crate::types::DocumentBlock, &Self> {
        if let ContentBlock::Document(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Document`](crate::types::ContentBlock::Document).
    pub fn is_document(&self) -> bool {
        self.as_document().is_ok()
    }
    /// Tries to convert the enum instance into [`GuardContent`](crate::types::ContentBlock::GuardContent), extracting the inner [`GuardrailConverseContentBlock`](crate::types::GuardrailConverseContentBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_guard_content(&self) -> ::std::result::Result<&crate::types::GuardrailConverseContentBlock, &Self> {
        if let ContentBlock::GuardContent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`GuardContent`](crate::types::ContentBlock::GuardContent).
    pub fn is_guard_content(&self) -> bool {
        self.as_guard_content().is_ok()
    }
    /// Tries to convert the enum instance into [`Image`](crate::types::ContentBlock::Image), extracting the inner [`ImageBlock`](crate::types::ImageBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_image(&self) -> ::std::result::Result<&crate::types::ImageBlock, &Self> {
        if let ContentBlock::Image(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Image`](crate::types::ContentBlock::Image).
    pub fn is_image(&self) -> bool {
        self.as_image().is_ok()
    }
    /// Tries to convert the enum instance into [`ReasoningContent`](crate::types::ContentBlock::ReasoningContent), extracting the inner [`ReasoningContentBlock`](crate::types::ReasoningContentBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_reasoning_content(&self) -> ::std::result::Result<&crate::types::ReasoningContentBlock, &Self> {
        if let ContentBlock::ReasoningContent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ReasoningContent`](crate::types::ContentBlock::ReasoningContent).
    pub fn is_reasoning_content(&self) -> bool {
        self.as_reasoning_content().is_ok()
    }
    /// Tries to convert the enum instance into [`Text`](crate::types::ContentBlock::Text), extracting the inner [`String`](::std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_text(&self) -> ::std::result::Result<&::std::string::String, &Self> {
        if let ContentBlock::Text(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Text`](crate::types::ContentBlock::Text).
    pub fn is_text(&self) -> bool {
        self.as_text().is_ok()
    }
    /// Tries to convert the enum instance into [`ToolResult`](crate::types::ContentBlock::ToolResult), extracting the inner [`ToolResultBlock`](crate::types::ToolResultBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tool_result(&self) -> ::std::result::Result<&crate::types::ToolResultBlock, &Self> {
        if let ContentBlock::ToolResult(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ToolResult`](crate::types::ContentBlock::ToolResult).
    pub fn is_tool_result(&self) -> bool {
        self.as_tool_result().is_ok()
    }
    /// Tries to convert the enum instance into [`ToolUse`](crate::types::ContentBlock::ToolUse), extracting the inner [`ToolUseBlock`](crate::types::ToolUseBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tool_use(&self) -> ::std::result::Result<&crate::types::ToolUseBlock, &Self> {
        if let ContentBlock::ToolUse(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ToolUse`](crate::types::ContentBlock::ToolUse).
    pub fn is_tool_use(&self) -> bool {
        self.as_tool_use().is_ok()
    }
    /// Tries to convert the enum instance into [`Video`](crate::types::ContentBlock::Video), extracting the inner [`VideoBlock`](crate::types::VideoBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_video(&self) -> ::std::result::Result<&crate::types::VideoBlock, &Self> {
        if let ContentBlock::Video(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Video`](crate::types::ContentBlock::Video).
    pub fn is_video(&self) -> bool {
        self.as_video().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
impl ::std::fmt::Debug for ContentBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ContentBlock::CachePoint(val) => f.debug_tuple("CachePoint").field(&val).finish(),
            ContentBlock::Document(val) => f.debug_tuple("Document").field(&val).finish(),
            ContentBlock::GuardContent(val) => f.debug_tuple("GuardContent").field(&val).finish(),
            ContentBlock::Image(val) => f.debug_tuple("Image").field(&val).finish(),
            ContentBlock::ReasoningContent(_) => f.debug_tuple("*** Sensitive Data Redacted ***").finish(),
            ContentBlock::Text(val) => f.debug_tuple("Text").field(&val).finish(),
            ContentBlock::ToolResult(val) => f.debug_tuple("ToolResult").field(&val).finish(),
            ContentBlock::ToolUse(val) => f.debug_tuple("ToolUse").field(&val).finish(),
            ContentBlock::Video(val) => f.debug_tuple("Video").field(&val).finish(),
            ContentBlock::Unknown => f.debug_tuple("Unknown").finish(),
        }
    }
}
