namespace FSIstrings
type internal SR private() =
    static member stoppedDueToError() = (sprintf "Stopped due to error\n" )
    static member fsiUsage(a0 : System.String) = (sprintf "Usage: %s <options> [script.fsx [<arguments>]]" a0)
    static member fsiInputFiles() = (sprintf "- INPUT FILES -" )
    static member fsiCodeGeneration() = (sprintf "- CODE GENERATION -" )
    static member fsiErrorsAndWarnings() = (sprintf "- ERRORS AND WARNINGS -" )
    static member fsiLanguage() = (sprintf "- LANGUAGE -" )
    static member fsiMiscellaneous() = (sprintf "- MISCELLANEOUS -" )
    static member fsiAdvanced() = (sprintf "- ADVANCED -" )
    static member fsiExceptionRaisedStartingServer(a0 : System.String) = (sprintf "Exception raised when starting remoting server.\n%s" a0)
    static member fsiUse() = (sprintf "Use the given file on startup as initial input" )
    static member fsiLoad() = (sprintf "#load the given file on startup" )
    static member fsiRemaining() = (sprintf "Treat remaining arguments as command line arguments, accessed using fsi.CommandLineArgs" )
    static member fsiHelp() = (sprintf "Display this usage message (Short form: -?)" )
    static member fsiExec() = (sprintf "Exit fsi after loading the files or running the .fsx script given on the command line" )
    static member fsiGui() = (sprintf "Execute interactions on a Windows Forms event loop (on by default)" )
    static member fsiQuiet() = (sprintf "Suppress fsi writing to stdout" )
    static member fsiReadline() = (sprintf "Support TAB completion in console (on by default)" )
    static member fsiEmitDebugInfoInQuotations() = (sprintf "Emit debug information in quotations" )
    static member fsiBanner3() = (sprintf "For help type #help;;" )
    static member fsiConsoleProblem() = (sprintf "A problem occurred starting the F# Interactive process. This may be due to a known problem with background process console support for Unicode-enabled applications on some Windows systems. Try selecting Tools->Options->F# Interactive for Visual Studio and enter '--fsi-server-no-unicode'." )
    static member fsiInvalidAssembly(a0 : System.String) = (2301, sprintf "'%s' is not a valid assembly name" a0)
    static member fsiDirectoryDoesNotExist(a0 : System.String) = (2302, sprintf "Directory '%s' doesn't exist" a0)
    static member fsiLineTooLong() = (sprintf "Warning: line too long, ignoring some characters\n" )
    static member fsiTimeInfoMainString(a0 : System.String, a1 : System.String, a2 : System.String) = (sprintf "Real: %s, CPU: %s, GC %s" a0 a1 a2)
    static member fsiTimeInfoGCGenerationLabelSomeShorthandForTheWordGeneration() = (sprintf "gen" )
    static member fsiExceptionDuringPrettyPrinting(a0 : System.String) = (sprintf "\n\nException raised during pretty printing.\nPlease report this so it can be fixed.\nTrace: %s\n" a0)
    static member fsiIntroTextHeader1directives() = (sprintf "  F# Interactive directives:" )
    static member fsiIntroTextHashrInfo() = (sprintf "Reference (dynamically load) the given DLL" )
    static member fsiIntroTextHashIInfo() = (sprintf "Add the given search path for referenced DLLs" )
    static member fsiIntroPackageSourceUriInfo() = (sprintf "Include package source uri when searching for packages" )
    static member fsiIntroTextHashloadInfo() = (sprintf "Load the given file(s) as if compiled and referenced" )
    static member fsiIntroTextHashtimeInfo() = (sprintf "Toggle timing on/off" )
    static member fsiIntroTextHashhelpInfo() = (sprintf "Display help" )
    static member fsiIntroTextHashquitInfo() = (sprintf "Exit" )
    static member fsiIntroTextHashclearInfo() = (sprintf "Clear screen" )
    static member fsiIntroTextHeader2commandLine() = (sprintf "  F# Interactive command line options:" )
    static member fsiIntroTextHeader3(a0 : System.String) = (sprintf "      See '%s' for options" a0)
    static member fsiLoadingFilesPrefixText() = (sprintf "Loading" )
    static member fsiInterrupt() = (sprintf "\n- Interrupt\n" )
    static member fsiExit() = (sprintf "\n- Exit...\n" )
    static member fsiAbortingMainThread() = (sprintf "- Aborting main thread..." )
    static member fsiCouldNotInstallCtrlCHandler(a0 : System.String) = (sprintf "Failed to install ctrl-c handler - Ctrl-C handling will not be available. Error was:\n\t%s" a0)
    static member fsiDidAHashr(a0 : System.String) = (sprintf "--> Referenced '%s'" a0)
    static member fsiDidAHashrWithLockWarning(a0 : System.String) = (sprintf "--> Referenced '%s' (file may be locked by F# Interactive process)" a0)
    static member fsiDidAHashrWithStaleWarning(a0 : System.String) = (sprintf "--> Referenced '%s' (an assembly with a different timestamp has already been referenced from this location, reset fsi to load the updated assembly)" a0)
    static member fsiDidAHashI(a0 : System.String) = (sprintf "--> Added '%s' to library include path" a0)
    static member fsiTurnedTimingOn() = (sprintf "--> Timing now on" )
    static member fsiTurnedTimingOff() = (sprintf "--> Timing now off" )
    static member fsiUnexpectedThreadAbortException() = (sprintf "- Unexpected ThreadAbortException (Ctrl-C) during event handling: Trying to restart..." )
    static member fsiFailedToResolveAssembly(a0 : System.String) = (sprintf "Failed to resolve assembly '%s'" a0)
    static member fsiBindingSessionTo(a0 : System.String) = (sprintf "Binding session to '%s'..." a0)
    static member fsiProductName(a0 : System.String) = (sprintf "Microsoft (R) F# Interactive version %s" a0)
    static member fsiProductNameCommunity(a0 : System.String) = (sprintf "F# Interactive for F# %s" a0)
    static member shadowCopyReferences() = (sprintf "Prevents references from being locked by the F# Interactive process" )
    static member fsiOperationCouldNotBeCompleted() = (sprintf "Operation could not be completed due to earlier error" )
    static member fsiOperationFailed() = (sprintf "Operation failed. The error text has been printed in the error stream. To return the corresponding FSharpDiagnostic use the EvalInteractionNonThrowing, EvalScriptNonThrowing or EvalExpressionNonThrowing" )
    static member fsiMultiAssemblyEmitOption() = (sprintf "Emit multiple assemblies (on by default)" )
    static member fsiEntryPointWontBeInvoked(a0 : System.String, a1 : System.String, a2 : System.String) = (2304, sprintf "Functions with [<EntryPoint>] are not invoked in FSI. '%s' was not invoked. Execute '%s <args>' in order to invoke '%s' with the appropriate string array of command line arguments." a0 a1 a2)
