import type { DescEnum, DescExtension, DescMessage } from "@bufbuild/protobuf";
import { LongType, ScalarType } from "@bufbuild/protobuf";
export type LiteralProtoInt64 = {
    readonly kind: "es_proto_int64";
    type: ScalarType.INT64 | ScalarType.SINT64 | ScalarType.SFIXED64 | ScalarType.UINT64 | ScalarType.FIXED64;
    longType: LongType;
    value: bigint | string;
};
export type LiteralString = {
    readonly kind: "es_string";
    value: string;
};
export type RefDescMessage = {
    readonly kind: "es_ref_message";
    type: DescMessage;
    typeOnly: boolean;
};
export type RefDescEnum = {
    readonly kind: "es_ref_enum";
    type: DescEnum;
    typeOnly: boolean;
};
export type ExportDeclaration = {
    readonly kind: "es_export_decl";
    declaration: string;
    name: string | DescMessage | DescEnum | DescExtension;
};
