//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitversionnumberwithcontinuousscrollingbrowser?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAppKitVersionNumberWithContinuousScrollingBrowser: NSAppKitVersion = 680.0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitversionnumberwithcolumnresizingbrowser?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAppKitVersionNumberWithColumnResizingBrowser: NSAppKitVersion = 685.0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbrowsercolumnsautosavename?language=objc)
pub type NSBrowserColumnsAutosaveName = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbrowsercolumnresizingtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBrowserColumnResizingType(pub NSUInteger);
impl NSBrowserColumnResizingType {
    #[doc(alias = "NSBrowserNoColumnResizing")]
    pub const NoColumnResizing: Self = Self(0);
    #[doc(alias = "NSBrowserAutoColumnResizing")]
    pub const AutoColumnResizing: Self = Self(1);
    #[doc(alias = "NSBrowserUserColumnResizing")]
    pub const UserColumnResizing: Self = Self(2);
}

unsafe impl Encode for NSBrowserColumnResizingType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBrowserColumnResizingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbrowserdropoperation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBrowserDropOperation(pub NSUInteger);
impl NSBrowserDropOperation {
    #[doc(alias = "NSBrowserDropOn")]
    pub const On: Self = Self(0);
    #[doc(alias = "NSBrowserDropAbove")]
    pub const Above: Self = Self(1);
}

unsafe impl Encode for NSBrowserDropOperation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBrowserDropOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbrowser?language=objc)
    #[unsafe(super(NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSBrowser;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSBrowser {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSBrowser {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSBrowser {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSBrowser {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSBrowser {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSBrowser {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSBrowser {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSBrowser {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSBrowser {
    extern_methods!(
        #[unsafe(method(cellClass))]
        #[unsafe(method_family = none)]
        pub fn cellClass(mtm: MainThreadMarker) -> &'static AnyClass;

        #[unsafe(method(loadColumnZero))]
        #[unsafe(method_family = none)]
        pub fn loadColumnZero(&self);

        #[unsafe(method(isLoaded))]
        #[unsafe(method_family = none)]
        pub fn isLoaded(&self) -> bool;

        #[unsafe(method(doubleAction))]
        #[unsafe(method_family = none)]
        pub fn doubleAction(&self) -> Option<Sel>;

        /// Setter for [`doubleAction`][Self::doubleAction].
        ///
        /// # Safety
        ///
        /// `double_action` must be a valid selector.
        #[unsafe(method(setDoubleAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDoubleAction(&self, double_action: Option<Sel>);

        /// # Safety
        ///
        /// `factory_id` probably has further requirements.
        #[unsafe(method(setCellClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCellClass(&self, factory_id: &AnyClass);

        #[unsafe(method(cellPrototype))]
        #[unsafe(method_family = none)]
        pub fn cellPrototype(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`cellPrototype`][Self::cellPrototype].
        ///
        /// # Safety
        ///
        /// - `cell_prototype` should be of the correct type.
        /// - `cell_prototype` might not allow `None`.
        #[unsafe(method(setCellPrototype:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCellPrototype(&self, cell_prototype: Option<&AnyObject>);

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSBrowserDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSBrowserDelegate>>);

        #[unsafe(method(reusesColumns))]
        #[unsafe(method_family = none)]
        pub fn reusesColumns(&self) -> bool;

        /// Setter for [`reusesColumns`][Self::reusesColumns].
        #[unsafe(method(setReusesColumns:))]
        #[unsafe(method_family = none)]
        pub fn setReusesColumns(&self, reuses_columns: bool);

        #[unsafe(method(hasHorizontalScroller))]
        #[unsafe(method_family = none)]
        pub fn hasHorizontalScroller(&self) -> bool;

        /// Setter for [`hasHorizontalScroller`][Self::hasHorizontalScroller].
        #[unsafe(method(setHasHorizontalScroller:))]
        #[unsafe(method_family = none)]
        pub fn setHasHorizontalScroller(&self, has_horizontal_scroller: bool);

        #[unsafe(method(autohidesScroller))]
        #[unsafe(method_family = none)]
        pub fn autohidesScroller(&self) -> bool;

        /// Setter for [`autohidesScroller`][Self::autohidesScroller].
        #[unsafe(method(setAutohidesScroller:))]
        #[unsafe(method_family = none)]
        pub fn setAutohidesScroller(&self, autohides_scroller: bool);

        #[unsafe(method(separatesColumns))]
        #[unsafe(method_family = none)]
        pub fn separatesColumns(&self) -> bool;

        /// Setter for [`separatesColumns`][Self::separatesColumns].
        #[unsafe(method(setSeparatesColumns:))]
        #[unsafe(method_family = none)]
        pub fn setSeparatesColumns(&self, separates_columns: bool);

        #[unsafe(method(isTitled))]
        #[unsafe(method_family = none)]
        pub fn isTitled(&self) -> bool;

        /// Setter for [`isTitled`][Self::isTitled].
        #[unsafe(method(setTitled:))]
        #[unsafe(method_family = none)]
        pub fn setTitled(&self, titled: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(minColumnWidth))]
        #[unsafe(method_family = none)]
        pub fn minColumnWidth(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`minColumnWidth`][Self::minColumnWidth].
        #[unsafe(method(setMinColumnWidth:))]
        #[unsafe(method_family = none)]
        pub fn setMinColumnWidth(&self, min_column_width: CGFloat);

        #[unsafe(method(maxVisibleColumns))]
        #[unsafe(method_family = none)]
        pub fn maxVisibleColumns(&self) -> NSInteger;

        /// Setter for [`maxVisibleColumns`][Self::maxVisibleColumns].
        #[unsafe(method(setMaxVisibleColumns:))]
        #[unsafe(method_family = none)]
        pub fn setMaxVisibleColumns(&self, max_visible_columns: NSInteger);

        #[unsafe(method(allowsMultipleSelection))]
        #[unsafe(method_family = none)]
        pub fn allowsMultipleSelection(&self) -> bool;

        /// Setter for [`allowsMultipleSelection`][Self::allowsMultipleSelection].
        #[unsafe(method(setAllowsMultipleSelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsMultipleSelection(&self, allows_multiple_selection: bool);

        #[unsafe(method(allowsBranchSelection))]
        #[unsafe(method_family = none)]
        pub fn allowsBranchSelection(&self) -> bool;

        /// Setter for [`allowsBranchSelection`][Self::allowsBranchSelection].
        #[unsafe(method(setAllowsBranchSelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsBranchSelection(&self, allows_branch_selection: bool);

        #[unsafe(method(allowsEmptySelection))]
        #[unsafe(method_family = none)]
        pub fn allowsEmptySelection(&self) -> bool;

        /// Setter for [`allowsEmptySelection`][Self::allowsEmptySelection].
        #[unsafe(method(setAllowsEmptySelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsEmptySelection(&self, allows_empty_selection: bool);

        #[unsafe(method(takesTitleFromPreviousColumn))]
        #[unsafe(method_family = none)]
        pub fn takesTitleFromPreviousColumn(&self) -> bool;

        /// Setter for [`takesTitleFromPreviousColumn`][Self::takesTitleFromPreviousColumn].
        #[unsafe(method(setTakesTitleFromPreviousColumn:))]
        #[unsafe(method_family = none)]
        pub fn setTakesTitleFromPreviousColumn(&self, takes_title_from_previous_column: bool);

        #[unsafe(method(sendsActionOnArrowKeys))]
        #[unsafe(method_family = none)]
        pub fn sendsActionOnArrowKeys(&self) -> bool;

        /// Setter for [`sendsActionOnArrowKeys`][Self::sendsActionOnArrowKeys].
        #[unsafe(method(setSendsActionOnArrowKeys:))]
        #[unsafe(method_family = none)]
        pub fn setSendsActionOnArrowKeys(&self, sends_action_on_arrow_keys: bool);

        #[unsafe(method(itemAtIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn itemAtIndexPath(&self, index_path: &NSIndexPath) -> Option<Retained<AnyObject>>;

        #[unsafe(method(itemAtRow:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn itemAtRow_inColumn(
            &self,
            row: NSInteger,
            column: NSInteger,
        ) -> Option<Retained<AnyObject>>;

        #[unsafe(method(indexPathForColumn:))]
        #[unsafe(method_family = none)]
        pub fn indexPathForColumn(&self, column: NSInteger) -> Retained<NSIndexPath>;

        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[unsafe(method(isLeafItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isLeafItem(&self, item: Option<&AnyObject>) -> bool;

        #[unsafe(method(reloadDataForRowIndexes:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn reloadDataForRowIndexes_inColumn(&self, row_indexes: &NSIndexSet, column: NSInteger);

        #[unsafe(method(parentForItemsInColumn:))]
        #[unsafe(method_family = none)]
        pub fn parentForItemsInColumn(&self, column: NSInteger) -> Option<Retained<AnyObject>>;

        #[unsafe(method(scrollRowToVisible:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn scrollRowToVisible_inColumn(&self, row: NSInteger, column: NSInteger);

        #[unsafe(method(setTitle:ofColumn:))]
        #[unsafe(method_family = none)]
        pub fn setTitle_ofColumn(&self, string: &NSString, column: NSInteger);

        #[unsafe(method(titleOfColumn:))]
        #[unsafe(method_family = none)]
        pub fn titleOfColumn(&self, column: NSInteger) -> Option<Retained<NSString>>;

        #[unsafe(method(pathSeparator))]
        #[unsafe(method_family = none)]
        pub fn pathSeparator(&self) -> Retained<NSString>;

        /// Setter for [`pathSeparator`][Self::pathSeparator].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setPathSeparator:))]
        #[unsafe(method_family = none)]
        pub fn setPathSeparator(&self, path_separator: &NSString);

        #[unsafe(method(setPath:))]
        #[unsafe(method_family = none)]
        pub fn setPath(&self, path: &NSString) -> bool;

        #[unsafe(method(path))]
        #[unsafe(method_family = none)]
        pub fn path(&self) -> Retained<NSString>;

        #[unsafe(method(pathToColumn:))]
        #[unsafe(method_family = none)]
        pub fn pathToColumn(&self, column: NSInteger) -> Retained<NSString>;

        #[unsafe(method(clickedColumn))]
        #[unsafe(method_family = none)]
        pub fn clickedColumn(&self) -> NSInteger;

        #[unsafe(method(clickedRow))]
        #[unsafe(method_family = none)]
        pub fn clickedRow(&self) -> NSInteger;

        #[unsafe(method(selectedColumn))]
        #[unsafe(method_family = none)]
        pub fn selectedColumn(&self) -> NSInteger;

        #[unsafe(method(selectedCell))]
        #[unsafe(method_family = none)]
        pub fn selectedCell(&self) -> Option<Retained<AnyObject>>;

        #[unsafe(method(selectedCellInColumn:))]
        #[unsafe(method_family = none)]
        pub fn selectedCellInColumn(&self, column: NSInteger) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSCell")]
        #[unsafe(method(selectedCells))]
        #[unsafe(method_family = none)]
        pub fn selectedCells(&self) -> Option<Retained<NSArray<NSCell>>>;

        #[unsafe(method(selectRow:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn selectRow_inColumn(&self, row: NSInteger, column: NSInteger);

        #[unsafe(method(selectedRowInColumn:))]
        #[unsafe(method_family = none)]
        pub fn selectedRowInColumn(&self, column: NSInteger) -> NSInteger;

        #[unsafe(method(selectionIndexPath))]
        #[unsafe(method_family = none)]
        pub fn selectionIndexPath(&self) -> Option<Retained<NSIndexPath>>;

        /// Setter for [`selectionIndexPath`][Self::selectionIndexPath].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectionIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn setSelectionIndexPath(&self, selection_index_path: Option<&NSIndexPath>);

        #[unsafe(method(selectionIndexPaths))]
        #[unsafe(method_family = none)]
        pub fn selectionIndexPaths(&self) -> Retained<NSArray<NSIndexPath>>;

        /// Setter for [`selectionIndexPaths`][Self::selectionIndexPaths].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectionIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn setSelectionIndexPaths(&self, selection_index_paths: &NSArray<NSIndexPath>);

        #[unsafe(method(selectRowIndexes:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn selectRowIndexes_inColumn(&self, indexes: &NSIndexSet, column: NSInteger);

        #[unsafe(method(selectedRowIndexesInColumn:))]
        #[unsafe(method_family = none)]
        pub fn selectedRowIndexesInColumn(&self, column: NSInteger)
            -> Option<Retained<NSIndexSet>>;

        #[unsafe(method(reloadColumn:))]
        #[unsafe(method_family = none)]
        pub fn reloadColumn(&self, column: NSInteger);

        #[unsafe(method(validateVisibleColumns))]
        #[unsafe(method_family = none)]
        pub fn validateVisibleColumns(&self);

        #[unsafe(method(scrollColumnsRightBy:))]
        #[unsafe(method_family = none)]
        pub fn scrollColumnsRightBy(&self, shift_amount: NSInteger);

        #[unsafe(method(scrollColumnsLeftBy:))]
        #[unsafe(method_family = none)]
        pub fn scrollColumnsLeftBy(&self, shift_amount: NSInteger);

        #[unsafe(method(scrollColumnToVisible:))]
        #[unsafe(method_family = none)]
        pub fn scrollColumnToVisible(&self, column: NSInteger);

        #[unsafe(method(lastColumn))]
        #[unsafe(method_family = none)]
        pub fn lastColumn(&self) -> NSInteger;

        /// Setter for [`lastColumn`][Self::lastColumn].
        #[unsafe(method(setLastColumn:))]
        #[unsafe(method_family = none)]
        pub fn setLastColumn(&self, last_column: NSInteger);

        #[unsafe(method(addColumn))]
        #[unsafe(method_family = none)]
        pub fn addColumn(&self);

        #[unsafe(method(numberOfVisibleColumns))]
        #[unsafe(method_family = none)]
        pub fn numberOfVisibleColumns(&self) -> NSInteger;

        #[unsafe(method(firstVisibleColumn))]
        #[unsafe(method_family = none)]
        pub fn firstVisibleColumn(&self) -> NSInteger;

        #[unsafe(method(lastVisibleColumn))]
        #[unsafe(method_family = none)]
        pub fn lastVisibleColumn(&self) -> NSInteger;

        #[unsafe(method(loadedCellAtRow:column:))]
        #[unsafe(method_family = none)]
        pub fn loadedCellAtRow_column(
            &self,
            row: NSInteger,
            col: NSInteger,
        ) -> Option<Retained<AnyObject>>;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(selectAll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectAll(&self, sender: Option<&AnyObject>);

        #[unsafe(method(tile))]
        #[unsafe(method_family = none)]
        pub fn tile(&self);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(doClick:))]
        #[unsafe(method_family = none)]
        pub unsafe fn doClick(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(doDoubleClick:))]
        #[unsafe(method_family = none)]
        pub unsafe fn doDoubleClick(&self, sender: Option<&AnyObject>);

        #[unsafe(method(sendAction))]
        #[unsafe(method_family = none)]
        pub fn sendAction(&self) -> bool;

        #[unsafe(method(titleFrameOfColumn:))]
        #[unsafe(method_family = none)]
        pub fn titleFrameOfColumn(&self, column: NSInteger) -> NSRect;

        #[unsafe(method(drawTitleOfColumn:inRect:))]
        #[unsafe(method_family = none)]
        pub fn drawTitleOfColumn_inRect(&self, column: NSInteger, rect: NSRect);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(titleHeight))]
        #[unsafe(method_family = none)]
        pub fn titleHeight(&self) -> CGFloat;

        #[unsafe(method(frameOfColumn:))]
        #[unsafe(method_family = none)]
        pub fn frameOfColumn(&self, column: NSInteger) -> NSRect;

        #[unsafe(method(frameOfInsideOfColumn:))]
        #[unsafe(method_family = none)]
        pub fn frameOfInsideOfColumn(&self, column: NSInteger) -> NSRect;

        #[unsafe(method(frameOfRow:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn frameOfRow_inColumn(&self, row: NSInteger, column: NSInteger) -> NSRect;

        /// # Safety
        ///
        /// - `row` must be a valid pointer or null.
        /// - `column` must be a valid pointer or null.
        #[unsafe(method(getRow:column:forPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getRow_column_forPoint(
            &self,
            row: *mut NSInteger,
            column: *mut NSInteger,
            point: NSPoint,
        ) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(columnWidthForColumnContentWidth:))]
        #[unsafe(method_family = none)]
        pub fn columnWidthForColumnContentWidth(&self, column_content_width: CGFloat) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(columnContentWidthForColumnWidth:))]
        #[unsafe(method_family = none)]
        pub fn columnContentWidthForColumnWidth(&self, column_width: CGFloat) -> CGFloat;

        #[unsafe(method(columnResizingType))]
        #[unsafe(method_family = none)]
        pub fn columnResizingType(&self) -> NSBrowserColumnResizingType;

        /// Setter for [`columnResizingType`][Self::columnResizingType].
        #[unsafe(method(setColumnResizingType:))]
        #[unsafe(method_family = none)]
        pub fn setColumnResizingType(&self, column_resizing_type: NSBrowserColumnResizingType);

        #[unsafe(method(prefersAllColumnUserResizing))]
        #[unsafe(method_family = none)]
        pub fn prefersAllColumnUserResizing(&self) -> bool;

        /// Setter for [`prefersAllColumnUserResizing`][Self::prefersAllColumnUserResizing].
        #[unsafe(method(setPrefersAllColumnUserResizing:))]
        #[unsafe(method_family = none)]
        pub fn setPrefersAllColumnUserResizing(&self, prefers_all_column_user_resizing: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setWidth:ofColumn:))]
        #[unsafe(method_family = none)]
        pub fn setWidth_ofColumn(&self, column_width: CGFloat, column_index: NSInteger);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(widthOfColumn:))]
        #[unsafe(method_family = none)]
        pub fn widthOfColumn(&self, column: NSInteger) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rowHeight))]
        #[unsafe(method_family = none)]
        pub fn rowHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`rowHeight`][Self::rowHeight].
        #[unsafe(method(setRowHeight:))]
        #[unsafe(method_family = none)]
        pub fn setRowHeight(&self, row_height: CGFloat);

        #[unsafe(method(noteHeightOfRowsWithIndexesChanged:inColumn:))]
        #[unsafe(method_family = none)]
        pub fn noteHeightOfRowsWithIndexesChanged_inColumn(
            &self,
            index_set: &NSIndexSet,
            column_index: NSInteger,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setDefaultColumnWidth:))]
        #[unsafe(method_family = none)]
        pub fn setDefaultColumnWidth(&self, column_width: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(defaultColumnWidth))]
        #[unsafe(method_family = none)]
        pub fn defaultColumnWidth(&self) -> CGFloat;

        #[unsafe(method(columnsAutosaveName))]
        #[unsafe(method_family = none)]
        pub fn columnsAutosaveName(&self) -> Retained<NSBrowserColumnsAutosaveName>;

        /// Setter for [`columnsAutosaveName`][Self::columnsAutosaveName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setColumnsAutosaveName:))]
        #[unsafe(method_family = none)]
        pub fn setColumnsAutosaveName(&self, columns_autosave_name: &NSBrowserColumnsAutosaveName);

        #[unsafe(method(removeSavedColumnsWithAutosaveName:))]
        #[unsafe(method_family = none)]
        pub fn removeSavedColumnsWithAutosaveName(
            name: &NSBrowserColumnsAutosaveName,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(canDragRowsWithIndexes:inColumn:withEvent:))]
        #[unsafe(method_family = none)]
        pub fn canDragRowsWithIndexes_inColumn_withEvent(
            &self,
            row_indexes: &NSIndexSet,
            column: NSInteger,
            event: &NSEvent,
        ) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        /// # Safety
        ///
        /// `drag_image_offset` must be a valid pointer or null.
        #[unsafe(method(draggingImageForRowsWithIndexes:inColumn:withEvent:offset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn draggingImageForRowsWithIndexes_inColumn_withEvent_offset(
            &self,
            row_indexes: &NSIndexSet,
            column: NSInteger,
            event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSDragging")]
        #[unsafe(method(setDraggingSourceOperationMask:forLocal:))]
        #[unsafe(method_family = none)]
        pub fn setDraggingSourceOperationMask_forLocal(
            &self,
            mask: NSDragOperation,
            is_local: bool,
        );

        #[unsafe(method(allowsTypeSelect))]
        #[unsafe(method_family = none)]
        pub fn allowsTypeSelect(&self) -> bool;

        /// Setter for [`allowsTypeSelect`][Self::allowsTypeSelect].
        #[unsafe(method(setAllowsTypeSelect:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsTypeSelect(&self, allows_type_select: bool);

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: &NSColor);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(editItemAtIndexPath:withEvent:select:))]
        #[unsafe(method_family = none)]
        pub fn editItemAtIndexPath_withEvent_select(
            &self,
            index_path: &NSIndexPath,
            event: Option<&NSEvent>,
            select: bool,
        );
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSBrowser {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSBrowser {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSBrowser {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbrowsercolumnconfigurationdidchangenotification?language=objc)
    pub static NSBrowserColumnConfigurationDidChangeNotification: &'static NSNotificationName;
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbrowserdelegate?language=objc)
    pub unsafe trait NSBrowserDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:numberOfRowsInColumn:))]
        #[unsafe(method_family = none)]
        fn browser_numberOfRowsInColumn(&self, sender: &NSBrowser, column: NSInteger) -> NSInteger;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSMatrix",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(browser:createRowsForColumn:inMatrix:))]
        #[unsafe(method_family = none)]
        fn browser_createRowsForColumn_inMatrix(
            &self,
            sender: &NSBrowser,
            column: NSInteger,
            matrix: &NSMatrix,
        );

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:numberOfChildrenOfItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_numberOfChildrenOfItem(
            &self,
            browser: &NSBrowser,
            item: Option<&AnyObject>,
        ) -> NSInteger;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:child:ofItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_child_ofItem(
            &self,
            browser: &NSBrowser,
            index: NSInteger,
            item: Option<&AnyObject>,
        ) -> Retained<AnyObject>;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:isLeafItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_isLeafItem(&self, browser: &NSBrowser, item: Option<&AnyObject>) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:objectValueForItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_objectValueForItem(
            &self,
            browser: &NSBrowser,
            item: Option<&AnyObject>,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(browser:heightOfRow:inColumn:))]
        #[unsafe(method_family = none)]
        fn browser_heightOfRow_inColumn(
            &self,
            browser: &NSBrowser,
            row: NSInteger,
            column_index: NSInteger,
        ) -> CGFloat;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(rootItemForBrowser:))]
        #[unsafe(method_family = none)]
        fn rootItemForBrowser(&self, browser: &NSBrowser) -> Option<Retained<AnyObject>>;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// - `object` should be of the correct type.
        /// - `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:setObjectValue:forItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_setObjectValue_forItem(
            &self,
            browser: &NSBrowser,
            object: Option<&AnyObject>,
            item: Option<&AnyObject>,
        );

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:shouldEditItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_shouldEditItem(
            &self,
            browser: &NSBrowser,
            item: Option<&AnyObject>,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `cell` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:willDisplayCell:atRow:column:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_willDisplayCell_atRow_column(
            &self,
            sender: &NSBrowser,
            cell: &AnyObject,
            row: NSInteger,
            column: NSInteger,
        );

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:titleOfColumn:))]
        #[unsafe(method_family = none)]
        fn browser_titleOfColumn(
            &self,
            sender: &NSBrowser,
            column: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:selectCellWithString:inColumn:))]
        #[unsafe(method_family = none)]
        fn browser_selectCellWithString_inColumn(
            &self,
            sender: &NSBrowser,
            title: &NSString,
            column: NSInteger,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:selectRow:inColumn:))]
        #[unsafe(method_family = none)]
        fn browser_selectRow_inColumn(
            &self,
            sender: &NSBrowser,
            row: NSInteger,
            column: NSInteger,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:isColumnValid:))]
        #[unsafe(method_family = none)]
        fn browser_isColumnValid(&self, sender: &NSBrowser, column: NSInteger) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browserWillScroll:))]
        #[unsafe(method_family = none)]
        fn browserWillScroll(&self, sender: &NSBrowser);

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browserDidScroll:))]
        #[unsafe(method_family = none)]
        fn browserDidScroll(&self, sender: &NSBrowser);

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(browser:shouldSizeColumn:forUserResize:toWidth:))]
        #[unsafe(method_family = none)]
        fn browser_shouldSizeColumn_forUserResize_toWidth(
            &self,
            browser: &NSBrowser,
            column_index: NSInteger,
            for_user_resize: bool,
            suggested_width: CGFloat,
        ) -> CGFloat;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(browser:sizeToFitWidthOfColumn:))]
        #[unsafe(method_family = none)]
        fn browser_sizeToFitWidthOfColumn(
            &self,
            browser: &NSBrowser,
            column_index: NSInteger,
        ) -> CGFloat;

        #[optional]
        #[unsafe(method(browserColumnConfigurationDidChange:))]
        #[unsafe(method_family = none)]
        fn browserColumnConfigurationDidChange(&self, notification: &NSNotification);

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:shouldShowCellExpansionForRow:column:))]
        #[unsafe(method_family = none)]
        fn browser_shouldShowCellExpansionForRow_column(
            &self,
            browser: &NSBrowser,
            row: NSInteger,
            column: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(browser:writeRowsWithIndexes:inColumn:toPasteboard:))]
        #[unsafe(method_family = none)]
        fn browser_writeRowsWithIndexes_inColumn_toPasteboard(
            &self,
            browser: &NSBrowser,
            row_indexes: &NSIndexSet,
            column: NSInteger,
            pasteboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use NSFilePromiseReceiver objects instead"]
        #[optional]
        #[unsafe(method(browser:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes:inColumn:))]
        #[unsafe(method_family = none)]
        fn browser_namesOfPromisedFilesDroppedAtDestination_forDraggedRowsWithIndexes_inColumn(
            &self,
            browser: &NSBrowser,
            drop_destination: &NSURL,
            row_indexes: &NSIndexSet,
            column: NSInteger,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(browser:canDragRowsWithIndexes:inColumn:withEvent:))]
        #[unsafe(method_family = none)]
        fn browser_canDragRowsWithIndexes_inColumn_withEvent(
            &self,
            browser: &NSBrowser,
            row_indexes: &NSIndexSet,
            column: NSInteger,
            event: &NSEvent,
        ) -> bool;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSEvent",
            feature = "NSImage",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `drag_image_offset` must be a valid pointer.
        #[optional]
        #[unsafe(method(browser:draggingImageForRowsWithIndexes:inColumn:withEvent:offset:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_draggingImageForRowsWithIndexes_inColumn_withEvent_offset(
            &self,
            browser: &NSBrowser,
            row_indexes: &NSIndexSet,
            column: NSInteger,
            event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Option<Retained<NSImage>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// - `row` must be a valid pointer.
        /// - `column` must be a valid pointer.
        /// - `drop_operation` must be a valid pointer.
        #[optional]
        #[unsafe(method(browser:validateDrop:proposedRow:column:dropOperation:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_validateDrop_proposedRow_column_dropOperation(
            &self,
            browser: &NSBrowser,
            info: &ProtocolObject<dyn NSDraggingInfo>,
            row: NonNull<NSInteger>,
            column: NonNull<NSInteger>,
            drop_operation: NonNull<NSBrowserDropOperation>,
        ) -> NSDragOperation;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(browser:acceptDrop:atRow:column:dropOperation:))]
        #[unsafe(method_family = none)]
        fn browser_acceptDrop_atRow_column_dropOperation(
            &self,
            browser: &NSBrowser,
            info: &ProtocolObject<dyn NSDraggingInfo>,
            row: NSInteger,
            column: NSInteger,
            drop_operation: NSBrowserDropOperation,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:typeSelectStringForRow:inColumn:))]
        #[unsafe(method_family = none)]
        fn browser_typeSelectStringForRow_inColumn(
            &self,
            browser: &NSBrowser,
            row: NSInteger,
            column: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(browser:shouldTypeSelectForEvent:withCurrentSearchString:))]
        #[unsafe(method_family = none)]
        fn browser_shouldTypeSelectForEvent_withCurrentSearchString(
            &self,
            browser: &NSBrowser,
            event: &NSEvent,
            search_string: Option<&NSString>,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:nextTypeSelectMatchFromRow:toRow:inColumn:forString:))]
        #[unsafe(method_family = none)]
        fn browser_nextTypeSelectMatchFromRow_toRow_inColumn_forString(
            &self,
            browser: &NSBrowser,
            start_row: NSInteger,
            end_row: NSInteger,
            column: NSInteger,
            search_string: Option<&NSString>,
        ) -> NSInteger;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView",
            feature = "NSViewController"
        ))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:previewViewControllerForLeafItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_previewViewControllerForLeafItem(
            &self,
            browser: &NSBrowser,
            item: &AnyObject,
        ) -> Option<Retained<NSViewController>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView",
            feature = "NSViewController"
        ))]
        /// # Safety
        ///
        /// `item` should be of the correct type.
        #[optional]
        #[unsafe(method(browser:headerViewControllerForItem:))]
        #[unsafe(method_family = none)]
        unsafe fn browser_headerViewControllerForItem(
            &self,
            browser: &NSBrowser,
            item: Option<&AnyObject>,
        ) -> Option<Retained<NSViewController>>;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:didChangeLastColumn:toColumn:))]
        #[unsafe(method_family = none)]
        fn browser_didChangeLastColumn_toColumn(
            &self,
            browser: &NSBrowser,
            old_last_column: NSInteger,
            column: NSInteger,
        );

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(browser:selectionIndexesForProposedSelection:inColumn:))]
        #[unsafe(method_family = none)]
        fn browser_selectionIndexesForProposedSelection_inColumn(
            &self,
            browser: &NSBrowser,
            proposed_selection_indexes: &NSIndexSet,
            column: NSInteger,
        ) -> Retained<NSIndexSet>;
    }
);

/// NSDeprecated.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSBrowser {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(setAcceptsArrowKeys:))]
        #[unsafe(method_family = none)]
        pub fn setAcceptsArrowKeys(&self, flag: bool);

        #[deprecated]
        #[unsafe(method(acceptsArrowKeys))]
        #[unsafe(method_family = none)]
        pub fn acceptsArrowKeys(&self) -> bool;

        #[deprecated]
        #[unsafe(method(displayColumn:))]
        #[unsafe(method_family = none)]
        pub fn displayColumn(&self, column: NSInteger);

        #[deprecated]
        #[unsafe(method(displayAllColumns))]
        #[unsafe(method_family = none)]
        pub fn displayAllColumns(&self);

        #[cfg(feature = "NSScroller")]
        /// # Safety
        ///
        /// `sender` might not allow `None`.
        #[deprecated]
        #[unsafe(method(scrollViaScroller:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollViaScroller(&self, sender: Option<&NSScroller>);

        #[deprecated]
        #[unsafe(method(updateScroller))]
        #[unsafe(method_family = none)]
        pub fn updateScroller(&self);

        /// # Safety
        ///
        /// `factory_id` probably has further requirements.
        #[deprecated = "Use the item based NSBrowser instead"]
        #[unsafe(method(setMatrixClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMatrixClass(&self, factory_id: &AnyClass);

        #[deprecated = "Use the item based NSBrowser instead"]
        #[unsafe(method(matrixClass))]
        #[unsafe(method_family = none)]
        pub fn matrixClass(&self) -> &'static AnyClass;

        #[cfg(feature = "NSMatrix")]
        #[deprecated = "Use the item based NSBrowser instead"]
        #[unsafe(method(columnOfMatrix:))]
        #[unsafe(method_family = none)]
        pub fn columnOfMatrix(&self, matrix: &NSMatrix) -> NSInteger;

        #[cfg(feature = "NSMatrix")]
        #[deprecated = "Use the item based NSBrowser instead"]
        #[unsafe(method(matrixInColumn:))]
        #[unsafe(method_family = none)]
        pub fn matrixInColumn(&self, column: NSInteger) -> Option<Retained<NSMatrix>>;
    );
}
