import {
  encodeQueryParams
} from "serialize-query-params";
import { decodedParamCache } from "./decodedParamCache";
import { extendParamConfigForKeys } from "./inheritedParams";
import { getLatestDecodedValues } from "./latestValues";
import { memoSearchStringToObject } from "./memoSearchStringToObject";
import { removeDefaults } from "./removeDefaults";
import { applyUrlNames } from "./urlName";
function getUpdatedSearchString({
  changes,
  updateType,
  currentSearchString,
  paramConfigMap: baseParamConfigMap,
  options
}) {
  const { searchStringToObject, objectToSearchString } = options;
  if (updateType == null)
    updateType = options.updateType;
  let encodedChanges;
  const parsedParams = memoSearchStringToObject(
    searchStringToObject,
    currentSearchString
  );
  const paramConfigMap = extendParamConfigForKeys(
    baseParamConfigMap,
    Object.keys(changes),
    options.params
  );
  let changesToUse;
  if (typeof changes === "function") {
    const latestValues = getLatestDecodedValues(
      parsedParams,
      paramConfigMap,
      decodedParamCache
    );
    changesToUse = changes(latestValues);
  } else {
    changesToUse = changes;
  }
  encodedChanges = encodeQueryParams(paramConfigMap, changesToUse);
  if (options.removeDefaultsFromUrl) {
    removeDefaults(encodedChanges, paramConfigMap);
  }
  encodedChanges = applyUrlNames(encodedChanges, paramConfigMap);
  let newSearchString;
  if (updateType === "push" || updateType === "replace") {
    newSearchString = objectToSearchString(encodedChanges);
  } else {
    newSearchString = objectToSearchString({
      ...parsedParams,
      ...encodedChanges
    });
  }
  if ((newSearchString == null ? void 0 : newSearchString.length) && newSearchString[0] !== "?") {
    newSearchString = `?${newSearchString}`;
  }
  return newSearchString != null ? newSearchString : "";
}
function updateSearchString({
  searchString,
  adapter,
  navigate,
  updateType
}) {
  const currentLocation = adapter.location;
  const newLocation = {
    ...currentLocation,
    search: searchString
  };
  if (navigate) {
    if (typeof updateType === "string" && updateType.startsWith("replace")) {
      adapter.replace(newLocation);
    } else {
      adapter.push(newLocation);
    }
  }
}
const immediateTask = (task) => task();
const timeoutTask = (task) => setTimeout(() => task(), 0);
const updateQueue = [];
function enqueueUpdate(args, { immediate } = {}) {
  updateQueue.push(args);
  let scheduleTask = immediate ? immediateTask : timeoutTask;
  if (updateQueue.length === 1) {
    scheduleTask(() => {
      const updates = updateQueue.slice();
      updateQueue.length = 0;
      const initialSearchString = updates[0].currentSearchString;
      let searchString;
      for (let i = 0; i < updates.length; ++i) {
        const modifiedUpdate = i === 0 ? updates[i] : { ...updates[i], currentSearchString: searchString };
        searchString = getUpdatedSearchString(modifiedUpdate);
      }
      if (args.options.skipUpdateWhenNoChange && searchString === initialSearchString) {
        return;
      }
      updateSearchString({
        searchString: searchString != null ? searchString : "",
        adapter: updates[updates.length - 1].adapter,
        navigate: true,
        updateType: updates[updates.length - 1].updateType
      });
    });
  }
}
export {
  enqueueUpdate,
  getUpdatedSearchString,
  updateSearchString
};
//# sourceMappingURL=updateSearchString.js.map
