'use client';
import { jsxs, jsx } from 'react/jsx-runtime';
import cx from 'clsx';
import { factory, useProps, useStyles, Box, CopyButton, Tooltip, ActionIcon, ScrollArea } from '@mantine/core';
import { CopyIcon } from './CopyIcon.mjs';
import { useHighlight } from './use-highlight.mjs';
import _classes from './CodeHighlight.module.css.mjs';
import themeClasses from './CodeHighlight.theme.module.css.mjs';

const classes = { ..._classes, root: cx(_classes.root, themeClasses.theme) };
const defaultProps = {
  copyLabel: "Copy code",
  copiedLabel: "Copied",
  language: "tsx",
  withCopyButton: true
};
const CodeHighlight = factory((_props, ref) => {
  const props = useProps("CodeHighlight", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    children,
    code,
    copiedLabel,
    copyLabel,
    language,
    withCopyButton,
    highlightOnClient,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "CodeHighlight",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled
  });
  const getCodeProps = useHighlight({
    code,
    language,
    highlightOnClient
  });
  return /* @__PURE__ */ jsxs(Box, { ...getStyles("root"), ref, ...others, dir: "ltr", children: [
    withCopyButton && /* @__PURE__ */ jsx(CopyButton, { value: code.trim(), children: ({ copied, copy }) => /* @__PURE__ */ jsx(Tooltip, { label: copied ? copiedLabel : copyLabel, fz: "sm", position: "left", children: /* @__PURE__ */ jsx(ActionIcon, { onClick: copy, variant: "none", ...getStyles("copy"), children: /* @__PURE__ */ jsx(CopyIcon, { copied }) }) }) }),
    /* @__PURE__ */ jsx(ScrollArea, { type: "hover", dir: "ltr", offsetScrollbars: false, children: /* @__PURE__ */ jsx("pre", { ...getStyles("pre"), children: /* @__PURE__ */ jsx("code", { ...getStyles("code"), ...getCodeProps() }) }) })
  ] });
});
CodeHighlight.displayName = "@mantine/core/CodeHighlight";
CodeHighlight.classes = classes;

export { CodeHighlight };
//# sourceMappingURL=CodeHighlight.mjs.map
