'use client';
'use strict';

var react = require('react');
var hljs = require('highlight.js');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var hljs__default = /*#__PURE__*/_interopDefault(hljs);

function useHighlight({ code, language, highlightOnClient }) {
  const lang = hljs__default.default.getLanguage(language) ? language : "plaintext";
  const getHighlightedCode = () => hljs__default.default.highlight(code.trim(), { language: lang }).value;
  const [highlighted, setHighlighted] = react.useState(!highlightOnClient);
  const [highlightedCode, setHighlightedCode] = react.useState(
    highlightOnClient ? code : getHighlightedCode()
  );
  const getCodeProps = () => highlighted ? { dangerouslySetInnerHTML: { __html: highlightedCode } } : { children: code.trim() };
  react.useEffect(() => {
    if (highlightOnClient) {
      setHighlightedCode(getHighlightedCode());
      setHighlighted(true);
    }
  }, []);
  react.useEffect(() => {
    setHighlightedCode(getHighlightedCode());
  }, [code]);
  return getCodeProps;
}

exports.useHighlight = useHighlight;
//# sourceMappingURL=use-highlight.cjs.map
