package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagRouteProtocolBgp invokes the smartag.ModifySagRouteProtocolBgp API synchronously
func (client *Client) ModifySagRouteProtocolBgp(request *ModifySagRouteProtocolBgpRequest) (response *ModifySagRouteProtocolBgpResponse, err error) {
	response = CreateModifySagRouteProtocolBgpResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagRouteProtocolBgpWithChan invokes the smartag.ModifySagRouteProtocolBgp API asynchronously
func (client *Client) ModifySagRouteProtocolBgpWithChan(request *ModifySagRouteProtocolBgpRequest) (<-chan *ModifySagRouteProtocolBgpResponse, <-chan error) {
	responseChan := make(chan *ModifySagRouteProtocolBgpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagRouteProtocolBgp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagRouteProtocolBgpWithCallback invokes the smartag.ModifySagRouteProtocolBgp API asynchronously
func (client *Client) ModifySagRouteProtocolBgpWithCallback(request *ModifySagRouteProtocolBgpRequest, callback func(response *ModifySagRouteProtocolBgpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagRouteProtocolBgpResponse
		var err error
		defer close(result)
		response, err = client.ModifySagRouteProtocolBgp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagRouteProtocolBgpRequest is the request struct for api ModifySagRouteProtocolBgp
type ModifySagRouteProtocolBgpRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	KeepAlive            requests.Integer `position:"Query" name:"KeepAlive"`
	HoldTime             requests.Integer `position:"Query" name:"HoldTime"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AdvertiseIps         string           `position:"Query" name:"AdvertiseIps"`
	RouterId             string           `position:"Query" name:"RouterId"`
	LocalAs              requests.Integer `position:"Query" name:"LocalAs"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// ModifySagRouteProtocolBgpResponse is the response struct for api ModifySagRouteProtocolBgp
type ModifySagRouteProtocolBgpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagRouteProtocolBgpRequest creates a request to invoke ModifySagRouteProtocolBgp API
func CreateModifySagRouteProtocolBgpRequest() (request *ModifySagRouteProtocolBgpRequest) {
	request = &ModifySagRouteProtocolBgpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagRouteProtocolBgp", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagRouteProtocolBgpResponse creates a response to parse from ModifySagRouteProtocolBgp response
func CreateModifySagRouteProtocolBgpResponse() (response *ModifySagRouteProtocolBgpResponse) {
	response = &ModifySagRouteProtocolBgpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
