package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssBucketInfo invokes the sgw.DescribeOssBucketInfo API synchronously
func (client *Client) DescribeOssBucketInfo(request *DescribeOssBucketInfoRequest) (response *DescribeOssBucketInfoResponse, err error) {
	response = CreateDescribeOssBucketInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssBucketInfoWithChan invokes the sgw.DescribeOssBucketInfo API asynchronously
func (client *Client) DescribeOssBucketInfoWithChan(request *DescribeOssBucketInfoRequest) (<-chan *DescribeOssBucketInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeOssBucketInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssBucketInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssBucketInfoWithCallback invokes the sgw.DescribeOssBucketInfo API asynchronously
func (client *Client) DescribeOssBucketInfoWithCallback(request *DescribeOssBucketInfoRequest, callback func(response *DescribeOssBucketInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssBucketInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssBucketInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssBucketInfoRequest is the request struct for api DescribeOssBucketInfo
type DescribeOssBucketInfoRequest struct {
	*requests.RpcRequest
	BucketEndpoint string `position:"Query" name:"BucketEndpoint"`
	Type           string `position:"Query" name:"Type"`
	SecurityToken  string `position:"Query" name:"SecurityToken"`
	BucketName     string `position:"Query" name:"BucketName"`
	GatewayId      string `position:"Query" name:"GatewayId"`
}

// DescribeOssBucketInfoResponse is the response struct for api DescribeOssBucketInfo
type DescribeOssBucketInfoResponse struct {
	*responses.BaseResponse
	RequestId                     string `json:"RequestId" xml:"RequestId"`
	Success                       bool   `json:"Success" xml:"Success"`
	Code                          string `json:"Code" xml:"Code"`
	Message                       string `json:"Message" xml:"Message"`
	IsArchive                     bool   `json:"IsArchive" xml:"IsArchive"`
	IsBackToResource              bool   `json:"IsBackToResource" xml:"IsBackToResource"`
	PollingInterval               int    `json:"PollingInterval" xml:"PollingInterval"`
	IsSupportServerSideEncryption bool   `json:"IsSupportServerSideEncryption" xml:"IsSupportServerSideEncryption"`
	IsFresh                       bool   `json:"IsFresh" xml:"IsFresh"`
	StorageSize                   int64  `json:"StorageSize" xml:"StorageSize"`
	IsVersioning                  bool   `json:"IsVersioning" xml:"IsVersioning"`
}

// CreateDescribeOssBucketInfoRequest creates a request to invoke DescribeOssBucketInfo API
func CreateDescribeOssBucketInfoRequest() (request *DescribeOssBucketInfoRequest) {
	request = &DescribeOssBucketInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeOssBucketInfo", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOssBucketInfoResponse creates a response to parse from DescribeOssBucketInfo response
func CreateDescribeOssBucketInfoResponse() (response *DescribeOssBucketInfoResponse) {
	response = &DescribeOssBucketInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
