package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEnvironment invokes the retailcloud.CreateEnvironment API synchronously
func (client *Client) CreateEnvironment(request *CreateEnvironmentRequest) (response *CreateEnvironmentResponse, err error) {
	response = CreateCreateEnvironmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEnvironmentWithChan invokes the retailcloud.CreateEnvironment API asynchronously
func (client *Client) CreateEnvironmentWithChan(request *CreateEnvironmentRequest) (<-chan *CreateEnvironmentResponse, <-chan error) {
	responseChan := make(chan *CreateEnvironmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEnvironment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEnvironmentWithCallback invokes the retailcloud.CreateEnvironment API asynchronously
func (client *Client) CreateEnvironmentWithCallback(request *CreateEnvironmentRequest, callback func(response *CreateEnvironmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEnvironmentResponse
		var err error
		defer close(result)
		response, err = client.CreateEnvironment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEnvironmentRequest is the request struct for api CreateEnvironment
type CreateEnvironmentRequest struct {
	*requests.RpcRequest
	EnvName     string           `position:"Query" name:"EnvName"`
	Replicas    requests.Integer `position:"Query" name:"Replicas"`
	AppId       requests.Integer `position:"Query" name:"AppId"`
	EnvType     requests.Integer `position:"Query" name:"EnvType"`
	AppSchemaId requests.Integer `position:"Query" name:"AppSchemaId"`
	ClusterId   string           `position:"Query" name:"ClusterId"`
	Region      string           `position:"Query" name:"Region"`
}

// CreateEnvironmentResponse is the response struct for api CreateEnvironment
type CreateEnvironmentResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateEnvironmentRequest creates a request to invoke CreateEnvironment API
func CreateCreateEnvironmentRequest() (request *CreateEnvironmentRequest) {
	request = &CreateEnvironmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "CreateEnvironment", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateEnvironmentResponse creates a response to parse from CreateEnvironment response
func CreateCreateEnvironmentResponse() (response *CreateEnvironmentResponse) {
	response = &CreateEnvironmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
