package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelPolarxOrder invokes the polardbx.CancelPolarxOrder API synchronously
func (client *Client) CancelPolarxOrder(request *CancelPolarxOrderRequest) (response *CancelPolarxOrderResponse, err error) {
	response = CreateCancelPolarxOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CancelPolarxOrderWithChan invokes the polardbx.CancelPolarxOrder API asynchronously
func (client *Client) CancelPolarxOrderWithChan(request *CancelPolarxOrderRequest) (<-chan *CancelPolarxOrderResponse, <-chan error) {
	responseChan := make(chan *CancelPolarxOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelPolarxOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelPolarxOrderWithCallback invokes the polardbx.CancelPolarxOrder API asynchronously
func (client *Client) CancelPolarxOrderWithCallback(request *CancelPolarxOrderRequest, callback func(response *CancelPolarxOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelPolarxOrderResponse
		var err error
		defer close(result)
		response, err = client.CancelPolarxOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelPolarxOrderRequest is the request struct for api CancelPolarxOrder
type CancelPolarxOrderRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	ScaleOutToken  string `position:"Query" name:"ScaleOutToken"`
}

// CancelPolarxOrderResponse is the response struct for api CancelPolarxOrder
type CancelPolarxOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelPolarxOrderRequest creates a request to invoke CancelPolarxOrder API
func CreateCancelPolarxOrderRequest() (request *CancelPolarxOrderRequest) {
	request = &CancelPolarxOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "CancelPolarxOrder", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelPolarxOrderResponse creates a response to parse from CancelPolarxOrder response
func CreateCancelPolarxOrderResponse() (response *CancelPolarxOrderResponse) {
	response = &CancelPolarxOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
