package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopIProductionJob invokes the mts.StopIProductionJob API synchronously
func (client *Client) StopIProductionJob(request *StopIProductionJobRequest) (response *StopIProductionJobResponse, err error) {
	response = CreateStopIProductionJobResponse()
	err = client.DoAction(request, response)
	return
}

// StopIProductionJobWithChan invokes the mts.StopIProductionJob API asynchronously
func (client *Client) StopIProductionJobWithChan(request *StopIProductionJobRequest) (<-chan *StopIProductionJobResponse, <-chan error) {
	responseChan := make(chan *StopIProductionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopIProductionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopIProductionJobWithCallback invokes the mts.StopIProductionJob API asynchronously
func (client *Client) StopIProductionJobWithCallback(request *StopIProductionJobRequest, callback func(response *StopIProductionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopIProductionJobResponse
		var err error
		defer close(result)
		response, err = client.StopIProductionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopIProductionJobRequest is the request struct for api StopIProductionJob
type StopIProductionJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobId                string           `position:"Query" name:"JobId"`
}

// StopIProductionJobResponse is the response struct for api StopIProductionJob
type StopIProductionJobResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopIProductionJobRequest creates a request to invoke StopIProductionJob API
func CreateStopIProductionJobRequest() (request *StopIProductionJobRequest) {
	request = &StopIProductionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "StopIProductionJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopIProductionJobResponse creates a response to parse from StopIProductionJob response
func CreateStopIProductionJobResponse() (response *StopIProductionJobResponse) {
	response = &StopIProductionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
