package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventConfig invokes the cloudcallcenter.DeleteEventConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deleteeventconfig.html
func (client *Client) DeleteEventConfig(request *DeleteEventConfigRequest) (response *DeleteEventConfigResponse, err error) {
	response = CreateDeleteEventConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventConfigWithChan invokes the cloudcallcenter.DeleteEventConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deleteeventconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEventConfigWithChan(request *DeleteEventConfigRequest) (<-chan *DeleteEventConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteEventConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventConfigWithCallback invokes the cloudcallcenter.DeleteEventConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deleteeventconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEventConfigWithCallback(request *DeleteEventConfigRequest, callback func(response *DeleteEventConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventConfigRequest is the request struct for api DeleteEventConfig
type DeleteEventConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteEventConfigResponse is the response struct for api DeleteEventConfig
type DeleteEventConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateDeleteEventConfigRequest creates a request to invoke DeleteEventConfig API
func CreateDeleteEventConfigRequest() (request *DeleteEventConfigRequest) {
	request = &DeleteEventConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DeleteEventConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEventConfigResponse creates a response to parse from DeleteEventConfig response
func CreateDeleteEventConfigResponse() (response *DeleteEventConfigResponse) {
	response = &DeleteEventConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
