%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x4142434445464748", "0x5152535455565758", "0xAAAABBBBCCCCDDDD", "0xEEEEFFFF11112222"],
    "XMM1": ["0x6162636465666768", "0x7172737475767778", "0xFFFFCCCCDDDDEEEE", "0xAAAABBBB88889999"],
    "XMM2": ["0x4546474845464748", "0x4546474845464748", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x7172737471727374", "0x7172737471727374", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0x4546474845464748", "0x4546474845464748", "0xCCCCDDDDCCCCDDDD", "0xCCCCDDDDCCCCDDDD"],
    "XMM5": ["0x7172737471727374", "0x7172737471727374", "0xAAAABBBBAAAABBBB", "0xAAAABBBBAAAABBBB"],
    "XMM6": ["0x4142434445464748", "0x5152535455565758", "0xAAAABBBBCCCCDDDD", "0xEEEEFFFF11112222"],
    "XMM7": ["0x6162636465666768", "0x7172737475767778", "0x0000000000000000", "0x0000000000000000"],
    "XMM8": ["0x5556575845464748", "0x5556575845464748", "0x11112222CCCCDDDD", "0x11112222CCCCDDDD"],
    "XMM9": ["0x7576777865666768", "0x7576777865666768", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

vpshufd xmm2, xmm0, 0x0
vpshufd xmm3, xmm1, 0xFF

vpshufd ymm4, ymm0, 0x0
vpshufd ymm5, ymm1, 0xFF

; Shouldn't modify vector (selector is [3, 2, 1, 0])
; Which would effectively place elements in their
; same location
vpshufd ymm6, ymm0, 0b11100100
vpshufd xmm7, xmm1, 0b11100100

; [2, 0, 2, 0] shuffling
vpshufd ymm8, ymm0, 0b10001000
vpshufd xmm9, xmm1, 0b10001000

hlt

align 32
.data:
dq 0x4142434445464748
dq 0x5152535455565758
dq 0xAAAABBBBCCCCDDDD
dq 0xEEEEFFFF11112222

dq 0x6162636465666768
dq 0x7172737475767778
dq 0xFFFFCCCCDDDDEEEE
dq 0xAAAABBBB88889999
