---
title: "Uloz.to"
description: "Rclone docs for Uloz.to"
versionIntroduced: "v1.66"
---

# {{< icon "fas fa-angle-double-down" >}} Uloz.to

Paths are specified as `remote:path`

Paths may be as deep as required, e.g. `remote:directory/subdirectory`.

The initial setup for Uloz.to involves filling in the user credentials.
`rclone config` walks you through it.

## Configuration

Here is an example of how to make a remote called `remote`.  First run:

```sh
rclone config
```

This will guide you through an interactive setup process:

```text
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> remote
Type of storage to configure.
Choose a number from below, or type in your own value
[snip]
XX / Uloz.to
   \ "ulozto"
[snip]
Storage> ulozto

Option app_token.
The application token identifying the app. An app API key can be either found in the API doc 
https://uloz.to/upload-resumable-api-beta or obtained from customer service.
Enter a value. Press Enter to leave empty.
app_token> token_value

Option username.
The username of the principal to operate as.
Enter a value. Press Enter to leave empty.
username> user

Option password.
The password for the user.
Choose an alternative below. Press Enter for the default (n).
y) Yes, type in my own password
g) Generate random password
n) No, leave this optional password blank (default)
y/g/n> y
Enter the password:
password:
Confirm the password:
password:

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Keep this "remote" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

Once configured you can then use `rclone` like this,

List folders in root level folder:

```sh
rclone lsd remote:
```

List all the files in your root folder:

```sh
rclone ls remote:
```

To copy a local folder to a Uloz.to folder called backup:

```sh
rclone copy /home/source remote:backup
```

### User credentials

The only reliable method is to authenticate the user using
username and password. Uloz.to offers an API key as well, but
it's reserved for the use of Uloz.to's in-house application
and using it in different circumstances is unreliable.

### Modification times and hashes

Uloz.to doesn't allow the user to set a custom modification time,
or retrieve the hashes after upload. As a result, the integration
uses a free form field the API provides to encode client-provided
timestamps and hashes. Timestamps are stored with microsecond
precision.

A server calculated MD5 hash of the file is verified upon upload.
Afterwards, the backend only serves the client-side calculated
hashes. Hashes can also be retrieved upon creating a file download
link, but it's impractical for `list`-like use cases.

### Restricted filename characters

In addition to the [default restricted characters set](/overview/#restricted-characters)
the following characters are also replaced:

| Character | Value | Replacement |
| --------- |:-----:|:-----------:|
| \         | 0x5C  | ＼           |

Invalid UTF-8 bytes will also be [replaced](/overview/#invalid-utf8),
as they can't be used in JSON strings.

### Transfers

All files are currently uploaded using a single HTTP request, so
for uploading large files a stable connection is necessary.  Rclone will
upload up to `--transfers` chunks at the same time (shared among all
uploads).

### Deleting files

By default, files are moved to the recycle bin whereas folders
are deleted immediately. Trashed files are permanently deleted after
30 days in the recycle bin.

Emptying the trash is currently not implemented in rclone.

### Root folder ID

You can set the `root_folder_slug` for rclone.  This is the folder
(identified by its `Folder slug`) that rclone considers to be the root
of your Uloz.to drive.

Normally you will leave this blank and rclone will determine the
correct root to use itself. However you can set this to restrict rclone
to a specific folder hierarchy.

In order to do this you will have to find the `Folder slug` of the
folder you wish to use as root.  This will be the last segment
of the URL when you open the relevant folder in the Uloz.to web
interface.

For example, for exploring a folder with URL
`https://uloz.to/fm/my-files/foobar`, `foobar` should be used as the
root slug.

`root_folder_slug` can be used alongside a specific path in the remote
path. For example, if your remote's `root_folder_slug` corresponds to `/foo/bar`,
`remote:baz/qux` will refer to `ABSOLUTE_ULOZTO_ROOT/foo/bar/baz/qux`.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/ulozto/ulozto.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to ulozto (Uloz.to).

#### --ulozto-app-token

The application token identifying the app. An app API key can be either found in the API
doc https://uloz.to/upload-resumable-api-beta or obtained from customer service.

Properties:

- Config:      app_token
- Env Var:     RCLONE_ULOZTO_APP_TOKEN
- Type:        string
- Required:    false

#### --ulozto-username

The username of the principal to operate as.

Properties:

- Config:      username
- Env Var:     RCLONE_ULOZTO_USERNAME
- Type:        string
- Required:    false

#### --ulozto-password

The password for the user.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      password
- Env Var:     RCLONE_ULOZTO_PASSWORD
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to ulozto (Uloz.to).

#### --ulozto-root-folder-slug

If set, rclone will use this folder as the root folder for all operations. For example,
if the slug identifies 'foo/bar/', 'ulozto:baz' is equivalent to 'ulozto:foo/bar/baz' without
any root slug set.

Properties:

- Config:      root_folder_slug
- Env Var:     RCLONE_ULOZTO_ROOT_FOLDER_SLUG
- Type:        string
- Required:    false

#### --ulozto-list-page-size

The size of a single page for list commands. 1-500

Properties:

- Config:      list_page_size
- Env Var:     RCLONE_ULOZTO_LIST_PAGE_SIZE
- Type:        int
- Default:     500

#### --ulozto-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_ULOZTO_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,Del,Ctl,InvalidUtf8,Dot

#### --ulozto-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_ULOZTO_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}

## Limitations

Uloz.to file names can't have the `\` character in.  rclone maps this to
and from an identical looking unicode equivalent `＼` (U+FF3C Fullwidth
Reverse Solidus).

Uloz.to only supports filenames up to 255 characters in length.

Uloz.to rate limits access to the API, but exact details are undisclosed. 
Practical testing reveals that hitting the rate limit during normal use
is very rare, although not impossible with higher number of concurrently 
uploaded files.

`rclone about` is not supported by the Uloz.to backend. Although 
there's an endpoint to retrieve the information for the UI, it's not 
exposed in the API.  Backends without this capability cannot determine 
free space for an rclone mount or use policy `mfs` (most free space) 
as a member of an rclone union remote.

See [List of backends that do not support rclone about](https://rclone.org/overview/#optional-features) and [rclone about](https://rclone.org/commands/rclone_about/)
