// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief e+e- R measurement
  class MUPI_1973_I95215 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(MUPI_1973_I95215);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      book(_c_hadrons, 1, 1, 1);
      book(_c_muons, "/TMP/sigma_muons", refData<YODA::BinnedEstimate<string>>(1, 1, 1));
      for (const string& en : _c_hadrons.binning().edges<0>()) {
        const double eval = stod(en);
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        ++nCount[p.pid()];
        ++ntotal;
      }
      if (nCount[-13]==1 and nCount[13]==1 &&	 ntotal==2+nCount[22]) { // mu+mu- + photons
        _c_muons->fill(_sqs);
      }
      else { // everything else
        _c_hadrons->fill(_sqs);
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      BinnedEstimatePtr<string> mult;
      book(mult, 1, 1, 2);
      divide(_c_hadrons,_c_muons,mult);
      scale(_c_hadrons, crossSection()/ sumOfWeights() /nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _c_hadrons, _c_muons;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(MUPI_1973_I95215);


}
