;;; swift-mode-standard-types.el --- Major-mode for Apple's Swift programming language, Standard Types. -*- lexical-binding: t -*-

;; Copyright (C) 2018-2020 taku0

;; Author: taku0 (http://github.com/taku0)

;; This file is not part of GNU Emacs.

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; Types and members of the standard library and Foundation framework.

;;; Code:


(defconst swift-mode:foundation-types
  '("AcceptPolicy"
    "ActivationType"
    "ActivityOptions"
    "AddingOptions"
    "AffineTransform"
    "Array"
    "ArrayLiteralElement"
    "AuthChallengeDisposition"
    "BackgroundTaskCancelledReason"
    "Base64DecodingOptions"
    "Base64EncodingOptions"
    "Behavior"
    "BlockOperation"
    "BookmarkCreationOptions"
    "BookmarkFileCreationOptions"
    "BookmarkResolutionOptions"
    "BooleanLiteralType"
    "Bundle"
    "ByteCountFormatter"
    "CGFloat"
    "CachePolicy"
    "CachedURLResponse"
    "CalculationError"
    "Calendar"
    "CenterType"
    "CharacterSet"
    "CheckingType"
    "CloseCode"
    "CocoaError"
    "Codable"
    "Code"
    "Comparator"
    "CompareOptions"
    "ComparisonResult"
    "CompletionHandler"
    "Component"
    "CompressionAlgorithm"
    "ContentKind"
    "Context"
    "CountStyle"
    "CustomNSError"
    "DTDKind"
    "Data"
    "DataDecodingStrategy"
    "DataEncodingStrategy"
    "DataTaskPublisher"
    "Date"
    "DateComponents"
    "DateComponentsFormatter"
    "DateDecodingStrategy"
    "DateEncodingStrategy"
    "DateFormatter"
    "DateInterval"
    "DateIntervalFormatter"
    "DateTimeStyle"
    "Deallocator"
    "Decimal"
    "DecodingFailurePolicy"
    "DelayedRequestDisposition"
    "Dictionary"
    "Dimension"
    "DirectoryEnumerationOptions"
    "DirectoryEnumerator"
    "DistributedNotificationCenter"
    "DocumentAttributeKey"
    "DocumentReadingOptionKey"
    "DocumentType"
    "Double"
    "DrawingOptions"
    "Element"
    "EncodingConversionOptions"
    "EnergyFormatter"
    "EnumerationOptions"
    "Error"
    "ErrorCode"
    "ErrorPointer"
    "Event"
    "ExpressionType"
    "ExtendedGraphemeClusterLiteralType"
    "ExternalEntityResolvingPolicy"
    "Failure"
    "FileAttributeKey"
    "FileAttributeType"
    "FileHandle"
    "FileManager"
    "FileManagerDelegate"
    "FileOperationKind"
    "FileProtectionType"
    "FileWrapper"
    "FloatLiteralType"
    "Formatter"
    "HTTPCookie"
    "HTTPCookiePropertyKey"
    "HTTPCookieStorage"
    "HTTPCookieStringPolicy"
    "HTTPURLResponse"
    "Host"
    "ISO8601DateFormatter"
    "Identifier"
    "Index"
    "IndexPath"
    "IndexSet"
    "Indices"
    "Input"
    "InputStream"
    "InsertionPosition"
    "Int"
    "IntegerLiteralType"
    "ItemReplacementOptions"
    "Iterator"
    "JSONDecoder"
    "JSONEncoder"
    "JSONSerialization"
    "Key"
    "KeyDecodingStrategy"
    "KeyEncodingStrategy"
    "Kind"
    "LanguageDirection"
    "LengthFormatter"
    "LoadHandler"
    "Locale"
    "LocalizedError"
    "LogicalType"
    "MachError"
    "Magnitude"
    "MassFormatter"
    "MatchingFlags"
    "MatchingOptions"
    "MatchingPolicy"
    "Measurement"
    "MeasurementFormatter"
    "Message"
    "MessagePort"
    "Mode"
    "Modifier"
    "MultipathServiceType"
    "MutabilityOptions"
    "MutableURLRequest"
    "NSAffineTransform"
    "NSAffineTransformStruct"
    "NSAppleEventDescriptor"
    "NSAppleEventManager"
    "NSAppleScript"
    "NSArchiver"
    "NSArray"
    "NSAssertionHandler"
    "NSAttributedString"
    "NSBackgroundActivityScheduler"
    "NSBinarySearchingOptions"
    "NSBundleResourceRequest"
    "NSCache"
    "NSCacheDelegate"
    "NSCalendar"
    "NSCharacterSet"
    "NSClassDescription"
    "NSCloneCommand"
    "NSCloseCommand"
    "NSCoder"
    "NSCoding"
    "NSCollectionChangeType"
    "NSComparisonPredicate"
    "NSCompoundPredicate"
    "NSCondition"
    "NSConditionLock"
    "NSCopying"
    "NSCountCommand"
    "NSCountedSet"
    "NSCreateCommand"
    "NSData"
    "NSDataDetector"
    "NSDate"
    "NSDateComponents"
    "NSDateInterval"
    "NSDecimalNumber"
    "NSDecimalNumberBehaviors"
    "NSDecimalNumberHandler"
    "NSDeleteCommand"
    "NSDictionary"
    "NSDiscardableContent"
    "NSDistributedLock"
    "NSEdgeInsets"
    "NSEnumerationOptions"
    "NSEnumerator"
    "NSError"
    "NSErrorDomain"
    "NSErrorPointer"
    "NSException"
    "NSExceptionName"
    "NSExistsCommand"
    "NSExpression"
    "NSExtensionContext"
    "NSExtensionItem"
    "NSExtensionRequestHandling"
    "NSFastEnumeration"
    "NSFastEnumerationIterator"
    "NSFastEnumerationState"
    "NSFileAccessIntent"
    "NSFileCoordinator"
    "NSFilePresenter"
    "NSFileProviderService"
    "NSFileProviderServiceName"
    "NSFileSecurity"
    "NSFileVersion"
    "NSGetCommand"
    "NSHashEnumerator"
    "NSHashTable"
    "NSHashTableCallBacks"
    "NSHashTableOptions"
    "NSIndexPath"
    "NSIndexSet"
    "NSIndexSetIterator"
    "NSIndexSpecifier"
    "NSItemProvider"
    "NSItemProviderFileOptions"
    "NSItemProviderReading"
    "NSItemProviderRepresentationVisibility"
    "NSItemProviderWriting"
    "NSKeyValueChange"
    "NSKeyValueChangeKey"
    "NSKeyValueObservation"
    "NSKeyValueObservedChange"
    "NSKeyValueObservingCustomization"
    "NSKeyValueObservingOptions"
    "NSKeyValueOperator"
    "NSKeyValueSetMutationKind"
    "NSKeyedArchiver"
    "NSKeyedArchiverDelegate"
    "NSKeyedUnarchiver"
    "NSKeyedUnarchiverDelegate"
    "NSLinguisticTag"
    "NSLinguisticTagScheme"
    "NSLinguisticTagger"
    "NSLinguisticTaggerUnit"
    "NSLocale"
    "NSLock"
    "NSLocking"
    "NSLogicalTest"
    "NSMachPort"
    "NSMachPortDelegate"
    "NSMapEnumerator"
    "NSMapTable"
    "NSMapTableKeyCallBacks"
    "NSMapTableOptions"
    "NSMapTableValueCallBacks"
    "NSMeasurement"
    "NSMetadataItem"
    "NSMetadataQuery"
    "NSMetadataQueryAttributeValueTuple"
    "NSMetadataQueryDelegate"
    "NSMetadataQueryResultGroup"
    "NSMiddleSpecifier"
    "NSMoveCommand"
    "NSMutableArray"
    "NSMutableAttributedString"
    "NSMutableCharacterSet"
    "NSMutableCopying"
    "NSMutableData"
    "NSMutableDictionary"
    "NSMutableIndexSet"
    "NSMutableOrderedSet"
    "NSMutableSet"
    "NSMutableString"
    "NSMutableURLRequest"
    "NSNameSpecifier"
    "NSNotification"
    "NSNull"
    "NSNumber"
    "NSObject"
    "NSObjectProtocol"
    "NSOrderedSet"
    "NSOrthography"
    "NSPersonNameComponents"
    "NSPoint"
    "NSPointerArray"
    "NSPointerFunctions"
    "NSPositionalSpecifier"
    "NSPredicate"
    "NSPropertySpecifier"
    "NSProtocolChecker"
    "NSProxy"
    "NSPurgeableData"
    "NSQuitCommand"
    "NSRandomSpecifier"
    "NSRange"
    "NSRangeSpecifier"
    "NSRect"
    "NSRecursiveLock"
    "NSRegularExpression"
    "NSRelativeSpecifier"
    "NSSaveOptions"
    "NSScriptClassDescription"
    "NSScriptCoercionHandler"
    "NSScriptCommand"
    "NSScriptCommandDescription"
    "NSScriptExecutionContext"
    "NSScriptObjectSpecifier"
    "NSScriptSuiteRegistry"
    "NSScriptWhoseTest"
    "NSSecureCoding"
    "NSSet"
    "NSSetCommand"
    "NSSize"
    "NSSortDescriptor"
    "NSSortOptions"
    "NSSpecifierTest"
    "NSSpellServer"
    "NSSpellServerDelegate"
    "NSString"
    "NSSwappedDouble"
    "NSSwappedFloat"
    "NSTextCheckingKey"
    "NSTextCheckingResult"
    "NSTextCheckingTypes"
    "NSTextWritingDirection"
    "NSTimeZone"
    "NSURL"
    "NSURLComponents"
    "NSURLConnection"
    "NSURLConnectionDataDelegate"
    "NSURLConnectionDelegate"
    "NSURLConnectionDownloadDelegate"
    "NSURLDownload"
    "NSURLDownloadDelegate"
    "NSURLHandle"
    "NSURLQueryItem"
    "NSURLRequest"
    "NSUUID"
    "NSUbiquitousKeyValueStore"
    "NSUnarchiver"
    "NSUncaughtExceptionHandler"
    "NSUnderlineStyle"
    "NSUniqueIDSpecifier"
    "NSUserActivity"
    "NSUserActivityDelegate"
    "NSUserActivityPersistentIdentifier"
    "NSUserAppleScriptTask"
    "NSUserAutomatorTask"
    "NSUserNotification"
    "NSUserNotificationAction"
    "NSUserNotificationCenter"
    "NSUserNotificationCenterDelegate"
    "NSUserScriptTask"
    "NSUserUnixTask"
    "NSValue"
    "NSValueTransformerName"
    "NSWhoseSpecifier"
    "NSWritingDirectionFormatType"
    "NSXPCConnection"
    "NSXPCInterface"
    "NSXPCListener"
    "NSXPCListenerDelegate"
    "NSXPCListenerEndpoint"
    "NSXPCProxyCreating"
    "Name"
    "NameStyle"
    "NetService"
    "NetServiceBrowser"
    "NetServiceBrowserDelegate"
    "NetServiceDelegate"
    "NetworkServiceType"
    "NetworkUnavailableReason"
    "NonConformingFloatDecodingStrategy"
    "NonConformingFloatEncodingStrategy"
    "Notification"
    "NotificationCenter"
    "NotificationCoalescing"
    "NotificationQueue"
    "NumberFormatter"
    "NumberRepresentation"
    "ObservableObject"
    "OperatingSystemVersion"
    "Operation"
    "OperationQueue"
    "Operator"
    "Options"
    "Output"
    "OutputFormatting"
    "OutputStream"
    "POSIXError"
    "PadPosition"
    "Persistence"
    "PersonNameComponents"
    "PersonNameComponentsFormatter"
    "Pipe"
    "Port"
    "PortDelegate"
    "PortMessage"
    "PostingStyle"
    "PreferredPresentationStyle"
    "Process"
    "ProcessInfo"
    "Progress"
    "ProgressKind"
    "ProgressReporting"
    "ProgressUserInfoKey"
    "PropertyKey"
    "PropertyListDecoder"
    "PropertyListEncoder"
    "PropertyListFormat"
    "PropertyListSerialization"
    "Published"
    "Publisher"
    "PublishingHandler"
    "QualityOfService"
    "QueuePriority"
    "RangeView"
    "RawValue"
    "ReadOptions"
    "ReadingOptions"
    "RecoverableError"
    "ReferenceConvertible"
    "ReferenceType"
    "Regions"
    "RelativePosition"
    "RepeatedTimePolicy"
    "ReplacingOptions"
    "ResourceFetchType"
    "ResponseDisposition"
    "Result"
    "RoundingMode"
    "RunLoop"
    "Scanner"
    "SchedulerOptions"
    "SchedulerTimeType"
    "SearchDirection"
    "SearchOptions"
    "SearchPathDirectory"
    "SearchPathDomainMask"
    "SendOptions"
    "Set"
    "SocketNativeHandle"
    "SocketPort"
    "SpellingState"
    "State"
    "Status"
    "StoragePolicy"
    "Stream"
    "StreamDelegate"
    "StreamNetworkServiceTypeValue"
    "StreamSOCKSProxyConfiguration"
    "StreamSOCKSProxyVersion"
    "StreamSocketSecurityLevel"
    "Stride"
    "String"
    "StringEncodingDetectionOptionsKey"
    "StringLiteralType"
    "StringTransform"
    "Style"
    "SubSequence"
    "SubelementIdentifier"
    "SuspensionBehavior"
    "SuspensionID"
    "TerminationReason"
    "TestComparisonOperation"
    "TextEffectStyle"
    "TextLayoutSectionKey"
    "ThermalState"
    "Thread"
    "TimeInterval"
    "TimeZone"
    "Timer"
    "TimerPublisher"
    "UIItemProviderPresentationSizeProviding"
    "URL"
    "URLAuthenticationChallenge"
    "URLAuthenticationChallengeSender"
    "URLCache"
    "URLComponents"
    "URLCredential"
    "URLCredentialStorage"
    "URLError"
    "URLFileProtection"
    "URLFileResourceType"
    "URLProtectionSpace"
    "URLProtocol"
    "URLProtocolClient"
    "URLQueryItem"
    "URLRelationship"
    "URLRequest"
    "URLResourceKey"
    "URLResourceValues"
    "URLResponse"
    "URLSession"
    "URLSessionConfiguration"
    "URLSessionDataDelegate"
    "URLSessionDataTask"
    "URLSessionDelegate"
    "URLSessionDownloadDelegate"
    "URLSessionDownloadTask"
    "URLSessionStreamDelegate"
    "URLSessionStreamTask"
    "URLSessionTask"
    "URLSessionTaskDelegate"
    "URLSessionTaskMetrics"
    "URLSessionTaskTransactionMetrics"
    "URLSessionUploadTask"
    "URLSessionWebSocketDelegate"
    "URLSessionWebSocketTask"
    "URLThumbnailDictionaryItem"
    "URLUbiquitousItemDownloadingStatus"
    "URLUbiquitousSharedItemPermissions"
    "URLUbiquitousSharedItemRole"
    "UUID"
    "UndoManager"
    "UnicodeScalar"
    "UnicodeScalarLiteralType"
    "Unit"
    "UnitAcceleration"
    "UnitAngle"
    "UnitArea"
    "UnitConcentrationMass"
    "UnitConverter"
    "UnitConverterLinear"
    "UnitDispersion"
    "UnitDuration"
    "UnitElectricCharge"
    "UnitElectricCurrent"
    "UnitElectricPotentialDifference"
    "UnitElectricResistance"
    "UnitEnergy"
    "UnitFrequency"
    "UnitFuelEfficiency"
    "UnitIlluminance"
    "UnitLength"
    "UnitMass"
    "UnitOptions"
    "UnitPower"
    "UnitPressure"
    "UnitSpeed"
    "UnitStyle"
    "UnitTemperature"
    "UnitVolume"
    "Units"
    "UnitsStyle"
    "UnmountOptions"
    "UnpublishingHandler"
    "UserDefaults"
    "UserInfoKey"
    "Value"
    "ValueTransformer"
    "VolumeEnumerationOptions"
    "WriteOptions"
    "WritingOptions"
    "XMLDTD"
    "XMLDTDNode"
    "XMLDocument"
    "XMLElement"
    "XMLNode"
    "XMLParser"
    "XMLParserDelegate"
    "ZeroFormattingBehavior"
    "unichar")
  "Foundation types.")

(defconst swift-mode:foundation-enum-cases
  '("DTDKind"
    "abbreviated"
    "abnormalClosure"
    "actionButtonClicked"
    "activityInProgress"
    "additionalActionClicked"
    "adminApplicationDirectory"
    "after"
    "afterPrefix"
    "afterSuffix"
    "aggregate"
    "all"
    "allApplicationsDirectory"
    "allLibrariesDirectory"
    "allow"
    "allowed"
    "allowedInMemoryOnly"
    "always"
    "and"
    "any"
    "anyDeclaration"
    "anyKey"
    "applicationDirectory"
    "applicationScriptsDirectory"
    "applicationSupportDirectory"
    "asap"
    "ask"
    "atEnd"
    "attachment"
    "attribute"
    "attributeDeclaration"
    "attributeHasNoValueError"
    "attributeListNotFinishedError"
    "attributeListNotStartedError"
    "attributeNotFinishedError"
    "attributeNotStartedError"
    "attributeRedefinedError"
    "autosavedInformationDirectory"
    "avStreaming"
    "background"
    "backgroundUpdatesDisabled"
    "backward"
    "badArgumentError"
    "bankers"
    "base64"
    "becomeDownload"
    "becomeStream"
    "before"
    "beforePrefix"
    "beforeSuffix"
    "beginning"
    "beginningOfSentence"
    "beginsWith"
    "behavior10_0"
    "behavior10_4"
    "between"
    "binary"
    "block"
    "bottomToTop"
    "brief"
    "buddhist"
    "cachesDirectory"
    "calendar"
    "callSignaling"
    "calorie"
    "cancel"
    "cancelAuthenticationChallenge"
    "canceling"
    "cancelledError"
    "cdataAttribute"
    "cdataNotFinishedError"
    "ceiling"
    "cellular"
    "centimeter"
    "characterRefAtEOFError"
    "characterRefInDTDError"
    "characterRefInEpilogError"
    "characterRefInPrologError"
    "chinese"
    "closed"
    "coalesce"
    "collisionError"
    "comment"
    "commentContainsDoubleHyphenError"
    "commentNotFinishedError"
    "completed"
    "conditional"
    "conditionalSectionNotFinishedError"
    "conditionalSectionNotStartedError"
    "constantValue"
    "constrained"
    "contains"
    "contentsClicked"
    "continueLoading"
    "convertFromSnakeCase"
    "convertFromString"
    "convertToSnakeCase"
    "convertToString"
    "coptic"
    "coreServiceDirectory"
    "critical"
    "currency"
    "currencyAccounting"
    "currencyISOCode"
    "currencyPlural"
    "custom"
    "customSelector"
    "data"
    "day"
    "daylightSaving"
    "decimal"
    "default"
    "deferred"
    "deferredToData"
    "deferredToDate"
    "delegateAbortedParseError"
    "deliverImmediately"
    "demoApplicationDirectory"
    "desktopDirectory"
    "developerApplicationDirectory"
    "developerDirectory"
    "direct"
    "divideByZero"
    "doctypeDeclNotFinishedError"
    "document"
    "documentDirectory"
    "documentStartError"
    "documentationDirectory"
    "down"
    "downloadsDirectory"
    "drop"
    "dynamic"
    "element"
    "elementContentDeclNotFinishedError"
    "elementContentDeclNotStartedError"
    "elementDeclaration"
    "emptyDeclaration"
    "emptyDocumentError"
    "encodingNotSupportedError"
    "end"
    "endsWith"
    "entitiesAttribute"
    "entityAttribute"
    "entityBoundaryError"
    "entityDeclaration"
    "entityIsExternalError"
    "entityIsParameterError"
    "entityNotFinishedError"
    "entityNotStartedError"
    "entityRefAtEOFError"
    "entityRefInDTDError"
    "entityRefInEpilogError"
    "entityRefInPrologError"
    "entityRefLoopError"
    "entityReferenceMissingSemiError"
    "entityReferenceWithoutNameError"
    "entityValueRequiredError"
    "enumerationAttribute"
    "equal"
    "equalExpectedError"
    "equalTo"
    "era"
    "error"
    "ethiopicAmeteAlem"
    "ethiopicAmeteMihret"
    "evaluatedObject"
    "everySubelement"
    "exit"
    "expensive"
    "externalStandaloneEntityError"
    "externalSubsetNotFinishedError"
    "extraContentError"
    "fair"
    "file"
    "finished"
    "first"
    "floor"
    "foot"
    "forSession"
    "formatted"
    "forward"
    "free"
    "full"
    "function"
    "general"
    "generic"
    "goingAway"
    "gram"
    "grammar"
    "greaterThan"
    "greaterThanOrEqual"
    "greaterThanOrEqualTo"
    "gregorian"
    "group"
    "gtRequiredError"
    "halfDown"
    "halfEven"
    "halfUp"
    "handover"
    "hebrew"
    "hexadecimal"
    "high"
    "hold"
    "hour"
    "html"
    "idAttribute"
    "idRefAttribute"
    "idRefsAttribute"
    "in"
    "inch"
    "indexSubelement"
    "indian"
    "inline"
    "inputMethodsDirectory"
    "insert"
    "insertion"
    "insufficientSystemResources"
    "interactive"
    "internalError"
    "internalServerError"
    "intersect"
    "intersectSet"
    "invalid"
    "invalidCharacterError"
    "invalidCharacterInEntityError"
    "invalidCharacterRefError"
    "invalidConditionalSectionError"
    "invalidDecimalCharacterRefError"
    "invalidEncodingError"
    "invalidEncodingNameError"
    "invalidError"
    "invalidFramePayloadData"
    "invalidHexCharacterRefError"
    "invalidURIError"
    "islamic"
    "islamicCivil"
    "islamicTabular"
    "islamicUmmAlQura"
    "iso8601"
    "itemReplacementDirectory"
    "itemUnavailableError"
    "japanese"
    "joule"
    "keyPath"
    "kilocalorie"
    "kilogram"
    "kilojoule"
    "kilometer"
    "last"
    "leftToRight"
    "lessThan"
    "lessThanOrEqual"
    "lessThanOrEqualTo"
    "lessThanSymbolInAttributeError"
    "libraryDirectory"
    "like"
    "listItem"
    "literalNotFinishedError"
    "literalNotStartedError"
    "loadFailed"
    "loadInProgress"
    "loadSucceeded"
    "localCache"
    "long"
    "lossOfPrecision"
    "low"
    "ltRequiredError"
    "ltSlashRequiredError"
    "lz4"
    "lzfse"
    "lzma"
    "mandatoryExtensionMissing"
    "matches"
    "medium"
    "memory"
    "messageTooBig"
    "meter"
    "middleOfSentence"
    "middleSubelement"
    "mile"
    "millimeter"
    "millisecondsSince1970"
    "minus"
    "minusSet"
    "minute"
    "misplacedCDATAEndStringError"
    "misplacedXMLDeclarationError"
    "mixedContentDeclNotFinishedError"
    "mixedContentDeclNotStartedError"
    "mixedDeclaration"
    "month"
    "moviesDirectory"
    "musicDirectory"
    "nameRequiredError"
    "named"
    "namespace"
    "namespaceDeclarationError"
    "nanosecond"
    "networkLoad"
    "never"
    "nextTime"
    "nextTimePreservingSmallerComponents"
    "nmTokenAttribute"
    "nmTokensAttribute"
    "nmtokenRequiredError"
    "no"
    "noDTDError"
    "noError"
    "noNetwork"
    "noStatusReceived"
    "noSubelement"
    "nominal"
    "none"
    "normal"
    "normalClosure"
    "not"
    "notAllowed"
    "notEqualTo"
    "notFoundError"
    "notLoaded"
    "notOpen"
    "notWellBalancedError"
    "notationAttribute"
    "notationDeclaration"
    "notationNotFinishedError"
    "notationNotStartedError"
    "now"
    "numeric"
    "onlyFromMainDocumentDomain"
    "open"
    "openStep"
    "opening"
    "or"
    "orderedAscending"
    "orderedDescending"
    "orderedSame"
    "ordinal"
    "other"
    "ounce"
    "outOfMemoryError"
    "overflow"
    "ownProcess"
    "paragraph"
    "parameter"
    "parsed"
    "parsedEntityRefAtEOFError"
    "parsedEntityRefInEpilogError"
    "parsedEntityRefInInternalError"
    "parsedEntityRefInInternalSubsetError"
    "parsedEntityRefInPrologError"
    "parsedEntityRefMissingSemiError"
    "parsedEntityRefNoNameError"
    "pcdataRequiredError"
    "percent"
    "performDefaultHandling"
    "permanent"
    "persian"
    "picturesDirectory"
    "plain"
    "policyViolation"
    "positional"
    "pound"
    "predefined"
    "preferencePanesDirectory"
    "prematureDocumentEndError"
    "previousTimePreservingSmallerComponents"
    "printerDescriptionDirectory"
    "processingInstruction"
    "processingInstructionNotFinishedError"
    "processingInstructionNotStartedError"
    "protocolError"
    "publicIdentifierRequiredError"
    "quarter"
    "raiseException"
    "randomSubelement"
    "reading"
    "rejectProtectionSpace"
    "reloadIgnoringLocalAndRemoteCacheData"
    "reloadIgnoringLocalCacheData"
    "reloadRevalidatingCacheData"
    "removal"
    "remove"
    "replace"
    "replacement"
    "replied"
    "republicOfChina"
    "responsiveAV"
    "responsiveData"
    "returnCacheDataDontLoad"
    "returnCacheDataElseLoad"
    "rightToLeft"
    "running"
    "same"
    "sameOriginOnly"
    "scientific"
    "second"
    "secondsSince1970"
    "sentence"
    "separatorRequiredError"
    "serious"
    "serverPush"
    "set"
    "setErrorAndReturn"
    "setting"
    "sharedPublicDirectory"
    "short"
    "shortDaylightSaving"
    "shortGeneric"
    "shortStandard"
    "spaceRequiredError"
    "spellOut"
    "spelling"
    "standalone"
    "standaloneValueError"
    "standard"
    "stone"
    "strict"
    "string"
    "stringNotClosedError"
    "stringNotStartedError"
    "subquery"
    "suspended"
    "synchronizable"
    "tagNameMismatchError"
    "team"
    "text"
    "throw"
    "timeZone"
    "timeoutError"
    "tlsHandshakeFailure"
    "topToBottom"
    "trashDirectory"
    "unavailableCoercionError"
    "uncaughtSignal"
    "undeclaredEntityError"
    "undefinedDeclaration"
    "underflow"
    "unexpectedValueClassError"
    "unfinishedTagError"
    "union"
    "unionSet"
    "unknown"
    "unknownEncodingError"
    "unknownError"
    "unmap"
    "unparsed"
    "unparsedEntityError"
    "unspecified"
    "unsupportedData"
    "up"
    "uriFragmentError"
    "uriRequiredError"
    "useCredential"
    "useDefaultKeys"
    "useNewRequest"
    "useProtocolCachePolicy"
    "userDirectory"
    "userForceQuitApplication"
    "userInitiated"
    "userInteractive"
    "utility"
    "variable"
    "veryHigh"
    "veryLow"
    "video"
    "virtualMemory"
    "voice"
    "voip"
    "weekOfMonth"
    "weekOfYear"
    "weekday"
    "weekdayOrdinal"
    "whenIdle"
    "word"
    "writing"
    "xhtml"
    "xml"
    "xmlDeclNotFinishedError"
    "xmlDeclNotStartedError"
    "yard"
    "year"
    "yearForWeekOfYear"
    "yes"
    "zlib")
  "Foundation enum cases.")

(defconst swift-mode:foundation-methods
  '("abbreviation"
    "abortParsing"
    "absoluteURL"
    "acceptConnectionInBackgroundAndNotify"
    "acceptInput"
    "accommodatePresentedItemDeletion"
    "accommodatePresentedSubitemDeletion"
    "add"
    "addApplicationParameterHeader"
    "addAttribute"
    "addAttributes"
    "addAuthorizationChallengeHeader"
    "addAuthorizationResponseHeader"
    "addBarrierBlock"
    "addBodyHeader"
    "addByteSequenceHeader"
    "addCharacters"
    "addChild"
    "addConnectionIDHeader"
    "addCountHeader"
    "addDependency"
    "addDescriptionHeader"
    "addEntries"
    "addExecutionBlock"
    "addFile"
    "addFilePresenter"
    "addFileWrapper"
    "addHTTPHeader"
    "addImageDescriptorHeader"
    "addImageHandleHeader"
    "addLengthHeader"
    "addNameHeader"
    "addNamespace"
    "addObjectClassHeader"
    "addObjects"
    "addObserver"
    "addOfItem"
    "addOperation"
    "addOperations"
    "addPointer"
    "addRegularFile"
    "addSubscriber"
    "addSuite"
    "addSymbolicLink"
    "addTargetHeader"
    "addTime4ByteHeader"
    "addTimeISOHeader"
    "addTimeInterval"
    "addTypeHeader"
    "addUserDefinedHeader"
    "addUserInfoEntries"
    "addValue"
    "addWhoHeader"
    "adding"
    "addingObjects"
    "addingPercentEncoding"
    "addingPercentEscapes"
    "addingTimeInterval"
    "addressCheckingResult"
    "adjustingRanges"
    "advanced"
    "aeteResource"
    "allKeys"
    "allSatisfy"
    "alloc"
    "allowEvaluation"
    "allowsReverseTransformation"
    "alphanumeric"
    "annotatedString"
    "anonymous"
    "anyObject"
    "append"
    "appendFormat"
    "appendPathComponent"
    "appendPathExtension"
    "appending"
    "appendingFormat"
    "appendingPathComponent"
    "appendingPathExtension"
    "appleEvent"
    "appleEventCode"
    "appleEventCodeForArgument"
    "applyFontTraits"
    "applyTransform"
    "applying"
    "applyingTransform"
    "archiveRootObject"
    "archivedData"
    "archiver"
    "archiverDidFinish"
    "archiverWillFinish"
    "array"
    "assertNoFailure"
    "assign"
    "atIndex"
    "attemptRecovery"
    "attribute"
    "attributeDeclaration"
    "attributeDescriptor"
    "attributedString"
    "attributedSubstring"
    "attributes"
    "attributesOfFileSystem"
    "attributesOfItem"
    "autoconnect"
    "automaticallyNotifiesObservers"
    "availableTagSchemes"
    "background"
    "backgroundSessionConfiguration"
    "base64EncodedData"
    "base64EncodedString"
    "base64Encoding"
    "baseUnit"
    "baseUnitValue"
    "becomeCurrent"
    "beginAccessingResources"
    "beginActivity"
    "beginContentAccess"
    "beginEditing"
    "beginRequest"
    "beginUndoGrouping"
    "bind"
    "bookmarkData"
    "bool"
    "boundingRect"
    "break"
    "breakpoint"
    "breakpointOnError"
    "broadcast"
    "buffer"
    "bundle"
    "cString"
    "cStringLength"
    "cache"
    "cachedResponse"
    "canBeConverted"
    "canHandle"
    "canInit"
    "canLoadObject"
    "canResumeDownloadDecoded"
    "cancel"
    "cancelAllOperations"
    "cancelPerform"
    "cancelPerformSelectors"
    "cancelRequest"
    "canonicalIdentifier"
    "canonicalLanguageIdentifier"
    "canonicalLocaleIdentifier"
    "canonicalRequest"
    "canonicalXMLStringPreservingComments"
    "capitalized"
    "capitalizedLetter"
    "captureStreams"
    "caseInsensitiveCompare"
    "catch"
    "cgAffineTransform"
    "cgPoint"
    "cgRect"
    "cgSize"
    "cgVector"
    "changeCurrentDirectoryPath"
    "changeFileAttributes"
    "character"
    "characterDirection"
    "characterIsMember"
    "checkPromisedItemIsReachable"
    "checkPromisedItemIsReachableAndReturnError"
    "checkResourceIsReachable"
    "checkResourceIsReachableAndReturnError"
    "child"
    "class"
    "classDescription"
    "classDescriptions"
    "className"
    "classNameDecoded"
    "classNameEncoded"
    "classNamed"
    "classes"
    "close"
    "closeFile"
    "closeRead"
    "closeWrite"
    "coerce"
    "coerceValue"
    "collect"
    "combineLatest"
    "commandDescription"
    "commandDescriptions"
    "comment"
    "commonPrefix"
    "compact"
    "compactMap"
    "compare"
    "compileAndReturnError"
    "completePath"
    "completeRequest"
    "component"
    "components"
    "componentsJoined"
    "componentsToDisplay"
    "compress"
    "compressed"
    "concat"
    "conditionallyBeginAccessingResources"
    "connect"
    "connection"
    "connectionDidFinishDownloading"
    "connectionDidFinishLoading"
    "connectionDidResumeDownloading"
    "connectionShouldUseCredentialStorage"
    "containerURL"
    "contains"
    "containsAttachments"
    "containsValue"
    "contents"
    "contentsEqual"
    "contentsOfDirectory"
    "contextHelp"
    "continueWithoutCredential"
    "control"
    "converting"
    "cookies"
    "coordinate"
    "copy"
    "copyBytes"
    "copyItem"
    "correctionCheckingResult"
    "count"
    "countByEnumerating"
    "countOfIndexes"
    "createCommandInstance"
    "createDirectory"
    "createFile"
    "createSymbolicLink"
    "credentials"
    "current"
    "currentProcess"
    "currentVersionOfItem"
    "dashCheckingResult"
    "data"
    "dataFromPropertyList"
    "dataTask"
    "dataTaskPublisher"
    "dataWithContentsOfMappedFile"
    "date"
    "dateCheckingResult"
    "dateComponents"
    "dateFormat"
    "dateInterval"
    "dateIntervalOfWeekend"
    "daylightSavingTimeOffset"
    "dealloc"
    "debounce"
    "decimalDigit"
    "decode"
    "decodeArray"
    "decodeBool"
    "decodeBytes"
    "decodeCGAffineTransform"
    "decodeCGPoint"
    "decodeCGRect"
    "decodeCGSize"
    "decodeCGVector"
    "decodeCInt"
    "decodeClassName"
    "decodeData"
    "decodeDecodable"
    "decodeDirectionalEdgeInsets"
    "decodeDouble"
    "decodeFloat"
    "decodeInt32"
    "decodeInt64"
    "decodeInteger"
    "decodeObject"
    "decodePoint"
    "decodePropertyList"
    "decodeRect"
    "decodeSize"
    "decodeTime"
    "decodeTimeMapping"
    "decodeTimeRange"
    "decodeTopLevelDecodable"
    "decodeTopLevelObject"
    "decodeUIEdgeInsets"
    "decodeUIOffset"
    "decodeValue"
    "decodeXPCObject"
    "decomposable"
    "decompress"
    "decompressed"
    "default"
    "defaultCredential"
    "defaultFormatterBehavior"
    "defaultOrthography"
    "deferredLocalizedIntentsString"
    "delay"
    "delegate"
    "deleteAllSavedUserActivities"
    "deleteCharacters"
    "deleteCookie"
    "deleteLastPathComponent"
    "deletePathExtension"
    "deleteSavedUserActivities"
    "deletingLastPathComponent"
    "deletingPathExtension"
    "deliver"
    "dequeueNotifications"
    "description"
    "destinationOfSymbolicLink"
    "detach"
    "detachNewThread"
    "detachNewThreadSelector"
    "dictionary"
    "dictionaryRepresentation"
    "dictionaryWithValues"
    "didChange"
    "didChangeValue"
    "difference"
    "directoryContents"
    "disableAutomaticTermination"
    "disableSuddenTermination"
    "disableUndoRegistration"
    "disableUpdates"
    "discardContentIfPossible"
    "discreteProgress"
    "dismissNotificationContentExtension"
    "dispatchRawAppleEvent"
    "displayName"
    "distance"
    "dividing"
    "docFormat"
    "document"
    "doesContain"
    "dominantLanguage"
    "double"
    "doubleClick"
    "download"
    "downloadDidBegin"
    "downloadDidFinish"
    "downloadShouldUseCredentialStorage"
    "downloadTask"
    "draw"
    "drop"
    "dropFirst"
    "dropLast"
    "dtdNode"
    "earlierDate"
    "editingString"
    "element"
    "elementDeclaration"
    "elements"
    "elementsEqual"
    "enableAutomaticTermination"
    "enableSuddenTermination"
    "enableUndoRegistration"
    "enableUpdates"
    "encode"
    "encodeArray"
    "encodeBycopyObject"
    "encodeByrefObject"
    "encodeBytes"
    "encodeCInt"
    "encodeClassName"
    "encodeConditionalObject"
    "encodeEncodable"
    "encodePropertyList"
    "encodeRootObject"
    "encodeValue"
    "encodeXPCObject"
    "endAccessingResources"
    "endActivity"
    "endContentAccess"
    "endEditing"
    "endUndoGrouping"
    "enqueue"
    "entityDeclaration"
    "enumerate"
    "enumerateAttribute"
    "enumerateAttributes"
    "enumerateBytes"
    "enumerateDates"
    "enumerateIndexPaths"
    "enumerateKeysAndObjects"
    "enumerateLines"
    "enumerateLinguisticTags"
    "enumerateMatches"
    "enumerateObjects"
    "enumerateRanges"
    "enumerateResults"
    "enumerateSubstrings"
    "enumerateTags"
    "enumerated"
    "enumerator"
    "eraseToAnyPublisher"
    "error"
    "escapedPattern"
    "escapedTemplate"
    "evaluate"
    "evictUbiquitousItem"
    "exceptionDuringOperation"
    "exchangeObject"
    "execute"
    "executeAndReturnError"
    "executeAppleEvent"
    "exit"
    "expressionForAnyKey"
    "expressionForEvaluatedObject"
    "expressionValue"
    "failWithError"
    "fileAttributes"
    "fileCreationDate"
    "fileExists"
    "fileExtensionHidden"
    "fileGroupOwnerAccountID"
    "fileGroupOwnerAccountName"
    "fileHFSCreatorCode"
    "fileHFSTypeCode"
    "fileIsAppendOnly"
    "fileIsImmutable"
    "fileManager"
    "fileModificationDate"
    "fileOwnerAccountID"
    "fileOwnerAccountName"
    "filePosixPermissions"
    "fileProviderErrorForCollision"
    "fileProviderErrorForNonExistentItem"
    "fileReferenceURL"
    "fileSize"
    "fileSystemAttributes"
    "fileSystemFileNumber"
    "fileSystemNumber"
    "fileSystemRepresentation"
    "fileType"
    "fileURL"
    "fileWrapper"
    "filter"
    "filtered"
    "filteredIndexSet"
    "finalize"
    "finishDecoding"
    "finishEncoding"
    "finishTasksAndInvalidate"
    "fire"
    "first"
    "firstIndex"
    "firstMatch"
    "firstObjectCommon"
    "firstRange"
    "fixAttachmentAttribute"
    "fixAttributes"
    "fixFontAttribute"
    "fixParagraphStyleAttribute"
    "flatMap"
    "float"
    "flush"
    "folding"
    "fontAttributes"
    "forEach"
    "forKey"
    "forKeyword"
    "forSelector"
    "forType"
    "formIndex"
    "formIntersection"
    "formSymmetricDifference"
    "formUnion"
    "forwardInvocation"
    "getAllTasks"
    "getBoundStreams"
    "getBuffer"
    "getBytes"
    "getCFRunLoop"
    "getCString"
    "getCachedResponse"
    "getCharacters"
    "getContinuationStreams"
    "getCookiesFor"
    "getCredentials"
    "getDefaultCredential"
    "getEra"
    "getFileProviderConnection"
    "getFileProviderServicesForItem"
    "getFileSystemRepresentation"
    "getHeaderBytes"
    "getHour"
    "getIndexes"
    "getInputStream"
    "getLineStart"
    "getNonlocalVersionsOfItem"
    "getObjectValue"
    "getParagraphStart"
    "getPromisedItemResourceValue"
    "getRelationship"
    "getResourceValue"
    "getStreamsTo"
    "getStreamsToHost"
    "getTasksWithCompletionHandler"
    "getValue"
    "grammarCheckingResult"
    "handle"
    "handleEvents"
    "handleMachMessage"
    "hasItemConformingToTypeIdentifier"
    "hasMember"
    "hasMemberInPlane"
    "hasOrderedToManyRelationship"
    "hasPrefix"
    "hasProperty"
    "hasReadableProperty"
    "hasRepresentationConforming"
    "hasSuffix"
    "hasWritableProperty"
    "hash"
    "homeDirectory"
    "identifier"
    "ignoreOutput"
    "illegal"
    "image"
    "increaseLength"
    "index"
    "indexGreaterThanIndex"
    "indexGreaterThanOrEqual"
    "indexLessThanIndex"
    "indexLessThanOrEqual"
    "indexOfObject"
    "indexOfObjectIdentical"
    "indexRange"
    "indexes"
    "indexesOfObjects"
    "indicesOfObjects"
    "indicesOfObjectsByEvaluating"
    "insert"
    "insertChild"
    "insertChildren"
    "insertPointer"
    "insertValue"
    "integer"
    "integerGreaterThan"
    "integerGreaterThanOrEqualTo"
    "integerLessThan"
    "integerLessThanOrEqualTo"
    "interfaceParametersDescription"
    "interrupt"
    "intersect"
    "intersectSet"
    "intersection"
    "intersects"
    "intersectsSet"
    "invalidate"
    "invalidateAndCancel"
    "invalidateClassDescriptionCache"
    "inverse"
    "invert"
    "inverted"
    "isCaseInsensitiveLike"
    "isContentDiscarded"
    "isDate"
    "isDateInToday"
    "isDateInTomorrow"
    "isDateInWeekend"
    "isDateInYesterday"
    "isDaylightSavingTime"
    "isDeletableFile"
    "isDisjoint"
    "isEqual"
    "isExecutableFile"
    "isFileReferenceURL"
    "isGreaterThan"
    "isGreaterThanOrEqual"
    "isLess"
    "isLessThan"
    "isLessThanOrEqual"
    "isLessThanOrEqualTo"
    "isLike"
    "isLocationRequiredToCreate"
    "isMultiThreaded"
    "isNotEqual"
    "isOperatingSystemAtLeast"
    "isOptionalArgument"
    "isPartialStringValid"
    "isProxy"
    "isReadableFile"
    "isStrictSubset"
    "isStrictSuperset"
    "isSubset"
    "isSuperset"
    "isTotallyOrdered"
    "isTrue"
    "isUbiquitousItem"
    "isValidDate"
    "isValidJSONObject"
    "isWord"
    "isWritableFile"
    "item"
    "itemNumber"
    "itemProviderVisibilityForRepresentation"
    "joined"
    "jsonObject"
    "key"
    "keyEnumerator"
    "keyForChildFileWrapper"
    "keyPathsAffectingValue"
    "keyPathsForValuesAffectingValue"
    "keysOfEntries"
    "keysSortedByValue"
    "keywordForDescriptor"
    "languages"
    "last"
    "lastIndex"
    "lastRange"
    "laterDate"
    "launch"
    "launchedProcess"
    "lengthOfBytes"
    "letter"
    "lexicographicallyPrecedes"
    "limitDate"
    "lineBreak"
    "lineBreakByHyphenating"
    "lineDirection"
    "lineRange"
    "linguisticTags"
    "linkCheckingResult"
    "linkItem"
    "list"
    "listener"
    "load"
    "loadAndReturnError"
    "loadBroadcastingApplicationInfo"
    "loadData"
    "loadDataRepresentation"
    "loadFileRepresentation"
    "loadFromHTML"
    "loadInPlaceFileRepresentation"
    "loadItem"
    "loadNibNamed"
    "loadObject"
    "loadPreviewImage"
    "loadSuite"
    "loadSuites"
    "localName"
    "localeIdentifier"
    "localizedCaseInsensitiveCompare"
    "localizedCaseInsensitiveContains"
    "localizedCompare"
    "localizedName"
    "localizedScanner"
    "localizedStandardCompare"
    "localizedStandardContains"
    "localizedStandardRange"
    "localizedString"
    "localizedStringWithFormat"
    "localizedUserNotificationString"
    "lock"
    "longCharacterIsMember"
    "longLong"
    "lossyCString"
    "lowercaseLetter"
    "lowercased"
    "main"
    "makeConnectable"
    "makeIterator"
    "map"
    "mapError"
    "matches"
    "matchesAppleEventCode"
    "matchesContents"
    "max"
    "maximumLengthOfBytes"
    "maximumRange"
    "measureInterval"
    "mediaPlayingPaused"
    "mediaPlayingStarted"
    "member"
    "merge"
    "metadataQuery"
    "microseconds"
    "millimolesPerLiter"
    "milliseconds"
    "min"
    "minimumRange"
    "minus"
    "minusSet"
    "mountedVolumeURLs"
    "moveItem"
    "moveObjects"
    "multicast"
    "multiplying"
    "mutableArrayValue"
    "mutableCopy"
    "mutableOrderedSetValue"
    "mutableSetValue"
    "namespace"
    "nanoseconds"
    "needsToBeUpdated"
    "negate"
    "netService"
    "netServiceBrowser"
    "netServiceBrowserDidStopSearch"
    "netServiceBrowserWillSearch"
    "netServiceDidPublish"
    "netServiceDidResolveAddress"
    "netServiceDidStop"
    "netServiceWillPublish"
    "netServiceWillResolve"
    "new"
    "newline"
    "next"
    "nextDate"
    "nextDaylightSavingTimeTransition"
    "nextObject"
    "nextWeekend"
    "nextWeekendStart"
    "nextWord"
    "nodes"
    "nonBase"
    "normalizeAdjacentTextNodesPreservingCDATA"
    "notationDeclaration"
    "nsDirectionalEdgeInsets"
    "null"
    "number"
    "numberOfMatches"
    "object"
    "objectByApplyingXSLT"
    "objectEnumerator"
    "objectIsForced"
    "objects"
    "objectsByEvaluating"
    "observeValue"
    "offset"
    "open"
    "operatingSystem"
    "operatingSystemName"
    "ordinality"
    "orthography"
    "orthographyCheckingResult"
    "otherVersionsOfItem"
    "output"
    "padding"
    "paragraphRange"
    "paramDescriptor"
    "parse"
    "parser"
    "parserDidEndDocument"
    "parserDidStartDocument"
    "partition"
    "path"
    "pathContentOfSymbolicLink"
    "pathForImageResource"
    "paths"
    "pathsMatchingExtensions"
    "pause"
    "perform"
    "performActivity"
    "performAsCurrent"
    "performDefaultHandling"
    "performDefaultImplementation"
    "performExpiringActivity"
    "performNotificationDefaultAction"
    "persistentDomain"
    "persistentDomainNames"
    "personNameComponents"
    "phoneNumberCheckingResult"
    "pointer"
    "popFirst"
    "popLast"
    "port"
    "possibleTags"
    "post"
    "postNotificationName"
    "predefinedEntityDeclaration"
    "predefinedNamespace"
    "preferredLocalizations"
    "prefix"
    "preflight"
    "prepare"
    "prepend"
    "presentedItemDidChange"
    "presentedItemDidChangeUbiquityAttributes"
    "presentedItemDidGain"
    "presentedItemDidLose"
    "presentedItemDidMove"
    "presentedItemDidResolveConflict"
    "presentedSubitem"
    "presentedSubitemDidAppear"
    "presentedSubitemDidChange"
    "preservationPriority"
    "print"
    "processingInstruction"
    "promisedItemResourceValues"
    "property"
    "propertyList"
    "propertyListFromData"
    "propertyListFromStringsFileFormat"
    "publish"
    "publisher"
    "punctuation"
    "quoteCheckingResult"
    "raise"
    "raising"
    "randomElement"
    "range"
    "rangeCount"
    "rangeOfCharacter"
    "rangeOfComposedCharacterSequence"
    "rangeOfComposedCharacterSequences"
    "rangeOfFirstMatch"
    "rangeView"
    "read"
    "readData"
    "readDataToEndOfFile"
    "readInBackgroundAndNotify"
    "readToEnd"
    "readToEndOfFileInBackgroundAndNotify"
    "readingIntent"
    "receive"
    "record"
    "redo"
    "redoMenuTitle"
    "reduce"
    "register"
    "registerClass"
    "registerCloudKitShare"
    "registerCoercer"
    "registerDataRepresentation"
    "registerFileRepresentation"
    "registerItem"
    "registerLanguage"
    "registerObject"
    "registerUndo"
    "registeredTypeIdentifiers"
    "regularExpressionCheckingResult"
    "rejectProtectionSpaceAndContinue"
    "relinquishPresentedItem"
    "remoteObjectProxy"
    "remoteObjectProxyWithErrorHandler"
    "remove"
    "removeAll"
    "removeAllActions"
    "removeAllCachedResourceValues"
    "removeAllCachedResponses"
    "removeAllDeliveredNotifications"
    "removeAllIndexes"
    "removeAllObjects"
    "removeAttribute"
    "removeCachedResourceValue"
    "removeCachedResponse"
    "removeCachedResponses"
    "removeCharacters"
    "removeChild"
    "removeCookies"
    "removeDeliveredNotification"
    "removeDependency"
    "removeDuplicates"
    "removeEventHandler"
    "removeFilePresenter"
    "removeFileWrapper"
    "removeFirst"
    "removeItem"
    "removeLast"
    "removeLastObject"
    "removeNamespace"
    "removeObject"
    "removeObjects"
    "removeObserver"
    "removeOtherVersionsOfItem"
    "removeParamDescriptor"
    "removePersistentDomain"
    "removePointer"
    "removeProperty"
    "removeScheduledNotification"
    "removeSubrange"
    "removeSubscriber"
    "removeSuite"
    "removeValue"
    "removeVolatileDomain"
    "removingLastIndex"
    "replace"
    "replaceBytes"
    "replaceCharacters"
    "replaceChild"
    "replaceEmpty"
    "replaceError"
    "replaceItem"
    "replaceItemAt"
    "replaceItemAtURL"
    "replaceMatches"
    "replaceNil"
    "replaceObject"
    "replaceObjects"
    "replaceOccurrences"
    "replacePointer"
    "replaceSubrange"
    "replaceValue"
    "replacementCheckingResult"
    "replacementClass"
    "replacementString"
    "replacingCharacters"
    "replacingOccurrences"
    "replacingPercentEscapes"
    "replyAppleEvent"
    "requestHeaderFields"
    "requestIsCacheEquivalent"
    "reserveCapacity"
    "reset"
    "resetBytes"
    "resetStandardUserDefaults"
    "resetSystemTimeZone"
    "resignCurrent"
    "resolve"
    "resolveNamespace"
    "resolvePrefix"
    "resolveSymlinksInPath"
    "resolvingSymlinksInPath"
    "resourceValues"
    "responds"
    "result"
    "resume"
    "resumeExecution"
    "retry"
    "reverse"
    "reverseObjectEnumerator"
    "reverseTransformedValue"
    "reversed"
    "rootElement"
    "rotate"
    "rounding"
    "roundingMode"
    "rtf"
    "rtfd"
    "rtfdFileWrapper"
    "rulerAttributes"
    "run"
    "savePresentedItemChanges"
    "scale"
    "scaleX"
    "scan"
    "scanCharacter"
    "scanCharacters"
    "scanDecimal"
    "scanDouble"
    "scanFloat"
    "scanHexDouble"
    "scanHexFloat"
    "scanHexInt32"
    "scanHexInt64"
    "scanInt"
    "scanInt32"
    "scanInt64"
    "scanString"
    "scanUInt64"
    "scanUnsignedLongLong"
    "scanUpTo"
    "scanUpToCharacters"
    "scanUpToString"
    "schedule"
    "scheduleNotification"
    "scheduleSendBarrierBlock"
    "scheduledTimer"
    "scriptingBegins"
    "scriptingContains"
    "scriptingEnds"
    "scriptingIsEqual"
    "scriptingIsGreaterThan"
    "scriptingIsGreaterThanOrEqual"
    "scriptingIsLessThan"
    "scriptingIsLessThanOrEqual"
    "searchForBrowsableDomains"
    "searchForRegistrationDomains"
    "searchForServices"
    "seconds"
    "secondsFromGMT"
    "seek"
    "seekToEnd"
    "seekToEndOfFile"
    "selector"
    "send"
    "sendAsynchronousRequest"
    "sendEvent"
    "sendPing"
    "sendSynchronousRequest"
    "sentenceRange"
    "service"
    "set"
    "setActionIsDiscardable"
    "setActionName"
    "setAlignment"
    "setArray"
    "setAttribute"
    "setAttributedString"
    "setAttributes"
    "setAttributesAs"
    "setAttributesWith"
    "setBaseWritingDirection"
    "setChildren"
    "setClass"
    "setClassName"
    "setClasses"
    "setCookie"
    "setCookies"
    "setCurrentAppleEventAndReplyEventWithSuspensionID"
    "setData"
    "setDefaultCredential"
    "setDefaultFormatterBehavior"
    "setDelegate"
    "setDelegateQueue"
    "setDescriptor"
    "setDestination"
    "setDictionary"
    "setEventHandler"
    "setFailureType"
    "setInsertionClassDescription"
    "setInterface"
    "setLocalizedDateFormatFromTemplate"
    "setNilValueForKey"
    "setObject"
    "setOrthography"
    "setParam"
    "setPersistentDomain"
    "setPreservationPriority"
    "setProperty"
    "setReceiversSpecifier"
    "setResourceValue"
    "setResourceValues"
    "setRootElement"
    "setSet"
    "setShared"
    "setString"
    "setStringValue"
    "setTXTRecord"
    "setTemporaryResourceValue"
    "setThreadPriority"
    "setUbiquitous"
    "setUserInfoObject"
    "setUserInfoValueProvider"
    "setValue"
    "setValueTransformer"
    "setValuesForKeys"
    "setVolatileDomain"
    "setWeek"
    "setXPCType"
    "share"
    "shared"
    "sharedCookieStorage"
    "sharedKeySet"
    "shift"
    "shiftIndexesStarting"
    "shuffle"
    "shuffled"
    "signal"
    "sink"
    "size"
    "skipDescendants"
    "skipDescendents"
    "sleep"
    "sort"
    "sortRange"
    "sorted"
    "sortedArray"
    "sortedCookies"
    "spellCheckingResult"
    "spellServer"
    "split"
    "standardize"
    "start"
    "startAccessingSecurityScopedResource"
    "startDownloadingUbiquitousItem"
    "startLoading"
    "startMonitoring"
    "startOfDay"
    "startSecureConnection"
    "starts"
    "stop"
    "stopAccessingSecurityScopedResource"
    "stopLoading"
    "stopMonitoring"
    "stopSecureConnection"
    "storeCachedResponse"
    "storeCookies"
    "stream"
    "streamTask"
    "string"
    "stringArray"
    "stringByReplacingMatches"
    "stringEdited"
    "stringEncoding"
    "strings"
    "strongObjects"
    "strongToStrongObjects"
    "strongToWeakObjects"
    "subarray"
    "subdata"
    "subpaths"
    "subpathsOfDirectory"
    "subscribe"
    "subscriptRange"
    "substring"
    "subtract"
    "subtracting"
    "suffix"
    "suite"
    "superscriptRange"
    "supportsCommand"
    "suspend"
    "suspendCurrentAppleEvent"
    "suspendExecution"
    "swapAt"
    "symbol"
    "symbolicLinkDestination"
    "symmetricDifference"
    "synchronize"
    "synchronizeFile"
    "synchronousRemoteObjectProxyWithErrorHandler"
    "tag"
    "tags"
    "temporaryDirectoryURLForNewVersionOfItem"
    "terminate"
    "text"
    "threadPriority"
    "throttle"
    "timeIntervalSince"
    "timeout"
    "toMemory"
    "tokenRange"
    "transform"
    "transformedValue"
    "transformedValueClass"
    "transformingChanges"
    "transitInformationCheckingResult"
    "translate"
    "translateX"
    "trashItem"
    "trimmingCharacters"
    "truncate"
    "truncateFile"
    "try"
    "tryAllSatisfy"
    "tryCatch"
    "tryCompactMap"
    "tryContains"
    "tryDrop"
    "tryFilter"
    "tryFirst"
    "tryLast"
    "tryLock"
    "tryMap"
    "tryMax"
    "tryMin"
    "tryPrefix"
    "tryReduce"
    "tryRemoveDuplicates"
    "tryScan"
    "txtRecordData"
    "type"
    "typeForArgument"
    "uiEdgeInsets"
    "uiOffset"
    "unarchiveObject"
    "unarchiveTopLevelObjectWithData"
    "unarchivedObject"
    "unarchiver"
    "unarchiverDidFinish"
    "unarchiverWillFinish"
    "undo"
    "undoMenuTitle"
    "undoNestedGroup"
    "union"
    "unionSet"
    "unitString"
    "unload"
    "unlock"
    "unmountVolume"
    "unpublish"
    "unregisterClass"
    "unresolvedConflictVersionsOfItem"
    "unschedule"
    "unscriptRange"
    "update"
    "updateAttachments"
    "uploadTask"
    "uppercaseLetter"
    "uppercased"
    "url"
    "urlForImageResource"
    "urlProtocol"
    "urlProtocolDidFinishLoading"
    "urlSession"
    "urlSessionDidFinishEvents"
    "urls"
    "use"
    "userActivity"
    "userActivityWasContinued"
    "userActivityWillSave"
    "userInfoValueProvider"
    "userNotificationCenter"
    "validate"
    "validateValue"
    "value"
    "valueTransformerNames"
    "values"
    "variantFittingPresentationWidth"
    "version"
    "volatileDomain"
    "wait"
    "waitForDataInBackgroundAndNotify"
    "waitUntilAllOperationsAreFinished"
    "waitUntilExit"
    "waitUntilFinished"
    "weakObjects"
    "weakToStrongObjects"
    "weakToWeakObjects"
    "webSocketTask"
    "week"
    "whitespace"
    "whitespaceAndNewline"
    "widgetMaximumSize"
    "willChange"
    "willChangeValue"
    "windowsLocaleCode"
    "withContiguousMutableStorageIfAvailable"
    "withContiguousStorageIfAvailable"
    "withSubstitutionVariables"
    "withUnsafeBytes"
    "withUnsafeFileSystemRepresentation"
    "withUnsafeMutableBytes"
    "write"
    "writeBookmarkData"
    "writeJSONObject"
    "writePropertyList"
    "writingIntent"
    "xmlData"
    "xmlString"
    "xpcType"
    "zip")
  "Foundation methods.")

(defconst swift-mode:foundation-properties
  '("ABPeoplePickerDisplayedPropertyDidChange"
    "ABPeoplePickerGroupSelectionDidChange"
    "ABPeoplePickerNameSelectionDidChange"
    "ABPeoplePickerValueSelectionDidChange"
    "ACAccountStoreDidChange"
    "ALAssetsLibraryChanged"
    "AVAssetChapterMetadataGroupsDidChange"
    "AVAssetContainsFragmentsDidChange"
    "AVAssetDurationDidChange"
    "AVAssetMediaSelectionGroupsDidChange"
    "AVAssetTrackSegmentsDidChange"
    "AVAssetTrackTimeRangeDidChange"
    "AVAssetTrackTrackAssociationsDidChange"
    "AVAssetWasDefragmented"
    "AVAudioEngineConfigurationChange"
    "AVAudioUnitComponentTagsDidChange"
    "AVCaptureDeviceSubjectAreaDidChange"
    "AVCaptureDeviceWasConnected"
    "AVCaptureDeviceWasDisconnected"
    "AVCaptureInputPortFormatDescriptionDidChange"
    "AVCaptureSessionDidStartRunning"
    "AVCaptureSessionDidStopRunning"
    "AVCaptureSessionInterruptionEnded"
    "AVCaptureSessionRuntimeError"
    "AVCaptureSessionWasInterrupted"
    "AVDisplayManagerModeSwitchEnd"
    "AVDisplayManagerModeSwitchSettingsChanged"
    "AVDisplayManagerModeSwitchStart"
    "AVFragmentedMovieContainsMovieFragmentsDidChange"
    "AVFragmentedMovieDurationDidChange"
    "AVFragmentedMovieTrackSegmentsDidChange"
    "AVFragmentedMovieTrackTimeRangeDidChange"
    "AVFragmentedMovieTrackTotalSampleDataLengthDidChange"
    "AVFragmentedMovieWasDefragmented"
    "AVPlayerAvailableHDRModesDidChange"
    "AVPlayerItemDidPlayToEndTime"
    "AVPlayerItemFailedToPlayToEndTime"
    "AVPlayerItemNewAccessLogEntry"
    "AVPlayerItemNewErrorLogEntry"
    "AVPlayerItemPlaybackStalled"
    "AVPlayerItemTimeJumped"
    "AVRouteDetectorMultipleRoutesDetectedDidChange"
    "AVSampleBufferAudioRendererWasFlushedAutomatically"
    "AVSampleBufferDisplayLayerFailedToDecode"
    "CKAccountChanged"
    "CLKComplicationServerActiveComplicationsDidChange"
    "CNContactStoreDidChange"
    "CTRadioAccessTechnologyDidChange"
    "CTServiceRadioAccessTechnologyDidChange"
    "CWBSSIDDidChange"
    "CWCountryCodeDidChange"
    "CWLinkDidChange"
    "CWLinkQualityDidChange"
    "CWModeDidChange"
    "CWPowerDidChange"
    "CWSSIDDidChange"
    "CWScanCacheDidUpdate"
    "E2BIG"
    "EAAccessoryDidConnect"
    "EAAccessoryDidDisconnect"
    "EACCES"
    "EADDRINUSE"
    "EADDRNOTAVAIL"
    "EAFNOSUPPORT"
    "EAGAIN"
    "EALREADY"
    "EAUTH"
    "EBADARCH"
    "EBADEXEC"
    "EBADF"
    "EBADMACHO"
    "EBADMSG"
    "EBADRPC"
    "EBUSY"
    "ECANCELED"
    "ECHILD"
    "ECONNABORTED"
    "ECONNREFUSED"
    "ECONNRESET"
    "EDEADLK"
    "EDESTADDRREQ"
    "EDEVERR"
    "EDOM"
    "EDQUOT"
    "EEXIST"
    "EFAULT"
    "EFBIG"
    "EFTYPE"
    "EHOSTDOWN"
    "EHOSTUNREACH"
    "EIDRM"
    "EILSEQ"
    "EINPROGRESS"
    "EINTR"
    "EINVAL"
    "EIO"
    "EISCONN"
    "EISDIR"
    "EKEventStoreChanged"
    "ELOOP"
    "EMFILE"
    "EMLINK"
    "EMSGSIZE"
    "EMULTIHOP"
    "ENAMETOOLONG"
    "ENEEDAUTH"
    "ENETDOWN"
    "ENETRESET"
    "ENETUNREACH"
    "ENFILE"
    "ENOATTR"
    "ENOBUFS"
    "ENODATA"
    "ENODEV"
    "ENOENT"
    "ENOEXEC"
    "ENOLCK"
    "ENOLINK"
    "ENOMEM"
    "ENOMSG"
    "ENOPOLICY"
    "ENOPROTOOPT"
    "ENOSPC"
    "ENOSR"
    "ENOSTR"
    "ENOSYS"
    "ENOTBLK"
    "ENOTCONN"
    "ENOTDIR"
    "ENOTEMPTY"
    "ENOTRECOVERABLE"
    "ENOTSOCK"
    "ENOTSUP"
    "ENOTTY"
    "ENXIO"
    "EOVERFLOW"
    "EOWNERDEAD"
    "EPERM"
    "EPFNOSUPPORT"
    "EPIPE"
    "EPROCLIM"
    "EPROCUNAVAIL"
    "EPROGMISMATCH"
    "EPROGUNAVAIL"
    "EPROTO"
    "EPROTONOSUPPORT"
    "EPROTOTYPE"
    "EPWROFF"
    "EQFULL"
    "ERANGE"
    "EREMOTE"
    "EROFS"
    "ERPCMISMATCH"
    "ESHLIBVERS"
    "ESHUTDOWN"
    "ESOCKTNOSUPPORT"
    "ESPIPE"
    "ESRCH"
    "ESTALE"
    "ETIME"
    "ETIMEDOUT"
    "ETOOMANYREFS"
    "ETXTBSY"
    "EUSERS"
    "EWOULDBLOCK"
    "EXDEV"
    "GCControllerDidConnect"
    "GCControllerDidDisconnect"
    "GKPlayerAuthenticationDidChangeNotificationName"
    "GKPlayerDidChangeNotificationName"
    "HKUserPreferencesDidChange"
    "IKFilterBrowserFilterDoubleClick"
    "IKFilterBrowserFilterSelected"
    "IKFilterBrowserWillPreviewFilter"
    "IOBluetoothHostControllerPoweredOff"
    "IOBluetoothHostControllerPoweredOn"
    "IOBluetoothL2CAPChannelPublished"
    "IOBluetoothL2CAPChannelTerminated"
    "ISO8601"
    "MFMessageComposeViewControllerTextMessageAvailabilityDidChange"
    "MKAnnotationCalloutInfoDidChange"
    "MPMediaLibraryDidChange"
    "MPMediaPlaybackIsPreparedToPlayDidChange"
    "MPMovieDurationAvailable"
    "MPMovieMediaTypesAvailable"
    "MPMovieNaturalSizeAvailable"
    "MPMoviePlayerDidEnterFullscreen"
    "MPMoviePlayerDidExitFullscreen"
    "MPMoviePlayerIsAirPlayVideoActiveDidChange"
    "MPMoviePlayerLoadStateDidChange"
    "MPMoviePlayerNowPlayingMovieDidChange"
    "MPMoviePlayerPlaybackDidFinish"
    "MPMoviePlayerPlaybackStateDidChange"
    "MPMoviePlayerReadyForDisplayDidChange"
    "MPMoviePlayerScalingModeDidChange"
    "MPMoviePlayerThumbnailImageRequestDidFinish"
    "MPMoviePlayerTimedMetadataUpdated"
    "MPMoviePlayerWillEnterFullscreen"
    "MPMoviePlayerWillExitFullscreen"
    "MPMovieSourceTypeAvailable"
    "MPMusicPlayerControllerNowPlayingItemDidChange"
    "MPMusicPlayerControllerPlaybackStateDidChange"
    "MPMusicPlayerControllerQueueDidChange"
    "MPMusicPlayerControllerVolumeDidChange"
    "MPVolumeViewWirelessRouteActiveDidChange"
    "MPVolumeViewWirelessRoutesAvailableDidChange"
    "NEDNSProxyConfigurationDidChange"
    "NEFilterConfigurationDidChange"
    "NEVPNConfigurationChange"
    "NEVPNStatusDidChange"
    "NKIssueDownloadCompleted"
    "NSAppleEventManagerWillProcessFirstEvent"
    "NSBundleResourceRequestLowDiskSpace"
    "NSCalendarCalendarUnit"
    "NSCalendarDayChanged"
    "NSClassDescriptionNeededForClass"
    "NSDayCalendarUnit"
    "NSDidBecomeSingleThreaded"
    "NSEraCalendarUnit"
    "NSExtensionHostDidBecomeActive"
    "NSExtensionHostDidEnterBackground"
    "NSExtensionHostWillEnterForeground"
    "NSExtensionHostWillResignActive"
    "NSFileHandleConnectionAccepted"
    "NSFileHandleDataAvailable"
    "NSFileHandleReadToEndOfFileCompletion"
    "NSHTTPCookieManagerAcceptPolicyChanged"
    "NSHTTPCookieManagerCookiesChanged"
    "NSHourCalendarUnit"
    "NSManagedObjectContextDidSave"
    "NSManagedObjectContextObjectsDidChange"
    "NSManagedObjectContextWillSave"
    "NSMetadataQueryDidFinishGathering"
    "NSMetadataQueryDidStartGathering"
    "NSMetadataQueryDidUpdate"
    "NSMetadataQueryGatheringProgress"
    "NSMinuteCalendarUnit"
    "NSMonthCalendarUnit"
    "NSPPDIncludeNotFoundException"
    "NSPPDIncludeStackOverflowException"
    "NSPPDIncludeStackUnderflowException"
    "NSPPDParseException"
    "NSPersistentStoreCoordinatorStoresDidChange"
    "NSPersistentStoreCoordinatorStoresWillChange"
    "NSPersistentStoreCoordinatorWillRemoveStore"
    "NSPersistentStoreDidImportUbiquitousContentChanges"
    "NSPersistentStoreRemoteChange"
    "NSPreferencePaneCancelUnselect"
    "NSPreferencePaneDoUnselect"
    "NSPreferencePaneSwitchToPane"
    "NSPreferencePaneUpdateHelpMenu"
    "NSPreferencePrefPaneIsAvailable"
    "NSProcessInfoPowerStateDidChange"
    "NSQuarterCalendarUnit"
    "NSRTFPropertyStackOverflowException"
    "NSSecondCalendarUnit"
    "NSSystemClockDidChange"
    "NSSystemTimeZoneDidChange"
    "NSTIFFException"
    "NSThreadWillExit"
    "NSThumbnail1024x1024SizeKey"
    "NSTimeZoneCalendarUnit"
    "NSURLCredentialStorageChanged"
    "NSURLErrorKey"
    "NSUbiquityIdentityDidChange"
    "NSUndoManagerCheckpoint"
    "NSUndoManagerDidCloseUndoGroup"
    "NSUndoManagerDidOpenUndoGroup"
    "NSUndoManagerDidRedoChange"
    "NSUndoManagerDidUndoChange"
    "NSUndoManagerWillCloseUndoGroup"
    "NSUndoManagerWillRedoChange"
    "NSUndoManagerWillUndoChange"
    "NSWeekCalendarUnit"
    "NSWeekOfMonthCalendarUnit"
    "NSWeekOfYearCalendarUnit"
    "NSWeekdayCalendarUnit"
    "NSWeekdayOrdinalCalendarUnit"
    "NSWillBecomeMultiThreaded"
    "NSYearCalendarUnit"
    "NSYearForWeekOfYearCalendarUnit"
    "PDFDocumentDidBeginFind"
    "PDFDocumentDidBeginPageFind"
    "PDFDocumentDidBeginPageWrite"
    "PDFDocumentDidBeginWrite"
    "PDFDocumentDidEndFind"
    "PDFDocumentDidEndPageFind"
    "PDFDocumentDidEndPageWrite"
    "PDFDocumentDidEndWrite"
    "PDFDocumentDidFindMatch"
    "PDFDocumentDidUnlock"
    "PDFThumbnailViewDocumentEdited"
    "PDFViewAnnotationHit"
    "PDFViewAnnotationWillHit"
    "PDFViewChangedHistory"
    "PDFViewCopyPermission"
    "PDFViewDisplayBoxChanged"
    "PDFViewDisplayModeChanged"
    "PDFViewDocumentChanged"
    "PDFViewPageChanged"
    "PDFViewPrintPermission"
    "PDFViewScaleChanged"
    "PDFViewSelectionChanged"
    "PDFViewVisiblePagesChanged"
    "PKPassLibraryDidChange"
    "PKPassLibraryRemotePaymentPassesDidChange"
    "QCCompositionPickerPanelDidSelectComposition"
    "QCCompositionPickerViewDidSelectComposition"
    "QCCompositionRepositoryDidUpdate"
    "QCViewDidStartRendering"
    "QCViewDidStopRendering"
    "SKCloudServiceCapabilitiesDidChange"
    "SKStorefrontCountryCodeDidChange"
    "SKStorefrontIdentifierDidChange"
    "ServiceApplicationLaunchFailedError"
    "ServiceApplicationNotFoundError"
    "ServiceInvalidPasteboardDataError"
    "ServiceMalformedServiceDictionaryError"
    "ServiceMiscellaneousError"
    "ServiceRequestTimedOutError"
    "SharingServiceNotConfiguredError"
    "TVTopShelfItemsDidChange"
    "TextReadInapplicableDocumentTypeError"
    "TextWriteInapplicableDocumentTypeError"
    "UIAccessibilityTextAttributeContext"
    "WKAccessibilityReduceMotionStatusDidChange"
    "WKAudioFilePlayerItemDidPlayToEndTime"
    "WKAudioFilePlayerItemFailedToPlayToEndTime"
    "WKAudioFilePlayerItemTimeJumped"
    "WebHistoryAllItemsRemoved"
    "WebHistoryItemChanged"
    "WebHistoryItemsAdded"
    "WebHistoryItemsRemoved"
    "WebHistoryLoaded"
    "WebHistorySaved"
    "WebPreferencesChanged"
    "WebViewDidBeginEditing"
    "WebViewDidChange"
    "WebViewDidChangeSelection"
    "WebViewDidChangeTypingStyle"
    "WebViewDidEndEditing"
    "WebViewProgressEstimateChanged"
    "WebViewProgressFinished"
    "WebViewProgressStarted"
    "abDatabaseChanged"
    "abDatabaseChangedExternally"
    "abbreviatingWithTildeInPath"
    "abbreviation"
    "abbreviationDictionary"
    "abortModalException"
    "abortPrintingException"
    "aborted"
    "absoluteString"
    "absoluteURL"
    "accessibilityAlignment"
    "accessibilityAnnotationTextAttribute"
    "accessibilityAttachment"
    "accessibilityAutocorrected"
    "accessibilityBackgroundColor"
    "accessibilityCustomText"
    "accessibilityDisplayOptionsDidChangeNotification"
    "accessibilityException"
    "accessibilityFont"
    "accessibilityForegroundColor"
    "accessibilityLanguage"
    "accessibilityLink"
    "accessibilityListItemIndex"
    "accessibilityListItemLevel"
    "accessibilityListItemPrefix"
    "accessibilityMarkedMisspelled"
    "accessibilityMisspelled"
    "accessibilityShadow"
    "accessibilitySpeechIPANotation"
    "accessibilitySpeechLanguage"
    "accessibilitySpeechPitch"
    "accessibilitySpeechPunctuation"
    "accessibilitySpeechQueueAnnouncement"
    "accessibilitySpeechSpellOut"
    "accessibilityStrikethrough"
    "accessibilityStrikethroughColor"
    "accessibilitySuperscript"
    "accessibilityTextCustom"
    "accessibilityTextHeadingLevel"
    "accessibilityUnderline"
    "accessibilityUnderlineColor"
    "acquireFunction"
    "acreFeet"
    "acres"
    "actionButtonTitle"
    "activationType"
    "activeProcessorCount"
    "activeSpaceDidChangeNotification"
    "activityType"
    "actualDeliveryDate"
    "addedToDirectoryDate"
    "addedToDirectoryDateKey"
    "additionalActions"
    "additionalActivationAction"
    "address"
    "addressComponents"
    "addresses"
    "adjective"
    "adverb"
    "aeDesc"
    "affectedObjects"
    "affectedStores"
    "airline"
    "allBundles"
    "allCredentials"
    "allCustomTypes"
    "allDomainsMask"
    "allFrameworks"
    "allHTTPHeaderFields"
    "allHeaderFields"
    "allKeys"
    "allLanguages"
    "allObjects"
    "allPartitionsAndEjectDisk"
    "allScripts"
    "allSystemTypes"
    "allTypes"
    "allValues"
    "allowCommentsAndWhitespace"
    "allowFragments"
    "allowLossy"
    "allowLossyKey"
    "allowedClasses"
    "allowedExternalEntityURLs"
    "allowedTopLevelClasses"
    "allowedUnits"
    "allowsCellularAccess"
    "allowsConstrainedNetworkAccess"
    "allowsExpensiveNetworkAccess"
    "allowsFloats"
    "allowsFractionalUnits"
    "allowsKeyedCoding"
    "allowsNonnumericFormatting"
    "alphanumerics"
    "alreadyInSet"
    "alreadyWaiting"
    "alternateQuotationBeginDelimiter"
    "alternateQuotationBeginDelimiterKey"
    "alternateQuotationEndDelimiter"
    "alternateQuotationEndDelimiterKey"
    "alternativeStrings"
    "alwaysInteract"
    "alwaysMapped"
    "alwaysShowsDecimalSeparator"
    "amSymbol"
    "ampereHours"
    "amperes"
    "anchored"
    "anchorsMatchLines"
    "announcementDidFinishNotification"
    "announcementRequested"
    "antialiasThresholdChangedNotification"
    "anyObject"
    "appKitIgnoredException"
    "appKitVirtualMemoryException"
    "appStoreReceiptURL"
    "appTransportSecurityRequiresSecureConnection"
    "appearance"
    "appendOnly"
    "appleEvent"
    "appleEventClassCode"
    "appleEventCode"
    "appleEventCodeForReturnType"
    "applicationActivated"
    "applicationDeactivated"
    "applicationHidden"
    "applicationIsScriptable"
    "applicationIsScriptableKey"
    "applicationShown"
    "arcMinutes"
    "arcSeconds"
    "archiverData"
    "ares"
    "argumentDomain"
    "argumentNames"
    "arguments"
    "array"
    "ascending"
    "assistiveTouchStatusDidChangeNotification"
    "associatedIndex"
    "astronomicalUnits"
    "atomic"
    "atomicWrite"
    "attachment"
    "attachments"
    "attribute"
    "attributeKeys"
    "attributeModificationDate"
    "attributeModificationDateKey"
    "attributedContentText"
    "attributedStringForNil"
    "attributedStringForNotANumber"
    "attributedStringForZero"
    "attributedTitle"
    "attributes"
    "auditSessionIdentifier"
    "authenticationMethod"
    "author"
    "automaticTerminationDisabled"
    "automaticTerminationSupportEnabled"
    "autoupdatingCurrent"
    "availableData"
    "availableIdentifiers"
    "availableLocaleIdentifiers"
    "availableStringEncodings"
    "averageKeyValueOperator"
    "background"
    "backgroundColor"
    "backgroundRefreshStatusDidChangeNotification"
    "backgroundSessionInUseByAnotherProcess"
    "backgroundSessionRequiresSharedContainer"
    "backgroundSessionWasDisconnected"
    "backgroundTaskCancelledReason"
    "backwards"
    "badBitmapParametersException"
    "badComparisonException"
    "badRTFColorTableException"
    "badRTFDirectiveException"
    "badRTFFontTableException"
    "badRTFStyleSheetException"
    "badServerResponse"
    "badURL"
    "bars"
    "baseSpecifier"
    "baseURL"
    "baselineOffset"
    "batteryLevelDidChangeNotification"
    "batteryStateDidChangeNotification"
    "bitmapRepresentation"
    "bits"
    "blockSpecial"
    "boldTextStatusDidChangeNotification"
    "boolValue"
    "booleanValue"
    "bottom"
    "bottomMargin"
    "boundsDidChangeNotification"
    "brightnessDidChangeNotification"
    "browserIllegalDelegateException"
    "buddhist"
    "builtInPlugInsPath"
    "builtInPlugInsURL"
    "bundle"
    "bundleIdentifier"
    "bundlePath"
    "bundleURL"
    "bushels"
    "busy"
    "byComposedCharacterSequences"
    "byLines"
    "byMoving"
    "byParagraphs"
    "bySentences"
    "byWords"
    "bytes"
    "cStringPersonality"
    "caTransform3DValue"
    "cachePolicy"
    "cachedResponse"
    "calendar"
    "calendarIdentifier"
    "callIsActive"
    "callSignaling"
    "callStackReturnAddresses"
    "callStackSymbols"
    "calories"
    "canInteract"
    "canRedo"
    "canSwitchLayer"
    "canUndo"
    "cancellationHandler"
    "cancelled"
    "cannotCloseFile"
    "cannotConnectToHost"
    "cannotCreateFile"
    "cannotDecodeContentData"
    "cannotDecodeRawData"
    "cannotFindHost"
    "cannotLoadFromNetwork"
    "cannotMoveFile"
    "cannotOpenFile"
    "cannotParseResponse"
    "cannotRemoveFile"
    "cannotWriteToFile"
    "canonicalPath"
    "canonicalPathKey"
    "capitalized"
    "capitalizedLetters"
    "carats"
    "caseInsensitive"
    "caseSensitive"
    "category"
    "celsius"
    "center"
    "centigrams"
    "centiliters"
    "centimeters"
    "certificates"
    "cgAffineTransformValue"
    "cgPointValue"
    "cgRectValue"
    "cgSizeValue"
    "cgVectorValue"
    "changeType"
    "changedNotification"
    "characterConversionException"
    "characterEncoding"
    "characterShapeAttributeName"
    "characterSpecial"
    "charactersToBeSkipped"
    "checkingTypes"
    "child"
    "childCount"
    "children"
    "chinese"
    "city"
    "className"
    "classifier"
    "client"
    "clientCertificateRejected"
    "clientCertificateRequired"
    "closeCode"
    "closeParenthesis"
    "closeQuote"
    "closeReason"
    "closedCaptioningStatusDidChangeNotification"
    "cocoaVersion"
    "code"
    "coderInvalidValue"
    "coderReadCorrupt"
    "coderReadCorruptError"
    "coderValueNotFound"
    "coderValueNotFoundError"
    "codesignError"
    "coefficient"
    "collapsesLargestUnit"
    "collationIdentifier"
    "collatorIdentifier"
    "collection"
    "colorDidChangeNotification"
    "colorListIOException"
    "colorListNotEditableException"
    "colorSpaceDidChangeNotification"
    "columnConfigurationDidChangeNotification"
    "columnDidMoveNotification"
    "columnDidResizeNotification"
    "columnNumber"
    "commandClassName"
    "commandDescription"
    "commandName"
    "comment"
    "commentURL"
    "common"
    "commonISOCurrencyCodes"
    "company"
    "comparator"
    "comparisonPredicateModifier"
    "complete"
    "completeFileProtection"
    "completeFileProtectionUnlessOpen"
    "completeFileProtectionUntilFirstUserAuthentication"
    "completeUnlessOpen"
    "completeUntilFirstUserAuthentication"
    "completed"
    "completedInitialCloudSyncNotification"
    "completedUnitCount"
    "completionBlock"
    "components"
    "compoundPredicateType"
    "concurrent"
    "condition"
    "configuration"
    "conjunction"
    "connectEndDate"
    "connectStartDate"
    "connection"
    "connectionProxyDictionary"
    "constant"
    "constantValue"
    "container"
    "containerClassDescription"
    "containerFrame"
    "containerIsObjectBeingTested"
    "containerIsRangeContainerObject"
    "containsAttachments"
    "contentAccessDate"
    "contentAccessDateKey"
    "contentAttributeSet"
    "contentImage"
    "contentIndependentMetadataOnly"
    "contentModificationDate"
    "contentModificationDateKey"
    "contextHelpModeDidActivateNotification"
    "contextHelpModeDidDeactivateNotification"
    "contextIdentifierPath"
    "controlCharacters"
    "converted"
    "converter"
    "cookieAcceptPolicy"
    "cookies"
    "coptic"
    "copyIn"
    "copying"
    "copyright"
    "coreData"
    "coreDataError"
    "correction"
    "coulombs"
    "count"
    "countKeyValueOperator"
    "countLimit"
    "countOfBytesClientExpectsToReceive"
    "countOfBytesClientExpectsToSend"
    "countOfBytesExpectedToReceive"
    "countOfBytesExpectedToSend"
    "countOfBytesReceived"
    "countOfBytesSent"
    "countOfRequestBodyBytesBeforeEncoding"
    "countOfRequestBodyBytesSent"
    "countOfRequestHeaderBytesSent"
    "countOfResponseBodyBytesAfterDecoding"
    "countOfResponseBodyBytesReceived"
    "countOfResponseHeaderBytesReceived"
    "countStyle"
    "country"
    "countryCode"
    "createClassDescription"
    "created"
    "creationDate"
    "creationDateKey"
    "creationTime"
    "cubicCentimeters"
    "cubicDecimeters"
    "cubicFeet"
    "cubicInches"
    "cubicKilometers"
    "cubicMeters"
    "cubicMiles"
    "cubicMillimeters"
    "cubicYards"
    "cups"
    "currencyCode"
    "currencyDecimalSeparator"
    "currencyGroupingSeparator"
    "currencySymbol"
    "current"
    "currentAppleEvent"
    "currentControlTintDidChangeNotification"
    "currentDirectoryPath"
    "currentDirectoryURL"
    "currentDiskUsage"
    "currentIndex"
    "currentInputModeDidChangeNotification"
    "currentLocaleDidChangeNotification"
    "currentMemoryUsage"
    "currentMode"
    "currentReplyAppleEvent"
    "currentRequest"
    "cursor"
    "customIcon"
    "customIconKey"
    "customMirror"
    "customPlaygroundQuickLook"
    "customSelector"
    "darkerSystemColorsStatusDidChangeNotification"
    "dash"
    "data"
    "dataDecodingStrategy"
    "dataEncodingStrategy"
    "dataLengthExceedsMaximum"
    "dataNotAllowed"
    "dataReadingMapped"
    "dataRepresentation"
    "dataWrittenToMemoryStreamKey"
    "date"
    "dateDecodingStrategy"
    "dateEncodingStrategy"
    "dateFormat"
    "dateStyle"
    "dateTemplate"
    "dateTimeStyle"
    "dateValue"
    "day"
    "daylightSavingTimeOffset"
    "deallocateReceiveRight"
    "deallocateSendRight"
    "debugDescription"
    "decameters"
    "decigrams"
    "deciliters"
    "decimalDigits"
    "decimalNumberDivideByZeroException"
    "decimalNumberExactnessException"
    "decimalNumberOverflowException"
    "decimalNumberUnderflowException"
    "decimalSeparator"
    "decimalValue"
    "decimeters"
    "decodingFailurePolicy"
    "decomposables"
    "decomposedStringWithCanonicalMapping"
    "decomposedStringWithCompatibilityMapping"
    "decompressingAfterDownloading"
    "default"
    "defaultAttributes"
    "defaultBehavior"
    "defaultCStringEncoding"
    "defaultDate"
    "defaultFormatterBehavior"
    "defaultMaxConcurrentOperationCount"
    "defaultOptions"
    "defaultPriority"
    "defaultSet"
    "defaultSubcontainerAttributeKey"
    "defaultTabInterval"
    "degrees"
    "delegate"
    "delegateQueue"
    "deletesFileUponFailure"
    "deletingLastPathComponent"
    "deletingPathExtension"
    "deliverImmediately"
    "deliveredNotifications"
    "deliveryDate"
    "deliveryRepeatInterval"
    "deliveryTimeZone"
    "dependencies"
    "describe"
    "description"
    "descriptionFunction"
    "descriptionInStringsFileFormat"
    "descriptor"
    "descriptorType"
    "destinationInvalidException"
    "detectedBarcodeDescriptor"
    "determiner"
    "developmentLocalization"
    "deviceIdentifier"
    "diacriticInsensitive"
    "dictionaryRepresentation"
    "didActivateApplicationNotification"
    "didAddItemNotification"
    "didBecomeActiveNotification"
    "didBecomeHiddenNotification"
    "didBecomeInvalidNotification"
    "didBecomeKeyNotification"
    "didBecomeMainNotification"
    "didBecomeVisibleNotification"
    "didBeginEditingNotification"
    "didBeginTrackingNotification"
    "didChangeAutomaticCapitalizationNotification"
    "didChangeAutomaticDashSubstitutionNotification"
    "didChangeAutomaticPeriodSubstitutionNotification"
    "didChangeAutomaticQuoteSubstitutionNotification"
    "didChangeAutomaticSpellingCorrectionNotification"
    "didChangeAutomaticTextCompletionNotification"
    "didChangeAutomaticTextReplacementNotification"
    "didChangeBackingPropertiesNotification"
    "didChangeCloudAccountsNotification"
    "didChangeExternallyNotification"
    "didChangeFileLabelsNotification"
    "didChangeItemNotification"
    "didChangeNotification"
    "didChangeOcclusionStateNotification"
    "didChangeScreenNotification"
    "didChangeScreenParametersNotification"
    "didChangeScreenProfileNotification"
    "didChangeSelectionNotification"
    "didChangeStatusBarFrameNotification"
    "didChangeStatusBarOrientationNotification"
    "didChangeTypingAttributesNotification"
    "didCloseNotification"
    "didConnectNotification"
    "didDeactivateApplicationNotification"
    "didDeminiaturizeNotification"
    "didDisconnectNotification"
    "didEndEditingNotification"
    "didEndLiveMagnifyNotification"
    "didEndLiveResizeNotification"
    "didEndLiveScrollNotification"
    "didEndSheetNotification"
    "didEndTrackingNotification"
    "didEnterBackgroundNotification"
    "didEnterFullScreenNotification"
    "didEnterVersionBrowserNotification"
    "didExitFullScreenNotification"
    "didExitVersionBrowserNotification"
    "didExposeNotification"
    "didFinishLaunchingNotification"
    "didFinishRestoringWindowsNotification"
    "didHideApplicationNotification"
    "didHideMenuNotification"
    "didHideNotification"
    "didLaunchApplicationNotification"
    "didLiveScrollNotification"
    "didLoadNotification"
    "didMiniaturizeNotification"
    "didMountNotification"
    "didMoveNotification"
    "didOpenNotification"
    "didPerformFileOperationNotification"
    "didProcessEditingNotification"
    "didReceiveMemoryWarningNotification"
    "didRemoveItemNotification"
    "didRenameVolumeNotification"
    "didResignActiveNotification"
    "didResignKeyNotification"
    "didResignMainNotification"
    "didResizeNotification"
    "didResizeSubviewsNotification"
    "didSendActionNotification"
    "didShowMenuNotification"
    "didShowNotification"
    "didTerminateApplicationNotification"
    "didTerminateNotification"
    "didUnhideApplicationNotification"
    "didUnhideNotification"
    "didUnmountNotification"
    "didUpdateNotification"
    "didUpdateTrackingAreasNotification"
    "didWakeNotification"
    "directParameter"
    "directionalEdgeInsetsValue"
    "directory"
    "directoryAttributes"
    "disableScreenFontSubstitution"
    "disallowedEncodingsKey"
    "discard"
    "diskCapacity"
    "distantFuture"
    "distantPast"
    "distinctUnionOfArraysKeyValueOperator"
    "distinctUnionOfObjectsKeyValueOperator"
    "distinctUnionOfSetsKeyValueOperator"
    "distinguishedNames"
    "dnsLookupFailed"
    "docFormat"
    "documentContentKind"
    "documentIdentifier"
    "documentIdentifierKey"
    "documentIncludeContentTypeDeclaration"
    "documentTidyHTML"
    "documentTidyXML"
    "documentType"
    "documentValidate"
    "documentXInclude"
    "doesRelativeDateFormatting"
    "domain"
    "domainLookupEndDate"
    "domainLookupStartDate"
    "dominantLanguage"
    "dominantScript"
    "dontAnnotate"
    "dontExecute"
    "dontRecord"
    "dotMatchesLineSeparators"
    "doubleValue"
    "downloadDecodingFailedMidStream"
    "downloadDecodingFailedToComplete"
    "downloadTaskResumeData"
    "downloaded"
    "downloading"
    "draggingException"
    "drawerCreated"
    "dropAll"
    "dropLeading"
    "dropMiddle"
    "dropTrailing"
    "dtd"
    "dtdKind"
    "duration"
    "earliestBeginDate"
    "edgeInsetsValue"
    "editor"
    "effectiveGroupIdentifier"
    "effectiveIcon"
    "effectiveIconKey"
    "effectiveUserIdentifier"
    "elementFocusedNotification"
    "encodedData"
    "end"
    "endDate"
    "endEncountered"
    "endIndex"
    "endLineWithCarriageReturn"
    "endLineWithLineFeed"
    "endSpecifier"
    "endSubelementIdentifier"
    "endSubelementIndex"
    "endpoint"
    "entityMigrationPolicy"
    "entityMigrationPolicyError"
    "enumCodeValue"
    "environment"
    "ephemeral"
    "era"
    "eraSymbols"
    "error"
    "errorAppName"
    "errorBriefMessage"
    "errorCode"
    "errorDescription"
    "errorDomain"
    "errorMessage"
    "errorNumber"
    "errorOccurred"
    "errorRange"
    "errorUserInfo"
    "estimatedTimeRemaining"
    "estimatedTimeRemainingKey"
    "ethiopicAmeteAlem"
    "ethiopicAmeteMihret"
    "evaluatedArguments"
    "evaluatedReceivers"
    "evaluationError"
    "evaluationErrorNumber"
    "eventClass"
    "eventID"
    "eventTracking"
    "evictsObjectsWithDiscardedContent"
    "exabits"
    "exabytes"
    "exbibits"
    "exbibytes"
    "exceptionProtected"
    "excludedElements"
    "executableArchitectureMismatch"
    "executableArchitectureMismatchError"
    "executableArchitectures"
    "executableLink"
    "executableLinkError"
    "executableLoad"
    "executableLoadError"
    "executableNotLoadable"
    "executableNotLoadableError"
    "executablePath"
    "executableRuntimeMismatch"
    "executableRuntimeMismatchError"
    "executableURL"
    "executionBlocks"
    "exemplarCharacterSet"
    "expandingTildeInPath"
    "expansion"
    "expectedContentLength"
    "expirationDate"
    "expires"
    "expiresDate"
    "exponent"
    "exponentSymbol"
    "exportedInterface"
    "exportedObject"
    "expressionBlock"
    "expressionType"
    "extensionHidden"
    "externalEntityResolvingPolicy"
    "externalMediaContentIdentifier"
    "externalRecordImport"
    "externalRecordImportError"
    "externalRepresentation"
    "extra"
    "fahrenheit"
    "failingURL"
    "failure"
    "failureReason"
    "failureResponse"
    "failureURLPeerTrust"
    "failureURLString"
    "false"
    "familyName"
    "fastestEncoding"
    "fathoms"
    "featureUnsupported"
    "featureUnsupportedError"
    "feet"
    "femtowatts"
    "fetchStartDate"
    "file"
    "fileAllocatedSize"
    "fileAllocatedSizeKey"
    "fileAnimationImageKey"
    "fileAnimationImageOriginalRectKey"
    "fileAttributes"
    "fileCompletedCount"
    "fileCompletedCountKey"
    "fileCurrentOffsetKey"
    "fileDescriptor"
    "fileDoesNotExist"
    "fileHandleForReading"
    "fileHandleForWriting"
    "fileHandleOperationException"
    "fileIconKey"
    "fileIsDirectory"
    "fileLocking"
    "fileLockingError"
    "fileManagerUnmountBusy"
    "fileManagerUnmountBusyError"
    "fileManagerUnmountUnknown"
    "fileManagerUnmountUnknownError"
    "fileNoSuchFile"
    "fileNoSuchFileError"
    "fileOperationKind"
    "fileOperationKindKey"
    "filePath"
    "filePathErrorKey"
    "filePathURL"
    "filePresenters"
    "fileProtection"
    "fileProtectionKey"
    "fileProtectionMask"
    "fileReadCorruptFile"
    "fileReadCorruptFileError"
    "fileReadInapplicableStringEncoding"
    "fileReadInapplicableStringEncodingError"
    "fileReadInvalidFileName"
    "fileReadInvalidFileNameError"
    "fileReadNoPermission"
    "fileReadNoPermissionError"
    "fileReadNoSuchFile"
    "fileReadNoSuchFileError"
    "fileReadTooLarge"
    "fileReadTooLargeError"
    "fileReadUnknown"
    "fileReadUnknownError"
    "fileReadUnknownStringEncoding"
    "fileReadUnknownStringEncodingError"
    "fileReadUnsupportedScheme"
    "fileReadUnsupportedSchemeError"
    "fileResourceIdentifier"
    "fileResourceIdentifierKey"
    "fileResourceType"
    "fileResourceTypeKey"
    "fileSecurity"
    "fileSecurityKey"
    "fileSize"
    "fileSizeKey"
    "fileSystemRepresentation"
    "fileTotalCount"
    "fileTotalCountKey"
    "fileType"
    "fileURL"
    "fileURLKey"
    "fileURLValue"
    "fileWrappers"
    "fileWriteFileExists"
    "fileWriteFileExistsError"
    "fileWriteInapplicableStringEncoding"
    "fileWriteInapplicableStringEncodingError"
    "fileWriteInvalidFileName"
    "fileWriteInvalidFileNameError"
    "fileWriteNoPermission"
    "fileWriteNoPermissionError"
    "fileWriteOutOfSpace"
    "fileWriteOutOfSpaceError"
    "fileWriteUnknown"
    "fileWriteUnknownError"
    "fileWriteUnsupportedScheme"
    "fileWriteUnsupportedSchemeError"
    "fileWriteVolumeReadOnly"
    "fileWriteVolumeReadOnlyError"
    "filename"
    "fireDate"
    "first"
    "firstEqual"
    "firstIndex"
    "firstObject"
    "firstWeekday"
    "flight"
    "floatValue"
    "floatingPointClass"
    "fluidOunces"
    "focusedUIElementChanged"
    "focusedWindowChanged"
    "font"
    "fontAssetDownloadError"
    "fontSetChangedNotification"
    "fontUnavailableException"
    "forDeleting"
    "forMerging"
    "forMoving"
    "forReplacing"
    "forUploading"
    "forcedOrdering"
    "foregroundColor"
    "format"
    "formatOptions"
    "formatWidth"
    "formatterBehavior"
    "formatting"
    "formattingContext"
    "formattingError"
    "fractionCompleted"
    "fragment"
    "fragmentsAllowed"
    "frameDidChangeNotification"
    "framesPerSecond"
    "fromWindowsKey"
    "fullUserName"
    "fullwidthToHalfwidth"
    "function"
    "furlongs"
    "gallons"
    "generatesCalendarDates"
    "generatesDecimalNumbers"
    "generationIdentifier"
    "generationIdentifierKey"
    "genericException"
    "gibibits"
    "gibibytes"
    "gigabits"
    "gigabytes"
    "gigahertz"
    "gigapascals"
    "gigawatts"
    "givenName"
    "globalDomain"
    "globalFrameDidChangeNotification"
    "globallyUniqueString"
    "glyphInfo"
    "gradians"
    "grammar"
    "grammarDetails"
    "grams"
    "gramsPerLiter"
    "gravity"
    "grayscaleStatusDidChangeNotification"
    "greatestFiniteMagnitude"
    "gregorian"
    "gregorianStartDate"
    "groupOwnerAccountID"
    "groupOwnerAccountName"
    "groupedResults"
    "groupingAttributes"
    "groupingLevel"
    "groupingSeparator"
    "groupingSize"
    "groupsByEvent"
    "guidedAccessStatusDidChangeNotification"
    "hasActionButton"
    "hasBytesAvailable"
    "hasChanges"
    "hasDirectoryPath"
    "hasHiddenExtension"
    "hasHiddenExtensionKey"
    "hasLocalContents"
    "hasPassword"
    "hasReplyButton"
    "hasSpaceAvailable"
    "hasThousandSeparators"
    "hasThumbnail"
    "hash"
    "hashFunction"
    "hashValue"
    "hearingDevicePairedEarDidChangeNotification"
    "hebrew"
    "hectares"
    "hectometers"
    "hectopascals"
    "helpAnchor"
    "helpAnchorErrorKey"
    "helpTagCreated"
    "hertz"
    "hfsCreatorCode"
    "hfsTypeCode"
    "hierarchyInconsistencyException"
    "highPriority"
    "hiraganaToKatakana"
    "hitEnd"
    "homeDirectoryForCurrentUser"
    "horsepower"
    "host"
    "hostKey"
    "hostName"
    "hostedViewMaximumAllowedSize"
    "hostedViewMinimumAllowedSize"
    "hour"
    "hours"
    "html"
    "httpAdditionalHeaders"
    "httpBody"
    "httpBodyStream"
    "httpCookieAcceptPolicy"
    "httpCookieStorage"
    "httpMaximumConnectionsPerHost"
    "httpMethod"
    "httpShouldHandleCookies"
    "httpShouldSetCookies"
    "httpShouldUsePipelining"
    "httpTooManyRedirects"
    "hyphenationFactor"
    "icon"
    "identifier"
    "identity"
    "idiom"
    "idleDisplaySleepDisabled"
    "idleSystemSleepDisabled"
    "ignoreMetacharacters"
    "ignoreUnknownCharacters"
    "illegalCharacters"
    "illegalSelectorException"
    "imageCacheException"
    "immediate"
    "immediatelyAvailableMetadataOnly"
    "immutable"
    "imperialFluidOunces"
    "imperialGallons"
    "imperialPints"
    "imperialQuarts"
    "imperialTablespoons"
    "imperialTeaspoons"
    "implementationClassName"
    "inches"
    "inchesOfMercury"
    "includesActualByteCount"
    "includesApproximationPhrase"
    "includesCount"
    "includesDirectoriesPostOrder"
    "includesPeerToPeer"
    "includesTimeRemainingPhrase"
    "includesUnit"
    "inconsistentArchiveException"
    "index"
    "indexes"
    "indexesKey"
    "indian"
    "indices"
    "inferMoves"
    "inferredMappingModel"
    "inferredMappingModelError"
    "infoDictionary"
    "informativeText"
    "initial"
    "inputItems"
    "insertionContainer"
    "insertionIndex"
    "insertionKey"
    "insertionReplaces"
    "insertions"
    "int16Value"
    "int32Value"
    "int64Value"
    "int8Value"
    "intValue"
    "integerPersonality"
    "integerValue"
    "intent"
    "interaction"
    "interjection"
    "internalError"
    "internalInconsistencyException"
    "internationalCurrencySymbol"
    "internationalRoamingOff"
    "interruptionHandler"
    "interruptionNotification"
    "interval"
    "invalidAddress"
    "invalidArchiveOperationException"
    "invalidArgument"
    "invalidArgumentException"
    "invalidCapability"
    "invalidHost"
    "invalidInterfaceOrientationException"
    "invalidLedger"
    "invalidMemoryControl"
    "invalidName"
    "invalidObject"
    "invalidPolicy"
    "invalidProcessorSet"
    "invalidReceivePortException"
    "invalidRight"
    "invalidSecurity"
    "invalidSendPortException"
    "invalidTask"
    "invalidUnarchiveOperationException"
    "invalidValue"
    "invalidationHandler"
    "invertColorsStatusDidChangeNotification"
    "inverted"
    "invocationOperationCancelledException"
    "invocationOperationVoidResultException"
    "isAbsolutePath"
    "isAdaptive"
    "isAliasFile"
    "isAliasFileKey"
    "isApplication"
    "isApplicationKey"
    "isAsynchronous"
    "isAtEnd"
    "isCancellable"
    "isCancelled"
    "isCanonical"
    "isCellular"
    "isClassKitDeepLink"
    "isCoderError"
    "isCompiled"
    "isConcurrent"
    "isConflict"
    "isConstrained"
    "isDaylightSavingTime"
    "isDirectory"
    "isDirectoryKey"
    "isDiscardable"
    "isDiscretionary"
    "isEligibleForHandoff"
    "isEligibleForPrediction"
    "isEligibleForPublicIndexing"
    "isEligibleForSearch"
    "isEmpty"
    "isEnumeratingDirectoryPostOrder"
    "isEqual"
    "isEqualFunction"
    "isExcludedFromBackup"
    "isExcludedFromBackupKey"
    "isExecutable"
    "isExecutableError"
    "isExecutableKey"
    "isExecuting"
    "isExpensive"
    "isExternal"
    "isFileError"
    "isFileURL"
    "isFinished"
    "isFinite"
    "isFontError"
    "isForFoodEnergyUse"
    "isForPersonHeightUse"
    "isForPersonMassUse"
    "isFormattingError"
    "isGathering"
    "isHTTPOnly"
    "isHidden"
    "isHiddenKey"
    "isIndeterminate"
    "isInfinite"
    "isLeapMonth"
    "isLenient"
    "isLoaded"
    "isLowPowerModeEnabled"
    "isMacCatalystApp"
    "isMainThread"
    "isMountTrigger"
    "isMountTriggerKey"
    "isMultipath"
    "isNaN"
    "isNilTransformerName"
    "isNormal"
    "isNotNilTransformerName"
    "isOld"
    "isPackage"
    "isPackageKey"
    "isPartialStringValidationEnabled"
    "isPausable"
    "isPaused"
    "isPhonetic"
    "isPresented"
    "isPrior"
    "isPropertyListError"
    "isProxyConnection"
    "isReadable"
    "isReadableKey"
    "isReady"
    "isRecordDescriptor"
    "isRedoing"
    "isRegularFile"
    "isRegularFileKey"
    "isRemote"
    "isResolved"
    "isReusedConnection"
    "isRunning"
    "isSecure"
    "isServiceError"
    "isSessionOnly"
    "isSharingServiceError"
    "isSignMinus"
    "isSignaling"
    "isSignalingNaN"
    "isStandalone"
    "isStarted"
    "isStopped"
    "isSubnormal"
    "isSuspended"
    "isSymbolicLink"
    "isSymbolicLinkKey"
    "isSystemImmutable"
    "isSystemImmutableKey"
    "isTextReadWriteError"
    "isUbiquitousFileError"
    "isUbiquitousItem"
    "isUbiquitousItemKey"
    "isUndoRegistrationEnabled"
    "isUndoing"
    "isUserActivityError"
    "isUserImmutable"
    "isUserImmutableKey"
    "isValid"
    "isValidDate"
    "isValidationError"
    "isVolume"
    "isVolumeKey"
    "isWellFormed"
    "isWritable"
    "isWritableKey"
    "isXPCConnectionError"
    "isZero"
    "islamic"
    "islamicCivil"
    "islamicTabular"
    "islamicUmmAlQura"
    "isoCountryCodes"
    "isoCurrencyCodes"
    "isoLanguageCodes"
    "isoRegionCodes"
    "item"
    "itemDidCollapseNotification"
    "itemDidExpandNotification"
    "itemFormatter"
    "itemWillCollapseNotification"
    "itemWillExpandNotification"
    "itemsPtr"
    "japanese"
    "jobTitle"
    "joinNames"
    "joules"
    "kelvin"
    "kern"
    "key"
    "keyClassDescription"
    "keyDecodingStrategy"
    "keyEncodingStrategy"
    "keyPath"
    "keyPointerFunctions"
    "keySpecifier"
    "keyValueValidation"
    "keyValueValidationError"
    "keyboardDidChangeFrameNotification"
    "keyboardDidHideNotification"
    "keyboardDidShowNotification"
    "keyboardSelectionDidChangeNotification"
    "keyboardWillChangeFrameNotification"
    "keyboardWillHideNotification"
    "keyboardWillShowNotification"
    "keyedUnarchiveFromDataTransformerName"
    "keysOfUnsetValuesKey"
    "keywords"
    "kibibits"
    "kibibytes"
    "kiloampereHours"
    "kiloamperes"
    "kilobits"
    "kilobytes"
    "kilocalories"
    "kilograms"
    "kilohertz"
    "kilojoules"
    "kiloliters"
    "kilometers"
    "kilometersPerHour"
    "kiloohms"
    "kilopascals"
    "kilovolts"
    "kilowattHours"
    "kilowatts"
    "kind"
    "kindKey"
    "knots"
    "knownTimeZoneIdentifiers"
    "knownTimeZoneNames"
    "labelColor"
    "labelColorKey"
    "labelNumber"
    "labelNumberKey"
    "language"
    "languageCode"
    "languageMap"
    "last"
    "lastEqual"
    "lastIndex"
    "lastObject"
    "lastPathComponent"
    "latencyCritical"
    "latinToArabic"
    "latinToCyrillic"
    "latinToGreek"
    "latinToHangul"
    "latinToHebrew"
    "latinToHiragana"
    "latinToKatakana"
    "latinToThai"
    "launchPath"
    "layoutChanged"
    "lazy"
    "leastFiniteMagnitude"
    "leastNonzeroMagnitude"
    "leastNormalMagnitude"
    "left"
    "leftExpression"
    "leftMargin"
    "lemma"
    "length"
    "letterpressStyle"
    "letters"
    "level"
    "levelsOfUndo"
    "lexicalClass"
    "ligature"
    "lightyears"
    "likelyLanguageKey"
    "lineLength64Characters"
    "lineLength76Characters"
    "lineNumber"
    "link"
    "linkCount"
    "linkCountKey"
    "listenForConnections"
    "literal"
    "liters"
    "litersPer100Kilometers"
    "loadingPriority"
    "local"
    "localAddress"
    "localDomainMask"
    "localName"
    "localNotificationCenterType"
    "localPort"
    "locale"
    "localeIdentifier"
    "localizations"
    "localized"
    "localizedAdditionalDescription"
    "localizedCapitalized"
    "localizedDescription"
    "localizedDescriptionKey"
    "localizedFailureReason"
    "localizedFailureReasonErrorKey"
    "localizedInfoDictionary"
    "localizedLabel"
    "localizedLabelKey"
    "localizedLowercase"
    "localizedName"
    "localizedNameKey"
    "localizedNameOfSavingComputer"
    "localizedRecoveryOptions"
    "localizedRecoveryOptionsErrorKey"
    "localizedRecoverySuggestion"
    "localizedRecoverySuggestionErrorKey"
    "localizedTypeDescription"
    "localizedTypeDescriptionKey"
    "localizedUppercase"
    "localizesFormat"
    "lockDate"
    "lockOwned"
    "lockOwnedSelf"
    "lockSetDestroyed"
    "lockUnstable"
    "longEraSymbols"
    "longLongValue"
    "longestEffectiveRangeNotRequired"
    "lossySubstitutionKey"
    "lowPriority"
    "lowercaseLetters"
    "lowercased"
    "lux"
    "m11"
    "m12"
    "m21"
    "m22"
    "macSimpleText"
    "machPort"
    "machVirtualMemory"
    "magnitude"
    "main"
    "mainDocumentURL"
    "mainWindowChanged"
    "majorVersion"
    "mallocException"
    "mallocMemory"
    "managedObjectConstraintMerge"
    "managedObjectConstraintMergeError"
    "managedObjectContextLocking"
    "managedObjectContextLockingError"
    "managedObjectExternalRelationship"
    "managedObjectExternalRelationshipError"
    "managedObjectMerge"
    "managedObjectMergeError"
    "managedObjectReferentialIntegrity"
    "managedObjectReferentialIntegrityError"
    "managedObjectValidation"
    "managedObjectValidationError"
    "manager"
    "mandarinToLatin"
    "mapItem"
    "mappedIfSafe"
    "mappedRead"
    "markedClauseSegment"
    "matchFirst"
    "matchLast"
    "matchNextTime"
    "matchNextTimePreservingSmallerUnits"
    "matchPreviousTimePreservingSmallerUnits"
    "matchStrictly"
    "maxConcurrentOperationCount"
    "maximum"
    "maximumAge"
    "maximumFractionDigits"
    "maximumIntegerDigits"
    "maximumKeyValueOperator"
    "maximumMessageSize"
    "maximumSignificantDigits"
    "maximumUnitCount"
    "measurementSystem"
    "mebibits"
    "mebibytes"
    "mediaServicesWereLostNotification"
    "mediaServicesWereResetNotification"
    "megaampereHours"
    "megaamperes"
    "megabits"
    "megabytes"
    "megahertz"
    "megaliters"
    "megameters"
    "megaohms"
    "megapascals"
    "megavolts"
    "megawatts"
    "memoryCapacity"
    "memoryDataMoved"
    "memoryError"
    "memoryFailure"
    "memoryPresent"
    "memoryRestartCopy"
    "menuFrameDidChangeNotification"
    "meters"
    "metersPerSecond"
    "metersPerSecondSquared"
    "metricCups"
    "metricTons"
    "microampereHours"
    "microamperes"
    "micrograms"
    "microhertz"
    "micrometers"
    "microohms"
    "microseconds"
    "microvolts"
    "microwatts"
    "middleName"
    "migration"
    "migrationCancelled"
    "migrationCancelledError"
    "migrationError"
    "migrationManagerDestinationStore"
    "migrationManagerDestinationStoreError"
    "migrationManagerSourceStore"
    "migrationManagerSourceStoreError"
    "migrationMissingMappingModel"
    "migrationMissingMappingModelError"
    "migrationMissingSourceModel"
    "migrationMissingSourceModelError"
    "miles"
    "milesPerGallon"
    "milesPerHour"
    "milesPerImperialGallon"
    "milliampereHours"
    "milliamperes"
    "millibars"
    "milligrams"
    "milligramsPerDeciliter"
    "millihertz"
    "milliliters"
    "millimeters"
    "millimetersOfMercury"
    "milliohms"
    "milliseconds"
    "millivolts"
    "milliwatts"
    "mimeType"
    "minimalBookmark"
    "minimum"
    "minimumDaysInFirstWeek"
    "minimumFractionDigits"
    "minimumIntegerDigits"
    "minimumKeyValueOperator"
    "minimumSignificantDigits"
    "minimumTolerance"
    "minorVersion"
    "minusSign"
    "minute"
    "minutes"
    "mkCoordinateSpanValue"
    "mkCoordinateValue"
    "modalPanel"
    "mode"
    "modeDidChangeNotification"
    "modificationDate"
    "modificationTime"
    "monoAudioStatusDidChangeNotification"
    "month"
    "monthSymbols"
    "moved"
    "msgid"
    "multipathServiceType"
    "multiplier"
    "mutableBytes"
    "mutableContainers"
    "mutableContainersAndLeaves"
    "mutableLeaves"
    "mutableString"
    "mutationsPtr"
    "name"
    "nameExists"
    "nameKey"
    "namePrefix"
    "nameSuffix"
    "nameType"
    "nameTypeOrLexicalClass"
    "namedPipe"
    "names"
    "namespaces"
    "nan"
    "nanograms"
    "nanohertz"
    "nanometers"
    "nanosecond"
    "nanoseconds"
    "nanowatts"
    "naturalScale"
    "nauticalMiles"
    "ndefMessagePayload"
    "needsSave"
    "negateBooleanTransformerName"
    "negativeFormat"
    "negativeInfinitySymbol"
    "negativePrefix"
    "negativeSuffix"
    "negotiatedSSL"
    "negotiatedTLSCipherSuite"
    "negotiatedTLSProtocolVersion"
    "networkConnectionLost"
    "networkDomainMask"
    "networkProtocolName"
    "networkServiceType"
    "networkUnavailableReason"
    "neverInteract"
    "new"
    "newKey"
    "newValue"
    "newlines"
    "newsstandAssetDownload"
    "newtonsPerMetersSquared"
    "next"
    "nextDaylightSavingTimeTransition"
    "nextDown"
    "nextSibling"
    "nextUp"
    "nibLoadingException"
    "nibbles"
    "nickname"
    "nilSymbol"
    "noAccess"
    "noAutoRename"
    "noCloudAccountNotification"
    "noFileProtection"
    "noPermissionsToReadFile"
    "noReply"
    "noSpace"
    "nodeCompactEmptyElement"
    "nodeDown"
    "nodeExpandEmptyElement"
    "nodeIsCDATA"
    "nodeLoadExternalEntitiesAlways"
    "nodeLoadExternalEntitiesNever"
    "nodeLoadExternalEntitiesSameOriginOnly"
    "nodeNeverEscapeContents"
    "nodePreserveAll"
    "nodePreserveAttributeOrder"
    "nodePreserveCDATA"
    "nodePreserveCharacterReferences"
    "nodePreserveDTD"
    "nodePreserveEmptyElements"
    "nodePreserveEntities"
    "nodePreserveNamespaceOrder"
    "nodePreservePrefixes"
    "nodePreserveQuotes"
    "nodePreserveWhitespace"
    "nodePrettyPrint"
    "nodePromoteSignificantWhitespace"
    "nodeUseDoubleQuotes"
    "nodeUseSingleQuotes"
    "nonBaseCharacters"
    "nonConformingFloatDecodingStrategy"
    "nonConformingFloatEncodingStrategy"
    "none"
    "nonretainedObjectValue"
    "normalized"
    "notAKeyMarker"
    "notANumber"
    "notANumberSymbol"
    "notConnectedToInternet"
    "notDepressed"
    "notDownloaded"
    "notInSet"
    "notReceiver"
    "notSupported"
    "notWaiting"
    "notationName"
    "notificationActions"
    "notificationBatchingInterval"
    "notificationIsPriorKey"
    "noun"
    "now"
    "nullDevice"
    "number"
    "numberFormatter"
    "numberOfCaptureGroups"
    "numberOfItems"
    "numberOfRanges"
    "numberStyle"
    "numeric"
    "objCType"
    "object"
    "objectBeingTested"
    "objectInaccessibleException"
    "objectNotAvailableException"
    "objectPersonality"
    "objectPointerPersonality"
    "objectSpecifier"
    "objectValue"
    "objectsByEvaluatingSpecifier"
    "obliqueness"
    "observationInfo"
    "observedPresentedItemUbiquityAttributes"
    "officeOpenXML"
    "offsetInFile"
    "ohms"
    "old"
    "oldKey"
    "oldStyleException"
    "oldValue"
    "omitInsertedObjects"
    "omitOther"
    "omitPunctuation"
    "omitRemovedObjects"
    "omitWhitespace"
    "omitWords"
    "onName"
    "onSender"
    "one"
    "oneShot"
    "opaqueMemory"
    "opaquePersonality"
    "openCompleted"
    "openDocument"
    "openInPlace"
    "openParenthesis"
    "openQuote"
    "operand"
    "operatingSystemVersion"
    "operatingSystemVersionString"
    "operationCount"
    "operationQueue"
    "operationTimedOut"
    "operations"
    "options"
    "organization"
    "organizationName"
    "orientation"
    "orientationDidChangeNotification"
    "originURL"
    "originalRequest"
    "originatorNameComponents"
    "orthography"
    "other"
    "otherButtonTitle"
    "otherPunctuation"
    "otherWhitespace"
    "otherWord"
    "ounces"
    "ouncesTroy"
    "outputFormat"
    "outputFormatting"
    "owner"
    "ownerAccountID"
    "ownerAccountName"
    "pad"
    "paddingCharacter"
    "paddingPosition"
    "paperMargin"
    "paperSize"
    "paragraphBreak"
    "paragraphStyle"
    "parameterString"
    "parent"
    "parentDirectory"
    "parentDirectoryURLKey"
    "parseErrorException"
    "parsecs"
    "parserError"
    "participant"
    "particle"
    "partsPerMillion"
    "password"
    "passwordKey"
    "pasteboardCommunicationException"
    "patchVersion"
    "path"
    "pathComponents"
    "pathExtension"
    "pathKey"
    "pattern"
    "pausingHandler"
    "pebibits"
    "pebibytes"
    "perMillSymbol"
    "percentEncodedFragment"
    "percentEncodedHost"
    "percentEncodedPassword"
    "percentEncodedPath"
    "percentEncodedQuery"
    "percentEncodedQueryItems"
    "percentEncodedUser"
    "percentSymbol"
    "persian"
    "persistence"
    "persistentIdentifier"
    "persistentStoreCoordinatorLocking"
    "persistentStoreCoordinatorLockingError"
    "persistentStoreIncompatibleSchema"
    "persistentStoreIncompatibleSchemaError"
    "persistentStoreIncompatibleVersionHash"
    "persistentStoreIncompatibleVersionHashError"
    "persistentStoreIncompleteSave"
    "persistentStoreIncompleteSaveError"
    "persistentStoreInvalidType"
    "persistentStoreInvalidTypeError"
    "persistentStoreOpen"
    "persistentStoreOpenError"
    "persistentStoreOperation"
    "persistentStoreOperationError"
    "persistentStoreSave"
    "persistentStoreSaveConflicts"
    "persistentStoreSaveConflictsError"
    "persistentStoreSaveError"
    "persistentStoreTimeout"
    "persistentStoreTimeoutError"
    "persistentStoreTypeMismatch"
    "persistentStoreTypeMismatchError"
    "persistentStoreUnsupportedRequestType"
    "persistentStoreUnsupportedRequestTypeError"
    "personalName"
    "petabits"
    "petabytes"
    "phone"
    "phoneNumber"
    "phonetic"
    "phoneticRepresentation"
    "physicalMemory"
    "pi"
    "picograms"
    "picometers"
    "picoseconds"
    "picowatts"
    "pints"
    "placeName"
    "plain"
    "playgroundPageExecutionModeDidChange"
    "plusSign"
    "pmSymbol"
    "pointValue"
    "pointerFunctions"
    "pointerValue"
    "policyLimit"
    "policyStatic"
    "port"
    "portKey"
    "portList"
    "portReceiveException"
    "portSendException"
    "portTimeoutException"
    "position"
    "positiveFormat"
    "positiveInfinitySymbol"
    "positivePrefix"
    "positiveSuffix"
    "posixPermissions"
    "postToAllSessions"
    "pounds"
    "poundsForcePerSquareInch"
    "precomposedStringWithCanonicalMapping"
    "precomposedStringWithCompatibilityMapping"
    "predicate"
    "predicateFormat"
    "predicateOperatorType"
    "preferFileIDResolution"
    "preferredFilename"
    "preferredIOBlockSize"
    "preferredIOBlockSizeKey"
    "preferredLanguages"
    "preferredLocalizations"
    "preferredPresentationSize"
    "preferredPresentationStyle"
    "preferredScrollerStyleDidChangeNotification"
    "prefix"
    "prefixSpaces"
    "preposition"
    "presentedItemOperationQueue"
    "presentedItemURL"
    "prettyPrinted"
    "previewImageHandler"
    "previous"
    "previousFailureCount"
    "previousSibling"
    "primaryPresentedItemURL"
    "principalClass"
    "printOperationExistsException"
    "printPackageException"
    "printingCommunicationException"
    "prior"
    "priority"
    "privateFrameworksPath"
    "privateFrameworksURL"
    "privileged"
    "processIdentifier"
    "processInfo"
    "processName"
    "processorCount"
    "produceFileReferenceURLs"
    "producesRelativePathURLs"
    "progress"
    "progressMarkNotification"
    "pronoun"
    "properties"
    "propertyListReadCorrupt"
    "propertyListReadCorruptError"
    "propertyListReadStream"
    "propertyListReadStreamError"
    "propertyListReadUnknownVersion"
    "propertyListReadUnknownVersionError"
    "propertyListWriteInvalid"
    "propertyListWriteInvalidError"
    "propertyListWriteStream"
    "propertyListWriteStreamError"
    "proposedCredential"
    "protectedDataDidBecomeAvailableNotification"
    "protectedDataWillBecomeUnavailableNotification"
    "protectionFailure"
    "protectionKey"
    "protectionSpace"
    "protocol"
    "protocolClasses"
    "protocolFamily"
    "providedUnit"
    "proximityStateDidChangeNotification"
    "proxyType"
    "publicID"
    "publisher"
    "punctuation"
    "punctuationCharacters"
    "purposeIdentifier"
    "qualityOfService"
    "quarantineProperties"
    "quarantinePropertiesKey"
    "quarter"
    "quarterSymbols"
    "quarts"
    "quartzFilterManagerDidAddFilter"
    "quartzFilterManagerDidModifyFilter"
    "quartzFilterManagerDidRemoveFilter"
    "quartzFilterManagerDidSelectFilter"
    "query"
    "queryItems"
    "queuePriority"
    "queueReply"
    "quietNaN"
    "quotationBeginDelimiter"
    "quotationBeginDelimiterKey"
    "quotationEndDelimiter"
    "quotationEndDelimiterKey"
    "quote"
    "radians"
    "radix"
    "range"
    "rangeContainerObject"
    "rangeException"
    "rangeOfFragment"
    "rangeOfHost"
    "rangeOfPassword"
    "rangeOfPath"
    "rangeOfPort"
    "rangeOfQuery"
    "rangeOfScheme"
    "rangeOfUser"
    "rangeValue"
    "rangeView"
    "rawValue"
    "readAccessURL"
    "readCompletionNotification"
    "readOnly"
    "readWrite"
    "readabilityHandler"
    "readableTypeIdentifiersForItemProvider"
    "realm"
    "reason"
    "receivePort"
    "receiversSpecifier"
    "receivesCredentialSecurely"
    "receiving"
    "recoveryAttempter"
    "recoveryAttempterErrorKey"
    "recoveryOptions"
    "recoverySuggestion"
    "rectValue"
    "redirectCount"
    "redirectToNonExistentLocation"
    "redoActionIsDiscardable"
    "redoActionName"
    "redoMenuItemTitle"
    "reduceMotionStatusDidChangeNotification"
    "reduceTransparencyStatusDidChangeNotification"
    "referenceCount"
    "referenceDate"
    "referrerURL"
    "regionCode"
    "regions"
    "registeredTypeIdentifiers"
    "registrationDomain"
    "registryDidChangeNotification"
    "regular"
    "regularExpression"
    "regularFileContents"
    "relativePath"
    "relativePosition"
    "relativeString"
    "release"
    "relinquishFunction"
    "reloadIgnoringCacheData"
    "remoteAddress"
    "remoteObjectInterface"
    "remoteObjectProxy"
    "remotePort"
    "removals"
    "removedNotification"
    "removingPercentEncoding"
    "repeats"
    "replacement"
    "replacementString"
    "reportCompletion"
    "reportProgress"
    "republicOfChina"
    "request"
    "requestBodyStreamExhausted"
    "requestCachePolicy"
    "requestEndDate"
    "requestStartDate"
    "requiredEnd"
    "requiredUserInfoKeys"
    "requiresSecureCoding"
    "reservedSpaceLength"
    "resized"
    "resolvedKeyDictionary"
    "resolvesSymbolicLink"
    "resolvingSymlinksInPath"
    "resourceFetchType"
    "resourcePath"
    "resourceShortage"
    "resourceSpecifier"
    "resourceURL"
    "resourceUnavailable"
    "response"
    "responseEndDate"
    "responsePlaceholder"
    "responseStartDate"
    "resultCount"
    "resultType"
    "results"
    "resumeData"
    "resumingHandler"
    "retain"
    "returnID"
    "returnType"
    "reverse"
    "reversed"
    "reversedSortDescriptor"
    "revolutions"
    "richTextSource"
    "right"
    "rightExists"
    "rightExpression"
    "rightMargin"
    "rootDocument"
    "roundingBehavior"
    "roundingIncrement"
    "roundingMode"
    "routeChangeNotification"
    "row"
    "rowCollapsed"
    "rowCountChanged"
    "rowExpanded"
    "rowsDidChangeNotification"
    "rpcContinueOrphan"
    "rpcServerTerminated"
    "rpcTerminateOrphan"
    "rtf"
    "rtfd"
    "runLoop"
    "runLoopModes"
    "sameSiteLax"
    "sameSitePolicy"
    "sameSiteStrict"
    "saveOptions"
    "scanLocation"
    "scandinavianMiles"
    "scheduledNotifications"
    "scheme"
    "scnMatrix4Value"
    "scnVector3Value"
    "scnVector4Value"
    "screensDidSleepNotification"
    "screensDidWakeNotification"
    "script"
    "scriptCode"
    "scriptErrorExpectedTypeDescriptor"
    "scriptErrorNumber"
    "scriptErrorOffendingObjectDescriptor"
    "scriptErrorString"
    "scriptURL"
    "searchBackwards"
    "searchItems"
    "searchScopes"
    "second"
    "secondaryGroupingSize"
    "seconds"
    "secondsFromGMT"
    "section"
    "secure"
    "secureConnectionEndDate"
    "secureConnectionFailed"
    "secureConnectionStartDate"
    "secureUnarchiveFromDataTransformerName"
    "securityScopeAllowOnlyReadAccess"
    "selectedAlternativeStringNotification"
    "selectedCellsChanged"
    "selectedChildrenChanged"
    "selectedChildrenMoved"
    "selectedColumnsChanged"
    "selectedRowsChanged"
    "selectedTextChanged"
    "selectionDidChangeNotification"
    "selectionIsChangingNotification"
    "selector"
    "semaphoreDestroyed"
    "sendPort"
    "sender"
    "sentenceTerminator"
    "serializedRepresentation"
    "serverCertificateHasBadDate"
    "serverCertificateHasUnknownRoot"
    "serverCertificateNotYetValid"
    "serverCertificateUntrusted"
    "serverTrust"
    "serviceApplicationLaunchFailed"
    "serviceApplicationLaunchFailedError"
    "serviceApplicationNotFound"
    "serviceApplicationNotFoundError"
    "serviceInvalidPasteboardData"
    "serviceInvalidPasteboardDataError"
    "serviceMalformedServiceDictionary"
    "serviceMalformedServiceDictionaryError"
    "serviceMiscellaneous"
    "serviceMiscellaneousError"
    "serviceName"
    "serviceRequestTimedOut"
    "serviceRequestTimedOutError"
    "session"
    "sessionDescription"
    "sessionDidBecomeActiveNotification"
    "sessionDidResignActiveNotification"
    "sessionSendsLaunchEvents"
    "set"
    "setRepresentation"
    "shadow"
    "shakeToUndoDidChangeNotification"
    "shared"
    "sharedContainerIdentifier"
    "sharedFrameworksPath"
    "sharedFrameworksURL"
    "sharedSupportPath"
    "sharedSupportURL"
    "sharingServiceNotConfigured"
    "sharingServiceNotConfiguredError"
    "sheetCreated"
    "shortMonthSymbols"
    "shortQuarterSymbols"
    "shortStandaloneMonthSymbols"
    "shortStandaloneQuarterSymbols"
    "shortStandaloneWeekdaySymbols"
    "shortTons"
    "shortWeekdaySymbols"
    "shouldDefer"
    "shouldProcessNamespaces"
    "shouldReportNamespacePrefixes"
    "shouldResolveExternalEntities"
    "shouldUseExtendedBackgroundIdleMode"
    "showDetailTargetDidChangeNotification"
    "sign"
    "significand"
    "significantTimeChangeNotification"
    "silenceSecondaryAudioHintNotification"
    "size"
    "sizeFunction"
    "sizeLimitExceededNotification"
    "sizeValue"
    "skipHiddenVolumes"
    "skipsHiddenFiles"
    "skipsPackageDescendants"
    "skipsSubdirectoryDescendants"
    "slugs"
    "smallestEncoding"
    "socket"
    "socketSecurityLevelKey"
    "socketType"
    "socksProxyConfigurationKey"
    "sortDescriptors"
    "sortedArrayHint"
    "sortedKeys"
    "soundName"
    "source"
    "sourceFrame"
    "sourceTextScaling"
    "speakScreenStatusDidChangeNotification"
    "speakSelectionStatusDidChangeNotification"
    "spelling"
    "spellingState"
    "sqlite"
    "sqliteError"
    "squareCentimeters"
    "squareFeet"
    "squareInches"
    "squareKilometers"
    "squareMegameters"
    "squareMeters"
    "squareMicrometers"
    "squareMiles"
    "squareMillimeters"
    "squareNanometers"
    "squareYards"
    "ssLv2"
    "ssLv3"
    "stable"
    "stackSize"
    "standaloneMonthSymbols"
    "standaloneQuarterSymbols"
    "standaloneWeekdaySymbols"
    "standard"
    "standardError"
    "standardInput"
    "standardOutput"
    "standardized"
    "standardizedFileURL"
    "standardizingPath"
    "start"
    "startDate"
    "startIndex"
    "startSpecifier"
    "startSubelementIdentifier"
    "startSubelementIndex"
    "state"
    "stateChangedNotification"
    "statusCode"
    "stones"
    "storagePolicy"
    "streamError"
    "streamStatus"
    "street"
    "strikethroughColor"
    "strikethroughStyle"
    "string"
    "stringEncoding"
    "stringEncodingErrorKey"
    "stringValue"
    "stripCombiningMarks"
    "stripDiacritics"
    "strokeColor"
    "strokeWidth"
    "strongMemory"
    "structPersonality"
    "style"
    "subgroups"
    "subject"
    "subpredicates"
    "substringNotRequired"
    "subtitle"
    "success"
    "suddenTerminationDisabled"
    "suggestedEncodingsKey"
    "suggestedFilename"
    "suggestedInvocationPhrase"
    "suggestedName"
    "suitableForBookmarkFile"
    "suiteName"
    "suiteNames"
    "sumKeyValueOperator"
    "superclass"
    "superscript"
    "supportsContinuationStreams"
    "supportsSecureCoding"
    "suspended"
    "switchControlStatusDidChangeNotification"
    "symbol"
    "symbolicLink"
    "symbolicLinkDestinationURL"
    "symbols"
    "system"
    "systemColorsDidChangeNotification"
    "systemDomainMask"
    "systemFileNumber"
    "systemFreeNodes"
    "systemFreeSize"
    "systemID"
    "systemNodes"
    "systemNumber"
    "systemSize"
    "systemUptime"
    "systemVersion"
    "tX"
    "tY"
    "tablespoons"
    "tagNames"
    "tagNamesKey"
    "tagSchemes"
    "tags"
    "target"
    "targetContentIdentifier"
    "targetTextScaling"
    "task"
    "taskDescription"
    "taskIdentifier"
    "taskInterval"
    "teamData"
    "teaspoons"
    "tebibits"
    "tebibytes"
    "temperatureWithoutUnit"
    "temporaryDirectory"
    "terabits"
    "terabytes"
    "terahertz"
    "terawatts"
    "terminated"
    "terminationHandler"
    "terminationReason"
    "terminationStatus"
    "test"
    "textAlternatives"
    "textAttributesForNegativeInfinity"
    "textAttributesForNegativeValues"
    "textAttributesForNil"
    "textAttributesForNotANumber"
    "textAttributesForPositiveInfinity"
    "textAttributesForPositiveValues"
    "textAttributesForZero"
    "textDidBeginEditingNotification"
    "textDidChangeNotification"
    "textDidEndEditingNotification"
    "textEffect"
    "textEncodingName"
    "textLayoutSections"
    "textLineTooLongException"
    "textNoSelectionException"
    "textReadException"
    "textReadInapplicableDocumentType"
    "textReadInapplicableDocumentTypeError"
    "textScaling"
    "textSizeMultiplier"
    "textTypes"
    "textUnfilteredTypes"
    "textWriteException"
    "textWriteInapplicableDocumentType"
    "textWriteInapplicableDocumentTypeError"
    "thermalState"
    "thermalStateDidChangeNotification"
    "thousandSeparator"
    "threadDictionary"
    "threadPriority"
    "throughput"
    "throughputKey"
    "thumbnail"
    "thumbnailDictionary"
    "thumbnailDictionaryKey"
    "thumbnailKey"
    "timeInterval"
    "timeIntervalBetween1970AndReferenceDate"
    "timeIntervalSince1970"
    "timeIntervalSinceNow"
    "timeIntervalSinceReferenceDate"
    "timeMappingValue"
    "timeRangeValue"
    "timeStyle"
    "timeValue"
    "timeZone"
    "timeZoneDataVersion"
    "timedOut"
    "timeout"
    "timeoutInterval"
    "timeoutIntervalForRequest"
    "timeoutIntervalForResource"
    "title"
    "titleChanged"
    "tlSv1"
    "tlsMaximumSupportedProtocol"
    "tlsMaximumSupportedProtocolVersion"
    "tlsMinimumSupportedProtocol"
    "tlsMinimumSupportedProtocolVersion"
    "toLatin"
    "toManyRelationshipKeys"
    "toOneRelationshipKeys"
    "toUnicodeName"
    "toXMLHex"
    "tokenType"
    "tolerance"
    "toolTip"
    "top"
    "topLevelObject"
    "topMargin"
    "totalCostLimit"
    "totalFileAllocatedSize"
    "totalFileAllocatedSizeKey"
    "totalFileSize"
    "totalFileSizeKey"
    "totalUnitCount"
    "tracking"
    "transactionID"
    "transactionMetrics"
    "transformStruct"
    "transitInformation"
    "true"
    "truncatesLastVisibleLine"
    "twoDigitStartDate"
    "type"
    "typeBlockSpecial"
    "typeCharacterSpecial"
    "typeCodeValue"
    "typeDirectory"
    "typeIdentifier"
    "typeIdentifierKey"
    "typeRegular"
    "typeSocket"
    "typeSymbolicLink"
    "typeUnknown"
    "typedStreamVersionException"
    "ubiquitousFileNotUploadedDueToQuota"
    "ubiquitousFileNotUploadedDueToQuotaError"
    "ubiquitousFileUbiquityServerNotAvailable"
    "ubiquitousFileUnavailable"
    "ubiquitousFileUnavailableError"
    "ubiquitousItemContainerDisplayName"
    "ubiquitousItemContainerDisplayNameKey"
    "ubiquitousItemDownloadRequested"
    "ubiquitousItemDownloadRequestedKey"
    "ubiquitousItemDownloadingError"
    "ubiquitousItemDownloadingErrorKey"
    "ubiquitousItemDownloadingStatus"
    "ubiquitousItemDownloadingStatusKey"
    "ubiquitousItemHasUnresolvedConflicts"
    "ubiquitousItemHasUnresolvedConflictsKey"
    "ubiquitousItemIsDownloadedKey"
    "ubiquitousItemIsDownloading"
    "ubiquitousItemIsDownloadingKey"
    "ubiquitousItemIsShared"
    "ubiquitousItemIsSharedKey"
    "ubiquitousItemIsUploaded"
    "ubiquitousItemIsUploadedKey"
    "ubiquitousItemIsUploading"
    "ubiquitousItemIsUploadingKey"
    "ubiquitousItemPercentDownloadedKey"
    "ubiquitousItemPercentUploadedKey"
    "ubiquitousItemUploadingError"
    "ubiquitousItemUploadingErrorKey"
    "ubiquitousSharedItemCurrentUserPermissions"
    "ubiquitousSharedItemCurrentUserPermissionsKey"
    "ubiquitousSharedItemCurrentUserRole"
    "ubiquitousSharedItemCurrentUserRoleKey"
    "ubiquitousSharedItemMostRecentEditorNameComponents"
    "ubiquitousSharedItemMostRecentEditorNameComponentsKey"
    "ubiquitousSharedItemOwnerNameComponents"
    "ubiquitousSharedItemOwnerNameComponentsKey"
    "ubiquityIdentityToken"
    "uiEdgeInsetsValue"
    "uiElementDestroyed"
    "uiOffsetValue"
    "uint16Value"
    "uint32Value"
    "uint64Value"
    "uint8Value"
    "uintValue"
    "ulp"
    "unarchiveFromDataTransformerName"
    "uncached"
    "uncachedRead"
    "undefinedKeyException"
    "underestimatedCount"
    "underlineColor"
    "underlineStyle"
    "underlying"
    "underlyingErrorKey"
    "underlyingQueue"
    "undoActionIsDiscardable"
    "undoActionName"
    "undoMenuItemTitle"
    "unionOfArraysKeyValueOperator"
    "unionOfObjectsKeyValueOperator"
    "unionOfSetsKeyValueOperator"
    "uniqueID"
    "unit"
    "unitOptions"
    "unitStyle"
    "unitsChanged"
    "unitsStyle"
    "unknown"
    "unsupportedURL"
    "uppercaseLetters"
    "uppercased"
    "uri"
    "url"
    "urlCache"
    "urlCredentialStorage"
    "urlFragmentAllowed"
    "urlHostAllowed"
    "urlPasswordAllowed"
    "urlPathAllowed"
    "urlQueryAllowed"
    "urlUserAllowed"
    "useAll"
    "useBytes"
    "useEB"
    "useGB"
    "useKB"
    "useMB"
    "useOnlySuggestedEncodingsKey"
    "usePB"
    "useTB"
    "useUnicodeWordBoundaries"
    "useUnixLineSeparators"
    "useYBOrHigher"
    "useZB"
    "user"
    "userActivityConnectionUnavailable"
    "userActivityConnectionUnavailableError"
    "userActivityHandoffFailed"
    "userActivityHandoffFailedError"
    "userActivityHandoffUserInfoTooLarge"
    "userActivityHandoffUserInfoTooLargeError"
    "userActivityRemoteApplicationTimedOut"
    "userActivityRemoteApplicationTimedOutError"
    "userAuthenticationRequired"
    "userCancelled"
    "userCancelledAuthentication"
    "userCancelledError"
    "userDidTakeScreenshotNotification"
    "userDomainMask"
    "userInfo"
    "userInitiated"
    "userInitiatedAllowingIdleSystemSleep"
    "userKey"
    "userName"
    "userReferencesOverflow"
    "usesDeviceMetrics"
    "usesFontLeading"
    "usesGroupingSeparator"
    "usesLineFragmentOrigin"
    "usesMetricSystem"
    "usesScreenFontsDocumentAttribute"
    "usesSignificantDigits"
    "usesStrongWriteBarrier"
    "usesWeakReadAndWriteBarriers"
    "usingNewMetadataOnly"
    "utf8String"
    "uuid"
    "uuidString"
    "v"
    "validationDateTooLate"
    "validationDateTooLateError"
    "validationDateTooSoon"
    "validationDateTooSoonError"
    "validationInvalidDate"
    "validationInvalidDateError"
    "validationKey"
    "validationMissingMandatoryProperty"
    "validationMissingMandatoryPropertyError"
    "validationMultipleErrors"
    "validationMultipleErrorsError"
    "validationNumberTooLarge"
    "validationNumberTooLargeError"
    "validationNumberTooSmall"
    "validationNumberTooSmallError"
    "validationObject"
    "validationPredicate"
    "validationRelationshipDeniedDelete"
    "validationRelationshipDeniedDeleteError"
    "validationRelationshipExceedsMaximumCount"
    "validationRelationshipExceedsMaximumCountError"
    "validationRelationshipLacksMinimumCount"
    "validationRelationshipLacksMinimumCountError"
    "validationStringPatternMatching"
    "validationStringPatternMatchingError"
    "validationStringTooLong"
    "validationStringTooLongError"
    "validationStringTooShort"
    "validationStringTooShortError"
    "validationValue"
    "value"
    "valueChanged"
    "valueListAttributes"
    "valueLists"
    "valuePointerFunctions"
    "variable"
    "variables"
    "variantCode"
    "verb"
    "version"
    "version4"
    "version5"
    "versionKey"
    "verticalGlyphForm"
    "veryShortMonthSymbols"
    "veryShortStandaloneMonthSymbols"
    "veryShortStandaloneWeekdaySymbols"
    "veryShortWeekdaySymbols"
    "video"
    "viewMode"
    "viewSize"
    "viewZoom"
    "voIP"
    "voice"
    "volatileDomainNames"
    "volts"
    "volume"
    "volumeAvailableCapacity"
    "volumeAvailableCapacityForImportantUsage"
    "volumeAvailableCapacityForImportantUsageKey"
    "volumeAvailableCapacityForOpportunisticUsage"
    "volumeAvailableCapacityForOpportunisticUsageKey"
    "volumeAvailableCapacityKey"
    "volumeCreationDate"
    "volumeCreationDateKey"
    "volumeIdentifier"
    "volumeIdentifierKey"
    "volumeIsAutomounted"
    "volumeIsAutomountedKey"
    "volumeIsBrowsable"
    "volumeIsBrowsableKey"
    "volumeIsEjectable"
    "volumeIsEjectableKey"
    "volumeIsEncrypted"
    "volumeIsEncryptedKey"
    "volumeIsInternal"
    "volumeIsInternalKey"
    "volumeIsJournaling"
    "volumeIsJournalingKey"
    "volumeIsLocal"
    "volumeIsLocalKey"
    "volumeIsReadOnly"
    "volumeIsReadOnlyKey"
    "volumeIsRemovable"
    "volumeIsRemovableKey"
    "volumeIsRootFileSystem"
    "volumeIsRootFileSystemKey"
    "volumeLocalizedFormatDescription"
    "volumeLocalizedFormatDescriptionKey"
    "volumeLocalizedName"
    "volumeLocalizedNameKey"
    "volumeMaximumFileSize"
    "volumeMaximumFileSizeKey"
    "volumeName"
    "volumeNameKey"
    "volumeResourceCount"
    "volumeResourceCountKey"
    "volumeSupportsAccessPermissions"
    "volumeSupportsAccessPermissionsKey"
    "volumeSupportsAdvisoryFileLocking"
    "volumeSupportsAdvisoryFileLockingKey"
    "volumeSupportsCasePreservedNames"
    "volumeSupportsCasePreservedNamesKey"
    "volumeSupportsCaseSensitiveNames"
    "volumeSupportsCaseSensitiveNamesKey"
    "volumeSupportsCompression"
    "volumeSupportsCompressionKey"
    "volumeSupportsExclusiveRenaming"
    "volumeSupportsExclusiveRenamingKey"
    "volumeSupportsExtendedSecurity"
    "volumeSupportsExtendedSecurityKey"
    "volumeSupportsFileCloning"
    "volumeSupportsFileCloningKey"
    "volumeSupportsHardLinks"
    "volumeSupportsHardLinksKey"
    "volumeSupportsImmutableFiles"
    "volumeSupportsImmutableFilesKey"
    "volumeSupportsJournaling"
    "volumeSupportsJournalingKey"
    "volumeSupportsPersistentIDs"
    "volumeSupportsPersistentIDsKey"
    "volumeSupportsRenaming"
    "volumeSupportsRenamingKey"
    "volumeSupportsRootDirectoryDates"
    "volumeSupportsRootDirectoryDatesKey"
    "volumeSupportsSparseFiles"
    "volumeSupportsSparseFilesKey"
    "volumeSupportsSwapRenaming"
    "volumeSupportsSwapRenamingKey"
    "volumeSupportsSymbolicLinks"
    "volumeSupportsSymbolicLinksKey"
    "volumeSupportsVolumeSizes"
    "volumeSupportsVolumeSizesKey"
    "volumeSupportsZeroRuns"
    "volumeSupportsZeroRunsKey"
    "volumeTotalCapacity"
    "volumeTotalCapacityKey"
    "volumeURLForRemounting"
    "volumeURLForRemountingKey"
    "volumeURLKey"
    "volumeUUIDString"
    "volumeUUIDStringKey"
    "waitForReply"
    "waitsForConnectivity"
    "watts"
    "weakMemory"
    "webArchive"
    "webPreferences"
    "webResourceLoadDelegate"
    "webpageURL"
    "weekOfMonth"
    "weekOfYear"
    "weekday"
    "weekdayOrdinal"
    "weekdaySymbols"
    "whitespace"
    "whitespaces"
    "whitespacesAndNewlines"
    "widgetActiveDisplayMode"
    "widgetLargestAvailableDisplayMode"
    "widthInsensitive"
    "willAddItemNotification"
    "willBecomeActiveNotification"
    "willBeginSheetNotification"
    "willChangeNotifyingTextViewNotification"
    "willChangeStatusBarFrameNotification"
    "willChangeStatusBarOrientationNotification"
    "willCloseNotification"
    "willDismissNotification"
    "willEnterForegroundNotification"
    "willEnterFullScreenNotification"
    "willEnterVersionBrowserNotification"
    "willExitFullScreenNotification"
    "willExitVersionBrowserNotification"
    "willFinishLaunchingNotification"
    "willHideMenuNotification"
    "willHideNotification"
    "willLaunchApplicationNotification"
    "willMiniaturizeNotification"
    "willMoveNotification"
    "willOpenNotification"
    "willPopUpNotification"
    "willPowerOffNotification"
    "willProcessEditingNotification"
    "willResignActiveNotification"
    "willResizeSubviewsNotification"
    "willSendActionNotification"
    "willShowMenuNotification"
    "willShowNotification"
    "willSleepNotification"
    "willStartLiveMagnifyNotification"
    "willStartLiveResizeNotification"
    "willStartLiveScrollNotification"
    "willTerminateNotification"
    "willUnhideNotification"
    "willUnmountNotification"
    "willUpdateNotification"
    "windowCreated"
    "windowDeminiaturized"
    "windowMiniaturized"
    "windowMoved"
    "windowResized"
    "windowServerCommunicationException"
    "withColonSeparatorInTime"
    "withColonSeparatorInTimeZone"
    "withDashSeparatorInDate"
    "withDay"
    "withFractionalSeconds"
    "withFullDate"
    "withFullTime"
    "withInternetDateTime"
    "withMonth"
    "withNameUpdating"
    "withSecurityScope"
    "withSpaceBetweenDateAndTime"
    "withTime"
    "withTimeZone"
    "withTransparentBounds"
    "withWeekOfYear"
    "withYear"
    "withoutAnchoringBounds"
    "withoutChanges"
    "withoutDeletingBackupItem"
    "withoutEscapingSlashes"
    "withoutMapping"
    "withoutMounting"
    "withoutOverwriting"
    "withoutUI"
    "word"
    "wordJoiner"
    "wordML"
    "wordTablesReadException"
    "wordTablesWriteException"
    "wrapComponents"
    "writableTypeIdentifiersForItemProvider"
    "writeabilityHandler"
    "writingDirection"
    "xPath"
    "xmlData"
    "xmlString"
    "xpcConnectionInterrupted"
    "xpcConnectionInvalid"
    "xpcConnectionReplyInvalid"
    "yards"
    "year"
    "yearForWeekOfYear"
    "yobibits"
    "yobibytes"
    "yottabits"
    "yottabytes"
    "zebibits"
    "zebibytes"
    "zero"
    "zeroByteResource"
    "zeroFormattingBehavior"
    "zeroPadsFractionDigits"
    "zeroSymbol"
    "zettabits"
    "zettabytes"
    "zip")
  "Foundation properties.")

(defconst swift-mode:foundation-functions
  '("CFBridgingRetain"
    "NSAllHashTableObjects"
    "NSAllMapTableKeys"
    "NSAllMapTableValues"
    "NSAllocateMemoryPages"
    "NSClassFromString"
    "NSCompareHashTables"
    "NSCompareMapTables"
    "NSConvertHostDoubleToSwapped"
    "NSConvertHostFloatToSwapped"
    "NSConvertSwappedDoubleToHost"
    "NSConvertSwappedFloatToHost"
    "NSCopyHashTableWithZone"
    "NSCopyMapTableWithZone"
    "NSCopyMemoryPages"
    "NSCountHashTable"
    "NSCountMapTable"
    "NSCreateHashTable"
    "NSCreateHashTableWithZone"
    "NSCreateMapTable"
    "NSCreateMapTableWithZone"
    "NSDeallocateMemoryPages"
    "NSDecimalAdd"
    "NSDecimalCompact"
    "NSDecimalCompare"
    "NSDecimalCopy"
    "NSDecimalDivide"
    "NSDecimalIsNotANumber"
    "NSDecimalMultiply"
    "NSDecimalMultiplyByPowerOf10"
    "NSDecimalNormalize"
    "NSDecimalPower"
    "NSDecimalRound"
    "NSDecimalString"
    "NSDecimalSubtract"
    "NSEdgeInsetsEqual"
    "NSEdgeInsetsMake"
    "NSEndHashTableEnumeration"
    "NSEndMapTableEnumeration"
    "NSEnumerateHashTable"
    "NSEnumerateMapTable"
    "NSFileTypeForHFSTypeCode"
    "NSFreeHashTable"
    "NSFreeMapTable"
    "NSFullUserName"
    "NSGetSizeAndAlignment"
    "NSGetUncaughtExceptionHandler"
    "NSHFSTypeCodeFromFileType"
    "NSHFSTypeOfFile"
    "NSHashGet"
    "NSHashInsert"
    "NSHashInsertIfAbsent"
    "NSHashInsertKnownAbsent"
    "NSHashRemove"
    "NSHomeDirectory"
    "NSHomeDirectoryForUser"
    "NSHostByteOrder"
    "NSLocalizedString"
    "NSLog"
    "NSLogPageSize"
    "NSLogv"
    "NSMapGet"
    "NSMapInsert"
    "NSMapInsertIfAbsent"
    "NSMapInsertKnownAbsent"
    "NSMapMember"
    "NSMapRemove"
    "NSNextHashEnumeratorItem"
    "NSNextMapEnumeratorPair"
    "NSOpenStepRootDirectory"
    "NSPageSize"
    "NSProtocolFromString"
    "NSRealMemoryAvailable"
    "NSResetHashTable"
    "NSResetMapTable"
    "NSRoundDownToMultipleOfPageSize"
    "NSRoundUpToMultipleOfPageSize"
    "NSSearchPathForDirectoriesInDomains"
    "NSSelectorFromString"
    "NSSetUncaughtExceptionHandler"
    "NSStringFromClass"
    "NSStringFromHashTable"
    "NSStringFromMapTable"
    "NSStringFromProtocol"
    "NSStringFromSelector"
    "NSSwapBigDoubleToHost"
    "NSSwapBigFloatToHost"
    "NSSwapBigIntToHost"
    "NSSwapBigLongLongToHost"
    "NSSwapBigLongToHost"
    "NSSwapBigShortToHost"
    "NSSwapDouble"
    "NSSwapFloat"
    "NSSwapHostDoubleToBig"
    "NSSwapHostDoubleToLittle"
    "NSSwapHostFloatToBig"
    "NSSwapHostFloatToLittle"
    "NSSwapHostIntToBig"
    "NSSwapHostIntToLittle"
    "NSSwapHostLongLongToBig"
    "NSSwapHostLongLongToLittle"
    "NSSwapHostLongToBig"
    "NSSwapHostLongToLittle"
    "NSSwapHostShortToBig"
    "NSSwapHostShortToLittle"
    "NSSwapInt"
    "NSSwapLittleDoubleToHost"
    "NSSwapLittleFloatToHost"
    "NSSwapLittleIntToHost"
    "NSSwapLittleLongLongToHost"
    "NSSwapLittleLongToHost"
    "NSSwapLittleShortToHost"
    "NSSwapLong"
    "NSSwapLongLong"
    "NSSwapShort"
    "NSTemporaryDirectory"
    "NSUserName"
    "pow")
  "Foundation functions.")

(defconst swift-mode:foundation-constants
  '("HMCharacteristicPropertySupportsEvent"
    "NSASCIIStringEncoding"
    "NSAppleEventTimeOutDefault"
    "NSAppleEventTimeOutNone"
    "NSArgumentEvaluationScriptError"
    "NSArgumentsWrongScriptError"
    "NSAssertionHandlerKey"
    "NSBuddhistCalendar"
    "NSBundleErrorMaximum"
    "NSBundleErrorMinimum"
    "NSBundleExecutableArchitectureI386"
    "NSBundleExecutableArchitecturePPC"
    "NSBundleExecutableArchitecturePPC64"
    "NSBundleExecutableArchitectureX86_64"
    "NSBundleOnDemandResourceExceededMaximumSizeError"
    "NSBundleOnDemandResourceInvalidTagError"
    "NSBundleOnDemandResourceOutOfSpaceError"
    "NSBundleResourceRequestLoadingPriorityUrgent"
    "NSCannotCreateScriptCommandError"
    "NSChineseCalendar"
    "NSCloudSharingConflictError"
    "NSCloudSharingErrorMaximum"
    "NSCloudSharingErrorMinimum"
    "NSCloudSharingNetworkFailureError"
    "NSCloudSharingNoPermissionError"
    "NSCloudSharingOtherError"
    "NSCloudSharingQuotaExceededError"
    "NSCloudSharingTooManyParticipantsError"
    "NSCocoaErrorDomain"
    "NSCoderErrorMaximum"
    "NSCoderErrorMinimum"
    "NSCoderInvalidValueError"
    "NSCoderReadCorruptError"
    "NSCoderValueNotFoundError"
    "NSCollectorDisabledOption"
    "NSCompressionErrorMaximum"
    "NSCompressionErrorMinimum"
    "NSCompressionFailedError"
    "NSContainerSpecifierError"
    "NSDateComponentUndefined"
    "NSDebugDescriptionErrorKey"
    "NSDecimalMaxSize"
    "NSDecimalNoScale"
    "NSDecompressionFailedError"
    "NSEdgeInsetsZero"
    "NSErrorFailingURLStringKey"
    "NSExecutableArchitectureMismatchError"
    "NSExecutableErrorMaximum"
    "NSExecutableErrorMinimum"
    "NSExecutableLinkError"
    "NSExecutableLoadError"
    "NSExecutableNotLoadableError"
    "NSExecutableRuntimeMismatchError"
    "NSExtensionItemAttachmentsKey"
    "NSExtensionItemAttributedContentTextKey"
    "NSExtensionItemAttributedTitleKey"
    "NSExtensionItemsAndErrorsKey"
    "NSExtensionJavaScriptFinalizeArgumentKey"
    "NSExtensionJavaScriptPreprocessingResultsKey"
    "NSFeatureUnsupportedError"
    "NSFileErrorMaximum"
    "NSFileErrorMinimum"
    "NSFileHandleNotificationDataItem"
    "NSFileHandleNotificationFileHandleItem"
    "NSFileHandleNotificationMonitorModes"
    "NSFileLockingError"
    "NSFileManagerUnmountBusyError"
    "NSFileManagerUnmountDissentingProcessIdentifierErrorKey"
    "NSFileManagerUnmountUnknownError"
    "NSFileNoSuchFileError"
    "NSFilePathErrorKey"
    "NSFileReadCorruptFileError"
    "NSFileReadInapplicableStringEncodingError"
    "NSFileReadInvalidFileNameError"
    "NSFileReadNoPermissionError"
    "NSFileReadNoSuchFileError"
    "NSFileReadTooLargeError"
    "NSFileReadUnknownError"
    "NSFileReadUnknownStringEncodingError"
    "NSFileReadUnsupportedSchemeError"
    "NSFileWriteFileExistsError"
    "NSFileWriteInapplicableStringEncodingError"
    "NSFileWriteInvalidFileNameError"
    "NSFileWriteNoPermissionError"
    "NSFileWriteOutOfSpaceError"
    "NSFileWriteUnknownError"
    "NSFileWriteUnsupportedSchemeError"
    "NSFileWriteVolumeReadOnlyError"
    "NSFormattingError"
    "NSFormattingErrorMaximum"
    "NSFormattingErrorMinimum"
    "NSFoundationVersionNumber"
    "NSFoundationVersionNumber10_0"
    "NSFoundationVersionNumber10_1"
    "NSFoundationVersionNumber10_10"
    "NSFoundationVersionNumber10_10_1"
    "NSFoundationVersionNumber10_10_2"
    "NSFoundationVersionNumber10_10_3"
    "NSFoundationVersionNumber10_10_4"
    "NSFoundationVersionNumber10_10_5"
    "NSFoundationVersionNumber10_10_Max"
    "NSFoundationVersionNumber10_11"
    "NSFoundationVersionNumber10_11_1"
    "NSFoundationVersionNumber10_11_2"
    "NSFoundationVersionNumber10_11_3"
    "NSFoundationVersionNumber10_11_4"
    "NSFoundationVersionNumber10_11_Max"
    "NSFoundationVersionNumber10_1_1"
    "NSFoundationVersionNumber10_1_2"
    "NSFoundationVersionNumber10_1_3"
    "NSFoundationVersionNumber10_1_4"
    "NSFoundationVersionNumber10_2"
    "NSFoundationVersionNumber10_2_1"
    "NSFoundationVersionNumber10_2_2"
    "NSFoundationVersionNumber10_2_3"
    "NSFoundationVersionNumber10_2_4"
    "NSFoundationVersionNumber10_2_5"
    "NSFoundationVersionNumber10_2_6"
    "NSFoundationVersionNumber10_2_7"
    "NSFoundationVersionNumber10_2_8"
    "NSFoundationVersionNumber10_3"
    "NSFoundationVersionNumber10_3_1"
    "NSFoundationVersionNumber10_3_2"
    "NSFoundationVersionNumber10_3_3"
    "NSFoundationVersionNumber10_3_4"
    "NSFoundationVersionNumber10_3_5"
    "NSFoundationVersionNumber10_3_6"
    "NSFoundationVersionNumber10_3_7"
    "NSFoundationVersionNumber10_3_8"
    "NSFoundationVersionNumber10_3_9"
    "NSFoundationVersionNumber10_4"
    "NSFoundationVersionNumber10_4_1"
    "NSFoundationVersionNumber10_4_10"
    "NSFoundationVersionNumber10_4_11"
    "NSFoundationVersionNumber10_4_2"
    "NSFoundationVersionNumber10_4_3"
    "NSFoundationVersionNumber10_4_4_Intel"
    "NSFoundationVersionNumber10_4_4_PowerPC"
    "NSFoundationVersionNumber10_4_5"
    "NSFoundationVersionNumber10_4_6"
    "NSFoundationVersionNumber10_4_7"
    "NSFoundationVersionNumber10_4_8"
    "NSFoundationVersionNumber10_4_9"
    "NSFoundationVersionNumber10_5"
    "NSFoundationVersionNumber10_5_1"
    "NSFoundationVersionNumber10_5_2"
    "NSFoundationVersionNumber10_5_3"
    "NSFoundationVersionNumber10_5_4"
    "NSFoundationVersionNumber10_5_5"
    "NSFoundationVersionNumber10_5_6"
    "NSFoundationVersionNumber10_5_7"
    "NSFoundationVersionNumber10_5_8"
    "NSFoundationVersionNumber10_6"
    "NSFoundationVersionNumber10_6_1"
    "NSFoundationVersionNumber10_6_2"
    "NSFoundationVersionNumber10_6_3"
    "NSFoundationVersionNumber10_6_4"
    "NSFoundationVersionNumber10_6_5"
    "NSFoundationVersionNumber10_6_6"
    "NSFoundationVersionNumber10_6_7"
    "NSFoundationVersionNumber10_6_8"
    "NSFoundationVersionNumber10_7"
    "NSFoundationVersionNumber10_7_1"
    "NSFoundationVersionNumber10_7_2"
    "NSFoundationVersionNumber10_7_3"
    "NSFoundationVersionNumber10_7_4"
    "NSFoundationVersionNumber10_8"
    "NSFoundationVersionNumber10_8_1"
    "NSFoundationVersionNumber10_8_2"
    "NSFoundationVersionNumber10_8_3"
    "NSFoundationVersionNumber10_8_4"
    "NSFoundationVersionNumber10_9"
    "NSFoundationVersionNumber10_9_1"
    "NSFoundationVersionNumber10_9_2"
    "NSFoundationVersionNumber_iOS_4_0"
    "NSFoundationVersionNumber_iOS_4_1"
    "NSFoundationVersionNumber_iOS_4_2"
    "NSFoundationVersionNumber_iOS_4_3"
    "NSFoundationVersionNumber_iOS_5_0"
    "NSFoundationVersionNumber_iOS_5_1"
    "NSFoundationVersionNumber_iOS_6_0"
    "NSFoundationVersionNumber_iOS_6_1"
    "NSFoundationVersionNumber_iOS_7_0"
    "NSFoundationVersionNumber_iOS_7_1"
    "NSFoundationVersionNumber_iOS_8_0"
    "NSFoundationVersionNumber_iOS_8_1"
    "NSFoundationVersionNumber_iOS_8_2"
    "NSFoundationVersionNumber_iOS_8_3"
    "NSFoundationVersionNumber_iOS_8_4"
    "NSFoundationVersionNumber_iOS_8_x_Max"
    "NSFoundationVersionNumber_iOS_9_0"
    "NSFoundationVersionNumber_iOS_9_1"
    "NSFoundationVersionNumber_iOS_9_2"
    "NSFoundationVersionNumber_iOS_9_3"
    "NSFoundationVersionNumber_iOS_9_4"
    "NSFoundationVersionNumber_iOS_9_x_Max"
    "NSFoundationVersionNumber_iPhoneOS_2_0"
    "NSFoundationVersionNumber_iPhoneOS_2_1"
    "NSFoundationVersionNumber_iPhoneOS_2_2"
    "NSFoundationVersionNumber_iPhoneOS_3_0"
    "NSFoundationVersionNumber_iPhoneOS_3_1"
    "NSFoundationVersionNumber_iPhoneOS_3_2"
    "NSFoundationVersionWithFileManagerResourceForkSupport"
    "NSGrammarCorrections"
    "NSGrammarRange"
    "NSGrammarUserDescription"
    "NSGregorianCalendar"
    "NSHPUXOperatingSystem"
    "NSHebrewCalendar"
    "NSHelpAnchorErrorKey"
    "NSISO2022JPStringEncoding"
    "NSISO8601Calendar"
    "NSISOLatin1StringEncoding"
    "NSISOLatin2StringEncoding"
    "NSIndianCalendar"
    "NSIntMapKeyCallBacks"
    "NSIntMapValueCallBacks"
    "NSIntegerHashCallBacks"
    "NSIntegerMapKeyCallBacks"
    "NSIntegerMapValueCallBacks"
    "NSInternalScriptError"
    "NSInternalSpecifierError"
    "NSInvalidIndexSpecifierError"
    "NSIslamicCalendar"
    "NSIslamicCivilCalendar"
    "NSItemProviderPreferredImageSizeKey"
    "NSJapaneseCalendar"
    "NSJapaneseEUCStringEncoding"
    "NSKeySpecifierEvaluationScriptError"
    "NSKeyValueValidationError"
    "NSKeyedArchiveRootObjectKey"
    "NSLoadedClasses"
    "NSLocalizedDescriptionKey"
    "NSLocalizedFailureErrorKey"
    "NSLocalizedFailureReasonErrorKey"
    "NSLocalizedRecoveryOptionsErrorKey"
    "NSLocalizedRecoverySuggestionErrorKey"
    "NSMACHOperatingSystem"
    "NSMacOSRomanStringEncoding"
    "NSMachErrorDomain"
    "NSMapTableCopyIn"
    "NSMapTableObjectPointerPersonality"
    "NSMapTableStrongMemory"
    "NSMapTableWeakMemory"
    "NSMetadataItemAcquisitionMakeKey"
    "NSMetadataItemAcquisitionModelKey"
    "NSMetadataItemAlbumKey"
    "NSMetadataItemAltitudeKey"
    "NSMetadataItemApertureKey"
    "NSMetadataItemAppleLoopDescriptorsKey"
    "NSMetadataItemAppleLoopsKeyFilterTypeKey"
    "NSMetadataItemAppleLoopsLoopModeKey"
    "NSMetadataItemAppleLoopsRootKeyKey"
    "NSMetadataItemApplicationCategoriesKey"
    "NSMetadataItemAttributeChangeDateKey"
    "NSMetadataItemAudiencesKey"
    "NSMetadataItemAudioBitRateKey"
    "NSMetadataItemAudioChannelCountKey"
    "NSMetadataItemAudioEncodingApplicationKey"
    "NSMetadataItemAudioSampleRateKey"
    "NSMetadataItemAudioTrackNumberKey"
    "NSMetadataItemAuthorAddressesKey"
    "NSMetadataItemAuthorEmailAddressesKey"
    "NSMetadataItemAuthorsKey"
    "NSMetadataItemBitsPerSampleKey"
    "NSMetadataItemCFBundleIdentifierKey"
    "NSMetadataItemCameraOwnerKey"
    "NSMetadataItemCityKey"
    "NSMetadataItemCodecsKey"
    "NSMetadataItemColorSpaceKey"
    "NSMetadataItemCommentKey"
    "NSMetadataItemComposerKey"
    "NSMetadataItemContactKeywordsKey"
    "NSMetadataItemContentCreationDateKey"
    "NSMetadataItemContentModificationDateKey"
    "NSMetadataItemContentTypeKey"
    "NSMetadataItemContentTypeTreeKey"
    "NSMetadataItemContributorsKey"
    "NSMetadataItemCopyrightKey"
    "NSMetadataItemCountryKey"
    "NSMetadataItemCoverageKey"
    "NSMetadataItemCreatorKey"
    "NSMetadataItemDateAddedKey"
    "NSMetadataItemDeliveryTypeKey"
    "NSMetadataItemDescriptionKey"
    "NSMetadataItemDirectorKey"
    "NSMetadataItemDisplayNameKey"
    "NSMetadataItemDownloadedDateKey"
    "NSMetadataItemDueDateKey"
    "NSMetadataItemDurationSecondsKey"
    "NSMetadataItemEXIFGPSVersionKey"
    "NSMetadataItemEXIFVersionKey"
    "NSMetadataItemEditorsKey"
    "NSMetadataItemEmailAddressesKey"
    "NSMetadataItemEncodingApplicationsKey"
    "NSMetadataItemExecutableArchitecturesKey"
    "NSMetadataItemExecutablePlatformKey"
    "NSMetadataItemExposureModeKey"
    "NSMetadataItemExposureProgramKey"
    "NSMetadataItemExposureTimeSecondsKey"
    "NSMetadataItemExposureTimeStringKey"
    "NSMetadataItemFNumberKey"
    "NSMetadataItemFSContentChangeDateKey"
    "NSMetadataItemFSCreationDateKey"
    "NSMetadataItemFSNameKey"
    "NSMetadataItemFSSizeKey"
    "NSMetadataItemFinderCommentKey"
    "NSMetadataItemFlashOnOffKey"
    "NSMetadataItemFocalLength35mmKey"
    "NSMetadataItemFocalLengthKey"
    "NSMetadataItemFontsKey"
    "NSMetadataItemGPSAreaInformationKey"
    "NSMetadataItemGPSDOPKey"
    "NSMetadataItemGPSDateStampKey"
    "NSMetadataItemGPSDestBearingKey"
    "NSMetadataItemGPSDestDistanceKey"
    "NSMetadataItemGPSDestLatitudeKey"
    "NSMetadataItemGPSDestLongitudeKey"
    "NSMetadataItemGPSDifferentalKey"
    "NSMetadataItemGPSMapDatumKey"
    "NSMetadataItemGPSMeasureModeKey"
    "NSMetadataItemGPSProcessingMethodKey"
    "NSMetadataItemGPSStatusKey"
    "NSMetadataItemGPSTrackKey"
    "NSMetadataItemGenreKey"
    "NSMetadataItemHasAlphaChannelKey"
    "NSMetadataItemHeadlineKey"
    "NSMetadataItemISOSpeedKey"
    "NSMetadataItemIdentifierKey"
    "NSMetadataItemImageDirectionKey"
    "NSMetadataItemInformationKey"
    "NSMetadataItemInstantMessageAddressesKey"
    "NSMetadataItemInstructionsKey"
    "NSMetadataItemIsApplicationManagedKey"
    "NSMetadataItemIsGeneralMIDISequenceKey"
    "NSMetadataItemIsLikelyJunkKey"
    "NSMetadataItemIsUbiquitousKey"
    "NSMetadataItemKeySignatureKey"
    "NSMetadataItemKeywordsKey"
    "NSMetadataItemKindKey"
    "NSMetadataItemLanguagesKey"
    "NSMetadataItemLastUsedDateKey"
    "NSMetadataItemLatitudeKey"
    "NSMetadataItemLayerNamesKey"
    "NSMetadataItemLensModelKey"
    "NSMetadataItemLongitudeKey"
    "NSMetadataItemLyricistKey"
    "NSMetadataItemMaxApertureKey"
    "NSMetadataItemMediaTypesKey"
    "NSMetadataItemMeteringModeKey"
    "NSMetadataItemMusicalGenreKey"
    "NSMetadataItemMusicalInstrumentCategoryKey"
    "NSMetadataItemMusicalInstrumentNameKey"
    "NSMetadataItemNamedLocationKey"
    "NSMetadataItemNumberOfPagesKey"
    "NSMetadataItemOrganizationsKey"
    "NSMetadataItemOrientationKey"
    "NSMetadataItemOriginalFormatKey"
    "NSMetadataItemOriginalSourceKey"
    "NSMetadataItemPageHeightKey"
    "NSMetadataItemPageWidthKey"
    "NSMetadataItemParticipantsKey"
    "NSMetadataItemPathKey"
    "NSMetadataItemPerformersKey"
    "NSMetadataItemPhoneNumbersKey"
    "NSMetadataItemPixelCountKey"
    "NSMetadataItemPixelHeightKey"
    "NSMetadataItemPixelWidthKey"
    "NSMetadataItemProducerKey"
    "NSMetadataItemProfileNameKey"
    "NSMetadataItemProjectsKey"
    "NSMetadataItemPublishersKey"
    "NSMetadataItemRecipientAddressesKey"
    "NSMetadataItemRecipientEmailAddressesKey"
    "NSMetadataItemRecipientsKey"
    "NSMetadataItemRecordingDateKey"
    "NSMetadataItemRecordingYearKey"
    "NSMetadataItemRedEyeOnOffKey"
    "NSMetadataItemResolutionHeightDPIKey"
    "NSMetadataItemResolutionWidthDPIKey"
    "NSMetadataItemRightsKey"
    "NSMetadataItemSecurityMethodKey"
    "NSMetadataItemSpeedKey"
    "NSMetadataItemStarRatingKey"
    "NSMetadataItemStateOrProvinceKey"
    "NSMetadataItemStreamableKey"
    "NSMetadataItemSubjectKey"
    "NSMetadataItemTempoKey"
    "NSMetadataItemTextContentKey"
    "NSMetadataItemThemeKey"
    "NSMetadataItemTimeSignatureKey"
    "NSMetadataItemTimestampKey"
    "NSMetadataItemTitleKey"
    "NSMetadataItemTotalBitRateKey"
    "NSMetadataItemURLKey"
    "NSMetadataItemVersionKey"
    "NSMetadataItemVideoBitRateKey"
    "NSMetadataItemWhereFromsKey"
    "NSMetadataItemWhiteBalanceKey"
    "NSMetadataQueryAccessibleUbiquitousExternalDocumentsScope"
    "NSMetadataQueryIndexedLocalComputerScope"
    "NSMetadataQueryIndexedNetworkScope"
    "NSMetadataQueryLocalComputerScope"
    "NSMetadataQueryNetworkScope"
    "NSMetadataQueryResultContentRelevanceAttribute"
    "NSMetadataQueryUbiquitousDataScope"
    "NSMetadataQueryUbiquitousDocumentsScope"
    "NSMetadataQueryUpdateAddedItemsKey"
    "NSMetadataQueryUpdateChangedItemsKey"
    "NSMetadataQueryUpdateRemovedItemsKey"
    "NSMetadataQueryUserHomeScope"
    "NSMetadataUbiquitousItemContainerDisplayNameKey"
    "NSMetadataUbiquitousItemDownloadRequestedKey"
    "NSMetadataUbiquitousItemDownloadingErrorKey"
    "NSMetadataUbiquitousItemDownloadingStatusCurrent"
    "NSMetadataUbiquitousItemDownloadingStatusDownloaded"
    "NSMetadataUbiquitousItemDownloadingStatusKey"
    "NSMetadataUbiquitousItemDownloadingStatusNotDownloaded"
    "NSMetadataUbiquitousItemHasUnresolvedConflictsKey"
    "NSMetadataUbiquitousItemIsDownloadedKey"
    "NSMetadataUbiquitousItemIsDownloadingKey"
    "NSMetadataUbiquitousItemIsExternalDocumentKey"
    "NSMetadataUbiquitousItemIsSharedKey"
    "NSMetadataUbiquitousItemIsUploadedKey"
    "NSMetadataUbiquitousItemIsUploadingKey"
    "NSMetadataUbiquitousItemPercentDownloadedKey"
    "NSMetadataUbiquitousItemPercentUploadedKey"
    "NSMetadataUbiquitousItemURLInLocalContainerKey"
    "NSMetadataUbiquitousItemUploadingErrorKey"
    "NSMetadataUbiquitousSharedItemCurrentUserPermissionsKey"
    "NSMetadataUbiquitousSharedItemCurrentUserRoleKey"
    "NSMetadataUbiquitousSharedItemMostRecentEditorNameComponentsKey"
    "NSMetadataUbiquitousSharedItemOwnerNameComponentsKey"
    "NSMetadataUbiquitousSharedItemPermissionsReadOnly"
    "NSMetadataUbiquitousSharedItemPermissionsReadWrite"
    "NSMetadataUbiquitousSharedItemRoleOwner"
    "NSMetadataUbiquitousSharedItemRoleParticipant"
    "NSNEXTSTEPStringEncoding"
    "NSNoScriptError"
    "NSNoSpecifierError"
    "NSNoTopLevelContainersSpecifierError"
    "NSNonLossyASCIIStringEncoding"
    "NSNonOwnedPointerHashCallBacks"
    "NSNonOwnedPointerMapKeyCallBacks"
    "NSNonOwnedPointerMapValueCallBacks"
    "NSNonOwnedPointerOrNullMapKeyCallBacks"
    "NSNonRetainedObjectHashCallBacks"
    "NSNonRetainedObjectMapKeyCallBacks"
    "NSNonRetainedObjectMapValueCallBacks"
    "NSNotFound"
    "NSNotificationDeliverImmediately"
    "NSNotificationPostToAllSessions"
    "NSOSF1OperatingSystem"
    "NSOSStatusErrorDomain"
    "NSObjectHashCallBacks"
    "NSObjectMapKeyCallBacks"
    "NSObjectMapValueCallBacks"
    "NSOpenStepUnicodeReservedBase"
    "NSOperationNotSupportedForKeyException"
    "NSOperationNotSupportedForKeyScriptError"
    "NSOperationNotSupportedForKeySpecifierError"
    "NSOwnedObjectIdentityHashCallBacks"
    "NSOwnedPointerHashCallBacks"
    "NSOwnedPointerMapKeyCallBacks"
    "NSOwnedPointerMapValueCallBacks"
    "NSPOSIXErrorDomain"
    "NSPersianCalendar"
    "NSPersonNameComponentDelimiter"
    "NSPersonNameComponentFamilyName"
    "NSPersonNameComponentGivenName"
    "NSPersonNameComponentKey"
    "NSPersonNameComponentMiddleName"
    "NSPersonNameComponentNickname"
    "NSPersonNameComponentPrefix"
    "NSPersonNameComponentSuffix"
    "NSPointerToStructHashCallBacks"
    "NSPropertyListErrorMaximum"
    "NSPropertyListErrorMinimum"
    "NSPropertyListReadCorruptError"
    "NSPropertyListReadStreamError"
    "NSPropertyListReadUnknownVersionError"
    "NSPropertyListWriteInvalidError"
    "NSPropertyListWriteStreamError"
    "NSProprietaryStringEncoding"
    "NSReceiverEvaluationScriptError"
    "NSReceiversCantHandleCommandScriptError"
    "NSRecoveryAttempterErrorKey"
    "NSRepublicOfChinaCalendar"
    "NSRequiredArgumentsMissingScriptError"
    "NSScannedOption"
    "NSShiftJISStringEncoding"
    "NSSolarisOperatingSystem"
    "NSStreamSOCKSErrorDomain"
    "NSStreamSocketSSLErrorDomain"
    "NSStringEncodingErrorKey"
    "NSSunOSOperatingSystem"
    "NSSymbolStringEncoding"
    "NSTextCheckingAllCustomTypes"
    "NSTextCheckingAllSystemTypes"
    "NSTextCheckingAllTypes"
    "NSTimeIntervalSince1970"
    "NSTypeIdentifierAddressText"
    "NSTypeIdentifierDateText"
    "NSTypeIdentifierPhoneNumberText"
    "NSTypeIdentifierTransitInformationText"
    "NSURLAuthenticationMethodClientCertificate"
    "NSURLAuthenticationMethodDefault"
    "NSURLAuthenticationMethodHTMLForm"
    "NSURLAuthenticationMethodHTTPBasic"
    "NSURLAuthenticationMethodHTTPDigest"
    "NSURLAuthenticationMethodNTLM"
    "NSURLAuthenticationMethodNegotiate"
    "NSURLAuthenticationMethodServerTrust"
    "NSURLCredentialStorageRemoveSynchronizableCredentials"
    "NSURLErrorAppTransportSecurityRequiresSecureConnection"
    "NSURLErrorBackgroundSessionInUseByAnotherProcess"
    "NSURLErrorBackgroundSessionRequiresSharedContainer"
    "NSURLErrorBackgroundSessionWasDisconnected"
    "NSURLErrorBackgroundTaskCancelledReasonKey"
    "NSURLErrorBadServerResponse"
    "NSURLErrorBadURL"
    "NSURLErrorCallIsActive"
    "NSURLErrorCancelled"
    "NSURLErrorCancelledReasonBackgroundUpdatesDisabled"
    "NSURLErrorCancelledReasonInsufficientSystemResources"
    "NSURLErrorCancelledReasonUserForceQuitApplication"
    "NSURLErrorCannotCloseFile"
    "NSURLErrorCannotConnectToHost"
    "NSURLErrorCannotCreateFile"
    "NSURLErrorCannotDecodeContentData"
    "NSURLErrorCannotDecodeRawData"
    "NSURLErrorCannotFindHost"
    "NSURLErrorCannotLoadFromNetwork"
    "NSURLErrorCannotMoveFile"
    "NSURLErrorCannotOpenFile"
    "NSURLErrorCannotParseResponse"
    "NSURLErrorCannotRemoveFile"
    "NSURLErrorCannotWriteToFile"
    "NSURLErrorClientCertificateRejected"
    "NSURLErrorClientCertificateRequired"
    "NSURLErrorDNSLookupFailed"
    "NSURLErrorDataLengthExceedsMaximum"
    "NSURLErrorDataNotAllowed"
    "NSURLErrorDomain"
    "NSURLErrorDownloadDecodingFailedMidStream"
    "NSURLErrorDownloadDecodingFailedToComplete"
    "NSURLErrorFailingURLErrorKey"
    "NSURLErrorFailingURLPeerTrustErrorKey"
    "NSURLErrorFailingURLStringErrorKey"
    "NSURLErrorFileDoesNotExist"
    "NSURLErrorFileIsDirectory"
    "NSURLErrorFileOutsideSafeArea"
    "NSURLErrorHTTPTooManyRedirects"
    "NSURLErrorInternationalRoamingOff"
    "NSURLErrorKey"
    "NSURLErrorNetworkConnectionLost"
    "NSURLErrorNetworkUnavailableReasonKey"
    "NSURLErrorNoPermissionsToReadFile"
    "NSURLErrorNotConnectedToInternet"
    "NSURLErrorRedirectToNonExistentLocation"
    "NSURLErrorRequestBodyStreamExhausted"
    "NSURLErrorResourceUnavailable"
    "NSURLErrorSecureConnectionFailed"
    "NSURLErrorServerCertificateHasBadDate"
    "NSURLErrorServerCertificateHasUnknownRoot"
    "NSURLErrorServerCertificateNotYetValid"
    "NSURLErrorServerCertificateUntrusted"
    "NSURLErrorTimedOut"
    "NSURLErrorUnknown"
    "NSURLErrorUnsupportedURL"
    "NSURLErrorUserAuthenticationRequired"
    "NSURLErrorUserCancelledAuthentication"
    "NSURLErrorZeroByteResource"
    "NSURLFileScheme"
    "NSURLProtectionSpaceFTP"
    "NSURLProtectionSpaceFTPProxy"
    "NSURLProtectionSpaceHTTP"
    "NSURLProtectionSpaceHTTPProxy"
    "NSURLProtectionSpaceHTTPS"
    "NSURLProtectionSpaceHTTPSProxy"
    "NSURLProtectionSpaceSOCKSProxy"
    "NSURLSessionDownloadTaskResumeData"
    "NSURLSessionTransferSizeUnknown"
    "NSUTF16BigEndianStringEncoding"
    "NSUTF16LittleEndianStringEncoding"
    "NSUTF16StringEncoding"
    "NSUTF32BigEndianStringEncoding"
    "NSUTF32LittleEndianStringEncoding"
    "NSUTF32StringEncoding"
    "NSUTF8StringEncoding"
    "NSUbiquitousFileErrorMaximum"
    "NSUbiquitousFileErrorMinimum"
    "NSUbiquitousFileNotUploadedDueToQuotaError"
    "NSUbiquitousFileUbiquityServerNotAvailable"
    "NSUbiquitousFileUnavailableError"
    "NSUbiquitousKeyValueStoreAccountChange"
    "NSUbiquitousKeyValueStoreChangeReasonKey"
    "NSUbiquitousKeyValueStoreChangedKeysKey"
    "NSUbiquitousKeyValueStoreInitialSyncChange"
    "NSUbiquitousKeyValueStoreQuotaViolationChange"
    "NSUbiquitousKeyValueStoreServerChange"
    "NSUndefinedDateComponent"
    "NSUnderlyingErrorKey"
    "NSUndoCloseGroupingRunLoopOrdering"
    "NSUndoManagerGroupIsDiscardableKey"
    "NSUnicodeStringEncoding"
    "NSUnknownKeyScriptError"
    "NSUnknownKeySpecifierError"
    "NSUserActivityConnectionUnavailableError"
    "NSUserActivityErrorMaximum"
    "NSUserActivityErrorMinimum"
    "NSUserActivityHandoffFailedError"
    "NSUserActivityHandoffUserInfoTooLargeError"
    "NSUserActivityRemoteApplicationTimedOutError"
    "NSUserActivityTypeBrowsingWeb"
    "NSUserCancelledError"
    "NSUserNotificationDefaultSoundName"
    "NSValidationErrorMaximum"
    "NSValidationErrorMinimum"
    "NSWindows95OperatingSystem"
    "NSWindowsCP1250StringEncoding"
    "NSWindowsCP1251StringEncoding"
    "NSWindowsCP1252StringEncoding"
    "NSWindowsCP1253StringEncoding"
    "NSWindowsCP1254StringEncoding"
    "NSWindowsNTOperatingSystem"
    "NSWrapCalendarComponents"
    "NSXPCConnectionErrorMaximum"
    "NSXPCConnectionErrorMinimum"
    "NSXPCConnectionInterrupted"
    "NSXPCConnectionInvalid"
    "NSXPCConnectionReplyInvalid"
    "NS_BigEndian"
    "NS_LittleEndian"
    "NS_UnknownByteOrder")
  "Foundation constants.")

(defconst swift-mode:standard-types
  '("ASCII"
    "AdditiveArithmetic"
    "AllCases"
    "AncestorRepresentation"
    "AnyBidirectionalCollection"
    "AnyClass"
    "AnyCollection"
    "AnyHashable"
    "AnyIndex"
    "AnyIterator"
    "AnyKeyPath"
    "AnyObject"
    "AnyRandomAccessCollection"
    "AnySequence"
    "Array"
    "ArrayLiteralElement"
    "ArraySlice"
    "AutoreleasingUnsafeMutablePointer"
    "BidirectionalCollection"
    "BinaryFloatingPoint"
    "BinaryInteger"
    "BiquadFunctions"
    "Body"
    "Bool"
    "BooleanLiteralType"
    "Bound"
    "CBool"
    "CChar"
    "CChar16"
    "CChar32"
    "CDouble"
    "CFloat"
    "CInt"
    "CLong"
    "CLongDouble"
    "CLongLong"
    "CShort"
    "CSignedChar"
    "CUnsignedChar"
    "CUnsignedInt"
    "CUnsignedLong"
    "CUnsignedLongLong"
    "CUnsignedShort"
    "CVaListPointer"
    "CVarArg"
    "CWideChar"
    "CanonicalCombiningClass"
    "CaseIterable"
    "Change"
    "Character"
    "Child"
    "Children"
    "ClosedRange"
    "Codable"
    "CodeUnit"
    "CodingKey"
    "CodingUserInfoKey"
    "Collection"
    "CollectionDifference"
    "CollectionOfOne"
    "CommandLine"
    "Comparable"
    "CompareOptions"
    "Context"
    "ContiguousArray"
    "CountableClosedRange"
    "CountablePartialRangeFrom"
    "CountableRange"
    "CustomDebugStringConvertible"
    "CustomLeafReflectable"
    "CustomNSError"
    "CustomPlaygroundDisplayConvertible"
    "CustomReflectable"
    "CustomStringConvertible"
    "DFTFunctions"
    "Decodable"
    "Decoder"
    "DecodingError"
    "DefaultIndices"
    "DefaultStringInterpolation"
    "Dictionary"
    "DictionaryIndex"
    "DictionaryIterator"
    "DictionaryLiteral"
    "DisplayStyle"
    "Distance"
    "Double"
    "DropFirstSequence"
    "DropWhileSequence"
    "Element"
    "Elements"
    "EmptyCollection"
    "Encodable"
    "EncodedScalar"
    "Encoder"
    "Encoding"
    "EncodingConversionOptions"
    "EncodingError"
    "EnumeratedIterator"
    "EnumeratedSequence"
    "EnumerationOptions"
    "Equatable"
    "Error"
    "Exponent"
    "ExpressibleByArrayLiteral"
    "ExpressibleByBooleanLiteral"
    "ExpressibleByDictionaryLiteral"
    "ExpressibleByExtendedGraphemeClusterLiteral"
    "ExpressibleByFloatLiteral"
    "ExpressibleByIntegerLiteral"
    "ExpressibleByNilLiteral"
    "ExpressibleByStringInterpolation"
    "ExpressibleByStringLiteral"
    "ExpressibleByUnicodeScalarLiteral"
    "ExtendedGraphemeClusterLiteralType"
    "ExtendedGraphemeClusterType"
    "Failure"
    "FixedWidthInteger"
    "FlattenCollection"
    "FlattenSequence"
    "Float"
    "Float32"
    "Float64"
    "Float80"
    "FloatLiteralType"
    "FloatingPoint"
    "FloatingPointClassification"
    "FloatingPointRoundingRule"
    "FloatingPointSign"
    "ForwardParser"
    "GeneralCategory"
    "Hashable"
    "Hasher"
    "Index"
    "IndexDistance"
    "IndexingIterator"
    "Indices"
    "Int"
    "Int16"
    "Int32"
    "Int64"
    "Int8"
    "IntegerLiteralType"
    "Iterator"
    "IteratorProtocol"
    "IteratorSequence"
    "JoinedSequence"
    "Key"
    "KeyPath"
    "KeyValuePairs"
    "KeyedDecodingContainer"
    "KeyedDecodingContainerProtocol"
    "KeyedEncodingContainer"
    "KeyedEncodingContainerProtocol"
    "Keys"
    "LazyCollection"
    "LazyCollectionProtocol"
    "LazyDropWhileCollection"
    "LazyDropWhileSequence"
    "LazyFilterCollection"
    "LazyFilterSequence"
    "LazyMapCollection"
    "LazyMapSequence"
    "LazyPrefixWhileCollection"
    "LazyPrefixWhileSequence"
    "LazySequence"
    "LazySequenceProtocol"
    "LocalizedError"
    "LosslessStringConvertible"
    "Magnitude"
    "ManagedBuffer"
    "ManagedBufferPointer"
    "MaskStorage"
    "MemoryLayout"
    "Mirror"
    "MirrorPath"
    "MutableCollection"
    "NSArray"
    "NSDictionary"
    "NSError"
    "NSMutableArray"
    "NSMutableDictionary"
    "NSMutableSet"
    "NSMutableString"
    "NSSet"
    "NSString"
    "Never"
    "Numeric"
    "NumericType"
    "ObjectIdentifier"
    "OpaquePointer"
    "OptionSet"
    "Optional"
    "Output"
    "ParseResult"
    "Parser"
    "PartialKeyPath"
    "PartialRangeFrom"
    "PartialRangeThrough"
    "PartialRangeUpTo"
    "PlaygroundQuickLook"
    "Pointee"
    "PrefixSequence"
    "Properties"
    "Publisher"
    "RandomAccessCollection"
    "RandomNumberGenerator"
    "Range"
    "RangeExpression"
    "RangeReplaceableCollection"
    "RawExponent"
    "RawRepresentable"
    "RawSignificand"
    "RawValue"
    "RecoverableError"
    "ReferenceWritableKeyPath"
    "Regions"
    "Repeated"
    "Result"
    "ReverseParser"
    "ReversedCollection"
    "SIMD"
    "SIMD16"
    "SIMD16Storage"
    "SIMD2"
    "SIMD2Storage"
    "SIMD3"
    "SIMD32"
    "SIMD32Storage"
    "SIMD4"
    "SIMD4Storage"
    "SIMD64"
    "SIMD64Storage"
    "SIMD8"
    "SIMD8Storage"
    "SIMDMask"
    "SIMDMaskScalar"
    "SIMDScalar"
    "SIMDStorage"
    "Scalar"
    "Sequence"
    "Set"
    "SetAlgebra"
    "SetIndex"
    "SetIterator"
    "SignedInteger"
    "SignedNumeric"
    "SingleValueDecodingContainer"
    "SingleValueEncodingContainer"
    "Slice"
    "StaticString"
    "Stride"
    "StrideThrough"
    "StrideThroughIterator"
    "StrideTo"
    "StrideToIterator"
    "Strideable"
    "String"
    "StringInterpolation"
    "StringInterpolationProtocol"
    "StringLiteralType"
    "StringProtocol"
    "SubSequence"
    "Substring"
    "SystemRandomNumberGenerator"
    "TextOutputStream"
    "TextOutputStreamable"
    "UInt"
    "UInt16"
    "UInt32"
    "UInt64"
    "UInt8"
    "UTF16"
    "UTF16View"
    "UTF32"
    "UTF8"
    "UTF8View"
    "UnboundedRange"
    "UnboundedRange_"
    "UnfoldFirstSequence"
    "UnfoldSequence"
    "Unicode"
    "UnicodeCodec"
    "UnicodeDecodingResult"
    "UnicodeScalar"
    "UnicodeScalarIndex"
    "UnicodeScalarLiteralType"
    "UnicodeScalarType"
    "UnicodeScalarView"
    "UnkeyedDecodingContainer"
    "UnkeyedEncodingContainer"
    "Unmanaged"
    "UnsafeBufferPointer"
    "UnsafeMutableBufferPointer"
    "UnsafeMutablePointer"
    "UnsafeMutableRawBufferPointer"
    "UnsafeMutableRawPointer"
    "UnsafePointer"
    "UnsafeRawBufferPointer"
    "UnsafeRawPointer"
    "UnsignedInteger"
    "Value"
    "Values"
    "Version"
    "Void"
    "Words"
    "WritableKeyPath"
    "Zip2Sequence"
    "_AppendKeyPath")
  "Built-in types.")

(defconst swift-mode:standard-enum-cases
  '("awayFromZero"
    "class"
    "closePunctuation"
    "collection"
    "connectorPunctuation"
    "control"
    "currencySymbol"
    "customized"
    "dashPunctuation"
    "dataCorrupted"
    "decimal"
    "decimalNumber"
    "dictionary"
    "digit"
    "down"
    "emptyInput"
    "enclosingMark"
    "enum"
    "error"
    "failure"
    "finalPunctuation"
    "format"
    "generated"
    "inRange"
    "initialPunctuation"
    "insert"
    "invalidValue"
    "keyNotFound"
    "letterNumber"
    "lineSeparator"
    "lowercaseLetter"
    "mathSymbol"
    "minus"
    "modifierLetter"
    "modifierSymbol"
    "negativeInfinity"
    "negativeNormal"
    "negativeSubnormal"
    "negativeZero"
    "none"
    "nonspacingMark"
    "numeric"
    "openPunctuation"
    "optional"
    "otherLetter"
    "otherNumber"
    "otherPunctuation"
    "otherSymbol"
    "paragraphSeparator"
    "pastEnd"
    "plus"
    "positiveInfinity"
    "positiveNormal"
    "positiveSubnormal"
    "positiveZero"
    "privateUse"
    "quietNaN"
    "remove"
    "scalarValue"
    "set"
    "signalingNaN"
    "some"
    "spaceSeparator"
    "spacingMark"
    "struct"
    "success"
    "suppressed"
    "surrogate"
    "titlecaseLetter"
    "toNearestOrAwayFromZero"
    "toNearestOrEven"
    "towardZero"
    "tuple"
    "typeMismatch"
    "unassigned"
    "up"
    "uppercaseLetter"
    "valid"
    "valueNotFound")
  "Built-in enum cases.")

(defconst swift-mode:standard-methods
  '("addProduct"
    "addingPercentEncoding"
    "addingProduct"
    "addingReportingOverflow"
    "advanced"
    "alignment"
    "allSatisfy"
    "allocate"
    "append"
    "appendInterpolation"
    "appendLiteral"
    "appending"
    "appendingFormat"
    "applying"
    "applyingTransform"
    "assign"
    "assumingMemoryBound"
    "autorelease"
    "bindMemory"
    "bytes"
    "cString"
    "canBeConverted"
    "capitalized"
    "caseInsensitiveCompare"
    "clamp"
    "clamped"
    "clip"
    "combine"
    "commonPrefix"
    "compactMap"
    "compactMapValues"
    "compare"
    "completePath"
    "components"
    "container"
    "contains"
    "copyBytes"
    "copyMemory"
    "create"
    "data"
    "dataCorruptedError"
    "deallocate"
    "decode"
    "decodeCString"
    "decodeIfPresent"
    "decodeNil"
    "deinitialize"
    "descendant"
    "difference"
    "distance"
    "dividedReportingOverflow"
    "dividingFullWidth"
    "drop"
    "dropFirst"
    "dropLast"
    "elementsEqual"
    "encode"
    "encodeConditional"
    "encodeIfPresent"
    "encodeNil"
    "enumerateLines"
    "enumerateLinguisticTags"
    "enumerateSubstrings"
    "enumerated"
    "escaped"
    "fill"
    "filter"
    "finalize"
    "first"
    "firstIndex"
    "flatMap"
    "flatMapError"
    "folding"
    "forEach"
    "formIndex"
    "formIntersection"
    "formRemainder"
    "formSquareRoot"
    "formSymmetricDifference"
    "formTruncatingRemainder"
    "formUnion"
    "fromOpaque"
    "get"
    "getBytes"
    "getCString"
    "getLineStart"
    "getParagraphStart"
    "hasPrefix"
    "hasSuffix"
    "hash"
    "index"
    "inferringMoves"
    "initialize"
    "initializeMemory"
    "insert"
    "intersection"
    "inverse"
    "isASCII"
    "isContinuation"
    "isDisjoint"
    "isEqual"
    "isLeadSurrogate"
    "isLess"
    "isLessThanOrEqualTo"
    "isMultiple"
    "isStrictSubset"
    "isStrictSuperset"
    "isSubset"
    "isSuperset"
    "isSurrogate"
    "isTotallyOrdered"
    "isTrailSurrogate"
    "isUniqueReference"
    "joined"
    "last"
    "lastIndex"
    "leadSurrogate"
    "lengthOfBytes"
    "lexicographicallyPrecedes"
    "lineRange"
    "linguisticTags"
    "load"
    "localizedCaseInsensitiveCompare"
    "localizedCaseInsensitiveContains"
    "localizedCompare"
    "localizedName"
    "localizedStandardCompare"
    "localizedStandardContains"
    "localizedStandardRange"
    "localizedStringWithFormat"
    "lowercased"
    "makeContiguousUTF8"
    "makeIterator"
    "map"
    "mapError"
    "mapValues"
    "max"
    "maximum"
    "maximumLengthOfBytes"
    "maximumMagnitude"
    "merge"
    "merging"
    "min"
    "minimum"
    "minimumMagnitude"
    "move"
    "moveAssign"
    "moveInitialize"
    "moveInitializeMemory"
    "multipliedFullWidth"
    "multipliedReportingOverflow"
    "negate"
    "nestedContainer"
    "nestedUnkeyedContainer"
    "next"
    "offset"
    "overlaps"
    "padding"
    "paragraphRange"
    "parseScalar"
    "partition"
    "passRetained"
    "passUnretained"
    "popFirst"
    "popLast"
    "prefix"
    "propertyList"
    "propertyListFromStringsFileFormat"
    "quotientAndRemainder"
    "random"
    "randomElement"
    "range"
    "rangeOfCharacter"
    "rangeOfComposedCharacterSequence"
    "rangeOfComposedCharacterSequences"
    "receive"
    "reduce"
    "relative"
    "release"
    "remainder"
    "remainderReportingOverflow"
    "remove"
    "removeAll"
    "removeFirst"
    "removeLast"
    "removeSubrange"
    "removeValue"
    "replace"
    "replaceSubrange"
    "replacing"
    "replacingCharacters"
    "replacingOccurrences"
    "reserveCapacity"
    "retain"
    "reverse"
    "reversed"
    "round"
    "rounded"
    "samePosition"
    "scale"
    "sequence"
    "shuffle"
    "shuffled"
    "signum"
    "singleValueContainer"
    "size"
    "sort"
    "sorted"
    "split"
    "squareRoot"
    "starts"
    "storeBytes"
    "stride"
    "substring"
    "subtract"
    "subtracting"
    "subtractingReportingOverflow"
    "suffix"
    "sum"
    "superDecoder"
    "superEncoder"
    "swapAt"
    "symmetricDifference"
    "takeRetainedValue"
    "takeUnretainedValue"
    "toOpaque"
    "toggle"
    "trailSurrogate"
    "transcode"
    "transcodedLength"
    "trimmingCharacters"
    "truncatingRemainder"
    "union"
    "unkeyedContainer"
    "unsafeSequence"
    "update"
    "updateValue"
    "uppercased"
    "utf16Offset"
    "width"
    "withCString"
    "withContiguousMutableStorageIfAvailable"
    "withContiguousStorageIfAvailable"
    "withMemoryRebound"
    "withUTF8"
    "withUTF8Buffer"
    "withUnsafeBufferPointer"
    "withUnsafeBytes"
    "withUnsafeMutableBufferPointer"
    "withUnsafeMutableBytes"
    "withUnsafeMutablePointerToElements"
    "withUnsafeMutablePointerToHeader"
    "withUnsafeMutablePointers"
    "wrappedSum"
    "write")
  "Built-in methods.")

(defconst swift-mode:standard-properties
  '("above"
    "aboveLeft"
    "aboveRight"
    "age"
    "alignment"
    "allCases"
    "allKeys"
    "argc"
    "arguments"
    "ascii"
    "asciiValue"
    "attachedAbove"
    "attachedAboveRight"
    "attachedBelow"
    "attachedBelowLeft"
    "availableStringEncodings"
    "base"
    "baseAddress"
    "below"
    "belowLeft"
    "belowRight"
    "bigEndian"
    "binade"
    "bitPattern"
    "bitWidth"
    "body"
    "buffer"
    "byteSwapped"
    "canonicalCombiningClass"
    "capacity"
    "capitalized"
    "changesWhenCaseFolded"
    "changesWhenCaseMapped"
    "changesWhenLowercased"
    "changesWhenNFKCCaseFolded"
    "changesWhenTitlecased"
    "changesWhenUppercased"
    "children"
    "codingPath"
    "count"
    "currentIndex"
    "customMirror"
    "customPlaygroundQuickLook"
    "dataValue"
    "dataValueType"
    "debugDescription"
    "decomposedStringWithCanonicalMapping"
    "decomposedStringWithCompatibilityMapping"
    "defaultCStringEncoding"
    "description"
    "displayStyle"
    "doubleAbove"
    "doubleBelow"
    "elements"
    "encodedOffset"
    "encodedReplacementCharacter"
    "endIndex"
    "evenHalf"
    "exponent"
    "exponentBitCount"
    "exponentBitPattern"
    "fastestEncoding"
    "first"
    "floatingPointClass"
    "generalCategory"
    "greatestFiniteMagnitude"
    "hasPointerRepresentation"
    "hash"
    "hashValue"
    "header"
    "hexDigitValue"
    "highHalf"
    "identifierValue"
    "indices"
    "infinity"
    "insertions"
    "intValue"
    "iotaSubscript"
    "isASCII"
    "isASCIIHexDigit"
    "isAlphabetic"
    "isAtEnd"
    "isBidiControl"
    "isBidiMirrored"
    "isCanonical"
    "isCaseIgnorable"
    "isCased"
    "isContiguousUTF8"
    "isCurrencySymbol"
    "isDash"
    "isDefaultIgnorableCodePoint"
    "isDeprecated"
    "isDiacritic"
    "isEmoji"
    "isEmojiModifier"
    "isEmojiModifierBase"
    "isEmojiPresentation"
    "isEmpty"
    "isExtender"
    "isFinite"
    "isFullCompositionExclusion"
    "isGraphemeBase"
    "isGraphemeExtend"
    "isHexDigit"
    "isIDContinue"
    "isIDSBinaryOperator"
    "isIDSTrinaryOperator"
    "isIDStart"
    "isIdeographic"
    "isInfinite"
    "isJoinControl"
    "isLetter"
    "isLogicalOrderException"
    "isLowercase"
    "isMath"
    "isMathSymbol"
    "isNaN"
    "isNewline"
    "isNoncharacterCodePoint"
    "isNormal"
    "isNumber"
    "isPatternSyntax"
    "isPatternWhitespace"
    "isPunctuation"
    "isQuotationMark"
    "isRadical"
    "isSentenceTerminal"
    "isSignalingNaN"
    "isSigned"
    "isSoftDotted"
    "isSubnormal"
    "isSymbol"
    "isTerminalPunctuation"
    "isUnifiedIdeograph"
    "isUppercase"
    "isVariationSelector"
    "isWhitespace"
    "isWholeNumber"
    "isXIDContinue"
    "isXIDStart"
    "isZero"
    "iso2022JP"
    "isoLatin1"
    "isoLatin2"
    "japaneseEUC"
    "kanaVoicing"
    "keys"
    "last"
    "lazy"
    "leadingZeroBitCount"
    "leastNonzeroMagnitude"
    "leastNormalMagnitude"
    "left"
    "littleEndian"
    "localizedCapitalized"
    "localizedDescription"
    "localizedLowercase"
    "localizedUppercase"
    "lowHalf"
    "lowerBound"
    "lowercaseMapping"
    "macOSRoman"
    "magnitude"
    "magnitudeSquared"
    "max"
    "min"
    "name"
    "nameAlias"
    "nan"
    "nextDown"
    "nextUp"
    "nextstep"
    "nonLossyASCII"
    "nonzeroBitCount"
    "notReordered"
    "nukta"
    "numericType"
    "numericValue"
    "oddHalf"
    "one"
    "output"
    "overlay"
    "pi"
    "playgroundDescription"
    "pointee"
    "precomposedStringWithCanonicalMapping"
    "precomposedStringWithCompatibilityMapping"
    "properties"
    "publisher"
    "radix"
    "rawValue"
    "regions"
    "removals"
    "removingPercentEncoding"
    "repeatedValue"
    "result"
    "right"
    "rootType"
    "scalarCount"
    "shiftJIS"
    "sign"
    "signalingNaN"
    "significand"
    "significandBitCount"
    "significandBitPattern"
    "significandWidth"
    "size"
    "smallestEncoding"
    "startIndex"
    "stride"
    "stringValue"
    "subjectType"
    "superclassMirror"
    "symbol"
    "titlecaseMapping"
    "trailingZeroBitCount"
    "ulp"
    "ulpOfOne"
    "underestimatedCount"
    "underlyingError"
    "unicode"
    "unicodeScalar"
    "unicodeScalars"
    "unsafeArgv"
    "unsafelyUnwrapped"
    "upperBound"
    "uppercaseMapping"
    "userInfo"
    "utf16"
    "utf16BigEndian"
    "utf16LittleEndian"
    "utf32"
    "utf32BigEndian"
    "utf32LittleEndian"
    "utf8"
    "utf8CString"
    "utf8CodeUnitCount"
    "utf8Start"
    "value"
    "valueType"
    "values"
    "virama"
    "w"
    "wholeNumberValue"
    "windowsCP1250"
    "windowsCP1251"
    "windowsCP1252"
    "windowsCP1253"
    "windowsCP1254"
    "words"
    "x"
    "y"
    "z"
    "zero")
  "Built-in properties.")

(defconst swift-mode:standard-functions
  '("abs"
    "assert"
    "assertionFailure"
    "debugPrint"
    "dump"
    "fatalError"
    "getVaList"
    "isKnownUniquelyReferenced"
    "max"
    "min"
    "numericCast"
    "precondition"
    "preconditionFailure"
    "print"
    "readLine"
    "repeatElement"
    "sequence"
    "stride"
    "swap"
    "transcode"
    "type"
    "unsafeBitCast"
    "unsafeDowncast"
    "withExtendedLifetime"
    "withUnsafeBytes"
    "withUnsafeMutableBytes"
    "withUnsafeMutablePointer"
    "withUnsafePointer"
    "withVaList"
    "withoutActuallyEscaping"
    "zip")
  "Built-in functions.")

(defconst swift-mode:standard-constants
  '()
  "Built-in constants.")

(provide 'swift-mode-standard-types)

;;; swift-mode-standard-types.el ends here
