# Contributing to cowsay

## Code of conduct

I have not selected a code of conduct yet, but please behave as though one were in place. Consider the [Contributor Covenant](http://contributor-covenant.org) and [Mac Homebrew's Code of Conduct](https://github.com/Homebrew/.github/blob/HEAD/CODE_OF_CONDUCT.md) to be examples.

## Contributions

Cowsay is a small project and is managed conservatively. Bug reports are welcome and will be acted on. Major unsolicited contributions are likely to be rejected.

New cows are welcome!

### Bug reports

Bug reports, no matter how small, are welcome. Please submit them as Issues on [cowsay's GitHub issue tracker](https://github.com/cowsay-org/cowsay/issues).

Documentation and usability issues count as bugs.

### Pull requests

Please don't submit Pull Requests for features or nontrivial bug fixes without posting a request as an Issue first. Major new features that aren't on the project roadmap already probably won't be accepted. This project is an exercise in process and deployment, not functionality, so new features are not a priority.

If you would like to see a new feature in cowsay, whether you wish to work on it or not, please submit the feature request as an [issue](https://github.com/cowsay-org/cowsay/issues) first. This will save wasted work on PRs that won't be accepted.

Pull requests for minor fixes (to code or documentation) are welcome.

Pull requests for new cows are fine.

### Contributing a new cow

New cows can be contributed by [submitting a pull request](https://github.com/cowsay-org/cowsay/pulls) on the cowsay repo on GitHub.

Feel free to add yourself to the `CONTRIBUTORS.md` file as part of the code changes in that pull request. And if you want to save me some admin work, add a "`- Add "<cowname>" cow`" entry to the `CHANGELOG.md`, file in the "Changes" section for the relevant "(unreleased)" cowsay version near the top of the file.

We're not accepting any new offensive cows. If you're not sure whether your cow would be considered offensive, ask in a PR or bug report, or by emailing the maintainer.

### Contribution licensing

We ask that all new contributions be dual licensed under "GPL 1.0 or later or Artistic License 1.0" terms, for maximum compatibility with the licensing of the rest of the Cowsay code.

## Contact a maintainer

If you have any questions about Cowsay contribution that aren't answered here or in the other doco in this repo, you can contact the maintainer Andrew via GitHub or by emailing <floss@apjanke.net>.

## "Upstream" contributions and the original cowsay project

Please do not send any bug reports or pull requests to [the original cowsay project](https://github.com/tnalpgge/rank-amateur-cowsay). The original author has moved on and is not interested in maintaining cowsay any further. That project is no longer maintained. This cowsay-org project does not upstream its changes to the original project.
