/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.GlobalOptimizer;
import adobe.abc.Namespace;
import adobe.abc.Nsset;
import java.util.ArrayList;

public class Name
implements Comparable<Name> {
    public static final Namespace PUBLIC = new Namespace("");
    public static final Namespace PKG_PUBLIC = new Namespace(22, "");
    public static final Namespace AS3 = new Namespace("http://adobe.com/AS3/2006/builtin");
    final int kind;
    final Nsset nsset;
    final String name;
    final String type_param;

    Name(int kind) {
        this(kind, GlobalOptimizer.uniqueNs(), GlobalOptimizer.unique());
    }

    Name(Namespace ns, String name) {
        this(7, ns, name);
    }

    public Name(int kind, Namespace ns, String name) {
        this(kind, name, new Nsset(new Namespace[]{ns}), null);
    }

    Name(int kind, String name, Nsset nsset) {
        this(kind, name, nsset, null);
    }

    Name(int kind, String name, Nsset nsset, String type_param_name) {
        assert (nsset != null);
        this.kind = kind;
        this.nsset = nsset;
        this.name = name;
        this.type_param = type_param_name;
    }

    public Name(String name) {
        this(7, PUBLIC, name);
    }

    public Namespace nsset(int i) {
        return this.nsset.nsset[i];
    }

    public String toString() {
        return this.name;
    }

    public String format() {
        if (this.nsset.length == 1) {
            return this.nsset(0) + "::" + this.name;
        }
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        for (Namespace n : this.nsset) {
            list.add(n);
        }
        return list + "::" + this.name;
    }

    public Name append(String s) {
        return new Name(this.kind, this.name + s, this.nsset);
    }

    public Name prepend(String s) {
        return new Name(this.kind, s + this.name, this.nsset);
    }

    private int hc(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public int hashCode() {
        return this.kind ^ this.hc(this.nsset) ^ this.hc(this.name);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Name)) {
            return false;
        }
        Name o = (Name)other;
        return this.kind == o.kind && this.name.equals(o.name) && this.nsset.equals(o.nsset);
    }

    @Override
    public int compareTo(Name other) {
        int d = this.kind - other.kind;
        if (d != 0) {
            return d;
        }
        d = this.name.compareTo(other.name);
        if (d != 0) {
            return d;
        }
        return this.nsset.compareTo(other.nsset);
    }

    public int attr() {
        return this.kind == 14 || this.kind == 13 || this.kind == 16 || this.kind == 18 || this.kind == 28 ? 1 : 0;
    }

    public boolean isQname() {
        return this.kind == 7 || this.kind == 13 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
    }

    public int match(Name b) {
        block7: {
            block6: {
                if (this == b) {
                    return 0;
                }
                int d = this.attr() - b.attr();
                if (d != 0) {
                    return d;
                }
                d = this.name.compareTo(b.name);
                if (d != 0) {
                    return d;
                }
                if (this.isQname() && b.isQname()) {
                    return this.nsset(0).compareTo(b.nsset(0));
                }
                if (!this.isQname() || b.isQname()) break block6;
                for (Namespace ns : b.nsset) {
                    if (!ns.equals(this.nsset(0))) continue;
                    return 0;
                }
                break block7;
            }
            if (!b.isQname() || this.isQname()) break block7;
            for (Namespace ns : this.nsset) {
                if (!ns.equals(b.nsset(0))) continue;
                return 0;
            }
        }
        return this.nsset.compareTo(b.nsset);
    }
}

