//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentchangekind?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDocumentChangeKind(pub NSInteger);
impl UIDocumentChangeKind {
    #[doc(alias = "UIDocumentChangeDone")]
    pub const Done: Self = Self(0);
    #[doc(alias = "UIDocumentChangeUndone")]
    pub const Undone: Self = Self(1);
    #[doc(alias = "UIDocumentChangeRedone")]
    pub const Redone: Self = Self(2);
    #[doc(alias = "UIDocumentChangeCleared")]
    pub const Cleared: Self = Self(3);
}

unsafe impl Encode for UIDocumentChangeKind {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIDocumentChangeKind {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentsaveoperation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDocumentSaveOperation(pub NSInteger);
impl UIDocumentSaveOperation {
    #[doc(alias = "UIDocumentSaveForCreating")]
    pub const ForCreating: Self = Self(0);
    #[doc(alias = "UIDocumentSaveForOverwriting")]
    pub const ForOverwriting: Self = Self(1);
}

unsafe impl Encode for UIDocumentSaveOperation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIDocumentSaveOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentstate?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDocumentState(pub NSUInteger);
bitflags::bitflags! {
    impl UIDocumentState: NSUInteger {
        #[doc(alias = "UIDocumentStateNormal")]
        const Normal = 0;
        #[doc(alias = "UIDocumentStateClosed")]
        const Closed = 1<<0;
        #[doc(alias = "UIDocumentStateInConflict")]
        const InConflict = 1<<1;
        #[doc(alias = "UIDocumentStateSavingError")]
        const SavingError = 1<<2;
        #[doc(alias = "UIDocumentStateEditingDisabled")]
        const EditingDisabled = 1<<3;
        #[doc(alias = "UIDocumentStateProgressAvailable")]
        const ProgressAvailable = 1<<4;
    }
}

unsafe impl Encode for UIDocumentState {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIDocumentState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentcreationintent?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type UIDocumentCreationIntent = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentcreationintentdefault?language=objc)
    pub static UIDocumentCreationIntentDefault: &'static UIDocumentCreationIntent;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentstatechangednotification?language=objc)
    pub static UIDocumentStateChangedNotification: &'static NSNotificationName;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocument?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIDocument;
);

extern_conformance!(
    unsafe impl NSFilePresenter for UIDocument {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIDocument {}
);

extern_conformance!(
    unsafe impl NSProgressReporting for UIDocument {}
);

impl UIDocument {
    extern_methods!(
        #[unsafe(method(initWithFileURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFileURL(this: Allocated<Self>, url: &NSURL) -> Retained<Self>;

        #[unsafe(method(fileURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileURL(&self) -> Retained<NSURL>;

        #[unsafe(method(localizedName))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedName(&self) -> Retained<NSString>;

        #[unsafe(method(fileType))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileType(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(fileModificationDate))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileModificationDate(&self) -> Option<Retained<NSDate>>;

        /// Setter for [`fileModificationDate`][Self::fileModificationDate].
        #[unsafe(method(setFileModificationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFileModificationDate(&self, file_modification_date: Option<&NSDate>);

        #[unsafe(method(documentState))]
        #[unsafe(method_family = none)]
        pub unsafe fn documentState(&self) -> UIDocumentState;

        #[unsafe(method(progress))]
        #[unsafe(method_family = none)]
        pub unsafe fn progress(&self) -> Option<Retained<NSProgress>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(openWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(closeWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn closeWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[unsafe(method(loadFromContents:ofType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadFromContents_ofType_error(
            &self,
            contents: &AnyObject,
            type_name: Option<&NSString>,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(contentsForType:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentsForType_error(
            &self,
            type_name: &NSString,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[unsafe(method(disableEditing))]
        #[unsafe(method_family = none)]
        pub unsafe fn disableEditing(&self);

        #[unsafe(method(enableEditing))]
        #[unsafe(method_family = none)]
        pub unsafe fn enableEditing(&self);

        #[unsafe(method(undoManager))]
        #[unsafe(method_family = none)]
        pub unsafe fn undoManager(&self) -> Option<Retained<NSUndoManager>>;

        /// Setter for [`undoManager`][Self::undoManager].
        #[unsafe(method(setUndoManager:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUndoManager(&self, undo_manager: Option<&NSUndoManager>);

        #[unsafe(method(hasUnsavedChanges))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasUnsavedChanges(&self) -> bool;

        #[unsafe(method(updateChangeCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateChangeCount(&self, change: UIDocumentChangeKind);

        #[unsafe(method(changeCountTokenForSaveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeCountTokenForSaveOperation(
            &self,
            save_operation: UIDocumentSaveOperation,
        ) -> Retained<AnyObject>;

        #[unsafe(method(updateChangeCountWithToken:forSaveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateChangeCountWithToken_forSaveOperation(
            &self,
            change_count_token: &AnyObject,
            save_operation: UIDocumentSaveOperation,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(saveToURL:forSaveOperation:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveToURL_forSaveOperation_completionHandler(
            &self,
            url: &NSURL,
            save_operation: UIDocumentSaveOperation,
            completion_handler: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(autosaveWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn autosaveWithCompletionHandler(
            &self,
            completion_handler: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[unsafe(method(savingFileType))]
        #[unsafe(method_family = none)]
        pub unsafe fn savingFileType(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(fileNameExtensionForType:saveOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileNameExtensionForType_saveOperation(
            &self,
            type_name: Option<&NSString>,
            save_operation: UIDocumentSaveOperation,
        ) -> Retained<NSString>;

        #[unsafe(method(writeContents:andAttributes:safelyToURL:forSaveOperation:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeContents_andAttributes_safelyToURL_forSaveOperation_error(
            &self,
            contents: &AnyObject,
            additional_file_attributes: Option<&NSDictionary>,
            url: &NSURL,
            save_operation: UIDocumentSaveOperation,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(writeContents:toURL:forSaveOperation:originalContentsURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeContents_toURL_forSaveOperation_originalContentsURL_error(
            &self,
            contents: &AnyObject,
            url: &NSURL,
            save_operation: UIDocumentSaveOperation,
            original_contents_url: Option<&NSURL>,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(fileAttributesToWriteToURL:forSaveOperation:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileAttributesToWriteToURL_forSaveOperation_error(
            &self,
            url: &NSURL,
            save_operation: UIDocumentSaveOperation,
        ) -> Result<Retained<NSDictionary>, Retained<NSError>>;

        #[unsafe(method(readFromURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn readFromURL_error(&self, url: &NSURL) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(performAsynchronousFileAccessUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performAsynchronousFileAccessUsingBlock(
            &self,
            block: &block2::DynBlock<dyn Fn()>,
        );

        #[unsafe(method(handleError:userInteractionPermitted:))]
        #[unsafe(method_family = none)]
        pub unsafe fn handleError_userInteractionPermitted(
            &self,
            error: &NSError,
            user_interaction_permitted: bool,
        );

        #[unsafe(method(finishedHandlingError:recovered:))]
        #[unsafe(method_family = none)]
        pub unsafe fn finishedHandlingError_recovered(&self, error: &NSError, recovered: bool);

        #[unsafe(method(userInteractionNoLongerPermittedForError:))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInteractionNoLongerPermittedForError(&self, error: &NSError);

        #[cfg(feature = "block2")]
        #[unsafe(method(revertToContentsOfURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn revertToContentsOfURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UIDocument {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

impl UIDocument {
    extern_methods!();
}

#[cfg(feature = "UINavigationItem")]
extern_conformance!(
    unsafe impl UINavigationItemRenameDelegate for UIDocument {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nsuseractivitydocumenturlkey?language=objc)
    pub static NSUserActivityDocumentURLKey: &'static NSString;
}

/// ActivityContinuation.
impl UIDocument {
    extern_methods!(
        #[unsafe(method(userActivity))]
        #[unsafe(method_family = none)]
        pub unsafe fn userActivity(&self) -> Option<Retained<NSUserActivity>>;

        /// Setter for [`userActivity`][Self::userActivity].
        #[unsafe(method(setUserActivity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserActivity(&self, user_activity: Option<&NSUserActivity>);

        #[unsafe(method(updateUserActivityState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateUserActivityState(&self, user_activity: &NSUserActivity);

        #[unsafe(method(restoreUserActivityState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoreUserActivityState(&self, user_activity: &NSUserActivity);
    );
}

#[cfg(feature = "UIUserActivity")]
extern_conformance!(
    unsafe impl UIUserActivityRestoring for UIDocument {}
);
